/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Thu Dec 10 07:06:14 EST 2020 */

#include "rdft/codelet-rdft.h"

#if defined(ARCH_PREFERS_FMA) || defined(ISA_EXTENSION_PREFERS_FMA)

/* Generated by: ../../../genfft/gen_hc2cdft.native -fma -compact -variables 4 -pipeline-latency 4 -n 4 -dit -name hc2cfdft_4 -include rdft/scalar/hc2cf.h */

/*
 * This function contains 30 FP additions, 20 FP multiplications,
 * (or, 24 additions, 14 multiplications, 6 fused multiply/add),
 * 31 stack variables, 1 constants, and 16 memory accesses
 */
#include "rdft/scalar/hc2cf.h"

static void hc2cfdft_4(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 6); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 6, MAKE_VOLATILE_STRIDE(16, rs)) {
	       E Td, Tl, Tu, Tk, TC, Tf, Tj, T4, Tr, T9, To, T5, Tv, Tp, TA;
	       E Tb, Tc;
	       Tb = Ip[0];
	       Tc = Im[0];
	       Td = Tb - Tc;
	       Tl = Tb + Tc;
	       {
		    E Tg, Th, Ti, T1, Tn;
		    Tg = Rm[0];
		    Th = Rp[0];
		    Ti = Tg - Th;
		    Tu = Th + Tg;
		    Tk = W[1];
		    TC = Tk * Ti;
		    Tf = W[0];
		    Tj = Tf * Ti;
		    {
			 E T2, T3, T7, T8;
			 T2 = Ip[WS(rs, 1)];
			 T3 = Im[WS(rs, 1)];
			 T4 = T2 - T3;
			 Tr = T2 + T3;
			 T7 = Rp[WS(rs, 1)];
			 T8 = Rm[WS(rs, 1)];
			 T9 = T7 + T8;
			 To = T7 - T8;
		    }
		    T1 = W[2];
		    T5 = T1 * T4;
		    Tv = T1 * T9;
		    Tn = W[4];
		    Tp = Tn * To;
		    TA = Tn * Tr;
	       }
	       {
		    E Tm, TD, Ta, Tw, Ts, TB, T6, Tq;
		    Tm = FNMS(Tk, Tl, Tj);
		    TD = FMA(Tf, Tl, TC);
		    T6 = W[3];
		    Ta = FNMS(T6, T9, T5);
		    Tw = FMA(T6, T4, Tv);
		    Tq = W[5];
		    Ts = FMA(Tq, Tr, Tp);
		    TB = FNMS(Tq, To, TA);
		    {
			 E Te, Tt, TF, TG;
			 Te = Ta + Td;
			 Tt = Tm - Ts;
			 Ip[0] = KP500000000 * (Te + Tt);
			 Im[WS(rs, 1)] = KP500000000 * (Tt - Te);
			 TF = Tu + Tw;
			 TG = TB + TD;
			 Rm[WS(rs, 1)] = KP500000000 * (TF - TG);
			 Rp[0] = KP500000000 * (TF + TG);
		    }
		    {
			 E Tx, Ty, Tz, TE;
			 Tx = Tu - Tw;
			 Ty = Ts + Tm;
			 Rm[0] = KP500000000 * (Tx - Ty);
			 Rp[WS(rs, 1)] = KP500000000 * (Tx + Ty);
			 Tz = Td - Ta;
			 TE = TB - TD;
			 Ip[WS(rs, 1)] = KP500000000 * (Tz + TE);
			 Im[0] = KP500000000 * (TE - Tz);
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     { TW_FULL, 1, 4 },
     { TW_NEXT, 1, 0 }
};

static const hc2c_desc desc = { 4, "hc2cfdft_4", twinstr, &GENUS, { 24, 14, 6, 0 } };

void X(codelet_hc2cfdft_4) (planner *p) {
     X(khc2c_register) (p, hc2cfdft_4, &desc, HC2C_VIA_DFT);
}
#else

/* Generated by: ../../../genfft/gen_hc2cdft.native -compact -variables 4 -pipeline-latency 4 -n 4 -dit -name hc2cfdft_4 -include rdft/scalar/hc2cf.h */

/*
 * This function contains 30 FP additions, 20 FP multiplications,
 * (or, 24 additions, 14 multiplications, 6 fused multiply/add),
 * 18 stack variables, 1 constants, and 16 memory accesses
 */
#include "rdft/scalar/hc2cf.h"

static void hc2cfdft_4(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 6); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 6, MAKE_VOLATILE_STRIDE(16, rs)) {
	       E Tc, Tr, Tk, Tx, T9, Ts, Tp, Tw;
	       {
		    E Ta, Tb, Tj, Tf, Tg, Th, Te, Ti;
		    Ta = Ip[0];
		    Tb = Im[0];
		    Tj = Ta + Tb;
		    Tf = Rm[0];
		    Tg = Rp[0];
		    Th = Tf - Tg;
		    Tc = Ta - Tb;
		    Tr = Tg + Tf;
		    Te = W[0];
		    Ti = W[1];
		    Tk = FNMS(Ti, Tj, Te * Th);
		    Tx = FMA(Ti, Th, Te * Tj);
	       }
	       {
		    E T4, To, T8, Tm;
		    {
			 E T2, T3, T6, T7;
			 T2 = Ip[WS(rs, 1)];
			 T3 = Im[WS(rs, 1)];
			 T4 = T2 - T3;
			 To = T2 + T3;
			 T6 = Rp[WS(rs, 1)];
			 T7 = Rm[WS(rs, 1)];
			 T8 = T6 + T7;
			 Tm = T6 - T7;
		    }
		    {
			 E T1, T5, Tl, Tn;
			 T1 = W[2];
			 T5 = W[3];
			 T9 = FNMS(T5, T8, T1 * T4);
			 Ts = FMA(T1, T8, T5 * T4);
			 Tl = W[4];
			 Tn = W[5];
			 Tp = FMA(Tl, Tm, Tn * To);
			 Tw = FNMS(Tn, Tm, Tl * To);
		    }
	       }
	       {
		    E Td, Tq, Tz, TA;
		    Td = T9 + Tc;
		    Tq = Tk - Tp;
		    Ip[0] = KP500000000 * (Td + Tq);
		    Im[WS(rs, 1)] = KP500000000 * (Tq - Td);
		    Tz = Tr + Ts;
		    TA = Tw + Tx;
		    Rm[WS(rs, 1)] = KP500000000 * (Tz - TA);
		    Rp[0] = KP500000000 * (Tz + TA);
	       }
	       {
		    E Tt, Tu, Tv, Ty;
		    Tt = Tr - Ts;
		    Tu = Tp + Tk;
		    Rm[0] = KP500000000 * (Tt - Tu);
		    Rp[WS(rs, 1)] = KP500000000 * (Tt + Tu);
		    Tv = Tc - T9;
		    Ty = Tw - Tx;
		    Ip[WS(rs, 1)] = KP500000000 * (Tv + Ty);
		    Im[0] = KP500000000 * (Ty - Tv);
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     { TW_FULL, 1, 4 },
     { TW_NEXT, 1, 0 }
};

static const hc2c_desc desc = { 4, "hc2cfdft_4", twinstr, &GENUS, { 24, 14, 6, 0 } };

void X(codelet_hc2cfdft_4) (planner *p) {
     X(khc2c_register) (p, hc2cfdft_4, &desc, HC2C_VIA_DFT);
}
#endif
