/* This file has been automatically generated by builder part of the ferite distribution */
/* file: unix_Network_Unix.c */
/* namespace: Unix */

#include <ferite.h>       /* we need this without a doubt */
#include "unix_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( ferite_unix_Network_Unix_connect_s )
{
   FeriteString *path = NULL;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &path );

   { /* Main function body. */
#line 126 "unixsocket.fec"

 
 FeriteVariable *obj, **args, *fv;
 FeriteClass *cls;
 struct sockaddr *sa;
 struct sockaddr_un un;
 int sock;
 
 if((sock = socket(PF_LOCAL, SOCK_STREAM, 0)) == -1)
 FE_RETURN_NULL_OBJECT;
 
 un.sun_family = AF_UNIX;
 if(path->length + 1 > sizeof(un.sun_path))
 {
 ferite_set_error(script, 0, "Path too long");
 FE_RETURN_NULL_OBJECT;
 }
 memcpy(un.sun_path, path->data, path->length + 1);
 sa = (struct sockaddr*)&un;
 
 if(connect(sock, sa, sizeof(struct sockaddr_un)) == -1)
 {
 ferite_set_error(script, errno, "%s", strerror(errno));
 close(sock);
 FE_RETURN_NULL_OBJECT;
 }
 
 if((cls = ferite_find_class(script, script->mainns, "Network.Unix.Stream")))
 {
 args = ferite_create_parameter_list(script,4);
 args = ferite_add_to_parameter_list(args, fe_new_lng_static("socket", sock));
 MARK_VARIABLE_AS_DISPOSABLE(args[0]); /* automatically clear up */
 obj = ferite_new_object(script, cls, args);
 ferite_delete_parameter_list(script, args);
 fv = ferite_create_string_variable(script, "path", path, FE_STATIC);
 ferite_object_set_var(script, VAO(obj), "path", fv);
 FE_RETURN_VAR(obj);
 }
 FE_RETURN_NULL_OBJECT;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_unix_Network_Unix_bind_s )
{
   FeriteString *path = NULL;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &path );

   { /* Main function body. */
#line 180 "unixsocket.fec"

 
 FeriteVariable *obj, **args, *fv;
 FeriteClass *cls;
 struct sockaddr *sa;
 struct sockaddr_un un;
 int sock;
 
 if((sock = socket(PF_LOCAL, SOCK_STREAM, 0)) == -1)
 FE_RETURN_NULL_OBJECT;
 
 un.sun_family = AF_UNIX;
 if(path->length + 1 > sizeof(un.sun_path))
 {
 ferite_set_error(script, 0, "Path too long");
 FE_RETURN_NULL_OBJECT;
 }
 memcpy(un.sun_path, path->data, path->length + 1);
 sa = (struct sockaddr*)&un;
 
 if(bind(sock, sa, sizeof(struct sockaddr_un)))
 {
 ferite_set_error(script, errno, "%s", strerror(errno));
 close(sock);
 FE_RETURN_NULL_OBJECT;
 }
 if(listen(sock, 10))
 {
 ferite_set_error(script, errno, "%s", strerror(errno));
 close(sock);
 FE_RETURN_NULL_OBJECT;
 }
 if((cls = ferite_find_class(script, script->mainns, "Network.Unix.Stream")))
 {
 args = ferite_create_parameter_list(script,4);
 args = ferite_add_to_parameter_list(args, fe_new_lng_static("socket", sock));
 obj = ferite_new_object(script, cls, args);
 ferite_delete_parameter_list(script, args);
 fv = ferite_create_string_variable(script, "path", path, FE_STATIC);
 ferite_object_set_var(script, VAO(obj), "path", fv);
 FE_RETURN_VAR(obj);
 }
 close(sock);
 FE_RETURN_NULL_OBJECT;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

