/* This file has been automatically generated by builder part of the ferite distribution */
/* file: sys_Sys.c */
/* namespace: Sys */

#include <ferite.h>       /* we need this without a doubt */
#include "sys_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( ferite_sys_Sys_usleep_n )
{
   double usecs = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &usecs );

   { /* Main function body. */
#line 257 "std.fec"

 
 usleep( (unsigned long)usecs );
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_getVersion_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 197 "std.fec"

 
 FeriteVariable *v;
 v = fe_new_str_static( "version", "ferite "VERSION, 0, FE_CHARSET_DEFAULT );
 FE_RETURN_VAR( v );
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_getBuildDate_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 209 "std.fec"

 
 FeriteVariable *v;
 v = fe_new_str_static( "builddate", __DATE__" "__TIME__, 0, FE_CHARSET_DEFAULT );
 FE_RETURN_VAR( v );
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_system_s )
{
   FeriteString *cms = NULL;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &cms );

   { /* Main function body. */
#line 222 "std.fec"

 
 int ret;
 ret = system( cms->data );
 if( ret == -1 )
 ferite_set_error( script, -1, "'system()' failed" );
#ifdef WIN32
	FE_RETURN_LONG( ret );
#else
 FE_RETURN_LONG( WEXITSTATUS(ret) );
#endif
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_timestamp_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 268 "std.fec"

 
 struct timeval the_time;
 double t = 0;

 gettimeofday(&the_time, NULL);
 t = (double)the_time.tv_sec + (((double)the_time.tv_usec)/1000000);

 FE_RETURN_DOUBLE( t );
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_scriptName_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 185 "std.fec"

 
 FeriteVariable *v;
 v = fe_new_str_static( "scriptname", script->filename, 0, FE_CHARSET_DEFAULT);
 FE_RETURN_VAR( v );
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_sleep_n )
{
   double secs = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &secs );

   { /* Main function body. */
#line 246 "std.fec"

 
 FE_RETURN_LONG(sleep((unsigned int)secs));
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_strerror_n )
{
   double what = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &what );

   { /* Main function body. */
#line 152 "std.fec"

 
 char buf[1024];
 FeriteVariable *var;
 int Error = (int)what;

 switch( Error )
 {
 case -1: sprintf(buf,"%d: Generic Error", Error); break;
 case 0: sprintf(buf,"%d: Success", Error); break;
 default: sprintf(buf,"%d: %s", Error, strerror(Error) );
 break;

 }
 var = fe_new_str_static( "System::strerror", buf, 0, FE_CHARSET_DEFAULT );
 FE_RETURN_VAR( var );
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_setlocale_ns )
{
   double category = 0.0;
   FeriteString *locale = NULL;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &category, &locale );

   { /* Main function body. */
#line 317 "std.fec"

	
		setlocale( (int)category, locale->data );
		FE_RETURN_VOID;
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_warning_s )
{
   FeriteString *message = NULL;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &message );

   { /* Main function body. */
#line 131 "std.fec"

 
 ferite_warning( script, "%.*s", message->length, message->data );
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_gc_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 121 "std.fec"

 
 ferite_check_gc( script );
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_sys_Sys_exit_n )
{
   double retval = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &retval );

   { /* Main function body. */
#line 175 "std.fec"

 
 ferite_stop_execution( script, (int)retval );
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

