/* This file has been automatically generated by builder part of the ferite distribution */
/* file: posix_Posix.c */
/* namespace: Posix */

#include <ferite.h>       /* we need this without a doubt */
#include "posix_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( ferite_posix_Posix_setgid_n )
{
   double gid = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &gid );

   { /* Main function body. */
#line 998 "posix.fec"

 
 if(setgid((gid_t)gid) == -1)
 {
 ferite_set_error( script, errno, "%s", strerror(errno) );
 FE_RETURN_FALSE;
 }
 else FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_lstat_s )
{
   FeriteString *filename = NULL;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &filename );

   { /* Main function body. */
#line 366 "posix.fec"

 
 struct stat *in;

 in = fmalloc( sizeof( struct stat ) );
 if( lstat( filename->data, in ) == -1 )
 {
 ferite_set_error( script, errno, "%s", strerror( errno ) );
 FE_RETURN_NULL_OBJECT;
 }
 FE_RETURN_VAR( system_call_stat( script, in ) );
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_geteuid_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 935 "posix.fec"

 
 FE_RETURN_LONG( geteuid() );
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_chown_snn )
{
   FeriteString *filename = NULL;
   double uid = 0.0;
   double gid = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 3, &filename, &uid, &gid );

   { /* Main function body. */
#line 287 "posix.fec"

 
 if(chown(filename->data, (uid_t)uid, (gid_t)gid) == -1)
 {
 ferite_set_error(script, errno, "%s", strerror(errno));
 FE_RETURN_FALSE;
 }
 else FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_umask_n )
{
   double mask = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &mask );

   { /* Main function body. */
#line 133 "posix.fec"

 
 FE_RETURN_LONG(umask((mode_t)mask));
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_fork_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 881 "posix.fec"

 
 pid_t pid;
 if( ( pid = fork() ) == -1 )
 ferite_set_error( script, errno, "%s", strerror(errno) );
 FE_RETURN_LONG( pid );
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_utime_s )
{
   FeriteString *filename = NULL;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &filename );

   { /* Main function body. */
#line 326 "posix.fec"

 
 if(utime(filename->data, NULL) == -1)
 {
 ferite_set_error(script, errno, "%s", strerror(errno));
 FE_RETURN_FALSE;
 }
 else FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_utime_snn )
{
   FeriteString *filename = NULL;
   double atime = 0.0;
   double mtime = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 3, &filename, &atime, &mtime );

   { /* Main function body. */
#line 312 "posix.fec"

 
 struct utimbuf ut;

 ut.actime = (time_t)atime;
 ut.modtime = (time_t)mtime;

 if(utime(filename->data, &ut) == -1)
 {
 ferite_set_error(script, errno, "%s", strerror(errno));
 FE_RETURN_FALSE;
 }
 else FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_softlink_ss )
{
   FeriteString *oldpath = NULL;
   FeriteString *newpath = NULL;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &oldpath, &newpath );

   { /* Main function body. */
#line 209 "posix.fec"

 

 if( symlink( oldpath->data, newpath->data ) == -1 )
 {
 ferite_set_error( script, errno, "%s", strerror( errno ) );
 FE_RETURN_FALSE;
 }
 FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_access_ss )
{
   FeriteString *pathname = NULL;
   FeriteString *modes = NULL;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &pathname, &modes );

   { /* Main function body. */
#line 91 "posix.fec"

 
 int i;
 int mode = 0;

 for(i = 0; i < modes->length; i++)
 {
 switch(modes->data[i])
 {
 case 'r':
 mode |= R_OK;
 break;
 case 'w':
 mode |= W_OK;
 break;
 case 'x':
 mode |= X_OK;
 break;
 case 'f':
 mode |= F_OK;
 break;
 }
 }

 if(access(pathname->data, mode) == -1)
 {
 ferite_set_error( script, errno, "%s", strerror(errno) );
 FE_RETURN_FALSE;
 }
 else FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_hardlink_ss )
{
   FeriteString *oldpath = NULL;
   FeriteString *newpath = NULL;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &oldpath, &newpath );

   { /* Main function body. */
#line 191 "posix.fec"

 
 if( link( oldpath->data, newpath->data ) == -1 )
 {
 ferite_set_error( script, errno, "%s", strerror(errno) );
 FE_RETURN_FALSE;
 }
 FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_openprocess_ss )
{
   FeriteString *cmd = NULL;
   FeriteString *modes = NULL;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &cmd, &modes );

   { /* Main function body. */
#line 171 "posix.fec"

 
 FILE *process = popen( cmd->data, modes->data );
 if( process == NULL || (int)process == -1 )
 {
 ferite_set_error( script, errno, "%s", strerror(errno) );
 FE_RETURN_NULL_OBJECT;
 }
 FE_RETURN_VAR( system_create_stream_object( script, "Posix.ProcessStream", process ) );
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_setPriority_nnn )
{
   double which = 0.0;
   double who = 0.0;
   double prio = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 3, &which, &who, &prio );

   { /* Main function body. */
#line 1335 "posix.fec"

 
#ifdef HAVE_SETPRIORITY
 int i;

 switch((int)which)
 {
 default:
 case 0:
 i = PRIO_PROCESS;
 break;
 case 1:
 i = PRIO_PGRP;
 break;
 case 2:
 i = PRIO_USER;
 break;
 }
 errno = 0;
 if(setpriority(i, (int)who, (int)prio) == -1)
 {
 ferite_set_error(script, errno, "%s", strerror(errno));
 FE_RETURN_FALSE;
 }
 else FE_RETURN_TRUE;
#else
 ferite_set_error(script, EINVAL, "setpriority() is not supported by "
 "this OS");
 FE_RETURN_FALSE;
#endif
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_chroot_s )
{
   FeriteString *path = NULL;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &path );

   { /* Main function body. */
#line 236 "posix.fec"

 
 if(chroot(path->data) == -1)
 {
 ferite_set_error(script, errno, "%s", strerror(errno));
 FE_RETURN_FALSE;
 }
 else FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_mkfifo_sn )
{
   FeriteString *filename = NULL;
   double mode = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &filename, &mode );

   { /* Main function body. */
#line 150 "posix.fec"

 
 if(mkfifo(filename->data, (mode_t)mode) == -1)
 {
 ferite_set_error(script, errno, "%s", strerror(errno));
 FE_RETURN_FALSE;
 }
 else FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_setsid_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 1164 "posix.fec"

 
 pid_t ret;
 if((ret = setsid()) == -1)
 ferite_set_error(script, errno, "%s", strerror(errno));
 FE_RETURN_LONG(ret);
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_getgid_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 969 "posix.fec"

 
 FE_RETURN_LONG( getgid() );
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_setuid_n )
{
   double uid = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &uid );

   { /* Main function body. */
#line 953 "posix.fec"

 
 if(setuid((uid_t)uid) == -1)
 {
 ferite_set_error( script, errno, "%s", strerror(errno) );
 FE_RETURN_FALSE;
 }
 else FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_exec_saa )
{
   FeriteString *filename = NULL;
   FeriteUnifiedArray *args = NULL;
   FeriteUnifiedArray *env = NULL;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 3, &filename, &args, &env );

   { /* Main function body. */
#line 1563 "posix.fec"

    
        int i;
        FeriteVariable *fv;
        char **cargv, **cenv;

        if(!(cargv = fcalloc(args->size + 1, sizeof(char *))))
          FE_RETURN_FALSE;
        
        if(!(cenv = fcalloc(env->size + 1, sizeof(char *))))
        {
            ffree(cargv);
            FE_RETURN_FALSE;
        }

        for(i = 0; i < args->size; i++)
        {
            fv = ferite_uarray_get_index(script, args, i);
            if(fv->type != F_VAR_STR)
            {
                ferite_set_error(script, 0, "argv[%d] not a string", i);
                goto execfailed;
            }
            if(!(cargv[i] = fstrdup(VAS(fv)->data))) goto execfailed;
        }

        for(i = 0; i < env->size; i++)
        {
            fv = ferite_uarray_get_index(script, env, i);
            if(fv->type != F_VAR_STR)
            {
                ferite_set_error(script, 0, "env[%d] not a string", i);
                goto execfailed;
            }
            if(fv->vname[0] == 0)
            {
                ferite_set_error(script, 0, "env[%d] doesn't have a key", i);
                goto execfailed;
            }
            if(!(cenv[i] = fmalloc(strlen(VAS(fv)->data) +
                                   strlen(fv->vname) + 2)))
            {
                goto execfailed;
            }
            sprintf(cenv[i], "%s=%s", fv->vname, VAS(fv)->data);
        }

        execve(filename->data, cargv, cenv);

	    /* If we get to here, execve() failed because it shouldn't return. */
        ferite_set_error(script, errno, "%s", strerror(errno));

        execfailed:
        for(i = 0; cargv[i]; i++) ffree(cargv[i]);
        ffree(cargv);
        for(i = 0; cenv[i]; i++) ffree(cenv[i]);
        ffree(cenv);
        FE_RETURN_FALSE;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_getppid_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 1148 "posix.fec"

 
 FE_RETURN_LONG(getppid());
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_getegid_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 980 "posix.fec"

 
 FE_RETURN_LONG( getegid() );
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_stat_s )
{
   FeriteString *filename = NULL;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &filename );

   { /* Main function body. */
#line 343 "posix.fec"

 
 struct stat *in;

 in = fmalloc( sizeof( struct stat ) );
 if( stat( filename->data, in ) == -1 )
 {
 ferite_set_error( script, errno, "%s", strerror( errno ) );
 FE_RETURN_NULL_OBJECT;
 }
 FE_RETURN_VAR( system_call_stat( script, in ) );
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_getpid_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 1137 "posix.fec"

 
 FE_RETURN_LONG(getpid());
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_waitpid_nn )
{
   double pid = 0.0;
   double nohang = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &pid, &nohang );

   { /* Main function body. */
#line 909 "posix.fec"

 
 int rpid = waitpid((pid_t) pid, NULL, (int)nohang ? WNOHANG : 0);
 if(rpid == -1) ferite_set_error(script, errno, "%s", strerror(errno));
 FE_RETURN_LONG(rpid);
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_resetSigAction_n )
{
   double sig = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &sig );

   { /* Main function body. */
#line 1232 "posix.fec"

 
 if(set_signal_action(script, (int)sig, SIG_DFL) == -1) FE_RETURN_FALSE;

 ferite_signal_unregister_handler(script, (int)sig);

 FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_getPriority_nn )
{
   double which = 0.0;
   double who = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &which, &who );

   { /* Main function body. */
#line 1285 "posix.fec"

 
#ifdef HAVE_GETPRIORITY
 int i;

 switch((int)which)
 {
 default:
 case 0:
 i = PRIO_PROCESS;
 break;
 case 1:
 i = PRIO_PGRP;
 break;
 case 2:
 i = PRIO_USER;
 break;
 }
 errno = 0;
 if((i = getpriority(i, (int)who)) == -1)
 ferite_set_error(script, errno, "%s", strerror(errno));
 FE_RETURN_LONG(i);
#else
 ferite_set_error(script, EINVAL, "getpriority() is not supported by "
 "this OS");
 FE_RETURN_LONG(-1);
#endif
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_ignoreSignal_n )
{
   double sig = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 1, &sig );

   { /* Main function body. */
#line 1252 "posix.fec"

 
 if(set_signal_action(script, (int)sig, SIG_IGN) == -1) FE_RETURN_FALSE;

 ferite_signal_unregister_handler(script, (int)sig);

 FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_getuid_ )
{
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   { /* Main function body. */
#line 924 "posix.fec"

 
 FE_RETURN_LONG( getuid() );
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_select_aaan )
{
   FeriteUnifiedArray *read = NULL;
   FeriteUnifiedArray *write = NULL;
   FeriteUnifiedArray *except = NULL;
   double timeout = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 4, &read, &write, &except, &timeout );

   { /* Main function body. */
#line 1700 "posix.fec"

    
        int selectret;
        FeriteClass *cls;
        fd_set rfds, wfds, efds;
        FeriteVariable *fv, *obj;
        struct timeval tv, endtime, newtime, *tvp;

        if(timeout < 0) 
			tvp = NULL;
        else if(timeout > 0)
        {
            tv.tv_sec = (long)timeout;
            tv.tv_usec = (long)((timeout - tv.tv_sec) * 1000000);
            tvp = &tv;
            gettimeofday(&endtime, NULL);
            endtime.tv_usec += tv.tv_usec;
            endtime.tv_sec += tv.tv_sec;
            if(endtime.tv_usec >= 1000000)
            {
                endtime.tv_usec -= 1000000;
                endtime.tv_sec++;
            }
        }
        else
        {
            tv.tv_usec = 0;
            tv.tv_sec = 0;
            tvp = &tv;
        }

        do
        {
            if(make_fd_set(script, read, &rfds) == -1 ||
               make_fd_set(script, write, &wfds) == -1 ||
               make_fd_set(script, except, &efds) == -1)
            {
                FE_RETURN_NULL_OBJECT;
            }
            selectret = select(FD_SETSIZE, &rfds, &wfds, &efds, tvp);
            if(tvp && timeout)
            {
                gettimeofday(&newtime, NULL);
                if(newtime.tv_sec > endtime.tv_sec || (newtime.tv_sec ==
                                                       endtime.tv_sec && newtime.tv_usec >= endtime.tv_usec))
                {
                    tv.tv_sec = 0;
                    tv.tv_usec = 0;
                }
                else
                {
                    tv.tv_sec = endtime.tv_sec - newtime.tv_sec;
                    tv.tv_usec = endtime.tv_usec - newtime.tv_usec;
                    if(tv.tv_usec < 0)
                    {
                        tv.tv_sec--;
                        tv.tv_usec += 1000000;
                    }
                }
            }
        }
        while(selectret == -1 && errno == EINTR);

        if(!(cls = ferite_find_class(script, script->mainns, "Posix.SelectResult"))) {
            FE_RETURN_NULL_OBJECT;
        }

        if(!(obj = ferite_new_object(script, cls, NULL))) {
            FE_RETURN_NULL_OBJECT;
        }

        if(selectret && tvp && (tv.tv_usec > 0 || tv.tv_sec > 0))
        {
            fv = ferite_object_get_var(script, VAO(obj), "timeout");
            fv->type = F_VAR_DOUBLE;
            VAF(fv) = tv.tv_sec + (double)((double)tv.tv_usec / 1000000);
        }

        if(selectret)
        {
            update_SelectResult(script, VAO(obj), read, "read", &rfds);
            update_SelectResult(script, VAO(obj), write, "write", &wfds);
            update_SelectResult(script, VAO(obj), except, "except", &efds);
        }

        FE_RETURN_VAR(obj);
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_registerSigHandler_nso )
{
   double sig = 0.0;
   FeriteString *func = NULL;
   FeriteObject *o = NULL;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 3, &sig, &func, &o );

   { /* Main function body. */
#line 1212 "posix.fec"

 
 set_signal_action(script, (int)sig, SIG_IGN);
 if( o != NULL )
 ferite_signal_register_object_handler( script, o, func->data, (int)sig );
 else
 ferite_signal_register_function_handler( script, func->data, (int)sig );
 set_signal_action(script, (int)sig, ferite_signal_handler);
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_chmod_sn )
{
   FeriteString *filename = NULL;
   double mode = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &filename, &mode );

   { /* Main function body. */
#line 261 "posix.fec"

 
 if(chmod(filename->data, (mode_t)mode) == -1)
 {
 ferite_set_error(script, errno, "%s", strerror(errno));
 FE_RETURN_FALSE;
 }
 else FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_posix_Posix_kill_nn )
{
   double pid = 0.0;
   double sig = 0.0;
   FeriteNamespace *self = FE_CONTAINER_TO_NS;

   ferite_get_parameters( params, 2, &pid, &sig );

   { /* Main function body. */
#line 1186 "posix.fec"

 
 if(kill((pid_t)pid, (int)sig))
 {
 ferite_set_error(script, errno, "%s", strerror(errno));
 FE_RETURN_FALSE;
 }
 else FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

