/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  filesystem_File.c */
/* class: File */

#include <ferite.h>       /* we need this without a doubt */
#include "filesystem_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( ferite_filesystem_File_unlock_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 486 "filesystem.fec"

 
#ifdef HAVE_FLOCK
 if(flock((int)StreamObject->filedata, LOCK_UN))
 {
 ferite_set_error(script, errno, "%s", strerror(errno));
 FE_RETURN_FALSE;
 }
 else FE_RETURN_TRUE;
#else
 ferite_set_error(script, EINVAL, "flock() is not supported by this OS");
 FE_RETURN_LONG(-1);
#endif

 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_filesystem_File_pos_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 390 "filesystem.fec"

 
 int retval = 0;
 stream_flush( script, self );
 retval = lseek( (int)StreamObject->filedata, 0, SEEK_CUR );
 if( retval == -1 )
 {
 ferite_set_error( script, errno, "%s", strerror( errno ) );
 StreamObject->errmsg = fstrdup( strerror( errno ) );
 }
 FE_RETURN_LONG( retval );
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_filesystem_File_length_ )
{
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   { /* Main function body. */
#line 408 "filesystem.fec"

 
 off_t offset = 0,length = 0;
 
 stream_flush( script, self );
 offset = lseek( (int)StreamObject->filedata, 0, SEEK_CUR );
 if( offset == -1 )
 {
 ferite_set_error( script, errno, "%s", strerror( errno ) );
 StreamObject->errmsg = fstrdup( strerror( errno ) );
 FE_RETURN_LONG( -1 );
 }
 length = lseek( (int)StreamObject->filedata, 0, SEEK_END );
 lseek( (int)StreamObject->filedata, offset, SEEK_SET );
 FE_RETURN_LONG( length );
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_filesystem_File_truncate_n )
{
   double length = 0.0;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 1, &length );

   { /* Main function body. */
#line 344 "filesystem.fec"

 
 int retval = 0;
 stream_flush( script, self );
 retval = ftruncate( (int)StreamObject->filedata, (off_t)length );
 if( retval == -1)
 {
 ferite_set_error( script, errno, "%s", strerror( errno ) );
 StreamObject->errmsg = fstrdup( strerror( errno ) );
 FE_RETURN_FALSE;
 }
 stream_clear_input( self->odata);
 FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_filesystem_File_lock_nn )
{
   double shared = 0.0;
   double wait = 0.0;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 2, &shared, &wait );

   { /* Main function body. */
#line 454 "filesystem.fec"

 
#ifdef HAVE_FLOCK
 int op = 0;
 
 if((int)shared) op = LOCK_SH;
 else op = LOCK_EX;
 
 if(!(int)wait) op |= LOCK_NB;
 
 if(flock((int)StreamObject->filedata, op))
 {
 if(errno == EWOULDBLOCK) FE_RETURN_LONG(1);
 ferite_set_error(script, errno, "%s", strerror(errno));
 FE_RETURN_LONG(-1);
 }
 else FE_RETURN_LONG(0);
#else
 ferite_set_error(script, EINVAL, "lock() is not supported by this OS");
 FE_RETURN_LONG(-1);
#endif
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_filesystem_File_seek_nn )
{
   double offset = 0.0;
   double whence = 0.0;
   FeriteObject *self = FE_CONTAINER_TO_OBJECT;
   FeriteObject *super = FE_CONTAINER_TO_OBJECT;

   ferite_get_parameters( params, 2, &offset, &whence );

   { /* Main function body. */
#line 370 "filesystem.fec"

 
 int retval = 0;
 stream_flush( script, self );
 retval = lseek( (int)StreamObject->filedata, (off_t)offset, (int)whence );
 if( retval == -1)
 {
 ferite_set_error( script, errno, "%s", strerror( errno ) );
 StreamObject->errmsg = fstrdup( strerror( errno ) );
 FE_RETURN_LONG(retval);
 }
 stream_clear_input( self->odata ); 
 FE_RETURN_LONG(retval);
 
   }
   FE_RETURN_VOID;
   self = NULL;
   super = NULL;
}

FE_NATIVE_FUNCTION( ferite_filesystem_File_remove_s )
{
   FeriteString *filename = NULL;
   FeriteClass *self = FE_CONTAINER_TO_CLASS;

   ferite_get_parameters( params, 1, &filename );

   { /* Main function body. */
#line 310 "filesystem.fec"

 
 if( remove( filename->data ) == -1 )
 {
 ferite_set_error( script, errno, "%s", strerror(errno) );
 FE_RETURN_FALSE;
 }
 FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_filesystem_File_name_s )
{
   FeriteString *name = NULL;
   FeriteClass *self = FE_CONTAINER_TO_CLASS;

   ferite_get_parameters( params, 1, &name );

   { /* Main function body. */
#line 524 "filesystem.fec"
 
	char *path = aphex_file_name( name->data );
	char *ret = fstrdup(path);
	aphex_free( path );
	if( ret ) {
	FE_RETURN_CSTR( ret, FE_TRUE );
	}
	FE_RETURN_CSTR( "", FE_FALSE );
	
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_filesystem_File_move_ss )
{
   FeriteString *oldpath = NULL;
   FeriteString *newpath = NULL;
   FeriteClass *self = FE_CONTAINER_TO_CLASS;

   ferite_get_parameters( params, 2, &oldpath, &newpath );

   { /* Main function body. */
#line 328 "filesystem.fec"

 
 if( rename( oldpath->data, newpath->data ) == -1 )
 {
 ferite_set_error( script, errno, "%s", strerror(errno) );
 FE_RETURN_FALSE;
 }
 FE_RETURN_TRUE;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_filesystem_File___create_sn )
{
   FeriteString *filename = NULL;
   double mode = 0.0;
   FeriteClass *self = FE_CONTAINER_TO_CLASS;

   ferite_get_parameters( params, 2, &filename, &mode );

   { /* Main function body. */
#line 245 "filesystem.fec"

 
 FeriteClass *cls = NULL;
 FeriteVariable *object = NULL, **args = NULL;
 int fd = 0;
 
 if(( fd = creat( filename->data, (int)mode )) != -1 )
 {
 if((cls = ferite_find_class( script, script->mainns, "File" )) != NULL)
 {
 args = ferite_create_parameter_list_from_data( script, "l", fd );
 object = ferite_new_object( script, cls, args );
 ferite_delete_parameter_list( script, args );
 FE_RETURN_VAR( object );
 }
 close( fd );
 }
 else
 {
 ferite_set_error( script, errno, "%s", strerror(errno) );
 }
 FE_RETURN_NULL_OBJECT;
 
   }
   FE_RETURN_VOID;
   self = NULL;
}

FE_NATIVE_FUNCTION( ferite_filesystem_File___open_sn )
{
   FeriteString *filename = NULL;
   double flags = 0.0;
   FeriteClass *self = FE_CONTAINER_TO_CLASS;

   ferite_get_parameters( params, 2, &filename, &flags );

   { /* Main function body. */
#line 170 "filesystem.fec"

    
        FeriteClass *cls = NULL;
        FeriteVariable *object = NULL, **args = NULL;
        int fd = 0;
        
        if(( fd = open( filename->data, (int)flags )) != -1 )
        {
            if((cls = ferite_find_class( script, script->mainns, "File" )) != NULL)
            {
                args = ferite_create_parameter_list_from_data( script, "l", fd );
                object = ferite_new_object( script, cls, args );
                ferite_delete_parameter_list( script, args );
                FE_RETURN_VAR( object );
            }
            close( fd );
        }
        else
        {
            ferite_set_error( script, errno, "%s", strerror(errno) );
        }
        FE_RETURN_NULL_OBJECT;
    
   }
   FE_RETURN_VOID;
   self = NULL;
}

