// @generated by Thrift for thrift/compiler/test/fixtures/rust-raw-identifiers/src/mod.thrift
// This file is probably not the place you want to edit!

//! Mock definitions for `mod`.
//!
//! Client mocks. For every service, a struct mock::TheService that implements
//! client::TheService.
//!
//! As an example of the generated API, for the following thrift service:
//!
//! ```thrift
//! service MyService {
//!     FunctionResponse myFunction(
//!         1: FunctionRequest request,
//!     ) throws {
//!         1: StorageException s,
//!         2: NotFoundException n,
//!     ),
//!
//!     // other functions
//! }
//! ```
//!
//! we would end up with this mock object under crate::mock::MyService:
//!
//! ```
//! # const _: &str = stringify! {
//! impl crate::client::MyService for MyService<'mock> {...}
//!
//! pub struct MyService<'mock> {
//!     pub myFunction: myFunction<'mock>,
//!     // ...
//! }
//!
//! impl dyn crate::client::MyService {
//!     pub fn mock<'mock>() -> MyService<'mock>;
//! }
//!
//! impl myFunction<'mock> {
//!     // directly return the given success response
//!     pub fn ret(&self, value: FunctionResponse);
//!
//!     // invoke closure to compute success response
//!     pub fn mock(
//!         &self,
//!         mock: impl FnMut(FunctionRequest) -> FunctionResponse + Send + Sync + 'mock,
//!     );
//!
//!     // invoke closure to compute response
//!     pub fn mock_result(
//!         &self,
//!         mock: impl FnMut(FunctionRequest) -> Result<FunctionResponse, crate::services::MyService::MyFunctionExn> + Send + Sync + 'mock,
//!     );
//!
//!     // return one of the function's declared exceptions
//!     pub fn throw<E>(&self, exception: E)
//!     where
//!         E: Clone + Into<crate::services::MyService::MyFunctionExn> + Send + Sync + 'mock;
//! }
//!
//! impl From<StorageException> for MyFunctionExn {...}
//! impl From<NotFoundException> for MyFunctionExn {...}
//! # };
//! ```
//!
//! The intended usage from a test would be:
//!
//! ```
//! # const _: &str = stringify! {
//! use std::sync::Arc;
//! use thrift_if::client::MyService;
//!
//! #[test]
//! fn test_my_client() {
//!     let mock = Arc::new(<dyn MyService>::mock());
//!
//!     // directly return a success response
//!     let resp = FunctionResponse {...};
//!     mock.myFunction.ret(resp);
//!
//!     // or give a closure to compute the success response
//!     mock.myFunction.mock(|request| FunctionResponse {...});
//!
//!     // or throw one of the function's exceptions
//!     mock.myFunction.throw(StorageException::ItFailed);
//!
//!     // or compute a Result (useful if your exceptions aren't Clone)
//!     mock.myFunction.mock_result(|request| Err(...));
//!
//!     let out = do_the_thing(mock).wait().unwrap();
//!     assert!(out.what_i_expected());
//! }
//!
//! fn do_the_thing(
//!     client: Arc<dyn MyService + Send + Sync + 'static>,
//! ) -> impl Future<Item = Out> {...}
//! # };
//! ```

pub struct Foo<'mock> {
    pub r#return: r#impl::foo::r#return<'mock>,
    pub super_: r#impl::foo::super_<'mock>,
    _marker: ::std::marker::PhantomData<&'mock ()>,
}

impl dyn super::client::Foo {
    pub fn mock<'mock>() -> Foo<'mock> {
        Foo {
            r#return: r#impl::foo::r#return::unimplemented(),
            super_: r#impl::foo::super_::unimplemented(),
            _marker: ::std::marker::PhantomData,
        }
    }
}

impl<'mock> super::client::Foo for Foo<'mock> {
    fn r#return(
        &self,
        arg_bar: &crate::types::ThereAreNoPascalCaseKeywords,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::foo::ReturnError>> {
        let mut closure = self.r#return.closure.lock().unwrap();
        let closure: &mut dyn ::std::ops::FnMut(crate::types::ThereAreNoPascalCaseKeywords) -> _ = &mut **closure;
        ::std::boxed::Box::pin(::futures::future::ready(closure(arg_bar.clone())))
    }
    fn super_(
        &self,
        arg_bar: &crate::types::ThereAreNoPascalCaseKeywords,
    ) -> ::futures::future::BoxFuture<'static, ::std::result::Result<(), crate::errors::foo::SuperError>> {
        let mut closure = self.super_.closure.lock().unwrap();
        let closure: &mut dyn ::std::ops::FnMut(crate::types::ThereAreNoPascalCaseKeywords) -> _ = &mut **closure;
        ::std::boxed::Box::pin(::futures::future::ready(closure(arg_bar.clone())))
    }
}

pub mod r#impl {
    pub mod foo {

        pub struct r#return<'mock> {
            pub(crate) closure: ::std::sync::Mutex<::std::boxed::Box<
                dyn ::std::ops::FnMut(crate::types::ThereAreNoPascalCaseKeywords) -> ::std::result::Result<
                    (),
                    crate::errors::foo::ReturnError,
                > + ::std::marker::Send + ::std::marker::Sync + 'mock,
            >>,
        }

        #[allow(clippy::redundant_closure)]
        impl<'mock> r#return<'mock> {
            pub(crate) fn unimplemented() -> Self {
                Self {
                    closure: ::std::sync::Mutex::new(::std::boxed::Box::new(|_: crate::types::ThereAreNoPascalCaseKeywords| panic!(
                        "{}::{} is not mocked",
                        "Foo",
                        "return",
                    ))),
                }
            }

            pub fn ret(&self, value: ()) {
                self.mock(move |_: crate::types::ThereAreNoPascalCaseKeywords| value.clone());
            }

            pub fn mock(&self, mut mock: impl ::std::ops::FnMut(crate::types::ThereAreNoPascalCaseKeywords) -> () + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move |bar| ::std::result::Result::Ok(mock(bar)));
            }

            pub fn mock_result(&self, mut mock: impl ::std::ops::FnMut(crate::types::ThereAreNoPascalCaseKeywords) -> ::std::result::Result<(), crate::errors::foo::ReturnError> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move |bar| mock(bar));
            }

            pub fn throw<E>(&self, exception: E)
            where
                E: ::std::convert::Into<crate::errors::foo::ReturnError>,
                E: ::std::clone::Clone + ::std::marker::Send + ::std::marker::Sync + 'mock,
            {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move |_: crate::types::ThereAreNoPascalCaseKeywords| ::std::result::Result::Err(exception.clone().into()));
            }
        }

        pub struct super_<'mock> {
            pub(crate) closure: ::std::sync::Mutex<::std::boxed::Box<
                dyn ::std::ops::FnMut(crate::types::ThereAreNoPascalCaseKeywords) -> ::std::result::Result<
                    (),
                    crate::errors::foo::SuperError,
                > + ::std::marker::Send + ::std::marker::Sync + 'mock,
            >>,
        }

        #[allow(clippy::redundant_closure)]
        impl<'mock> super_<'mock> {
            pub(crate) fn unimplemented() -> Self {
                Self {
                    closure: ::std::sync::Mutex::new(::std::boxed::Box::new(|_: crate::types::ThereAreNoPascalCaseKeywords| panic!(
                        "{}::{} is not mocked",
                        "Foo",
                        "super",
                    ))),
                }
            }

            pub fn ret(&self, value: ()) {
                self.mock(move |_: crate::types::ThereAreNoPascalCaseKeywords| value.clone());
            }

            pub fn mock(&self, mut mock: impl ::std::ops::FnMut(crate::types::ThereAreNoPascalCaseKeywords) -> () + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move |bar| ::std::result::Result::Ok(mock(bar)));
            }

            pub fn mock_result(&self, mut mock: impl ::std::ops::FnMut(crate::types::ThereAreNoPascalCaseKeywords) -> ::std::result::Result<(), crate::errors::foo::SuperError> + ::std::marker::Send + ::std::marker::Sync + 'mock) {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move |bar| mock(bar));
            }

            pub fn throw<E>(&self, exception: E)
            where
                E: ::std::convert::Into<crate::errors::foo::SuperError>,
                E: ::std::clone::Clone + ::std::marker::Send + ::std::marker::Sync + 'mock,
            {
                let mut closure = self.closure.lock().unwrap();
                *closure = ::std::boxed::Box::new(move |_: crate::types::ThereAreNoPascalCaseKeywords| ::std::result::Result::Err(exception.clone().into()));
            }
        }
    }
}
