// @generated by Thrift for [[[ program path ]]]
// This file is probably not the place you want to edit!

package module // [[[ program thrift source path ]]]


import (
    "context"
    "fmt"
    "strings"
    "sync"

    thrift "github.com/facebook/fbthrift/thrift/lib/go/thrift"
    metadata "github.com/facebook/fbthrift/thrift/lib/thrift/metadata"
)

// (needed to ensure safety because of naive import list construction)
var _ = context.Background
var _ = fmt.Printf
var _ = strings.Split
var _ = sync.Mutex{}
var _ = thrift.ZERO
var _ = metadata.GoUnusedProtection__



type GetEntity interface {
    GetEntity(ctx context.Context, r *GetEntityRequest) (*GetEntityResponse, error)
    GetBool(ctx context.Context) (bool, error)
    GetByte(ctx context.Context) (int8, error)
    GetI16(ctx context.Context) (int16, error)
    GetI32(ctx context.Context) (int32, error)
    GetI64(ctx context.Context) (int64, error)
    GetDouble(ctx context.Context) (float64, error)
    GetString(ctx context.Context) (string, error)
    GetBinary(ctx context.Context) ([]byte, error)
    GetMap(ctx context.Context) (map[string]string, error)
    GetSet(ctx context.Context) ([]string, error)
    GetList(ctx context.Context) ([]string, error)
    GetLegacyStuff(ctx context.Context, numPos int64, numNeg1 int64, numNeg2 int64) (int32, error)
    GetCtxCollision(ctx1 context.Context, ctx int64) (int32, error)
    GetCtx1Collision(ctx2 context.Context, ctx int64, ctx1 int64) (int32, error)
}

type GetEntityChannelClientInterface interface {
    thrift.ClientInterface
    GetEntity
}

// Deprecated: Migrate to ChannelClient and use GetEntityChannelClientInterface instead.
type GetEntityClientInterface interface {
    thrift.ClientInterface
    GetEntity(r *GetEntityRequest) (*GetEntityResponse, error)
    GetBool() (bool, error)
    GetByte() (int8, error)
    GetI16() (int16, error)
    GetI32() (int32, error)
    GetI64() (int64, error)
    GetDouble() (float64, error)
    GetString() (string, error)
    GetBinary() ([]byte, error)
    GetMap() (map[string]string, error)
    GetSet() ([]string, error)
    GetList() ([]string, error)
    GetLegacyStuff(numPos int64, numNeg1 int64, numNeg2 int64) (int32, error)
    GetCtxCollision(ctx int64) (int32, error)
    GetCtx1Collision(ctx int64, ctx1 int64) (int32, error)
}

type GetEntityChannelClient struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ GetEntityChannelClientInterface = &GetEntityChannelClient{}

func NewGetEntityChannelClient(channel thrift.RequestChannel) *GetEntityChannelClient {
    return &GetEntityChannelClient{
        ch: channel,
    }
}

func (c *GetEntityChannelClient) Close() error {
    return c.ch.Close()
}

func (c *GetEntityChannelClient) IsOpen() bool {
    return c.ch.IsOpen()
}

func (c *GetEntityChannelClient) Open() error {
    return c.ch.Open()
}

// Deprecated: Use GetEntityChannelClient instead.
type GetEntityClient struct {
    chClient *GetEntityChannelClient
    Mu       sync.Mutex
}
// Compile time interface enforcer
var _ GetEntityClientInterface = &GetEntityClient{}

// Deprecated: Use NewGetEntityChannelClient() instead.
func NewGetEntityClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *GetEntityClient {
    return &GetEntityClient{
        chClient: NewGetEntityChannelClient(
            thrift.NewSerialChannel(iprot),
        ),
    }
}

func (c *GetEntityClient) Close() error {
    return c.chClient.Close()
}

func (c *GetEntityClient) IsOpen() bool {
    return c.chClient.IsOpen()
}

func (c *GetEntityClient) Open() error {
    return c.chClient.Open()
}

// Deprecated: Use GetEntityChannelClient instead.
type GetEntityThreadsafeClient = GetEntityClient

// Deprecated: Use NewGetEntityChannelClient() instead.
func NewGetEntityThreadsafeClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *GetEntityThreadsafeClient {
    return NewGetEntityClient(t, iprot, oprot)
}

// Deprecated: Use NewGetEntityChannelClient() instead.
func NewGetEntityClientProtocol(prot thrift.Protocol) *GetEntityClient {
  return NewGetEntityClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewGetEntityChannelClient() instead.
func NewGetEntityThreadsafeClientProtocol(prot thrift.Protocol) *GetEntityClient {
  return NewGetEntityClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewGetEntityChannelClient() instead.
func NewGetEntityClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *GetEntityClient {
  iprot := pf.GetProtocol(t)
  oprot := pf.GetProtocol(t)
  return NewGetEntityClient(t, iprot, oprot)
}

// Deprecated: Use NewGetEntityChannelClient() instead.
func NewGetEntityThreadsafeClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *GetEntityThreadsafeClient {
  return NewGetEntityClientFactory(t, pf)
}


func (c *GetEntityChannelClient) GetEntity(ctx context.Context, r *GetEntityRequest) (*GetEntityResponse, error) {
    in := &reqGetEntityGetEntity{
        R: r,
    }
    out := newRespGetEntityGetEntity()
    err := c.ch.Call(ctx, "getEntity", in, out)
    if err != nil {
        return nil, err
    }
    return out.GetSuccess(), nil
}

func (c *GetEntityClient) GetEntity(r *GetEntityRequest) (*GetEntityResponse, error) {
    return c.chClient.GetEntity(nil, r)
}


func (c *GetEntityChannelClient) GetBool(ctx context.Context) (bool, error) {
    in := &reqGetEntityGetBool{
    }
    out := newRespGetEntityGetBool()
    err := c.ch.Call(ctx, "getBool", in, out)
    if err != nil {
        return false, err
    }
    return out.GetSuccess(), nil
}

func (c *GetEntityClient) GetBool() (bool, error) {
    return c.chClient.GetBool(nil)
}


func (c *GetEntityChannelClient) GetByte(ctx context.Context) (int8, error) {
    in := &reqGetEntityGetByte{
    }
    out := newRespGetEntityGetByte()
    err := c.ch.Call(ctx, "getByte", in, out)
    if err != nil {
        return 0, err
    }
    return out.GetSuccess(), nil
}

func (c *GetEntityClient) GetByte() (int8, error) {
    return c.chClient.GetByte(nil)
}


func (c *GetEntityChannelClient) GetI16(ctx context.Context) (int16, error) {
    in := &reqGetEntityGetI16{
    }
    out := newRespGetEntityGetI16()
    err := c.ch.Call(ctx, "getI16", in, out)
    if err != nil {
        return 0, err
    }
    return out.GetSuccess(), nil
}

func (c *GetEntityClient) GetI16() (int16, error) {
    return c.chClient.GetI16(nil)
}


func (c *GetEntityChannelClient) GetI32(ctx context.Context) (int32, error) {
    in := &reqGetEntityGetI32{
    }
    out := newRespGetEntityGetI32()
    err := c.ch.Call(ctx, "getI32", in, out)
    if err != nil {
        return 0, err
    }
    return out.GetSuccess(), nil
}

func (c *GetEntityClient) GetI32() (int32, error) {
    return c.chClient.GetI32(nil)
}


func (c *GetEntityChannelClient) GetI64(ctx context.Context) (int64, error) {
    in := &reqGetEntityGetI64{
    }
    out := newRespGetEntityGetI64()
    err := c.ch.Call(ctx, "getI64", in, out)
    if err != nil {
        return 0, err
    }
    return out.GetSuccess(), nil
}

func (c *GetEntityClient) GetI64() (int64, error) {
    return c.chClient.GetI64(nil)
}


func (c *GetEntityChannelClient) GetDouble(ctx context.Context) (float64, error) {
    in := &reqGetEntityGetDouble{
    }
    out := newRespGetEntityGetDouble()
    err := c.ch.Call(ctx, "getDouble", in, out)
    if err != nil {
        return 0.0, err
    }
    return out.GetSuccess(), nil
}

func (c *GetEntityClient) GetDouble() (float64, error) {
    return c.chClient.GetDouble(nil)
}


func (c *GetEntityChannelClient) GetString(ctx context.Context) (string, error) {
    in := &reqGetEntityGetString{
    }
    out := newRespGetEntityGetString()
    err := c.ch.Call(ctx, "getString", in, out)
    if err != nil {
        return "", err
    }
    return out.GetSuccess(), nil
}

func (c *GetEntityClient) GetString() (string, error) {
    return c.chClient.GetString(nil)
}


func (c *GetEntityChannelClient) GetBinary(ctx context.Context) ([]byte, error) {
    in := &reqGetEntityGetBinary{
    }
    out := newRespGetEntityGetBinary()
    err := c.ch.Call(ctx, "getBinary", in, out)
    if err != nil {
        return nil, err
    }
    return out.GetSuccess(), nil
}

func (c *GetEntityClient) GetBinary() ([]byte, error) {
    return c.chClient.GetBinary(nil)
}


func (c *GetEntityChannelClient) GetMap(ctx context.Context) (map[string]string, error) {
    in := &reqGetEntityGetMap{
    }
    out := newRespGetEntityGetMap()
    err := c.ch.Call(ctx, "getMap", in, out)
    if err != nil {
        return nil, err
    }
    return out.GetSuccess(), nil
}

func (c *GetEntityClient) GetMap() (map[string]string, error) {
    return c.chClient.GetMap(nil)
}


func (c *GetEntityChannelClient) GetSet(ctx context.Context) ([]string, error) {
    in := &reqGetEntityGetSet{
    }
    out := newRespGetEntityGetSet()
    err := c.ch.Call(ctx, "getSet", in, out)
    if err != nil {
        return nil, err
    }
    return out.GetSuccess(), nil
}

func (c *GetEntityClient) GetSet() ([]string, error) {
    return c.chClient.GetSet(nil)
}


func (c *GetEntityChannelClient) GetList(ctx context.Context) ([]string, error) {
    in := &reqGetEntityGetList{
    }
    out := newRespGetEntityGetList()
    err := c.ch.Call(ctx, "getList", in, out)
    if err != nil {
        return nil, err
    }
    return out.GetSuccess(), nil
}

func (c *GetEntityClient) GetList() ([]string, error) {
    return c.chClient.GetList(nil)
}


func (c *GetEntityChannelClient) GetLegacyStuff(ctx context.Context, numPos int64, numNeg1 int64, numNeg2 int64) (int32, error) {
    in := &reqGetEntityGetLegacyStuff{
        NumPos: numPos,
        NumNeg1: numNeg1,
        NumNeg2: numNeg2,
    }
    out := newRespGetEntityGetLegacyStuff()
    err := c.ch.Call(ctx, "getLegacyStuff", in, out)
    if err != nil {
        return 0, err
    }
    return out.GetSuccess(), nil
}

func (c *GetEntityClient) GetLegacyStuff(numPos int64, numNeg1 int64, numNeg2 int64) (int32, error) {
    return c.chClient.GetLegacyStuff(nil, numPos, numNeg1, numNeg2)
}


func (c *GetEntityChannelClient) GetCtxCollision(ctx1 context.Context, ctx int64) (int32, error) {
    in := &reqGetEntityGetCtxCollision{
        Ctx: ctx,
    }
    out := newRespGetEntityGetCtxCollision()
    err := c.ch.Call(ctx1, "getCtxCollision", in, out)
    if err != nil {
        return 0, err
    }
    return out.GetSuccess(), nil
}

func (c *GetEntityClient) GetCtxCollision(ctx int64) (int32, error) {
    return c.chClient.GetCtxCollision(nil, ctx)
}


func (c *GetEntityChannelClient) GetCtx1Collision(ctx2 context.Context, ctx int64, ctx1 int64) (int32, error) {
    in := &reqGetEntityGetCtx1Collision{
        Ctx: ctx,
        Ctx1: ctx1,
    }
    out := newRespGetEntityGetCtx1Collision()
    err := c.ch.Call(ctx2, "getCtx1Collision", in, out)
    if err != nil {
        return 0, err
    }
    return out.GetSuccess(), nil
}

func (c *GetEntityClient) GetCtx1Collision(ctx int64, ctx1 int64) (int32, error) {
    return c.chClient.GetCtx1Collision(nil, ctx, ctx1)
}


type reqGetEntityGetEntity struct {
    R *GetEntityRequest `thrift:"r,1" json:"r" db:"r"`
}
// Compile time interface enforcer
var _ thrift.Struct = &reqGetEntityGetEntity{}

type GetEntityGetEntityArgs = reqGetEntityGetEntity

func newReqGetEntityGetEntity() *reqGetEntityGetEntity {
    return (&reqGetEntityGetEntity{}).
        SetRNonCompat(*NewGetEntityRequest())
}

func (x *reqGetEntityGetEntity) GetRNonCompat() *GetEntityRequest {
    return x.R
}

func (x *reqGetEntityGetEntity) GetR() *GetEntityRequest {
    if !x.IsSetR() {
        return nil
    }

    return x.R
}

func (x *reqGetEntityGetEntity) SetRNonCompat(value GetEntityRequest) *reqGetEntityGetEntity {
    x.R = &value
    return x
}

func (x *reqGetEntityGetEntity) SetR(value *GetEntityRequest) *reqGetEntityGetEntity {
    x.R = value
    return x
}

func (x *reqGetEntityGetEntity) IsSetR() bool {
    return x != nil && x.R != nil
}

func (x *reqGetEntityGetEntity) writeField1(p thrift.Protocol) error {  // R
    if !x.IsSetR() {
        return nil
    }

    if err := p.WriteFieldBegin("r", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetRNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetEntity) readField1(p thrift.Protocol) error {  // R
    result := *NewGetEntityRequest()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetRNonCompat(result)
    return nil
}

func (x *reqGetEntityGetEntity) toString1() string {  // R
    return fmt.Sprintf("%v", x.GetRNonCompat())
}

// Deprecated: Use newReqGetEntityGetEntity().GetR() instead.
func (x *reqGetEntityGetEntity) DefaultGetR() *GetEntityRequest {
    if !x.IsSetR() {
        return NewGetEntityRequest()
    }
    return x.R
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetEntity().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqGetEntityGetEntityBuilder struct {
    obj *reqGetEntityGetEntity
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetEntity().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqGetEntityGetEntityBuilder() *reqGetEntityGetEntityBuilder {
    return &reqGetEntityGetEntityBuilder{
        obj: newReqGetEntityGetEntity(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetEntity().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetEntityBuilder) R(value *GetEntityRequest) *reqGetEntityGetEntityBuilder {
    x.obj.R = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetEntity().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetEntityBuilder) Emit() *reqGetEntityGetEntity {
    var objCopy reqGetEntityGetEntity = *x.obj
    return &objCopy
}

func (x *reqGetEntityGetEntity) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqGetEntityGetEntity"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetEntity) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRUCT)):  // r
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqGetEntityGetEntity) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqGetEntityGetEntity({")
    sb.WriteString(fmt.Sprintf("R:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}
type respGetEntityGetEntity struct {
    Success *GetEntityResponse `thrift:"success,0,optional" json:"success,omitempty" db:"success"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respGetEntityGetEntity{}
var _ thrift.WritableResult = &respGetEntityGetEntity{}

type GetEntityGetEntityResult = respGetEntityGetEntity

func newRespGetEntityGetEntity() *respGetEntityGetEntity {
    return (&respGetEntityGetEntity{})
}

func (x *respGetEntityGetEntity) GetSuccessNonCompat() *GetEntityResponse {
    return x.Success
}

func (x *respGetEntityGetEntity) GetSuccess() *GetEntityResponse {
    if !x.IsSetSuccess() {
        return nil
    }

    return x.Success
}

func (x *respGetEntityGetEntity) SetSuccessNonCompat(value GetEntityResponse) *respGetEntityGetEntity {
    x.Success = &value
    return x
}

func (x *respGetEntityGetEntity) SetSuccess(value *GetEntityResponse) *respGetEntityGetEntity {
    x.Success = value
    return x
}

func (x *respGetEntityGetEntity) IsSetSuccess() bool {
    return x != nil && x.Success != nil
}

func (x *respGetEntityGetEntity) writeField0(p thrift.Protocol) error {  // Success
    if !x.IsSetSuccess() {
        return nil
    }

    if err := p.WriteFieldBegin("success", thrift.STRUCT, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetSuccessNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetEntity) readField0(p thrift.Protocol) error {  // Success
    result := *NewGetEntityResponse()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetSuccessNonCompat(result)
    return nil
}

func (x *respGetEntityGetEntity) toString0() string {  // Success
    return fmt.Sprintf("%v", x.GetSuccessNonCompat())
}

// Deprecated: Use newRespGetEntityGetEntity().GetSuccess() instead.
func (x *respGetEntityGetEntity) DefaultGetSuccess() *GetEntityResponse {
    if !x.IsSetSuccess() {
        return NewGetEntityResponse()
    }
    return x.Success
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetEntity().Set<FieldNameFoo>().Set<FieldNameBar>()
type respGetEntityGetEntityBuilder struct {
    obj *respGetEntityGetEntity
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetEntity().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespGetEntityGetEntityBuilder() *respGetEntityGetEntityBuilder {
    return &respGetEntityGetEntityBuilder{
        obj: newRespGetEntityGetEntity(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetEntity().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetEntityBuilder) Success(value *GetEntityResponse) *respGetEntityGetEntityBuilder {
    x.obj.Success = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetEntity().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetEntityBuilder) Emit() *respGetEntityGetEntity {
    var objCopy respGetEntityGetEntity = *x.obj
    return &objCopy
}

func (x *respGetEntityGetEntity) Exception() thrift.WritableException {
    return nil
}

func (x *respGetEntityGetEntity) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respGetEntityGetEntity"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetEntity) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 0 && wireType == thrift.Type(thrift.STRUCT)):  // success
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respGetEntityGetEntity) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respGetEntityGetEntity({")
    sb.WriteString(fmt.Sprintf("Success:%s", x.toString0()))
    sb.WriteString("})")

    return sb.String()
}
type reqGetEntityGetBool struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqGetEntityGetBool{}

type GetEntityGetBoolArgs = reqGetEntityGetBool

func newReqGetEntityGetBool() *reqGetEntityGetBool {
    return (&reqGetEntityGetBool{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetBool().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqGetEntityGetBoolBuilder struct {
    obj *reqGetEntityGetBool
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetBool().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqGetEntityGetBoolBuilder() *reqGetEntityGetBoolBuilder {
    return &reqGetEntityGetBoolBuilder{
        obj: newReqGetEntityGetBool(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetBool().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetBoolBuilder) Emit() *reqGetEntityGetBool {
    var objCopy reqGetEntityGetBool = *x.obj
    return &objCopy
}

func (x *reqGetEntityGetBool) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqGetEntityGetBool"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetBool) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqGetEntityGetBool) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqGetEntityGetBool({")
    sb.WriteString("})")

    return sb.String()
}
type respGetEntityGetBool struct {
    Success *bool `thrift:"success,0,optional" json:"success,omitempty" db:"success"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respGetEntityGetBool{}
var _ thrift.WritableResult = &respGetEntityGetBool{}

type GetEntityGetBoolResult = respGetEntityGetBool

func newRespGetEntityGetBool() *respGetEntityGetBool {
    return (&respGetEntityGetBool{})
}

func (x *respGetEntityGetBool) GetSuccessNonCompat() *bool {
    return x.Success
}

func (x *respGetEntityGetBool) GetSuccess() bool {
    if !x.IsSetSuccess() {
        return false
    }

    return *x.Success
}

func (x *respGetEntityGetBool) SetSuccessNonCompat(value bool) *respGetEntityGetBool {
    x.Success = &value
    return x
}

func (x *respGetEntityGetBool) SetSuccess(value *bool) *respGetEntityGetBool {
    x.Success = value
    return x
}

func (x *respGetEntityGetBool) IsSetSuccess() bool {
    return x != nil && x.Success != nil
}

func (x *respGetEntityGetBool) writeField0(p thrift.Protocol) error {  // Success
    if !x.IsSetSuccess() {
        return nil
    }

    if err := p.WriteFieldBegin("success", thrift.BOOL, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetSuccessNonCompat()
    if err := p.WriteBool(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetBool) readField0(p thrift.Protocol) error {  // Success
    result, err := p.ReadBool()
if err != nil {
    return err
}

    x.SetSuccessNonCompat(result)
    return nil
}

func (x *respGetEntityGetBool) toString0() string {  // Success
    if x.IsSetSuccess() {
        return fmt.Sprintf("%v", *x.GetSuccessNonCompat())
    }
    return fmt.Sprintf("%v", x.GetSuccessNonCompat())
}



// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetBool().Set<FieldNameFoo>().Set<FieldNameBar>()
type respGetEntityGetBoolBuilder struct {
    obj *respGetEntityGetBool
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetBool().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespGetEntityGetBoolBuilder() *respGetEntityGetBoolBuilder {
    return &respGetEntityGetBoolBuilder{
        obj: newRespGetEntityGetBool(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetBool().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetBoolBuilder) Success(value *bool) *respGetEntityGetBoolBuilder {
    x.obj.Success = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetBool().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetBoolBuilder) Emit() *respGetEntityGetBool {
    var objCopy respGetEntityGetBool = *x.obj
    return &objCopy
}

func (x *respGetEntityGetBool) Exception() thrift.WritableException {
    return nil
}

func (x *respGetEntityGetBool) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respGetEntityGetBool"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetBool) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 0 && wireType == thrift.Type(thrift.BOOL)):  // success
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respGetEntityGetBool) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respGetEntityGetBool({")
    sb.WriteString(fmt.Sprintf("Success:%s", x.toString0()))
    sb.WriteString("})")

    return sb.String()
}
type reqGetEntityGetByte struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqGetEntityGetByte{}

type GetEntityGetByteArgs = reqGetEntityGetByte

func newReqGetEntityGetByte() *reqGetEntityGetByte {
    return (&reqGetEntityGetByte{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetByte().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqGetEntityGetByteBuilder struct {
    obj *reqGetEntityGetByte
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetByte().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqGetEntityGetByteBuilder() *reqGetEntityGetByteBuilder {
    return &reqGetEntityGetByteBuilder{
        obj: newReqGetEntityGetByte(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetByte().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetByteBuilder) Emit() *reqGetEntityGetByte {
    var objCopy reqGetEntityGetByte = *x.obj
    return &objCopy
}

func (x *reqGetEntityGetByte) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqGetEntityGetByte"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetByte) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqGetEntityGetByte) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqGetEntityGetByte({")
    sb.WriteString("})")

    return sb.String()
}
type respGetEntityGetByte struct {
    Success *int8 `thrift:"success,0,optional" json:"success,omitempty" db:"success"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respGetEntityGetByte{}
var _ thrift.WritableResult = &respGetEntityGetByte{}

type GetEntityGetByteResult = respGetEntityGetByte

func newRespGetEntityGetByte() *respGetEntityGetByte {
    return (&respGetEntityGetByte{})
}

func (x *respGetEntityGetByte) GetSuccessNonCompat() *int8 {
    return x.Success
}

func (x *respGetEntityGetByte) GetSuccess() int8 {
    if !x.IsSetSuccess() {
        return 0
    }

    return *x.Success
}

func (x *respGetEntityGetByte) SetSuccessNonCompat(value int8) *respGetEntityGetByte {
    x.Success = &value
    return x
}

func (x *respGetEntityGetByte) SetSuccess(value *int8) *respGetEntityGetByte {
    x.Success = value
    return x
}

func (x *respGetEntityGetByte) IsSetSuccess() bool {
    return x != nil && x.Success != nil
}

func (x *respGetEntityGetByte) writeField0(p thrift.Protocol) error {  // Success
    if !x.IsSetSuccess() {
        return nil
    }

    if err := p.WriteFieldBegin("success", thrift.BYTE, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetSuccessNonCompat()
    if err := p.WriteByte(byte(item)); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetByte) readField0(p thrift.Protocol) error {  // Success
    resultByte, err := p.ReadByte()
result := int8(resultByte)
if err != nil {
    return err
}

    x.SetSuccessNonCompat(result)
    return nil
}

func (x *respGetEntityGetByte) toString0() string {  // Success
    if x.IsSetSuccess() {
        return fmt.Sprintf("%v", *x.GetSuccessNonCompat())
    }
    return fmt.Sprintf("%v", x.GetSuccessNonCompat())
}



// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetByte().Set<FieldNameFoo>().Set<FieldNameBar>()
type respGetEntityGetByteBuilder struct {
    obj *respGetEntityGetByte
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetByte().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespGetEntityGetByteBuilder() *respGetEntityGetByteBuilder {
    return &respGetEntityGetByteBuilder{
        obj: newRespGetEntityGetByte(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetByte().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetByteBuilder) Success(value *int8) *respGetEntityGetByteBuilder {
    x.obj.Success = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetByte().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetByteBuilder) Emit() *respGetEntityGetByte {
    var objCopy respGetEntityGetByte = *x.obj
    return &objCopy
}

func (x *respGetEntityGetByte) Exception() thrift.WritableException {
    return nil
}

func (x *respGetEntityGetByte) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respGetEntityGetByte"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetByte) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 0 && wireType == thrift.Type(thrift.BYTE)):  // success
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respGetEntityGetByte) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respGetEntityGetByte({")
    sb.WriteString(fmt.Sprintf("Success:%s", x.toString0()))
    sb.WriteString("})")

    return sb.String()
}
type reqGetEntityGetI16 struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqGetEntityGetI16{}

type GetEntityGetI16Args = reqGetEntityGetI16

func newReqGetEntityGetI16() *reqGetEntityGetI16 {
    return (&reqGetEntityGetI16{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetI16().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqGetEntityGetI16Builder struct {
    obj *reqGetEntityGetI16
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetI16().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqGetEntityGetI16Builder() *reqGetEntityGetI16Builder {
    return &reqGetEntityGetI16Builder{
        obj: newReqGetEntityGetI16(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetI16().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetI16Builder) Emit() *reqGetEntityGetI16 {
    var objCopy reqGetEntityGetI16 = *x.obj
    return &objCopy
}

func (x *reqGetEntityGetI16) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqGetEntityGetI16"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetI16) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqGetEntityGetI16) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqGetEntityGetI16({")
    sb.WriteString("})")

    return sb.String()
}
type respGetEntityGetI16 struct {
    Success *int16 `thrift:"success,0,optional" json:"success,omitempty" db:"success"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respGetEntityGetI16{}
var _ thrift.WritableResult = &respGetEntityGetI16{}

type GetEntityGetI16Result = respGetEntityGetI16

func newRespGetEntityGetI16() *respGetEntityGetI16 {
    return (&respGetEntityGetI16{})
}

func (x *respGetEntityGetI16) GetSuccessNonCompat() *int16 {
    return x.Success
}

func (x *respGetEntityGetI16) GetSuccess() int16 {
    if !x.IsSetSuccess() {
        return 0
    }

    return *x.Success
}

func (x *respGetEntityGetI16) SetSuccessNonCompat(value int16) *respGetEntityGetI16 {
    x.Success = &value
    return x
}

func (x *respGetEntityGetI16) SetSuccess(value *int16) *respGetEntityGetI16 {
    x.Success = value
    return x
}

func (x *respGetEntityGetI16) IsSetSuccess() bool {
    return x != nil && x.Success != nil
}

func (x *respGetEntityGetI16) writeField0(p thrift.Protocol) error {  // Success
    if !x.IsSetSuccess() {
        return nil
    }

    if err := p.WriteFieldBegin("success", thrift.I16, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetSuccessNonCompat()
    if err := p.WriteI16(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetI16) readField0(p thrift.Protocol) error {  // Success
    result, err := p.ReadI16()
if err != nil {
    return err
}

    x.SetSuccessNonCompat(result)
    return nil
}

func (x *respGetEntityGetI16) toString0() string {  // Success
    if x.IsSetSuccess() {
        return fmt.Sprintf("%v", *x.GetSuccessNonCompat())
    }
    return fmt.Sprintf("%v", x.GetSuccessNonCompat())
}



// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetI16().Set<FieldNameFoo>().Set<FieldNameBar>()
type respGetEntityGetI16Builder struct {
    obj *respGetEntityGetI16
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetI16().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespGetEntityGetI16Builder() *respGetEntityGetI16Builder {
    return &respGetEntityGetI16Builder{
        obj: newRespGetEntityGetI16(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetI16().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetI16Builder) Success(value *int16) *respGetEntityGetI16Builder {
    x.obj.Success = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetI16().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetI16Builder) Emit() *respGetEntityGetI16 {
    var objCopy respGetEntityGetI16 = *x.obj
    return &objCopy
}

func (x *respGetEntityGetI16) Exception() thrift.WritableException {
    return nil
}

func (x *respGetEntityGetI16) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respGetEntityGetI16"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetI16) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 0 && wireType == thrift.Type(thrift.I16)):  // success
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respGetEntityGetI16) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respGetEntityGetI16({")
    sb.WriteString(fmt.Sprintf("Success:%s", x.toString0()))
    sb.WriteString("})")

    return sb.String()
}
type reqGetEntityGetI32 struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqGetEntityGetI32{}

type GetEntityGetI32Args = reqGetEntityGetI32

func newReqGetEntityGetI32() *reqGetEntityGetI32 {
    return (&reqGetEntityGetI32{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetI32().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqGetEntityGetI32Builder struct {
    obj *reqGetEntityGetI32
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetI32().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqGetEntityGetI32Builder() *reqGetEntityGetI32Builder {
    return &reqGetEntityGetI32Builder{
        obj: newReqGetEntityGetI32(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetI32().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetI32Builder) Emit() *reqGetEntityGetI32 {
    var objCopy reqGetEntityGetI32 = *x.obj
    return &objCopy
}

func (x *reqGetEntityGetI32) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqGetEntityGetI32"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetI32) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqGetEntityGetI32) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqGetEntityGetI32({")
    sb.WriteString("})")

    return sb.String()
}
type respGetEntityGetI32 struct {
    Success *int32 `thrift:"success,0,optional" json:"success,omitempty" db:"success"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respGetEntityGetI32{}
var _ thrift.WritableResult = &respGetEntityGetI32{}

type GetEntityGetI32Result = respGetEntityGetI32

func newRespGetEntityGetI32() *respGetEntityGetI32 {
    return (&respGetEntityGetI32{})
}

func (x *respGetEntityGetI32) GetSuccessNonCompat() *int32 {
    return x.Success
}

func (x *respGetEntityGetI32) GetSuccess() int32 {
    if !x.IsSetSuccess() {
        return 0
    }

    return *x.Success
}

func (x *respGetEntityGetI32) SetSuccessNonCompat(value int32) *respGetEntityGetI32 {
    x.Success = &value
    return x
}

func (x *respGetEntityGetI32) SetSuccess(value *int32) *respGetEntityGetI32 {
    x.Success = value
    return x
}

func (x *respGetEntityGetI32) IsSetSuccess() bool {
    return x != nil && x.Success != nil
}

func (x *respGetEntityGetI32) writeField0(p thrift.Protocol) error {  // Success
    if !x.IsSetSuccess() {
        return nil
    }

    if err := p.WriteFieldBegin("success", thrift.I32, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetSuccessNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetI32) readField0(p thrift.Protocol) error {  // Success
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetSuccessNonCompat(result)
    return nil
}

func (x *respGetEntityGetI32) toString0() string {  // Success
    if x.IsSetSuccess() {
        return fmt.Sprintf("%v", *x.GetSuccessNonCompat())
    }
    return fmt.Sprintf("%v", x.GetSuccessNonCompat())
}



// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetI32().Set<FieldNameFoo>().Set<FieldNameBar>()
type respGetEntityGetI32Builder struct {
    obj *respGetEntityGetI32
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetI32().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespGetEntityGetI32Builder() *respGetEntityGetI32Builder {
    return &respGetEntityGetI32Builder{
        obj: newRespGetEntityGetI32(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetI32().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetI32Builder) Success(value *int32) *respGetEntityGetI32Builder {
    x.obj.Success = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetI32().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetI32Builder) Emit() *respGetEntityGetI32 {
    var objCopy respGetEntityGetI32 = *x.obj
    return &objCopy
}

func (x *respGetEntityGetI32) Exception() thrift.WritableException {
    return nil
}

func (x *respGetEntityGetI32) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respGetEntityGetI32"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetI32) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 0 && wireType == thrift.Type(thrift.I32)):  // success
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respGetEntityGetI32) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respGetEntityGetI32({")
    sb.WriteString(fmt.Sprintf("Success:%s", x.toString0()))
    sb.WriteString("})")

    return sb.String()
}
type reqGetEntityGetI64 struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqGetEntityGetI64{}

type GetEntityGetI64Args = reqGetEntityGetI64

func newReqGetEntityGetI64() *reqGetEntityGetI64 {
    return (&reqGetEntityGetI64{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetI64().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqGetEntityGetI64Builder struct {
    obj *reqGetEntityGetI64
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetI64().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqGetEntityGetI64Builder() *reqGetEntityGetI64Builder {
    return &reqGetEntityGetI64Builder{
        obj: newReqGetEntityGetI64(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetI64().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetI64Builder) Emit() *reqGetEntityGetI64 {
    var objCopy reqGetEntityGetI64 = *x.obj
    return &objCopy
}

func (x *reqGetEntityGetI64) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqGetEntityGetI64"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetI64) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqGetEntityGetI64) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqGetEntityGetI64({")
    sb.WriteString("})")

    return sb.String()
}
type respGetEntityGetI64 struct {
    Success *int64 `thrift:"success,0,optional" json:"success,omitempty" db:"success"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respGetEntityGetI64{}
var _ thrift.WritableResult = &respGetEntityGetI64{}

type GetEntityGetI64Result = respGetEntityGetI64

func newRespGetEntityGetI64() *respGetEntityGetI64 {
    return (&respGetEntityGetI64{})
}

func (x *respGetEntityGetI64) GetSuccessNonCompat() *int64 {
    return x.Success
}

func (x *respGetEntityGetI64) GetSuccess() int64 {
    if !x.IsSetSuccess() {
        return 0
    }

    return *x.Success
}

func (x *respGetEntityGetI64) SetSuccessNonCompat(value int64) *respGetEntityGetI64 {
    x.Success = &value
    return x
}

func (x *respGetEntityGetI64) SetSuccess(value *int64) *respGetEntityGetI64 {
    x.Success = value
    return x
}

func (x *respGetEntityGetI64) IsSetSuccess() bool {
    return x != nil && x.Success != nil
}

func (x *respGetEntityGetI64) writeField0(p thrift.Protocol) error {  // Success
    if !x.IsSetSuccess() {
        return nil
    }

    if err := p.WriteFieldBegin("success", thrift.I64, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetSuccessNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetI64) readField0(p thrift.Protocol) error {  // Success
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetSuccessNonCompat(result)
    return nil
}

func (x *respGetEntityGetI64) toString0() string {  // Success
    if x.IsSetSuccess() {
        return fmt.Sprintf("%v", *x.GetSuccessNonCompat())
    }
    return fmt.Sprintf("%v", x.GetSuccessNonCompat())
}



// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetI64().Set<FieldNameFoo>().Set<FieldNameBar>()
type respGetEntityGetI64Builder struct {
    obj *respGetEntityGetI64
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetI64().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespGetEntityGetI64Builder() *respGetEntityGetI64Builder {
    return &respGetEntityGetI64Builder{
        obj: newRespGetEntityGetI64(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetI64().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetI64Builder) Success(value *int64) *respGetEntityGetI64Builder {
    x.obj.Success = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetI64().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetI64Builder) Emit() *respGetEntityGetI64 {
    var objCopy respGetEntityGetI64 = *x.obj
    return &objCopy
}

func (x *respGetEntityGetI64) Exception() thrift.WritableException {
    return nil
}

func (x *respGetEntityGetI64) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respGetEntityGetI64"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetI64) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 0 && wireType == thrift.Type(thrift.I64)):  // success
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respGetEntityGetI64) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respGetEntityGetI64({")
    sb.WriteString(fmt.Sprintf("Success:%s", x.toString0()))
    sb.WriteString("})")

    return sb.String()
}
type reqGetEntityGetDouble struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqGetEntityGetDouble{}

type GetEntityGetDoubleArgs = reqGetEntityGetDouble

func newReqGetEntityGetDouble() *reqGetEntityGetDouble {
    return (&reqGetEntityGetDouble{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetDouble().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqGetEntityGetDoubleBuilder struct {
    obj *reqGetEntityGetDouble
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetDouble().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqGetEntityGetDoubleBuilder() *reqGetEntityGetDoubleBuilder {
    return &reqGetEntityGetDoubleBuilder{
        obj: newReqGetEntityGetDouble(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetDouble().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetDoubleBuilder) Emit() *reqGetEntityGetDouble {
    var objCopy reqGetEntityGetDouble = *x.obj
    return &objCopy
}

func (x *reqGetEntityGetDouble) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqGetEntityGetDouble"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetDouble) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqGetEntityGetDouble) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqGetEntityGetDouble({")
    sb.WriteString("})")

    return sb.String()
}
type respGetEntityGetDouble struct {
    Success *float64 `thrift:"success,0,optional" json:"success,omitempty" db:"success"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respGetEntityGetDouble{}
var _ thrift.WritableResult = &respGetEntityGetDouble{}

type GetEntityGetDoubleResult = respGetEntityGetDouble

func newRespGetEntityGetDouble() *respGetEntityGetDouble {
    return (&respGetEntityGetDouble{})
}

func (x *respGetEntityGetDouble) GetSuccessNonCompat() *float64 {
    return x.Success
}

func (x *respGetEntityGetDouble) GetSuccess() float64 {
    if !x.IsSetSuccess() {
        return 0.0
    }

    return *x.Success
}

func (x *respGetEntityGetDouble) SetSuccessNonCompat(value float64) *respGetEntityGetDouble {
    x.Success = &value
    return x
}

func (x *respGetEntityGetDouble) SetSuccess(value *float64) *respGetEntityGetDouble {
    x.Success = value
    return x
}

func (x *respGetEntityGetDouble) IsSetSuccess() bool {
    return x != nil && x.Success != nil
}

func (x *respGetEntityGetDouble) writeField0(p thrift.Protocol) error {  // Success
    if !x.IsSetSuccess() {
        return nil
    }

    if err := p.WriteFieldBegin("success", thrift.DOUBLE, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetSuccessNonCompat()
    if err := p.WriteDouble(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetDouble) readField0(p thrift.Protocol) error {  // Success
    result, err := p.ReadDouble()
if err != nil {
    return err
}

    x.SetSuccessNonCompat(result)
    return nil
}

func (x *respGetEntityGetDouble) toString0() string {  // Success
    if x.IsSetSuccess() {
        return fmt.Sprintf("%v", *x.GetSuccessNonCompat())
    }
    return fmt.Sprintf("%v", x.GetSuccessNonCompat())
}



// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetDouble().Set<FieldNameFoo>().Set<FieldNameBar>()
type respGetEntityGetDoubleBuilder struct {
    obj *respGetEntityGetDouble
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetDouble().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespGetEntityGetDoubleBuilder() *respGetEntityGetDoubleBuilder {
    return &respGetEntityGetDoubleBuilder{
        obj: newRespGetEntityGetDouble(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetDouble().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetDoubleBuilder) Success(value *float64) *respGetEntityGetDoubleBuilder {
    x.obj.Success = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetDouble().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetDoubleBuilder) Emit() *respGetEntityGetDouble {
    var objCopy respGetEntityGetDouble = *x.obj
    return &objCopy
}

func (x *respGetEntityGetDouble) Exception() thrift.WritableException {
    return nil
}

func (x *respGetEntityGetDouble) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respGetEntityGetDouble"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetDouble) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 0 && wireType == thrift.Type(thrift.DOUBLE)):  // success
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respGetEntityGetDouble) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respGetEntityGetDouble({")
    sb.WriteString(fmt.Sprintf("Success:%s", x.toString0()))
    sb.WriteString("})")

    return sb.String()
}
type reqGetEntityGetString struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqGetEntityGetString{}

type GetEntityGetStringArgs = reqGetEntityGetString

func newReqGetEntityGetString() *reqGetEntityGetString {
    return (&reqGetEntityGetString{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetString().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqGetEntityGetStringBuilder struct {
    obj *reqGetEntityGetString
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetString().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqGetEntityGetStringBuilder() *reqGetEntityGetStringBuilder {
    return &reqGetEntityGetStringBuilder{
        obj: newReqGetEntityGetString(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetString().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetStringBuilder) Emit() *reqGetEntityGetString {
    var objCopy reqGetEntityGetString = *x.obj
    return &objCopy
}

func (x *reqGetEntityGetString) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqGetEntityGetString"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetString) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqGetEntityGetString) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqGetEntityGetString({")
    sb.WriteString("})")

    return sb.String()
}
type respGetEntityGetString struct {
    Success *string `thrift:"success,0,optional" json:"success,omitempty" db:"success"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respGetEntityGetString{}
var _ thrift.WritableResult = &respGetEntityGetString{}

type GetEntityGetStringResult = respGetEntityGetString

func newRespGetEntityGetString() *respGetEntityGetString {
    return (&respGetEntityGetString{})
}

func (x *respGetEntityGetString) GetSuccessNonCompat() *string {
    return x.Success
}

func (x *respGetEntityGetString) GetSuccess() string {
    if !x.IsSetSuccess() {
        return ""
    }

    return *x.Success
}

func (x *respGetEntityGetString) SetSuccessNonCompat(value string) *respGetEntityGetString {
    x.Success = &value
    return x
}

func (x *respGetEntityGetString) SetSuccess(value *string) *respGetEntityGetString {
    x.Success = value
    return x
}

func (x *respGetEntityGetString) IsSetSuccess() bool {
    return x != nil && x.Success != nil
}

func (x *respGetEntityGetString) writeField0(p thrift.Protocol) error {  // Success
    if !x.IsSetSuccess() {
        return nil
    }

    if err := p.WriteFieldBegin("success", thrift.STRING, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetSuccessNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetString) readField0(p thrift.Protocol) error {  // Success
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetSuccessNonCompat(result)
    return nil
}

func (x *respGetEntityGetString) toString0() string {  // Success
    if x.IsSetSuccess() {
        return fmt.Sprintf("%v", *x.GetSuccessNonCompat())
    }
    return fmt.Sprintf("%v", x.GetSuccessNonCompat())
}



// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetString().Set<FieldNameFoo>().Set<FieldNameBar>()
type respGetEntityGetStringBuilder struct {
    obj *respGetEntityGetString
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetString().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespGetEntityGetStringBuilder() *respGetEntityGetStringBuilder {
    return &respGetEntityGetStringBuilder{
        obj: newRespGetEntityGetString(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetString().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetStringBuilder) Success(value *string) *respGetEntityGetStringBuilder {
    x.obj.Success = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetString().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetStringBuilder) Emit() *respGetEntityGetString {
    var objCopy respGetEntityGetString = *x.obj
    return &objCopy
}

func (x *respGetEntityGetString) Exception() thrift.WritableException {
    return nil
}

func (x *respGetEntityGetString) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respGetEntityGetString"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetString) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 0 && wireType == thrift.Type(thrift.STRING)):  // success
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respGetEntityGetString) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respGetEntityGetString({")
    sb.WriteString(fmt.Sprintf("Success:%s", x.toString0()))
    sb.WriteString("})")

    return sb.String()
}
type reqGetEntityGetBinary struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqGetEntityGetBinary{}

type GetEntityGetBinaryArgs = reqGetEntityGetBinary

func newReqGetEntityGetBinary() *reqGetEntityGetBinary {
    return (&reqGetEntityGetBinary{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetBinary().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqGetEntityGetBinaryBuilder struct {
    obj *reqGetEntityGetBinary
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetBinary().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqGetEntityGetBinaryBuilder() *reqGetEntityGetBinaryBuilder {
    return &reqGetEntityGetBinaryBuilder{
        obj: newReqGetEntityGetBinary(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetBinary().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetBinaryBuilder) Emit() *reqGetEntityGetBinary {
    var objCopy reqGetEntityGetBinary = *x.obj
    return &objCopy
}

func (x *reqGetEntityGetBinary) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqGetEntityGetBinary"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetBinary) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqGetEntityGetBinary) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqGetEntityGetBinary({")
    sb.WriteString("})")

    return sb.String()
}
type respGetEntityGetBinary struct {
    Success []byte `thrift:"success,0,optional" json:"success,omitempty" db:"success"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respGetEntityGetBinary{}
var _ thrift.WritableResult = &respGetEntityGetBinary{}

type GetEntityGetBinaryResult = respGetEntityGetBinary

func newRespGetEntityGetBinary() *respGetEntityGetBinary {
    return (&respGetEntityGetBinary{})
}

func (x *respGetEntityGetBinary) GetSuccessNonCompat() []byte {
    return x.Success
}

func (x *respGetEntityGetBinary) GetSuccess() []byte {
    if !x.IsSetSuccess() {
        return []byte("")
    }

    return x.Success
}

func (x *respGetEntityGetBinary) SetSuccessNonCompat(value []byte) *respGetEntityGetBinary {
    x.Success = value
    return x
}

func (x *respGetEntityGetBinary) SetSuccess(value []byte) *respGetEntityGetBinary {
    x.Success = value
    return x
}

func (x *respGetEntityGetBinary) IsSetSuccess() bool {
    return x != nil && x.Success != nil
}

func (x *respGetEntityGetBinary) writeField0(p thrift.Protocol) error {  // Success
    if !x.IsSetSuccess() {
        return nil
    }

    if err := p.WriteFieldBegin("success", thrift.STRING, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetSuccessNonCompat()
    if err := p.WriteBinary(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetBinary) readField0(p thrift.Protocol) error {  // Success
    result, err := p.ReadBinary()
if err != nil {
    return err
}

    x.SetSuccessNonCompat(result)
    return nil
}

func (x *respGetEntityGetBinary) toString0() string {  // Success
    return fmt.Sprintf("%v", x.GetSuccessNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetBinary().Set<FieldNameFoo>().Set<FieldNameBar>()
type respGetEntityGetBinaryBuilder struct {
    obj *respGetEntityGetBinary
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetBinary().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespGetEntityGetBinaryBuilder() *respGetEntityGetBinaryBuilder {
    return &respGetEntityGetBinaryBuilder{
        obj: newRespGetEntityGetBinary(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetBinary().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetBinaryBuilder) Success(value []byte) *respGetEntityGetBinaryBuilder {
    x.obj.Success = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetBinary().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetBinaryBuilder) Emit() *respGetEntityGetBinary {
    var objCopy respGetEntityGetBinary = *x.obj
    return &objCopy
}

func (x *respGetEntityGetBinary) Exception() thrift.WritableException {
    return nil
}

func (x *respGetEntityGetBinary) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respGetEntityGetBinary"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetBinary) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 0 && wireType == thrift.Type(thrift.STRING)):  // success
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respGetEntityGetBinary) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respGetEntityGetBinary({")
    sb.WriteString(fmt.Sprintf("Success:%s", x.toString0()))
    sb.WriteString("})")

    return sb.String()
}
type reqGetEntityGetMap struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqGetEntityGetMap{}

type GetEntityGetMapArgs = reqGetEntityGetMap

func newReqGetEntityGetMap() *reqGetEntityGetMap {
    return (&reqGetEntityGetMap{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetMap().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqGetEntityGetMapBuilder struct {
    obj *reqGetEntityGetMap
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetMap().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqGetEntityGetMapBuilder() *reqGetEntityGetMapBuilder {
    return &reqGetEntityGetMapBuilder{
        obj: newReqGetEntityGetMap(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetMap().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetMapBuilder) Emit() *reqGetEntityGetMap {
    var objCopy reqGetEntityGetMap = *x.obj
    return &objCopy
}

func (x *reqGetEntityGetMap) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqGetEntityGetMap"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetMap) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqGetEntityGetMap) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqGetEntityGetMap({")
    sb.WriteString("})")

    return sb.String()
}
type respGetEntityGetMap struct {
    Success map[string]string `thrift:"success,0,optional" json:"success,omitempty" db:"success"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respGetEntityGetMap{}
var _ thrift.WritableResult = &respGetEntityGetMap{}

type GetEntityGetMapResult = respGetEntityGetMap

func newRespGetEntityGetMap() *respGetEntityGetMap {
    return (&respGetEntityGetMap{})
}

func (x *respGetEntityGetMap) GetSuccessNonCompat() map[string]string {
    return x.Success
}

func (x *respGetEntityGetMap) GetSuccess() map[string]string {
    if !x.IsSetSuccess() {
        return make(map[string]string)
    }

    return x.Success
}

func (x *respGetEntityGetMap) SetSuccessNonCompat(value map[string]string) *respGetEntityGetMap {
    x.Success = value
    return x
}

func (x *respGetEntityGetMap) SetSuccess(value map[string]string) *respGetEntityGetMap {
    x.Success = value
    return x
}

func (x *respGetEntityGetMap) IsSetSuccess() bool {
    return x != nil && x.Success != nil
}

func (x *respGetEntityGetMap) writeField0(p thrift.Protocol) error {  // Success
    if !x.IsSetSuccess() {
        return nil
    }

    if err := p.WriteFieldBegin("success", thrift.MAP, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetSuccessNonCompat()
    if err := p.WriteMapBegin(thrift.STRING, thrift.STRING, len(item)); err != nil {
    return thrift.PrependError("error writing map begin: ", err)
}
for k, v := range item {
    {
        item := k
        if err := p.WriteString(item); err != nil {
    return err
}
    }

    {
        item := v
        if err := p.WriteString(item); err != nil {
    return err
}
    }
}
if err := p.WriteMapEnd(); err != nil {
    return thrift.PrependError("error writing map end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetMap) readField0(p thrift.Protocol) error {  // Success
    _ /* keyType */, _ /* valueType */, size, err := p.ReadMapBegin()
if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
}

mapResult := make(map[string]string, size)
for i := 0; i < size; i++ {
    var key string
    {
        result, err := p.ReadString()
if err != nil {
    return err
}
        key = result
    }

    var value string
    {
        result, err := p.ReadString()
if err != nil {
    return err
}
        value = result
    }

    mapResult[key] = value
}

if err := p.ReadMapEnd(); err != nil {
    return thrift.PrependError("error reading map end: ", err)
}
result := mapResult

    x.SetSuccessNonCompat(result)
    return nil
}

func (x *respGetEntityGetMap) toString0() string {  // Success
    return fmt.Sprintf("%v", x.GetSuccessNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetMap().Set<FieldNameFoo>().Set<FieldNameBar>()
type respGetEntityGetMapBuilder struct {
    obj *respGetEntityGetMap
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetMap().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespGetEntityGetMapBuilder() *respGetEntityGetMapBuilder {
    return &respGetEntityGetMapBuilder{
        obj: newRespGetEntityGetMap(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetMap().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetMapBuilder) Success(value map[string]string) *respGetEntityGetMapBuilder {
    x.obj.Success = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetMap().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetMapBuilder) Emit() *respGetEntityGetMap {
    var objCopy respGetEntityGetMap = *x.obj
    return &objCopy
}

func (x *respGetEntityGetMap) Exception() thrift.WritableException {
    return nil
}

func (x *respGetEntityGetMap) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respGetEntityGetMap"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetMap) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 0 && wireType == thrift.Type(thrift.MAP)):  // success
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respGetEntityGetMap) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respGetEntityGetMap({")
    sb.WriteString(fmt.Sprintf("Success:%s", x.toString0()))
    sb.WriteString("})")

    return sb.String()
}
type reqGetEntityGetSet struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqGetEntityGetSet{}

type GetEntityGetSetArgs = reqGetEntityGetSet

func newReqGetEntityGetSet() *reqGetEntityGetSet {
    return (&reqGetEntityGetSet{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetSet().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqGetEntityGetSetBuilder struct {
    obj *reqGetEntityGetSet
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetSet().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqGetEntityGetSetBuilder() *reqGetEntityGetSetBuilder {
    return &reqGetEntityGetSetBuilder{
        obj: newReqGetEntityGetSet(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetSet().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetSetBuilder) Emit() *reqGetEntityGetSet {
    var objCopy reqGetEntityGetSet = *x.obj
    return &objCopy
}

func (x *reqGetEntityGetSet) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqGetEntityGetSet"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetSet) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqGetEntityGetSet) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqGetEntityGetSet({")
    sb.WriteString("})")

    return sb.String()
}
type respGetEntityGetSet struct {
    Success []string `thrift:"success,0,optional" json:"success,omitempty" db:"success"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respGetEntityGetSet{}
var _ thrift.WritableResult = &respGetEntityGetSet{}

type GetEntityGetSetResult = respGetEntityGetSet

func newRespGetEntityGetSet() *respGetEntityGetSet {
    return (&respGetEntityGetSet{})
}

func (x *respGetEntityGetSet) GetSuccessNonCompat() []string {
    return x.Success
}

func (x *respGetEntityGetSet) GetSuccess() []string {
    if !x.IsSetSuccess() {
        return make([]string, 0)
    }

    return x.Success
}

func (x *respGetEntityGetSet) SetSuccessNonCompat(value []string) *respGetEntityGetSet {
    x.Success = value
    return x
}

func (x *respGetEntityGetSet) SetSuccess(value []string) *respGetEntityGetSet {
    x.Success = value
    return x
}

func (x *respGetEntityGetSet) IsSetSuccess() bool {
    return x != nil && x.Success != nil
}

func (x *respGetEntityGetSet) writeField0(p thrift.Protocol) error {  // Success
    if !x.IsSetSuccess() {
        return nil
    }

    if err := p.WriteFieldBegin("success", thrift.SET, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetSuccessNonCompat()
    if err := p.WriteSetBegin(thrift.STRING, len(item)); err != nil {
    return thrift.PrependError("error writing set begin: ", err)
}
for _, v := range item {
    {
        item := v
        if err := p.WriteString(item); err != nil {
    return err
}
    }
}
if err := p.WriteSetEnd(); err != nil {
    return thrift.PrependError("error writing set end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetSet) readField0(p thrift.Protocol) error {  // Success
    _ /* elemType */, size, err := p.ReadSetBegin()
if err != nil {
    return thrift.PrependError("error reading set begin: ", err)
}

setResult := make([]string, 0, size)
for i := 0; i < size; i++ {
    var elem string
    {
        result, err := p.ReadString()
if err != nil {
    return err
}
        elem = result
    }
    setResult = append(setResult, elem)
}

if err := p.ReadSetEnd(); err != nil {
    return thrift.PrependError("error reading set end: ", err)
}
result := setResult

    x.SetSuccessNonCompat(result)
    return nil
}

func (x *respGetEntityGetSet) toString0() string {  // Success
    return fmt.Sprintf("%v", x.GetSuccessNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetSet().Set<FieldNameFoo>().Set<FieldNameBar>()
type respGetEntityGetSetBuilder struct {
    obj *respGetEntityGetSet
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetSet().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespGetEntityGetSetBuilder() *respGetEntityGetSetBuilder {
    return &respGetEntityGetSetBuilder{
        obj: newRespGetEntityGetSet(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetSet().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetSetBuilder) Success(value []string) *respGetEntityGetSetBuilder {
    x.obj.Success = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetSet().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetSetBuilder) Emit() *respGetEntityGetSet {
    var objCopy respGetEntityGetSet = *x.obj
    return &objCopy
}

func (x *respGetEntityGetSet) Exception() thrift.WritableException {
    return nil
}

func (x *respGetEntityGetSet) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respGetEntityGetSet"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetSet) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 0 && wireType == thrift.Type(thrift.SET)):  // success
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respGetEntityGetSet) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respGetEntityGetSet({")
    sb.WriteString(fmt.Sprintf("Success:%s", x.toString0()))
    sb.WriteString("})")

    return sb.String()
}
type reqGetEntityGetList struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqGetEntityGetList{}

type GetEntityGetListArgs = reqGetEntityGetList

func newReqGetEntityGetList() *reqGetEntityGetList {
    return (&reqGetEntityGetList{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetList().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqGetEntityGetListBuilder struct {
    obj *reqGetEntityGetList
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetList().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqGetEntityGetListBuilder() *reqGetEntityGetListBuilder {
    return &reqGetEntityGetListBuilder{
        obj: newReqGetEntityGetList(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetList().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetListBuilder) Emit() *reqGetEntityGetList {
    var objCopy reqGetEntityGetList = *x.obj
    return &objCopy
}

func (x *reqGetEntityGetList) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqGetEntityGetList"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetList) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqGetEntityGetList) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqGetEntityGetList({")
    sb.WriteString("})")

    return sb.String()
}
type respGetEntityGetList struct {
    Success []string `thrift:"success,0,optional" json:"success,omitempty" db:"success"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respGetEntityGetList{}
var _ thrift.WritableResult = &respGetEntityGetList{}

type GetEntityGetListResult = respGetEntityGetList

func newRespGetEntityGetList() *respGetEntityGetList {
    return (&respGetEntityGetList{})
}

func (x *respGetEntityGetList) GetSuccessNonCompat() []string {
    return x.Success
}

func (x *respGetEntityGetList) GetSuccess() []string {
    if !x.IsSetSuccess() {
        return make([]string, 0)
    }

    return x.Success
}

func (x *respGetEntityGetList) SetSuccessNonCompat(value []string) *respGetEntityGetList {
    x.Success = value
    return x
}

func (x *respGetEntityGetList) SetSuccess(value []string) *respGetEntityGetList {
    x.Success = value
    return x
}

func (x *respGetEntityGetList) IsSetSuccess() bool {
    return x != nil && x.Success != nil
}

func (x *respGetEntityGetList) writeField0(p thrift.Protocol) error {  // Success
    if !x.IsSetSuccess() {
        return nil
    }

    if err := p.WriteFieldBegin("success", thrift.LIST, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetSuccessNonCompat()
    if err := p.WriteListBegin(thrift.STRING, len(item)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
}
for _, v := range item {
    {
        item := v
        if err := p.WriteString(item); err != nil {
    return err
}
    }
}
if err := p.WriteListEnd(); err != nil {
    return thrift.PrependError("error writing list end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetList) readField0(p thrift.Protocol) error {  // Success
    _ /* elemType */, size, err := p.ReadListBegin()
if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
}

listResult := make([]string, 0, size)
for i := 0; i < size; i++ {
    var elem string
    {
        result, err := p.ReadString()
if err != nil {
    return err
}
        elem = result
    }
    listResult = append(listResult, elem)
}

if err := p.ReadListEnd(); err != nil {
    return thrift.PrependError("error reading list end: ", err)
}
result := listResult

    x.SetSuccessNonCompat(result)
    return nil
}

func (x *respGetEntityGetList) toString0() string {  // Success
    return fmt.Sprintf("%v", x.GetSuccessNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetList().Set<FieldNameFoo>().Set<FieldNameBar>()
type respGetEntityGetListBuilder struct {
    obj *respGetEntityGetList
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetList().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespGetEntityGetListBuilder() *respGetEntityGetListBuilder {
    return &respGetEntityGetListBuilder{
        obj: newRespGetEntityGetList(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetList().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetListBuilder) Success(value []string) *respGetEntityGetListBuilder {
    x.obj.Success = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetList().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetListBuilder) Emit() *respGetEntityGetList {
    var objCopy respGetEntityGetList = *x.obj
    return &objCopy
}

func (x *respGetEntityGetList) Exception() thrift.WritableException {
    return nil
}

func (x *respGetEntityGetList) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respGetEntityGetList"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetList) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 0 && wireType == thrift.Type(thrift.LIST)):  // success
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respGetEntityGetList) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respGetEntityGetList({")
    sb.WriteString(fmt.Sprintf("Success:%s", x.toString0()))
    sb.WriteString("})")

    return sb.String()
}
type reqGetEntityGetLegacyStuff struct {
    NumNeg2 int64 `thrift:"numNeg2,-2" json:"numNeg2" db:"numNeg2"`
    NumNeg1 int64 `thrift:"numNeg1,-1" json:"numNeg1" db:"numNeg1"`
    NumPos int64 `thrift:"numPos,1" json:"numPos" db:"numPos"`
}
// Compile time interface enforcer
var _ thrift.Struct = &reqGetEntityGetLegacyStuff{}

type GetEntityGetLegacyStuffArgs = reqGetEntityGetLegacyStuff

func newReqGetEntityGetLegacyStuff() *reqGetEntityGetLegacyStuff {
    return (&reqGetEntityGetLegacyStuff{}).
        SetNumNeg2NonCompat(0).
        SetNumNeg1NonCompat(0).
        SetNumPosNonCompat(0)
}

func (x *reqGetEntityGetLegacyStuff) GetNumNeg2NonCompat() int64 {
    return x.NumNeg2
}

func (x *reqGetEntityGetLegacyStuff) GetNumNeg2() int64 {
    return x.NumNeg2
}

func (x *reqGetEntityGetLegacyStuff) GetNumNeg1NonCompat() int64 {
    return x.NumNeg1
}

func (x *reqGetEntityGetLegacyStuff) GetNumNeg1() int64 {
    return x.NumNeg1
}

func (x *reqGetEntityGetLegacyStuff) GetNumPosNonCompat() int64 {
    return x.NumPos
}

func (x *reqGetEntityGetLegacyStuff) GetNumPos() int64 {
    return x.NumPos
}

func (x *reqGetEntityGetLegacyStuff) SetNumNeg2NonCompat(value int64) *reqGetEntityGetLegacyStuff {
    x.NumNeg2 = value
    return x
}

func (x *reqGetEntityGetLegacyStuff) SetNumNeg2(value int64) *reqGetEntityGetLegacyStuff {
    x.NumNeg2 = value
    return x
}

func (x *reqGetEntityGetLegacyStuff) SetNumNeg1NonCompat(value int64) *reqGetEntityGetLegacyStuff {
    x.NumNeg1 = value
    return x
}

func (x *reqGetEntityGetLegacyStuff) SetNumNeg1(value int64) *reqGetEntityGetLegacyStuff {
    x.NumNeg1 = value
    return x
}

func (x *reqGetEntityGetLegacyStuff) SetNumPosNonCompat(value int64) *reqGetEntityGetLegacyStuff {
    x.NumPos = value
    return x
}

func (x *reqGetEntityGetLegacyStuff) SetNumPos(value int64) *reqGetEntityGetLegacyStuff {
    x.NumPos = value
    return x
}

func (x *reqGetEntityGetLegacyStuff) writeField_2(p thrift.Protocol) error {  // NumNeg2
    if err := p.WriteFieldBegin("numNeg2", thrift.I64, -2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetNumNeg2NonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetLegacyStuff) writeField_1(p thrift.Protocol) error {  // NumNeg1
    if err := p.WriteFieldBegin("numNeg1", thrift.I64, -1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetNumNeg1NonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetLegacyStuff) writeField1(p thrift.Protocol) error {  // NumPos
    if err := p.WriteFieldBegin("numPos", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetNumPosNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetLegacyStuff) readField_2(p thrift.Protocol) error {  // NumNeg2
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetNumNeg2NonCompat(result)
    return nil
}

func (x *reqGetEntityGetLegacyStuff) readField_1(p thrift.Protocol) error {  // NumNeg1
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetNumNeg1NonCompat(result)
    return nil
}

func (x *reqGetEntityGetLegacyStuff) readField1(p thrift.Protocol) error {  // NumPos
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetNumPosNonCompat(result)
    return nil
}

func (x *reqGetEntityGetLegacyStuff) toString_2() string {  // NumNeg2
    return fmt.Sprintf("%v", x.GetNumNeg2NonCompat())
}

func (x *reqGetEntityGetLegacyStuff) toString_1() string {  // NumNeg1
    return fmt.Sprintf("%v", x.GetNumNeg1NonCompat())
}

func (x *reqGetEntityGetLegacyStuff) toString1() string {  // NumPos
    return fmt.Sprintf("%v", x.GetNumPosNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetLegacyStuff().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqGetEntityGetLegacyStuffBuilder struct {
    obj *reqGetEntityGetLegacyStuff
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetLegacyStuff().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqGetEntityGetLegacyStuffBuilder() *reqGetEntityGetLegacyStuffBuilder {
    return &reqGetEntityGetLegacyStuffBuilder{
        obj: newReqGetEntityGetLegacyStuff(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetLegacyStuff().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetLegacyStuffBuilder) NumNeg2(value int64) *reqGetEntityGetLegacyStuffBuilder {
    x.obj.NumNeg2 = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetLegacyStuff().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetLegacyStuffBuilder) NumNeg1(value int64) *reqGetEntityGetLegacyStuffBuilder {
    x.obj.NumNeg1 = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetLegacyStuff().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetLegacyStuffBuilder) NumPos(value int64) *reqGetEntityGetLegacyStuffBuilder {
    x.obj.NumPos = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetLegacyStuff().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetLegacyStuffBuilder) Emit() *reqGetEntityGetLegacyStuff {
    var objCopy reqGetEntityGetLegacyStuff = *x.obj
    return &objCopy
}

func (x *reqGetEntityGetLegacyStuff) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqGetEntityGetLegacyStuff"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField_2(p); err != nil {
        return err
    }

    if err := x.writeField_1(p); err != nil {
        return err
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetLegacyStuff) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == -2 && wireType == thrift.Type(thrift.I64)):  // numNeg2
            if err := x.readField_2(p); err != nil {
                return err
            }
        case (id == -1 && wireType == thrift.Type(thrift.I64)):  // numNeg1
            if err := x.readField_1(p); err != nil {
                return err
            }
        case (id == 1 && wireType == thrift.Type(thrift.I64)):  // numPos
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqGetEntityGetLegacyStuff) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqGetEntityGetLegacyStuff({")
    sb.WriteString(fmt.Sprintf("NumNeg2:%s ", x.toString_2()))
    sb.WriteString(fmt.Sprintf("NumNeg1:%s ", x.toString_1()))
    sb.WriteString(fmt.Sprintf("NumPos:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}
type respGetEntityGetLegacyStuff struct {
    Success *int32 `thrift:"success,0,optional" json:"success,omitempty" db:"success"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respGetEntityGetLegacyStuff{}
var _ thrift.WritableResult = &respGetEntityGetLegacyStuff{}

type GetEntityGetLegacyStuffResult = respGetEntityGetLegacyStuff

func newRespGetEntityGetLegacyStuff() *respGetEntityGetLegacyStuff {
    return (&respGetEntityGetLegacyStuff{})
}

func (x *respGetEntityGetLegacyStuff) GetSuccessNonCompat() *int32 {
    return x.Success
}

func (x *respGetEntityGetLegacyStuff) GetSuccess() int32 {
    if !x.IsSetSuccess() {
        return 0
    }

    return *x.Success
}

func (x *respGetEntityGetLegacyStuff) SetSuccessNonCompat(value int32) *respGetEntityGetLegacyStuff {
    x.Success = &value
    return x
}

func (x *respGetEntityGetLegacyStuff) SetSuccess(value *int32) *respGetEntityGetLegacyStuff {
    x.Success = value
    return x
}

func (x *respGetEntityGetLegacyStuff) IsSetSuccess() bool {
    return x != nil && x.Success != nil
}

func (x *respGetEntityGetLegacyStuff) writeField0(p thrift.Protocol) error {  // Success
    if !x.IsSetSuccess() {
        return nil
    }

    if err := p.WriteFieldBegin("success", thrift.I32, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetSuccessNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetLegacyStuff) readField0(p thrift.Protocol) error {  // Success
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetSuccessNonCompat(result)
    return nil
}

func (x *respGetEntityGetLegacyStuff) toString0() string {  // Success
    if x.IsSetSuccess() {
        return fmt.Sprintf("%v", *x.GetSuccessNonCompat())
    }
    return fmt.Sprintf("%v", x.GetSuccessNonCompat())
}



// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetLegacyStuff().Set<FieldNameFoo>().Set<FieldNameBar>()
type respGetEntityGetLegacyStuffBuilder struct {
    obj *respGetEntityGetLegacyStuff
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetLegacyStuff().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespGetEntityGetLegacyStuffBuilder() *respGetEntityGetLegacyStuffBuilder {
    return &respGetEntityGetLegacyStuffBuilder{
        obj: newRespGetEntityGetLegacyStuff(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetLegacyStuff().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetLegacyStuffBuilder) Success(value *int32) *respGetEntityGetLegacyStuffBuilder {
    x.obj.Success = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetLegacyStuff().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetLegacyStuffBuilder) Emit() *respGetEntityGetLegacyStuff {
    var objCopy respGetEntityGetLegacyStuff = *x.obj
    return &objCopy
}

func (x *respGetEntityGetLegacyStuff) Exception() thrift.WritableException {
    return nil
}

func (x *respGetEntityGetLegacyStuff) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respGetEntityGetLegacyStuff"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetLegacyStuff) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 0 && wireType == thrift.Type(thrift.I32)):  // success
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respGetEntityGetLegacyStuff) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respGetEntityGetLegacyStuff({")
    sb.WriteString(fmt.Sprintf("Success:%s", x.toString0()))
    sb.WriteString("})")

    return sb.String()
}
type reqGetEntityGetCtxCollision struct {
    Ctx int64 `thrift:"ctx,1" json:"ctx" db:"ctx"`
}
// Compile time interface enforcer
var _ thrift.Struct = &reqGetEntityGetCtxCollision{}

type GetEntityGetCtxCollisionArgs = reqGetEntityGetCtxCollision

func newReqGetEntityGetCtxCollision() *reqGetEntityGetCtxCollision {
    return (&reqGetEntityGetCtxCollision{}).
        SetCtxNonCompat(0)
}

func (x *reqGetEntityGetCtxCollision) GetCtxNonCompat() int64 {
    return x.Ctx
}

func (x *reqGetEntityGetCtxCollision) GetCtx() int64 {
    return x.Ctx
}

func (x *reqGetEntityGetCtxCollision) SetCtxNonCompat(value int64) *reqGetEntityGetCtxCollision {
    x.Ctx = value
    return x
}

func (x *reqGetEntityGetCtxCollision) SetCtx(value int64) *reqGetEntityGetCtxCollision {
    x.Ctx = value
    return x
}

func (x *reqGetEntityGetCtxCollision) writeField1(p thrift.Protocol) error {  // Ctx
    if err := p.WriteFieldBegin("ctx", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetCtxNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetCtxCollision) readField1(p thrift.Protocol) error {  // Ctx
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetCtxNonCompat(result)
    return nil
}

func (x *reqGetEntityGetCtxCollision) toString1() string {  // Ctx
    return fmt.Sprintf("%v", x.GetCtxNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetCtxCollision().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqGetEntityGetCtxCollisionBuilder struct {
    obj *reqGetEntityGetCtxCollision
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetCtxCollision().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqGetEntityGetCtxCollisionBuilder() *reqGetEntityGetCtxCollisionBuilder {
    return &reqGetEntityGetCtxCollisionBuilder{
        obj: newReqGetEntityGetCtxCollision(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetCtxCollision().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetCtxCollisionBuilder) Ctx(value int64) *reqGetEntityGetCtxCollisionBuilder {
    x.obj.Ctx = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetCtxCollision().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetCtxCollisionBuilder) Emit() *reqGetEntityGetCtxCollision {
    var objCopy reqGetEntityGetCtxCollision = *x.obj
    return &objCopy
}

func (x *reqGetEntityGetCtxCollision) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqGetEntityGetCtxCollision"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetCtxCollision) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I64)):  // ctx
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqGetEntityGetCtxCollision) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqGetEntityGetCtxCollision({")
    sb.WriteString(fmt.Sprintf("Ctx:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}
type respGetEntityGetCtxCollision struct {
    Success *int32 `thrift:"success,0,optional" json:"success,omitempty" db:"success"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respGetEntityGetCtxCollision{}
var _ thrift.WritableResult = &respGetEntityGetCtxCollision{}

type GetEntityGetCtxCollisionResult = respGetEntityGetCtxCollision

func newRespGetEntityGetCtxCollision() *respGetEntityGetCtxCollision {
    return (&respGetEntityGetCtxCollision{})
}

func (x *respGetEntityGetCtxCollision) GetSuccessNonCompat() *int32 {
    return x.Success
}

func (x *respGetEntityGetCtxCollision) GetSuccess() int32 {
    if !x.IsSetSuccess() {
        return 0
    }

    return *x.Success
}

func (x *respGetEntityGetCtxCollision) SetSuccessNonCompat(value int32) *respGetEntityGetCtxCollision {
    x.Success = &value
    return x
}

func (x *respGetEntityGetCtxCollision) SetSuccess(value *int32) *respGetEntityGetCtxCollision {
    x.Success = value
    return x
}

func (x *respGetEntityGetCtxCollision) IsSetSuccess() bool {
    return x != nil && x.Success != nil
}

func (x *respGetEntityGetCtxCollision) writeField0(p thrift.Protocol) error {  // Success
    if !x.IsSetSuccess() {
        return nil
    }

    if err := p.WriteFieldBegin("success", thrift.I32, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetSuccessNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetCtxCollision) readField0(p thrift.Protocol) error {  // Success
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetSuccessNonCompat(result)
    return nil
}

func (x *respGetEntityGetCtxCollision) toString0() string {  // Success
    if x.IsSetSuccess() {
        return fmt.Sprintf("%v", *x.GetSuccessNonCompat())
    }
    return fmt.Sprintf("%v", x.GetSuccessNonCompat())
}



// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetCtxCollision().Set<FieldNameFoo>().Set<FieldNameBar>()
type respGetEntityGetCtxCollisionBuilder struct {
    obj *respGetEntityGetCtxCollision
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetCtxCollision().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespGetEntityGetCtxCollisionBuilder() *respGetEntityGetCtxCollisionBuilder {
    return &respGetEntityGetCtxCollisionBuilder{
        obj: newRespGetEntityGetCtxCollision(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetCtxCollision().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetCtxCollisionBuilder) Success(value *int32) *respGetEntityGetCtxCollisionBuilder {
    x.obj.Success = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetCtxCollision().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetCtxCollisionBuilder) Emit() *respGetEntityGetCtxCollision {
    var objCopy respGetEntityGetCtxCollision = *x.obj
    return &objCopy
}

func (x *respGetEntityGetCtxCollision) Exception() thrift.WritableException {
    return nil
}

func (x *respGetEntityGetCtxCollision) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respGetEntityGetCtxCollision"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetCtxCollision) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 0 && wireType == thrift.Type(thrift.I32)):  // success
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respGetEntityGetCtxCollision) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respGetEntityGetCtxCollision({")
    sb.WriteString(fmt.Sprintf("Success:%s", x.toString0()))
    sb.WriteString("})")

    return sb.String()
}
type reqGetEntityGetCtx1Collision struct {
    Ctx int64 `thrift:"ctx,1" json:"ctx" db:"ctx"`
    Ctx1 int64 `thrift:"ctx1,2" json:"ctx1" db:"ctx1"`
}
// Compile time interface enforcer
var _ thrift.Struct = &reqGetEntityGetCtx1Collision{}

type GetEntityGetCtx1CollisionArgs = reqGetEntityGetCtx1Collision

func newReqGetEntityGetCtx1Collision() *reqGetEntityGetCtx1Collision {
    return (&reqGetEntityGetCtx1Collision{}).
        SetCtxNonCompat(0).
        SetCtx1NonCompat(0)
}

func (x *reqGetEntityGetCtx1Collision) GetCtxNonCompat() int64 {
    return x.Ctx
}

func (x *reqGetEntityGetCtx1Collision) GetCtx() int64 {
    return x.Ctx
}

func (x *reqGetEntityGetCtx1Collision) GetCtx1NonCompat() int64 {
    return x.Ctx1
}

func (x *reqGetEntityGetCtx1Collision) GetCtx1() int64 {
    return x.Ctx1
}

func (x *reqGetEntityGetCtx1Collision) SetCtxNonCompat(value int64) *reqGetEntityGetCtx1Collision {
    x.Ctx = value
    return x
}

func (x *reqGetEntityGetCtx1Collision) SetCtx(value int64) *reqGetEntityGetCtx1Collision {
    x.Ctx = value
    return x
}

func (x *reqGetEntityGetCtx1Collision) SetCtx1NonCompat(value int64) *reqGetEntityGetCtx1Collision {
    x.Ctx1 = value
    return x
}

func (x *reqGetEntityGetCtx1Collision) SetCtx1(value int64) *reqGetEntityGetCtx1Collision {
    x.Ctx1 = value
    return x
}

func (x *reqGetEntityGetCtx1Collision) writeField1(p thrift.Protocol) error {  // Ctx
    if err := p.WriteFieldBegin("ctx", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetCtxNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetCtx1Collision) writeField2(p thrift.Protocol) error {  // Ctx1
    if err := p.WriteFieldBegin("ctx1", thrift.I64, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetCtx1NonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetCtx1Collision) readField1(p thrift.Protocol) error {  // Ctx
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetCtxNonCompat(result)
    return nil
}

func (x *reqGetEntityGetCtx1Collision) readField2(p thrift.Protocol) error {  // Ctx1
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetCtx1NonCompat(result)
    return nil
}

func (x *reqGetEntityGetCtx1Collision) toString1() string {  // Ctx
    return fmt.Sprintf("%v", x.GetCtxNonCompat())
}

func (x *reqGetEntityGetCtx1Collision) toString2() string {  // Ctx1
    return fmt.Sprintf("%v", x.GetCtx1NonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetCtx1Collision().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqGetEntityGetCtx1CollisionBuilder struct {
    obj *reqGetEntityGetCtx1Collision
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetCtx1Collision().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqGetEntityGetCtx1CollisionBuilder() *reqGetEntityGetCtx1CollisionBuilder {
    return &reqGetEntityGetCtx1CollisionBuilder{
        obj: newReqGetEntityGetCtx1Collision(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetCtx1Collision().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetCtx1CollisionBuilder) Ctx(value int64) *reqGetEntityGetCtx1CollisionBuilder {
    x.obj.Ctx = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetCtx1Collision().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetCtx1CollisionBuilder) Ctx1(value int64) *reqGetEntityGetCtx1CollisionBuilder {
    x.obj.Ctx1 = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqGetEntityGetCtx1Collision().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqGetEntityGetCtx1CollisionBuilder) Emit() *reqGetEntityGetCtx1Collision {
    var objCopy reqGetEntityGetCtx1Collision = *x.obj
    return &objCopy
}

func (x *reqGetEntityGetCtx1Collision) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqGetEntityGetCtx1Collision"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqGetEntityGetCtx1Collision) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I64)):  // ctx
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.I64)):  // ctx1
            if err := x.readField2(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqGetEntityGetCtx1Collision) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqGetEntityGetCtx1Collision({")
    sb.WriteString(fmt.Sprintf("Ctx:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("Ctx1:%s", x.toString2()))
    sb.WriteString("})")

    return sb.String()
}
type respGetEntityGetCtx1Collision struct {
    Success *int32 `thrift:"success,0,optional" json:"success,omitempty" db:"success"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respGetEntityGetCtx1Collision{}
var _ thrift.WritableResult = &respGetEntityGetCtx1Collision{}

type GetEntityGetCtx1CollisionResult = respGetEntityGetCtx1Collision

func newRespGetEntityGetCtx1Collision() *respGetEntityGetCtx1Collision {
    return (&respGetEntityGetCtx1Collision{})
}

func (x *respGetEntityGetCtx1Collision) GetSuccessNonCompat() *int32 {
    return x.Success
}

func (x *respGetEntityGetCtx1Collision) GetSuccess() int32 {
    if !x.IsSetSuccess() {
        return 0
    }

    return *x.Success
}

func (x *respGetEntityGetCtx1Collision) SetSuccessNonCompat(value int32) *respGetEntityGetCtx1Collision {
    x.Success = &value
    return x
}

func (x *respGetEntityGetCtx1Collision) SetSuccess(value *int32) *respGetEntityGetCtx1Collision {
    x.Success = value
    return x
}

func (x *respGetEntityGetCtx1Collision) IsSetSuccess() bool {
    return x != nil && x.Success != nil
}

func (x *respGetEntityGetCtx1Collision) writeField0(p thrift.Protocol) error {  // Success
    if !x.IsSetSuccess() {
        return nil
    }

    if err := p.WriteFieldBegin("success", thrift.I32, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetSuccessNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetCtx1Collision) readField0(p thrift.Protocol) error {  // Success
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetSuccessNonCompat(result)
    return nil
}

func (x *respGetEntityGetCtx1Collision) toString0() string {  // Success
    if x.IsSetSuccess() {
        return fmt.Sprintf("%v", *x.GetSuccessNonCompat())
    }
    return fmt.Sprintf("%v", x.GetSuccessNonCompat())
}



// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetCtx1Collision().Set<FieldNameFoo>().Set<FieldNameBar>()
type respGetEntityGetCtx1CollisionBuilder struct {
    obj *respGetEntityGetCtx1Collision
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetCtx1Collision().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespGetEntityGetCtx1CollisionBuilder() *respGetEntityGetCtx1CollisionBuilder {
    return &respGetEntityGetCtx1CollisionBuilder{
        obj: newRespGetEntityGetCtx1Collision(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetCtx1Collision().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetCtx1CollisionBuilder) Success(value *int32) *respGetEntityGetCtx1CollisionBuilder {
    x.obj.Success = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespGetEntityGetCtx1Collision().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respGetEntityGetCtx1CollisionBuilder) Emit() *respGetEntityGetCtx1Collision {
    var objCopy respGetEntityGetCtx1Collision = *x.obj
    return &objCopy
}

func (x *respGetEntityGetCtx1Collision) Exception() thrift.WritableException {
    return nil
}

func (x *respGetEntityGetCtx1Collision) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respGetEntityGetCtx1Collision"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respGetEntityGetCtx1Collision) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 0 && wireType == thrift.Type(thrift.I32)):  // success
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respGetEntityGetCtx1Collision) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respGetEntityGetCtx1Collision({")
    sb.WriteString(fmt.Sprintf("Success:%s", x.toString0()))
    sb.WriteString("})")

    return sb.String()
}


type GetEntityProcessor struct {
    processorMap       map[string]thrift.ProcessorFunctionContext
    functionServiceMap map[string]string
    handler            GetEntity
}
// Compile time interface enforcer
var _ thrift.ProcessorContext = &GetEntityProcessor{}

func NewGetEntityProcessor(handler GetEntity) *GetEntityProcessor {
    p := &GetEntityProcessor{
        handler:            handler,
        processorMap:       make(map[string]thrift.ProcessorFunctionContext),
        functionServiceMap: make(map[string]string),
    }
    p.AddToProcessorMap("getEntity", &procFuncGetEntityGetEntity{handler: handler})
    p.AddToProcessorMap("getBool", &procFuncGetEntityGetBool{handler: handler})
    p.AddToProcessorMap("getByte", &procFuncGetEntityGetByte{handler: handler})
    p.AddToProcessorMap("getI16", &procFuncGetEntityGetI16{handler: handler})
    p.AddToProcessorMap("getI32", &procFuncGetEntityGetI32{handler: handler})
    p.AddToProcessorMap("getI64", &procFuncGetEntityGetI64{handler: handler})
    p.AddToProcessorMap("getDouble", &procFuncGetEntityGetDouble{handler: handler})
    p.AddToProcessorMap("getString", &procFuncGetEntityGetString{handler: handler})
    p.AddToProcessorMap("getBinary", &procFuncGetEntityGetBinary{handler: handler})
    p.AddToProcessorMap("getMap", &procFuncGetEntityGetMap{handler: handler})
    p.AddToProcessorMap("getSet", &procFuncGetEntityGetSet{handler: handler})
    p.AddToProcessorMap("getList", &procFuncGetEntityGetList{handler: handler})
    p.AddToProcessorMap("getLegacyStuff", &procFuncGetEntityGetLegacyStuff{handler: handler})
    p.AddToProcessorMap("getCtxCollision", &procFuncGetEntityGetCtxCollision{handler: handler})
    p.AddToProcessorMap("getCtx1Collision", &procFuncGetEntityGetCtx1Collision{handler: handler})
    p.AddToFunctionServiceMap("getEntity", "GetEntity")
    p.AddToFunctionServiceMap("getBool", "GetEntity")
    p.AddToFunctionServiceMap("getByte", "GetEntity")
    p.AddToFunctionServiceMap("getI16", "GetEntity")
    p.AddToFunctionServiceMap("getI32", "GetEntity")
    p.AddToFunctionServiceMap("getI64", "GetEntity")
    p.AddToFunctionServiceMap("getDouble", "GetEntity")
    p.AddToFunctionServiceMap("getString", "GetEntity")
    p.AddToFunctionServiceMap("getBinary", "GetEntity")
    p.AddToFunctionServiceMap("getMap", "GetEntity")
    p.AddToFunctionServiceMap("getSet", "GetEntity")
    p.AddToFunctionServiceMap("getList", "GetEntity")
    p.AddToFunctionServiceMap("getLegacyStuff", "GetEntity")
    p.AddToFunctionServiceMap("getCtxCollision", "GetEntity")
    p.AddToFunctionServiceMap("getCtx1Collision", "GetEntity")

    return p
}

func (p *GetEntityProcessor) AddToProcessorMap(key string, processor thrift.ProcessorFunctionContext) {
    p.processorMap[key] = processor
}

func (p *GetEntityProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *GetEntityProcessor) GetProcessorFunctionContext(key string) (processor thrift.ProcessorFunctionContext, err error) {
    if processor, ok := p.processorMap[key]; ok {
        return processor, nil
    }
    return nil, nil
}

func (p *GetEntityProcessor) ProcessorMap() map[string]thrift.ProcessorFunctionContext {
    return p.processorMap
}

func (p *GetEntityProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func (p *GetEntityProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.GetEntity")
}


type procFuncGetEntityGetEntity struct {
    handler GetEntity
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncGetEntityGetEntity{}

func (p *procFuncGetEntityGetEntity) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqGetEntityGetEntity()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncGetEntityGetEntity) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("getEntity", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncGetEntityGetEntity) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    args := reqStruct.(*reqGetEntityGetEntity)
    result := newRespGetEntityGetEntity()
    retval, err := p.handler.GetEntity(ctx, args.R)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GetEntity: " + err.Error(), err)
        return x, x
    }

    result.Success = retval
    return result, nil
}


type procFuncGetEntityGetBool struct {
    handler GetEntity
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncGetEntityGetBool{}

func (p *procFuncGetEntityGetBool) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqGetEntityGetBool()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncGetEntityGetBool) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("getBool", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncGetEntityGetBool) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespGetEntityGetBool()
    retval, err := p.handler.GetBool(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GetBool: " + err.Error(), err)
        return x, x
    }

    result.Success = &retval
    return result, nil
}


type procFuncGetEntityGetByte struct {
    handler GetEntity
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncGetEntityGetByte{}

func (p *procFuncGetEntityGetByte) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqGetEntityGetByte()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncGetEntityGetByte) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("getByte", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncGetEntityGetByte) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespGetEntityGetByte()
    retval, err := p.handler.GetByte(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GetByte: " + err.Error(), err)
        return x, x
    }

    result.Success = &retval
    return result, nil
}


type procFuncGetEntityGetI16 struct {
    handler GetEntity
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncGetEntityGetI16{}

func (p *procFuncGetEntityGetI16) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqGetEntityGetI16()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncGetEntityGetI16) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("getI16", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncGetEntityGetI16) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespGetEntityGetI16()
    retval, err := p.handler.GetI16(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GetI16: " + err.Error(), err)
        return x, x
    }

    result.Success = &retval
    return result, nil
}


type procFuncGetEntityGetI32 struct {
    handler GetEntity
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncGetEntityGetI32{}

func (p *procFuncGetEntityGetI32) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqGetEntityGetI32()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncGetEntityGetI32) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("getI32", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncGetEntityGetI32) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespGetEntityGetI32()
    retval, err := p.handler.GetI32(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GetI32: " + err.Error(), err)
        return x, x
    }

    result.Success = &retval
    return result, nil
}


type procFuncGetEntityGetI64 struct {
    handler GetEntity
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncGetEntityGetI64{}

func (p *procFuncGetEntityGetI64) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqGetEntityGetI64()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncGetEntityGetI64) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("getI64", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncGetEntityGetI64) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespGetEntityGetI64()
    retval, err := p.handler.GetI64(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GetI64: " + err.Error(), err)
        return x, x
    }

    result.Success = &retval
    return result, nil
}


type procFuncGetEntityGetDouble struct {
    handler GetEntity
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncGetEntityGetDouble{}

func (p *procFuncGetEntityGetDouble) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqGetEntityGetDouble()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncGetEntityGetDouble) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("getDouble", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncGetEntityGetDouble) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespGetEntityGetDouble()
    retval, err := p.handler.GetDouble(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GetDouble: " + err.Error(), err)
        return x, x
    }

    result.Success = &retval
    return result, nil
}


type procFuncGetEntityGetString struct {
    handler GetEntity
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncGetEntityGetString{}

func (p *procFuncGetEntityGetString) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqGetEntityGetString()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncGetEntityGetString) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("getString", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncGetEntityGetString) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespGetEntityGetString()
    retval, err := p.handler.GetString(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GetString: " + err.Error(), err)
        return x, x
    }

    result.Success = &retval
    return result, nil
}


type procFuncGetEntityGetBinary struct {
    handler GetEntity
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncGetEntityGetBinary{}

func (p *procFuncGetEntityGetBinary) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqGetEntityGetBinary()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncGetEntityGetBinary) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("getBinary", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncGetEntityGetBinary) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespGetEntityGetBinary()
    retval, err := p.handler.GetBinary(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GetBinary: " + err.Error(), err)
        return x, x
    }

    result.Success = retval
    return result, nil
}


type procFuncGetEntityGetMap struct {
    handler GetEntity
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncGetEntityGetMap{}

func (p *procFuncGetEntityGetMap) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqGetEntityGetMap()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncGetEntityGetMap) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("getMap", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncGetEntityGetMap) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespGetEntityGetMap()
    retval, err := p.handler.GetMap(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GetMap: " + err.Error(), err)
        return x, x
    }

    result.Success = retval
    return result, nil
}


type procFuncGetEntityGetSet struct {
    handler GetEntity
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncGetEntityGetSet{}

func (p *procFuncGetEntityGetSet) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqGetEntityGetSet()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncGetEntityGetSet) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("getSet", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncGetEntityGetSet) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespGetEntityGetSet()
    retval, err := p.handler.GetSet(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GetSet: " + err.Error(), err)
        return x, x
    }

    result.Success = retval
    return result, nil
}


type procFuncGetEntityGetList struct {
    handler GetEntity
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncGetEntityGetList{}

func (p *procFuncGetEntityGetList) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqGetEntityGetList()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncGetEntityGetList) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("getList", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncGetEntityGetList) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespGetEntityGetList()
    retval, err := p.handler.GetList(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GetList: " + err.Error(), err)
        return x, x
    }

    result.Success = retval
    return result, nil
}


type procFuncGetEntityGetLegacyStuff struct {
    handler GetEntity
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncGetEntityGetLegacyStuff{}

func (p *procFuncGetEntityGetLegacyStuff) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqGetEntityGetLegacyStuff()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncGetEntityGetLegacyStuff) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("getLegacyStuff", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncGetEntityGetLegacyStuff) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    args := reqStruct.(*reqGetEntityGetLegacyStuff)
    result := newRespGetEntityGetLegacyStuff()
    retval, err := p.handler.GetLegacyStuff(ctx, args.NumPos, args.NumNeg1, args.NumNeg2)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GetLegacyStuff: " + err.Error(), err)
        return x, x
    }

    result.Success = &retval
    return result, nil
}


type procFuncGetEntityGetCtxCollision struct {
    handler GetEntity
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncGetEntityGetCtxCollision{}

func (p *procFuncGetEntityGetCtxCollision) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqGetEntityGetCtxCollision()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncGetEntityGetCtxCollision) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("getCtxCollision", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncGetEntityGetCtxCollision) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    args := reqStruct.(*reqGetEntityGetCtxCollision)
    result := newRespGetEntityGetCtxCollision()
    retval, err := p.handler.GetCtxCollision(ctx, args.Ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GetCtxCollision: " + err.Error(), err)
        return x, x
    }

    result.Success = &retval
    return result, nil
}


type procFuncGetEntityGetCtx1Collision struct {
    handler GetEntity
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncGetEntityGetCtx1Collision{}

func (p *procFuncGetEntityGetCtx1Collision) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqGetEntityGetCtx1Collision()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncGetEntityGetCtx1Collision) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("getCtx1Collision", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncGetEntityGetCtx1Collision) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    args := reqStruct.(*reqGetEntityGetCtx1Collision)
    result := newRespGetEntityGetCtx1Collision()
    retval, err := p.handler.GetCtx1Collision(ctx, args.Ctx, args.Ctx1)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GetCtx1Collision: " + err.Error(), err)
        return x, x
    }

    result.Success = &retval
    return result, nil
}


