// @generated by Thrift for [[[ program path ]]]
// This file is probably not the place you want to edit!

package module // [[[ program thrift source path ]]]


import (
    "context"
    "fmt"
    "strings"
    "sync"

    thrift "github.com/facebook/fbthrift/thrift/lib/go/thrift"
    metadata "github.com/facebook/fbthrift/thrift/lib/thrift/metadata"
)

// (needed to ensure safety because of naive import list construction)
var _ = context.Background
var _ = fmt.Printf
var _ = strings.Split
var _ = sync.Mutex{}
var _ = thrift.ZERO
var _ = metadata.GoUnusedProtection__



type MyService interface {
    Ping(ctx context.Context) (error)
    GetRandomData(ctx context.Context) (string, error)
    HasDataById(ctx context.Context, id int64) (bool, error)
    GoGetDataById(ctx context.Context, id int64) (string, error)
    PutDataById(ctx context.Context, id int64, data string) (error)
    LobDataById(ctx context.Context, id int64, data string) (error)
    GoDoNothing(ctx context.Context) (error)
}

type MyServiceChannelClientInterface interface {
    thrift.ClientInterface
    MyService
}

// Deprecated: Migrate to ChannelClient and use MyServiceChannelClientInterface instead.
type MyServiceClientInterface interface {
    thrift.ClientInterface
    Ping() (error)
    GetRandomData() (string, error)
    HasDataById(id int64) (bool, error)
    GoGetDataById(id int64) (string, error)
    PutDataById(id int64, data string) (error)
    LobDataById(id int64, data string) (error)
    GoDoNothing() (error)
}

type MyServiceChannelClient struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ MyServiceChannelClientInterface = &MyServiceChannelClient{}

func NewMyServiceChannelClient(channel thrift.RequestChannel) *MyServiceChannelClient {
    return &MyServiceChannelClient{
        ch: channel,
    }
}

func (c *MyServiceChannelClient) Close() error {
    return c.ch.Close()
}

func (c *MyServiceChannelClient) IsOpen() bool {
    return c.ch.IsOpen()
}

func (c *MyServiceChannelClient) Open() error {
    return c.ch.Open()
}

// Deprecated: Use MyServiceChannelClient instead.
type MyServiceClient struct {
    chClient *MyServiceChannelClient
    Mu       sync.Mutex
}
// Compile time interface enforcer
var _ MyServiceClientInterface = &MyServiceClient{}

// Deprecated: Use NewMyServiceChannelClient() instead.
func NewMyServiceClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *MyServiceClient {
    return &MyServiceClient{
        chClient: NewMyServiceChannelClient(
            thrift.NewSerialChannel(iprot),
        ),
    }
}

func (c *MyServiceClient) Close() error {
    return c.chClient.Close()
}

func (c *MyServiceClient) IsOpen() bool {
    return c.chClient.IsOpen()
}

func (c *MyServiceClient) Open() error {
    return c.chClient.Open()
}

// Deprecated: Use MyServiceChannelClient instead.
type MyServiceThreadsafeClient = MyServiceClient

// Deprecated: Use NewMyServiceChannelClient() instead.
func NewMyServiceThreadsafeClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *MyServiceThreadsafeClient {
    return NewMyServiceClient(t, iprot, oprot)
}

// Deprecated: Use NewMyServiceChannelClient() instead.
func NewMyServiceClientProtocol(prot thrift.Protocol) *MyServiceClient {
  return NewMyServiceClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewMyServiceChannelClient() instead.
func NewMyServiceThreadsafeClientProtocol(prot thrift.Protocol) *MyServiceClient {
  return NewMyServiceClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewMyServiceChannelClient() instead.
func NewMyServiceClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *MyServiceClient {
  iprot := pf.GetProtocol(t)
  oprot := pf.GetProtocol(t)
  return NewMyServiceClient(t, iprot, oprot)
}

// Deprecated: Use NewMyServiceChannelClient() instead.
func NewMyServiceThreadsafeClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *MyServiceThreadsafeClient {
  return NewMyServiceClientFactory(t, pf)
}


func (c *MyServiceChannelClient) Ping(ctx context.Context) (error) {
    in := &reqMyServicePing{
    }
    out := newRespMyServicePing()
    err := c.ch.Call(ctx, "ping", in, out)
    if err != nil {
        return err
    } else if out.MyExcept != nil {
        return out.MyExcept
    }
    return nil
}

func (c *MyServiceClient) Ping() (error) {
    return c.chClient.Ping(nil)
}


func (c *MyServiceChannelClient) GetRandomData(ctx context.Context) (string, error) {
    in := &reqMyServiceGetRandomData{
    }
    out := newRespMyServiceGetRandomData()
    err := c.ch.Call(ctx, "getRandomData", in, out)
    if err != nil {
        return "", err
    }
    return out.GetSuccess(), nil
}

func (c *MyServiceClient) GetRandomData() (string, error) {
    return c.chClient.GetRandomData(nil)
}


func (c *MyServiceChannelClient) HasDataById(ctx context.Context, id int64) (bool, error) {
    in := &reqMyServiceHasDataById{
        Id: id,
    }
    out := newRespMyServiceHasDataById()
    err := c.ch.Call(ctx, "hasDataById", in, out)
    if err != nil {
        return false, err
    }
    return out.GetSuccess(), nil
}

func (c *MyServiceClient) HasDataById(id int64) (bool, error) {
    return c.chClient.HasDataById(nil, id)
}


func (c *MyServiceChannelClient) GoGetDataById(ctx context.Context, id int64) (string, error) {
    in := &reqMyServiceGoGetDataById{
        Id: id,
    }
    out := newRespMyServiceGoGetDataById()
    err := c.ch.Call(ctx, "getDataById", in, out)
    if err != nil {
        return "", err
    }
    return out.GetSuccess(), nil
}

func (c *MyServiceClient) GoGetDataById(id int64) (string, error) {
    return c.chClient.GoGetDataById(nil, id)
}


func (c *MyServiceChannelClient) PutDataById(ctx context.Context, id int64, data string) (error) {
    in := &reqMyServicePutDataById{
        Id: id,
        Data: data,
    }
    out := newRespMyServicePutDataById()
    err := c.ch.Call(ctx, "putDataById", in, out)
    if err != nil {
        return err
    }
    return nil
}

func (c *MyServiceClient) PutDataById(id int64, data string) (error) {
    return c.chClient.PutDataById(nil, id, data)
}


func (c *MyServiceChannelClient) LobDataById(ctx context.Context, id int64, data string) (error) {
    in := &reqMyServiceLobDataById{
        Id: id,
        Data: data,
    }
    return c.ch.Oneway(ctx, "lobDataById", in)
}

func (c *MyServiceClient) LobDataById(id int64, data string) (error) {
    return c.chClient.LobDataById(nil, id, data)
}


func (c *MyServiceChannelClient) GoDoNothing(ctx context.Context) (error) {
    in := &reqMyServiceGoDoNothing{
    }
    out := newRespMyServiceGoDoNothing()
    err := c.ch.Call(ctx, "doNothing", in, out)
    if err != nil {
        return err
    }
    return nil
}

func (c *MyServiceClient) GoDoNothing() (error) {
    return c.chClient.GoDoNothing(nil)
}


type reqMyServicePing struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServicePing{}

type MyServicePingArgs = reqMyServicePing

func newReqMyServicePing() *reqMyServicePing {
    return (&reqMyServicePing{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServicePing().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqMyServicePingBuilder struct {
    obj *reqMyServicePing
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServicePing().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqMyServicePingBuilder() *reqMyServicePingBuilder {
    return &reqMyServicePingBuilder{
        obj: newReqMyServicePing(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServicePing().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqMyServicePingBuilder) Emit() *reqMyServicePing {
    var objCopy reqMyServicePing = *x.obj
    return &objCopy
}

func (x *reqMyServicePing) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqMyServicePing"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServicePing) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqMyServicePing) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqMyServicePing({")
    sb.WriteString("})")

    return sb.String()
}
type respMyServicePing struct {
    MyExcept *MyException `thrift:"myExcept,1,optional" json:"myExcept,omitempty" db:"myExcept"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServicePing{}
var _ thrift.WritableResult = &respMyServicePing{}

type MyServicePingResult = respMyServicePing

func newRespMyServicePing() *respMyServicePing {
    return (&respMyServicePing{})
}

func (x *respMyServicePing) GetMyExceptNonCompat() *MyException {
    return x.MyExcept
}

func (x *respMyServicePing) GetMyExcept() *MyException {
    if !x.IsSetMyExcept() {
        return nil
    }

    return x.MyExcept
}

func (x *respMyServicePing) SetMyExceptNonCompat(value MyException) *respMyServicePing {
    x.MyExcept = &value
    return x
}

func (x *respMyServicePing) SetMyExcept(value *MyException) *respMyServicePing {
    x.MyExcept = value
    return x
}

func (x *respMyServicePing) IsSetMyExcept() bool {
    return x != nil && x.MyExcept != nil
}

func (x *respMyServicePing) writeField1(p thrift.Protocol) error {  // MyExcept
    if !x.IsSetMyExcept() {
        return nil
    }

    if err := p.WriteFieldBegin("myExcept", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetMyExceptNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respMyServicePing) readField1(p thrift.Protocol) error {  // MyExcept
    result := *NewMyException()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetMyExceptNonCompat(result)
    return nil
}

func (x *respMyServicePing) toString1() string {  // MyExcept
    return fmt.Sprintf("%v", x.GetMyExceptNonCompat())
}

// Deprecated: Use newRespMyServicePing().GetMyExcept() instead.
func (x *respMyServicePing) DefaultGetMyExcept() *MyException {
    if !x.IsSetMyExcept() {
        return NewMyException()
    }
    return x.MyExcept
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServicePing().Set<FieldNameFoo>().Set<FieldNameBar>()
type respMyServicePingBuilder struct {
    obj *respMyServicePing
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServicePing().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespMyServicePingBuilder() *respMyServicePingBuilder {
    return &respMyServicePingBuilder{
        obj: newRespMyServicePing(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServicePing().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respMyServicePingBuilder) MyExcept(value *MyException) *respMyServicePingBuilder {
    x.obj.MyExcept = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServicePing().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respMyServicePingBuilder) Emit() *respMyServicePing {
    var objCopy respMyServicePing = *x.obj
    return &objCopy
}

func (x *respMyServicePing) Exception() thrift.WritableException {
    if x.MyExcept != nil {
        return x.MyExcept
    }
    return nil
}

func (x *respMyServicePing) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respMyServicePing"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServicePing) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRUCT)):  // myExcept
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respMyServicePing) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respMyServicePing({")
    sb.WriteString(fmt.Sprintf("MyExcept:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}
type reqMyServiceGetRandomData struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServiceGetRandomData{}

type MyServiceGetRandomDataArgs = reqMyServiceGetRandomData

func newReqMyServiceGetRandomData() *reqMyServiceGetRandomData {
    return (&reqMyServiceGetRandomData{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServiceGetRandomData().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqMyServiceGetRandomDataBuilder struct {
    obj *reqMyServiceGetRandomData
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServiceGetRandomData().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqMyServiceGetRandomDataBuilder() *reqMyServiceGetRandomDataBuilder {
    return &reqMyServiceGetRandomDataBuilder{
        obj: newReqMyServiceGetRandomData(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServiceGetRandomData().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqMyServiceGetRandomDataBuilder) Emit() *reqMyServiceGetRandomData {
    var objCopy reqMyServiceGetRandomData = *x.obj
    return &objCopy
}

func (x *reqMyServiceGetRandomData) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqMyServiceGetRandomData"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServiceGetRandomData) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqMyServiceGetRandomData) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqMyServiceGetRandomData({")
    sb.WriteString("})")

    return sb.String()
}
type respMyServiceGetRandomData struct {
    Success *string `thrift:"success,0,optional" json:"success,omitempty" db:"success"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServiceGetRandomData{}
var _ thrift.WritableResult = &respMyServiceGetRandomData{}

type MyServiceGetRandomDataResult = respMyServiceGetRandomData

func newRespMyServiceGetRandomData() *respMyServiceGetRandomData {
    return (&respMyServiceGetRandomData{})
}

func (x *respMyServiceGetRandomData) GetSuccessNonCompat() *string {
    return x.Success
}

func (x *respMyServiceGetRandomData) GetSuccess() string {
    if !x.IsSetSuccess() {
        return ""
    }

    return *x.Success
}

func (x *respMyServiceGetRandomData) SetSuccessNonCompat(value string) *respMyServiceGetRandomData {
    x.Success = &value
    return x
}

func (x *respMyServiceGetRandomData) SetSuccess(value *string) *respMyServiceGetRandomData {
    x.Success = value
    return x
}

func (x *respMyServiceGetRandomData) IsSetSuccess() bool {
    return x != nil && x.Success != nil
}

func (x *respMyServiceGetRandomData) writeField0(p thrift.Protocol) error {  // Success
    if !x.IsSetSuccess() {
        return nil
    }

    if err := p.WriteFieldBegin("success", thrift.STRING, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetSuccessNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respMyServiceGetRandomData) readField0(p thrift.Protocol) error {  // Success
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetSuccessNonCompat(result)
    return nil
}

func (x *respMyServiceGetRandomData) toString0() string {  // Success
    if x.IsSetSuccess() {
        return fmt.Sprintf("%v", *x.GetSuccessNonCompat())
    }
    return fmt.Sprintf("%v", x.GetSuccessNonCompat())
}



// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServiceGetRandomData().Set<FieldNameFoo>().Set<FieldNameBar>()
type respMyServiceGetRandomDataBuilder struct {
    obj *respMyServiceGetRandomData
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServiceGetRandomData().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespMyServiceGetRandomDataBuilder() *respMyServiceGetRandomDataBuilder {
    return &respMyServiceGetRandomDataBuilder{
        obj: newRespMyServiceGetRandomData(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServiceGetRandomData().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respMyServiceGetRandomDataBuilder) Success(value *string) *respMyServiceGetRandomDataBuilder {
    x.obj.Success = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServiceGetRandomData().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respMyServiceGetRandomDataBuilder) Emit() *respMyServiceGetRandomData {
    var objCopy respMyServiceGetRandomData = *x.obj
    return &objCopy
}

func (x *respMyServiceGetRandomData) Exception() thrift.WritableException {
    return nil
}

func (x *respMyServiceGetRandomData) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respMyServiceGetRandomData"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServiceGetRandomData) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 0 && wireType == thrift.Type(thrift.STRING)):  // success
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respMyServiceGetRandomData) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respMyServiceGetRandomData({")
    sb.WriteString(fmt.Sprintf("Success:%s", x.toString0()))
    sb.WriteString("})")

    return sb.String()
}
type reqMyServiceHasDataById struct {
    Id int64 `thrift:"id,1" json:"id" db:"id"`
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServiceHasDataById{}

type MyServiceHasDataByIdArgs = reqMyServiceHasDataById

func newReqMyServiceHasDataById() *reqMyServiceHasDataById {
    return (&reqMyServiceHasDataById{}).
        SetIdNonCompat(0)
}

func (x *reqMyServiceHasDataById) GetIdNonCompat() int64 {
    return x.Id
}

func (x *reqMyServiceHasDataById) GetId() int64 {
    return x.Id
}

func (x *reqMyServiceHasDataById) SetIdNonCompat(value int64) *reqMyServiceHasDataById {
    x.Id = value
    return x
}

func (x *reqMyServiceHasDataById) SetId(value int64) *reqMyServiceHasDataById {
    x.Id = value
    return x
}

func (x *reqMyServiceHasDataById) writeField1(p thrift.Protocol) error {  // Id
    if err := p.WriteFieldBegin("id", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetIdNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *reqMyServiceHasDataById) readField1(p thrift.Protocol) error {  // Id
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetIdNonCompat(result)
    return nil
}

func (x *reqMyServiceHasDataById) toString1() string {  // Id
    return fmt.Sprintf("%v", x.GetIdNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServiceHasDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqMyServiceHasDataByIdBuilder struct {
    obj *reqMyServiceHasDataById
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServiceHasDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqMyServiceHasDataByIdBuilder() *reqMyServiceHasDataByIdBuilder {
    return &reqMyServiceHasDataByIdBuilder{
        obj: newReqMyServiceHasDataById(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServiceHasDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqMyServiceHasDataByIdBuilder) Id(value int64) *reqMyServiceHasDataByIdBuilder {
    x.obj.Id = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServiceHasDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqMyServiceHasDataByIdBuilder) Emit() *reqMyServiceHasDataById {
    var objCopy reqMyServiceHasDataById = *x.obj
    return &objCopy
}

func (x *reqMyServiceHasDataById) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqMyServiceHasDataById"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServiceHasDataById) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I64)):  // id
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqMyServiceHasDataById) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqMyServiceHasDataById({")
    sb.WriteString(fmt.Sprintf("Id:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}
type respMyServiceHasDataById struct {
    Success *bool `thrift:"success,0,optional" json:"success,omitempty" db:"success"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServiceHasDataById{}
var _ thrift.WritableResult = &respMyServiceHasDataById{}

type MyServiceHasDataByIdResult = respMyServiceHasDataById

func newRespMyServiceHasDataById() *respMyServiceHasDataById {
    return (&respMyServiceHasDataById{})
}

func (x *respMyServiceHasDataById) GetSuccessNonCompat() *bool {
    return x.Success
}

func (x *respMyServiceHasDataById) GetSuccess() bool {
    if !x.IsSetSuccess() {
        return false
    }

    return *x.Success
}

func (x *respMyServiceHasDataById) SetSuccessNonCompat(value bool) *respMyServiceHasDataById {
    x.Success = &value
    return x
}

func (x *respMyServiceHasDataById) SetSuccess(value *bool) *respMyServiceHasDataById {
    x.Success = value
    return x
}

func (x *respMyServiceHasDataById) IsSetSuccess() bool {
    return x != nil && x.Success != nil
}

func (x *respMyServiceHasDataById) writeField0(p thrift.Protocol) error {  // Success
    if !x.IsSetSuccess() {
        return nil
    }

    if err := p.WriteFieldBegin("success", thrift.BOOL, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetSuccessNonCompat()
    if err := p.WriteBool(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respMyServiceHasDataById) readField0(p thrift.Protocol) error {  // Success
    result, err := p.ReadBool()
if err != nil {
    return err
}

    x.SetSuccessNonCompat(result)
    return nil
}

func (x *respMyServiceHasDataById) toString0() string {  // Success
    if x.IsSetSuccess() {
        return fmt.Sprintf("%v", *x.GetSuccessNonCompat())
    }
    return fmt.Sprintf("%v", x.GetSuccessNonCompat())
}



// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServiceHasDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
type respMyServiceHasDataByIdBuilder struct {
    obj *respMyServiceHasDataById
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServiceHasDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespMyServiceHasDataByIdBuilder() *respMyServiceHasDataByIdBuilder {
    return &respMyServiceHasDataByIdBuilder{
        obj: newRespMyServiceHasDataById(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServiceHasDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respMyServiceHasDataByIdBuilder) Success(value *bool) *respMyServiceHasDataByIdBuilder {
    x.obj.Success = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServiceHasDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respMyServiceHasDataByIdBuilder) Emit() *respMyServiceHasDataById {
    var objCopy respMyServiceHasDataById = *x.obj
    return &objCopy
}

func (x *respMyServiceHasDataById) Exception() thrift.WritableException {
    return nil
}

func (x *respMyServiceHasDataById) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respMyServiceHasDataById"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServiceHasDataById) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 0 && wireType == thrift.Type(thrift.BOOL)):  // success
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respMyServiceHasDataById) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respMyServiceHasDataById({")
    sb.WriteString(fmt.Sprintf("Success:%s", x.toString0()))
    sb.WriteString("})")

    return sb.String()
}
type reqMyServiceGoGetDataById struct {
    Id int64 `thrift:"id,1" json:"id" db:"id"`
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServiceGoGetDataById{}

type MyServiceGoGetDataByIdArgs = reqMyServiceGoGetDataById

func newReqMyServiceGoGetDataById() *reqMyServiceGoGetDataById {
    return (&reqMyServiceGoGetDataById{}).
        SetIdNonCompat(0)
}

func (x *reqMyServiceGoGetDataById) GetIdNonCompat() int64 {
    return x.Id
}

func (x *reqMyServiceGoGetDataById) GetId() int64 {
    return x.Id
}

func (x *reqMyServiceGoGetDataById) SetIdNonCompat(value int64) *reqMyServiceGoGetDataById {
    x.Id = value
    return x
}

func (x *reqMyServiceGoGetDataById) SetId(value int64) *reqMyServiceGoGetDataById {
    x.Id = value
    return x
}

func (x *reqMyServiceGoGetDataById) writeField1(p thrift.Protocol) error {  // Id
    if err := p.WriteFieldBegin("id", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetIdNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *reqMyServiceGoGetDataById) readField1(p thrift.Protocol) error {  // Id
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetIdNonCompat(result)
    return nil
}

func (x *reqMyServiceGoGetDataById) toString1() string {  // Id
    return fmt.Sprintf("%v", x.GetIdNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServiceGoGetDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqMyServiceGoGetDataByIdBuilder struct {
    obj *reqMyServiceGoGetDataById
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServiceGoGetDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqMyServiceGoGetDataByIdBuilder() *reqMyServiceGoGetDataByIdBuilder {
    return &reqMyServiceGoGetDataByIdBuilder{
        obj: newReqMyServiceGoGetDataById(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServiceGoGetDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqMyServiceGoGetDataByIdBuilder) Id(value int64) *reqMyServiceGoGetDataByIdBuilder {
    x.obj.Id = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServiceGoGetDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqMyServiceGoGetDataByIdBuilder) Emit() *reqMyServiceGoGetDataById {
    var objCopy reqMyServiceGoGetDataById = *x.obj
    return &objCopy
}

func (x *reqMyServiceGoGetDataById) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqMyServiceGoGetDataById"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServiceGoGetDataById) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I64)):  // id
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqMyServiceGoGetDataById) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqMyServiceGoGetDataById({")
    sb.WriteString(fmt.Sprintf("Id:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}
type respMyServiceGoGetDataById struct {
    Success *string `thrift:"success,0,optional" json:"success,omitempty" db:"success"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServiceGoGetDataById{}
var _ thrift.WritableResult = &respMyServiceGoGetDataById{}

type MyServiceGoGetDataByIdResult = respMyServiceGoGetDataById

func newRespMyServiceGoGetDataById() *respMyServiceGoGetDataById {
    return (&respMyServiceGoGetDataById{})
}

func (x *respMyServiceGoGetDataById) GetSuccessNonCompat() *string {
    return x.Success
}

func (x *respMyServiceGoGetDataById) GetSuccess() string {
    if !x.IsSetSuccess() {
        return ""
    }

    return *x.Success
}

func (x *respMyServiceGoGetDataById) SetSuccessNonCompat(value string) *respMyServiceGoGetDataById {
    x.Success = &value
    return x
}

func (x *respMyServiceGoGetDataById) SetSuccess(value *string) *respMyServiceGoGetDataById {
    x.Success = value
    return x
}

func (x *respMyServiceGoGetDataById) IsSetSuccess() bool {
    return x != nil && x.Success != nil
}

func (x *respMyServiceGoGetDataById) writeField0(p thrift.Protocol) error {  // Success
    if !x.IsSetSuccess() {
        return nil
    }

    if err := p.WriteFieldBegin("success", thrift.STRING, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetSuccessNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respMyServiceGoGetDataById) readField0(p thrift.Protocol) error {  // Success
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetSuccessNonCompat(result)
    return nil
}

func (x *respMyServiceGoGetDataById) toString0() string {  // Success
    if x.IsSetSuccess() {
        return fmt.Sprintf("%v", *x.GetSuccessNonCompat())
    }
    return fmt.Sprintf("%v", x.GetSuccessNonCompat())
}



// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServiceGoGetDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
type respMyServiceGoGetDataByIdBuilder struct {
    obj *respMyServiceGoGetDataById
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServiceGoGetDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespMyServiceGoGetDataByIdBuilder() *respMyServiceGoGetDataByIdBuilder {
    return &respMyServiceGoGetDataByIdBuilder{
        obj: newRespMyServiceGoGetDataById(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServiceGoGetDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respMyServiceGoGetDataByIdBuilder) Success(value *string) *respMyServiceGoGetDataByIdBuilder {
    x.obj.Success = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServiceGoGetDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respMyServiceGoGetDataByIdBuilder) Emit() *respMyServiceGoGetDataById {
    var objCopy respMyServiceGoGetDataById = *x.obj
    return &objCopy
}

func (x *respMyServiceGoGetDataById) Exception() thrift.WritableException {
    return nil
}

func (x *respMyServiceGoGetDataById) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respMyServiceGoGetDataById"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServiceGoGetDataById) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 0 && wireType == thrift.Type(thrift.STRING)):  // success
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respMyServiceGoGetDataById) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respMyServiceGoGetDataById({")
    sb.WriteString(fmt.Sprintf("Success:%s", x.toString0()))
    sb.WriteString("})")

    return sb.String()
}
type reqMyServicePutDataById struct {
    Id int64 `thrift:"id,1" json:"id" db:"id"`
    Data string `thrift:"data,2" json:"data" db:"data"`
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServicePutDataById{}

type MyServicePutDataByIdArgs = reqMyServicePutDataById

func newReqMyServicePutDataById() *reqMyServicePutDataById {
    return (&reqMyServicePutDataById{}).
        SetIdNonCompat(0).
        SetDataNonCompat("")
}

func (x *reqMyServicePutDataById) GetIdNonCompat() int64 {
    return x.Id
}

func (x *reqMyServicePutDataById) GetId() int64 {
    return x.Id
}

func (x *reqMyServicePutDataById) GetDataNonCompat() string {
    return x.Data
}

func (x *reqMyServicePutDataById) GetData() string {
    return x.Data
}

func (x *reqMyServicePutDataById) SetIdNonCompat(value int64) *reqMyServicePutDataById {
    x.Id = value
    return x
}

func (x *reqMyServicePutDataById) SetId(value int64) *reqMyServicePutDataById {
    x.Id = value
    return x
}

func (x *reqMyServicePutDataById) SetDataNonCompat(value string) *reqMyServicePutDataById {
    x.Data = value
    return x
}

func (x *reqMyServicePutDataById) SetData(value string) *reqMyServicePutDataById {
    x.Data = value
    return x
}

func (x *reqMyServicePutDataById) writeField1(p thrift.Protocol) error {  // Id
    if err := p.WriteFieldBegin("id", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetIdNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *reqMyServicePutDataById) writeField2(p thrift.Protocol) error {  // Data
    if err := p.WriteFieldBegin("data", thrift.STRING, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDataNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *reqMyServicePutDataById) readField1(p thrift.Protocol) error {  // Id
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetIdNonCompat(result)
    return nil
}

func (x *reqMyServicePutDataById) readField2(p thrift.Protocol) error {  // Data
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetDataNonCompat(result)
    return nil
}

func (x *reqMyServicePutDataById) toString1() string {  // Id
    return fmt.Sprintf("%v", x.GetIdNonCompat())
}

func (x *reqMyServicePutDataById) toString2() string {  // Data
    return fmt.Sprintf("%v", x.GetDataNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServicePutDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqMyServicePutDataByIdBuilder struct {
    obj *reqMyServicePutDataById
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServicePutDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqMyServicePutDataByIdBuilder() *reqMyServicePutDataByIdBuilder {
    return &reqMyServicePutDataByIdBuilder{
        obj: newReqMyServicePutDataById(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServicePutDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqMyServicePutDataByIdBuilder) Id(value int64) *reqMyServicePutDataByIdBuilder {
    x.obj.Id = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServicePutDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqMyServicePutDataByIdBuilder) Data(value string) *reqMyServicePutDataByIdBuilder {
    x.obj.Data = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServicePutDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqMyServicePutDataByIdBuilder) Emit() *reqMyServicePutDataById {
    var objCopy reqMyServicePutDataById = *x.obj
    return &objCopy
}

func (x *reqMyServicePutDataById) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqMyServicePutDataById"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServicePutDataById) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I64)):  // id
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.STRING)):  // data
            if err := x.readField2(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqMyServicePutDataById) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqMyServicePutDataById({")
    sb.WriteString(fmt.Sprintf("Id:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("Data:%s", x.toString2()))
    sb.WriteString("})")

    return sb.String()
}
type respMyServicePutDataById struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServicePutDataById{}
var _ thrift.WritableResult = &respMyServicePutDataById{}

type MyServicePutDataByIdResult = respMyServicePutDataById

func newRespMyServicePutDataById() *respMyServicePutDataById {
    return (&respMyServicePutDataById{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServicePutDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
type respMyServicePutDataByIdBuilder struct {
    obj *respMyServicePutDataById
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServicePutDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespMyServicePutDataByIdBuilder() *respMyServicePutDataByIdBuilder {
    return &respMyServicePutDataByIdBuilder{
        obj: newRespMyServicePutDataById(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServicePutDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respMyServicePutDataByIdBuilder) Emit() *respMyServicePutDataById {
    var objCopy respMyServicePutDataById = *x.obj
    return &objCopy
}

func (x *respMyServicePutDataById) Exception() thrift.WritableException {
    return nil
}

func (x *respMyServicePutDataById) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respMyServicePutDataById"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServicePutDataById) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respMyServicePutDataById) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respMyServicePutDataById({")
    sb.WriteString("})")

    return sb.String()
}
type reqMyServiceLobDataById struct {
    Id int64 `thrift:"id,1" json:"id" db:"id"`
    Data string `thrift:"data,2" json:"data" db:"data"`
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServiceLobDataById{}

type MyServiceLobDataByIdArgs = reqMyServiceLobDataById

func newReqMyServiceLobDataById() *reqMyServiceLobDataById {
    return (&reqMyServiceLobDataById{}).
        SetIdNonCompat(0).
        SetDataNonCompat("")
}

func (x *reqMyServiceLobDataById) GetIdNonCompat() int64 {
    return x.Id
}

func (x *reqMyServiceLobDataById) GetId() int64 {
    return x.Id
}

func (x *reqMyServiceLobDataById) GetDataNonCompat() string {
    return x.Data
}

func (x *reqMyServiceLobDataById) GetData() string {
    return x.Data
}

func (x *reqMyServiceLobDataById) SetIdNonCompat(value int64) *reqMyServiceLobDataById {
    x.Id = value
    return x
}

func (x *reqMyServiceLobDataById) SetId(value int64) *reqMyServiceLobDataById {
    x.Id = value
    return x
}

func (x *reqMyServiceLobDataById) SetDataNonCompat(value string) *reqMyServiceLobDataById {
    x.Data = value
    return x
}

func (x *reqMyServiceLobDataById) SetData(value string) *reqMyServiceLobDataById {
    x.Data = value
    return x
}

func (x *reqMyServiceLobDataById) writeField1(p thrift.Protocol) error {  // Id
    if err := p.WriteFieldBegin("id", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetIdNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *reqMyServiceLobDataById) writeField2(p thrift.Protocol) error {  // Data
    if err := p.WriteFieldBegin("data", thrift.STRING, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDataNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *reqMyServiceLobDataById) readField1(p thrift.Protocol) error {  // Id
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetIdNonCompat(result)
    return nil
}

func (x *reqMyServiceLobDataById) readField2(p thrift.Protocol) error {  // Data
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetDataNonCompat(result)
    return nil
}

func (x *reqMyServiceLobDataById) toString1() string {  // Id
    return fmt.Sprintf("%v", x.GetIdNonCompat())
}

func (x *reqMyServiceLobDataById) toString2() string {  // Data
    return fmt.Sprintf("%v", x.GetDataNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServiceLobDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqMyServiceLobDataByIdBuilder struct {
    obj *reqMyServiceLobDataById
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServiceLobDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqMyServiceLobDataByIdBuilder() *reqMyServiceLobDataByIdBuilder {
    return &reqMyServiceLobDataByIdBuilder{
        obj: newReqMyServiceLobDataById(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServiceLobDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqMyServiceLobDataByIdBuilder) Id(value int64) *reqMyServiceLobDataByIdBuilder {
    x.obj.Id = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServiceLobDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqMyServiceLobDataByIdBuilder) Data(value string) *reqMyServiceLobDataByIdBuilder {
    x.obj.Data = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServiceLobDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqMyServiceLobDataByIdBuilder) Emit() *reqMyServiceLobDataById {
    var objCopy reqMyServiceLobDataById = *x.obj
    return &objCopy
}

func (x *reqMyServiceLobDataById) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqMyServiceLobDataById"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServiceLobDataById) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I64)):  // id
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.STRING)):  // data
            if err := x.readField2(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqMyServiceLobDataById) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqMyServiceLobDataById({")
    sb.WriteString(fmt.Sprintf("Id:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("Data:%s", x.toString2()))
    sb.WriteString("})")

    return sb.String()
}
type respMyServiceLobDataById struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServiceLobDataById{}
var _ thrift.WritableResult = &respMyServiceLobDataById{}

type MyServiceLobDataByIdResult = respMyServiceLobDataById

func newRespMyServiceLobDataById() *respMyServiceLobDataById {
    return (&respMyServiceLobDataById{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServiceLobDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
type respMyServiceLobDataByIdBuilder struct {
    obj *respMyServiceLobDataById
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServiceLobDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespMyServiceLobDataByIdBuilder() *respMyServiceLobDataByIdBuilder {
    return &respMyServiceLobDataByIdBuilder{
        obj: newRespMyServiceLobDataById(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServiceLobDataById().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respMyServiceLobDataByIdBuilder) Emit() *respMyServiceLobDataById {
    var objCopy respMyServiceLobDataById = *x.obj
    return &objCopy
}

func (x *respMyServiceLobDataById) Exception() thrift.WritableException {
    return nil
}

func (x *respMyServiceLobDataById) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respMyServiceLobDataById"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServiceLobDataById) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respMyServiceLobDataById) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respMyServiceLobDataById({")
    sb.WriteString("})")

    return sb.String()
}
type reqMyServiceGoDoNothing struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServiceGoDoNothing{}

type MyServiceGoDoNothingArgs = reqMyServiceGoDoNothing

func newReqMyServiceGoDoNothing() *reqMyServiceGoDoNothing {
    return (&reqMyServiceGoDoNothing{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServiceGoDoNothing().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqMyServiceGoDoNothingBuilder struct {
    obj *reqMyServiceGoDoNothing
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServiceGoDoNothing().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqMyServiceGoDoNothingBuilder() *reqMyServiceGoDoNothingBuilder {
    return &reqMyServiceGoDoNothingBuilder{
        obj: newReqMyServiceGoDoNothing(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServiceGoDoNothing().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqMyServiceGoDoNothingBuilder) Emit() *reqMyServiceGoDoNothing {
    var objCopy reqMyServiceGoDoNothing = *x.obj
    return &objCopy
}

func (x *reqMyServiceGoDoNothing) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqMyServiceGoDoNothing"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServiceGoDoNothing) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqMyServiceGoDoNothing) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqMyServiceGoDoNothing({")
    sb.WriteString("})")

    return sb.String()
}
type respMyServiceGoDoNothing struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServiceGoDoNothing{}
var _ thrift.WritableResult = &respMyServiceGoDoNothing{}

type MyServiceGoDoNothingResult = respMyServiceGoDoNothing

func newRespMyServiceGoDoNothing() *respMyServiceGoDoNothing {
    return (&respMyServiceGoDoNothing{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServiceGoDoNothing().Set<FieldNameFoo>().Set<FieldNameBar>()
type respMyServiceGoDoNothingBuilder struct {
    obj *respMyServiceGoDoNothing
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServiceGoDoNothing().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespMyServiceGoDoNothingBuilder() *respMyServiceGoDoNothingBuilder {
    return &respMyServiceGoDoNothingBuilder{
        obj: newRespMyServiceGoDoNothing(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServiceGoDoNothing().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respMyServiceGoDoNothingBuilder) Emit() *respMyServiceGoDoNothing {
    var objCopy respMyServiceGoDoNothing = *x.obj
    return &objCopy
}

func (x *respMyServiceGoDoNothing) Exception() thrift.WritableException {
    return nil
}

func (x *respMyServiceGoDoNothing) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respMyServiceGoDoNothing"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServiceGoDoNothing) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respMyServiceGoDoNothing) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respMyServiceGoDoNothing({")
    sb.WriteString("})")

    return sb.String()
}


type MyServiceProcessor struct {
    processorMap       map[string]thrift.ProcessorFunctionContext
    functionServiceMap map[string]string
    handler            MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorContext = &MyServiceProcessor{}

func NewMyServiceProcessor(handler MyService) *MyServiceProcessor {
    p := &MyServiceProcessor{
        handler:            handler,
        processorMap:       make(map[string]thrift.ProcessorFunctionContext),
        functionServiceMap: make(map[string]string),
    }
    p.AddToProcessorMap("ping", &procFuncMyServicePing{handler: handler})
    p.AddToProcessorMap("getRandomData", &procFuncMyServiceGetRandomData{handler: handler})
    p.AddToProcessorMap("hasDataById", &procFuncMyServiceHasDataById{handler: handler})
    p.AddToProcessorMap("getDataById", &procFuncMyServiceGoGetDataById{handler: handler})
    p.AddToProcessorMap("putDataById", &procFuncMyServicePutDataById{handler: handler})
    p.AddToProcessorMap("lobDataById", &procFuncMyServiceLobDataById{handler: handler})
    p.AddToProcessorMap("doNothing", &procFuncMyServiceGoDoNothing{handler: handler})
    p.AddToFunctionServiceMap("ping", "MyService")
    p.AddToFunctionServiceMap("getRandomData", "MyService")
    p.AddToFunctionServiceMap("hasDataById", "MyService")
    p.AddToFunctionServiceMap("getDataById", "MyService")
    p.AddToFunctionServiceMap("putDataById", "MyService")
    p.AddToFunctionServiceMap("lobDataById", "MyService")
    p.AddToFunctionServiceMap("doNothing", "MyService")

    return p
}

func (p *MyServiceProcessor) AddToProcessorMap(key string, processor thrift.ProcessorFunctionContext) {
    p.processorMap[key] = processor
}

func (p *MyServiceProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *MyServiceProcessor) GetProcessorFunctionContext(key string) (processor thrift.ProcessorFunctionContext, err error) {
    if processor, ok := p.processorMap[key]; ok {
        return processor, nil
    }
    return nil, nil
}

func (p *MyServiceProcessor) ProcessorMap() map[string]thrift.ProcessorFunctionContext {
    return p.processorMap
}

func (p *MyServiceProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func (p *MyServiceProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.MyService")
}


type procFuncMyServicePing struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncMyServicePing{}

func (p *procFuncMyServicePing) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServicePing()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServicePing) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch v := result.(type) {
    case *MyException:
        result = &respMyServicePing{
            MyExcept: v,
        }
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("ping", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServicePing) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespMyServicePing()
    err := p.handler.Ping(ctx)
    if err != nil {
        switch v := err.(type) {
        case *MyException:
            result.MyExcept = v
            return result, nil
        default:
            x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing doRaise: " + err.Error(), err)
            return x, x
        }
    }

    return result, nil
}


type procFuncMyServiceGetRandomData struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncMyServiceGetRandomData{}

func (p *procFuncMyServiceGetRandomData) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServiceGetRandomData()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServiceGetRandomData) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("getRandomData", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServiceGetRandomData) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespMyServiceGetRandomData()
    retval, err := p.handler.GetRandomData(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GetRandomData: " + err.Error(), err)
        return x, x
    }

    result.Success = &retval
    return result, nil
}


type procFuncMyServiceHasDataById struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncMyServiceHasDataById{}

func (p *procFuncMyServiceHasDataById) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServiceHasDataById()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServiceHasDataById) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("hasDataById", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServiceHasDataById) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    args := reqStruct.(*reqMyServiceHasDataById)
    result := newRespMyServiceHasDataById()
    retval, err := p.handler.HasDataById(ctx, args.Id)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing HasDataById: " + err.Error(), err)
        return x, x
    }

    result.Success = &retval
    return result, nil
}


type procFuncMyServiceGoGetDataById struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncMyServiceGoGetDataById{}

func (p *procFuncMyServiceGoGetDataById) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServiceGoGetDataById()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServiceGoGetDataById) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("getDataById", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServiceGoGetDataById) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    args := reqStruct.(*reqMyServiceGoGetDataById)
    result := newRespMyServiceGoGetDataById()
    retval, err := p.handler.GoGetDataById(ctx, args.Id)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GoGetDataById: " + err.Error(), err)
        return x, x
    }

    result.Success = &retval
    return result, nil
}


type procFuncMyServicePutDataById struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncMyServicePutDataById{}

func (p *procFuncMyServicePutDataById) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServicePutDataById()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServicePutDataById) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("putDataById", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServicePutDataById) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    args := reqStruct.(*reqMyServicePutDataById)
    result := newRespMyServicePutDataById()
    err := p.handler.PutDataById(ctx, args.Id, args.Data)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing PutDataById: " + err.Error(), err)
        return x, x
    }

    return result, nil
}


type procFuncMyServiceLobDataById struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncMyServiceLobDataById{}

func (p *procFuncMyServiceLobDataById) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServiceLobDataById()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServiceLobDataById) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("lobDataById", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServiceLobDataById) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    args := reqStruct.(*reqMyServiceLobDataById)
    err := p.handler.LobDataById(ctx, args.Id, args.Data)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing LobDataById: " + err.Error(), err)
        return x, x
    }

    return nil, nil
}


type procFuncMyServiceGoDoNothing struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncMyServiceGoDoNothing{}

func (p *procFuncMyServiceGoDoNothing) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServiceGoDoNothing()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServiceGoDoNothing) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("doNothing", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServiceGoDoNothing) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespMyServiceGoDoNothing()
    err := p.handler.GoDoNothing(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GoDoNothing: " + err.Error(), err)
        return x, x
    }

    return result, nil
}




type MyServicePrioParent interface {
    Ping(ctx context.Context) (error)
    Pong(ctx context.Context) (error)
}

type MyServicePrioParentChannelClientInterface interface {
    thrift.ClientInterface
    MyServicePrioParent
}

// Deprecated: Migrate to ChannelClient and use MyServicePrioParentChannelClientInterface instead.
type MyServicePrioParentClientInterface interface {
    thrift.ClientInterface
    Ping() (error)
    Pong() (error)
}

type MyServicePrioParentChannelClient struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ MyServicePrioParentChannelClientInterface = &MyServicePrioParentChannelClient{}

func NewMyServicePrioParentChannelClient(channel thrift.RequestChannel) *MyServicePrioParentChannelClient {
    return &MyServicePrioParentChannelClient{
        ch: channel,
    }
}

func (c *MyServicePrioParentChannelClient) Close() error {
    return c.ch.Close()
}

func (c *MyServicePrioParentChannelClient) IsOpen() bool {
    return c.ch.IsOpen()
}

func (c *MyServicePrioParentChannelClient) Open() error {
    return c.ch.Open()
}

// Deprecated: Use MyServicePrioParentChannelClient instead.
type MyServicePrioParentClient struct {
    chClient *MyServicePrioParentChannelClient
    Mu       sync.Mutex
}
// Compile time interface enforcer
var _ MyServicePrioParentClientInterface = &MyServicePrioParentClient{}

// Deprecated: Use NewMyServicePrioParentChannelClient() instead.
func NewMyServicePrioParentClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *MyServicePrioParentClient {
    return &MyServicePrioParentClient{
        chClient: NewMyServicePrioParentChannelClient(
            thrift.NewSerialChannel(iprot),
        ),
    }
}

func (c *MyServicePrioParentClient) Close() error {
    return c.chClient.Close()
}

func (c *MyServicePrioParentClient) IsOpen() bool {
    return c.chClient.IsOpen()
}

func (c *MyServicePrioParentClient) Open() error {
    return c.chClient.Open()
}

// Deprecated: Use MyServicePrioParentChannelClient instead.
type MyServicePrioParentThreadsafeClient = MyServicePrioParentClient

// Deprecated: Use NewMyServicePrioParentChannelClient() instead.
func NewMyServicePrioParentThreadsafeClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *MyServicePrioParentThreadsafeClient {
    return NewMyServicePrioParentClient(t, iprot, oprot)
}

// Deprecated: Use NewMyServicePrioParentChannelClient() instead.
func NewMyServicePrioParentClientProtocol(prot thrift.Protocol) *MyServicePrioParentClient {
  return NewMyServicePrioParentClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewMyServicePrioParentChannelClient() instead.
func NewMyServicePrioParentThreadsafeClientProtocol(prot thrift.Protocol) *MyServicePrioParentClient {
  return NewMyServicePrioParentClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewMyServicePrioParentChannelClient() instead.
func NewMyServicePrioParentClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *MyServicePrioParentClient {
  iprot := pf.GetProtocol(t)
  oprot := pf.GetProtocol(t)
  return NewMyServicePrioParentClient(t, iprot, oprot)
}

// Deprecated: Use NewMyServicePrioParentChannelClient() instead.
func NewMyServicePrioParentThreadsafeClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *MyServicePrioParentThreadsafeClient {
  return NewMyServicePrioParentClientFactory(t, pf)
}


func (c *MyServicePrioParentChannelClient) Ping(ctx context.Context) (error) {
    in := &reqMyServicePrioParentPing{
    }
    out := newRespMyServicePrioParentPing()
    err := c.ch.Call(ctx, "ping", in, out)
    if err != nil {
        return err
    }
    return nil
}

func (c *MyServicePrioParentClient) Ping() (error) {
    return c.chClient.Ping(nil)
}


func (c *MyServicePrioParentChannelClient) Pong(ctx context.Context) (error) {
    in := &reqMyServicePrioParentPong{
    }
    out := newRespMyServicePrioParentPong()
    err := c.ch.Call(ctx, "pong", in, out)
    if err != nil {
        return err
    }
    return nil
}

func (c *MyServicePrioParentClient) Pong() (error) {
    return c.chClient.Pong(nil)
}


type reqMyServicePrioParentPing struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServicePrioParentPing{}

type MyServicePrioParentPingArgs = reqMyServicePrioParentPing

func newReqMyServicePrioParentPing() *reqMyServicePrioParentPing {
    return (&reqMyServicePrioParentPing{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServicePrioParentPing().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqMyServicePrioParentPingBuilder struct {
    obj *reqMyServicePrioParentPing
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServicePrioParentPing().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqMyServicePrioParentPingBuilder() *reqMyServicePrioParentPingBuilder {
    return &reqMyServicePrioParentPingBuilder{
        obj: newReqMyServicePrioParentPing(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServicePrioParentPing().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqMyServicePrioParentPingBuilder) Emit() *reqMyServicePrioParentPing {
    var objCopy reqMyServicePrioParentPing = *x.obj
    return &objCopy
}

func (x *reqMyServicePrioParentPing) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqMyServicePrioParentPing"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServicePrioParentPing) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqMyServicePrioParentPing) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqMyServicePrioParentPing({")
    sb.WriteString("})")

    return sb.String()
}
type respMyServicePrioParentPing struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServicePrioParentPing{}
var _ thrift.WritableResult = &respMyServicePrioParentPing{}

type MyServicePrioParentPingResult = respMyServicePrioParentPing

func newRespMyServicePrioParentPing() *respMyServicePrioParentPing {
    return (&respMyServicePrioParentPing{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServicePrioParentPing().Set<FieldNameFoo>().Set<FieldNameBar>()
type respMyServicePrioParentPingBuilder struct {
    obj *respMyServicePrioParentPing
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServicePrioParentPing().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespMyServicePrioParentPingBuilder() *respMyServicePrioParentPingBuilder {
    return &respMyServicePrioParentPingBuilder{
        obj: newRespMyServicePrioParentPing(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServicePrioParentPing().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respMyServicePrioParentPingBuilder) Emit() *respMyServicePrioParentPing {
    var objCopy respMyServicePrioParentPing = *x.obj
    return &objCopy
}

func (x *respMyServicePrioParentPing) Exception() thrift.WritableException {
    return nil
}

func (x *respMyServicePrioParentPing) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respMyServicePrioParentPing"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServicePrioParentPing) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respMyServicePrioParentPing) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respMyServicePrioParentPing({")
    sb.WriteString("})")

    return sb.String()
}
type reqMyServicePrioParentPong struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServicePrioParentPong{}

type MyServicePrioParentPongArgs = reqMyServicePrioParentPong

func newReqMyServicePrioParentPong() *reqMyServicePrioParentPong {
    return (&reqMyServicePrioParentPong{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServicePrioParentPong().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqMyServicePrioParentPongBuilder struct {
    obj *reqMyServicePrioParentPong
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServicePrioParentPong().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqMyServicePrioParentPongBuilder() *reqMyServicePrioParentPongBuilder {
    return &reqMyServicePrioParentPongBuilder{
        obj: newReqMyServicePrioParentPong(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServicePrioParentPong().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqMyServicePrioParentPongBuilder) Emit() *reqMyServicePrioParentPong {
    var objCopy reqMyServicePrioParentPong = *x.obj
    return &objCopy
}

func (x *reqMyServicePrioParentPong) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqMyServicePrioParentPong"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServicePrioParentPong) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqMyServicePrioParentPong) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqMyServicePrioParentPong({")
    sb.WriteString("})")

    return sb.String()
}
type respMyServicePrioParentPong struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServicePrioParentPong{}
var _ thrift.WritableResult = &respMyServicePrioParentPong{}

type MyServicePrioParentPongResult = respMyServicePrioParentPong

func newRespMyServicePrioParentPong() *respMyServicePrioParentPong {
    return (&respMyServicePrioParentPong{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServicePrioParentPong().Set<FieldNameFoo>().Set<FieldNameBar>()
type respMyServicePrioParentPongBuilder struct {
    obj *respMyServicePrioParentPong
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServicePrioParentPong().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespMyServicePrioParentPongBuilder() *respMyServicePrioParentPongBuilder {
    return &respMyServicePrioParentPongBuilder{
        obj: newRespMyServicePrioParentPong(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServicePrioParentPong().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respMyServicePrioParentPongBuilder) Emit() *respMyServicePrioParentPong {
    var objCopy respMyServicePrioParentPong = *x.obj
    return &objCopy
}

func (x *respMyServicePrioParentPong) Exception() thrift.WritableException {
    return nil
}

func (x *respMyServicePrioParentPong) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respMyServicePrioParentPong"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServicePrioParentPong) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respMyServicePrioParentPong) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respMyServicePrioParentPong({")
    sb.WriteString("})")

    return sb.String()
}


type MyServicePrioParentProcessor struct {
    processorMap       map[string]thrift.ProcessorFunctionContext
    functionServiceMap map[string]string
    handler            MyServicePrioParent
}
// Compile time interface enforcer
var _ thrift.ProcessorContext = &MyServicePrioParentProcessor{}

func NewMyServicePrioParentProcessor(handler MyServicePrioParent) *MyServicePrioParentProcessor {
    p := &MyServicePrioParentProcessor{
        handler:            handler,
        processorMap:       make(map[string]thrift.ProcessorFunctionContext),
        functionServiceMap: make(map[string]string),
    }
    p.AddToProcessorMap("ping", &procFuncMyServicePrioParentPing{handler: handler})
    p.AddToProcessorMap("pong", &procFuncMyServicePrioParentPong{handler: handler})
    p.AddToFunctionServiceMap("ping", "MyServicePrioParent")
    p.AddToFunctionServiceMap("pong", "MyServicePrioParent")

    return p
}

func (p *MyServicePrioParentProcessor) AddToProcessorMap(key string, processor thrift.ProcessorFunctionContext) {
    p.processorMap[key] = processor
}

func (p *MyServicePrioParentProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *MyServicePrioParentProcessor) GetProcessorFunctionContext(key string) (processor thrift.ProcessorFunctionContext, err error) {
    if processor, ok := p.processorMap[key]; ok {
        return processor, nil
    }
    return nil, nil
}

func (p *MyServicePrioParentProcessor) ProcessorMap() map[string]thrift.ProcessorFunctionContext {
    return p.processorMap
}

func (p *MyServicePrioParentProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func (p *MyServicePrioParentProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.MyServicePrioParent")
}


type procFuncMyServicePrioParentPing struct {
    handler MyServicePrioParent
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncMyServicePrioParentPing{}

func (p *procFuncMyServicePrioParentPing) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServicePrioParentPing()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServicePrioParentPing) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("ping", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServicePrioParentPing) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespMyServicePrioParentPing()
    err := p.handler.Ping(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing Ping: " + err.Error(), err)
        return x, x
    }

    return result, nil
}


type procFuncMyServicePrioParentPong struct {
    handler MyServicePrioParent
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncMyServicePrioParentPong{}

func (p *procFuncMyServicePrioParentPong) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServicePrioParentPong()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServicePrioParentPong) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("pong", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServicePrioParentPong) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespMyServicePrioParentPong()
    err := p.handler.Pong(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing Pong: " + err.Error(), err)
        return x, x
    }

    return result, nil
}




type MyServicePrioChild interface {
    // Inherited/extended service
    MyServicePrioParent

    Pang(ctx context.Context) (error)
}

type MyServicePrioChildChannelClientInterface interface {
    thrift.ClientInterface
    MyServicePrioChild
}

// Deprecated: Migrate to ChannelClient and use MyServicePrioChildChannelClientInterface instead.
type MyServicePrioChildClientInterface interface {
    thrift.ClientInterface
    Pang() (error)
}

type MyServicePrioChildChannelClient struct {
    // Inherited/extended service
    *MyServicePrioParentChannelClient
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ MyServicePrioChildChannelClientInterface = &MyServicePrioChildChannelClient{}

func NewMyServicePrioChildChannelClient(channel thrift.RequestChannel) *MyServicePrioChildChannelClient {
    return &MyServicePrioChildChannelClient{
        MyServicePrioParentChannelClient: NewMyServicePrioParentChannelClient(channel),
        ch: channel,
    }
}

func (c *MyServicePrioChildChannelClient) Close() error {
    return c.ch.Close()
}

func (c *MyServicePrioChildChannelClient) IsOpen() bool {
    return c.ch.IsOpen()
}

func (c *MyServicePrioChildChannelClient) Open() error {
    return c.ch.Open()
}

// Deprecated: Use MyServicePrioChildChannelClient instead.
type MyServicePrioChildClient struct {
    // Inherited/extended service
    *MyServicePrioParentClient
    chClient *MyServicePrioChildChannelClient
    Mu       sync.Mutex
}
// Compile time interface enforcer
var _ MyServicePrioChildClientInterface = &MyServicePrioChildClient{}

// Deprecated: Use NewMyServicePrioChildChannelClient() instead.
func NewMyServicePrioChildClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *MyServicePrioChildClient {
    return &MyServicePrioChildClient{
        MyServicePrioParentClient: NewMyServicePrioParentClient(t, iprot, oprot),
        chClient: NewMyServicePrioChildChannelClient(
            thrift.NewSerialChannel(iprot),
        ),
    }
}

func (c *MyServicePrioChildClient) Close() error {
    return c.chClient.Close()
}

func (c *MyServicePrioChildClient) IsOpen() bool {
    return c.chClient.IsOpen()
}

func (c *MyServicePrioChildClient) Open() error {
    return c.chClient.Open()
}

// Deprecated: Use MyServicePrioChildChannelClient instead.
type MyServicePrioChildThreadsafeClient = MyServicePrioChildClient

// Deprecated: Use NewMyServicePrioChildChannelClient() instead.
func NewMyServicePrioChildThreadsafeClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *MyServicePrioChildThreadsafeClient {
    return NewMyServicePrioChildClient(t, iprot, oprot)
}

// Deprecated: Use NewMyServicePrioChildChannelClient() instead.
func NewMyServicePrioChildClientProtocol(prot thrift.Protocol) *MyServicePrioChildClient {
  return NewMyServicePrioChildClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewMyServicePrioChildChannelClient() instead.
func NewMyServicePrioChildThreadsafeClientProtocol(prot thrift.Protocol) *MyServicePrioChildClient {
  return NewMyServicePrioChildClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewMyServicePrioChildChannelClient() instead.
func NewMyServicePrioChildClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *MyServicePrioChildClient {
  iprot := pf.GetProtocol(t)
  oprot := pf.GetProtocol(t)
  return NewMyServicePrioChildClient(t, iprot, oprot)
}

// Deprecated: Use NewMyServicePrioChildChannelClient() instead.
func NewMyServicePrioChildThreadsafeClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *MyServicePrioChildThreadsafeClient {
  return NewMyServicePrioChildClientFactory(t, pf)
}


func (c *MyServicePrioChildChannelClient) Pang(ctx context.Context) (error) {
    in := &reqMyServicePrioChildPang{
    }
    out := newRespMyServicePrioChildPang()
    err := c.ch.Call(ctx, "pang", in, out)
    if err != nil {
        return err
    }
    return nil
}

func (c *MyServicePrioChildClient) Pang() (error) {
    return c.chClient.Pang(nil)
}


type reqMyServicePrioChildPang struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServicePrioChildPang{}

type MyServicePrioChildPangArgs = reqMyServicePrioChildPang

func newReqMyServicePrioChildPang() *reqMyServicePrioChildPang {
    return (&reqMyServicePrioChildPang{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServicePrioChildPang().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqMyServicePrioChildPangBuilder struct {
    obj *reqMyServicePrioChildPang
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServicePrioChildPang().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqMyServicePrioChildPangBuilder() *reqMyServicePrioChildPangBuilder {
    return &reqMyServicePrioChildPangBuilder{
        obj: newReqMyServicePrioChildPang(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqMyServicePrioChildPang().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqMyServicePrioChildPangBuilder) Emit() *reqMyServicePrioChildPang {
    var objCopy reqMyServicePrioChildPang = *x.obj
    return &objCopy
}

func (x *reqMyServicePrioChildPang) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqMyServicePrioChildPang"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServicePrioChildPang) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqMyServicePrioChildPang) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqMyServicePrioChildPang({")
    sb.WriteString("})")

    return sb.String()
}
type respMyServicePrioChildPang struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServicePrioChildPang{}
var _ thrift.WritableResult = &respMyServicePrioChildPang{}

type MyServicePrioChildPangResult = respMyServicePrioChildPang

func newRespMyServicePrioChildPang() *respMyServicePrioChildPang {
    return (&respMyServicePrioChildPang{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServicePrioChildPang().Set<FieldNameFoo>().Set<FieldNameBar>()
type respMyServicePrioChildPangBuilder struct {
    obj *respMyServicePrioChildPang
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServicePrioChildPang().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespMyServicePrioChildPangBuilder() *respMyServicePrioChildPangBuilder {
    return &respMyServicePrioChildPangBuilder{
        obj: newRespMyServicePrioChildPang(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespMyServicePrioChildPang().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respMyServicePrioChildPangBuilder) Emit() *respMyServicePrioChildPang {
    var objCopy respMyServicePrioChildPang = *x.obj
    return &objCopy
}

func (x *respMyServicePrioChildPang) Exception() thrift.WritableException {
    return nil
}

func (x *respMyServicePrioChildPang) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respMyServicePrioChildPang"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServicePrioChildPang) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respMyServicePrioChildPang) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respMyServicePrioChildPang({")
    sb.WriteString("})")

    return sb.String()
}


type MyServicePrioChildProcessor struct {
    // Inherited/extended processor
    *MyServicePrioParentProcessor
}
// Compile time interface enforcer
var _ thrift.ProcessorContext = &MyServicePrioChildProcessor{}

func NewMyServicePrioChildProcessor(handler MyServicePrioChild) *MyServicePrioChildProcessor {
    p := &MyServicePrioChildProcessor{
        NewMyServicePrioParentProcessor(handler),
    }
    p.AddToProcessorMap("pang", &procFuncMyServicePrioChildPang{handler: handler})
    p.AddToFunctionServiceMap("pang", "MyServicePrioChild")

    return p
}

func (p *MyServicePrioChildProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.MyServicePrioChild")
}


type procFuncMyServicePrioChildPang struct {
    handler MyServicePrioChild
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncMyServicePrioChildPang{}

func (p *procFuncMyServicePrioChildPang) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServicePrioChildPang()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServicePrioChildPang) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("pang", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServicePrioChildPang) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespMyServicePrioChildPang()
    err := p.handler.Pang(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing Pang: " + err.Error(), err)
        return x, x
    }

    return result, nil
}




type BadService interface {
    Bar(ctx context.Context) (int32, error)
}

type BadServiceChannelClientInterface interface {
    thrift.ClientInterface
    BadService
}

// Deprecated: Migrate to ChannelClient and use BadServiceChannelClientInterface instead.
type BadServiceClientInterface interface {
    thrift.ClientInterface
    Bar() (int32, error)
}

type BadServiceChannelClient struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ BadServiceChannelClientInterface = &BadServiceChannelClient{}

func NewBadServiceChannelClient(channel thrift.RequestChannel) *BadServiceChannelClient {
    return &BadServiceChannelClient{
        ch: channel,
    }
}

func (c *BadServiceChannelClient) Close() error {
    return c.ch.Close()
}

func (c *BadServiceChannelClient) IsOpen() bool {
    return c.ch.IsOpen()
}

func (c *BadServiceChannelClient) Open() error {
    return c.ch.Open()
}

// Deprecated: Use BadServiceChannelClient instead.
type BadServiceClient struct {
    chClient *BadServiceChannelClient
    Mu       sync.Mutex
}
// Compile time interface enforcer
var _ BadServiceClientInterface = &BadServiceClient{}

// Deprecated: Use NewBadServiceChannelClient() instead.
func NewBadServiceClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *BadServiceClient {
    return &BadServiceClient{
        chClient: NewBadServiceChannelClient(
            thrift.NewSerialChannel(iprot),
        ),
    }
}

func (c *BadServiceClient) Close() error {
    return c.chClient.Close()
}

func (c *BadServiceClient) IsOpen() bool {
    return c.chClient.IsOpen()
}

func (c *BadServiceClient) Open() error {
    return c.chClient.Open()
}

// Deprecated: Use BadServiceChannelClient instead.
type BadServiceThreadsafeClient = BadServiceClient

// Deprecated: Use NewBadServiceChannelClient() instead.
func NewBadServiceThreadsafeClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *BadServiceThreadsafeClient {
    return NewBadServiceClient(t, iprot, oprot)
}

// Deprecated: Use NewBadServiceChannelClient() instead.
func NewBadServiceClientProtocol(prot thrift.Protocol) *BadServiceClient {
  return NewBadServiceClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewBadServiceChannelClient() instead.
func NewBadServiceThreadsafeClientProtocol(prot thrift.Protocol) *BadServiceClient {
  return NewBadServiceClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewBadServiceChannelClient() instead.
func NewBadServiceClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *BadServiceClient {
  iprot := pf.GetProtocol(t)
  oprot := pf.GetProtocol(t)
  return NewBadServiceClient(t, iprot, oprot)
}

// Deprecated: Use NewBadServiceChannelClient() instead.
func NewBadServiceThreadsafeClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *BadServiceThreadsafeClient {
  return NewBadServiceClientFactory(t, pf)
}


func (c *BadServiceChannelClient) Bar(ctx context.Context) (int32, error) {
    in := &reqBadServiceBar{
    }
    out := newRespBadServiceBar()
    err := c.ch.Call(ctx, "bar", in, out)
    if err != nil {
        return 0, err
    }
    return out.GetSuccess(), nil
}

func (c *BadServiceClient) Bar() (int32, error) {
    return c.chClient.Bar(nil)
}


type reqBadServiceBar struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqBadServiceBar{}

type BadServiceBarArgs = reqBadServiceBar

func newReqBadServiceBar() *reqBadServiceBar {
    return (&reqBadServiceBar{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqBadServiceBar().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqBadServiceBarBuilder struct {
    obj *reqBadServiceBar
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqBadServiceBar().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqBadServiceBarBuilder() *reqBadServiceBarBuilder {
    return &reqBadServiceBarBuilder{
        obj: newReqBadServiceBar(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqBadServiceBar().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqBadServiceBarBuilder) Emit() *reqBadServiceBar {
    var objCopy reqBadServiceBar = *x.obj
    return &objCopy
}

func (x *reqBadServiceBar) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqBadServiceBar"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqBadServiceBar) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqBadServiceBar) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqBadServiceBar({")
    sb.WriteString("})")

    return sb.String()
}
type respBadServiceBar struct {
    Success *int32 `thrift:"success,0,optional" json:"success,omitempty" db:"success"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respBadServiceBar{}
var _ thrift.WritableResult = &respBadServiceBar{}

type BadServiceBarResult = respBadServiceBar

func newRespBadServiceBar() *respBadServiceBar {
    return (&respBadServiceBar{})
}

func (x *respBadServiceBar) GetSuccessNonCompat() *int32 {
    return x.Success
}

func (x *respBadServiceBar) GetSuccess() int32 {
    if !x.IsSetSuccess() {
        return 0
    }

    return *x.Success
}

func (x *respBadServiceBar) SetSuccessNonCompat(value int32) *respBadServiceBar {
    x.Success = &value
    return x
}

func (x *respBadServiceBar) SetSuccess(value *int32) *respBadServiceBar {
    x.Success = value
    return x
}

func (x *respBadServiceBar) IsSetSuccess() bool {
    return x != nil && x.Success != nil
}

func (x *respBadServiceBar) writeField0(p thrift.Protocol) error {  // Success
    if !x.IsSetSuccess() {
        return nil
    }

    if err := p.WriteFieldBegin("success", thrift.I32, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetSuccessNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respBadServiceBar) readField0(p thrift.Protocol) error {  // Success
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetSuccessNonCompat(result)
    return nil
}

func (x *respBadServiceBar) toString0() string {  // Success
    if x.IsSetSuccess() {
        return fmt.Sprintf("%v", *x.GetSuccessNonCompat())
    }
    return fmt.Sprintf("%v", x.GetSuccessNonCompat())
}



// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespBadServiceBar().Set<FieldNameFoo>().Set<FieldNameBar>()
type respBadServiceBarBuilder struct {
    obj *respBadServiceBar
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespBadServiceBar().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespBadServiceBarBuilder() *respBadServiceBarBuilder {
    return &respBadServiceBarBuilder{
        obj: newRespBadServiceBar(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespBadServiceBar().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respBadServiceBarBuilder) Success(value *int32) *respBadServiceBarBuilder {
    x.obj.Success = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespBadServiceBar().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respBadServiceBarBuilder) Emit() *respBadServiceBar {
    var objCopy respBadServiceBar = *x.obj
    return &objCopy
}

func (x *respBadServiceBar) Exception() thrift.WritableException {
    return nil
}

func (x *respBadServiceBar) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respBadServiceBar"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respBadServiceBar) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 0 && wireType == thrift.Type(thrift.I32)):  // success
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respBadServiceBar) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respBadServiceBar({")
    sb.WriteString(fmt.Sprintf("Success:%s", x.toString0()))
    sb.WriteString("})")

    return sb.String()
}


type BadServiceProcessor struct {
    processorMap       map[string]thrift.ProcessorFunctionContext
    functionServiceMap map[string]string
    handler            BadService
}
// Compile time interface enforcer
var _ thrift.ProcessorContext = &BadServiceProcessor{}

func NewBadServiceProcessor(handler BadService) *BadServiceProcessor {
    p := &BadServiceProcessor{
        handler:            handler,
        processorMap:       make(map[string]thrift.ProcessorFunctionContext),
        functionServiceMap: make(map[string]string),
    }
    p.AddToProcessorMap("bar", &procFuncBadServiceBar{handler: handler})
    p.AddToFunctionServiceMap("bar", "BadService")

    return p
}

func (p *BadServiceProcessor) AddToProcessorMap(key string, processor thrift.ProcessorFunctionContext) {
    p.processorMap[key] = processor
}

func (p *BadServiceProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *BadServiceProcessor) GetProcessorFunctionContext(key string) (processor thrift.ProcessorFunctionContext, err error) {
    if processor, ok := p.processorMap[key]; ok {
        return processor, nil
    }
    return nil, nil
}

func (p *BadServiceProcessor) ProcessorMap() map[string]thrift.ProcessorFunctionContext {
    return p.processorMap
}

func (p *BadServiceProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func (p *BadServiceProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.BadService")
}


type procFuncBadServiceBar struct {
    handler BadService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncBadServiceBar{}

func (p *procFuncBadServiceBar) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqBadServiceBar()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncBadServiceBar) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("bar", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncBadServiceBar) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespBadServiceBar()
    retval, err := p.handler.Bar(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing Bar: " + err.Error(), err)
        return x, x
    }

    result.Success = &retval
    return result, nil
}




type FooBarBazService interface {
    FooStructured(ctx context.Context) (error)
    BarNonStructured(ctx context.Context) (error)
    Baz(ctx context.Context) (error)
}

type FooBarBazServiceChannelClientInterface interface {
    thrift.ClientInterface
    FooBarBazService
}

// Deprecated: Migrate to ChannelClient and use FooBarBazServiceChannelClientInterface instead.
type FooBarBazServiceClientInterface interface {
    thrift.ClientInterface
    FooStructured() (error)
    BarNonStructured() (error)
    Baz() (error)
}

type FooBarBazServiceChannelClient struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ FooBarBazServiceChannelClientInterface = &FooBarBazServiceChannelClient{}

func NewFooBarBazServiceChannelClient(channel thrift.RequestChannel) *FooBarBazServiceChannelClient {
    return &FooBarBazServiceChannelClient{
        ch: channel,
    }
}

func (c *FooBarBazServiceChannelClient) Close() error {
    return c.ch.Close()
}

func (c *FooBarBazServiceChannelClient) IsOpen() bool {
    return c.ch.IsOpen()
}

func (c *FooBarBazServiceChannelClient) Open() error {
    return c.ch.Open()
}

// Deprecated: Use FooBarBazServiceChannelClient instead.
type FooBarBazServiceClient struct {
    chClient *FooBarBazServiceChannelClient
    Mu       sync.Mutex
}
// Compile time interface enforcer
var _ FooBarBazServiceClientInterface = &FooBarBazServiceClient{}

// Deprecated: Use NewFooBarBazServiceChannelClient() instead.
func NewFooBarBazServiceClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *FooBarBazServiceClient {
    return &FooBarBazServiceClient{
        chClient: NewFooBarBazServiceChannelClient(
            thrift.NewSerialChannel(iprot),
        ),
    }
}

func (c *FooBarBazServiceClient) Close() error {
    return c.chClient.Close()
}

func (c *FooBarBazServiceClient) IsOpen() bool {
    return c.chClient.IsOpen()
}

func (c *FooBarBazServiceClient) Open() error {
    return c.chClient.Open()
}

// Deprecated: Use FooBarBazServiceChannelClient instead.
type FooBarBazServiceThreadsafeClient = FooBarBazServiceClient

// Deprecated: Use NewFooBarBazServiceChannelClient() instead.
func NewFooBarBazServiceThreadsafeClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *FooBarBazServiceThreadsafeClient {
    return NewFooBarBazServiceClient(t, iprot, oprot)
}

// Deprecated: Use NewFooBarBazServiceChannelClient() instead.
func NewFooBarBazServiceClientProtocol(prot thrift.Protocol) *FooBarBazServiceClient {
  return NewFooBarBazServiceClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewFooBarBazServiceChannelClient() instead.
func NewFooBarBazServiceThreadsafeClientProtocol(prot thrift.Protocol) *FooBarBazServiceClient {
  return NewFooBarBazServiceClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewFooBarBazServiceChannelClient() instead.
func NewFooBarBazServiceClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *FooBarBazServiceClient {
  iprot := pf.GetProtocol(t)
  oprot := pf.GetProtocol(t)
  return NewFooBarBazServiceClient(t, iprot, oprot)
}

// Deprecated: Use NewFooBarBazServiceChannelClient() instead.
func NewFooBarBazServiceThreadsafeClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *FooBarBazServiceThreadsafeClient {
  return NewFooBarBazServiceClientFactory(t, pf)
}


func (c *FooBarBazServiceChannelClient) FooStructured(ctx context.Context) (error) {
    in := &reqFooBarBazServiceFooStructured{
    }
    out := newRespFooBarBazServiceFooStructured()
    err := c.ch.Call(ctx, "foo", in, out)
    if err != nil {
        return err
    }
    return nil
}

func (c *FooBarBazServiceClient) FooStructured() (error) {
    return c.chClient.FooStructured(nil)
}


func (c *FooBarBazServiceChannelClient) BarNonStructured(ctx context.Context) (error) {
    in := &reqFooBarBazServiceBarNonStructured{
    }
    out := newRespFooBarBazServiceBarNonStructured()
    err := c.ch.Call(ctx, "bar", in, out)
    if err != nil {
        return err
    }
    return nil
}

func (c *FooBarBazServiceClient) BarNonStructured() (error) {
    return c.chClient.BarNonStructured(nil)
}


func (c *FooBarBazServiceChannelClient) Baz(ctx context.Context) (error) {
    in := &reqFooBarBazServiceBaz{
    }
    out := newRespFooBarBazServiceBaz()
    err := c.ch.Call(ctx, "baz", in, out)
    if err != nil {
        return err
    }
    return nil
}

func (c *FooBarBazServiceClient) Baz() (error) {
    return c.chClient.Baz(nil)
}


type reqFooBarBazServiceFooStructured struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqFooBarBazServiceFooStructured{}

type FooBarBazServiceFooStructuredArgs = reqFooBarBazServiceFooStructured

func newReqFooBarBazServiceFooStructured() *reqFooBarBazServiceFooStructured {
    return (&reqFooBarBazServiceFooStructured{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqFooBarBazServiceFooStructured().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqFooBarBazServiceFooStructuredBuilder struct {
    obj *reqFooBarBazServiceFooStructured
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqFooBarBazServiceFooStructured().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqFooBarBazServiceFooStructuredBuilder() *reqFooBarBazServiceFooStructuredBuilder {
    return &reqFooBarBazServiceFooStructuredBuilder{
        obj: newReqFooBarBazServiceFooStructured(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqFooBarBazServiceFooStructured().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqFooBarBazServiceFooStructuredBuilder) Emit() *reqFooBarBazServiceFooStructured {
    var objCopy reqFooBarBazServiceFooStructured = *x.obj
    return &objCopy
}

func (x *reqFooBarBazServiceFooStructured) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqFooBarBazServiceFooStructured"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqFooBarBazServiceFooStructured) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqFooBarBazServiceFooStructured) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqFooBarBazServiceFooStructured({")
    sb.WriteString("})")

    return sb.String()
}
type respFooBarBazServiceFooStructured struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &respFooBarBazServiceFooStructured{}
var _ thrift.WritableResult = &respFooBarBazServiceFooStructured{}

type FooBarBazServiceFooStructuredResult = respFooBarBazServiceFooStructured

func newRespFooBarBazServiceFooStructured() *respFooBarBazServiceFooStructured {
    return (&respFooBarBazServiceFooStructured{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespFooBarBazServiceFooStructured().Set<FieldNameFoo>().Set<FieldNameBar>()
type respFooBarBazServiceFooStructuredBuilder struct {
    obj *respFooBarBazServiceFooStructured
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespFooBarBazServiceFooStructured().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespFooBarBazServiceFooStructuredBuilder() *respFooBarBazServiceFooStructuredBuilder {
    return &respFooBarBazServiceFooStructuredBuilder{
        obj: newRespFooBarBazServiceFooStructured(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespFooBarBazServiceFooStructured().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respFooBarBazServiceFooStructuredBuilder) Emit() *respFooBarBazServiceFooStructured {
    var objCopy respFooBarBazServiceFooStructured = *x.obj
    return &objCopy
}

func (x *respFooBarBazServiceFooStructured) Exception() thrift.WritableException {
    return nil
}

func (x *respFooBarBazServiceFooStructured) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respFooBarBazServiceFooStructured"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respFooBarBazServiceFooStructured) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respFooBarBazServiceFooStructured) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respFooBarBazServiceFooStructured({")
    sb.WriteString("})")

    return sb.String()
}
type reqFooBarBazServiceBarNonStructured struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqFooBarBazServiceBarNonStructured{}

type FooBarBazServiceBarNonStructuredArgs = reqFooBarBazServiceBarNonStructured

func newReqFooBarBazServiceBarNonStructured() *reqFooBarBazServiceBarNonStructured {
    return (&reqFooBarBazServiceBarNonStructured{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqFooBarBazServiceBarNonStructured().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqFooBarBazServiceBarNonStructuredBuilder struct {
    obj *reqFooBarBazServiceBarNonStructured
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqFooBarBazServiceBarNonStructured().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqFooBarBazServiceBarNonStructuredBuilder() *reqFooBarBazServiceBarNonStructuredBuilder {
    return &reqFooBarBazServiceBarNonStructuredBuilder{
        obj: newReqFooBarBazServiceBarNonStructured(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqFooBarBazServiceBarNonStructured().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqFooBarBazServiceBarNonStructuredBuilder) Emit() *reqFooBarBazServiceBarNonStructured {
    var objCopy reqFooBarBazServiceBarNonStructured = *x.obj
    return &objCopy
}

func (x *reqFooBarBazServiceBarNonStructured) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqFooBarBazServiceBarNonStructured"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqFooBarBazServiceBarNonStructured) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqFooBarBazServiceBarNonStructured) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqFooBarBazServiceBarNonStructured({")
    sb.WriteString("})")

    return sb.String()
}
type respFooBarBazServiceBarNonStructured struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &respFooBarBazServiceBarNonStructured{}
var _ thrift.WritableResult = &respFooBarBazServiceBarNonStructured{}

type FooBarBazServiceBarNonStructuredResult = respFooBarBazServiceBarNonStructured

func newRespFooBarBazServiceBarNonStructured() *respFooBarBazServiceBarNonStructured {
    return (&respFooBarBazServiceBarNonStructured{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespFooBarBazServiceBarNonStructured().Set<FieldNameFoo>().Set<FieldNameBar>()
type respFooBarBazServiceBarNonStructuredBuilder struct {
    obj *respFooBarBazServiceBarNonStructured
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespFooBarBazServiceBarNonStructured().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespFooBarBazServiceBarNonStructuredBuilder() *respFooBarBazServiceBarNonStructuredBuilder {
    return &respFooBarBazServiceBarNonStructuredBuilder{
        obj: newRespFooBarBazServiceBarNonStructured(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespFooBarBazServiceBarNonStructured().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respFooBarBazServiceBarNonStructuredBuilder) Emit() *respFooBarBazServiceBarNonStructured {
    var objCopy respFooBarBazServiceBarNonStructured = *x.obj
    return &objCopy
}

func (x *respFooBarBazServiceBarNonStructured) Exception() thrift.WritableException {
    return nil
}

func (x *respFooBarBazServiceBarNonStructured) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respFooBarBazServiceBarNonStructured"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respFooBarBazServiceBarNonStructured) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respFooBarBazServiceBarNonStructured) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respFooBarBazServiceBarNonStructured({")
    sb.WriteString("})")

    return sb.String()
}
type reqFooBarBazServiceBaz struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqFooBarBazServiceBaz{}

type FooBarBazServiceBazArgs = reqFooBarBazServiceBaz

func newReqFooBarBazServiceBaz() *reqFooBarBazServiceBaz {
    return (&reqFooBarBazServiceBaz{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqFooBarBazServiceBaz().Set<FieldNameFoo>().Set<FieldNameBar>()
type reqFooBarBazServiceBazBuilder struct {
    obj *reqFooBarBazServiceBaz
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqFooBarBazServiceBaz().Set<FieldNameFoo>().Set<FieldNameBar>()
func newReqFooBarBazServiceBazBuilder() *reqFooBarBazServiceBazBuilder {
    return &reqFooBarBazServiceBazBuilder{
        obj: newReqFooBarBazServiceBaz(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newReqFooBarBazServiceBaz().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *reqFooBarBazServiceBazBuilder) Emit() *reqFooBarBazServiceBaz {
    var objCopy reqFooBarBazServiceBaz = *x.obj
    return &objCopy
}

func (x *reqFooBarBazServiceBaz) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("reqFooBarBazServiceBaz"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqFooBarBazServiceBaz) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *reqFooBarBazServiceBaz) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("reqFooBarBazServiceBaz({")
    sb.WriteString("})")

    return sb.String()
}
type respFooBarBazServiceBaz struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &respFooBarBazServiceBaz{}
var _ thrift.WritableResult = &respFooBarBazServiceBaz{}

type FooBarBazServiceBazResult = respFooBarBazServiceBaz

func newRespFooBarBazServiceBaz() *respFooBarBazServiceBaz {
    return (&respFooBarBazServiceBaz{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespFooBarBazServiceBaz().Set<FieldNameFoo>().Set<FieldNameBar>()
type respFooBarBazServiceBazBuilder struct {
    obj *respFooBarBazServiceBaz
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespFooBarBazServiceBaz().Set<FieldNameFoo>().Set<FieldNameBar>()
func newRespFooBarBazServiceBazBuilder() *respFooBarBazServiceBazBuilder {
    return &respFooBarBazServiceBazBuilder{
        obj: newRespFooBarBazServiceBaz(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g newRespFooBarBazServiceBaz().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *respFooBarBazServiceBazBuilder) Emit() *respFooBarBazServiceBaz {
    var objCopy respFooBarBazServiceBaz = *x.obj
    return &objCopy
}

func (x *respFooBarBazServiceBaz) Exception() thrift.WritableException {
    return nil
}

func (x *respFooBarBazServiceBaz) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("respFooBarBazServiceBaz"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respFooBarBazServiceBaz) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *respFooBarBazServiceBaz) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("respFooBarBazServiceBaz({")
    sb.WriteString("})")

    return sb.String()
}


type FooBarBazServiceProcessor struct {
    processorMap       map[string]thrift.ProcessorFunctionContext
    functionServiceMap map[string]string
    handler            FooBarBazService
}
// Compile time interface enforcer
var _ thrift.ProcessorContext = &FooBarBazServiceProcessor{}

func NewFooBarBazServiceProcessor(handler FooBarBazService) *FooBarBazServiceProcessor {
    p := &FooBarBazServiceProcessor{
        handler:            handler,
        processorMap:       make(map[string]thrift.ProcessorFunctionContext),
        functionServiceMap: make(map[string]string),
    }
    p.AddToProcessorMap("foo", &procFuncFooBarBazServiceFooStructured{handler: handler})
    p.AddToProcessorMap("bar", &procFuncFooBarBazServiceBarNonStructured{handler: handler})
    p.AddToProcessorMap("baz", &procFuncFooBarBazServiceBaz{handler: handler})
    p.AddToFunctionServiceMap("foo", "FooBarBazService")
    p.AddToFunctionServiceMap("bar", "FooBarBazService")
    p.AddToFunctionServiceMap("baz", "FooBarBazService")

    return p
}

func (p *FooBarBazServiceProcessor) AddToProcessorMap(key string, processor thrift.ProcessorFunctionContext) {
    p.processorMap[key] = processor
}

func (p *FooBarBazServiceProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *FooBarBazServiceProcessor) GetProcessorFunctionContext(key string) (processor thrift.ProcessorFunctionContext, err error) {
    if processor, ok := p.processorMap[key]; ok {
        return processor, nil
    }
    return nil, nil
}

func (p *FooBarBazServiceProcessor) ProcessorMap() map[string]thrift.ProcessorFunctionContext {
    return p.processorMap
}

func (p *FooBarBazServiceProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func (p *FooBarBazServiceProcessor) GetThriftMetadata() *metadata.ThriftMetadata {
    return GetThriftMetadataForService("module.FooBarBazService")
}


type procFuncFooBarBazServiceFooStructured struct {
    handler FooBarBazService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncFooBarBazServiceFooStructured{}

func (p *procFuncFooBarBazServiceFooStructured) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqFooBarBazServiceFooStructured()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncFooBarBazServiceFooStructured) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("foo", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncFooBarBazServiceFooStructured) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespFooBarBazServiceFooStructured()
    err := p.handler.FooStructured(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing FooStructured: " + err.Error(), err)
        return x, x
    }

    return result, nil
}


type procFuncFooBarBazServiceBarNonStructured struct {
    handler FooBarBazService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncFooBarBazServiceBarNonStructured{}

func (p *procFuncFooBarBazServiceBarNonStructured) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqFooBarBazServiceBarNonStructured()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncFooBarBazServiceBarNonStructured) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("bar", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncFooBarBazServiceBarNonStructured) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespFooBarBazServiceBarNonStructured()
    err := p.handler.BarNonStructured(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing BarNonStructured: " + err.Error(), err)
        return x, x
    }

    return result, nil
}


type procFuncFooBarBazServiceBaz struct {
    handler FooBarBazService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunctionContext = &procFuncFooBarBazServiceBaz{}

func (p *procFuncFooBarBazServiceBaz) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqFooBarBazServiceBaz()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncFooBarBazServiceBaz) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    switch result.(type) {
    case thrift.ApplicationException:
        messageType = thrift.EXCEPTION
    }

    if err2 = oprot.WriteMessageBegin("baz", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncFooBarBazServiceBaz) RunContext(ctx context.Context, reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespFooBarBazServiceBaz()
    err := p.handler.Baz(ctx)
    if err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing Baz: " + err.Error(), err)
        return x, x
    }

    return result, nil
}


