// @generated by Thrift for [[[ program path ]]]
// This file is probably not the place you want to edit!

package module // [[[ program thrift source path ]]]

import (
    "fmt"
    "strings"

    thrift "github.com/facebook/fbthrift/thrift/lib/go/thrift"
)

// (needed to ensure safety because of naive import list construction)
var _ = fmt.Printf
var _ = strings.Split
var _ = thrift.ZERO


type SetWithAdapter = []string

func NewSetWithAdapter() SetWithAdapter {
    return make([]string, 0)
}

func WriteSetWithAdapter(item SetWithAdapter, p thrift.Protocol) error {
    if err := p.WriteSetBegin(thrift.STRING, len(item)); err != nil {
    return thrift.PrependError("error writing set begin: ", err)
}
for _, v := range item {
    {
        item := v
        if err := p.WriteString(item); err != nil {
    return err
}
    }
}
if err := p.WriteSetEnd(); err != nil {
    return thrift.PrependError("error writing set end: ", err)
}
    return nil
}

func ReadSetWithAdapter(p thrift.Protocol) (SetWithAdapter, error) {
    var decodeResult SetWithAdapter
    decodeErr := func() error {
        _ /* elemType */, size, err := p.ReadSetBegin()
if err != nil {
    return thrift.PrependError("error reading set begin: ", err)
}

setResult := make([]string, 0, size)
for i := 0; i < size; i++ {
    var elem string
    {
        result, err := p.ReadString()
if err != nil {
    return err
}
        elem = result
    }
    setResult = append(setResult, elem)
}

if err := p.ReadSetEnd(); err != nil {
    return thrift.PrependError("error reading set end: ", err)
}
result := setResult
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type StringWithAdapter = string

func NewStringWithAdapter() StringWithAdapter {
    return ""
}

func WriteStringWithAdapter(item StringWithAdapter, p thrift.Protocol) error {
    if err := p.WriteString(item); err != nil {
    return err
}
    return nil
}

func ReadStringWithAdapter(p thrift.Protocol) (StringWithAdapter, error) {
    var decodeResult StringWithAdapter
    decodeErr := func() error {
        result, err := p.ReadString()
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type ListWithElemAdapter = []StringWithAdapter

func NewListWithElemAdapter() ListWithElemAdapter {
    return make([]StringWithAdapter, 0)
}

func WriteListWithElemAdapter(item ListWithElemAdapter, p thrift.Protocol) error {
    if err := p.WriteListBegin(thrift.STRING, len(item)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
}
for _, v := range item {
    {
        item := v
        err := WriteStringWithAdapter(item, p)
if err != nil {
    return err
}
    }
}
if err := p.WriteListEnd(); err != nil {
    return thrift.PrependError("error writing list end: ", err)
}
    return nil
}

func ReadListWithElemAdapter(p thrift.Protocol) (ListWithElemAdapter, error) {
    var decodeResult ListWithElemAdapter
    decodeErr := func() error {
        _ /* elemType */, size, err := p.ReadListBegin()
if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
}

listResult := make([]StringWithAdapter, 0, size)
for i := 0; i < size; i++ {
    var elem StringWithAdapter
    {
        result, err := ReadStringWithAdapter(p)
if err != nil {
    return err
}
        elem = result
    }
    listResult = append(listResult, elem)
}

if err := p.ReadListEnd(); err != nil {
    return thrift.PrependError("error reading list end: ", err)
}
result := listResult
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type ListWithElemAdapterWithAdapter = ListWithElemAdapter

func NewListWithElemAdapterWithAdapter() ListWithElemAdapterWithAdapter {
    return NewListWithElemAdapter()
}

func WriteListWithElemAdapterWithAdapter(item ListWithElemAdapterWithAdapter, p thrift.Protocol) error {
    err := WriteListWithElemAdapter(item, p)
if err != nil {
    return err
}
    return nil
}

func ReadListWithElemAdapterWithAdapter(p thrift.Protocol) (ListWithElemAdapterWithAdapter, error) {
    var decodeResult ListWithElemAdapterWithAdapter
    decodeErr := func() error {
        result, err := ReadListWithElemAdapter(p)
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type MyI64 = int64

func NewMyI64() MyI64 {
    return 0
}

func WriteMyI64(item MyI64, p thrift.Protocol) error {
    if err := p.WriteI64(item); err != nil {
    return err
}
    return nil
}

func ReadMyI64(p thrift.Protocol) (MyI64, error) {
    var decodeResult MyI64
    decodeErr := func() error {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type DoubleTypedefI64 = MyI64

func NewDoubleTypedefI64() DoubleTypedefI64 {
    return NewMyI64()
}

func WriteDoubleTypedefI64(item DoubleTypedefI64, p thrift.Protocol) error {
    err := WriteMyI64(item, p)
if err != nil {
    return err
}
    return nil
}

func ReadDoubleTypedefI64(p thrift.Protocol) (DoubleTypedefI64, error) {
    var decodeResult DoubleTypedefI64
    decodeErr := func() error {
        result, err := ReadMyI64(p)
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type MyI32 = int32

func NewMyI32() MyI32 {
    return 0
}

func WriteMyI32(item MyI32, p thrift.Protocol) error {
    if err := p.WriteI32(item); err != nil {
    return err
}
    return nil
}

func ReadMyI32(p thrift.Protocol) (MyI32, error) {
    var decodeResult MyI32
    decodeErr := func() error {
        result, err := p.ReadI32()
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type FooWithAdapter = Foo

func NewFooWithAdapter() *FooWithAdapter {
    return NewFoo()
}

func WriteFooWithAdapter(item *FooWithAdapter, p thrift.Protocol) error {
    if err := item.Write(p); err != nil {
    return err
}
    return nil
}

func ReadFooWithAdapter(p thrift.Protocol) (FooWithAdapter, error) {
    var decodeResult FooWithAdapter
    decodeErr := func() error {
        result := *NewFoo()
err := result.Read(p)
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type StructWithAdapter = Bar

func NewStructWithAdapter() *StructWithAdapter {
    return NewBar()
}

func WriteStructWithAdapter(item *StructWithAdapter, p thrift.Protocol) error {
    if err := item.Write(p); err != nil {
    return err
}
    return nil
}

func ReadStructWithAdapter(p thrift.Protocol) (StructWithAdapter, error) {
    var decodeResult StructWithAdapter
    decodeErr := func() error {
        result := *NewBar()
err := result.Read(p)
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type UnionWithAdapter = Baz

func NewUnionWithAdapter() *UnionWithAdapter {
    return NewBaz()
}

func WriteUnionWithAdapter(item *UnionWithAdapter, p thrift.Protocol) error {
    if err := item.Write(p); err != nil {
    return err
}
    return nil
}

func ReadUnionWithAdapter(p thrift.Protocol) (UnionWithAdapter, error) {
    var decodeResult UnionWithAdapter
    decodeErr := func() error {
        result := *NewBaz()
err := result.Read(p)
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type AdaptedA = A

func NewAdaptedA() *AdaptedA {
    return NewA()
}

func WriteAdaptedA(item *AdaptedA, p thrift.Protocol) error {
    if err := item.Write(p); err != nil {
    return err
}
    return nil
}

func ReadAdaptedA(p thrift.Protocol) (AdaptedA, error) {
    var decodeResult AdaptedA
    decodeErr := func() error {
        result := *NewA()
err := result.Read(p)
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type DurationMs = int64

func NewDurationMs() DurationMs {
    return 0
}

func WriteDurationMs(item DurationMs, p thrift.Protocol) error {
    if err := p.WriteI64(item); err != nil {
    return err
}
    return nil
}

func ReadDurationMs(p thrift.Protocol) (DurationMs, error) {
    var decodeResult DurationMs
    decodeErr := func() error {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type AdaptedBool = bool

func NewAdaptedBool() AdaptedBool {
    return false
}

func WriteAdaptedBool(item AdaptedBool, p thrift.Protocol) error {
    if err := p.WriteBool(item); err != nil {
    return err
}
    return nil
}

func ReadAdaptedBool(p thrift.Protocol) (AdaptedBool, error) {
    var decodeResult AdaptedBool
    decodeErr := func() error {
        result, err := p.ReadBool()
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type AdaptedByte = int8

func NewAdaptedByte() AdaptedByte {
    return 0
}

func WriteAdaptedByte(item AdaptedByte, p thrift.Protocol) error {
    if err := p.WriteByte(byte(item)); err != nil {
    return err
}
    return nil
}

func ReadAdaptedByte(p thrift.Protocol) (AdaptedByte, error) {
    var decodeResult AdaptedByte
    decodeErr := func() error {
        resultByte, err := p.ReadByte()
result := int8(resultByte)
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type AdaptedShort = int16

func NewAdaptedShort() AdaptedShort {
    return 0
}

func WriteAdaptedShort(item AdaptedShort, p thrift.Protocol) error {
    if err := p.WriteI16(item); err != nil {
    return err
}
    return nil
}

func ReadAdaptedShort(p thrift.Protocol) (AdaptedShort, error) {
    var decodeResult AdaptedShort
    decodeErr := func() error {
        result, err := p.ReadI16()
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type AdaptedInteger = int32

func NewAdaptedInteger() AdaptedInteger {
    return 0
}

func WriteAdaptedInteger(item AdaptedInteger, p thrift.Protocol) error {
    if err := p.WriteI32(item); err != nil {
    return err
}
    return nil
}

func ReadAdaptedInteger(p thrift.Protocol) (AdaptedInteger, error) {
    var decodeResult AdaptedInteger
    decodeErr := func() error {
        result, err := p.ReadI32()
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type AdaptedLong = int64

func NewAdaptedLong() AdaptedLong {
    return 0
}

func WriteAdaptedLong(item AdaptedLong, p thrift.Protocol) error {
    if err := p.WriteI64(item); err != nil {
    return err
}
    return nil
}

func ReadAdaptedLong(p thrift.Protocol) (AdaptedLong, error) {
    var decodeResult AdaptedLong
    decodeErr := func() error {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type AdaptedDouble = float64

func NewAdaptedDouble() AdaptedDouble {
    return 0.0
}

func WriteAdaptedDouble(item AdaptedDouble, p thrift.Protocol) error {
    if err := p.WriteDouble(item); err != nil {
    return err
}
    return nil
}

func ReadAdaptedDouble(p thrift.Protocol) (AdaptedDouble, error) {
    var decodeResult AdaptedDouble
    decodeErr := func() error {
        result, err := p.ReadDouble()
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type AdaptedString = string

func NewAdaptedString() AdaptedString {
    return ""
}

func WriteAdaptedString(item AdaptedString, p thrift.Protocol) error {
    if err := p.WriteString(item); err != nil {
    return err
}
    return nil
}

func ReadAdaptedString(p thrift.Protocol) (AdaptedString, error) {
    var decodeResult AdaptedString
    decodeErr := func() error {
        result, err := p.ReadString()
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type DoubleTypedefBool = AdaptedBool

func NewDoubleTypedefBool() DoubleTypedefBool {
    return NewAdaptedBool()
}

func WriteDoubleTypedefBool(item DoubleTypedefBool, p thrift.Protocol) error {
    err := WriteAdaptedBool(item, p)
if err != nil {
    return err
}
    return nil
}

func ReadDoubleTypedefBool(p thrift.Protocol) (DoubleTypedefBool, error) {
    var decodeResult DoubleTypedefBool
    decodeErr := func() error {
        result, err := ReadAdaptedBool(p)
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type IOBuf = []byte

func NewIOBuf() IOBuf {
    return []byte("")
}

func WriteIOBuf(item IOBuf, p thrift.Protocol) error {
    if err := p.WriteBinary(item); err != nil {
    return err
}
    return nil
}

func ReadIOBuf(p thrift.Protocol) (IOBuf, error) {
    var decodeResult IOBuf
    decodeErr := func() error {
        result, err := p.ReadBinary()
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type CustomProtocolType = IOBuf

func NewCustomProtocolType() CustomProtocolType {
    return NewIOBuf()
}

func WriteCustomProtocolType(item CustomProtocolType, p thrift.Protocol) error {
    err := WriteIOBuf(item, p)
if err != nil {
    return err
}
    return nil
}

func ReadCustomProtocolType(p thrift.Protocol) (CustomProtocolType, error) {
    var decodeResult CustomProtocolType
    decodeErr := func() error {
        result, err := ReadIOBuf(p)
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type IndirectionString = string

func NewIndirectionString() IndirectionString {
    return ""
}

func WriteIndirectionString(item IndirectionString, p thrift.Protocol) error {
    if err := p.WriteString(item); err != nil {
    return err
}
    return nil
}

func ReadIndirectionString(p thrift.Protocol) (IndirectionString, error) {
    var decodeResult IndirectionString
    decodeErr := func() error {
        result, err := p.ReadString()
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type AdaptedEnum = ThriftAdaptedEnum

func NewAdaptedEnum() AdaptedEnum {
    return 0
}

func WriteAdaptedEnum(item AdaptedEnum, p thrift.Protocol) error {
    if err := p.WriteI32(int32(item)); err != nil {
    return err
}
    return nil
}

func ReadAdaptedEnum(p thrift.Protocol) (AdaptedEnum, error) {
    var decodeResult AdaptedEnum
    decodeErr := func() error {
        enumResult, err := p.ReadI32()
if err != nil {
    return err
}
result := ThriftAdaptedEnum(enumResult)
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type AdaptedTypedef = AdaptedStruct

func NewAdaptedTypedef() *AdaptedTypedef {
    return NewAdaptedStruct()
}

func WriteAdaptedTypedef(item *AdaptedTypedef, p thrift.Protocol) error {
    if err := item.Write(p); err != nil {
    return err
}
    return nil
}

func ReadAdaptedTypedef(p thrift.Protocol) (AdaptedTypedef, error) {
    var decodeResult AdaptedTypedef
    decodeErr := func() error {
        result := *NewAdaptedStruct()
err := result.Read(p)
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type TypedefOfDirect = DirectlyAdaptedStruct

func NewTypedefOfDirect() *TypedefOfDirect {
    return NewDirectlyAdaptedStruct()
}

func WriteTypedefOfDirect(item *TypedefOfDirect, p thrift.Protocol) error {
    if err := item.Write(p); err != nil {
    return err
}
    return nil
}

func ReadTypedefOfDirect(p thrift.Protocol) (TypedefOfDirect, error) {
    var decodeResult TypedefOfDirect
    decodeErr := func() error {
        result := *NewDirectlyAdaptedStruct()
err := result.Read(p)
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type AdaptedCircularAdaptee = CircularAdaptee

func NewAdaptedCircularAdaptee() *AdaptedCircularAdaptee {
    return NewCircularAdaptee()
}

func WriteAdaptedCircularAdaptee(item *AdaptedCircularAdaptee, p thrift.Protocol) error {
    if err := item.Write(p); err != nil {
    return err
}
    return nil
}

func ReadAdaptedCircularAdaptee(p thrift.Protocol) (AdaptedCircularAdaptee, error) {
    var decodeResult AdaptedCircularAdaptee
    decodeErr := func() error {
        result := *NewCircularAdaptee()
err := result.Read(p)
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type CountingInt = int64

func NewCountingInt() CountingInt {
    return 0
}

func WriteCountingInt(item CountingInt, p thrift.Protocol) error {
    if err := p.WriteI64(item); err != nil {
    return err
}
    return nil
}

func ReadCountingInt(p thrift.Protocol) (CountingInt, error) {
    var decodeResult CountingInt
    decodeErr := func() error {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type FooWithAdapter_9317 = FooWithAdapter

func NewFooWithAdapter_9317() *FooWithAdapter_9317 {
    return NewFooWithAdapter()
}

func WriteFooWithAdapter_9317(item *FooWithAdapter_9317, p thrift.Protocol) error {
    err := WriteFooWithAdapter(item, p)
if err != nil {
    return err
}
    return nil
}

func ReadFooWithAdapter_9317(p thrift.Protocol) (FooWithAdapter_9317, error) {
    var decodeResult FooWithAdapter_9317
    decodeErr := func() error {
        result, err := ReadFooWithAdapter(p)
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type ListWithElemAdapterWithAdapter_2312 = ListWithElemAdapterWithAdapter

func NewListWithElemAdapterWithAdapter_2312() ListWithElemAdapterWithAdapter_2312 {
    return NewListWithElemAdapterWithAdapter()
}

func WriteListWithElemAdapterWithAdapter_2312(item ListWithElemAdapterWithAdapter_2312, p thrift.Protocol) error {
    err := WriteListWithElemAdapterWithAdapter(item, p)
if err != nil {
    return err
}
    return nil
}

func ReadListWithElemAdapterWithAdapter_2312(p thrift.Protocol) (ListWithElemAdapterWithAdapter_2312, error) {
    var decodeResult ListWithElemAdapterWithAdapter_2312
    decodeErr := func() error {
        result, err := ReadListWithElemAdapterWithAdapter(p)
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type MyI32_4873 = MyI32

func NewMyI32_4873() MyI32_4873 {
    return NewMyI32()
}

func WriteMyI32_4873(item MyI32_4873, p thrift.Protocol) error {
    err := WriteMyI32(item, p)
if err != nil {
    return err
}
    return nil
}

func ReadMyI32_4873(p thrift.Protocol) (MyI32_4873, error) {
    var decodeResult MyI32_4873
    decodeErr := func() error {
        result, err := ReadMyI32(p)
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type StringWithAdapter_7208 = StringWithAdapter

func NewStringWithAdapter_7208() StringWithAdapter_7208 {
    return NewStringWithAdapter()
}

func WriteStringWithAdapter_7208(item StringWithAdapter_7208, p thrift.Protocol) error {
    err := WriteStringWithAdapter(item, p)
if err != nil {
    return err
}
    return nil
}

func ReadStringWithAdapter_7208(p thrift.Protocol) (StringWithAdapter_7208, error) {
    var decodeResult StringWithAdapter_7208
    decodeErr := func() error {
        result, err := ReadStringWithAdapter(p)
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type Baz_7352 = Baz

func NewBaz_7352() *Baz_7352 {
    return NewBaz()
}

func WriteBaz_7352(item *Baz_7352, p thrift.Protocol) error {
    if err := item.Write(p); err != nil {
    return err
}
    return nil
}

func ReadBaz_7352(p thrift.Protocol) (Baz_7352, error) {
    var decodeResult Baz_7352
    decodeErr := func() error {
        result := *NewBaz()
err := result.Read(p)
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type Foo_3943 = Foo

func NewFoo_3943() *Foo_3943 {
    return NewFoo()
}

func WriteFoo_3943(item *Foo_3943, p thrift.Protocol) error {
    if err := item.Write(p); err != nil {
    return err
}
    return nil
}

func ReadFoo_3943(p thrift.Protocol) (Foo_3943, error) {
    var decodeResult Foo_3943
    decodeErr := func() error {
        result := *NewFoo()
err := result.Read(p)
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type Foo_6868 = Foo

func NewFoo_6868() *Foo_6868 {
    return NewFoo()
}

func WriteFoo_6868(item *Foo_6868, p thrift.Protocol) error {
    if err := item.Write(p); err != nil {
    return err
}
    return nil
}

func ReadFoo_6868(p thrift.Protocol) (Foo_6868, error) {
    var decodeResult Foo_6868
    decodeErr := func() error {
        result := *NewFoo()
err := result.Read(p)
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type Binary_5673 = []byte

func NewBinary_5673() Binary_5673 {
    return []byte("")
}

func WriteBinary_5673(item Binary_5673, p thrift.Protocol) error {
    if err := p.WriteBinary(item); err != nil {
    return err
}
    return nil
}

func ReadBinary_5673(p thrift.Protocol) (Binary_5673, error) {
    var decodeResult Binary_5673
    decodeErr := func() error {
        result, err := p.ReadBinary()
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type I32_5137 = int32

func NewI32_5137() I32_5137 {
    return 0
}

func WriteI32_5137(item I32_5137, p thrift.Protocol) error {
    if err := p.WriteI32(item); err != nil {
    return err
}
    return nil
}

func ReadI32_5137(p thrift.Protocol) (I32_5137, error) {
    var decodeResult I32_5137
    decodeErr := func() error {
        result, err := p.ReadI32()
if err != nil {
    return err
}
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type MapString_ListWithElemAdapterWithAdapter_8454 = map[string]ListWithElemAdapterWithAdapter_2312

func NewMapString_ListWithElemAdapterWithAdapter_8454() MapString_ListWithElemAdapterWithAdapter_8454 {
    return make(map[string]ListWithElemAdapterWithAdapter_2312)
}

func WriteMapString_ListWithElemAdapterWithAdapter_8454(item MapString_ListWithElemAdapterWithAdapter_8454, p thrift.Protocol) error {
    if err := p.WriteMapBegin(thrift.STRING, thrift.LIST, len(item)); err != nil {
    return thrift.PrependError("error writing map begin: ", err)
}
for k, v := range item {
    {
        item := k
        if err := p.WriteString(item); err != nil {
    return err
}
    }

    {
        item := v
        err := WriteListWithElemAdapterWithAdapter_2312(item, p)
if err != nil {
    return err
}
    }
}
if err := p.WriteMapEnd(); err != nil {
    return thrift.PrependError("error writing map end: ", err)
}
    return nil
}

func ReadMapString_ListWithElemAdapterWithAdapter_8454(p thrift.Protocol) (MapString_ListWithElemAdapterWithAdapter_8454, error) {
    var decodeResult MapString_ListWithElemAdapterWithAdapter_8454
    decodeErr := func() error {
        _ /* keyType */, _ /* valueType */, size, err := p.ReadMapBegin()
if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
}

mapResult := make(map[string]ListWithElemAdapterWithAdapter_2312, size)
for i := 0; i < size; i++ {
    var key string
    {
        result, err := p.ReadString()
if err != nil {
    return err
}
        key = result
    }

    var value ListWithElemAdapterWithAdapter_2312
    {
        result, err := ReadListWithElemAdapterWithAdapter_2312(p)
if err != nil {
    return err
}
        value = result
    }

    mapResult[key] = value
}

if err := p.ReadMapEnd(); err != nil {
    return thrift.PrependError("error reading map end: ", err)
}
result := mapResult
        decodeResult = result
        return nil
    }()
    return decodeResult, decodeErr
}

type Color int32

const (
    Color_UNKNOWN Color = 0
    Color_RED Color = 1
    Color_GREEN Color = 2
    Color_BLUE Color = 3
)

// Enum value maps for Color
var (
    ColorToName = map[Color]string {
        Color_UNKNOWN: "UNKNOWN",
        Color_RED: "RED",
        Color_GREEN: "GREEN",
        Color_BLUE: "BLUE",
    }

    ColorToValue = map[string]Color {
        "UNKNOWN": Color_UNKNOWN,
        "RED": Color_RED,
        "GREEN": Color_GREEN,
        "BLUE": Color_BLUE,
    }

    ColorNames = []string{
        "UNKNOWN",
        "RED",
        "GREEN",
        "BLUE",
    }

    ColorValues = []Color{
        Color_UNKNOWN,
        Color_RED,
        Color_GREEN,
        Color_BLUE,
    }
)

func (x Color) String() string {
    if v, ok := ColorToName[x]; ok {
        return v
    }
    return "<UNSET>"
}

func (x Color) Ptr() *Color {
    return &x
}

// Deprecated: Use ColorToValue instead (e.g. `x, ok := ColorToValue["name"]`).
func ColorFromString(s string) (Color, error) {
    if v, ok := ColorToValue[s]; ok {
        return v, nil
    }
    return Color(0), fmt.Errorf("not a valid Color string")
}

// Deprecated: Use Color.Ptr() instead.
func ColorPtr(v Color) *Color {
    return &v
}


type ThriftAdaptedEnum int32

const (
    ThriftAdaptedEnum_Zero ThriftAdaptedEnum = 0
    ThriftAdaptedEnum_One ThriftAdaptedEnum = 1
)

// Enum value maps for ThriftAdaptedEnum
var (
    ThriftAdaptedEnumToName = map[ThriftAdaptedEnum]string {
        ThriftAdaptedEnum_Zero: "Zero",
        ThriftAdaptedEnum_One: "One",
    }

    ThriftAdaptedEnumToValue = map[string]ThriftAdaptedEnum {
        "Zero": ThriftAdaptedEnum_Zero,
        "One": ThriftAdaptedEnum_One,
    }

    ThriftAdaptedEnumNames = []string{
        "Zero",
        "One",
    }

    ThriftAdaptedEnumValues = []ThriftAdaptedEnum{
        ThriftAdaptedEnum_Zero,
        ThriftAdaptedEnum_One,
    }
)

func (x ThriftAdaptedEnum) String() string {
    if v, ok := ThriftAdaptedEnumToName[x]; ok {
        return v
    }
    return "<UNSET>"
}

func (x ThriftAdaptedEnum) Ptr() *ThriftAdaptedEnum {
    return &x
}

// Deprecated: Use ThriftAdaptedEnumToValue instead (e.g. `x, ok := ThriftAdaptedEnumToValue["name"]`).
func ThriftAdaptedEnumFromString(s string) (ThriftAdaptedEnum, error) {
    if v, ok := ThriftAdaptedEnumToValue[s]; ok {
        return v, nil
    }
    return ThriftAdaptedEnum(0), fmt.Errorf("not a valid ThriftAdaptedEnum string")
}

// Deprecated: Use ThriftAdaptedEnum.Ptr() instead.
func ThriftAdaptedEnumPtr(v ThriftAdaptedEnum) *ThriftAdaptedEnum {
    return &v
}


type MyAnnotation struct {
    Signature string `thrift:"signature,1" json:"signature" db:"signature"`
    Color Color `thrift:"color,2" json:"color" db:"color"`
}
// Compile time interface enforcer
var _ thrift.Struct = &MyAnnotation{}

func NewMyAnnotation() *MyAnnotation {
    return (&MyAnnotation{}).
        SetSignatureNonCompat("").
        SetColorNonCompat(
              Color_RED,
          )
}

func (x *MyAnnotation) GetSignatureNonCompat() string {
    return x.Signature
}

func (x *MyAnnotation) GetSignature() string {
    return x.Signature
}

func (x *MyAnnotation) GetColorNonCompat() Color {
    return x.Color
}

func (x *MyAnnotation) GetColor() Color {
    return x.Color
}

func (x *MyAnnotation) SetSignatureNonCompat(value string) *MyAnnotation {
    x.Signature = value
    return x
}

func (x *MyAnnotation) SetSignature(value string) *MyAnnotation {
    x.Signature = value
    return x
}

func (x *MyAnnotation) SetColorNonCompat(value Color) *MyAnnotation {
    x.Color = value
    return x
}

func (x *MyAnnotation) SetColor(value Color) *MyAnnotation {
    x.Color = value
    return x
}

func (x *MyAnnotation) writeField1(p thrift.Protocol) error {  // Signature
    if err := p.WriteFieldBegin("signature", thrift.STRING, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetSignatureNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *MyAnnotation) writeField2(p thrift.Protocol) error {  // Color
    if err := p.WriteFieldBegin("color", thrift.I32, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetColorNonCompat()
    if err := p.WriteI32(int32(item)); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *MyAnnotation) readField1(p thrift.Protocol) error {  // Signature
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetSignatureNonCompat(result)
    return nil
}

func (x *MyAnnotation) readField2(p thrift.Protocol) error {  // Color
    enumResult, err := p.ReadI32()
if err != nil {
    return err
}
result := Color(enumResult)

    x.SetColorNonCompat(result)
    return nil
}

func (x *MyAnnotation) toString1() string {  // Signature
    return fmt.Sprintf("%v", x.GetSignatureNonCompat())
}

func (x *MyAnnotation) toString2() string {  // Color
    return fmt.Sprintf("%v", x.GetColorNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewMyAnnotation().Set<FieldNameFoo>().Set<FieldNameBar>()
type MyAnnotationBuilder struct {
    obj *MyAnnotation
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewMyAnnotation().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewMyAnnotationBuilder() *MyAnnotationBuilder {
    return &MyAnnotationBuilder{
        obj: NewMyAnnotation(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewMyAnnotation().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *MyAnnotationBuilder) Signature(value string) *MyAnnotationBuilder {
    x.obj.Signature = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewMyAnnotation().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *MyAnnotationBuilder) Color(value Color) *MyAnnotationBuilder {
    x.obj.Color = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewMyAnnotation().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *MyAnnotationBuilder) Emit() *MyAnnotation {
    var objCopy MyAnnotation = *x.obj
    return &objCopy
}

func (x *MyAnnotation) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("MyAnnotation"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *MyAnnotation) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRING)):  // signature
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.I32)):  // color
            if err := x.readField2(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *MyAnnotation) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("MyAnnotation({")
    sb.WriteString(fmt.Sprintf("Signature:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("Color:%s", x.toString2()))
    sb.WriteString("})")

    return sb.String()
}

type Foo struct {
    IntField I32_5137 `thrift:"intField,1" json:"intField" db:"intField"`
    OptionalIntField *I32_5137 `thrift:"optionalIntField,2,optional" json:"optionalIntField,omitempty" db:"optionalIntField"`
    IntFieldWithDefault I32_5137 `thrift:"intFieldWithDefault,3" json:"intFieldWithDefault" db:"intFieldWithDefault"`
    SetField SetWithAdapter `thrift:"setField,4" json:"setField" db:"setField"`
    OptionalSetField SetWithAdapter `thrift:"optionalSetField,5,optional" json:"optionalSetField,omitempty" db:"optionalSetField"`
    MapField MapString_ListWithElemAdapterWithAdapter_8454 `thrift:"mapField,6" json:"mapField" db:"mapField"`
    OptionalMapField MapString_ListWithElemAdapterWithAdapter_8454 `thrift:"optionalMapField,7,optional" json:"optionalMapField,omitempty" db:"optionalMapField"`
    BinaryField Binary_5673 `thrift:"binaryField,8" json:"binaryField" db:"binaryField"`
    LongField MyI64 `thrift:"longField,9" json:"longField" db:"longField"`
    AdaptedLongField MyI64 `thrift:"adaptedLongField,10" json:"adaptedLongField" db:"adaptedLongField"`
    DoubleAdaptedField DoubleTypedefI64 `thrift:"doubleAdaptedField,11" json:"doubleAdaptedField" db:"doubleAdaptedField"`
}
// Compile time interface enforcer
var _ thrift.Struct = &Foo{}

func NewFoo() *Foo {
    return (&Foo{}).
        SetIntFieldNonCompat(NewI32_5137()).
        SetIntFieldWithDefaultNonCompat(13).
        SetSetFieldNonCompat(NewSetWithAdapter()).
        SetMapFieldNonCompat(NewMapString_ListWithElemAdapterWithAdapter_8454()).
        SetBinaryFieldNonCompat(NewBinary_5673()).
        SetLongFieldNonCompat(NewMyI64()).
        SetAdaptedLongFieldNonCompat(NewMyI64()).
        SetDoubleAdaptedFieldNonCompat(NewDoubleTypedefI64())
}

func (x *Foo) GetIntFieldNonCompat() I32_5137 {
    return x.IntField
}

func (x *Foo) GetIntField() I32_5137 {
    return x.IntField
}

func (x *Foo) GetOptionalIntFieldNonCompat() *I32_5137 {
    return x.OptionalIntField
}

func (x *Foo) GetOptionalIntField() I32_5137 {
    if !x.IsSetOptionalIntField() {
        return NewI32_5137()
    }

    return *x.OptionalIntField
}

func (x *Foo) GetIntFieldWithDefaultNonCompat() I32_5137 {
    return x.IntFieldWithDefault
}

func (x *Foo) GetIntFieldWithDefault() I32_5137 {
    return x.IntFieldWithDefault
}

func (x *Foo) GetSetFieldNonCompat() SetWithAdapter {
    return x.SetField
}

func (x *Foo) GetSetField() SetWithAdapter {
    if !x.IsSetSetField() {
        return NewSetWithAdapter()
    }

    return x.SetField
}

func (x *Foo) GetOptionalSetFieldNonCompat() SetWithAdapter {
    return x.OptionalSetField
}

func (x *Foo) GetOptionalSetField() SetWithAdapter {
    if !x.IsSetOptionalSetField() {
        return NewSetWithAdapter()
    }

    return x.OptionalSetField
}

func (x *Foo) GetMapFieldNonCompat() MapString_ListWithElemAdapterWithAdapter_8454 {
    return x.MapField
}

func (x *Foo) GetMapField() MapString_ListWithElemAdapterWithAdapter_8454 {
    if !x.IsSetMapField() {
        return NewMapString_ListWithElemAdapterWithAdapter_8454()
    }

    return x.MapField
}

func (x *Foo) GetOptionalMapFieldNonCompat() MapString_ListWithElemAdapterWithAdapter_8454 {
    return x.OptionalMapField
}

func (x *Foo) GetOptionalMapField() MapString_ListWithElemAdapterWithAdapter_8454 {
    if !x.IsSetOptionalMapField() {
        return NewMapString_ListWithElemAdapterWithAdapter_8454()
    }

    return x.OptionalMapField
}

func (x *Foo) GetBinaryFieldNonCompat() Binary_5673 {
    return x.BinaryField
}

func (x *Foo) GetBinaryField() Binary_5673 {
    if !x.IsSetBinaryField() {
        return NewBinary_5673()
    }

    return x.BinaryField
}

func (x *Foo) GetLongFieldNonCompat() MyI64 {
    return x.LongField
}

func (x *Foo) GetLongField() MyI64 {
    return x.LongField
}

func (x *Foo) GetAdaptedLongFieldNonCompat() MyI64 {
    return x.AdaptedLongField
}

func (x *Foo) GetAdaptedLongField() MyI64 {
    return x.AdaptedLongField
}

func (x *Foo) GetDoubleAdaptedFieldNonCompat() DoubleTypedefI64 {
    return x.DoubleAdaptedField
}

func (x *Foo) GetDoubleAdaptedField() DoubleTypedefI64 {
    return x.DoubleAdaptedField
}

func (x *Foo) SetIntFieldNonCompat(value I32_5137) *Foo {
    x.IntField = value
    return x
}

func (x *Foo) SetIntField(value I32_5137) *Foo {
    x.IntField = value
    return x
}

func (x *Foo) SetOptionalIntFieldNonCompat(value I32_5137) *Foo {
    x.OptionalIntField = &value
    return x
}

func (x *Foo) SetOptionalIntField(value *I32_5137) *Foo {
    x.OptionalIntField = value
    return x
}

func (x *Foo) SetIntFieldWithDefaultNonCompat(value I32_5137) *Foo {
    x.IntFieldWithDefault = value
    return x
}

func (x *Foo) SetIntFieldWithDefault(value I32_5137) *Foo {
    x.IntFieldWithDefault = value
    return x
}

func (x *Foo) SetSetFieldNonCompat(value SetWithAdapter) *Foo {
    x.SetField = value
    return x
}

func (x *Foo) SetSetField(value SetWithAdapter) *Foo {
    x.SetField = value
    return x
}

func (x *Foo) SetOptionalSetFieldNonCompat(value SetWithAdapter) *Foo {
    x.OptionalSetField = value
    return x
}

func (x *Foo) SetOptionalSetField(value SetWithAdapter) *Foo {
    x.OptionalSetField = value
    return x
}

func (x *Foo) SetMapFieldNonCompat(value MapString_ListWithElemAdapterWithAdapter_8454) *Foo {
    x.MapField = value
    return x
}

func (x *Foo) SetMapField(value MapString_ListWithElemAdapterWithAdapter_8454) *Foo {
    x.MapField = value
    return x
}

func (x *Foo) SetOptionalMapFieldNonCompat(value MapString_ListWithElemAdapterWithAdapter_8454) *Foo {
    x.OptionalMapField = value
    return x
}

func (x *Foo) SetOptionalMapField(value MapString_ListWithElemAdapterWithAdapter_8454) *Foo {
    x.OptionalMapField = value
    return x
}

func (x *Foo) SetBinaryFieldNonCompat(value Binary_5673) *Foo {
    x.BinaryField = value
    return x
}

func (x *Foo) SetBinaryField(value Binary_5673) *Foo {
    x.BinaryField = value
    return x
}

func (x *Foo) SetLongFieldNonCompat(value MyI64) *Foo {
    x.LongField = value
    return x
}

func (x *Foo) SetLongField(value MyI64) *Foo {
    x.LongField = value
    return x
}

func (x *Foo) SetAdaptedLongFieldNonCompat(value MyI64) *Foo {
    x.AdaptedLongField = value
    return x
}

func (x *Foo) SetAdaptedLongField(value MyI64) *Foo {
    x.AdaptedLongField = value
    return x
}

func (x *Foo) SetDoubleAdaptedFieldNonCompat(value DoubleTypedefI64) *Foo {
    x.DoubleAdaptedField = value
    return x
}

func (x *Foo) SetDoubleAdaptedField(value DoubleTypedefI64) *Foo {
    x.DoubleAdaptedField = value
    return x
}

func (x *Foo) IsSetOptionalIntField() bool {
    return x != nil && x.OptionalIntField != nil
}

func (x *Foo) IsSetSetField() bool {
    return x != nil && x.SetField != nil
}

func (x *Foo) IsSetOptionalSetField() bool {
    return x != nil && x.OptionalSetField != nil
}

func (x *Foo) IsSetMapField() bool {
    return x != nil && x.MapField != nil
}

func (x *Foo) IsSetOptionalMapField() bool {
    return x != nil && x.OptionalMapField != nil
}

func (x *Foo) IsSetBinaryField() bool {
    return x != nil && x.BinaryField != nil
}

func (x *Foo) writeField1(p thrift.Protocol) error {  // IntField
    if err := p.WriteFieldBegin("intField", thrift.I32, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetIntFieldNonCompat()
    err := WriteI32_5137(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField2(p thrift.Protocol) error {  // OptionalIntField
    if !x.IsSetOptionalIntField() {
        return nil
    }

    if err := p.WriteFieldBegin("optionalIntField", thrift.I32, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetOptionalIntFieldNonCompat()
    err := WriteI32_5137(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField3(p thrift.Protocol) error {  // IntFieldWithDefault
    if err := p.WriteFieldBegin("intFieldWithDefault", thrift.I32, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetIntFieldWithDefaultNonCompat()
    err := WriteI32_5137(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField4(p thrift.Protocol) error {  // SetField
    if err := p.WriteFieldBegin("setField", thrift.SET, 4); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetSetFieldNonCompat()
    err := WriteSetWithAdapter(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField5(p thrift.Protocol) error {  // OptionalSetField
    if !x.IsSetOptionalSetField() {
        return nil
    }

    if err := p.WriteFieldBegin("optionalSetField", thrift.SET, 5); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetOptionalSetFieldNonCompat()
    err := WriteSetWithAdapter(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField6(p thrift.Protocol) error {  // MapField
    if err := p.WriteFieldBegin("mapField", thrift.MAP, 6); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetMapFieldNonCompat()
    err := WriteMapString_ListWithElemAdapterWithAdapter_8454(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField7(p thrift.Protocol) error {  // OptionalMapField
    if !x.IsSetOptionalMapField() {
        return nil
    }

    if err := p.WriteFieldBegin("optionalMapField", thrift.MAP, 7); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetOptionalMapFieldNonCompat()
    err := WriteMapString_ListWithElemAdapterWithAdapter_8454(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField8(p thrift.Protocol) error {  // BinaryField
    if err := p.WriteFieldBegin("binaryField", thrift.STRING, 8); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetBinaryFieldNonCompat()
    err := WriteBinary_5673(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField9(p thrift.Protocol) error {  // LongField
    if err := p.WriteFieldBegin("longField", thrift.I64, 9); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetLongFieldNonCompat()
    err := WriteMyI64(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField10(p thrift.Protocol) error {  // AdaptedLongField
    if err := p.WriteFieldBegin("adaptedLongField", thrift.I64, 10); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedLongFieldNonCompat()
    err := WriteMyI64(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField11(p thrift.Protocol) error {  // DoubleAdaptedField
    if err := p.WriteFieldBegin("doubleAdaptedField", thrift.I64, 11); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDoubleAdaptedFieldNonCompat()
    err := WriteDoubleTypedefI64(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) readField1(p thrift.Protocol) error {  // IntField
    result, err := ReadI32_5137(p)
if err != nil {
    return err
}

    x.SetIntFieldNonCompat(result)
    return nil
}

func (x *Foo) readField2(p thrift.Protocol) error {  // OptionalIntField
    result, err := ReadI32_5137(p)
if err != nil {
    return err
}

    x.SetOptionalIntFieldNonCompat(result)
    return nil
}

func (x *Foo) readField3(p thrift.Protocol) error {  // IntFieldWithDefault
    result, err := ReadI32_5137(p)
if err != nil {
    return err
}

    x.SetIntFieldWithDefaultNonCompat(result)
    return nil
}

func (x *Foo) readField4(p thrift.Protocol) error {  // SetField
    result, err := ReadSetWithAdapter(p)
if err != nil {
    return err
}

    x.SetSetFieldNonCompat(result)
    return nil
}

func (x *Foo) readField5(p thrift.Protocol) error {  // OptionalSetField
    result, err := ReadSetWithAdapter(p)
if err != nil {
    return err
}

    x.SetOptionalSetFieldNonCompat(result)
    return nil
}

func (x *Foo) readField6(p thrift.Protocol) error {  // MapField
    result, err := ReadMapString_ListWithElemAdapterWithAdapter_8454(p)
if err != nil {
    return err
}

    x.SetMapFieldNonCompat(result)
    return nil
}

func (x *Foo) readField7(p thrift.Protocol) error {  // OptionalMapField
    result, err := ReadMapString_ListWithElemAdapterWithAdapter_8454(p)
if err != nil {
    return err
}

    x.SetOptionalMapFieldNonCompat(result)
    return nil
}

func (x *Foo) readField8(p thrift.Protocol) error {  // BinaryField
    result, err := ReadBinary_5673(p)
if err != nil {
    return err
}

    x.SetBinaryFieldNonCompat(result)
    return nil
}

func (x *Foo) readField9(p thrift.Protocol) error {  // LongField
    result, err := ReadMyI64(p)
if err != nil {
    return err
}

    x.SetLongFieldNonCompat(result)
    return nil
}

func (x *Foo) readField10(p thrift.Protocol) error {  // AdaptedLongField
    result, err := ReadMyI64(p)
if err != nil {
    return err
}

    x.SetAdaptedLongFieldNonCompat(result)
    return nil
}

func (x *Foo) readField11(p thrift.Protocol) error {  // DoubleAdaptedField
    result, err := ReadDoubleTypedefI64(p)
if err != nil {
    return err
}

    x.SetDoubleAdaptedFieldNonCompat(result)
    return nil
}

func (x *Foo) toString1() string {  // IntField
    return fmt.Sprintf("%v", x.GetIntFieldNonCompat())
}

func (x *Foo) toString2() string {  // OptionalIntField
    if x.IsSetOptionalIntField() {
        return fmt.Sprintf("%v", *x.GetOptionalIntFieldNonCompat())
    }
    return fmt.Sprintf("%v", x.GetOptionalIntFieldNonCompat())
}

func (x *Foo) toString3() string {  // IntFieldWithDefault
    return fmt.Sprintf("%v", x.GetIntFieldWithDefaultNonCompat())
}

func (x *Foo) toString4() string {  // SetField
    return fmt.Sprintf("%v", x.GetSetFieldNonCompat())
}

func (x *Foo) toString5() string {  // OptionalSetField
    return fmt.Sprintf("%v", x.GetOptionalSetFieldNonCompat())
}

func (x *Foo) toString6() string {  // MapField
    return fmt.Sprintf("%v", x.GetMapFieldNonCompat())
}

func (x *Foo) toString7() string {  // OptionalMapField
    return fmt.Sprintf("%v", x.GetOptionalMapFieldNonCompat())
}

func (x *Foo) toString8() string {  // BinaryField
    return fmt.Sprintf("%v", x.GetBinaryFieldNonCompat())
}

func (x *Foo) toString9() string {  // LongField
    return fmt.Sprintf("%v", x.GetLongFieldNonCompat())
}

func (x *Foo) toString10() string {  // AdaptedLongField
    return fmt.Sprintf("%v", x.GetAdaptedLongFieldNonCompat())
}

func (x *Foo) toString11() string {  // DoubleAdaptedField
    return fmt.Sprintf("%v", x.GetDoubleAdaptedFieldNonCompat())
}



// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewFoo().Set<FieldNameFoo>().Set<FieldNameBar>()
type FooBuilder struct {
    obj *Foo
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewFoo().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewFooBuilder() *FooBuilder {
    return &FooBuilder{
        obj: NewFoo(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewFoo().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *FooBuilder) IntField(value I32_5137) *FooBuilder {
    x.obj.IntField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewFoo().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *FooBuilder) OptionalIntField(value *I32_5137) *FooBuilder {
    x.obj.OptionalIntField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewFoo().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *FooBuilder) IntFieldWithDefault(value I32_5137) *FooBuilder {
    x.obj.IntFieldWithDefault = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewFoo().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *FooBuilder) SetField(value SetWithAdapter) *FooBuilder {
    x.obj.SetField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewFoo().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *FooBuilder) OptionalSetField(value SetWithAdapter) *FooBuilder {
    x.obj.OptionalSetField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewFoo().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *FooBuilder) MapField(value MapString_ListWithElemAdapterWithAdapter_8454) *FooBuilder {
    x.obj.MapField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewFoo().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *FooBuilder) OptionalMapField(value MapString_ListWithElemAdapterWithAdapter_8454) *FooBuilder {
    x.obj.OptionalMapField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewFoo().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *FooBuilder) BinaryField(value Binary_5673) *FooBuilder {
    x.obj.BinaryField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewFoo().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *FooBuilder) LongField(value MyI64) *FooBuilder {
    x.obj.LongField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewFoo().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *FooBuilder) AdaptedLongField(value MyI64) *FooBuilder {
    x.obj.AdaptedLongField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewFoo().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *FooBuilder) DoubleAdaptedField(value DoubleTypedefI64) *FooBuilder {
    x.obj.DoubleAdaptedField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewFoo().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *FooBuilder) Emit() *Foo {
    var objCopy Foo = *x.obj
    return &objCopy
}

func (x *Foo) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("Foo"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := x.writeField4(p); err != nil {
        return err
    }

    if err := x.writeField5(p); err != nil {
        return err
    }

    if err := x.writeField6(p); err != nil {
        return err
    }

    if err := x.writeField7(p); err != nil {
        return err
    }

    if err := x.writeField8(p); err != nil {
        return err
    }

    if err := x.writeField9(p); err != nil {
        return err
    }

    if err := x.writeField10(p); err != nil {
        return err
    }

    if err := x.writeField11(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *Foo) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I32)):  // intField
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.I32)):  // optionalIntField
            if err := x.readField2(p); err != nil {
                return err
            }
        case (id == 3 && wireType == thrift.Type(thrift.I32)):  // intFieldWithDefault
            if err := x.readField3(p); err != nil {
                return err
            }
        case (id == 4 && wireType == thrift.Type(thrift.SET)):  // setField
            if err := x.readField4(p); err != nil {
                return err
            }
        case (id == 5 && wireType == thrift.Type(thrift.SET)):  // optionalSetField
            if err := x.readField5(p); err != nil {
                return err
            }
        case (id == 6 && wireType == thrift.Type(thrift.MAP)):  // mapField
            if err := x.readField6(p); err != nil {
                return err
            }
        case (id == 7 && wireType == thrift.Type(thrift.MAP)):  // optionalMapField
            if err := x.readField7(p); err != nil {
                return err
            }
        case (id == 8 && wireType == thrift.Type(thrift.STRING)):  // binaryField
            if err := x.readField8(p); err != nil {
                return err
            }
        case (id == 9 && wireType == thrift.Type(thrift.I64)):  // longField
            if err := x.readField9(p); err != nil {
                return err
            }
        case (id == 10 && wireType == thrift.Type(thrift.I64)):  // adaptedLongField
            if err := x.readField10(p); err != nil {
                return err
            }
        case (id == 11 && wireType == thrift.Type(thrift.I64)):  // doubleAdaptedField
            if err := x.readField11(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *Foo) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("Foo({")
    sb.WriteString(fmt.Sprintf("IntField:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("OptionalIntField:%s ", x.toString2()))
    sb.WriteString(fmt.Sprintf("IntFieldWithDefault:%s ", x.toString3()))
    sb.WriteString(fmt.Sprintf("SetField:%s ", x.toString4()))
    sb.WriteString(fmt.Sprintf("OptionalSetField:%s ", x.toString5()))
    sb.WriteString(fmt.Sprintf("MapField:%s ", x.toString6()))
    sb.WriteString(fmt.Sprintf("OptionalMapField:%s ", x.toString7()))
    sb.WriteString(fmt.Sprintf("BinaryField:%s ", x.toString8()))
    sb.WriteString(fmt.Sprintf("LongField:%s ", x.toString9()))
    sb.WriteString(fmt.Sprintf("AdaptedLongField:%s ", x.toString10()))
    sb.WriteString(fmt.Sprintf("DoubleAdaptedField:%s", x.toString11()))
    sb.WriteString("})")

    return sb.String()
}

type Baz struct {
    IntField *I32_5137 `thrift:"intField,1" json:"intField,omitempty" db:"intField"`
    SetField SetWithAdapter `thrift:"setField,4" json:"setField,omitempty" db:"setField"`
    MapField MapString_ListWithElemAdapterWithAdapter_8454 `thrift:"mapField,6" json:"mapField,omitempty" db:"mapField"`
    BinaryField Binary_5673 `thrift:"binaryField,8" json:"binaryField,omitempty" db:"binaryField"`
    LongField *MyI64 `thrift:"longField,9" json:"longField,omitempty" db:"longField"`
}
// Compile time interface enforcer
var _ thrift.Struct = &Baz{}

func NewBaz() *Baz {
    return (&Baz{})
}

func (x *Baz) GetIntFieldNonCompat() *I32_5137 {
    return x.IntField
}

func (x *Baz) GetIntField() I32_5137 {
    if !x.IsSetIntField() {
        return NewI32_5137()
    }

    return *x.IntField
}

func (x *Baz) GetSetFieldNonCompat() SetWithAdapter {
    return x.SetField
}

func (x *Baz) GetSetField() SetWithAdapter {
    if !x.IsSetSetField() {
        return NewSetWithAdapter()
    }

    return x.SetField
}

func (x *Baz) GetMapFieldNonCompat() MapString_ListWithElemAdapterWithAdapter_8454 {
    return x.MapField
}

func (x *Baz) GetMapField() MapString_ListWithElemAdapterWithAdapter_8454 {
    if !x.IsSetMapField() {
        return NewMapString_ListWithElemAdapterWithAdapter_8454()
    }

    return x.MapField
}

func (x *Baz) GetBinaryFieldNonCompat() Binary_5673 {
    return x.BinaryField
}

func (x *Baz) GetBinaryField() Binary_5673 {
    if !x.IsSetBinaryField() {
        return NewBinary_5673()
    }

    return x.BinaryField
}

func (x *Baz) GetLongFieldNonCompat() *MyI64 {
    return x.LongField
}

func (x *Baz) GetLongField() MyI64 {
    if !x.IsSetLongField() {
        return NewMyI64()
    }

    return *x.LongField
}

func (x *Baz) SetIntFieldNonCompat(value I32_5137) *Baz {
    x.IntField = &value
    return x
}

func (x *Baz) SetIntField(value *I32_5137) *Baz {
    x.IntField = value
    return x
}

func (x *Baz) SetSetFieldNonCompat(value SetWithAdapter) *Baz {
    x.SetField = value
    return x
}

func (x *Baz) SetSetField(value SetWithAdapter) *Baz {
    x.SetField = value
    return x
}

func (x *Baz) SetMapFieldNonCompat(value MapString_ListWithElemAdapterWithAdapter_8454) *Baz {
    x.MapField = value
    return x
}

func (x *Baz) SetMapField(value MapString_ListWithElemAdapterWithAdapter_8454) *Baz {
    x.MapField = value
    return x
}

func (x *Baz) SetBinaryFieldNonCompat(value Binary_5673) *Baz {
    x.BinaryField = value
    return x
}

func (x *Baz) SetBinaryField(value Binary_5673) *Baz {
    x.BinaryField = value
    return x
}

func (x *Baz) SetLongFieldNonCompat(value MyI64) *Baz {
    x.LongField = &value
    return x
}

func (x *Baz) SetLongField(value *MyI64) *Baz {
    x.LongField = value
    return x
}

func (x *Baz) IsSetIntField() bool {
    return x != nil && x.IntField != nil
}

func (x *Baz) IsSetSetField() bool {
    return x != nil && x.SetField != nil
}

func (x *Baz) IsSetMapField() bool {
    return x != nil && x.MapField != nil
}

func (x *Baz) IsSetBinaryField() bool {
    return x != nil && x.BinaryField != nil
}

func (x *Baz) IsSetLongField() bool {
    return x != nil && x.LongField != nil
}

func (x *Baz) writeField1(p thrift.Protocol) error {  // IntField
    if !x.IsSetIntField() {
        return nil
    }

    if err := p.WriteFieldBegin("intField", thrift.I32, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetIntFieldNonCompat()
    err := WriteI32_5137(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Baz) writeField4(p thrift.Protocol) error {  // SetField
    if !x.IsSetSetField() {
        return nil
    }

    if err := p.WriteFieldBegin("setField", thrift.SET, 4); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetSetFieldNonCompat()
    err := WriteSetWithAdapter(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Baz) writeField6(p thrift.Protocol) error {  // MapField
    if !x.IsSetMapField() {
        return nil
    }

    if err := p.WriteFieldBegin("mapField", thrift.MAP, 6); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetMapFieldNonCompat()
    err := WriteMapString_ListWithElemAdapterWithAdapter_8454(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Baz) writeField8(p thrift.Protocol) error {  // BinaryField
    if !x.IsSetBinaryField() {
        return nil
    }

    if err := p.WriteFieldBegin("binaryField", thrift.STRING, 8); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetBinaryFieldNonCompat()
    err := WriteBinary_5673(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Baz) writeField9(p thrift.Protocol) error {  // LongField
    if !x.IsSetLongField() {
        return nil
    }

    if err := p.WriteFieldBegin("longField", thrift.I64, 9); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetLongFieldNonCompat()
    err := WriteMyI64(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Baz) readField1(p thrift.Protocol) error {  // IntField
    result, err := ReadI32_5137(p)
if err != nil {
    return err
}

    x.SetIntFieldNonCompat(result)
    return nil
}

func (x *Baz) readField4(p thrift.Protocol) error {  // SetField
    result, err := ReadSetWithAdapter(p)
if err != nil {
    return err
}

    x.SetSetFieldNonCompat(result)
    return nil
}

func (x *Baz) readField6(p thrift.Protocol) error {  // MapField
    result, err := ReadMapString_ListWithElemAdapterWithAdapter_8454(p)
if err != nil {
    return err
}

    x.SetMapFieldNonCompat(result)
    return nil
}

func (x *Baz) readField8(p thrift.Protocol) error {  // BinaryField
    result, err := ReadBinary_5673(p)
if err != nil {
    return err
}

    x.SetBinaryFieldNonCompat(result)
    return nil
}

func (x *Baz) readField9(p thrift.Protocol) error {  // LongField
    result, err := ReadMyI64(p)
if err != nil {
    return err
}

    x.SetLongFieldNonCompat(result)
    return nil
}

func (x *Baz) toString1() string {  // IntField
    if x.IsSetIntField() {
        return fmt.Sprintf("%v", *x.GetIntFieldNonCompat())
    }
    return fmt.Sprintf("%v", x.GetIntFieldNonCompat())
}

func (x *Baz) toString4() string {  // SetField
    return fmt.Sprintf("%v", x.GetSetFieldNonCompat())
}

func (x *Baz) toString6() string {  // MapField
    return fmt.Sprintf("%v", x.GetMapFieldNonCompat())
}

func (x *Baz) toString8() string {  // BinaryField
    return fmt.Sprintf("%v", x.GetBinaryFieldNonCompat())
}

func (x *Baz) toString9() string {  // LongField
    if x.IsSetLongField() {
        return fmt.Sprintf("%v", *x.GetLongFieldNonCompat())
    }
    return fmt.Sprintf("%v", x.GetLongFieldNonCompat())
}



func (x *Baz) countSetFields() int {
    count := int(0)
    if (x.IsSetIntField()) {
        count++
    }
    if (x.IsSetSetField()) {
        count++
    }
    if (x.IsSetMapField()) {
        count++
    }
    if (x.IsSetBinaryField()) {
        count++
    }
    if (x.IsSetLongField()) {
        count++
    }
    return count
}

func (x *Baz) CountSetFieldsBaz() int {
    return x.countSetFields()
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewBaz().Set<FieldNameFoo>().Set<FieldNameBar>()
type BazBuilder struct {
    obj *Baz
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewBaz().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewBazBuilder() *BazBuilder {
    return &BazBuilder{
        obj: NewBaz(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewBaz().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *BazBuilder) IntField(value *I32_5137) *BazBuilder {
    x.obj.IntField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewBaz().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *BazBuilder) SetField(value SetWithAdapter) *BazBuilder {
    x.obj.SetField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewBaz().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *BazBuilder) MapField(value MapString_ListWithElemAdapterWithAdapter_8454) *BazBuilder {
    x.obj.MapField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewBaz().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *BazBuilder) BinaryField(value Binary_5673) *BazBuilder {
    x.obj.BinaryField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewBaz().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *BazBuilder) LongField(value *MyI64) *BazBuilder {
    x.obj.LongField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewBaz().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *BazBuilder) Emit() *Baz {
    var objCopy Baz = *x.obj
    return &objCopy
}

func (x *Baz) Write(p thrift.Protocol) error {
    if countSet := x.countSetFields(); countSet > 1 {
        return fmt.Errorf("%T write union: no more than one field must be set (%d set).", x, countSet)
    }
    if err := p.WriteStructBegin("Baz"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField4(p); err != nil {
        return err
    }

    if err := x.writeField6(p); err != nil {
        return err
    }

    if err := x.writeField8(p); err != nil {
        return err
    }

    if err := x.writeField9(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *Baz) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I32)):  // intField
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 4 && wireType == thrift.Type(thrift.SET)):  // setField
            if err := x.readField4(p); err != nil {
                return err
            }
        case (id == 6 && wireType == thrift.Type(thrift.MAP)):  // mapField
            if err := x.readField6(p); err != nil {
                return err
            }
        case (id == 8 && wireType == thrift.Type(thrift.STRING)):  // binaryField
            if err := x.readField8(p); err != nil {
                return err
            }
        case (id == 9 && wireType == thrift.Type(thrift.I64)):  // longField
            if err := x.readField9(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *Baz) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("Baz({")
    sb.WriteString(fmt.Sprintf("IntField:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("SetField:%s ", x.toString4()))
    sb.WriteString(fmt.Sprintf("MapField:%s ", x.toString6()))
    sb.WriteString(fmt.Sprintf("BinaryField:%s ", x.toString8()))
    sb.WriteString(fmt.Sprintf("LongField:%s", x.toString9()))
    sb.WriteString("})")

    return sb.String()
}

type Bar struct {
    StructField *Foo_6868 `thrift:"structField,1" json:"structField" db:"structField"`
    OptionalStructField *Foo_3943 `thrift:"optionalStructField,2,optional" json:"optionalStructField,omitempty" db:"optionalStructField"`
    StructListField []*FooWithAdapter_9317 `thrift:"structListField,3" json:"structListField" db:"structListField"`
    OptionalStructListField []*FooWithAdapter_9317 `thrift:"optionalStructListField,4,optional" json:"optionalStructListField,omitempty" db:"optionalStructListField"`
    UnionField *Baz_7352 `thrift:"unionField,5" json:"unionField" db:"unionField"`
    OptionalUnionField *Baz_7352 `thrift:"optionalUnionField,6,optional" json:"optionalUnionField,omitempty" db:"optionalUnionField"`
    AdaptedStructField *DirectlyAdapted `thrift:"adaptedStructField,7" json:"adaptedStructField" db:"adaptedStructField"`
}
// Compile time interface enforcer
var _ thrift.Struct = &Bar{}

func NewBar() *Bar {
    return (&Bar{}).
        SetStructFieldNonCompat(*NewFoo_6868()).
        SetStructListFieldNonCompat(make([]*FooWithAdapter_9317, 0)).
        SetUnionFieldNonCompat(*NewBaz_7352()).
        SetAdaptedStructFieldNonCompat(*NewDirectlyAdapted())
}

func (x *Bar) GetStructFieldNonCompat() *Foo_6868 {
    return x.StructField
}

func (x *Bar) GetStructField() *Foo_6868 {
    if !x.IsSetStructField() {
        return nil
    }

    return x.StructField
}

func (x *Bar) GetOptionalStructFieldNonCompat() *Foo_3943 {
    return x.OptionalStructField
}

func (x *Bar) GetOptionalStructField() *Foo_3943 {
    if !x.IsSetOptionalStructField() {
        return nil
    }

    return x.OptionalStructField
}

func (x *Bar) GetStructListFieldNonCompat() []*FooWithAdapter_9317 {
    return x.StructListField
}

func (x *Bar) GetStructListField() []*FooWithAdapter_9317 {
    if !x.IsSetStructListField() {
        return make([]*FooWithAdapter_9317, 0)
    }

    return x.StructListField
}

func (x *Bar) GetOptionalStructListFieldNonCompat() []*FooWithAdapter_9317 {
    return x.OptionalStructListField
}

func (x *Bar) GetOptionalStructListField() []*FooWithAdapter_9317 {
    if !x.IsSetOptionalStructListField() {
        return make([]*FooWithAdapter_9317, 0)
    }

    return x.OptionalStructListField
}

func (x *Bar) GetUnionFieldNonCompat() *Baz_7352 {
    return x.UnionField
}

func (x *Bar) GetUnionField() *Baz_7352 {
    if !x.IsSetUnionField() {
        return nil
    }

    return x.UnionField
}

func (x *Bar) GetOptionalUnionFieldNonCompat() *Baz_7352 {
    return x.OptionalUnionField
}

func (x *Bar) GetOptionalUnionField() *Baz_7352 {
    if !x.IsSetOptionalUnionField() {
        return nil
    }

    return x.OptionalUnionField
}

func (x *Bar) GetAdaptedStructFieldNonCompat() *DirectlyAdapted {
    return x.AdaptedStructField
}

func (x *Bar) GetAdaptedStructField() *DirectlyAdapted {
    if !x.IsSetAdaptedStructField() {
        return nil
    }

    return x.AdaptedStructField
}

func (x *Bar) SetStructFieldNonCompat(value Foo_6868) *Bar {
    x.StructField = &value
    return x
}

func (x *Bar) SetStructField(value *Foo_6868) *Bar {
    x.StructField = value
    return x
}

func (x *Bar) SetOptionalStructFieldNonCompat(value Foo_3943) *Bar {
    x.OptionalStructField = &value
    return x
}

func (x *Bar) SetOptionalStructField(value *Foo_3943) *Bar {
    x.OptionalStructField = value
    return x
}

func (x *Bar) SetStructListFieldNonCompat(value []*FooWithAdapter_9317) *Bar {
    x.StructListField = value
    return x
}

func (x *Bar) SetStructListField(value []*FooWithAdapter_9317) *Bar {
    x.StructListField = value
    return x
}

func (x *Bar) SetOptionalStructListFieldNonCompat(value []*FooWithAdapter_9317) *Bar {
    x.OptionalStructListField = value
    return x
}

func (x *Bar) SetOptionalStructListField(value []*FooWithAdapter_9317) *Bar {
    x.OptionalStructListField = value
    return x
}

func (x *Bar) SetUnionFieldNonCompat(value Baz_7352) *Bar {
    x.UnionField = &value
    return x
}

func (x *Bar) SetUnionField(value *Baz_7352) *Bar {
    x.UnionField = value
    return x
}

func (x *Bar) SetOptionalUnionFieldNonCompat(value Baz_7352) *Bar {
    x.OptionalUnionField = &value
    return x
}

func (x *Bar) SetOptionalUnionField(value *Baz_7352) *Bar {
    x.OptionalUnionField = value
    return x
}

func (x *Bar) SetAdaptedStructFieldNonCompat(value DirectlyAdapted) *Bar {
    x.AdaptedStructField = &value
    return x
}

func (x *Bar) SetAdaptedStructField(value *DirectlyAdapted) *Bar {
    x.AdaptedStructField = value
    return x
}

func (x *Bar) IsSetStructField() bool {
    return x != nil && x.StructField != nil
}

func (x *Bar) IsSetOptionalStructField() bool {
    return x != nil && x.OptionalStructField != nil
}

func (x *Bar) IsSetStructListField() bool {
    return x != nil && x.StructListField != nil
}

func (x *Bar) IsSetOptionalStructListField() bool {
    return x != nil && x.OptionalStructListField != nil
}

func (x *Bar) IsSetUnionField() bool {
    return x != nil && x.UnionField != nil
}

func (x *Bar) IsSetOptionalUnionField() bool {
    return x != nil && x.OptionalUnionField != nil
}

func (x *Bar) IsSetAdaptedStructField() bool {
    return x != nil && x.AdaptedStructField != nil
}

func (x *Bar) writeField1(p thrift.Protocol) error {  // StructField
    if !x.IsSetStructField() {
        return nil
    }

    if err := p.WriteFieldBegin("structField", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetStructFieldNonCompat()
    err := WriteFoo_6868(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Bar) writeField2(p thrift.Protocol) error {  // OptionalStructField
    if !x.IsSetOptionalStructField() {
        return nil
    }

    if err := p.WriteFieldBegin("optionalStructField", thrift.STRUCT, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetOptionalStructFieldNonCompat()
    err := WriteFoo_3943(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Bar) writeField3(p thrift.Protocol) error {  // StructListField
    if err := p.WriteFieldBegin("structListField", thrift.LIST, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetStructListFieldNonCompat()
    if err := p.WriteListBegin(thrift.STRUCT, len(item)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
}
for _, v := range item {
    {
        item := v
        err := WriteFooWithAdapter_9317(item, p)
if err != nil {
    return err
}
    }
}
if err := p.WriteListEnd(); err != nil {
    return thrift.PrependError("error writing list end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Bar) writeField4(p thrift.Protocol) error {  // OptionalStructListField
    if !x.IsSetOptionalStructListField() {
        return nil
    }

    if err := p.WriteFieldBegin("optionalStructListField", thrift.LIST, 4); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetOptionalStructListFieldNonCompat()
    if err := p.WriteListBegin(thrift.STRUCT, len(item)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
}
for _, v := range item {
    {
        item := v
        err := WriteFooWithAdapter_9317(item, p)
if err != nil {
    return err
}
    }
}
if err := p.WriteListEnd(); err != nil {
    return thrift.PrependError("error writing list end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Bar) writeField5(p thrift.Protocol) error {  // UnionField
    if !x.IsSetUnionField() {
        return nil
    }

    if err := p.WriteFieldBegin("unionField", thrift.STRUCT, 5); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetUnionFieldNonCompat()
    err := WriteBaz_7352(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Bar) writeField6(p thrift.Protocol) error {  // OptionalUnionField
    if !x.IsSetOptionalUnionField() {
        return nil
    }

    if err := p.WriteFieldBegin("optionalUnionField", thrift.STRUCT, 6); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetOptionalUnionFieldNonCompat()
    err := WriteBaz_7352(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Bar) writeField7(p thrift.Protocol) error {  // AdaptedStructField
    if !x.IsSetAdaptedStructField() {
        return nil
    }

    if err := p.WriteFieldBegin("adaptedStructField", thrift.STRUCT, 7); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedStructFieldNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Bar) readField1(p thrift.Protocol) error {  // StructField
    result, err := ReadFoo_6868(p)
if err != nil {
    return err
}

    x.SetStructFieldNonCompat(result)
    return nil
}

func (x *Bar) readField2(p thrift.Protocol) error {  // OptionalStructField
    result, err := ReadFoo_3943(p)
if err != nil {
    return err
}

    x.SetOptionalStructFieldNonCompat(result)
    return nil
}

func (x *Bar) readField3(p thrift.Protocol) error {  // StructListField
    _ /* elemType */, size, err := p.ReadListBegin()
if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
}

listResult := make([]*FooWithAdapter_9317, 0, size)
for i := 0; i < size; i++ {
    var elem FooWithAdapter_9317
    {
        result, err := ReadFooWithAdapter_9317(p)
if err != nil {
    return err
}
        elem = result
    }
    listResult = append(listResult, &elem)
}

if err := p.ReadListEnd(); err != nil {
    return thrift.PrependError("error reading list end: ", err)
}
result := listResult

    x.SetStructListFieldNonCompat(result)
    return nil
}

func (x *Bar) readField4(p thrift.Protocol) error {  // OptionalStructListField
    _ /* elemType */, size, err := p.ReadListBegin()
if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
}

listResult := make([]*FooWithAdapter_9317, 0, size)
for i := 0; i < size; i++ {
    var elem FooWithAdapter_9317
    {
        result, err := ReadFooWithAdapter_9317(p)
if err != nil {
    return err
}
        elem = result
    }
    listResult = append(listResult, &elem)
}

if err := p.ReadListEnd(); err != nil {
    return thrift.PrependError("error reading list end: ", err)
}
result := listResult

    x.SetOptionalStructListFieldNonCompat(result)
    return nil
}

func (x *Bar) readField5(p thrift.Protocol) error {  // UnionField
    result, err := ReadBaz_7352(p)
if err != nil {
    return err
}

    x.SetUnionFieldNonCompat(result)
    return nil
}

func (x *Bar) readField6(p thrift.Protocol) error {  // OptionalUnionField
    result, err := ReadBaz_7352(p)
if err != nil {
    return err
}

    x.SetOptionalUnionFieldNonCompat(result)
    return nil
}

func (x *Bar) readField7(p thrift.Protocol) error {  // AdaptedStructField
    result := *NewDirectlyAdapted()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetAdaptedStructFieldNonCompat(result)
    return nil
}

func (x *Bar) toString1() string {  // StructField
    return fmt.Sprintf("%v", x.GetStructFieldNonCompat())
}

func (x *Bar) toString2() string {  // OptionalStructField
    return fmt.Sprintf("%v", x.GetOptionalStructFieldNonCompat())
}

func (x *Bar) toString3() string {  // StructListField
    return fmt.Sprintf("%v", x.GetStructListFieldNonCompat())
}

func (x *Bar) toString4() string {  // OptionalStructListField
    return fmt.Sprintf("%v", x.GetOptionalStructListFieldNonCompat())
}

func (x *Bar) toString5() string {  // UnionField
    return fmt.Sprintf("%v", x.GetUnionFieldNonCompat())
}

func (x *Bar) toString6() string {  // OptionalUnionField
    return fmt.Sprintf("%v", x.GetOptionalUnionFieldNonCompat())
}

func (x *Bar) toString7() string {  // AdaptedStructField
    return fmt.Sprintf("%v", x.GetAdaptedStructFieldNonCompat())
}

// Deprecated: Use NewBar().GetStructField() instead.
func (x *Bar) DefaultGetStructField() *Foo_6868 {
    if !x.IsSetStructField() {
        return NewFoo_6868()
    }
    return x.StructField
}

// Deprecated: Use NewBar().GetOptionalStructField() instead.
func (x *Bar) DefaultGetOptionalStructField() *Foo_3943 {
    if !x.IsSetOptionalStructField() {
        return NewFoo_3943()
    }
    return x.OptionalStructField
}

// Deprecated: Use NewBar().GetUnionField() instead.
func (x *Bar) DefaultGetUnionField() *Baz_7352 {
    if !x.IsSetUnionField() {
        return NewBaz_7352()
    }
    return x.UnionField
}

// Deprecated: Use NewBar().GetOptionalUnionField() instead.
func (x *Bar) DefaultGetOptionalUnionField() *Baz_7352 {
    if !x.IsSetOptionalUnionField() {
        return NewBaz_7352()
    }
    return x.OptionalUnionField
}

// Deprecated: Use NewBar().GetAdaptedStructField() instead.
func (x *Bar) DefaultGetAdaptedStructField() *DirectlyAdapted {
    if !x.IsSetAdaptedStructField() {
        return NewDirectlyAdapted()
    }
    return x.AdaptedStructField
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewBar().Set<FieldNameFoo>().Set<FieldNameBar>()
type BarBuilder struct {
    obj *Bar
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewBar().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewBarBuilder() *BarBuilder {
    return &BarBuilder{
        obj: NewBar(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewBar().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *BarBuilder) StructField(value *Foo_6868) *BarBuilder {
    x.obj.StructField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewBar().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *BarBuilder) OptionalStructField(value *Foo_3943) *BarBuilder {
    x.obj.OptionalStructField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewBar().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *BarBuilder) StructListField(value []*FooWithAdapter_9317) *BarBuilder {
    x.obj.StructListField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewBar().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *BarBuilder) OptionalStructListField(value []*FooWithAdapter_9317) *BarBuilder {
    x.obj.OptionalStructListField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewBar().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *BarBuilder) UnionField(value *Baz_7352) *BarBuilder {
    x.obj.UnionField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewBar().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *BarBuilder) OptionalUnionField(value *Baz_7352) *BarBuilder {
    x.obj.OptionalUnionField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewBar().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *BarBuilder) AdaptedStructField(value *DirectlyAdapted) *BarBuilder {
    x.obj.AdaptedStructField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewBar().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *BarBuilder) Emit() *Bar {
    var objCopy Bar = *x.obj
    return &objCopy
}

func (x *Bar) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("Bar"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := x.writeField4(p); err != nil {
        return err
    }

    if err := x.writeField5(p); err != nil {
        return err
    }

    if err := x.writeField6(p); err != nil {
        return err
    }

    if err := x.writeField7(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *Bar) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRUCT)):  // structField
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.STRUCT)):  // optionalStructField
            if err := x.readField2(p); err != nil {
                return err
            }
        case (id == 3 && wireType == thrift.Type(thrift.LIST)):  // structListField
            if err := x.readField3(p); err != nil {
                return err
            }
        case (id == 4 && wireType == thrift.Type(thrift.LIST)):  // optionalStructListField
            if err := x.readField4(p); err != nil {
                return err
            }
        case (id == 5 && wireType == thrift.Type(thrift.STRUCT)):  // unionField
            if err := x.readField5(p); err != nil {
                return err
            }
        case (id == 6 && wireType == thrift.Type(thrift.STRUCT)):  // optionalUnionField
            if err := x.readField6(p); err != nil {
                return err
            }
        case (id == 7 && wireType == thrift.Type(thrift.STRUCT)):  // adaptedStructField
            if err := x.readField7(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *Bar) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("Bar({")
    sb.WriteString(fmt.Sprintf("StructField:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("OptionalStructField:%s ", x.toString2()))
    sb.WriteString(fmt.Sprintf("StructListField:%s ", x.toString3()))
    sb.WriteString(fmt.Sprintf("OptionalStructListField:%s ", x.toString4()))
    sb.WriteString(fmt.Sprintf("UnionField:%s ", x.toString5()))
    sb.WriteString(fmt.Sprintf("OptionalUnionField:%s ", x.toString6()))
    sb.WriteString(fmt.Sprintf("AdaptedStructField:%s", x.toString7()))
    sb.WriteString("})")

    return sb.String()
}

type DirectlyAdapted struct {
    Field int32 `thrift:"field,1" json:"field" db:"field"`
}
// Compile time interface enforcer
var _ thrift.Struct = &DirectlyAdapted{}

func NewDirectlyAdapted() *DirectlyAdapted {
    return (&DirectlyAdapted{}).
        SetFieldNonCompat(0)
}

func (x *DirectlyAdapted) GetFieldNonCompat() int32 {
    return x.Field
}

func (x *DirectlyAdapted) GetField() int32 {
    return x.Field
}

func (x *DirectlyAdapted) SetFieldNonCompat(value int32) *DirectlyAdapted {
    x.Field = value
    return x
}

func (x *DirectlyAdapted) SetField(value int32) *DirectlyAdapted {
    x.Field = value
    return x
}

func (x *DirectlyAdapted) writeField1(p thrift.Protocol) error {  // Field
    if err := p.WriteFieldBegin("field", thrift.I32, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetFieldNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *DirectlyAdapted) readField1(p thrift.Protocol) error {  // Field
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetFieldNonCompat(result)
    return nil
}

func (x *DirectlyAdapted) toString1() string {  // Field
    return fmt.Sprintf("%v", x.GetFieldNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewDirectlyAdapted().Set<FieldNameFoo>().Set<FieldNameBar>()
type DirectlyAdaptedBuilder struct {
    obj *DirectlyAdapted
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewDirectlyAdapted().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewDirectlyAdaptedBuilder() *DirectlyAdaptedBuilder {
    return &DirectlyAdaptedBuilder{
        obj: NewDirectlyAdapted(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewDirectlyAdapted().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *DirectlyAdaptedBuilder) Field(value int32) *DirectlyAdaptedBuilder {
    x.obj.Field = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewDirectlyAdapted().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *DirectlyAdaptedBuilder) Emit() *DirectlyAdapted {
    var objCopy DirectlyAdapted = *x.obj
    return &objCopy
}

func (x *DirectlyAdapted) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("DirectlyAdapted"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *DirectlyAdapted) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I32)):  // field
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *DirectlyAdapted) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("DirectlyAdapted({")
    sb.WriteString(fmt.Sprintf("Field:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}

type IndependentDirectlyAdapted struct {
    Field int32 `thrift:"field,1" json:"field" db:"field"`
}
// Compile time interface enforcer
var _ thrift.Struct = &IndependentDirectlyAdapted{}

func NewIndependentDirectlyAdapted() *IndependentDirectlyAdapted {
    return (&IndependentDirectlyAdapted{}).
        SetFieldNonCompat(0)
}

func (x *IndependentDirectlyAdapted) GetFieldNonCompat() int32 {
    return x.Field
}

func (x *IndependentDirectlyAdapted) GetField() int32 {
    return x.Field
}

func (x *IndependentDirectlyAdapted) SetFieldNonCompat(value int32) *IndependentDirectlyAdapted {
    x.Field = value
    return x
}

func (x *IndependentDirectlyAdapted) SetField(value int32) *IndependentDirectlyAdapted {
    x.Field = value
    return x
}

func (x *IndependentDirectlyAdapted) writeField1(p thrift.Protocol) error {  // Field
    if err := p.WriteFieldBegin("field", thrift.I32, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetFieldNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *IndependentDirectlyAdapted) readField1(p thrift.Protocol) error {  // Field
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetFieldNonCompat(result)
    return nil
}

func (x *IndependentDirectlyAdapted) toString1() string {  // Field
    return fmt.Sprintf("%v", x.GetFieldNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewIndependentDirectlyAdapted().Set<FieldNameFoo>().Set<FieldNameBar>()
type IndependentDirectlyAdaptedBuilder struct {
    obj *IndependentDirectlyAdapted
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewIndependentDirectlyAdapted().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewIndependentDirectlyAdaptedBuilder() *IndependentDirectlyAdaptedBuilder {
    return &IndependentDirectlyAdaptedBuilder{
        obj: NewIndependentDirectlyAdapted(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewIndependentDirectlyAdapted().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *IndependentDirectlyAdaptedBuilder) Field(value int32) *IndependentDirectlyAdaptedBuilder {
    x.obj.Field = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewIndependentDirectlyAdapted().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *IndependentDirectlyAdaptedBuilder) Emit() *IndependentDirectlyAdapted {
    var objCopy IndependentDirectlyAdapted = *x.obj
    return &objCopy
}

func (x *IndependentDirectlyAdapted) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("IndependentDirectlyAdapted"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *IndependentDirectlyAdapted) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I32)):  // field
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *IndependentDirectlyAdapted) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("IndependentDirectlyAdapted({")
    sb.WriteString(fmt.Sprintf("Field:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}

type StructWithFieldAdapter struct {
    Field int32 `thrift:"field,1" json:"field" db:"field"`
    SharedField int32 `thrift:"shared_field,2" json:"shared_field" db:"shared_field"`
    OptSharedField *int32 `thrift:"opt_shared_field,3,optional" json:"opt_shared_field,omitempty" db:"opt_shared_field"`
    OptBoxedField *int32 `thrift:"opt_boxed_field,4,optional" json:"opt_boxed_field,omitempty" db:"opt_boxed_field"`
}
// Compile time interface enforcer
var _ thrift.Struct = &StructWithFieldAdapter{}

func NewStructWithFieldAdapter() *StructWithFieldAdapter {
    return (&StructWithFieldAdapter{}).
        SetFieldNonCompat(0).
        SetSharedFieldNonCompat(0)
}

func (x *StructWithFieldAdapter) GetFieldNonCompat() int32 {
    return x.Field
}

func (x *StructWithFieldAdapter) GetField() int32 {
    return x.Field
}

func (x *StructWithFieldAdapter) GetSharedFieldNonCompat() int32 {
    return x.SharedField
}

func (x *StructWithFieldAdapter) GetSharedField() int32 {
    return x.SharedField
}

func (x *StructWithFieldAdapter) GetOptSharedFieldNonCompat() *int32 {
    return x.OptSharedField
}

func (x *StructWithFieldAdapter) GetOptSharedField() int32 {
    if !x.IsSetOptSharedField() {
        return 0
    }

    return *x.OptSharedField
}

func (x *StructWithFieldAdapter) GetOptBoxedFieldNonCompat() *int32 {
    return x.OptBoxedField
}

func (x *StructWithFieldAdapter) GetOptBoxedField() int32 {
    if !x.IsSetOptBoxedField() {
        return 0
    }

    return *x.OptBoxedField
}

func (x *StructWithFieldAdapter) SetFieldNonCompat(value int32) *StructWithFieldAdapter {
    x.Field = value
    return x
}

func (x *StructWithFieldAdapter) SetField(value int32) *StructWithFieldAdapter {
    x.Field = value
    return x
}

func (x *StructWithFieldAdapter) SetSharedFieldNonCompat(value int32) *StructWithFieldAdapter {
    x.SharedField = value
    return x
}

func (x *StructWithFieldAdapter) SetSharedField(value int32) *StructWithFieldAdapter {
    x.SharedField = value
    return x
}

func (x *StructWithFieldAdapter) SetOptSharedFieldNonCompat(value int32) *StructWithFieldAdapter {
    x.OptSharedField = &value
    return x
}

func (x *StructWithFieldAdapter) SetOptSharedField(value *int32) *StructWithFieldAdapter {
    x.OptSharedField = value
    return x
}

func (x *StructWithFieldAdapter) SetOptBoxedFieldNonCompat(value int32) *StructWithFieldAdapter {
    x.OptBoxedField = &value
    return x
}

func (x *StructWithFieldAdapter) SetOptBoxedField(value *int32) *StructWithFieldAdapter {
    x.OptBoxedField = value
    return x
}

func (x *StructWithFieldAdapter) IsSetOptSharedField() bool {
    return x != nil && x.OptSharedField != nil
}

func (x *StructWithFieldAdapter) IsSetOptBoxedField() bool {
    return x != nil && x.OptBoxedField != nil
}

func (x *StructWithFieldAdapter) writeField1(p thrift.Protocol) error {  // Field
    if err := p.WriteFieldBegin("field", thrift.I32, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetFieldNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *StructWithFieldAdapter) writeField2(p thrift.Protocol) error {  // SharedField
    if err := p.WriteFieldBegin("shared_field", thrift.I32, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetSharedFieldNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *StructWithFieldAdapter) writeField3(p thrift.Protocol) error {  // OptSharedField
    if !x.IsSetOptSharedField() {
        return nil
    }

    if err := p.WriteFieldBegin("opt_shared_field", thrift.I32, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetOptSharedFieldNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *StructWithFieldAdapter) writeField4(p thrift.Protocol) error {  // OptBoxedField
    if !x.IsSetOptBoxedField() {
        return nil
    }

    if err := p.WriteFieldBegin("opt_boxed_field", thrift.I32, 4); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetOptBoxedFieldNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *StructWithFieldAdapter) readField1(p thrift.Protocol) error {  // Field
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetFieldNonCompat(result)
    return nil
}

func (x *StructWithFieldAdapter) readField2(p thrift.Protocol) error {  // SharedField
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetSharedFieldNonCompat(result)
    return nil
}

func (x *StructWithFieldAdapter) readField3(p thrift.Protocol) error {  // OptSharedField
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetOptSharedFieldNonCompat(result)
    return nil
}

func (x *StructWithFieldAdapter) readField4(p thrift.Protocol) error {  // OptBoxedField
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetOptBoxedFieldNonCompat(result)
    return nil
}

func (x *StructWithFieldAdapter) toString1() string {  // Field
    return fmt.Sprintf("%v", x.GetFieldNonCompat())
}

func (x *StructWithFieldAdapter) toString2() string {  // SharedField
    return fmt.Sprintf("%v", x.GetSharedFieldNonCompat())
}

func (x *StructWithFieldAdapter) toString3() string {  // OptSharedField
    if x.IsSetOptSharedField() {
        return fmt.Sprintf("%v", *x.GetOptSharedFieldNonCompat())
    }
    return fmt.Sprintf("%v", x.GetOptSharedFieldNonCompat())
}

func (x *StructWithFieldAdapter) toString4() string {  // OptBoxedField
    if x.IsSetOptBoxedField() {
        return fmt.Sprintf("%v", *x.GetOptBoxedFieldNonCompat())
    }
    return fmt.Sprintf("%v", x.GetOptBoxedFieldNonCompat())
}




// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewStructWithFieldAdapter().Set<FieldNameFoo>().Set<FieldNameBar>()
type StructWithFieldAdapterBuilder struct {
    obj *StructWithFieldAdapter
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewStructWithFieldAdapter().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewStructWithFieldAdapterBuilder() *StructWithFieldAdapterBuilder {
    return &StructWithFieldAdapterBuilder{
        obj: NewStructWithFieldAdapter(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewStructWithFieldAdapter().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *StructWithFieldAdapterBuilder) Field(value int32) *StructWithFieldAdapterBuilder {
    x.obj.Field = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewStructWithFieldAdapter().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *StructWithFieldAdapterBuilder) SharedField(value int32) *StructWithFieldAdapterBuilder {
    x.obj.SharedField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewStructWithFieldAdapter().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *StructWithFieldAdapterBuilder) OptSharedField(value *int32) *StructWithFieldAdapterBuilder {
    x.obj.OptSharedField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewStructWithFieldAdapter().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *StructWithFieldAdapterBuilder) OptBoxedField(value *int32) *StructWithFieldAdapterBuilder {
    x.obj.OptBoxedField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewStructWithFieldAdapter().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *StructWithFieldAdapterBuilder) Emit() *StructWithFieldAdapter {
    var objCopy StructWithFieldAdapter = *x.obj
    return &objCopy
}

func (x *StructWithFieldAdapter) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("StructWithFieldAdapter"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := x.writeField4(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *StructWithFieldAdapter) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I32)):  // field
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.I32)):  // shared_field
            if err := x.readField2(p); err != nil {
                return err
            }
        case (id == 3 && wireType == thrift.Type(thrift.I32)):  // opt_shared_field
            if err := x.readField3(p); err != nil {
                return err
            }
        case (id == 4 && wireType == thrift.Type(thrift.I32)):  // opt_boxed_field
            if err := x.readField4(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *StructWithFieldAdapter) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("StructWithFieldAdapter({")
    sb.WriteString(fmt.Sprintf("Field:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("SharedField:%s ", x.toString2()))
    sb.WriteString(fmt.Sprintf("OptSharedField:%s ", x.toString3()))
    sb.WriteString(fmt.Sprintf("OptBoxedField:%s", x.toString4()))
    sb.WriteString("})")

    return sb.String()
}

type TerseAdaptedFields struct {
    IntField int32 `thrift:"int_field,1" json:"int_field" db:"int_field"`
    StringField string `thrift:"string_field,2" json:"string_field" db:"string_field"`
    SetField []int32 `thrift:"set_field,3" json:"set_field" db:"set_field"`
}
// Compile time interface enforcer
var _ thrift.Struct = &TerseAdaptedFields{}

func NewTerseAdaptedFields() *TerseAdaptedFields {
    return (&TerseAdaptedFields{}).
        SetIntFieldNonCompat(0).
        SetStringFieldNonCompat("").
        SetSetFieldNonCompat(make([]int32, 0))
}

func (x *TerseAdaptedFields) GetIntFieldNonCompat() int32 {
    return x.IntField
}

func (x *TerseAdaptedFields) GetIntField() int32 {
    return x.IntField
}

func (x *TerseAdaptedFields) GetStringFieldNonCompat() string {
    return x.StringField
}

func (x *TerseAdaptedFields) GetStringField() string {
    return x.StringField
}

func (x *TerseAdaptedFields) GetSetFieldNonCompat() []int32 {
    return x.SetField
}

func (x *TerseAdaptedFields) GetSetField() []int32 {
    if !x.IsSetSetField() {
        return make([]int32, 0)
    }

    return x.SetField
}

func (x *TerseAdaptedFields) SetIntFieldNonCompat(value int32) *TerseAdaptedFields {
    x.IntField = value
    return x
}

func (x *TerseAdaptedFields) SetIntField(value int32) *TerseAdaptedFields {
    x.IntField = value
    return x
}

func (x *TerseAdaptedFields) SetStringFieldNonCompat(value string) *TerseAdaptedFields {
    x.StringField = value
    return x
}

func (x *TerseAdaptedFields) SetStringField(value string) *TerseAdaptedFields {
    x.StringField = value
    return x
}

func (x *TerseAdaptedFields) SetSetFieldNonCompat(value []int32) *TerseAdaptedFields {
    x.SetField = value
    return x
}

func (x *TerseAdaptedFields) SetSetField(value []int32) *TerseAdaptedFields {
    x.SetField = value
    return x
}

func (x *TerseAdaptedFields) IsSetSetField() bool {
    return x != nil && x.SetField != nil
}

func (x *TerseAdaptedFields) writeField1(p thrift.Protocol) error {  // IntField
    if err := p.WriteFieldBegin("int_field", thrift.I32, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetIntFieldNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TerseAdaptedFields) writeField2(p thrift.Protocol) error {  // StringField
    if err := p.WriteFieldBegin("string_field", thrift.STRING, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetStringFieldNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TerseAdaptedFields) writeField3(p thrift.Protocol) error {  // SetField
    if err := p.WriteFieldBegin("set_field", thrift.SET, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetSetFieldNonCompat()
    if err := p.WriteSetBegin(thrift.I32, len(item)); err != nil {
    return thrift.PrependError("error writing set begin: ", err)
}
for _, v := range item {
    {
        item := v
        if err := p.WriteI32(item); err != nil {
    return err
}
    }
}
if err := p.WriteSetEnd(); err != nil {
    return thrift.PrependError("error writing set end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TerseAdaptedFields) readField1(p thrift.Protocol) error {  // IntField
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetIntFieldNonCompat(result)
    return nil
}

func (x *TerseAdaptedFields) readField2(p thrift.Protocol) error {  // StringField
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetStringFieldNonCompat(result)
    return nil
}

func (x *TerseAdaptedFields) readField3(p thrift.Protocol) error {  // SetField
    _ /* elemType */, size, err := p.ReadSetBegin()
if err != nil {
    return thrift.PrependError("error reading set begin: ", err)
}

setResult := make([]int32, 0, size)
for i := 0; i < size; i++ {
    var elem int32
    {
        result, err := p.ReadI32()
if err != nil {
    return err
}
        elem = result
    }
    setResult = append(setResult, elem)
}

if err := p.ReadSetEnd(); err != nil {
    return thrift.PrependError("error reading set end: ", err)
}
result := setResult

    x.SetSetFieldNonCompat(result)
    return nil
}

func (x *TerseAdaptedFields) toString1() string {  // IntField
    return fmt.Sprintf("%v", x.GetIntFieldNonCompat())
}

func (x *TerseAdaptedFields) toString2() string {  // StringField
    return fmt.Sprintf("%v", x.GetStringFieldNonCompat())
}

func (x *TerseAdaptedFields) toString3() string {  // SetField
    return fmt.Sprintf("%v", x.GetSetFieldNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTerseAdaptedFields().Set<FieldNameFoo>().Set<FieldNameBar>()
type TerseAdaptedFieldsBuilder struct {
    obj *TerseAdaptedFields
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTerseAdaptedFields().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewTerseAdaptedFieldsBuilder() *TerseAdaptedFieldsBuilder {
    return &TerseAdaptedFieldsBuilder{
        obj: NewTerseAdaptedFields(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTerseAdaptedFields().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TerseAdaptedFieldsBuilder) IntField(value int32) *TerseAdaptedFieldsBuilder {
    x.obj.IntField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTerseAdaptedFields().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TerseAdaptedFieldsBuilder) StringField(value string) *TerseAdaptedFieldsBuilder {
    x.obj.StringField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTerseAdaptedFields().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TerseAdaptedFieldsBuilder) SetField(value []int32) *TerseAdaptedFieldsBuilder {
    x.obj.SetField = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTerseAdaptedFields().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TerseAdaptedFieldsBuilder) Emit() *TerseAdaptedFields {
    var objCopy TerseAdaptedFields = *x.obj
    return &objCopy
}

func (x *TerseAdaptedFields) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("TerseAdaptedFields"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *TerseAdaptedFields) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I32)):  // int_field
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.STRING)):  // string_field
            if err := x.readField2(p); err != nil {
                return err
            }
        case (id == 3 && wireType == thrift.Type(thrift.SET)):  // set_field
            if err := x.readField3(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *TerseAdaptedFields) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("TerseAdaptedFields({")
    sb.WriteString(fmt.Sprintf("IntField:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("StringField:%s ", x.toString2()))
    sb.WriteString(fmt.Sprintf("SetField:%s", x.toString3()))
    sb.WriteString("})")

    return sb.String()
}

type B struct {
    A *AdaptedA `thrift:"a,1" json:"a" db:"a"`
}
// Compile time interface enforcer
var _ thrift.Struct = &B{}

func NewB() *B {
    return (&B{}).
        SetANonCompat(*NewAdaptedA())
}

func (x *B) GetANonCompat() *AdaptedA {
    return x.A
}

func (x *B) GetA() *AdaptedA {
    if !x.IsSetA() {
        return nil
    }

    return x.A
}

func (x *B) SetANonCompat(value AdaptedA) *B {
    x.A = &value
    return x
}

func (x *B) SetA(value *AdaptedA) *B {
    x.A = value
    return x
}

func (x *B) IsSetA() bool {
    return x != nil && x.A != nil
}

func (x *B) writeField1(p thrift.Protocol) error {  // A
    if !x.IsSetA() {
        return nil
    }

    if err := p.WriteFieldBegin("a", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetANonCompat()
    err := WriteAdaptedA(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *B) readField1(p thrift.Protocol) error {  // A
    result, err := ReadAdaptedA(p)
if err != nil {
    return err
}

    x.SetANonCompat(result)
    return nil
}

func (x *B) toString1() string {  // A
    return fmt.Sprintf("%v", x.GetANonCompat())
}

// Deprecated: Use NewB().GetA() instead.
func (x *B) DefaultGetA() *AdaptedA {
    if !x.IsSetA() {
        return NewAdaptedA()
    }
    return x.A
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewB().Set<FieldNameFoo>().Set<FieldNameBar>()
type BBuilder struct {
    obj *B
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewB().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewBBuilder() *BBuilder {
    return &BBuilder{
        obj: NewB(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewB().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *BBuilder) A(value *AdaptedA) *BBuilder {
    x.obj.A = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewB().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *BBuilder) Emit() *B {
    var objCopy B = *x.obj
    return &objCopy
}

func (x *B) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("B"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *B) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRUCT)):  // a
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *B) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("B({")
    sb.WriteString(fmt.Sprintf("A:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}

type A struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &A{}

func NewA() *A {
    return (&A{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewA().Set<FieldNameFoo>().Set<FieldNameBar>()
type ABuilder struct {
    obj *A
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewA().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewABuilder() *ABuilder {
    return &ABuilder{
        obj: NewA(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewA().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ABuilder) Emit() *A {
    var objCopy A = *x.obj
    return &objCopy
}

func (x *A) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("A"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *A) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *A) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("A({")
    sb.WriteString("})")

    return sb.String()
}

type Config struct {
    Path string `thrift:"path,1" json:"path" db:"path"`
}
// Compile time interface enforcer
var _ thrift.Struct = &Config{}

func NewConfig() *Config {
    return (&Config{}).
        SetPathNonCompat("")
}

func (x *Config) GetPathNonCompat() string {
    return x.Path
}

func (x *Config) GetPath() string {
    return x.Path
}

func (x *Config) SetPathNonCompat(value string) *Config {
    x.Path = value
    return x
}

func (x *Config) SetPath(value string) *Config {
    x.Path = value
    return x
}

func (x *Config) writeField1(p thrift.Protocol) error {  // Path
    if err := p.WriteFieldBegin("path", thrift.STRING, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetPathNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Config) readField1(p thrift.Protocol) error {  // Path
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetPathNonCompat(result)
    return nil
}

func (x *Config) toString1() string {  // Path
    return fmt.Sprintf("%v", x.GetPathNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewConfig().Set<FieldNameFoo>().Set<FieldNameBar>()
type ConfigBuilder struct {
    obj *Config
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewConfig().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewConfigBuilder() *ConfigBuilder {
    return &ConfigBuilder{
        obj: NewConfig(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewConfig().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ConfigBuilder) Path(value string) *ConfigBuilder {
    x.obj.Path = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewConfig().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ConfigBuilder) Emit() *Config {
    var objCopy Config = *x.obj
    return &objCopy
}

func (x *Config) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("Config"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *Config) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRING)):  // path
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *Config) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("Config({")
    sb.WriteString(fmt.Sprintf("Path:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}

type MyStruct struct {
    Field int32 `thrift:"field,1" json:"field" db:"field"`
    SetString SetWithAdapter `thrift:"set_string,2" json:"set_string" db:"set_string"`
}
// Compile time interface enforcer
var _ thrift.Struct = &MyStruct{}

func NewMyStruct() *MyStruct {
    return (&MyStruct{}).
        SetFieldNonCompat(0).
        SetSetStringNonCompat(NewSetWithAdapter())
}

func (x *MyStruct) GetFieldNonCompat() int32 {
    return x.Field
}

func (x *MyStruct) GetField() int32 {
    return x.Field
}

func (x *MyStruct) GetSetStringNonCompat() SetWithAdapter {
    return x.SetString
}

func (x *MyStruct) GetSetString() SetWithAdapter {
    if !x.IsSetSetString() {
        return NewSetWithAdapter()
    }

    return x.SetString
}

func (x *MyStruct) SetFieldNonCompat(value int32) *MyStruct {
    x.Field = value
    return x
}

func (x *MyStruct) SetField(value int32) *MyStruct {
    x.Field = value
    return x
}

func (x *MyStruct) SetSetStringNonCompat(value SetWithAdapter) *MyStruct {
    x.SetString = value
    return x
}

func (x *MyStruct) SetSetString(value SetWithAdapter) *MyStruct {
    x.SetString = value
    return x
}

func (x *MyStruct) IsSetSetString() bool {
    return x != nil && x.SetString != nil
}

func (x *MyStruct) writeField1(p thrift.Protocol) error {  // Field
    if err := p.WriteFieldBegin("field", thrift.I32, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetFieldNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *MyStruct) writeField2(p thrift.Protocol) error {  // SetString
    if err := p.WriteFieldBegin("set_string", thrift.SET, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetSetStringNonCompat()
    err := WriteSetWithAdapter(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *MyStruct) readField1(p thrift.Protocol) error {  // Field
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetFieldNonCompat(result)
    return nil
}

func (x *MyStruct) readField2(p thrift.Protocol) error {  // SetString
    result, err := ReadSetWithAdapter(p)
if err != nil {
    return err
}

    x.SetSetStringNonCompat(result)
    return nil
}

func (x *MyStruct) toString1() string {  // Field
    return fmt.Sprintf("%v", x.GetFieldNonCompat())
}

func (x *MyStruct) toString2() string {  // SetString
    return fmt.Sprintf("%v", x.GetSetStringNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewMyStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
type MyStructBuilder struct {
    obj *MyStruct
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewMyStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewMyStructBuilder() *MyStructBuilder {
    return &MyStructBuilder{
        obj: NewMyStruct(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewMyStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *MyStructBuilder) Field(value int32) *MyStructBuilder {
    x.obj.Field = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewMyStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *MyStructBuilder) SetString(value SetWithAdapter) *MyStructBuilder {
    x.obj.SetString = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewMyStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *MyStructBuilder) Emit() *MyStruct {
    var objCopy MyStruct = *x.obj
    return &objCopy
}

func (x *MyStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("MyStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *MyStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I32)):  // field
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.SET)):  // set_string
            if err := x.readField2(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *MyStruct) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("MyStruct({")
    sb.WriteString(fmt.Sprintf("Field:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("SetString:%s", x.toString2()))
    sb.WriteString("})")

    return sb.String()
}

type AdaptTestStruct struct {
    Delay DurationMs `thrift:"delay,1" json:"delay" db:"delay"`
    Custom CustomProtocolType `thrift:"custom,2" json:"custom" db:"custom"`
    Timeout int64 `thrift:"timeout,3" json:"timeout" db:"timeout"`
    Data int64 `thrift:"data,4" json:"data" db:"data"`
    Meta string `thrift:"meta,5" json:"meta" db:"meta"`
    IndirectionString IndirectionString `thrift:"indirectionString,6" json:"indirectionString" db:"indirectionString"`
    StringData string `thrift:"string_data,7" json:"string_data" db:"string_data"`
    DoubleWrappedBool AdaptedBool `thrift:"double_wrapped_bool,8" json:"double_wrapped_bool" db:"double_wrapped_bool"`
    DoubleWrappedInteger AdaptedInteger `thrift:"double_wrapped_integer,9" json:"double_wrapped_integer" db:"double_wrapped_integer"`
    BinaryData []byte `thrift:"binary_data,10" json:"binary_data" db:"binary_data"`
}
// Compile time interface enforcer
var _ thrift.Struct = &AdaptTestStruct{}

func NewAdaptTestStruct() *AdaptTestStruct {
    return (&AdaptTestStruct{}).
        SetDelayNonCompat(NewDurationMs()).
        SetCustomNonCompat(NewCustomProtocolType()).
        SetTimeoutNonCompat(0).
        SetDataNonCompat(0).
        SetMetaNonCompat("").
        SetIndirectionStringNonCompat(NewIndirectionString()).
        SetStringDataNonCompat("").
        SetDoubleWrappedBoolNonCompat(NewAdaptedBool()).
        SetDoubleWrappedIntegerNonCompat(NewAdaptedInteger()).
        SetBinaryDataNonCompat([]byte(""))
}

func (x *AdaptTestStruct) GetDelayNonCompat() DurationMs {
    return x.Delay
}

func (x *AdaptTestStruct) GetDelay() DurationMs {
    return x.Delay
}

func (x *AdaptTestStruct) GetCustomNonCompat() CustomProtocolType {
    return x.Custom
}

func (x *AdaptTestStruct) GetCustom() CustomProtocolType {
    if !x.IsSetCustom() {
        return NewCustomProtocolType()
    }

    return x.Custom
}

func (x *AdaptTestStruct) GetTimeoutNonCompat() int64 {
    return x.Timeout
}

func (x *AdaptTestStruct) GetTimeout() int64 {
    return x.Timeout
}

func (x *AdaptTestStruct) GetDataNonCompat() int64 {
    return x.Data
}

func (x *AdaptTestStruct) GetData() int64 {
    return x.Data
}

func (x *AdaptTestStruct) GetMetaNonCompat() string {
    return x.Meta
}

func (x *AdaptTestStruct) GetMeta() string {
    return x.Meta
}

func (x *AdaptTestStruct) GetIndirectionStringNonCompat() IndirectionString {
    return x.IndirectionString
}

func (x *AdaptTestStruct) GetIndirectionString() IndirectionString {
    return x.IndirectionString
}

func (x *AdaptTestStruct) GetStringDataNonCompat() string {
    return x.StringData
}

func (x *AdaptTestStruct) GetStringData() string {
    return x.StringData
}

func (x *AdaptTestStruct) GetDoubleWrappedBoolNonCompat() AdaptedBool {
    return x.DoubleWrappedBool
}

func (x *AdaptTestStruct) GetDoubleWrappedBool() AdaptedBool {
    return x.DoubleWrappedBool
}

func (x *AdaptTestStruct) GetDoubleWrappedIntegerNonCompat() AdaptedInteger {
    return x.DoubleWrappedInteger
}

func (x *AdaptTestStruct) GetDoubleWrappedInteger() AdaptedInteger {
    return x.DoubleWrappedInteger
}

func (x *AdaptTestStruct) GetBinaryDataNonCompat() []byte {
    return x.BinaryData
}

func (x *AdaptTestStruct) GetBinaryData() []byte {
    if !x.IsSetBinaryData() {
        return []byte("")
    }

    return x.BinaryData
}

func (x *AdaptTestStruct) SetDelayNonCompat(value DurationMs) *AdaptTestStruct {
    x.Delay = value
    return x
}

func (x *AdaptTestStruct) SetDelay(value DurationMs) *AdaptTestStruct {
    x.Delay = value
    return x
}

func (x *AdaptTestStruct) SetCustomNonCompat(value CustomProtocolType) *AdaptTestStruct {
    x.Custom = value
    return x
}

func (x *AdaptTestStruct) SetCustom(value CustomProtocolType) *AdaptTestStruct {
    x.Custom = value
    return x
}

func (x *AdaptTestStruct) SetTimeoutNonCompat(value int64) *AdaptTestStruct {
    x.Timeout = value
    return x
}

func (x *AdaptTestStruct) SetTimeout(value int64) *AdaptTestStruct {
    x.Timeout = value
    return x
}

func (x *AdaptTestStruct) SetDataNonCompat(value int64) *AdaptTestStruct {
    x.Data = value
    return x
}

func (x *AdaptTestStruct) SetData(value int64) *AdaptTestStruct {
    x.Data = value
    return x
}

func (x *AdaptTestStruct) SetMetaNonCompat(value string) *AdaptTestStruct {
    x.Meta = value
    return x
}

func (x *AdaptTestStruct) SetMeta(value string) *AdaptTestStruct {
    x.Meta = value
    return x
}

func (x *AdaptTestStruct) SetIndirectionStringNonCompat(value IndirectionString) *AdaptTestStruct {
    x.IndirectionString = value
    return x
}

func (x *AdaptTestStruct) SetIndirectionString(value IndirectionString) *AdaptTestStruct {
    x.IndirectionString = value
    return x
}

func (x *AdaptTestStruct) SetStringDataNonCompat(value string) *AdaptTestStruct {
    x.StringData = value
    return x
}

func (x *AdaptTestStruct) SetStringData(value string) *AdaptTestStruct {
    x.StringData = value
    return x
}

func (x *AdaptTestStruct) SetDoubleWrappedBoolNonCompat(value AdaptedBool) *AdaptTestStruct {
    x.DoubleWrappedBool = value
    return x
}

func (x *AdaptTestStruct) SetDoubleWrappedBool(value AdaptedBool) *AdaptTestStruct {
    x.DoubleWrappedBool = value
    return x
}

func (x *AdaptTestStruct) SetDoubleWrappedIntegerNonCompat(value AdaptedInteger) *AdaptTestStruct {
    x.DoubleWrappedInteger = value
    return x
}

func (x *AdaptTestStruct) SetDoubleWrappedInteger(value AdaptedInteger) *AdaptTestStruct {
    x.DoubleWrappedInteger = value
    return x
}

func (x *AdaptTestStruct) SetBinaryDataNonCompat(value []byte) *AdaptTestStruct {
    x.BinaryData = value
    return x
}

func (x *AdaptTestStruct) SetBinaryData(value []byte) *AdaptTestStruct {
    x.BinaryData = value
    return x
}

func (x *AdaptTestStruct) IsSetCustom() bool {
    return x != nil && x.Custom != nil
}

func (x *AdaptTestStruct) IsSetBinaryData() bool {
    return x != nil && x.BinaryData != nil
}

func (x *AdaptTestStruct) writeField1(p thrift.Protocol) error {  // Delay
    if err := p.WriteFieldBegin("delay", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDelayNonCompat()
    err := WriteDurationMs(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) writeField2(p thrift.Protocol) error {  // Custom
    if err := p.WriteFieldBegin("custom", thrift.STRING, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetCustomNonCompat()
    err := WriteCustomProtocolType(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) writeField3(p thrift.Protocol) error {  // Timeout
    if err := p.WriteFieldBegin("timeout", thrift.I64, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetTimeoutNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) writeField4(p thrift.Protocol) error {  // Data
    if err := p.WriteFieldBegin("data", thrift.I64, 4); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDataNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) writeField5(p thrift.Protocol) error {  // Meta
    if err := p.WriteFieldBegin("meta", thrift.STRING, 5); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetMetaNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) writeField6(p thrift.Protocol) error {  // IndirectionString
    if err := p.WriteFieldBegin("indirectionString", thrift.STRING, 6); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetIndirectionStringNonCompat()
    err := WriteIndirectionString(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) writeField7(p thrift.Protocol) error {  // StringData
    if err := p.WriteFieldBegin("string_data", thrift.STRING, 7); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetStringDataNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) writeField8(p thrift.Protocol) error {  // DoubleWrappedBool
    if err := p.WriteFieldBegin("double_wrapped_bool", thrift.BOOL, 8); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDoubleWrappedBoolNonCompat()
    err := WriteAdaptedBool(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) writeField9(p thrift.Protocol) error {  // DoubleWrappedInteger
    if err := p.WriteFieldBegin("double_wrapped_integer", thrift.I32, 9); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDoubleWrappedIntegerNonCompat()
    err := WriteAdaptedInteger(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) writeField10(p thrift.Protocol) error {  // BinaryData
    if err := p.WriteFieldBegin("binary_data", thrift.STRING, 10); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetBinaryDataNonCompat()
    if err := p.WriteBinary(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) readField1(p thrift.Protocol) error {  // Delay
    result, err := ReadDurationMs(p)
if err != nil {
    return err
}

    x.SetDelayNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) readField2(p thrift.Protocol) error {  // Custom
    result, err := ReadCustomProtocolType(p)
if err != nil {
    return err
}

    x.SetCustomNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) readField3(p thrift.Protocol) error {  // Timeout
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetTimeoutNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) readField4(p thrift.Protocol) error {  // Data
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetDataNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) readField5(p thrift.Protocol) error {  // Meta
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetMetaNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) readField6(p thrift.Protocol) error {  // IndirectionString
    result, err := ReadIndirectionString(p)
if err != nil {
    return err
}

    x.SetIndirectionStringNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) readField7(p thrift.Protocol) error {  // StringData
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetStringDataNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) readField8(p thrift.Protocol) error {  // DoubleWrappedBool
    result, err := ReadAdaptedBool(p)
if err != nil {
    return err
}

    x.SetDoubleWrappedBoolNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) readField9(p thrift.Protocol) error {  // DoubleWrappedInteger
    result, err := ReadAdaptedInteger(p)
if err != nil {
    return err
}

    x.SetDoubleWrappedIntegerNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) readField10(p thrift.Protocol) error {  // BinaryData
    result, err := p.ReadBinary()
if err != nil {
    return err
}

    x.SetBinaryDataNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) toString1() string {  // Delay
    return fmt.Sprintf("%v", x.GetDelayNonCompat())
}

func (x *AdaptTestStruct) toString2() string {  // Custom
    return fmt.Sprintf("%v", x.GetCustomNonCompat())
}

func (x *AdaptTestStruct) toString3() string {  // Timeout
    return fmt.Sprintf("%v", x.GetTimeoutNonCompat())
}

func (x *AdaptTestStruct) toString4() string {  // Data
    return fmt.Sprintf("%v", x.GetDataNonCompat())
}

func (x *AdaptTestStruct) toString5() string {  // Meta
    return fmt.Sprintf("%v", x.GetMetaNonCompat())
}

func (x *AdaptTestStruct) toString6() string {  // IndirectionString
    return fmt.Sprintf("%v", x.GetIndirectionStringNonCompat())
}

func (x *AdaptTestStruct) toString7() string {  // StringData
    return fmt.Sprintf("%v", x.GetStringDataNonCompat())
}

func (x *AdaptTestStruct) toString8() string {  // DoubleWrappedBool
    return fmt.Sprintf("%v", x.GetDoubleWrappedBoolNonCompat())
}

func (x *AdaptTestStruct) toString9() string {  // DoubleWrappedInteger
    return fmt.Sprintf("%v", x.GetDoubleWrappedIntegerNonCompat())
}

func (x *AdaptTestStruct) toString10() string {  // BinaryData
    return fmt.Sprintf("%v", x.GetBinaryDataNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
type AdaptTestStructBuilder struct {
    obj *AdaptTestStruct
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewAdaptTestStructBuilder() *AdaptTestStructBuilder {
    return &AdaptTestStructBuilder{
        obj: NewAdaptTestStruct(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTestStructBuilder) Delay(value DurationMs) *AdaptTestStructBuilder {
    x.obj.Delay = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTestStructBuilder) Custom(value CustomProtocolType) *AdaptTestStructBuilder {
    x.obj.Custom = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTestStructBuilder) Timeout(value int64) *AdaptTestStructBuilder {
    x.obj.Timeout = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTestStructBuilder) Data(value int64) *AdaptTestStructBuilder {
    x.obj.Data = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTestStructBuilder) Meta(value string) *AdaptTestStructBuilder {
    x.obj.Meta = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTestStructBuilder) IndirectionString(value IndirectionString) *AdaptTestStructBuilder {
    x.obj.IndirectionString = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTestStructBuilder) StringData(value string) *AdaptTestStructBuilder {
    x.obj.StringData = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTestStructBuilder) DoubleWrappedBool(value AdaptedBool) *AdaptTestStructBuilder {
    x.obj.DoubleWrappedBool = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTestStructBuilder) DoubleWrappedInteger(value AdaptedInteger) *AdaptTestStructBuilder {
    x.obj.DoubleWrappedInteger = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTestStructBuilder) BinaryData(value []byte) *AdaptTestStructBuilder {
    x.obj.BinaryData = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTestStructBuilder) Emit() *AdaptTestStruct {
    var objCopy AdaptTestStruct = *x.obj
    return &objCopy
}

func (x *AdaptTestStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("AdaptTestStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := x.writeField4(p); err != nil {
        return err
    }

    if err := x.writeField5(p); err != nil {
        return err
    }

    if err := x.writeField6(p); err != nil {
        return err
    }

    if err := x.writeField7(p); err != nil {
        return err
    }

    if err := x.writeField8(p); err != nil {
        return err
    }

    if err := x.writeField9(p); err != nil {
        return err
    }

    if err := x.writeField10(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I64)):  // delay
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.STRING)):  // custom
            if err := x.readField2(p); err != nil {
                return err
            }
        case (id == 3 && wireType == thrift.Type(thrift.I64)):  // timeout
            if err := x.readField3(p); err != nil {
                return err
            }
        case (id == 4 && wireType == thrift.Type(thrift.I64)):  // data
            if err := x.readField4(p); err != nil {
                return err
            }
        case (id == 5 && wireType == thrift.Type(thrift.STRING)):  // meta
            if err := x.readField5(p); err != nil {
                return err
            }
        case (id == 6 && wireType == thrift.Type(thrift.STRING)):  // indirectionString
            if err := x.readField6(p); err != nil {
                return err
            }
        case (id == 7 && wireType == thrift.Type(thrift.STRING)):  // string_data
            if err := x.readField7(p); err != nil {
                return err
            }
        case (id == 8 && wireType == thrift.Type(thrift.BOOL)):  // double_wrapped_bool
            if err := x.readField8(p); err != nil {
                return err
            }
        case (id == 9 && wireType == thrift.Type(thrift.I32)):  // double_wrapped_integer
            if err := x.readField9(p); err != nil {
                return err
            }
        case (id == 10 && wireType == thrift.Type(thrift.STRING)):  // binary_data
            if err := x.readField10(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *AdaptTestStruct) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("AdaptTestStruct({")
    sb.WriteString(fmt.Sprintf("Delay:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("Custom:%s ", x.toString2()))
    sb.WriteString(fmt.Sprintf("Timeout:%s ", x.toString3()))
    sb.WriteString(fmt.Sprintf("Data:%s ", x.toString4()))
    sb.WriteString(fmt.Sprintf("Meta:%s ", x.toString5()))
    sb.WriteString(fmt.Sprintf("IndirectionString:%s ", x.toString6()))
    sb.WriteString(fmt.Sprintf("StringData:%s ", x.toString7()))
    sb.WriteString(fmt.Sprintf("DoubleWrappedBool:%s ", x.toString8()))
    sb.WriteString(fmt.Sprintf("DoubleWrappedInteger:%s ", x.toString9()))
    sb.WriteString(fmt.Sprintf("BinaryData:%s", x.toString10()))
    sb.WriteString("})")

    return sb.String()
}

type AdaptTemplatedTestStruct struct {
    AdaptedBool AdaptedBool `thrift:"adaptedBool,1" json:"adaptedBool" db:"adaptedBool"`
    AdaptedByte AdaptedByte `thrift:"adaptedByte,2" json:"adaptedByte" db:"adaptedByte"`
    AdaptedShort AdaptedShort `thrift:"adaptedShort,3" json:"adaptedShort" db:"adaptedShort"`
    AdaptedInteger AdaptedInteger `thrift:"adaptedInteger,4" json:"adaptedInteger" db:"adaptedInteger"`
    AdaptedLong AdaptedLong `thrift:"adaptedLong,5" json:"adaptedLong" db:"adaptedLong"`
    AdaptedDouble AdaptedDouble `thrift:"adaptedDouble,6" json:"adaptedDouble" db:"adaptedDouble"`
    AdaptedString AdaptedString `thrift:"adaptedString,7" json:"adaptedString" db:"adaptedString"`
    AdaptedList []int64 `thrift:"adaptedList,8" json:"adaptedList" db:"adaptedList"`
    AdaptedSet []int64 `thrift:"adaptedSet,9" json:"adaptedSet" db:"adaptedSet"`
    AdaptedMap map[int64]int64 `thrift:"adaptedMap,10" json:"adaptedMap" db:"adaptedMap"`
    AdaptedBoolDefault AdaptedBool `thrift:"adaptedBoolDefault,11" json:"adaptedBoolDefault" db:"adaptedBoolDefault"`
    AdaptedByteDefault AdaptedByte `thrift:"adaptedByteDefault,12" json:"adaptedByteDefault" db:"adaptedByteDefault"`
    AdaptedShortDefault AdaptedShort `thrift:"adaptedShortDefault,13" json:"adaptedShortDefault" db:"adaptedShortDefault"`
    AdaptedIntegerDefault AdaptedInteger `thrift:"adaptedIntegerDefault,14" json:"adaptedIntegerDefault" db:"adaptedIntegerDefault"`
    AdaptedLongDefault AdaptedLong `thrift:"adaptedLongDefault,15" json:"adaptedLongDefault" db:"adaptedLongDefault"`
    AdaptedDoubleDefault AdaptedDouble `thrift:"adaptedDoubleDefault,16" json:"adaptedDoubleDefault" db:"adaptedDoubleDefault"`
    AdaptedStringDefault AdaptedString `thrift:"adaptedStringDefault,17" json:"adaptedStringDefault" db:"adaptedStringDefault"`
    AdaptedEnum AdaptedEnum `thrift:"adaptedEnum,18" json:"adaptedEnum" db:"adaptedEnum"`
    AdaptedListDefault []int64 `thrift:"adaptedListDefault,19" json:"adaptedListDefault" db:"adaptedListDefault"`
    AdaptedSetDefault []int64 `thrift:"adaptedSetDefault,20" json:"adaptedSetDefault" db:"adaptedSetDefault"`
    AdaptedMapDefault map[int64]int64 `thrift:"adaptedMapDefault,21" json:"adaptedMapDefault" db:"adaptedMapDefault"`
    DoubleTypedefBool DoubleTypedefBool `thrift:"doubleTypedefBool,22" json:"doubleTypedefBool" db:"doubleTypedefBool"`
}
// Compile time interface enforcer
var _ thrift.Struct = &AdaptTemplatedTestStruct{}

func NewAdaptTemplatedTestStruct() *AdaptTemplatedTestStruct {
    return (&AdaptTemplatedTestStruct{}).
        SetAdaptedBoolNonCompat(NewAdaptedBool()).
        SetAdaptedByteNonCompat(NewAdaptedByte()).
        SetAdaptedShortNonCompat(NewAdaptedShort()).
        SetAdaptedIntegerNonCompat(NewAdaptedInteger()).
        SetAdaptedLongNonCompat(NewAdaptedLong()).
        SetAdaptedDoubleNonCompat(NewAdaptedDouble()).
        SetAdaptedStringNonCompat(NewAdaptedString()).
        SetAdaptedListNonCompat(make([]int64, 0)).
        SetAdaptedSetNonCompat(make([]int64, 0)).
        SetAdaptedMapNonCompat(make(map[int64]int64)).
        SetAdaptedBoolDefaultNonCompat(true).
        SetAdaptedByteDefaultNonCompat(1).
        SetAdaptedShortDefaultNonCompat(2).
        SetAdaptedIntegerDefaultNonCompat(3).
        SetAdaptedLongDefaultNonCompat(4).
        SetAdaptedDoubleDefaultNonCompat(5.0).
        SetAdaptedStringDefaultNonCompat("6").
        SetAdaptedEnumNonCompat(
              ThriftAdaptedEnum_One,
          ).
        SetAdaptedListDefaultNonCompat(
              []int64{
    1,
},
          ).
        SetAdaptedSetDefaultNonCompat(
              []int64{
    1,
},
          ).
        SetAdaptedMapDefaultNonCompat(
              map[int64]int64{
    1: 1,
},
          ).
        SetDoubleTypedefBoolNonCompat(NewDoubleTypedefBool())
}

func (x *AdaptTemplatedTestStruct) GetAdaptedBoolNonCompat() AdaptedBool {
    return x.AdaptedBool
}

func (x *AdaptTemplatedTestStruct) GetAdaptedBool() AdaptedBool {
    return x.AdaptedBool
}

func (x *AdaptTemplatedTestStruct) GetAdaptedByteNonCompat() AdaptedByte {
    return x.AdaptedByte
}

func (x *AdaptTemplatedTestStruct) GetAdaptedByte() AdaptedByte {
    return x.AdaptedByte
}

func (x *AdaptTemplatedTestStruct) GetAdaptedShortNonCompat() AdaptedShort {
    return x.AdaptedShort
}

func (x *AdaptTemplatedTestStruct) GetAdaptedShort() AdaptedShort {
    return x.AdaptedShort
}

func (x *AdaptTemplatedTestStruct) GetAdaptedIntegerNonCompat() AdaptedInteger {
    return x.AdaptedInteger
}

func (x *AdaptTemplatedTestStruct) GetAdaptedInteger() AdaptedInteger {
    return x.AdaptedInteger
}

func (x *AdaptTemplatedTestStruct) GetAdaptedLongNonCompat() AdaptedLong {
    return x.AdaptedLong
}

func (x *AdaptTemplatedTestStruct) GetAdaptedLong() AdaptedLong {
    return x.AdaptedLong
}

func (x *AdaptTemplatedTestStruct) GetAdaptedDoubleNonCompat() AdaptedDouble {
    return x.AdaptedDouble
}

func (x *AdaptTemplatedTestStruct) GetAdaptedDouble() AdaptedDouble {
    return x.AdaptedDouble
}

func (x *AdaptTemplatedTestStruct) GetAdaptedStringNonCompat() AdaptedString {
    return x.AdaptedString
}

func (x *AdaptTemplatedTestStruct) GetAdaptedString() AdaptedString {
    return x.AdaptedString
}

func (x *AdaptTemplatedTestStruct) GetAdaptedListNonCompat() []int64 {
    return x.AdaptedList
}

func (x *AdaptTemplatedTestStruct) GetAdaptedList() []int64 {
    if !x.IsSetAdaptedList() {
        return make([]int64, 0)
    }

    return x.AdaptedList
}

func (x *AdaptTemplatedTestStruct) GetAdaptedSetNonCompat() []int64 {
    return x.AdaptedSet
}

func (x *AdaptTemplatedTestStruct) GetAdaptedSet() []int64 {
    if !x.IsSetAdaptedSet() {
        return make([]int64, 0)
    }

    return x.AdaptedSet
}

func (x *AdaptTemplatedTestStruct) GetAdaptedMapNonCompat() map[int64]int64 {
    return x.AdaptedMap
}

func (x *AdaptTemplatedTestStruct) GetAdaptedMap() map[int64]int64 {
    if !x.IsSetAdaptedMap() {
        return make(map[int64]int64)
    }

    return x.AdaptedMap
}

func (x *AdaptTemplatedTestStruct) GetAdaptedBoolDefaultNonCompat() AdaptedBool {
    return x.AdaptedBoolDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedBoolDefault() AdaptedBool {
    return x.AdaptedBoolDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedByteDefaultNonCompat() AdaptedByte {
    return x.AdaptedByteDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedByteDefault() AdaptedByte {
    return x.AdaptedByteDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedShortDefaultNonCompat() AdaptedShort {
    return x.AdaptedShortDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedShortDefault() AdaptedShort {
    return x.AdaptedShortDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedIntegerDefaultNonCompat() AdaptedInteger {
    return x.AdaptedIntegerDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedIntegerDefault() AdaptedInteger {
    return x.AdaptedIntegerDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedLongDefaultNonCompat() AdaptedLong {
    return x.AdaptedLongDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedLongDefault() AdaptedLong {
    return x.AdaptedLongDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedDoubleDefaultNonCompat() AdaptedDouble {
    return x.AdaptedDoubleDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedDoubleDefault() AdaptedDouble {
    return x.AdaptedDoubleDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedStringDefaultNonCompat() AdaptedString {
    return x.AdaptedStringDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedStringDefault() AdaptedString {
    return x.AdaptedStringDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedEnumNonCompat() AdaptedEnum {
    return x.AdaptedEnum
}

func (x *AdaptTemplatedTestStruct) GetAdaptedEnum() AdaptedEnum {
    return x.AdaptedEnum
}

func (x *AdaptTemplatedTestStruct) GetAdaptedListDefaultNonCompat() []int64 {
    return x.AdaptedListDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedListDefault() []int64 {
    if !x.IsSetAdaptedListDefault() {
        return []int64{
    1,
}
    }

    return x.AdaptedListDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedSetDefaultNonCompat() []int64 {
    return x.AdaptedSetDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedSetDefault() []int64 {
    if !x.IsSetAdaptedSetDefault() {
        return []int64{
    1,
}
    }

    return x.AdaptedSetDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedMapDefaultNonCompat() map[int64]int64 {
    return x.AdaptedMapDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedMapDefault() map[int64]int64 {
    if !x.IsSetAdaptedMapDefault() {
        return map[int64]int64{
    1: 1,
}
    }

    return x.AdaptedMapDefault
}

func (x *AdaptTemplatedTestStruct) GetDoubleTypedefBoolNonCompat() DoubleTypedefBool {
    return x.DoubleTypedefBool
}

func (x *AdaptTemplatedTestStruct) GetDoubleTypedefBool() DoubleTypedefBool {
    return x.DoubleTypedefBool
}

func (x *AdaptTemplatedTestStruct) SetAdaptedBoolNonCompat(value AdaptedBool) *AdaptTemplatedTestStruct {
    x.AdaptedBool = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedBool(value AdaptedBool) *AdaptTemplatedTestStruct {
    x.AdaptedBool = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedByteNonCompat(value AdaptedByte) *AdaptTemplatedTestStruct {
    x.AdaptedByte = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedByte(value AdaptedByte) *AdaptTemplatedTestStruct {
    x.AdaptedByte = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedShortNonCompat(value AdaptedShort) *AdaptTemplatedTestStruct {
    x.AdaptedShort = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedShort(value AdaptedShort) *AdaptTemplatedTestStruct {
    x.AdaptedShort = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedIntegerNonCompat(value AdaptedInteger) *AdaptTemplatedTestStruct {
    x.AdaptedInteger = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedInteger(value AdaptedInteger) *AdaptTemplatedTestStruct {
    x.AdaptedInteger = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedLongNonCompat(value AdaptedLong) *AdaptTemplatedTestStruct {
    x.AdaptedLong = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedLong(value AdaptedLong) *AdaptTemplatedTestStruct {
    x.AdaptedLong = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedDoubleNonCompat(value AdaptedDouble) *AdaptTemplatedTestStruct {
    x.AdaptedDouble = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedDouble(value AdaptedDouble) *AdaptTemplatedTestStruct {
    x.AdaptedDouble = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedStringNonCompat(value AdaptedString) *AdaptTemplatedTestStruct {
    x.AdaptedString = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedString(value AdaptedString) *AdaptTemplatedTestStruct {
    x.AdaptedString = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedListNonCompat(value []int64) *AdaptTemplatedTestStruct {
    x.AdaptedList = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedList(value []int64) *AdaptTemplatedTestStruct {
    x.AdaptedList = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedSetNonCompat(value []int64) *AdaptTemplatedTestStruct {
    x.AdaptedSet = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedSet(value []int64) *AdaptTemplatedTestStruct {
    x.AdaptedSet = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedMapNonCompat(value map[int64]int64) *AdaptTemplatedTestStruct {
    x.AdaptedMap = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedMap(value map[int64]int64) *AdaptTemplatedTestStruct {
    x.AdaptedMap = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedBoolDefaultNonCompat(value AdaptedBool) *AdaptTemplatedTestStruct {
    x.AdaptedBoolDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedBoolDefault(value AdaptedBool) *AdaptTemplatedTestStruct {
    x.AdaptedBoolDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedByteDefaultNonCompat(value AdaptedByte) *AdaptTemplatedTestStruct {
    x.AdaptedByteDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedByteDefault(value AdaptedByte) *AdaptTemplatedTestStruct {
    x.AdaptedByteDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedShortDefaultNonCompat(value AdaptedShort) *AdaptTemplatedTestStruct {
    x.AdaptedShortDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedShortDefault(value AdaptedShort) *AdaptTemplatedTestStruct {
    x.AdaptedShortDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedIntegerDefaultNonCompat(value AdaptedInteger) *AdaptTemplatedTestStruct {
    x.AdaptedIntegerDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedIntegerDefault(value AdaptedInteger) *AdaptTemplatedTestStruct {
    x.AdaptedIntegerDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedLongDefaultNonCompat(value AdaptedLong) *AdaptTemplatedTestStruct {
    x.AdaptedLongDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedLongDefault(value AdaptedLong) *AdaptTemplatedTestStruct {
    x.AdaptedLongDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedDoubleDefaultNonCompat(value AdaptedDouble) *AdaptTemplatedTestStruct {
    x.AdaptedDoubleDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedDoubleDefault(value AdaptedDouble) *AdaptTemplatedTestStruct {
    x.AdaptedDoubleDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedStringDefaultNonCompat(value AdaptedString) *AdaptTemplatedTestStruct {
    x.AdaptedStringDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedStringDefault(value AdaptedString) *AdaptTemplatedTestStruct {
    x.AdaptedStringDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedEnumNonCompat(value AdaptedEnum) *AdaptTemplatedTestStruct {
    x.AdaptedEnum = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedEnum(value AdaptedEnum) *AdaptTemplatedTestStruct {
    x.AdaptedEnum = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedListDefaultNonCompat(value []int64) *AdaptTemplatedTestStruct {
    x.AdaptedListDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedListDefault(value []int64) *AdaptTemplatedTestStruct {
    x.AdaptedListDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedSetDefaultNonCompat(value []int64) *AdaptTemplatedTestStruct {
    x.AdaptedSetDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedSetDefault(value []int64) *AdaptTemplatedTestStruct {
    x.AdaptedSetDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedMapDefaultNonCompat(value map[int64]int64) *AdaptTemplatedTestStruct {
    x.AdaptedMapDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedMapDefault(value map[int64]int64) *AdaptTemplatedTestStruct {
    x.AdaptedMapDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetDoubleTypedefBoolNonCompat(value DoubleTypedefBool) *AdaptTemplatedTestStruct {
    x.DoubleTypedefBool = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetDoubleTypedefBool(value DoubleTypedefBool) *AdaptTemplatedTestStruct {
    x.DoubleTypedefBool = value
    return x
}

func (x *AdaptTemplatedTestStruct) IsSetAdaptedList() bool {
    return x != nil && x.AdaptedList != nil
}

func (x *AdaptTemplatedTestStruct) IsSetAdaptedSet() bool {
    return x != nil && x.AdaptedSet != nil
}

func (x *AdaptTemplatedTestStruct) IsSetAdaptedMap() bool {
    return x != nil && x.AdaptedMap != nil
}

func (x *AdaptTemplatedTestStruct) IsSetAdaptedListDefault() bool {
    return x != nil && x.AdaptedListDefault != nil
}

func (x *AdaptTemplatedTestStruct) IsSetAdaptedSetDefault() bool {
    return x != nil && x.AdaptedSetDefault != nil
}

func (x *AdaptTemplatedTestStruct) IsSetAdaptedMapDefault() bool {
    return x != nil && x.AdaptedMapDefault != nil
}

func (x *AdaptTemplatedTestStruct) writeField1(p thrift.Protocol) error {  // AdaptedBool
    if err := p.WriteFieldBegin("adaptedBool", thrift.BOOL, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedBoolNonCompat()
    err := WriteAdaptedBool(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField2(p thrift.Protocol) error {  // AdaptedByte
    if err := p.WriteFieldBegin("adaptedByte", thrift.BYTE, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedByteNonCompat()
    err := WriteAdaptedByte(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField3(p thrift.Protocol) error {  // AdaptedShort
    if err := p.WriteFieldBegin("adaptedShort", thrift.I16, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedShortNonCompat()
    err := WriteAdaptedShort(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField4(p thrift.Protocol) error {  // AdaptedInteger
    if err := p.WriteFieldBegin("adaptedInteger", thrift.I32, 4); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedIntegerNonCompat()
    err := WriteAdaptedInteger(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField5(p thrift.Protocol) error {  // AdaptedLong
    if err := p.WriteFieldBegin("adaptedLong", thrift.I64, 5); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedLongNonCompat()
    err := WriteAdaptedLong(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField6(p thrift.Protocol) error {  // AdaptedDouble
    if err := p.WriteFieldBegin("adaptedDouble", thrift.DOUBLE, 6); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedDoubleNonCompat()
    err := WriteAdaptedDouble(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField7(p thrift.Protocol) error {  // AdaptedString
    if err := p.WriteFieldBegin("adaptedString", thrift.STRING, 7); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedStringNonCompat()
    err := WriteAdaptedString(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField8(p thrift.Protocol) error {  // AdaptedList
    if err := p.WriteFieldBegin("adaptedList", thrift.LIST, 8); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedListNonCompat()
    if err := p.WriteListBegin(thrift.I64, len(item)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
}
for _, v := range item {
    {
        item := v
        if err := p.WriteI64(item); err != nil {
    return err
}
    }
}
if err := p.WriteListEnd(); err != nil {
    return thrift.PrependError("error writing list end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField9(p thrift.Protocol) error {  // AdaptedSet
    if err := p.WriteFieldBegin("adaptedSet", thrift.SET, 9); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedSetNonCompat()
    if err := p.WriteSetBegin(thrift.I64, len(item)); err != nil {
    return thrift.PrependError("error writing set begin: ", err)
}
for _, v := range item {
    {
        item := v
        if err := p.WriteI64(item); err != nil {
    return err
}
    }
}
if err := p.WriteSetEnd(); err != nil {
    return thrift.PrependError("error writing set end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField10(p thrift.Protocol) error {  // AdaptedMap
    if err := p.WriteFieldBegin("adaptedMap", thrift.MAP, 10); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedMapNonCompat()
    if err := p.WriteMapBegin(thrift.I64, thrift.I64, len(item)); err != nil {
    return thrift.PrependError("error writing map begin: ", err)
}
for k, v := range item {
    {
        item := k
        if err := p.WriteI64(item); err != nil {
    return err
}
    }

    {
        item := v
        if err := p.WriteI64(item); err != nil {
    return err
}
    }
}
if err := p.WriteMapEnd(); err != nil {
    return thrift.PrependError("error writing map end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField11(p thrift.Protocol) error {  // AdaptedBoolDefault
    if err := p.WriteFieldBegin("adaptedBoolDefault", thrift.BOOL, 11); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedBoolDefaultNonCompat()
    err := WriteAdaptedBool(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField12(p thrift.Protocol) error {  // AdaptedByteDefault
    if err := p.WriteFieldBegin("adaptedByteDefault", thrift.BYTE, 12); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedByteDefaultNonCompat()
    err := WriteAdaptedByte(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField13(p thrift.Protocol) error {  // AdaptedShortDefault
    if err := p.WriteFieldBegin("adaptedShortDefault", thrift.I16, 13); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedShortDefaultNonCompat()
    err := WriteAdaptedShort(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField14(p thrift.Protocol) error {  // AdaptedIntegerDefault
    if err := p.WriteFieldBegin("adaptedIntegerDefault", thrift.I32, 14); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedIntegerDefaultNonCompat()
    err := WriteAdaptedInteger(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField15(p thrift.Protocol) error {  // AdaptedLongDefault
    if err := p.WriteFieldBegin("adaptedLongDefault", thrift.I64, 15); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedLongDefaultNonCompat()
    err := WriteAdaptedLong(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField16(p thrift.Protocol) error {  // AdaptedDoubleDefault
    if err := p.WriteFieldBegin("adaptedDoubleDefault", thrift.DOUBLE, 16); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedDoubleDefaultNonCompat()
    err := WriteAdaptedDouble(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField17(p thrift.Protocol) error {  // AdaptedStringDefault
    if err := p.WriteFieldBegin("adaptedStringDefault", thrift.STRING, 17); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedStringDefaultNonCompat()
    err := WriteAdaptedString(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField18(p thrift.Protocol) error {  // AdaptedEnum
    if err := p.WriteFieldBegin("adaptedEnum", thrift.I32, 18); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedEnumNonCompat()
    err := WriteAdaptedEnum(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField19(p thrift.Protocol) error {  // AdaptedListDefault
    if err := p.WriteFieldBegin("adaptedListDefault", thrift.LIST, 19); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedListDefaultNonCompat()
    if err := p.WriteListBegin(thrift.I64, len(item)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
}
for _, v := range item {
    {
        item := v
        if err := p.WriteI64(item); err != nil {
    return err
}
    }
}
if err := p.WriteListEnd(); err != nil {
    return thrift.PrependError("error writing list end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField20(p thrift.Protocol) error {  // AdaptedSetDefault
    if err := p.WriteFieldBegin("adaptedSetDefault", thrift.SET, 20); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedSetDefaultNonCompat()
    if err := p.WriteSetBegin(thrift.I64, len(item)); err != nil {
    return thrift.PrependError("error writing set begin: ", err)
}
for _, v := range item {
    {
        item := v
        if err := p.WriteI64(item); err != nil {
    return err
}
    }
}
if err := p.WriteSetEnd(); err != nil {
    return thrift.PrependError("error writing set end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField21(p thrift.Protocol) error {  // AdaptedMapDefault
    if err := p.WriteFieldBegin("adaptedMapDefault", thrift.MAP, 21); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedMapDefaultNonCompat()
    if err := p.WriteMapBegin(thrift.I64, thrift.I64, len(item)); err != nil {
    return thrift.PrependError("error writing map begin: ", err)
}
for k, v := range item {
    {
        item := k
        if err := p.WriteI64(item); err != nil {
    return err
}
    }

    {
        item := v
        if err := p.WriteI64(item); err != nil {
    return err
}
    }
}
if err := p.WriteMapEnd(); err != nil {
    return thrift.PrependError("error writing map end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField22(p thrift.Protocol) error {  // DoubleTypedefBool
    if err := p.WriteFieldBegin("doubleTypedefBool", thrift.BOOL, 22); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDoubleTypedefBoolNonCompat()
    err := WriteDoubleTypedefBool(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) readField1(p thrift.Protocol) error {  // AdaptedBool
    result, err := ReadAdaptedBool(p)
if err != nil {
    return err
}

    x.SetAdaptedBoolNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField2(p thrift.Protocol) error {  // AdaptedByte
    result, err := ReadAdaptedByte(p)
if err != nil {
    return err
}

    x.SetAdaptedByteNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField3(p thrift.Protocol) error {  // AdaptedShort
    result, err := ReadAdaptedShort(p)
if err != nil {
    return err
}

    x.SetAdaptedShortNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField4(p thrift.Protocol) error {  // AdaptedInteger
    result, err := ReadAdaptedInteger(p)
if err != nil {
    return err
}

    x.SetAdaptedIntegerNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField5(p thrift.Protocol) error {  // AdaptedLong
    result, err := ReadAdaptedLong(p)
if err != nil {
    return err
}

    x.SetAdaptedLongNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField6(p thrift.Protocol) error {  // AdaptedDouble
    result, err := ReadAdaptedDouble(p)
if err != nil {
    return err
}

    x.SetAdaptedDoubleNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField7(p thrift.Protocol) error {  // AdaptedString
    result, err := ReadAdaptedString(p)
if err != nil {
    return err
}

    x.SetAdaptedStringNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField8(p thrift.Protocol) error {  // AdaptedList
    _ /* elemType */, size, err := p.ReadListBegin()
if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
}

listResult := make([]int64, 0, size)
for i := 0; i < size; i++ {
    var elem int64
    {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        elem = result
    }
    listResult = append(listResult, elem)
}

if err := p.ReadListEnd(); err != nil {
    return thrift.PrependError("error reading list end: ", err)
}
result := listResult

    x.SetAdaptedListNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField9(p thrift.Protocol) error {  // AdaptedSet
    _ /* elemType */, size, err := p.ReadSetBegin()
if err != nil {
    return thrift.PrependError("error reading set begin: ", err)
}

setResult := make([]int64, 0, size)
for i := 0; i < size; i++ {
    var elem int64
    {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        elem = result
    }
    setResult = append(setResult, elem)
}

if err := p.ReadSetEnd(); err != nil {
    return thrift.PrependError("error reading set end: ", err)
}
result := setResult

    x.SetAdaptedSetNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField10(p thrift.Protocol) error {  // AdaptedMap
    _ /* keyType */, _ /* valueType */, size, err := p.ReadMapBegin()
if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
}

mapResult := make(map[int64]int64, size)
for i := 0; i < size; i++ {
    var key int64
    {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        key = result
    }

    var value int64
    {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        value = result
    }

    mapResult[key] = value
}

if err := p.ReadMapEnd(); err != nil {
    return thrift.PrependError("error reading map end: ", err)
}
result := mapResult

    x.SetAdaptedMapNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField11(p thrift.Protocol) error {  // AdaptedBoolDefault
    result, err := ReadAdaptedBool(p)
if err != nil {
    return err
}

    x.SetAdaptedBoolDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField12(p thrift.Protocol) error {  // AdaptedByteDefault
    result, err := ReadAdaptedByte(p)
if err != nil {
    return err
}

    x.SetAdaptedByteDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField13(p thrift.Protocol) error {  // AdaptedShortDefault
    result, err := ReadAdaptedShort(p)
if err != nil {
    return err
}

    x.SetAdaptedShortDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField14(p thrift.Protocol) error {  // AdaptedIntegerDefault
    result, err := ReadAdaptedInteger(p)
if err != nil {
    return err
}

    x.SetAdaptedIntegerDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField15(p thrift.Protocol) error {  // AdaptedLongDefault
    result, err := ReadAdaptedLong(p)
if err != nil {
    return err
}

    x.SetAdaptedLongDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField16(p thrift.Protocol) error {  // AdaptedDoubleDefault
    result, err := ReadAdaptedDouble(p)
if err != nil {
    return err
}

    x.SetAdaptedDoubleDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField17(p thrift.Protocol) error {  // AdaptedStringDefault
    result, err := ReadAdaptedString(p)
if err != nil {
    return err
}

    x.SetAdaptedStringDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField18(p thrift.Protocol) error {  // AdaptedEnum
    result, err := ReadAdaptedEnum(p)
if err != nil {
    return err
}

    x.SetAdaptedEnumNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField19(p thrift.Protocol) error {  // AdaptedListDefault
    _ /* elemType */, size, err := p.ReadListBegin()
if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
}

listResult := make([]int64, 0, size)
for i := 0; i < size; i++ {
    var elem int64
    {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        elem = result
    }
    listResult = append(listResult, elem)
}

if err := p.ReadListEnd(); err != nil {
    return thrift.PrependError("error reading list end: ", err)
}
result := listResult

    x.SetAdaptedListDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField20(p thrift.Protocol) error {  // AdaptedSetDefault
    _ /* elemType */, size, err := p.ReadSetBegin()
if err != nil {
    return thrift.PrependError("error reading set begin: ", err)
}

setResult := make([]int64, 0, size)
for i := 0; i < size; i++ {
    var elem int64
    {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        elem = result
    }
    setResult = append(setResult, elem)
}

if err := p.ReadSetEnd(); err != nil {
    return thrift.PrependError("error reading set end: ", err)
}
result := setResult

    x.SetAdaptedSetDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField21(p thrift.Protocol) error {  // AdaptedMapDefault
    _ /* keyType */, _ /* valueType */, size, err := p.ReadMapBegin()
if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
}

mapResult := make(map[int64]int64, size)
for i := 0; i < size; i++ {
    var key int64
    {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        key = result
    }

    var value int64
    {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        value = result
    }

    mapResult[key] = value
}

if err := p.ReadMapEnd(); err != nil {
    return thrift.PrependError("error reading map end: ", err)
}
result := mapResult

    x.SetAdaptedMapDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField22(p thrift.Protocol) error {  // DoubleTypedefBool
    result, err := ReadDoubleTypedefBool(p)
if err != nil {
    return err
}

    x.SetDoubleTypedefBoolNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) toString1() string {  // AdaptedBool
    return fmt.Sprintf("%v", x.GetAdaptedBoolNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString2() string {  // AdaptedByte
    return fmt.Sprintf("%v", x.GetAdaptedByteNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString3() string {  // AdaptedShort
    return fmt.Sprintf("%v", x.GetAdaptedShortNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString4() string {  // AdaptedInteger
    return fmt.Sprintf("%v", x.GetAdaptedIntegerNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString5() string {  // AdaptedLong
    return fmt.Sprintf("%v", x.GetAdaptedLongNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString6() string {  // AdaptedDouble
    return fmt.Sprintf("%v", x.GetAdaptedDoubleNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString7() string {  // AdaptedString
    return fmt.Sprintf("%v", x.GetAdaptedStringNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString8() string {  // AdaptedList
    return fmt.Sprintf("%v", x.GetAdaptedListNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString9() string {  // AdaptedSet
    return fmt.Sprintf("%v", x.GetAdaptedSetNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString10() string {  // AdaptedMap
    return fmt.Sprintf("%v", x.GetAdaptedMapNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString11() string {  // AdaptedBoolDefault
    return fmt.Sprintf("%v", x.GetAdaptedBoolDefaultNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString12() string {  // AdaptedByteDefault
    return fmt.Sprintf("%v", x.GetAdaptedByteDefaultNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString13() string {  // AdaptedShortDefault
    return fmt.Sprintf("%v", x.GetAdaptedShortDefaultNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString14() string {  // AdaptedIntegerDefault
    return fmt.Sprintf("%v", x.GetAdaptedIntegerDefaultNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString15() string {  // AdaptedLongDefault
    return fmt.Sprintf("%v", x.GetAdaptedLongDefaultNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString16() string {  // AdaptedDoubleDefault
    return fmt.Sprintf("%v", x.GetAdaptedDoubleDefaultNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString17() string {  // AdaptedStringDefault
    return fmt.Sprintf("%v", x.GetAdaptedStringDefaultNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString18() string {  // AdaptedEnum
    return fmt.Sprintf("%v", x.GetAdaptedEnumNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString19() string {  // AdaptedListDefault
    return fmt.Sprintf("%v", x.GetAdaptedListDefaultNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString20() string {  // AdaptedSetDefault
    return fmt.Sprintf("%v", x.GetAdaptedSetDefaultNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString21() string {  // AdaptedMapDefault
    return fmt.Sprintf("%v", x.GetAdaptedMapDefaultNonCompat())
}

func (x *AdaptTemplatedTestStruct) toString22() string {  // DoubleTypedefBool
    return fmt.Sprintf("%v", x.GetDoubleTypedefBoolNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
type AdaptTemplatedTestStructBuilder struct {
    obj *AdaptTemplatedTestStruct
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewAdaptTemplatedTestStructBuilder() *AdaptTemplatedTestStructBuilder {
    return &AdaptTemplatedTestStructBuilder{
        obj: NewAdaptTemplatedTestStruct(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedBool(value AdaptedBool) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedBool = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedByte(value AdaptedByte) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedByte = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedShort(value AdaptedShort) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedShort = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedInteger(value AdaptedInteger) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedInteger = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedLong(value AdaptedLong) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedLong = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedDouble(value AdaptedDouble) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedDouble = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedString(value AdaptedString) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedString = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedList(value []int64) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedList = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedSet(value []int64) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedSet = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedMap(value map[int64]int64) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedMap = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedBoolDefault(value AdaptedBool) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedBoolDefault = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedByteDefault(value AdaptedByte) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedByteDefault = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedShortDefault(value AdaptedShort) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedShortDefault = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedIntegerDefault(value AdaptedInteger) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedIntegerDefault = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedLongDefault(value AdaptedLong) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedLongDefault = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedDoubleDefault(value AdaptedDouble) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedDoubleDefault = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedStringDefault(value AdaptedString) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedStringDefault = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedEnum(value AdaptedEnum) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedEnum = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedListDefault(value []int64) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedListDefault = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedSetDefault(value []int64) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedSetDefault = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) AdaptedMapDefault(value map[int64]int64) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedMapDefault = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) DoubleTypedefBool(value DoubleTypedefBool) *AdaptTemplatedTestStructBuilder {
    x.obj.DoubleTypedefBool = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedTestStructBuilder) Emit() *AdaptTemplatedTestStruct {
    var objCopy AdaptTemplatedTestStruct = *x.obj
    return &objCopy
}

func (x *AdaptTemplatedTestStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("AdaptTemplatedTestStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := x.writeField4(p); err != nil {
        return err
    }

    if err := x.writeField5(p); err != nil {
        return err
    }

    if err := x.writeField6(p); err != nil {
        return err
    }

    if err := x.writeField7(p); err != nil {
        return err
    }

    if err := x.writeField8(p); err != nil {
        return err
    }

    if err := x.writeField9(p); err != nil {
        return err
    }

    if err := x.writeField10(p); err != nil {
        return err
    }

    if err := x.writeField11(p); err != nil {
        return err
    }

    if err := x.writeField12(p); err != nil {
        return err
    }

    if err := x.writeField13(p); err != nil {
        return err
    }

    if err := x.writeField14(p); err != nil {
        return err
    }

    if err := x.writeField15(p); err != nil {
        return err
    }

    if err := x.writeField16(p); err != nil {
        return err
    }

    if err := x.writeField17(p); err != nil {
        return err
    }

    if err := x.writeField18(p); err != nil {
        return err
    }

    if err := x.writeField19(p); err != nil {
        return err
    }

    if err := x.writeField20(p); err != nil {
        return err
    }

    if err := x.writeField21(p); err != nil {
        return err
    }

    if err := x.writeField22(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.BOOL)):  // adaptedBool
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.BYTE)):  // adaptedByte
            if err := x.readField2(p); err != nil {
                return err
            }
        case (id == 3 && wireType == thrift.Type(thrift.I16)):  // adaptedShort
            if err := x.readField3(p); err != nil {
                return err
            }
        case (id == 4 && wireType == thrift.Type(thrift.I32)):  // adaptedInteger
            if err := x.readField4(p); err != nil {
                return err
            }
        case (id == 5 && wireType == thrift.Type(thrift.I64)):  // adaptedLong
            if err := x.readField5(p); err != nil {
                return err
            }
        case (id == 6 && wireType == thrift.Type(thrift.DOUBLE)):  // adaptedDouble
            if err := x.readField6(p); err != nil {
                return err
            }
        case (id == 7 && wireType == thrift.Type(thrift.STRING)):  // adaptedString
            if err := x.readField7(p); err != nil {
                return err
            }
        case (id == 8 && wireType == thrift.Type(thrift.LIST)):  // adaptedList
            if err := x.readField8(p); err != nil {
                return err
            }
        case (id == 9 && wireType == thrift.Type(thrift.SET)):  // adaptedSet
            if err := x.readField9(p); err != nil {
                return err
            }
        case (id == 10 && wireType == thrift.Type(thrift.MAP)):  // adaptedMap
            if err := x.readField10(p); err != nil {
                return err
            }
        case (id == 11 && wireType == thrift.Type(thrift.BOOL)):  // adaptedBoolDefault
            if err := x.readField11(p); err != nil {
                return err
            }
        case (id == 12 && wireType == thrift.Type(thrift.BYTE)):  // adaptedByteDefault
            if err := x.readField12(p); err != nil {
                return err
            }
        case (id == 13 && wireType == thrift.Type(thrift.I16)):  // adaptedShortDefault
            if err := x.readField13(p); err != nil {
                return err
            }
        case (id == 14 && wireType == thrift.Type(thrift.I32)):  // adaptedIntegerDefault
            if err := x.readField14(p); err != nil {
                return err
            }
        case (id == 15 && wireType == thrift.Type(thrift.I64)):  // adaptedLongDefault
            if err := x.readField15(p); err != nil {
                return err
            }
        case (id == 16 && wireType == thrift.Type(thrift.DOUBLE)):  // adaptedDoubleDefault
            if err := x.readField16(p); err != nil {
                return err
            }
        case (id == 17 && wireType == thrift.Type(thrift.STRING)):  // adaptedStringDefault
            if err := x.readField17(p); err != nil {
                return err
            }
        case (id == 18 && wireType == thrift.Type(thrift.I32)):  // adaptedEnum
            if err := x.readField18(p); err != nil {
                return err
            }
        case (id == 19 && wireType == thrift.Type(thrift.LIST)):  // adaptedListDefault
            if err := x.readField19(p); err != nil {
                return err
            }
        case (id == 20 && wireType == thrift.Type(thrift.SET)):  // adaptedSetDefault
            if err := x.readField20(p); err != nil {
                return err
            }
        case (id == 21 && wireType == thrift.Type(thrift.MAP)):  // adaptedMapDefault
            if err := x.readField21(p); err != nil {
                return err
            }
        case (id == 22 && wireType == thrift.Type(thrift.BOOL)):  // doubleTypedefBool
            if err := x.readField22(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *AdaptTemplatedTestStruct) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("AdaptTemplatedTestStruct({")
    sb.WriteString(fmt.Sprintf("AdaptedBool:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("AdaptedByte:%s ", x.toString2()))
    sb.WriteString(fmt.Sprintf("AdaptedShort:%s ", x.toString3()))
    sb.WriteString(fmt.Sprintf("AdaptedInteger:%s ", x.toString4()))
    sb.WriteString(fmt.Sprintf("AdaptedLong:%s ", x.toString5()))
    sb.WriteString(fmt.Sprintf("AdaptedDouble:%s ", x.toString6()))
    sb.WriteString(fmt.Sprintf("AdaptedString:%s ", x.toString7()))
    sb.WriteString(fmt.Sprintf("AdaptedList:%s ", x.toString8()))
    sb.WriteString(fmt.Sprintf("AdaptedSet:%s ", x.toString9()))
    sb.WriteString(fmt.Sprintf("AdaptedMap:%s ", x.toString10()))
    sb.WriteString(fmt.Sprintf("AdaptedBoolDefault:%s ", x.toString11()))
    sb.WriteString(fmt.Sprintf("AdaptedByteDefault:%s ", x.toString12()))
    sb.WriteString(fmt.Sprintf("AdaptedShortDefault:%s ", x.toString13()))
    sb.WriteString(fmt.Sprintf("AdaptedIntegerDefault:%s ", x.toString14()))
    sb.WriteString(fmt.Sprintf("AdaptedLongDefault:%s ", x.toString15()))
    sb.WriteString(fmt.Sprintf("AdaptedDoubleDefault:%s ", x.toString16()))
    sb.WriteString(fmt.Sprintf("AdaptedStringDefault:%s ", x.toString17()))
    sb.WriteString(fmt.Sprintf("AdaptedEnum:%s ", x.toString18()))
    sb.WriteString(fmt.Sprintf("AdaptedListDefault:%s ", x.toString19()))
    sb.WriteString(fmt.Sprintf("AdaptedSetDefault:%s ", x.toString20()))
    sb.WriteString(fmt.Sprintf("AdaptedMapDefault:%s ", x.toString21()))
    sb.WriteString(fmt.Sprintf("DoubleTypedefBool:%s", x.toString22()))
    sb.WriteString("})")

    return sb.String()
}

type AdaptTemplatedNestedTestStruct struct {
    AdaptedStruct *AdaptTemplatedTestStruct `thrift:"adaptedStruct,1" json:"adaptedStruct" db:"adaptedStruct"`
}
// Compile time interface enforcer
var _ thrift.Struct = &AdaptTemplatedNestedTestStruct{}

func NewAdaptTemplatedNestedTestStruct() *AdaptTemplatedNestedTestStruct {
    return (&AdaptTemplatedNestedTestStruct{}).
        SetAdaptedStructNonCompat(*NewAdaptTemplatedTestStruct())
}

func (x *AdaptTemplatedNestedTestStruct) GetAdaptedStructNonCompat() *AdaptTemplatedTestStruct {
    return x.AdaptedStruct
}

func (x *AdaptTemplatedNestedTestStruct) GetAdaptedStruct() *AdaptTemplatedTestStruct {
    if !x.IsSetAdaptedStruct() {
        return nil
    }

    return x.AdaptedStruct
}

func (x *AdaptTemplatedNestedTestStruct) SetAdaptedStructNonCompat(value AdaptTemplatedTestStruct) *AdaptTemplatedNestedTestStruct {
    x.AdaptedStruct = &value
    return x
}

func (x *AdaptTemplatedNestedTestStruct) SetAdaptedStruct(value *AdaptTemplatedTestStruct) *AdaptTemplatedNestedTestStruct {
    x.AdaptedStruct = value
    return x
}

func (x *AdaptTemplatedNestedTestStruct) IsSetAdaptedStruct() bool {
    return x != nil && x.AdaptedStruct != nil
}

func (x *AdaptTemplatedNestedTestStruct) writeField1(p thrift.Protocol) error {  // AdaptedStruct
    if !x.IsSetAdaptedStruct() {
        return nil
    }

    if err := p.WriteFieldBegin("adaptedStruct", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedStructNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedNestedTestStruct) readField1(p thrift.Protocol) error {  // AdaptedStruct
    result := *NewAdaptTemplatedTestStruct()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetAdaptedStructNonCompat(result)
    return nil
}

func (x *AdaptTemplatedNestedTestStruct) toString1() string {  // AdaptedStruct
    return fmt.Sprintf("%v", x.GetAdaptedStructNonCompat())
}

// Deprecated: Use NewAdaptTemplatedNestedTestStruct().GetAdaptedStruct() instead.
func (x *AdaptTemplatedNestedTestStruct) DefaultGetAdaptedStruct() *AdaptTemplatedTestStruct {
    if !x.IsSetAdaptedStruct() {
        return NewAdaptTemplatedTestStruct()
    }
    return x.AdaptedStruct
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedNestedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
type AdaptTemplatedNestedTestStructBuilder struct {
    obj *AdaptTemplatedNestedTestStruct
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedNestedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewAdaptTemplatedNestedTestStructBuilder() *AdaptTemplatedNestedTestStructBuilder {
    return &AdaptTemplatedNestedTestStructBuilder{
        obj: NewAdaptTemplatedNestedTestStruct(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedNestedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedNestedTestStructBuilder) AdaptedStruct(value *AdaptTemplatedTestStruct) *AdaptTemplatedNestedTestStructBuilder {
    x.obj.AdaptedStruct = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTemplatedNestedTestStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTemplatedNestedTestStructBuilder) Emit() *AdaptTemplatedNestedTestStruct {
    var objCopy AdaptTemplatedNestedTestStruct = *x.obj
    return &objCopy
}

func (x *AdaptTemplatedNestedTestStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("AdaptTemplatedNestedTestStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedNestedTestStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRUCT)):  // adaptedStruct
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *AdaptTemplatedNestedTestStruct) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("AdaptTemplatedNestedTestStruct({")
    sb.WriteString(fmt.Sprintf("AdaptedStruct:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}

type AdaptTestUnion struct {
    Delay *DurationMs `thrift:"delay,1" json:"delay,omitempty" db:"delay"`
    Custom CustomProtocolType `thrift:"custom,2" json:"custom,omitempty" db:"custom"`
}
// Compile time interface enforcer
var _ thrift.Struct = &AdaptTestUnion{}

func NewAdaptTestUnion() *AdaptTestUnion {
    return (&AdaptTestUnion{})
}

func (x *AdaptTestUnion) GetDelayNonCompat() *DurationMs {
    return x.Delay
}

func (x *AdaptTestUnion) GetDelay() DurationMs {
    if !x.IsSetDelay() {
        return NewDurationMs()
    }

    return *x.Delay
}

func (x *AdaptTestUnion) GetCustomNonCompat() CustomProtocolType {
    return x.Custom
}

func (x *AdaptTestUnion) GetCustom() CustomProtocolType {
    if !x.IsSetCustom() {
        return NewCustomProtocolType()
    }

    return x.Custom
}

func (x *AdaptTestUnion) SetDelayNonCompat(value DurationMs) *AdaptTestUnion {
    x.Delay = &value
    return x
}

func (x *AdaptTestUnion) SetDelay(value *DurationMs) *AdaptTestUnion {
    x.Delay = value
    return x
}

func (x *AdaptTestUnion) SetCustomNonCompat(value CustomProtocolType) *AdaptTestUnion {
    x.Custom = value
    return x
}

func (x *AdaptTestUnion) SetCustom(value CustomProtocolType) *AdaptTestUnion {
    x.Custom = value
    return x
}

func (x *AdaptTestUnion) IsSetDelay() bool {
    return x != nil && x.Delay != nil
}

func (x *AdaptTestUnion) IsSetCustom() bool {
    return x != nil && x.Custom != nil
}

func (x *AdaptTestUnion) writeField1(p thrift.Protocol) error {  // Delay
    if !x.IsSetDelay() {
        return nil
    }

    if err := p.WriteFieldBegin("delay", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetDelayNonCompat()
    err := WriteDurationMs(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestUnion) writeField2(p thrift.Protocol) error {  // Custom
    if !x.IsSetCustom() {
        return nil
    }

    if err := p.WriteFieldBegin("custom", thrift.STRING, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetCustomNonCompat()
    err := WriteCustomProtocolType(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestUnion) readField1(p thrift.Protocol) error {  // Delay
    result, err := ReadDurationMs(p)
if err != nil {
    return err
}

    x.SetDelayNonCompat(result)
    return nil
}

func (x *AdaptTestUnion) readField2(p thrift.Protocol) error {  // Custom
    result, err := ReadCustomProtocolType(p)
if err != nil {
    return err
}

    x.SetCustomNonCompat(result)
    return nil
}

func (x *AdaptTestUnion) toString1() string {  // Delay
    if x.IsSetDelay() {
        return fmt.Sprintf("%v", *x.GetDelayNonCompat())
    }
    return fmt.Sprintf("%v", x.GetDelayNonCompat())
}

func (x *AdaptTestUnion) toString2() string {  // Custom
    return fmt.Sprintf("%v", x.GetCustomNonCompat())
}


func (x *AdaptTestUnion) countSetFields() int {
    count := int(0)
    if (x.IsSetDelay()) {
        count++
    }
    if (x.IsSetCustom()) {
        count++
    }
    return count
}

func (x *AdaptTestUnion) CountSetFieldsAdaptTestUnion() int {
    return x.countSetFields()
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTestUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
type AdaptTestUnionBuilder struct {
    obj *AdaptTestUnion
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTestUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewAdaptTestUnionBuilder() *AdaptTestUnionBuilder {
    return &AdaptTestUnionBuilder{
        obj: NewAdaptTestUnion(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTestUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTestUnionBuilder) Delay(value *DurationMs) *AdaptTestUnionBuilder {
    x.obj.Delay = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTestUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTestUnionBuilder) Custom(value CustomProtocolType) *AdaptTestUnionBuilder {
    x.obj.Custom = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptTestUnion().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptTestUnionBuilder) Emit() *AdaptTestUnion {
    var objCopy AdaptTestUnion = *x.obj
    return &objCopy
}

func (x *AdaptTestUnion) Write(p thrift.Protocol) error {
    if countSet := x.countSetFields(); countSet > 1 {
        return fmt.Errorf("%T write union: no more than one field must be set (%d set).", x, countSet)
    }
    if err := p.WriteStructBegin("AdaptTestUnion"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestUnion) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I64)):  // delay
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.STRING)):  // custom
            if err := x.readField2(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *AdaptTestUnion) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("AdaptTestUnion({")
    sb.WriteString(fmt.Sprintf("Delay:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("Custom:%s", x.toString2()))
    sb.WriteString("})")

    return sb.String()
}

type AdaptedStruct struct {
    Data int64 `thrift:"data,1" json:"data" db:"data"`
}
// Compile time interface enforcer
var _ thrift.Struct = &AdaptedStruct{}

func NewAdaptedStruct() *AdaptedStruct {
    return (&AdaptedStruct{}).
        SetDataNonCompat(0)
}

func (x *AdaptedStruct) GetDataNonCompat() int64 {
    return x.Data
}

func (x *AdaptedStruct) GetData() int64 {
    return x.Data
}

func (x *AdaptedStruct) SetDataNonCompat(value int64) *AdaptedStruct {
    x.Data = value
    return x
}

func (x *AdaptedStruct) SetData(value int64) *AdaptedStruct {
    x.Data = value
    return x
}

func (x *AdaptedStruct) writeField1(p thrift.Protocol) error {  // Data
    if err := p.WriteFieldBegin("data", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDataNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptedStruct) readField1(p thrift.Protocol) error {  // Data
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetDataNonCompat(result)
    return nil
}

func (x *AdaptedStruct) toString1() string {  // Data
    return fmt.Sprintf("%v", x.GetDataNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
type AdaptedStructBuilder struct {
    obj *AdaptedStruct
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewAdaptedStructBuilder() *AdaptedStructBuilder {
    return &AdaptedStructBuilder{
        obj: NewAdaptedStruct(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptedStructBuilder) Data(value int64) *AdaptedStructBuilder {
    x.obj.Data = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAdaptedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AdaptedStructBuilder) Emit() *AdaptedStruct {
    var objCopy AdaptedStruct = *x.obj
    return &objCopy
}

func (x *AdaptedStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("AdaptedStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *AdaptedStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I64)):  // data
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *AdaptedStruct) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("AdaptedStruct({")
    sb.WriteString(fmt.Sprintf("Data:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}

type DirectlyAdaptedStruct struct {
    Data int64 `thrift:"data,1" json:"data" db:"data"`
}
// Compile time interface enforcer
var _ thrift.Struct = &DirectlyAdaptedStruct{}

func NewDirectlyAdaptedStruct() *DirectlyAdaptedStruct {
    return (&DirectlyAdaptedStruct{}).
        SetDataNonCompat(0)
}

func (x *DirectlyAdaptedStruct) GetDataNonCompat() int64 {
    return x.Data
}

func (x *DirectlyAdaptedStruct) GetData() int64 {
    return x.Data
}

func (x *DirectlyAdaptedStruct) SetDataNonCompat(value int64) *DirectlyAdaptedStruct {
    x.Data = value
    return x
}

func (x *DirectlyAdaptedStruct) SetData(value int64) *DirectlyAdaptedStruct {
    x.Data = value
    return x
}

func (x *DirectlyAdaptedStruct) writeField1(p thrift.Protocol) error {  // Data
    if err := p.WriteFieldBegin("data", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDataNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *DirectlyAdaptedStruct) readField1(p thrift.Protocol) error {  // Data
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetDataNonCompat(result)
    return nil
}

func (x *DirectlyAdaptedStruct) toString1() string {  // Data
    return fmt.Sprintf("%v", x.GetDataNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewDirectlyAdaptedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
type DirectlyAdaptedStructBuilder struct {
    obj *DirectlyAdaptedStruct
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewDirectlyAdaptedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewDirectlyAdaptedStructBuilder() *DirectlyAdaptedStructBuilder {
    return &DirectlyAdaptedStructBuilder{
        obj: NewDirectlyAdaptedStruct(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewDirectlyAdaptedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *DirectlyAdaptedStructBuilder) Data(value int64) *DirectlyAdaptedStructBuilder {
    x.obj.Data = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewDirectlyAdaptedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *DirectlyAdaptedStructBuilder) Emit() *DirectlyAdaptedStruct {
    var objCopy DirectlyAdaptedStruct = *x.obj
    return &objCopy
}

func (x *DirectlyAdaptedStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("DirectlyAdaptedStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *DirectlyAdaptedStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I64)):  // data
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *DirectlyAdaptedStruct) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("DirectlyAdaptedStruct({")
    sb.WriteString(fmt.Sprintf("Data:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}

type StructFieldAdaptedStruct struct {
    AdaptedStruct *AdaptedStruct `thrift:"adaptedStruct,1" json:"adaptedStruct" db:"adaptedStruct"`
    AdaptedTypedef *AdaptedTypedef `thrift:"adaptedTypedef,2" json:"adaptedTypedef" db:"adaptedTypedef"`
    DirectlyAdapted *DirectlyAdaptedStruct `thrift:"directlyAdapted,3" json:"directlyAdapted" db:"directlyAdapted"`
    TypedefOfAdapted *TypedefOfDirect `thrift:"typedefOfAdapted,4" json:"typedefOfAdapted" db:"typedefOfAdapted"`
}
// Compile time interface enforcer
var _ thrift.Struct = &StructFieldAdaptedStruct{}

func NewStructFieldAdaptedStruct() *StructFieldAdaptedStruct {
    return (&StructFieldAdaptedStruct{}).
        SetAdaptedStructNonCompat(*NewAdaptedStruct()).
        SetAdaptedTypedefNonCompat(*NewAdaptedTypedef()).
        SetDirectlyAdaptedNonCompat(*NewDirectlyAdaptedStruct()).
        SetTypedefOfAdaptedNonCompat(*NewTypedefOfDirect())
}

func (x *StructFieldAdaptedStruct) GetAdaptedStructNonCompat() *AdaptedStruct {
    return x.AdaptedStruct
}

func (x *StructFieldAdaptedStruct) GetAdaptedStruct() *AdaptedStruct {
    if !x.IsSetAdaptedStruct() {
        return nil
    }

    return x.AdaptedStruct
}

func (x *StructFieldAdaptedStruct) GetAdaptedTypedefNonCompat() *AdaptedTypedef {
    return x.AdaptedTypedef
}

func (x *StructFieldAdaptedStruct) GetAdaptedTypedef() *AdaptedTypedef {
    if !x.IsSetAdaptedTypedef() {
        return nil
    }

    return x.AdaptedTypedef
}

func (x *StructFieldAdaptedStruct) GetDirectlyAdaptedNonCompat() *DirectlyAdaptedStruct {
    return x.DirectlyAdapted
}

func (x *StructFieldAdaptedStruct) GetDirectlyAdapted() *DirectlyAdaptedStruct {
    if !x.IsSetDirectlyAdapted() {
        return nil
    }

    return x.DirectlyAdapted
}

func (x *StructFieldAdaptedStruct) GetTypedefOfAdaptedNonCompat() *TypedefOfDirect {
    return x.TypedefOfAdapted
}

func (x *StructFieldAdaptedStruct) GetTypedefOfAdapted() *TypedefOfDirect {
    if !x.IsSetTypedefOfAdapted() {
        return nil
    }

    return x.TypedefOfAdapted
}

func (x *StructFieldAdaptedStruct) SetAdaptedStructNonCompat(value AdaptedStruct) *StructFieldAdaptedStruct {
    x.AdaptedStruct = &value
    return x
}

func (x *StructFieldAdaptedStruct) SetAdaptedStruct(value *AdaptedStruct) *StructFieldAdaptedStruct {
    x.AdaptedStruct = value
    return x
}

func (x *StructFieldAdaptedStruct) SetAdaptedTypedefNonCompat(value AdaptedTypedef) *StructFieldAdaptedStruct {
    x.AdaptedTypedef = &value
    return x
}

func (x *StructFieldAdaptedStruct) SetAdaptedTypedef(value *AdaptedTypedef) *StructFieldAdaptedStruct {
    x.AdaptedTypedef = value
    return x
}

func (x *StructFieldAdaptedStruct) SetDirectlyAdaptedNonCompat(value DirectlyAdaptedStruct) *StructFieldAdaptedStruct {
    x.DirectlyAdapted = &value
    return x
}

func (x *StructFieldAdaptedStruct) SetDirectlyAdapted(value *DirectlyAdaptedStruct) *StructFieldAdaptedStruct {
    x.DirectlyAdapted = value
    return x
}

func (x *StructFieldAdaptedStruct) SetTypedefOfAdaptedNonCompat(value TypedefOfDirect) *StructFieldAdaptedStruct {
    x.TypedefOfAdapted = &value
    return x
}

func (x *StructFieldAdaptedStruct) SetTypedefOfAdapted(value *TypedefOfDirect) *StructFieldAdaptedStruct {
    x.TypedefOfAdapted = value
    return x
}

func (x *StructFieldAdaptedStruct) IsSetAdaptedStruct() bool {
    return x != nil && x.AdaptedStruct != nil
}

func (x *StructFieldAdaptedStruct) IsSetAdaptedTypedef() bool {
    return x != nil && x.AdaptedTypedef != nil
}

func (x *StructFieldAdaptedStruct) IsSetDirectlyAdapted() bool {
    return x != nil && x.DirectlyAdapted != nil
}

func (x *StructFieldAdaptedStruct) IsSetTypedefOfAdapted() bool {
    return x != nil && x.TypedefOfAdapted != nil
}

func (x *StructFieldAdaptedStruct) writeField1(p thrift.Protocol) error {  // AdaptedStruct
    if !x.IsSetAdaptedStruct() {
        return nil
    }

    if err := p.WriteFieldBegin("adaptedStruct", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedStructNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *StructFieldAdaptedStruct) writeField2(p thrift.Protocol) error {  // AdaptedTypedef
    if !x.IsSetAdaptedTypedef() {
        return nil
    }

    if err := p.WriteFieldBegin("adaptedTypedef", thrift.STRUCT, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedTypedefNonCompat()
    err := WriteAdaptedTypedef(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *StructFieldAdaptedStruct) writeField3(p thrift.Protocol) error {  // DirectlyAdapted
    if !x.IsSetDirectlyAdapted() {
        return nil
    }

    if err := p.WriteFieldBegin("directlyAdapted", thrift.STRUCT, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDirectlyAdaptedNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *StructFieldAdaptedStruct) writeField4(p thrift.Protocol) error {  // TypedefOfAdapted
    if !x.IsSetTypedefOfAdapted() {
        return nil
    }

    if err := p.WriteFieldBegin("typedefOfAdapted", thrift.STRUCT, 4); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetTypedefOfAdaptedNonCompat()
    err := WriteTypedefOfDirect(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *StructFieldAdaptedStruct) readField1(p thrift.Protocol) error {  // AdaptedStruct
    result := *NewAdaptedStruct()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetAdaptedStructNonCompat(result)
    return nil
}

func (x *StructFieldAdaptedStruct) readField2(p thrift.Protocol) error {  // AdaptedTypedef
    result, err := ReadAdaptedTypedef(p)
if err != nil {
    return err
}

    x.SetAdaptedTypedefNonCompat(result)
    return nil
}

func (x *StructFieldAdaptedStruct) readField3(p thrift.Protocol) error {  // DirectlyAdapted
    result := *NewDirectlyAdaptedStruct()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetDirectlyAdaptedNonCompat(result)
    return nil
}

func (x *StructFieldAdaptedStruct) readField4(p thrift.Protocol) error {  // TypedefOfAdapted
    result, err := ReadTypedefOfDirect(p)
if err != nil {
    return err
}

    x.SetTypedefOfAdaptedNonCompat(result)
    return nil
}

func (x *StructFieldAdaptedStruct) toString1() string {  // AdaptedStruct
    return fmt.Sprintf("%v", x.GetAdaptedStructNonCompat())
}

func (x *StructFieldAdaptedStruct) toString2() string {  // AdaptedTypedef
    return fmt.Sprintf("%v", x.GetAdaptedTypedefNonCompat())
}

func (x *StructFieldAdaptedStruct) toString3() string {  // DirectlyAdapted
    return fmt.Sprintf("%v", x.GetDirectlyAdaptedNonCompat())
}

func (x *StructFieldAdaptedStruct) toString4() string {  // TypedefOfAdapted
    return fmt.Sprintf("%v", x.GetTypedefOfAdaptedNonCompat())
}

// Deprecated: Use NewStructFieldAdaptedStruct().GetAdaptedStruct() instead.
func (x *StructFieldAdaptedStruct) DefaultGetAdaptedStruct() *AdaptedStruct {
    if !x.IsSetAdaptedStruct() {
        return NewAdaptedStruct()
    }
    return x.AdaptedStruct
}

// Deprecated: Use NewStructFieldAdaptedStruct().GetAdaptedTypedef() instead.
func (x *StructFieldAdaptedStruct) DefaultGetAdaptedTypedef() *AdaptedTypedef {
    if !x.IsSetAdaptedTypedef() {
        return NewAdaptedTypedef()
    }
    return x.AdaptedTypedef
}

// Deprecated: Use NewStructFieldAdaptedStruct().GetDirectlyAdapted() instead.
func (x *StructFieldAdaptedStruct) DefaultGetDirectlyAdapted() *DirectlyAdaptedStruct {
    if !x.IsSetDirectlyAdapted() {
        return NewDirectlyAdaptedStruct()
    }
    return x.DirectlyAdapted
}

// Deprecated: Use NewStructFieldAdaptedStruct().GetTypedefOfAdapted() instead.
func (x *StructFieldAdaptedStruct) DefaultGetTypedefOfAdapted() *TypedefOfDirect {
    if !x.IsSetTypedefOfAdapted() {
        return NewTypedefOfDirect()
    }
    return x.TypedefOfAdapted
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewStructFieldAdaptedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
type StructFieldAdaptedStructBuilder struct {
    obj *StructFieldAdaptedStruct
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewStructFieldAdaptedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewStructFieldAdaptedStructBuilder() *StructFieldAdaptedStructBuilder {
    return &StructFieldAdaptedStructBuilder{
        obj: NewStructFieldAdaptedStruct(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewStructFieldAdaptedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *StructFieldAdaptedStructBuilder) AdaptedStruct(value *AdaptedStruct) *StructFieldAdaptedStructBuilder {
    x.obj.AdaptedStruct = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewStructFieldAdaptedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *StructFieldAdaptedStructBuilder) AdaptedTypedef(value *AdaptedTypedef) *StructFieldAdaptedStructBuilder {
    x.obj.AdaptedTypedef = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewStructFieldAdaptedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *StructFieldAdaptedStructBuilder) DirectlyAdapted(value *DirectlyAdaptedStruct) *StructFieldAdaptedStructBuilder {
    x.obj.DirectlyAdapted = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewStructFieldAdaptedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *StructFieldAdaptedStructBuilder) TypedefOfAdapted(value *TypedefOfDirect) *StructFieldAdaptedStructBuilder {
    x.obj.TypedefOfAdapted = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewStructFieldAdaptedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *StructFieldAdaptedStructBuilder) Emit() *StructFieldAdaptedStruct {
    var objCopy StructFieldAdaptedStruct = *x.obj
    return &objCopy
}

func (x *StructFieldAdaptedStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("StructFieldAdaptedStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := x.writeField4(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *StructFieldAdaptedStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRUCT)):  // adaptedStruct
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.STRUCT)):  // adaptedTypedef
            if err := x.readField2(p); err != nil {
                return err
            }
        case (id == 3 && wireType == thrift.Type(thrift.STRUCT)):  // directlyAdapted
            if err := x.readField3(p); err != nil {
                return err
            }
        case (id == 4 && wireType == thrift.Type(thrift.STRUCT)):  // typedefOfAdapted
            if err := x.readField4(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *StructFieldAdaptedStruct) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("StructFieldAdaptedStruct({")
    sb.WriteString(fmt.Sprintf("AdaptedStruct:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("AdaptedTypedef:%s ", x.toString2()))
    sb.WriteString(fmt.Sprintf("DirectlyAdapted:%s ", x.toString3()))
    sb.WriteString(fmt.Sprintf("TypedefOfAdapted:%s", x.toString4()))
    sb.WriteString("})")

    return sb.String()
}

type CircularAdaptee struct {
    Field *CircularStruct `thrift:"field,1" json:"field" db:"field"`
}
// Compile time interface enforcer
var _ thrift.Struct = &CircularAdaptee{}

func NewCircularAdaptee() *CircularAdaptee {
    return (&CircularAdaptee{}).
        SetFieldNonCompat(*NewCircularStruct())
}

func (x *CircularAdaptee) GetFieldNonCompat() *CircularStruct {
    return x.Field
}

func (x *CircularAdaptee) GetField() *CircularStruct {
    if !x.IsSetField() {
        return nil
    }

    return x.Field
}

func (x *CircularAdaptee) SetFieldNonCompat(value CircularStruct) *CircularAdaptee {
    x.Field = &value
    return x
}

func (x *CircularAdaptee) SetField(value *CircularStruct) *CircularAdaptee {
    x.Field = value
    return x
}

func (x *CircularAdaptee) IsSetField() bool {
    return x != nil && x.Field != nil
}

func (x *CircularAdaptee) writeField1(p thrift.Protocol) error {  // Field
    if !x.IsSetField() {
        return nil
    }

    if err := p.WriteFieldBegin("field", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetFieldNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *CircularAdaptee) readField1(p thrift.Protocol) error {  // Field
    result := *NewCircularStruct()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetFieldNonCompat(result)
    return nil
}

func (x *CircularAdaptee) toString1() string {  // Field
    return fmt.Sprintf("%v", x.GetFieldNonCompat())
}

// Deprecated: Use NewCircularAdaptee().GetField() instead.
func (x *CircularAdaptee) DefaultGetField() *CircularStruct {
    if !x.IsSetField() {
        return NewCircularStruct()
    }
    return x.Field
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewCircularAdaptee().Set<FieldNameFoo>().Set<FieldNameBar>()
type CircularAdapteeBuilder struct {
    obj *CircularAdaptee
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewCircularAdaptee().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewCircularAdapteeBuilder() *CircularAdapteeBuilder {
    return &CircularAdapteeBuilder{
        obj: NewCircularAdaptee(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewCircularAdaptee().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *CircularAdapteeBuilder) Field(value *CircularStruct) *CircularAdapteeBuilder {
    x.obj.Field = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewCircularAdaptee().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *CircularAdapteeBuilder) Emit() *CircularAdaptee {
    var objCopy CircularAdaptee = *x.obj
    return &objCopy
}

func (x *CircularAdaptee) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("CircularAdaptee"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *CircularAdaptee) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRUCT)):  // field
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *CircularAdaptee) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("CircularAdaptee({")
    sb.WriteString(fmt.Sprintf("Field:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}

type CircularStruct struct {
    Field *AdaptedCircularAdaptee `thrift:"field,1,optional" json:"field,omitempty" db:"field"`
}
// Compile time interface enforcer
var _ thrift.Struct = &CircularStruct{}

func NewCircularStruct() *CircularStruct {
    return (&CircularStruct{})
}

func (x *CircularStruct) GetFieldNonCompat() *AdaptedCircularAdaptee {
    return x.Field
}

func (x *CircularStruct) GetField() *AdaptedCircularAdaptee {
    if !x.IsSetField() {
        return nil
    }

    return x.Field
}

func (x *CircularStruct) SetFieldNonCompat(value AdaptedCircularAdaptee) *CircularStruct {
    x.Field = &value
    return x
}

func (x *CircularStruct) SetField(value *AdaptedCircularAdaptee) *CircularStruct {
    x.Field = value
    return x
}

func (x *CircularStruct) IsSetField() bool {
    return x != nil && x.Field != nil
}

func (x *CircularStruct) writeField1(p thrift.Protocol) error {  // Field
    if !x.IsSetField() {
        return nil
    }

    if err := p.WriteFieldBegin("field", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetFieldNonCompat()
    err := WriteAdaptedCircularAdaptee(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *CircularStruct) readField1(p thrift.Protocol) error {  // Field
    result, err := ReadAdaptedCircularAdaptee(p)
if err != nil {
    return err
}

    x.SetFieldNonCompat(result)
    return nil
}

func (x *CircularStruct) toString1() string {  // Field
    return fmt.Sprintf("%v", x.GetFieldNonCompat())
}

// Deprecated: Use NewCircularStruct().GetField() instead.
func (x *CircularStruct) DefaultGetField() *AdaptedCircularAdaptee {
    if !x.IsSetField() {
        return NewAdaptedCircularAdaptee()
    }
    return x.Field
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewCircularStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
type CircularStructBuilder struct {
    obj *CircularStruct
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewCircularStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewCircularStructBuilder() *CircularStructBuilder {
    return &CircularStructBuilder{
        obj: NewCircularStruct(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewCircularStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *CircularStructBuilder) Field(value *AdaptedCircularAdaptee) *CircularStructBuilder {
    x.obj.Field = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewCircularStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *CircularStructBuilder) Emit() *CircularStruct {
    var objCopy CircularStruct = *x.obj
    return &objCopy
}

func (x *CircularStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("CircularStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *CircularStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRUCT)):  // field
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *CircularStruct) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("CircularStruct({")
    sb.WriteString(fmt.Sprintf("Field:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}

type ReorderedStruct struct {
    ReorderedDependentAdapted *DeclaredAfterStruct `thrift:"reordered_dependent_adapted,1" json:"reordered_dependent_adapted" db:"reordered_dependent_adapted"`
}
// Compile time interface enforcer
var _ thrift.Struct = &ReorderedStruct{}

func NewReorderedStruct() *ReorderedStruct {
    return (&ReorderedStruct{}).
        SetReorderedDependentAdaptedNonCompat(*NewDeclaredAfterStruct())
}

func (x *ReorderedStruct) GetReorderedDependentAdaptedNonCompat() *DeclaredAfterStruct {
    return x.ReorderedDependentAdapted
}

func (x *ReorderedStruct) GetReorderedDependentAdapted() *DeclaredAfterStruct {
    if !x.IsSetReorderedDependentAdapted() {
        return nil
    }

    return x.ReorderedDependentAdapted
}

func (x *ReorderedStruct) SetReorderedDependentAdaptedNonCompat(value DeclaredAfterStruct) *ReorderedStruct {
    x.ReorderedDependentAdapted = &value
    return x
}

func (x *ReorderedStruct) SetReorderedDependentAdapted(value *DeclaredAfterStruct) *ReorderedStruct {
    x.ReorderedDependentAdapted = value
    return x
}

func (x *ReorderedStruct) IsSetReorderedDependentAdapted() bool {
    return x != nil && x.ReorderedDependentAdapted != nil
}

func (x *ReorderedStruct) writeField1(p thrift.Protocol) error {  // ReorderedDependentAdapted
    if !x.IsSetReorderedDependentAdapted() {
        return nil
    }

    if err := p.WriteFieldBegin("reordered_dependent_adapted", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetReorderedDependentAdaptedNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *ReorderedStruct) readField1(p thrift.Protocol) error {  // ReorderedDependentAdapted
    result := *NewDeclaredAfterStruct()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetReorderedDependentAdaptedNonCompat(result)
    return nil
}

func (x *ReorderedStruct) toString1() string {  // ReorderedDependentAdapted
    return fmt.Sprintf("%v", x.GetReorderedDependentAdaptedNonCompat())
}

// Deprecated: Use NewReorderedStruct().GetReorderedDependentAdapted() instead.
func (x *ReorderedStruct) DefaultGetReorderedDependentAdapted() *DeclaredAfterStruct {
    if !x.IsSetReorderedDependentAdapted() {
        return NewDeclaredAfterStruct()
    }
    return x.ReorderedDependentAdapted
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewReorderedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
type ReorderedStructBuilder struct {
    obj *ReorderedStruct
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewReorderedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewReorderedStructBuilder() *ReorderedStructBuilder {
    return &ReorderedStructBuilder{
        obj: NewReorderedStruct(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewReorderedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ReorderedStructBuilder) ReorderedDependentAdapted(value *DeclaredAfterStruct) *ReorderedStructBuilder {
    x.obj.ReorderedDependentAdapted = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewReorderedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ReorderedStructBuilder) Emit() *ReorderedStruct {
    var objCopy ReorderedStruct = *x.obj
    return &objCopy
}

func (x *ReorderedStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("ReorderedStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *ReorderedStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRUCT)):  // reordered_dependent_adapted
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *ReorderedStruct) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("ReorderedStruct({")
    sb.WriteString(fmt.Sprintf("ReorderedDependentAdapted:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}

type DeclaredAfterStruct struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &DeclaredAfterStruct{}

func NewDeclaredAfterStruct() *DeclaredAfterStruct {
    return (&DeclaredAfterStruct{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewDeclaredAfterStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
type DeclaredAfterStructBuilder struct {
    obj *DeclaredAfterStruct
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewDeclaredAfterStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewDeclaredAfterStructBuilder() *DeclaredAfterStructBuilder {
    return &DeclaredAfterStructBuilder{
        obj: NewDeclaredAfterStruct(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewDeclaredAfterStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *DeclaredAfterStructBuilder) Emit() *DeclaredAfterStruct {
    var objCopy DeclaredAfterStruct = *x.obj
    return &objCopy
}

func (x *DeclaredAfterStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("DeclaredAfterStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *DeclaredAfterStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *DeclaredAfterStruct) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("DeclaredAfterStruct({")
    sb.WriteString("})")

    return sb.String()
}

type RenamedStruct struct {
    Data int64 `thrift:"data,1" json:"data" db:"data"`
}
// Compile time interface enforcer
var _ thrift.Struct = &RenamedStruct{}

func NewRenamedStruct() *RenamedStruct {
    return (&RenamedStruct{}).
        SetDataNonCompat(0)
}

func (x *RenamedStruct) GetDataNonCompat() int64 {
    return x.Data
}

func (x *RenamedStruct) GetData() int64 {
    return x.Data
}

func (x *RenamedStruct) SetDataNonCompat(value int64) *RenamedStruct {
    x.Data = value
    return x
}

func (x *RenamedStruct) SetData(value int64) *RenamedStruct {
    x.Data = value
    return x
}

func (x *RenamedStruct) writeField1(p thrift.Protocol) error {  // Data
    if err := p.WriteFieldBegin("data", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDataNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *RenamedStruct) readField1(p thrift.Protocol) error {  // Data
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetDataNonCompat(result)
    return nil
}

func (x *RenamedStruct) toString1() string {  // Data
    return fmt.Sprintf("%v", x.GetDataNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewRenamedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
type RenamedStructBuilder struct {
    obj *RenamedStruct
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewRenamedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewRenamedStructBuilder() *RenamedStructBuilder {
    return &RenamedStructBuilder{
        obj: NewRenamedStruct(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewRenamedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *RenamedStructBuilder) Data(value int64) *RenamedStructBuilder {
    x.obj.Data = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewRenamedStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *RenamedStructBuilder) Emit() *RenamedStruct {
    var objCopy RenamedStruct = *x.obj
    return &objCopy
}

func (x *RenamedStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("RenamedStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *RenamedStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I64)):  // data
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *RenamedStruct) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("RenamedStruct({")
    sb.WriteString(fmt.Sprintf("Data:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}

type SameNamespaceStruct struct {
    Data int64 `thrift:"data,1" json:"data" db:"data"`
}
// Compile time interface enforcer
var _ thrift.Struct = &SameNamespaceStruct{}

func NewSameNamespaceStruct() *SameNamespaceStruct {
    return (&SameNamespaceStruct{}).
        SetDataNonCompat(0)
}

func (x *SameNamespaceStruct) GetDataNonCompat() int64 {
    return x.Data
}

func (x *SameNamespaceStruct) GetData() int64 {
    return x.Data
}

func (x *SameNamespaceStruct) SetDataNonCompat(value int64) *SameNamespaceStruct {
    x.Data = value
    return x
}

func (x *SameNamespaceStruct) SetData(value int64) *SameNamespaceStruct {
    x.Data = value
    return x
}

func (x *SameNamespaceStruct) writeField1(p thrift.Protocol) error {  // Data
    if err := p.WriteFieldBegin("data", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDataNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *SameNamespaceStruct) readField1(p thrift.Protocol) error {  // Data
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetDataNonCompat(result)
    return nil
}

func (x *SameNamespaceStruct) toString1() string {  // Data
    return fmt.Sprintf("%v", x.GetDataNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewSameNamespaceStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
type SameNamespaceStructBuilder struct {
    obj *SameNamespaceStruct
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewSameNamespaceStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewSameNamespaceStructBuilder() *SameNamespaceStructBuilder {
    return &SameNamespaceStructBuilder{
        obj: NewSameNamespaceStruct(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewSameNamespaceStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *SameNamespaceStructBuilder) Data(value int64) *SameNamespaceStructBuilder {
    x.obj.Data = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewSameNamespaceStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *SameNamespaceStructBuilder) Emit() *SameNamespaceStruct {
    var objCopy SameNamespaceStruct = *x.obj
    return &objCopy
}

func (x *SameNamespaceStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("SameNamespaceStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *SameNamespaceStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I64)):  // data
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *SameNamespaceStruct) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("SameNamespaceStruct({")
    sb.WriteString(fmt.Sprintf("Data:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}

type HeapAllocated struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &HeapAllocated{}

func NewHeapAllocated() *HeapAllocated {
    return (&HeapAllocated{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewHeapAllocated().Set<FieldNameFoo>().Set<FieldNameBar>()
type HeapAllocatedBuilder struct {
    obj *HeapAllocated
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewHeapAllocated().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewHeapAllocatedBuilder() *HeapAllocatedBuilder {
    return &HeapAllocatedBuilder{
        obj: NewHeapAllocated(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewHeapAllocated().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *HeapAllocatedBuilder) Emit() *HeapAllocated {
    var objCopy HeapAllocated = *x.obj
    return &objCopy
}

func (x *HeapAllocated) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("HeapAllocated"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *HeapAllocated) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *HeapAllocated) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("HeapAllocated({")
    sb.WriteString("})")

    return sb.String()
}

type MoveOnly struct {
    Ptr *HeapAllocated `thrift:"ptr,1" json:"ptr" db:"ptr"`
}
// Compile time interface enforcer
var _ thrift.Struct = &MoveOnly{}

func NewMoveOnly() *MoveOnly {
    return (&MoveOnly{}).
        SetPtrNonCompat(*NewHeapAllocated())
}

func (x *MoveOnly) GetPtrNonCompat() *HeapAllocated {
    return x.Ptr
}

func (x *MoveOnly) GetPtr() *HeapAllocated {
    if !x.IsSetPtr() {
        return nil
    }

    return x.Ptr
}

func (x *MoveOnly) SetPtrNonCompat(value HeapAllocated) *MoveOnly {
    x.Ptr = &value
    return x
}

func (x *MoveOnly) SetPtr(value *HeapAllocated) *MoveOnly {
    x.Ptr = value
    return x
}

func (x *MoveOnly) IsSetPtr() bool {
    return x != nil && x.Ptr != nil
}

func (x *MoveOnly) writeField1(p thrift.Protocol) error {  // Ptr
    if !x.IsSetPtr() {
        return nil
    }

    if err := p.WriteFieldBegin("ptr", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetPtrNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *MoveOnly) readField1(p thrift.Protocol) error {  // Ptr
    result := *NewHeapAllocated()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetPtrNonCompat(result)
    return nil
}

func (x *MoveOnly) toString1() string {  // Ptr
    return fmt.Sprintf("%v", x.GetPtrNonCompat())
}

// Deprecated: Use NewMoveOnly().GetPtr() instead.
func (x *MoveOnly) DefaultGetPtr() *HeapAllocated {
    if !x.IsSetPtr() {
        return NewHeapAllocated()
    }
    return x.Ptr
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewMoveOnly().Set<FieldNameFoo>().Set<FieldNameBar>()
type MoveOnlyBuilder struct {
    obj *MoveOnly
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewMoveOnly().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewMoveOnlyBuilder() *MoveOnlyBuilder {
    return &MoveOnlyBuilder{
        obj: NewMoveOnly(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewMoveOnly().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *MoveOnlyBuilder) Ptr(value *HeapAllocated) *MoveOnlyBuilder {
    x.obj.Ptr = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewMoveOnly().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *MoveOnlyBuilder) Emit() *MoveOnly {
    var objCopy MoveOnly = *x.obj
    return &objCopy
}

func (x *MoveOnly) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("MoveOnly"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *MoveOnly) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRUCT)):  // ptr
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *MoveOnly) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("MoveOnly({")
    sb.WriteString(fmt.Sprintf("Ptr:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}

type AlsoMoveOnly struct {
    Ptr int64 `thrift:"ptr,1" json:"ptr" db:"ptr"`
}
// Compile time interface enforcer
var _ thrift.Struct = &AlsoMoveOnly{}

func NewAlsoMoveOnly() *AlsoMoveOnly {
    return (&AlsoMoveOnly{}).
        SetPtrNonCompat(0)
}

func (x *AlsoMoveOnly) GetPtrNonCompat() int64 {
    return x.Ptr
}

func (x *AlsoMoveOnly) GetPtr() int64 {
    return x.Ptr
}

func (x *AlsoMoveOnly) SetPtrNonCompat(value int64) *AlsoMoveOnly {
    x.Ptr = value
    return x
}

func (x *AlsoMoveOnly) SetPtr(value int64) *AlsoMoveOnly {
    x.Ptr = value
    return x
}

func (x *AlsoMoveOnly) writeField1(p thrift.Protocol) error {  // Ptr
    if err := p.WriteFieldBegin("ptr", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetPtrNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AlsoMoveOnly) readField1(p thrift.Protocol) error {  // Ptr
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetPtrNonCompat(result)
    return nil
}

func (x *AlsoMoveOnly) toString1() string {  // Ptr
    return fmt.Sprintf("%v", x.GetPtrNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAlsoMoveOnly().Set<FieldNameFoo>().Set<FieldNameBar>()
type AlsoMoveOnlyBuilder struct {
    obj *AlsoMoveOnly
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAlsoMoveOnly().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewAlsoMoveOnlyBuilder() *AlsoMoveOnlyBuilder {
    return &AlsoMoveOnlyBuilder{
        obj: NewAlsoMoveOnly(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAlsoMoveOnly().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AlsoMoveOnlyBuilder) Ptr(value int64) *AlsoMoveOnlyBuilder {
    x.obj.Ptr = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewAlsoMoveOnly().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *AlsoMoveOnlyBuilder) Emit() *AlsoMoveOnly {
    var objCopy AlsoMoveOnly = *x.obj
    return &objCopy
}

func (x *AlsoMoveOnly) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("AlsoMoveOnly"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *AlsoMoveOnly) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I64)):  // ptr
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *AlsoMoveOnly) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("AlsoMoveOnly({")
    sb.WriteString(fmt.Sprintf("Ptr:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}

type ApplyAdapter struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &ApplyAdapter{}

func NewApplyAdapter() *ApplyAdapter {
    return (&ApplyAdapter{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewApplyAdapter().Set<FieldNameFoo>().Set<FieldNameBar>()
type ApplyAdapterBuilder struct {
    obj *ApplyAdapter
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewApplyAdapter().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewApplyAdapterBuilder() *ApplyAdapterBuilder {
    return &ApplyAdapterBuilder{
        obj: NewApplyAdapter(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewApplyAdapter().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *ApplyAdapterBuilder) Emit() *ApplyAdapter {
    var objCopy ApplyAdapter = *x.obj
    return &objCopy
}

func (x *ApplyAdapter) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("ApplyAdapter"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *ApplyAdapter) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *ApplyAdapter) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("ApplyAdapter({")
    sb.WriteString("})")

    return sb.String()
}

type TransitiveAdapted struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &TransitiveAdapted{}

func NewTransitiveAdapted() *TransitiveAdapted {
    return (&TransitiveAdapted{})
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTransitiveAdapted().Set<FieldNameFoo>().Set<FieldNameBar>()
type TransitiveAdaptedBuilder struct {
    obj *TransitiveAdapted
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTransitiveAdapted().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewTransitiveAdaptedBuilder() *TransitiveAdaptedBuilder {
    return &TransitiveAdaptedBuilder{
        obj: NewTransitiveAdapted(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewTransitiveAdapted().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *TransitiveAdaptedBuilder) Emit() *TransitiveAdapted {
    var objCopy TransitiveAdapted = *x.obj
    return &objCopy
}

func (x *TransitiveAdapted) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("TransitiveAdapted"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *TransitiveAdapted) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *TransitiveAdapted) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("TransitiveAdapted({")
    sb.WriteString("})")

    return sb.String()
}

type CountingStruct struct {
    RegularInt *int64 `thrift:"regularInt,1,optional" json:"regularInt,omitempty" db:"regularInt"`
    CountingInt *CountingInt `thrift:"countingInt,2,optional" json:"countingInt,omitempty" db:"countingInt"`
    RegularString *string `thrift:"regularString,3,optional" json:"regularString,omitempty" db:"regularString"`
}
// Compile time interface enforcer
var _ thrift.Struct = &CountingStruct{}

func NewCountingStruct() *CountingStruct {
    return (&CountingStruct{})
}

func (x *CountingStruct) GetRegularIntNonCompat() *int64 {
    return x.RegularInt
}

func (x *CountingStruct) GetRegularInt() int64 {
    if !x.IsSetRegularInt() {
        return 0
    }

    return *x.RegularInt
}

func (x *CountingStruct) GetCountingIntNonCompat() *CountingInt {
    return x.CountingInt
}

func (x *CountingStruct) GetCountingInt() CountingInt {
    if !x.IsSetCountingInt() {
        return NewCountingInt()
    }

    return *x.CountingInt
}

func (x *CountingStruct) GetRegularStringNonCompat() *string {
    return x.RegularString
}

func (x *CountingStruct) GetRegularString() string {
    if !x.IsSetRegularString() {
        return ""
    }

    return *x.RegularString
}

func (x *CountingStruct) SetRegularIntNonCompat(value int64) *CountingStruct {
    x.RegularInt = &value
    return x
}

func (x *CountingStruct) SetRegularInt(value *int64) *CountingStruct {
    x.RegularInt = value
    return x
}

func (x *CountingStruct) SetCountingIntNonCompat(value CountingInt) *CountingStruct {
    x.CountingInt = &value
    return x
}

func (x *CountingStruct) SetCountingInt(value *CountingInt) *CountingStruct {
    x.CountingInt = value
    return x
}

func (x *CountingStruct) SetRegularStringNonCompat(value string) *CountingStruct {
    x.RegularString = &value
    return x
}

func (x *CountingStruct) SetRegularString(value *string) *CountingStruct {
    x.RegularString = value
    return x
}

func (x *CountingStruct) IsSetRegularInt() bool {
    return x != nil && x.RegularInt != nil
}

func (x *CountingStruct) IsSetCountingInt() bool {
    return x != nil && x.CountingInt != nil
}

func (x *CountingStruct) IsSetRegularString() bool {
    return x != nil && x.RegularString != nil
}

func (x *CountingStruct) writeField1(p thrift.Protocol) error {  // RegularInt
    if !x.IsSetRegularInt() {
        return nil
    }

    if err := p.WriteFieldBegin("regularInt", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetRegularIntNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *CountingStruct) writeField2(p thrift.Protocol) error {  // CountingInt
    if !x.IsSetCountingInt() {
        return nil
    }

    if err := p.WriteFieldBegin("countingInt", thrift.I64, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetCountingIntNonCompat()
    err := WriteCountingInt(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *CountingStruct) writeField3(p thrift.Protocol) error {  // RegularString
    if !x.IsSetRegularString() {
        return nil
    }

    if err := p.WriteFieldBegin("regularString", thrift.STRING, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetRegularStringNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *CountingStruct) readField1(p thrift.Protocol) error {  // RegularInt
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetRegularIntNonCompat(result)
    return nil
}

func (x *CountingStruct) readField2(p thrift.Protocol) error {  // CountingInt
    result, err := ReadCountingInt(p)
if err != nil {
    return err
}

    x.SetCountingIntNonCompat(result)
    return nil
}

func (x *CountingStruct) readField3(p thrift.Protocol) error {  // RegularString
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetRegularStringNonCompat(result)
    return nil
}

func (x *CountingStruct) toString1() string {  // RegularInt
    if x.IsSetRegularInt() {
        return fmt.Sprintf("%v", *x.GetRegularIntNonCompat())
    }
    return fmt.Sprintf("%v", x.GetRegularIntNonCompat())
}

func (x *CountingStruct) toString2() string {  // CountingInt
    if x.IsSetCountingInt() {
        return fmt.Sprintf("%v", *x.GetCountingIntNonCompat())
    }
    return fmt.Sprintf("%v", x.GetCountingIntNonCompat())
}

func (x *CountingStruct) toString3() string {  // RegularString
    if x.IsSetRegularString() {
        return fmt.Sprintf("%v", *x.GetRegularStringNonCompat())
    }
    return fmt.Sprintf("%v", x.GetRegularStringNonCompat())
}





// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewCountingStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
type CountingStructBuilder struct {
    obj *CountingStruct
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewCountingStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewCountingStructBuilder() *CountingStructBuilder {
    return &CountingStructBuilder{
        obj: NewCountingStruct(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewCountingStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *CountingStructBuilder) RegularInt(value *int64) *CountingStructBuilder {
    x.obj.RegularInt = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewCountingStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *CountingStructBuilder) CountingInt(value *CountingInt) *CountingStructBuilder {
    x.obj.CountingInt = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewCountingStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *CountingStructBuilder) RegularString(value *string) *CountingStructBuilder {
    x.obj.RegularString = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewCountingStruct().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *CountingStructBuilder) Emit() *CountingStruct {
    var objCopy CountingStruct = *x.obj
    return &objCopy
}

func (x *CountingStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("CountingStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *CountingStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.I64)):  // regularInt
            if err := x.readField1(p); err != nil {
                return err
            }
        case (id == 2 && wireType == thrift.Type(thrift.I64)):  // countingInt
            if err := x.readField2(p); err != nil {
                return err
            }
        case (id == 3 && wireType == thrift.Type(thrift.STRING)):  // regularString
            if err := x.readField3(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *CountingStruct) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("CountingStruct({")
    sb.WriteString(fmt.Sprintf("RegularInt:%s ", x.toString1()))
    sb.WriteString(fmt.Sprintf("CountingInt:%s ", x.toString2()))
    sb.WriteString(fmt.Sprintf("RegularString:%s", x.toString3()))
    sb.WriteString("})")

    return sb.String()
}

type Person struct {
    Name string `thrift:"name,1" json:"name" db:"name"`
}
// Compile time interface enforcer
var _ thrift.Struct = &Person{}

func NewPerson() *Person {
    return (&Person{}).
        SetNameNonCompat("")
}

func (x *Person) GetNameNonCompat() string {
    return x.Name
}

func (x *Person) GetName() string {
    return x.Name
}

func (x *Person) SetNameNonCompat(value string) *Person {
    x.Name = value
    return x
}

func (x *Person) SetName(value string) *Person {
    x.Name = value
    return x
}

func (x *Person) writeField1(p thrift.Protocol) error {  // Name
    if err := p.WriteFieldBegin("name", thrift.STRING, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetNameNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Person) readField1(p thrift.Protocol) error {  // Name
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetNameNonCompat(result)
    return nil
}

func (x *Person) toString1() string {  // Name
    return fmt.Sprintf("%v", x.GetNameNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewPerson().Set<FieldNameFoo>().Set<FieldNameBar>()
type PersonBuilder struct {
    obj *Person
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewPerson().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewPersonBuilder() *PersonBuilder {
    return &PersonBuilder{
        obj: NewPerson(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewPerson().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *PersonBuilder) Name(value string) *PersonBuilder {
    x.obj.Name = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewPerson().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *PersonBuilder) Emit() *Person {
    var objCopy Person = *x.obj
    return &objCopy
}

func (x *Person) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("Person"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *Person) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRING)):  // name
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *Person) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("Person({")
    sb.WriteString(fmt.Sprintf("Name:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}

type Person2 struct {
    Name string `thrift:"name,1" json:"name" db:"name"`
}
// Compile time interface enforcer
var _ thrift.Struct = &Person2{}

func NewPerson2() *Person2 {
    return (&Person2{}).
        SetNameNonCompat("")
}

func (x *Person2) GetNameNonCompat() string {
    return x.Name
}

func (x *Person2) GetName() string {
    return x.Name
}

func (x *Person2) SetNameNonCompat(value string) *Person2 {
    x.Name = value
    return x
}

func (x *Person2) SetName(value string) *Person2 {
    x.Name = value
    return x
}

func (x *Person2) writeField1(p thrift.Protocol) error {  // Name
    if err := p.WriteFieldBegin("name", thrift.STRING, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetNameNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Person2) readField1(p thrift.Protocol) error {  // Name
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetNameNonCompat(result)
    return nil
}

func (x *Person2) toString1() string {  // Name
    return fmt.Sprintf("%v", x.GetNameNonCompat())
}


// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewPerson2().Set<FieldNameFoo>().Set<FieldNameBar>()
type Person2Builder struct {
    obj *Person2
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewPerson2().Set<FieldNameFoo>().Set<FieldNameBar>()
func NewPerson2Builder() *Person2Builder {
    return &Person2Builder{
        obj: NewPerson2(),
    }
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewPerson2().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *Person2Builder) Name(value string) *Person2Builder {
    x.obj.Name = value
    return x
}

// Deprecated: Use "New" constructor and setters to build your structs.
// e.g NewPerson2().Set<FieldNameFoo>().Set<FieldNameBar>()
func (x *Person2Builder) Emit() *Person2 {
    var objCopy Person2 = *x.obj
    return &objCopy
}

func (x *Person2) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("Person2"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *Person2) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, wireType, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if wireType == thrift.STOP {
            break;
        }

        switch {
        case (id == 1 && wireType == thrift.Type(thrift.STRING)):  // name
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(wireType); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

func (x *Person2) String() string {
    if x == nil {
        return "<nil>"
    }

    var sb strings.Builder

    sb.WriteString("Person2({")
    sb.WriteString(fmt.Sprintf("Name:%s", x.toString1()))
    sb.WriteString("})")

    return sb.String()
}

// RegisterTypes registers types found in this file that have a thrift_uri with the passed in registry.
func RegisterTypes(registry interface {
  RegisterType(name string, initializer func() any)
}) {
    registry.RegisterType("facebook.com/thrift/test/MyAnnotation", func() any { return NewMyAnnotation() })
    registry.RegisterType("facebook.com/thrift/compiler/test/fixtures/adapter/src/module/Foo", func() any { return NewFoo() })
    registry.RegisterType("facebook.com/thrift/test/Baz", func() any { return NewBaz() })
    registry.RegisterType("facebook.com/thrift/test/Bar", func() any { return NewBar() })
    registry.RegisterType("facebook.com/thrift/test/DirectlyAdapted", func() any { return NewDirectlyAdapted() })
    registry.RegisterType("facebook.com/thrift/test/IndependentDirectlyAdapted", func() any { return NewIndependentDirectlyAdapted() })
    registry.RegisterType("facebook.com/thrift/test/StructWithFieldAdapter", func() any { return NewStructWithFieldAdapter() })
    registry.RegisterType("facebook.com/thrift/test/TerseAdaptedFields", func() any { return NewTerseAdaptedFields() })
    registry.RegisterType("facebook.com/thrift/test/B", func() any { return NewB() })
    registry.RegisterType("facebook.com/thrift/test/A", func() any { return NewA() })
    registry.RegisterType("facebook.com/thrift/test/Config", func() any { return NewConfig() })
    registry.RegisterType("facebook.com/thrift/test/MyStruct", func() any { return NewMyStruct() })
    registry.RegisterType("facebook.com/thrift/test/AdaptTestStruct", func() any { return NewAdaptTestStruct() })
    registry.RegisterType("facebook.com/thrift/test/AdaptTemplatedTestStruct", func() any { return NewAdaptTemplatedTestStruct() })
    registry.RegisterType("facebook.com/thrift/test/AdaptTemplatedNestedTestStruct", func() any { return NewAdaptTemplatedNestedTestStruct() })
    registry.RegisterType("facebook.com/thrift/test/AdaptTestUnion", func() any { return NewAdaptTestUnion() })
    registry.RegisterType("facebook.com/thrift/test/AdaptedStruct", func() any { return NewAdaptedStruct() })
    registry.RegisterType("facebook.com/thrift/test/DirectlyAdaptedStruct", func() any { return NewDirectlyAdaptedStruct() })
    registry.RegisterType("facebook.com/thrift/test/StructFieldAdaptedStruct", func() any { return NewStructFieldAdaptedStruct() })
    registry.RegisterType("facebook.com/thrift/test/CircularAdaptee", func() any { return NewCircularAdaptee() })
    registry.RegisterType("facebook.com/thrift/test/CircularStruct", func() any { return NewCircularStruct() })
    registry.RegisterType("facebook.com/thrift/test/ReorderedStruct", func() any { return NewReorderedStruct() })
    registry.RegisterType("facebook.com/thrift/test/DeclaredAfterStruct", func() any { return NewDeclaredAfterStruct() })
    registry.RegisterType("facebook.com/thrift/test/RenamedStruct", func() any { return NewRenamedStruct() })
    registry.RegisterType("facebook.com/thrift/test/SameNamespaceStruct", func() any { return NewSameNamespaceStruct() })
    registry.RegisterType("facebook.com/thrift/test/HeapAllocated", func() any { return NewHeapAllocated() })
    registry.RegisterType("facebook.com/thrift/test/MoveOnly", func() any { return NewMoveOnly() })
    registry.RegisterType("facebook.com/thrift/test/AlsoMoveOnly", func() any { return NewAlsoMoveOnly() })
    registry.RegisterType("facebook.com/thrift/test/ApplyAdapter", func() any { return NewApplyAdapter() })
    registry.RegisterType("facebook.com/thrift/test/TransitiveAdapted", func() any { return NewTransitiveAdapted() })
    registry.RegisterType("facebook.com/thrift/test/CountingStruct", func() any { return NewCountingStruct() })
    registry.RegisterType("facebook.com/thrift/test/Person", func() any { return NewPerson() })
    registry.RegisterType("facebook.com/thrift/test/Person2", func() any { return NewPerson2() })

    registry.RegisterType("facebook.com/thrift/test/Color", func() any { return Color(0) })
    registry.RegisterType("facebook.com/thrift/test/ThriftAdaptedEnum", func() any { return ThriftAdaptedEnum(0) })
}
