// @generated by Thrift for [[[ program path ]]]
// This file is probably not the place you want to edit!

package module // [[[ program thrift source path ]]]

import (
    "fmt"

    cpp "thrift/annotation/cpp"
    python "thrift/annotation/python"
    thrift0 "thrift/annotation/thrift"
    scope "thrift/annotation/scope"
    hack "thrift/annotation/hack"
    rust "thrift/annotation/rust"
    thrift "github.com/facebook/fbthrift/thrift/lib/go/thrift"
)

var _ = cpp.GoUnusedProtection__
var _ = python.GoUnusedProtection__
var _ = thrift0.GoUnusedProtection__
var _ = scope.GoUnusedProtection__
var _ = hack.GoUnusedProtection__
var _ = rust.GoUnusedProtection__

// (needed to ensure safety because of naive import list construction)
var _ = fmt.Printf
var _ = thrift.ZERO


type SetWithAdapter = []string

func NewSetWithAdapter() SetWithAdapter {
  return make([]string, 0)
}

func WriteSetWithAdapter(item SetWithAdapter, p thrift.Protocol) error {
  if err := p.WriteSetBegin(thrift.STRING, len(item)); err != nil {
    return thrift.PrependError("error writing set begin: ", err)
}
for _, v := range item {
    {
        item := v
        if err := p.WriteString(item); err != nil {
    return err
}
    }
}
if err := p.WriteSetEnd(); err != nil {
    return thrift.PrependError("error writing set end: ", err)
}
  return nil
}

func ReadSetWithAdapter(p thrift.Protocol) (SetWithAdapter, error) {
  var decodeResult SetWithAdapter
  decodeErr := func() error {
    _ /* elemType */, size, err := p.ReadSetBegin()
if err != nil {
    return thrift.PrependError("error reading set begin: ", err)
}

setResult := make([]string, 0, size)
for i := 0; i < size; i++ {
    var elem string
    {
        result, err := p.ReadString()
if err != nil {
    return err
}
        elem = result
    }
    setResult = append(setResult, elem)
}

if err := p.ReadSetEnd(); err != nil {
    return thrift.PrependError("error reading set end: ", err)
}
result := setResult
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type StringWithAdapter = string

func NewStringWithAdapter() StringWithAdapter {
  return ""
}

func WriteStringWithAdapter(item StringWithAdapter, p thrift.Protocol) error {
  if err := p.WriteString(item); err != nil {
    return err
}
  return nil
}

func ReadStringWithAdapter(p thrift.Protocol) (StringWithAdapter, error) {
  var decodeResult StringWithAdapter
  decodeErr := func() error {
    result, err := p.ReadString()
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type ListWithElemAdapter = []StringWithAdapter

func NewListWithElemAdapter() ListWithElemAdapter {
  return make([]StringWithAdapter, 0)
}

func WriteListWithElemAdapter(item ListWithElemAdapter, p thrift.Protocol) error {
  if err := p.WriteListBegin(thrift.STRING, len(item)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
}
for _, v := range item {
    {
        item := v
        err := WriteStringWithAdapter(item, p)
if err != nil {
    return err
}
    }
}
if err := p.WriteListEnd(); err != nil {
    return thrift.PrependError("error writing list end: ", err)
}
  return nil
}

func ReadListWithElemAdapter(p thrift.Protocol) (ListWithElemAdapter, error) {
  var decodeResult ListWithElemAdapter
  decodeErr := func() error {
    _ /* elemType */, size, err := p.ReadListBegin()
if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
}

listResult := make([]StringWithAdapter, 0, size)
for i := 0; i < size; i++ {
    var elem StringWithAdapter
    {
        result, err := ReadStringWithAdapter(p)
if err != nil {
    return err
}
        elem = result
    }
    listResult = append(listResult, elem)
}

if err := p.ReadListEnd(); err != nil {
    return thrift.PrependError("error reading list end: ", err)
}
result := listResult
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type ListWithElemAdapterWithAdapter = ListWithElemAdapter

func NewListWithElemAdapterWithAdapter() ListWithElemAdapterWithAdapter {
  return NewListWithElemAdapter()
}

func WriteListWithElemAdapterWithAdapter(item ListWithElemAdapterWithAdapter, p thrift.Protocol) error {
  err := WriteListWithElemAdapter(item, p)
if err != nil {
    return err
}
  return nil
}

func ReadListWithElemAdapterWithAdapter(p thrift.Protocol) (ListWithElemAdapterWithAdapter, error) {
  var decodeResult ListWithElemAdapterWithAdapter
  decodeErr := func() error {
    result, err := ReadListWithElemAdapter(p)
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type MyI64 = int64

func NewMyI64() MyI64 {
  return 0
}

func WriteMyI64(item MyI64, p thrift.Protocol) error {
  if err := p.WriteI64(item); err != nil {
    return err
}
  return nil
}

func ReadMyI64(p thrift.Protocol) (MyI64, error) {
  var decodeResult MyI64
  decodeErr := func() error {
    result, err := p.ReadI64()
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type DoubleTypedefI64 = MyI64

func NewDoubleTypedefI64() DoubleTypedefI64 {
  return NewMyI64()
}

func WriteDoubleTypedefI64(item DoubleTypedefI64, p thrift.Protocol) error {
  err := WriteMyI64(item, p)
if err != nil {
    return err
}
  return nil
}

func ReadDoubleTypedefI64(p thrift.Protocol) (DoubleTypedefI64, error) {
  var decodeResult DoubleTypedefI64
  decodeErr := func() error {
    result, err := ReadMyI64(p)
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type MyI32 = int32

func NewMyI32() MyI32 {
  return 0
}

func WriteMyI32(item MyI32, p thrift.Protocol) error {
  if err := p.WriteI32(item); err != nil {
    return err
}
  return nil
}

func ReadMyI32(p thrift.Protocol) (MyI32, error) {
  var decodeResult MyI32
  decodeErr := func() error {
    result, err := p.ReadI32()
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type FooWithAdapter = Foo

func NewFooWithAdapter() *FooWithAdapter {
  return NewFoo()
}

func WriteFooWithAdapter(item *FooWithAdapter, p thrift.Protocol) error {
  if err := item.Write(p); err != nil {
    return err
}
  return nil
}

func ReadFooWithAdapter(p thrift.Protocol) (FooWithAdapter, error) {
  var decodeResult FooWithAdapter
  decodeErr := func() error {
    result := *NewFoo()
err := result.Read(p)
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type StructWithAdapter = Bar

func NewStructWithAdapter() *StructWithAdapter {
  return NewBar()
}

func WriteStructWithAdapter(item *StructWithAdapter, p thrift.Protocol) error {
  if err := item.Write(p); err != nil {
    return err
}
  return nil
}

func ReadStructWithAdapter(p thrift.Protocol) (StructWithAdapter, error) {
  var decodeResult StructWithAdapter
  decodeErr := func() error {
    result := *NewBar()
err := result.Read(p)
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type UnionWithAdapter = Baz

func NewUnionWithAdapter() *UnionWithAdapter {
  return NewBaz()
}

func WriteUnionWithAdapter(item *UnionWithAdapter, p thrift.Protocol) error {
  if err := item.Write(p); err != nil {
    return err
}
  return nil
}

func ReadUnionWithAdapter(p thrift.Protocol) (UnionWithAdapter, error) {
  var decodeResult UnionWithAdapter
  decodeErr := func() error {
    result := *NewBaz()
err := result.Read(p)
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type AdaptedA = A

func NewAdaptedA() *AdaptedA {
  return NewA()
}

func WriteAdaptedA(item *AdaptedA, p thrift.Protocol) error {
  if err := item.Write(p); err != nil {
    return err
}
  return nil
}

func ReadAdaptedA(p thrift.Protocol) (AdaptedA, error) {
  var decodeResult AdaptedA
  decodeErr := func() error {
    result := *NewA()
err := result.Read(p)
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type DurationMs = int64

func NewDurationMs() DurationMs {
  return 0
}

func WriteDurationMs(item DurationMs, p thrift.Protocol) error {
  if err := p.WriteI64(item); err != nil {
    return err
}
  return nil
}

func ReadDurationMs(p thrift.Protocol) (DurationMs, error) {
  var decodeResult DurationMs
  decodeErr := func() error {
    result, err := p.ReadI64()
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type AdaptedBool = bool

func NewAdaptedBool() AdaptedBool {
  return false
}

func WriteAdaptedBool(item AdaptedBool, p thrift.Protocol) error {
  if err := p.WriteBool(item); err != nil {
    return err
}
  return nil
}

func ReadAdaptedBool(p thrift.Protocol) (AdaptedBool, error) {
  var decodeResult AdaptedBool
  decodeErr := func() error {
    result, err := p.ReadBool()
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type AdaptedByte = int8

func NewAdaptedByte() AdaptedByte {
  return 0
}

func WriteAdaptedByte(item AdaptedByte, p thrift.Protocol) error {
  if err := p.WriteByte(byte(item)); err != nil {
    return err
}
  return nil
}

func ReadAdaptedByte(p thrift.Protocol) (AdaptedByte, error) {
  var decodeResult AdaptedByte
  decodeErr := func() error {
    resultByte, err := p.ReadByte()
result := int8(resultByte)
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type AdaptedShort = int16

func NewAdaptedShort() AdaptedShort {
  return 0
}

func WriteAdaptedShort(item AdaptedShort, p thrift.Protocol) error {
  if err := p.WriteI16(item); err != nil {
    return err
}
  return nil
}

func ReadAdaptedShort(p thrift.Protocol) (AdaptedShort, error) {
  var decodeResult AdaptedShort
  decodeErr := func() error {
    result, err := p.ReadI16()
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type AdaptedInteger = int32

func NewAdaptedInteger() AdaptedInteger {
  return 0
}

func WriteAdaptedInteger(item AdaptedInteger, p thrift.Protocol) error {
  if err := p.WriteI32(item); err != nil {
    return err
}
  return nil
}

func ReadAdaptedInteger(p thrift.Protocol) (AdaptedInteger, error) {
  var decodeResult AdaptedInteger
  decodeErr := func() error {
    result, err := p.ReadI32()
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type AdaptedLong = int64

func NewAdaptedLong() AdaptedLong {
  return 0
}

func WriteAdaptedLong(item AdaptedLong, p thrift.Protocol) error {
  if err := p.WriteI64(item); err != nil {
    return err
}
  return nil
}

func ReadAdaptedLong(p thrift.Protocol) (AdaptedLong, error) {
  var decodeResult AdaptedLong
  decodeErr := func() error {
    result, err := p.ReadI64()
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type AdaptedDouble = float64

func NewAdaptedDouble() AdaptedDouble {
  return 0.0
}

func WriteAdaptedDouble(item AdaptedDouble, p thrift.Protocol) error {
  if err := p.WriteDouble(item); err != nil {
    return err
}
  return nil
}

func ReadAdaptedDouble(p thrift.Protocol) (AdaptedDouble, error) {
  var decodeResult AdaptedDouble
  decodeErr := func() error {
    result, err := p.ReadDouble()
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type AdaptedString = string

func NewAdaptedString() AdaptedString {
  return ""
}

func WriteAdaptedString(item AdaptedString, p thrift.Protocol) error {
  if err := p.WriteString(item); err != nil {
    return err
}
  return nil
}

func ReadAdaptedString(p thrift.Protocol) (AdaptedString, error) {
  var decodeResult AdaptedString
  decodeErr := func() error {
    result, err := p.ReadString()
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type DoubleTypedefBool = AdaptedBool

func NewDoubleTypedefBool() DoubleTypedefBool {
  return NewAdaptedBool()
}

func WriteDoubleTypedefBool(item DoubleTypedefBool, p thrift.Protocol) error {
  err := WriteAdaptedBool(item, p)
if err != nil {
    return err
}
  return nil
}

func ReadDoubleTypedefBool(p thrift.Protocol) (DoubleTypedefBool, error) {
  var decodeResult DoubleTypedefBool
  decodeErr := func() error {
    result, err := ReadAdaptedBool(p)
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type CustomProtocolType = []byte

func NewCustomProtocolType() CustomProtocolType {
  return []byte("")
}

func WriteCustomProtocolType(item CustomProtocolType, p thrift.Protocol) error {
  if err := p.WriteBinary(item); err != nil {
    return err
}
  return nil
}

func ReadCustomProtocolType(p thrift.Protocol) (CustomProtocolType, error) {
  var decodeResult CustomProtocolType
  decodeErr := func() error {
    result, err := p.ReadBinary()
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type IndirectionString = string

func NewIndirectionString() IndirectionString {
  return ""
}

func WriteIndirectionString(item IndirectionString, p thrift.Protocol) error {
  if err := p.WriteString(item); err != nil {
    return err
}
  return nil
}

func ReadIndirectionString(p thrift.Protocol) (IndirectionString, error) {
  var decodeResult IndirectionString
  decodeErr := func() error {
    result, err := p.ReadString()
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type AdaptedEnum = ThriftAdaptedEnum

func NewAdaptedEnum() AdaptedEnum {
  return 0
}

func WriteAdaptedEnum(item AdaptedEnum, p thrift.Protocol) error {
  if err := p.WriteI32(int32(item)); err != nil {
    return err
}
  return nil
}

func ReadAdaptedEnum(p thrift.Protocol) (AdaptedEnum, error) {
  var decodeResult AdaptedEnum
  decodeErr := func() error {
    enumResult, err := p.ReadI32()
if err != nil {
    return err
}
result := ThriftAdaptedEnum(enumResult)
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type AdaptedTypedef = AdaptedStruct

func NewAdaptedTypedef() *AdaptedTypedef {
  return NewAdaptedStruct()
}

func WriteAdaptedTypedef(item *AdaptedTypedef, p thrift.Protocol) error {
  if err := item.Write(p); err != nil {
    return err
}
  return nil
}

func ReadAdaptedTypedef(p thrift.Protocol) (AdaptedTypedef, error) {
  var decodeResult AdaptedTypedef
  decodeErr := func() error {
    result := *NewAdaptedStruct()
err := result.Read(p)
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type TypedefOfDirect = DirectlyAdaptedStruct

func NewTypedefOfDirect() *TypedefOfDirect {
  return NewDirectlyAdaptedStruct()
}

func WriteTypedefOfDirect(item *TypedefOfDirect, p thrift.Protocol) error {
  if err := item.Write(p); err != nil {
    return err
}
  return nil
}

func ReadTypedefOfDirect(p thrift.Protocol) (TypedefOfDirect, error) {
  var decodeResult TypedefOfDirect
  decodeErr := func() error {
    result := *NewDirectlyAdaptedStruct()
err := result.Read(p)
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type AdaptedCircularAdaptee = CircularAdaptee

func NewAdaptedCircularAdaptee() *AdaptedCircularAdaptee {
  return NewCircularAdaptee()
}

func WriteAdaptedCircularAdaptee(item *AdaptedCircularAdaptee, p thrift.Protocol) error {
  if err := item.Write(p); err != nil {
    return err
}
  return nil
}

func ReadAdaptedCircularAdaptee(p thrift.Protocol) (AdaptedCircularAdaptee, error) {
  var decodeResult AdaptedCircularAdaptee
  decodeErr := func() error {
    result := *NewCircularAdaptee()
err := result.Read(p)
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type CountingInt = int64

func NewCountingInt() CountingInt {
  return 0
}

func WriteCountingInt(item CountingInt, p thrift.Protocol) error {
  if err := p.WriteI64(item); err != nil {
    return err
}
  return nil
}

func ReadCountingInt(p thrift.Protocol) (CountingInt, error) {
  var decodeResult CountingInt
  decodeErr := func() error {
    result, err := p.ReadI64()
if err != nil {
    return err
}
    decodeResult = result
    return nil
  }()
  return decodeResult, decodeErr
}

type Color int32

const (
    Color_UNKNOWN Color = 0
    Color_RED Color = 1
    Color_GREEN Color = 2
    Color_BLUE Color = 3
)

// Enum value maps for Color
var (
    ColorToName = map[Color]string {
        Color_UNKNOWN: "UNKNOWN",
        Color_RED: "RED",
        Color_GREEN: "GREEN",
        Color_BLUE: "BLUE",
    }

    ColorToValue = map[string]Color {
        "UNKNOWN": Color_UNKNOWN,
        "RED": Color_RED,
        "GREEN": Color_GREEN,
        "BLUE": Color_BLUE,
    }

    ColorNames = []string{
        "UNKNOWN",
        "RED",
        "GREEN",
        "BLUE",
    }

    ColorValues = []Color{
        Color_UNKNOWN,
        Color_RED,
        Color_GREEN,
        Color_BLUE,
    }
)

func (x Color) String() string {
    if v, ok := ColorToName[x]; ok {
        return v
    }
    return "<UNSET>"
}

func (x Color) Ptr() *Color {
    return &x
}

// Deprecated: Use ColorToValue instead (e.g. `x, ok := ColorToValue["name"]`).
func ColorFromString(s string) (Color, error) {
    if v, ok := ColorToValue[s]; ok {
        return v, nil
    }
    return Color(0), fmt.Errorf("not a valid Color string")
}

// Deprecated: Use Color.Ptr() instead.
func ColorPtr(v Color) *Color {
    return &v
}


type ThriftAdaptedEnum int32

const (
    ThriftAdaptedEnum_Zero ThriftAdaptedEnum = 0
    ThriftAdaptedEnum_One ThriftAdaptedEnum = 1
)

// Enum value maps for ThriftAdaptedEnum
var (
    ThriftAdaptedEnumToName = map[ThriftAdaptedEnum]string {
        ThriftAdaptedEnum_Zero: "Zero",
        ThriftAdaptedEnum_One: "One",
    }

    ThriftAdaptedEnumToValue = map[string]ThriftAdaptedEnum {
        "Zero": ThriftAdaptedEnum_Zero,
        "One": ThriftAdaptedEnum_One,
    }

    ThriftAdaptedEnumNames = []string{
        "Zero",
        "One",
    }

    ThriftAdaptedEnumValues = []ThriftAdaptedEnum{
        ThriftAdaptedEnum_Zero,
        ThriftAdaptedEnum_One,
    }
)

func (x ThriftAdaptedEnum) String() string {
    if v, ok := ThriftAdaptedEnumToName[x]; ok {
        return v
    }
    return "<UNSET>"
}

func (x ThriftAdaptedEnum) Ptr() *ThriftAdaptedEnum {
    return &x
}

// Deprecated: Use ThriftAdaptedEnumToValue instead (e.g. `x, ok := ThriftAdaptedEnumToValue["name"]`).
func ThriftAdaptedEnumFromString(s string) (ThriftAdaptedEnum, error) {
    if v, ok := ThriftAdaptedEnumToValue[s]; ok {
        return v, nil
    }
    return ThriftAdaptedEnum(0), fmt.Errorf("not a valid ThriftAdaptedEnum string")
}

// Deprecated: Use ThriftAdaptedEnum.Ptr() instead.
func ThriftAdaptedEnumPtr(v ThriftAdaptedEnum) *ThriftAdaptedEnum {
    return &v
}


type MyAnnotation struct {
    Signature string `thrift:"signature,1" json:"signature" db:"signature"`
    Color Color `thrift:"color,2" json:"color" db:"color"`
}
// Compile time interface enforcer
var _ thrift.Struct = &MyAnnotation{}

func NewMyAnnotation() *MyAnnotation {
    return (&MyAnnotation{}).
        SetSignatureNonCompat("").
        SetColorNonCompat(
              Color_RED,
          )
}

func (x *MyAnnotation) GetSignatureNonCompat() string {
    return x.Signature
}

func (x *MyAnnotation) GetSignature() string {
    return x.Signature
}

func (x *MyAnnotation) GetColorNonCompat() Color {
    return x.Color
}

func (x *MyAnnotation) GetColor() Color {
    return x.Color
}

func (x *MyAnnotation) SetSignatureNonCompat(value string) *MyAnnotation {
    x.Signature = value
    return x
}

func (x *MyAnnotation) SetSignature(value string) *MyAnnotation {
    x.Signature = value
    return x
}

func (x *MyAnnotation) SetColorNonCompat(value Color) *MyAnnotation {
    x.Color = value
    return x
}

func (x *MyAnnotation) SetColor(value Color) *MyAnnotation {
    x.Color = value
    return x
}

func (x *MyAnnotation) writeField1(p thrift.Protocol) error {  // Signature
    if err := p.WriteFieldBegin("signature", thrift.STRING, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetSignatureNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *MyAnnotation) writeField2(p thrift.Protocol) error {  // Color
    if err := p.WriteFieldBegin("color", thrift.I32, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetColorNonCompat()
    if err := p.WriteI32(int32(item)); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *MyAnnotation) readField1(p thrift.Protocol) error {  // Signature
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetSignatureNonCompat(result)
    return nil
}

func (x *MyAnnotation) readField2(p thrift.Protocol) error {  // Color
    enumResult, err := p.ReadI32()
if err != nil {
    return err
}
result := Color(enumResult)

    x.SetColorNonCompat(result)
    return nil
}

func (x *MyAnnotation) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use MyAnnotation.Set* methods instead or set the fields directly.
type MyAnnotationBuilder struct {
    obj *MyAnnotation
}

func NewMyAnnotationBuilder() *MyAnnotationBuilder {
    return &MyAnnotationBuilder{
        obj: NewMyAnnotation(),
    }
}

func (x *MyAnnotationBuilder) Signature(value string) *MyAnnotationBuilder {
    x.obj.Signature = value
    return x
}

func (x *MyAnnotationBuilder) Color(value Color) *MyAnnotationBuilder {
    x.obj.Color = value
    return x
}

func (x *MyAnnotationBuilder) Emit() *MyAnnotation {
    var objCopy MyAnnotation = *x.obj
    return &objCopy
}

func (x *MyAnnotation) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("MyAnnotation"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *MyAnnotation) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // signature
            if err := x.readField1(p); err != nil {
                return err
            }
        case 2:  // color
            if err := x.readField2(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type Foo struct {
    IntField int32 `thrift:"intField,1" json:"intField" db:"intField"`
    OptionalIntField *int32 `thrift:"optionalIntField,2,optional" json:"optionalIntField,omitempty" db:"optionalIntField"`
    IntFieldWithDefault int32 `thrift:"intFieldWithDefault,3" json:"intFieldWithDefault" db:"intFieldWithDefault"`
    SetField SetWithAdapter `thrift:"setField,4" json:"setField" db:"setField"`
    OptionalSetField SetWithAdapter `thrift:"optionalSetField,5,optional" json:"optionalSetField,omitempty" db:"optionalSetField"`
    MapField map[string]ListWithElemAdapterWithAdapter `thrift:"mapField,6" json:"mapField" db:"mapField"`
    OptionalMapField map[string]ListWithElemAdapterWithAdapter `thrift:"optionalMapField,7,optional" json:"optionalMapField,omitempty" db:"optionalMapField"`
    BinaryField []byte `thrift:"binaryField,8" json:"binaryField" db:"binaryField"`
    LongField MyI64 `thrift:"longField,9" json:"longField" db:"longField"`
    AdaptedLongField MyI64 `thrift:"adaptedLongField,10" json:"adaptedLongField" db:"adaptedLongField"`
    DoubleAdaptedField DoubleTypedefI64 `thrift:"doubleAdaptedField,11" json:"doubleAdaptedField" db:"doubleAdaptedField"`
}
// Compile time interface enforcer
var _ thrift.Struct = &Foo{}

func NewFoo() *Foo {
    return (&Foo{}).
        SetIntFieldNonCompat(0).
        SetIntFieldWithDefaultNonCompat(13).
        SetSetFieldNonCompat(NewSetWithAdapter()).
        SetMapFieldNonCompat(make(map[string]ListWithElemAdapterWithAdapter)).
        SetBinaryFieldNonCompat([]byte("")).
        SetLongFieldNonCompat(NewMyI64()).
        SetAdaptedLongFieldNonCompat(NewMyI64()).
        SetDoubleAdaptedFieldNonCompat(NewDoubleTypedefI64())
}

// Deprecated: Use NewFoo().GetOptionalIntField() instead.
var Foo_OptionalIntField_DEFAULT = NewFoo().GetOptionalIntField()

func (x *Foo) GetIntFieldNonCompat() int32 {
    return x.IntField
}

func (x *Foo) GetIntField() int32 {
    return x.IntField
}

func (x *Foo) GetOptionalIntFieldNonCompat() *int32 {
    return x.OptionalIntField
}

func (x *Foo) GetOptionalIntField() int32 {
    if !x.IsSetOptionalIntField() {
        return 0
    }

    return *x.OptionalIntField
}

func (x *Foo) GetIntFieldWithDefaultNonCompat() int32 {
    return x.IntFieldWithDefault
}

func (x *Foo) GetIntFieldWithDefault() int32 {
    return x.IntFieldWithDefault
}

func (x *Foo) GetSetFieldNonCompat() SetWithAdapter {
    return x.SetField
}

func (x *Foo) GetSetField() SetWithAdapter {
    if !x.IsSetSetField() {
        return NewSetWithAdapter()
    }

    return x.SetField
}

func (x *Foo) GetOptionalSetFieldNonCompat() SetWithAdapter {
    return x.OptionalSetField
}

func (x *Foo) GetOptionalSetField() SetWithAdapter {
    if !x.IsSetOptionalSetField() {
        return NewSetWithAdapter()
    }

    return x.OptionalSetField
}

func (x *Foo) GetMapFieldNonCompat() map[string]ListWithElemAdapterWithAdapter {
    return x.MapField
}

func (x *Foo) GetMapField() map[string]ListWithElemAdapterWithAdapter {
    if !x.IsSetMapField() {
        return make(map[string]ListWithElemAdapterWithAdapter)
    }

    return x.MapField
}

func (x *Foo) GetOptionalMapFieldNonCompat() map[string]ListWithElemAdapterWithAdapter {
    return x.OptionalMapField
}

func (x *Foo) GetOptionalMapField() map[string]ListWithElemAdapterWithAdapter {
    if !x.IsSetOptionalMapField() {
        return make(map[string]ListWithElemAdapterWithAdapter)
    }

    return x.OptionalMapField
}

func (x *Foo) GetBinaryFieldNonCompat() []byte {
    return x.BinaryField
}

func (x *Foo) GetBinaryField() []byte {
    if !x.IsSetBinaryField() {
        return []byte("")
    }

    return x.BinaryField
}

func (x *Foo) GetLongFieldNonCompat() MyI64 {
    return x.LongField
}

func (x *Foo) GetLongField() MyI64 {
    return x.LongField
}

func (x *Foo) GetAdaptedLongFieldNonCompat() MyI64 {
    return x.AdaptedLongField
}

func (x *Foo) GetAdaptedLongField() MyI64 {
    return x.AdaptedLongField
}

func (x *Foo) GetDoubleAdaptedFieldNonCompat() DoubleTypedefI64 {
    return x.DoubleAdaptedField
}

func (x *Foo) GetDoubleAdaptedField() DoubleTypedefI64 {
    return x.DoubleAdaptedField
}

func (x *Foo) SetIntFieldNonCompat(value int32) *Foo {
    x.IntField = value
    return x
}

func (x *Foo) SetIntField(value int32) *Foo {
    x.IntField = value
    return x
}

func (x *Foo) SetOptionalIntFieldNonCompat(value int32) *Foo {
    x.OptionalIntField = &value
    return x
}

func (x *Foo) SetOptionalIntField(value *int32) *Foo {
    x.OptionalIntField = value
    return x
}

func (x *Foo) SetIntFieldWithDefaultNonCompat(value int32) *Foo {
    x.IntFieldWithDefault = value
    return x
}

func (x *Foo) SetIntFieldWithDefault(value int32) *Foo {
    x.IntFieldWithDefault = value
    return x
}

func (x *Foo) SetSetFieldNonCompat(value SetWithAdapter) *Foo {
    x.SetField = value
    return x
}

func (x *Foo) SetSetField(value SetWithAdapter) *Foo {
    x.SetField = value
    return x
}

func (x *Foo) SetOptionalSetFieldNonCompat(value SetWithAdapter) *Foo {
    x.OptionalSetField = value
    return x
}

func (x *Foo) SetOptionalSetField(value SetWithAdapter) *Foo {
    x.OptionalSetField = value
    return x
}

func (x *Foo) SetMapFieldNonCompat(value map[string]ListWithElemAdapterWithAdapter) *Foo {
    x.MapField = value
    return x
}

func (x *Foo) SetMapField(value map[string]ListWithElemAdapterWithAdapter) *Foo {
    x.MapField = value
    return x
}

func (x *Foo) SetOptionalMapFieldNonCompat(value map[string]ListWithElemAdapterWithAdapter) *Foo {
    x.OptionalMapField = value
    return x
}

func (x *Foo) SetOptionalMapField(value map[string]ListWithElemAdapterWithAdapter) *Foo {
    x.OptionalMapField = value
    return x
}

func (x *Foo) SetBinaryFieldNonCompat(value []byte) *Foo {
    x.BinaryField = value
    return x
}

func (x *Foo) SetBinaryField(value []byte) *Foo {
    x.BinaryField = value
    return x
}

func (x *Foo) SetLongFieldNonCompat(value MyI64) *Foo {
    x.LongField = value
    return x
}

func (x *Foo) SetLongField(value MyI64) *Foo {
    x.LongField = value
    return x
}

func (x *Foo) SetAdaptedLongFieldNonCompat(value MyI64) *Foo {
    x.AdaptedLongField = value
    return x
}

func (x *Foo) SetAdaptedLongField(value MyI64) *Foo {
    x.AdaptedLongField = value
    return x
}

func (x *Foo) SetDoubleAdaptedFieldNonCompat(value DoubleTypedefI64) *Foo {
    x.DoubleAdaptedField = value
    return x
}

func (x *Foo) SetDoubleAdaptedField(value DoubleTypedefI64) *Foo {
    x.DoubleAdaptedField = value
    return x
}

func (x *Foo) IsSetOptionalIntField() bool {
    return x.OptionalIntField != nil
}

func (x *Foo) IsSetSetField() bool {
    return x.SetField != nil
}

func (x *Foo) IsSetOptionalSetField() bool {
    return x.OptionalSetField != nil
}

func (x *Foo) IsSetMapField() bool {
    return x.MapField != nil
}

func (x *Foo) IsSetOptionalMapField() bool {
    return x.OptionalMapField != nil
}

func (x *Foo) IsSetBinaryField() bool {
    return x.BinaryField != nil
}

func (x *Foo) writeField1(p thrift.Protocol) error {  // IntField
    if err := p.WriteFieldBegin("intField", thrift.I32, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetIntFieldNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField2(p thrift.Protocol) error {  // OptionalIntField
    if !x.IsSetOptionalIntField() {
        return nil
    }

    if err := p.WriteFieldBegin("optionalIntField", thrift.I32, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetOptionalIntFieldNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField3(p thrift.Protocol) error {  // IntFieldWithDefault
    if err := p.WriteFieldBegin("intFieldWithDefault", thrift.I32, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetIntFieldWithDefaultNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField4(p thrift.Protocol) error {  // SetField
    if !x.IsSetSetField() {
        return nil
    }

    if err := p.WriteFieldBegin("setField", thrift.SET, 4); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetSetFieldNonCompat()
    err := WriteSetWithAdapter(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField5(p thrift.Protocol) error {  // OptionalSetField
    if !x.IsSetOptionalSetField() {
        return nil
    }

    if err := p.WriteFieldBegin("optionalSetField", thrift.SET, 5); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetOptionalSetFieldNonCompat()
    err := WriteSetWithAdapter(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField6(p thrift.Protocol) error {  // MapField
    if !x.IsSetMapField() {
        return nil
    }

    if err := p.WriteFieldBegin("mapField", thrift.MAP, 6); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetMapFieldNonCompat()
    if err := p.WriteMapBegin(thrift.STRING, thrift.LIST, len(item)); err != nil {
    return thrift.PrependError("error writing map begin: ", err)
}
for k, v := range item {
    {
        item := k
        if err := p.WriteString(item); err != nil {
    return err
}
    }

    {
        item := v
        err := WriteListWithElemAdapterWithAdapter(item, p)
if err != nil {
    return err
}
    }
}
if err := p.WriteMapEnd(); err != nil {
    return thrift.PrependError("error writing map end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField7(p thrift.Protocol) error {  // OptionalMapField
    if !x.IsSetOptionalMapField() {
        return nil
    }

    if err := p.WriteFieldBegin("optionalMapField", thrift.MAP, 7); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetOptionalMapFieldNonCompat()
    if err := p.WriteMapBegin(thrift.STRING, thrift.LIST, len(item)); err != nil {
    return thrift.PrependError("error writing map begin: ", err)
}
for k, v := range item {
    {
        item := k
        if err := p.WriteString(item); err != nil {
    return err
}
    }

    {
        item := v
        err := WriteListWithElemAdapterWithAdapter(item, p)
if err != nil {
    return err
}
    }
}
if err := p.WriteMapEnd(); err != nil {
    return thrift.PrependError("error writing map end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField8(p thrift.Protocol) error {  // BinaryField
    if !x.IsSetBinaryField() {
        return nil
    }

    if err := p.WriteFieldBegin("binaryField", thrift.BINARY, 8); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetBinaryFieldNonCompat()
    if err := p.WriteBinary(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField9(p thrift.Protocol) error {  // LongField
    if err := p.WriteFieldBegin("longField", thrift.I64, 9); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetLongFieldNonCompat()
    err := WriteMyI64(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField10(p thrift.Protocol) error {  // AdaptedLongField
    if err := p.WriteFieldBegin("adaptedLongField", thrift.I64, 10); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedLongFieldNonCompat()
    err := WriteMyI64(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) writeField11(p thrift.Protocol) error {  // DoubleAdaptedField
    if err := p.WriteFieldBegin("doubleAdaptedField", thrift.I64, 11); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDoubleAdaptedFieldNonCompat()
    err := WriteDoubleTypedefI64(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Foo) readField1(p thrift.Protocol) error {  // IntField
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetIntFieldNonCompat(result)
    return nil
}

func (x *Foo) readField2(p thrift.Protocol) error {  // OptionalIntField
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetOptionalIntFieldNonCompat(result)
    return nil
}

func (x *Foo) readField3(p thrift.Protocol) error {  // IntFieldWithDefault
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetIntFieldWithDefaultNonCompat(result)
    return nil
}

func (x *Foo) readField4(p thrift.Protocol) error {  // SetField
    result, err := ReadSetWithAdapter(p)
if err != nil {
    return err
}

    x.SetSetFieldNonCompat(result)
    return nil
}

func (x *Foo) readField5(p thrift.Protocol) error {  // OptionalSetField
    result, err := ReadSetWithAdapter(p)
if err != nil {
    return err
}

    x.SetOptionalSetFieldNonCompat(result)
    return nil
}

func (x *Foo) readField6(p thrift.Protocol) error {  // MapField
    _ /* keyType */, _ /* valueType */, size, err := p.ReadMapBegin()
if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
}

mapResult := make(map[string]ListWithElemAdapterWithAdapter, size)
for i := 0; i < size; i++ {
    var key string
    {
        result, err := p.ReadString()
if err != nil {
    return err
}
        key = result
    }

    var value ListWithElemAdapterWithAdapter
    {
        result, err := ReadListWithElemAdapterWithAdapter(p)
if err != nil {
    return err
}
        value = result
    }

    mapResult[key] = value
}

if err := p.ReadMapEnd(); err != nil {
    return thrift.PrependError("error reading map end: ", err)
}
result := mapResult

    x.SetMapFieldNonCompat(result)
    return nil
}

func (x *Foo) readField7(p thrift.Protocol) error {  // OptionalMapField
    _ /* keyType */, _ /* valueType */, size, err := p.ReadMapBegin()
if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
}

mapResult := make(map[string]ListWithElemAdapterWithAdapter, size)
for i := 0; i < size; i++ {
    var key string
    {
        result, err := p.ReadString()
if err != nil {
    return err
}
        key = result
    }

    var value ListWithElemAdapterWithAdapter
    {
        result, err := ReadListWithElemAdapterWithAdapter(p)
if err != nil {
    return err
}
        value = result
    }

    mapResult[key] = value
}

if err := p.ReadMapEnd(); err != nil {
    return thrift.PrependError("error reading map end: ", err)
}
result := mapResult

    x.SetOptionalMapFieldNonCompat(result)
    return nil
}

func (x *Foo) readField8(p thrift.Protocol) error {  // BinaryField
    result, err := p.ReadBinary()
if err != nil {
    return err
}

    x.SetBinaryFieldNonCompat(result)
    return nil
}

func (x *Foo) readField9(p thrift.Protocol) error {  // LongField
    result, err := ReadMyI64(p)
if err != nil {
    return err
}

    x.SetLongFieldNonCompat(result)
    return nil
}

func (x *Foo) readField10(p thrift.Protocol) error {  // AdaptedLongField
    result, err := ReadMyI64(p)
if err != nil {
    return err
}

    x.SetAdaptedLongFieldNonCompat(result)
    return nil
}

func (x *Foo) readField11(p thrift.Protocol) error {  // DoubleAdaptedField
    result, err := ReadDoubleTypedefI64(p)
if err != nil {
    return err
}

    x.SetDoubleAdaptedFieldNonCompat(result)
    return nil
}

func (x *Foo) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use Foo.Set* methods instead or set the fields directly.
type FooBuilder struct {
    obj *Foo
}

func NewFooBuilder() *FooBuilder {
    return &FooBuilder{
        obj: NewFoo(),
    }
}

func (x *FooBuilder) IntField(value int32) *FooBuilder {
    x.obj.IntField = value
    return x
}

func (x *FooBuilder) OptionalIntField(value *int32) *FooBuilder {
    x.obj.OptionalIntField = value
    return x
}

func (x *FooBuilder) IntFieldWithDefault(value int32) *FooBuilder {
    x.obj.IntFieldWithDefault = value
    return x
}

func (x *FooBuilder) SetField(value SetWithAdapter) *FooBuilder {
    x.obj.SetField = value
    return x
}

func (x *FooBuilder) OptionalSetField(value SetWithAdapter) *FooBuilder {
    x.obj.OptionalSetField = value
    return x
}

func (x *FooBuilder) MapField(value map[string]ListWithElemAdapterWithAdapter) *FooBuilder {
    x.obj.MapField = value
    return x
}

func (x *FooBuilder) OptionalMapField(value map[string]ListWithElemAdapterWithAdapter) *FooBuilder {
    x.obj.OptionalMapField = value
    return x
}

func (x *FooBuilder) BinaryField(value []byte) *FooBuilder {
    x.obj.BinaryField = value
    return x
}

func (x *FooBuilder) LongField(value MyI64) *FooBuilder {
    x.obj.LongField = value
    return x
}

func (x *FooBuilder) AdaptedLongField(value MyI64) *FooBuilder {
    x.obj.AdaptedLongField = value
    return x
}

func (x *FooBuilder) DoubleAdaptedField(value DoubleTypedefI64) *FooBuilder {
    x.obj.DoubleAdaptedField = value
    return x
}

func (x *FooBuilder) Emit() *Foo {
    var objCopy Foo = *x.obj
    return &objCopy
}

func (x *Foo) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("Foo"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := x.writeField4(p); err != nil {
        return err
    }

    if err := x.writeField5(p); err != nil {
        return err
    }

    if err := x.writeField6(p); err != nil {
        return err
    }

    if err := x.writeField7(p); err != nil {
        return err
    }

    if err := x.writeField8(p); err != nil {
        return err
    }

    if err := x.writeField9(p); err != nil {
        return err
    }

    if err := x.writeField10(p); err != nil {
        return err
    }

    if err := x.writeField11(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *Foo) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // intField
            if err := x.readField1(p); err != nil {
                return err
            }
        case 2:  // optionalIntField
            if err := x.readField2(p); err != nil {
                return err
            }
        case 3:  // intFieldWithDefault
            if err := x.readField3(p); err != nil {
                return err
            }
        case 4:  // setField
            if err := x.readField4(p); err != nil {
                return err
            }
        case 5:  // optionalSetField
            if err := x.readField5(p); err != nil {
                return err
            }
        case 6:  // mapField
            if err := x.readField6(p); err != nil {
                return err
            }
        case 7:  // optionalMapField
            if err := x.readField7(p); err != nil {
                return err
            }
        case 8:  // binaryField
            if err := x.readField8(p); err != nil {
                return err
            }
        case 9:  // longField
            if err := x.readField9(p); err != nil {
                return err
            }
        case 10:  // adaptedLongField
            if err := x.readField10(p); err != nil {
                return err
            }
        case 11:  // doubleAdaptedField
            if err := x.readField11(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type Baz struct {
    IntField *int32 `thrift:"intField,1" json:"intField" db:"intField"`
    SetField SetWithAdapter `thrift:"setField,4" json:"setField" db:"setField"`
    MapField map[string]ListWithElemAdapterWithAdapter `thrift:"mapField,6" json:"mapField" db:"mapField"`
    BinaryField []byte `thrift:"binaryField,8" json:"binaryField" db:"binaryField"`
    LongField *MyI64 `thrift:"longField,9" json:"longField" db:"longField"`
}
// Compile time interface enforcer
var _ thrift.Struct = &Baz{}

func NewBaz() *Baz {
    return (&Baz{}).
        SetIntFieldNonCompat(0).
        SetSetFieldNonCompat(NewSetWithAdapter()).
        SetMapFieldNonCompat(make(map[string]ListWithElemAdapterWithAdapter)).
        SetBinaryFieldNonCompat([]byte("")).
        SetLongFieldNonCompat(NewMyI64())
}

// Deprecated: Use NewBaz().GetIntField() instead.
var Baz_IntField_DEFAULT = NewBaz().GetIntField()

// Deprecated: Use NewBaz().GetLongField() instead.
var Baz_LongField_DEFAULT = NewBaz().GetLongField()

func (x *Baz) GetIntFieldNonCompat() *int32 {
    return x.IntField
}

func (x *Baz) GetIntField() int32 {
    if !x.IsSetIntField() {
        return 0
    }

    return *x.IntField
}

func (x *Baz) GetSetFieldNonCompat() SetWithAdapter {
    return x.SetField
}

func (x *Baz) GetSetField() SetWithAdapter {
    if !x.IsSetSetField() {
        return NewSetWithAdapter()
    }

    return x.SetField
}

func (x *Baz) GetMapFieldNonCompat() map[string]ListWithElemAdapterWithAdapter {
    return x.MapField
}

func (x *Baz) GetMapField() map[string]ListWithElemAdapterWithAdapter {
    if !x.IsSetMapField() {
        return make(map[string]ListWithElemAdapterWithAdapter)
    }

    return x.MapField
}

func (x *Baz) GetBinaryFieldNonCompat() []byte {
    return x.BinaryField
}

func (x *Baz) GetBinaryField() []byte {
    if !x.IsSetBinaryField() {
        return []byte("")
    }

    return x.BinaryField
}

func (x *Baz) GetLongFieldNonCompat() *MyI64 {
    return x.LongField
}

func (x *Baz) GetLongField() MyI64 {
    if !x.IsSetLongField() {
        return NewMyI64()
    }

    return *x.LongField
}

func (x *Baz) SetIntFieldNonCompat(value int32) *Baz {
    x.IntField = &value
    return x
}

func (x *Baz) SetIntField(value *int32) *Baz {
    x.IntField = value
    return x
}

func (x *Baz) SetSetFieldNonCompat(value SetWithAdapter) *Baz {
    x.SetField = value
    return x
}

func (x *Baz) SetSetField(value SetWithAdapter) *Baz {
    x.SetField = value
    return x
}

func (x *Baz) SetMapFieldNonCompat(value map[string]ListWithElemAdapterWithAdapter) *Baz {
    x.MapField = value
    return x
}

func (x *Baz) SetMapField(value map[string]ListWithElemAdapterWithAdapter) *Baz {
    x.MapField = value
    return x
}

func (x *Baz) SetBinaryFieldNonCompat(value []byte) *Baz {
    x.BinaryField = value
    return x
}

func (x *Baz) SetBinaryField(value []byte) *Baz {
    x.BinaryField = value
    return x
}

func (x *Baz) SetLongFieldNonCompat(value MyI64) *Baz {
    x.LongField = &value
    return x
}

func (x *Baz) SetLongField(value *MyI64) *Baz {
    x.LongField = value
    return x
}

func (x *Baz) IsSetIntField() bool {
    return x.IntField != nil
}

func (x *Baz) IsSetSetField() bool {
    return x.SetField != nil
}

func (x *Baz) IsSetMapField() bool {
    return x.MapField != nil
}

func (x *Baz) IsSetBinaryField() bool {
    return x.BinaryField != nil
}

func (x *Baz) IsSetLongField() bool {
    return x.LongField != nil
}

func (x *Baz) writeField1(p thrift.Protocol) error {  // IntField
    if !x.IsSetIntField() {
        return nil
    }

    if err := p.WriteFieldBegin("intField", thrift.I32, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetIntFieldNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Baz) writeField4(p thrift.Protocol) error {  // SetField
    if !x.IsSetSetField() {
        return nil
    }

    if err := p.WriteFieldBegin("setField", thrift.SET, 4); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetSetFieldNonCompat()
    err := WriteSetWithAdapter(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Baz) writeField6(p thrift.Protocol) error {  // MapField
    if !x.IsSetMapField() {
        return nil
    }

    if err := p.WriteFieldBegin("mapField", thrift.MAP, 6); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetMapFieldNonCompat()
    if err := p.WriteMapBegin(thrift.STRING, thrift.LIST, len(item)); err != nil {
    return thrift.PrependError("error writing map begin: ", err)
}
for k, v := range item {
    {
        item := k
        if err := p.WriteString(item); err != nil {
    return err
}
    }

    {
        item := v
        err := WriteListWithElemAdapterWithAdapter(item, p)
if err != nil {
    return err
}
    }
}
if err := p.WriteMapEnd(); err != nil {
    return thrift.PrependError("error writing map end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Baz) writeField8(p thrift.Protocol) error {  // BinaryField
    if !x.IsSetBinaryField() {
        return nil
    }

    if err := p.WriteFieldBegin("binaryField", thrift.BINARY, 8); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetBinaryFieldNonCompat()
    if err := p.WriteBinary(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Baz) writeField9(p thrift.Protocol) error {  // LongField
    if !x.IsSetLongField() {
        return nil
    }

    if err := p.WriteFieldBegin("longField", thrift.I64, 9); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetLongFieldNonCompat()
    err := WriteMyI64(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Baz) readField1(p thrift.Protocol) error {  // IntField
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetIntFieldNonCompat(result)
    return nil
}

func (x *Baz) readField4(p thrift.Protocol) error {  // SetField
    result, err := ReadSetWithAdapter(p)
if err != nil {
    return err
}

    x.SetSetFieldNonCompat(result)
    return nil
}

func (x *Baz) readField6(p thrift.Protocol) error {  // MapField
    _ /* keyType */, _ /* valueType */, size, err := p.ReadMapBegin()
if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
}

mapResult := make(map[string]ListWithElemAdapterWithAdapter, size)
for i := 0; i < size; i++ {
    var key string
    {
        result, err := p.ReadString()
if err != nil {
    return err
}
        key = result
    }

    var value ListWithElemAdapterWithAdapter
    {
        result, err := ReadListWithElemAdapterWithAdapter(p)
if err != nil {
    return err
}
        value = result
    }

    mapResult[key] = value
}

if err := p.ReadMapEnd(); err != nil {
    return thrift.PrependError("error reading map end: ", err)
}
result := mapResult

    x.SetMapFieldNonCompat(result)
    return nil
}

func (x *Baz) readField8(p thrift.Protocol) error {  // BinaryField
    result, err := p.ReadBinary()
if err != nil {
    return err
}

    x.SetBinaryFieldNonCompat(result)
    return nil
}

func (x *Baz) readField9(p thrift.Protocol) error {  // LongField
    result, err := ReadMyI64(p)
if err != nil {
    return err
}

    x.SetLongFieldNonCompat(result)
    return nil
}

func (x *Baz) String() string {
    return fmt.Sprintf("%+v", x)
}

func (x *Baz) countSetFields() int {
    count := int(0)
    if (x.IsSetIntField()) {
        count++
    }
    if (x.IsSetSetField()) {
        count++
    }
    if (x.IsSetMapField()) {
        count++
    }
    if (x.IsSetBinaryField()) {
        count++
    }
    if (x.IsSetLongField()) {
        count++
    }
    return count
}


// Deprecated: Use Baz.Set* methods instead or set the fields directly.
type BazBuilder struct {
    obj *Baz
}

func NewBazBuilder() *BazBuilder {
    return &BazBuilder{
        obj: NewBaz(),
    }
}

func (x *BazBuilder) IntField(value *int32) *BazBuilder {
    x.obj.IntField = value
    return x
}

func (x *BazBuilder) SetField(value SetWithAdapter) *BazBuilder {
    x.obj.SetField = value
    return x
}

func (x *BazBuilder) MapField(value map[string]ListWithElemAdapterWithAdapter) *BazBuilder {
    x.obj.MapField = value
    return x
}

func (x *BazBuilder) BinaryField(value []byte) *BazBuilder {
    x.obj.BinaryField = value
    return x
}

func (x *BazBuilder) LongField(value *MyI64) *BazBuilder {
    x.obj.LongField = value
    return x
}

func (x *BazBuilder) Emit() *Baz {
    var objCopy Baz = *x.obj
    return &objCopy
}

func (x *Baz) Write(p thrift.Protocol) error {
    if countSet := x.countSetFields(); countSet > 1 {
        return fmt.Errorf("%T write union: no more than one field must be set (%d set).", x, countSet)
    }
    if err := p.WriteStructBegin("Baz"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField4(p); err != nil {
        return err
    }

    if err := x.writeField6(p); err != nil {
        return err
    }

    if err := x.writeField8(p); err != nil {
        return err
    }

    if err := x.writeField9(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *Baz) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // intField
            if err := x.readField1(p); err != nil {
                return err
            }
        case 4:  // setField
            if err := x.readField4(p); err != nil {
                return err
            }
        case 6:  // mapField
            if err := x.readField6(p); err != nil {
                return err
            }
        case 8:  // binaryField
            if err := x.readField8(p); err != nil {
                return err
            }
        case 9:  // longField
            if err := x.readField9(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type Bar struct {
    StructField *Foo `thrift:"structField,1" json:"structField" db:"structField"`
    OptionalStructField *Foo `thrift:"optionalStructField,2,optional" json:"optionalStructField,omitempty" db:"optionalStructField"`
    StructListField []*FooWithAdapter `thrift:"structListField,3" json:"structListField" db:"structListField"`
    OptionalStructListField []*FooWithAdapter `thrift:"optionalStructListField,4,optional" json:"optionalStructListField,omitempty" db:"optionalStructListField"`
    UnionField *Baz `thrift:"unionField,5" json:"unionField" db:"unionField"`
    OptionalUnionField *Baz `thrift:"optionalUnionField,6,optional" json:"optionalUnionField,omitempty" db:"optionalUnionField"`
    AdaptedStructField *DirectlyAdapted `thrift:"adaptedStructField,7" json:"adaptedStructField" db:"adaptedStructField"`
}
// Compile time interface enforcer
var _ thrift.Struct = &Bar{}

func NewBar() *Bar {
    return (&Bar{}).
        SetStructFieldNonCompat(*NewFoo()).
        SetStructListFieldNonCompat(make([]*FooWithAdapter, 0)).
        SetUnionFieldNonCompat(*NewBaz()).
        SetAdaptedStructFieldNonCompat(*NewDirectlyAdapted())
}

// Deprecated: Use NewBar().GetStructField() instead.
var Bar_StructField_DEFAULT = NewBar().GetStructField()

// Deprecated: Use NewBar().GetOptionalStructField() instead.
var Bar_OptionalStructField_DEFAULT = NewBar().GetOptionalStructField()

// Deprecated: Use NewBar().GetUnionField() instead.
var Bar_UnionField_DEFAULT = NewBar().GetUnionField()

// Deprecated: Use NewBar().GetOptionalUnionField() instead.
var Bar_OptionalUnionField_DEFAULT = NewBar().GetOptionalUnionField()

// Deprecated: Use NewBar().GetAdaptedStructField() instead.
var Bar_AdaptedStructField_DEFAULT = NewBar().GetAdaptedStructField()

func (x *Bar) GetStructFieldNonCompat() *Foo {
    return x.StructField
}

func (x *Bar) GetStructField() *Foo {
    if !x.IsSetStructField() {
        return NewFoo()
    }

    return x.StructField
}

func (x *Bar) GetOptionalStructFieldNonCompat() *Foo {
    return x.OptionalStructField
}

func (x *Bar) GetOptionalStructField() *Foo {
    if !x.IsSetOptionalStructField() {
        return NewFoo()
    }

    return x.OptionalStructField
}

func (x *Bar) GetStructListFieldNonCompat() []*FooWithAdapter {
    return x.StructListField
}

func (x *Bar) GetStructListField() []*FooWithAdapter {
    if !x.IsSetStructListField() {
        return make([]*FooWithAdapter, 0)
    }

    return x.StructListField
}

func (x *Bar) GetOptionalStructListFieldNonCompat() []*FooWithAdapter {
    return x.OptionalStructListField
}

func (x *Bar) GetOptionalStructListField() []*FooWithAdapter {
    if !x.IsSetOptionalStructListField() {
        return make([]*FooWithAdapter, 0)
    }

    return x.OptionalStructListField
}

func (x *Bar) GetUnionFieldNonCompat() *Baz {
    return x.UnionField
}

func (x *Bar) GetUnionField() *Baz {
    if !x.IsSetUnionField() {
        return NewBaz()
    }

    return x.UnionField
}

func (x *Bar) GetOptionalUnionFieldNonCompat() *Baz {
    return x.OptionalUnionField
}

func (x *Bar) GetOptionalUnionField() *Baz {
    if !x.IsSetOptionalUnionField() {
        return NewBaz()
    }

    return x.OptionalUnionField
}

func (x *Bar) GetAdaptedStructFieldNonCompat() *DirectlyAdapted {
    return x.AdaptedStructField
}

func (x *Bar) GetAdaptedStructField() *DirectlyAdapted {
    if !x.IsSetAdaptedStructField() {
        return NewDirectlyAdapted()
    }

    return x.AdaptedStructField
}

func (x *Bar) SetStructFieldNonCompat(value Foo) *Bar {
    x.StructField = &value
    return x
}

func (x *Bar) SetStructField(value *Foo) *Bar {
    x.StructField = value
    return x
}

func (x *Bar) SetOptionalStructFieldNonCompat(value Foo) *Bar {
    x.OptionalStructField = &value
    return x
}

func (x *Bar) SetOptionalStructField(value *Foo) *Bar {
    x.OptionalStructField = value
    return x
}

func (x *Bar) SetStructListFieldNonCompat(value []*FooWithAdapter) *Bar {
    x.StructListField = value
    return x
}

func (x *Bar) SetStructListField(value []*FooWithAdapter) *Bar {
    x.StructListField = value
    return x
}

func (x *Bar) SetOptionalStructListFieldNonCompat(value []*FooWithAdapter) *Bar {
    x.OptionalStructListField = value
    return x
}

func (x *Bar) SetOptionalStructListField(value []*FooWithAdapter) *Bar {
    x.OptionalStructListField = value
    return x
}

func (x *Bar) SetUnionFieldNonCompat(value Baz) *Bar {
    x.UnionField = &value
    return x
}

func (x *Bar) SetUnionField(value *Baz) *Bar {
    x.UnionField = value
    return x
}

func (x *Bar) SetOptionalUnionFieldNonCompat(value Baz) *Bar {
    x.OptionalUnionField = &value
    return x
}

func (x *Bar) SetOptionalUnionField(value *Baz) *Bar {
    x.OptionalUnionField = value
    return x
}

func (x *Bar) SetAdaptedStructFieldNonCompat(value DirectlyAdapted) *Bar {
    x.AdaptedStructField = &value
    return x
}

func (x *Bar) SetAdaptedStructField(value *DirectlyAdapted) *Bar {
    x.AdaptedStructField = value
    return x
}

func (x *Bar) IsSetStructField() bool {
    return x.StructField != nil
}

func (x *Bar) IsSetOptionalStructField() bool {
    return x.OptionalStructField != nil
}

func (x *Bar) IsSetStructListField() bool {
    return x.StructListField != nil
}

func (x *Bar) IsSetOptionalStructListField() bool {
    return x.OptionalStructListField != nil
}

func (x *Bar) IsSetUnionField() bool {
    return x.UnionField != nil
}

func (x *Bar) IsSetOptionalUnionField() bool {
    return x.OptionalUnionField != nil
}

func (x *Bar) IsSetAdaptedStructField() bool {
    return x.AdaptedStructField != nil
}

func (x *Bar) writeField1(p thrift.Protocol) error {  // StructField
    if !x.IsSetStructField() {
        return nil
    }

    if err := p.WriteFieldBegin("structField", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetStructFieldNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Bar) writeField2(p thrift.Protocol) error {  // OptionalStructField
    if !x.IsSetOptionalStructField() {
        return nil
    }

    if err := p.WriteFieldBegin("optionalStructField", thrift.STRUCT, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetOptionalStructFieldNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Bar) writeField3(p thrift.Protocol) error {  // StructListField
    if !x.IsSetStructListField() {
        return nil
    }

    if err := p.WriteFieldBegin("structListField", thrift.LIST, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetStructListFieldNonCompat()
    if err := p.WriteListBegin(thrift.STRUCT, len(item)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
}
for _, v := range item {
    {
        item := v
        err := WriteFooWithAdapter(item, p)
if err != nil {
    return err
}
    }
}
if err := p.WriteListEnd(); err != nil {
    return thrift.PrependError("error writing list end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Bar) writeField4(p thrift.Protocol) error {  // OptionalStructListField
    if !x.IsSetOptionalStructListField() {
        return nil
    }

    if err := p.WriteFieldBegin("optionalStructListField", thrift.LIST, 4); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetOptionalStructListFieldNonCompat()
    if err := p.WriteListBegin(thrift.STRUCT, len(item)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
}
for _, v := range item {
    {
        item := v
        err := WriteFooWithAdapter(item, p)
if err != nil {
    return err
}
    }
}
if err := p.WriteListEnd(); err != nil {
    return thrift.PrependError("error writing list end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Bar) writeField5(p thrift.Protocol) error {  // UnionField
    if !x.IsSetUnionField() {
        return nil
    }

    if err := p.WriteFieldBegin("unionField", thrift.STRUCT, 5); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetUnionFieldNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Bar) writeField6(p thrift.Protocol) error {  // OptionalUnionField
    if !x.IsSetOptionalUnionField() {
        return nil
    }

    if err := p.WriteFieldBegin("optionalUnionField", thrift.STRUCT, 6); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetOptionalUnionFieldNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Bar) writeField7(p thrift.Protocol) error {  // AdaptedStructField
    if !x.IsSetAdaptedStructField() {
        return nil
    }

    if err := p.WriteFieldBegin("adaptedStructField", thrift.STRUCT, 7); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedStructFieldNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Bar) readField1(p thrift.Protocol) error {  // StructField
    result := *NewFoo()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetStructFieldNonCompat(result)
    return nil
}

func (x *Bar) readField2(p thrift.Protocol) error {  // OptionalStructField
    result := *NewFoo()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetOptionalStructFieldNonCompat(result)
    return nil
}

func (x *Bar) readField3(p thrift.Protocol) error {  // StructListField
    _ /* elemType */, size, err := p.ReadListBegin()
if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
}

listResult := make([]*FooWithAdapter, 0, size)
for i := 0; i < size; i++ {
    var elem FooWithAdapter
    {
        result, err := ReadFooWithAdapter(p)
if err != nil {
    return err
}
        elem = result
    }
    listResult = append(listResult, &elem)
}

if err := p.ReadListEnd(); err != nil {
    return thrift.PrependError("error reading list end: ", err)
}
result := listResult

    x.SetStructListFieldNonCompat(result)
    return nil
}

func (x *Bar) readField4(p thrift.Protocol) error {  // OptionalStructListField
    _ /* elemType */, size, err := p.ReadListBegin()
if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
}

listResult := make([]*FooWithAdapter, 0, size)
for i := 0; i < size; i++ {
    var elem FooWithAdapter
    {
        result, err := ReadFooWithAdapter(p)
if err != nil {
    return err
}
        elem = result
    }
    listResult = append(listResult, &elem)
}

if err := p.ReadListEnd(); err != nil {
    return thrift.PrependError("error reading list end: ", err)
}
result := listResult

    x.SetOptionalStructListFieldNonCompat(result)
    return nil
}

func (x *Bar) readField5(p thrift.Protocol) error {  // UnionField
    result := *NewBaz()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetUnionFieldNonCompat(result)
    return nil
}

func (x *Bar) readField6(p thrift.Protocol) error {  // OptionalUnionField
    result := *NewBaz()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetOptionalUnionFieldNonCompat(result)
    return nil
}

func (x *Bar) readField7(p thrift.Protocol) error {  // AdaptedStructField
    result := *NewDirectlyAdapted()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetAdaptedStructFieldNonCompat(result)
    return nil
}

func (x *Bar) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use Bar.Set* methods instead or set the fields directly.
type BarBuilder struct {
    obj *Bar
}

func NewBarBuilder() *BarBuilder {
    return &BarBuilder{
        obj: NewBar(),
    }
}

func (x *BarBuilder) StructField(value *Foo) *BarBuilder {
    x.obj.StructField = value
    return x
}

func (x *BarBuilder) OptionalStructField(value *Foo) *BarBuilder {
    x.obj.OptionalStructField = value
    return x
}

func (x *BarBuilder) StructListField(value []*FooWithAdapter) *BarBuilder {
    x.obj.StructListField = value
    return x
}

func (x *BarBuilder) OptionalStructListField(value []*FooWithAdapter) *BarBuilder {
    x.obj.OptionalStructListField = value
    return x
}

func (x *BarBuilder) UnionField(value *Baz) *BarBuilder {
    x.obj.UnionField = value
    return x
}

func (x *BarBuilder) OptionalUnionField(value *Baz) *BarBuilder {
    x.obj.OptionalUnionField = value
    return x
}

func (x *BarBuilder) AdaptedStructField(value *DirectlyAdapted) *BarBuilder {
    x.obj.AdaptedStructField = value
    return x
}

func (x *BarBuilder) Emit() *Bar {
    var objCopy Bar = *x.obj
    return &objCopy
}

func (x *Bar) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("Bar"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := x.writeField4(p); err != nil {
        return err
    }

    if err := x.writeField5(p); err != nil {
        return err
    }

    if err := x.writeField6(p); err != nil {
        return err
    }

    if err := x.writeField7(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *Bar) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // structField
            if err := x.readField1(p); err != nil {
                return err
            }
        case 2:  // optionalStructField
            if err := x.readField2(p); err != nil {
                return err
            }
        case 3:  // structListField
            if err := x.readField3(p); err != nil {
                return err
            }
        case 4:  // optionalStructListField
            if err := x.readField4(p); err != nil {
                return err
            }
        case 5:  // unionField
            if err := x.readField5(p); err != nil {
                return err
            }
        case 6:  // optionalUnionField
            if err := x.readField6(p); err != nil {
                return err
            }
        case 7:  // adaptedStructField
            if err := x.readField7(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type DirectlyAdapted struct {
    Field int32 `thrift:"field,1" json:"field" db:"field"`
}
// Compile time interface enforcer
var _ thrift.Struct = &DirectlyAdapted{}

func NewDirectlyAdapted() *DirectlyAdapted {
    return (&DirectlyAdapted{}).
        SetFieldNonCompat(0)
}

func (x *DirectlyAdapted) GetFieldNonCompat() int32 {
    return x.Field
}

func (x *DirectlyAdapted) GetField() int32 {
    return x.Field
}

func (x *DirectlyAdapted) SetFieldNonCompat(value int32) *DirectlyAdapted {
    x.Field = value
    return x
}

func (x *DirectlyAdapted) SetField(value int32) *DirectlyAdapted {
    x.Field = value
    return x
}

func (x *DirectlyAdapted) writeField1(p thrift.Protocol) error {  // Field
    if err := p.WriteFieldBegin("field", thrift.I32, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetFieldNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *DirectlyAdapted) readField1(p thrift.Protocol) error {  // Field
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetFieldNonCompat(result)
    return nil
}

func (x *DirectlyAdapted) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use DirectlyAdapted.Set* methods instead or set the fields directly.
type DirectlyAdaptedBuilder struct {
    obj *DirectlyAdapted
}

func NewDirectlyAdaptedBuilder() *DirectlyAdaptedBuilder {
    return &DirectlyAdaptedBuilder{
        obj: NewDirectlyAdapted(),
    }
}

func (x *DirectlyAdaptedBuilder) Field(value int32) *DirectlyAdaptedBuilder {
    x.obj.Field = value
    return x
}

func (x *DirectlyAdaptedBuilder) Emit() *DirectlyAdapted {
    var objCopy DirectlyAdapted = *x.obj
    return &objCopy
}

func (x *DirectlyAdapted) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("DirectlyAdapted"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *DirectlyAdapted) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // field
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type IndependentDirectlyAdapted struct {
    Field int32 `thrift:"field,1" json:"field" db:"field"`
}
// Compile time interface enforcer
var _ thrift.Struct = &IndependentDirectlyAdapted{}

func NewIndependentDirectlyAdapted() *IndependentDirectlyAdapted {
    return (&IndependentDirectlyAdapted{}).
        SetFieldNonCompat(0)
}

func (x *IndependentDirectlyAdapted) GetFieldNonCompat() int32 {
    return x.Field
}

func (x *IndependentDirectlyAdapted) GetField() int32 {
    return x.Field
}

func (x *IndependentDirectlyAdapted) SetFieldNonCompat(value int32) *IndependentDirectlyAdapted {
    x.Field = value
    return x
}

func (x *IndependentDirectlyAdapted) SetField(value int32) *IndependentDirectlyAdapted {
    x.Field = value
    return x
}

func (x *IndependentDirectlyAdapted) writeField1(p thrift.Protocol) error {  // Field
    if err := p.WriteFieldBegin("field", thrift.I32, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetFieldNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *IndependentDirectlyAdapted) readField1(p thrift.Protocol) error {  // Field
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetFieldNonCompat(result)
    return nil
}

func (x *IndependentDirectlyAdapted) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use IndependentDirectlyAdapted.Set* methods instead or set the fields directly.
type IndependentDirectlyAdaptedBuilder struct {
    obj *IndependentDirectlyAdapted
}

func NewIndependentDirectlyAdaptedBuilder() *IndependentDirectlyAdaptedBuilder {
    return &IndependentDirectlyAdaptedBuilder{
        obj: NewIndependentDirectlyAdapted(),
    }
}

func (x *IndependentDirectlyAdaptedBuilder) Field(value int32) *IndependentDirectlyAdaptedBuilder {
    x.obj.Field = value
    return x
}

func (x *IndependentDirectlyAdaptedBuilder) Emit() *IndependentDirectlyAdapted {
    var objCopy IndependentDirectlyAdapted = *x.obj
    return &objCopy
}

func (x *IndependentDirectlyAdapted) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("IndependentDirectlyAdapted"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *IndependentDirectlyAdapted) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // field
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type StructWithFieldAdapter struct {
    Field int32 `thrift:"field,1" json:"field" db:"field"`
    SharedField int32 `thrift:"shared_field,2" json:"shared_field" db:"shared_field"`
    OptSharedField *int32 `thrift:"opt_shared_field,3,optional" json:"opt_shared_field,omitempty" db:"opt_shared_field"`
    OptBoxedField *int32 `thrift:"opt_boxed_field,4,optional" json:"opt_boxed_field,omitempty" db:"opt_boxed_field"`
}
// Compile time interface enforcer
var _ thrift.Struct = &StructWithFieldAdapter{}

func NewStructWithFieldAdapter() *StructWithFieldAdapter {
    return (&StructWithFieldAdapter{}).
        SetFieldNonCompat(0).
        SetSharedFieldNonCompat(0)
}

// Deprecated: Use NewStructWithFieldAdapter().GetOptSharedField() instead.
var StructWithFieldAdapter_OptSharedField_DEFAULT = NewStructWithFieldAdapter().GetOptSharedField()

// Deprecated: Use NewStructWithFieldAdapter().GetOptBoxedField() instead.
var StructWithFieldAdapter_OptBoxedField_DEFAULT = NewStructWithFieldAdapter().GetOptBoxedField()

func (x *StructWithFieldAdapter) GetFieldNonCompat() int32 {
    return x.Field
}

func (x *StructWithFieldAdapter) GetField() int32 {
    return x.Field
}

func (x *StructWithFieldAdapter) GetSharedFieldNonCompat() int32 {
    return x.SharedField
}

func (x *StructWithFieldAdapter) GetSharedField() int32 {
    return x.SharedField
}

func (x *StructWithFieldAdapter) GetOptSharedFieldNonCompat() *int32 {
    return x.OptSharedField
}

func (x *StructWithFieldAdapter) GetOptSharedField() int32 {
    if !x.IsSetOptSharedField() {
        return 0
    }

    return *x.OptSharedField
}

func (x *StructWithFieldAdapter) GetOptBoxedFieldNonCompat() *int32 {
    return x.OptBoxedField
}

func (x *StructWithFieldAdapter) GetOptBoxedField() int32 {
    if !x.IsSetOptBoxedField() {
        return 0
    }

    return *x.OptBoxedField
}

func (x *StructWithFieldAdapter) SetFieldNonCompat(value int32) *StructWithFieldAdapter {
    x.Field = value
    return x
}

func (x *StructWithFieldAdapter) SetField(value int32) *StructWithFieldAdapter {
    x.Field = value
    return x
}

func (x *StructWithFieldAdapter) SetSharedFieldNonCompat(value int32) *StructWithFieldAdapter {
    x.SharedField = value
    return x
}

func (x *StructWithFieldAdapter) SetSharedField(value int32) *StructWithFieldAdapter {
    x.SharedField = value
    return x
}

func (x *StructWithFieldAdapter) SetOptSharedFieldNonCompat(value int32) *StructWithFieldAdapter {
    x.OptSharedField = &value
    return x
}

func (x *StructWithFieldAdapter) SetOptSharedField(value *int32) *StructWithFieldAdapter {
    x.OptSharedField = value
    return x
}

func (x *StructWithFieldAdapter) SetOptBoxedFieldNonCompat(value int32) *StructWithFieldAdapter {
    x.OptBoxedField = &value
    return x
}

func (x *StructWithFieldAdapter) SetOptBoxedField(value *int32) *StructWithFieldAdapter {
    x.OptBoxedField = value
    return x
}

func (x *StructWithFieldAdapter) IsSetOptSharedField() bool {
    return x.OptSharedField != nil
}

func (x *StructWithFieldAdapter) IsSetOptBoxedField() bool {
    return x.OptBoxedField != nil
}

func (x *StructWithFieldAdapter) writeField1(p thrift.Protocol) error {  // Field
    if err := p.WriteFieldBegin("field", thrift.I32, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetFieldNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *StructWithFieldAdapter) writeField2(p thrift.Protocol) error {  // SharedField
    if err := p.WriteFieldBegin("shared_field", thrift.I32, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetSharedFieldNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *StructWithFieldAdapter) writeField3(p thrift.Protocol) error {  // OptSharedField
    if !x.IsSetOptSharedField() {
        return nil
    }

    if err := p.WriteFieldBegin("opt_shared_field", thrift.I32, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetOptSharedFieldNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *StructWithFieldAdapter) writeField4(p thrift.Protocol) error {  // OptBoxedField
    if !x.IsSetOptBoxedField() {
        return nil
    }

    if err := p.WriteFieldBegin("opt_boxed_field", thrift.I32, 4); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetOptBoxedFieldNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *StructWithFieldAdapter) readField1(p thrift.Protocol) error {  // Field
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetFieldNonCompat(result)
    return nil
}

func (x *StructWithFieldAdapter) readField2(p thrift.Protocol) error {  // SharedField
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetSharedFieldNonCompat(result)
    return nil
}

func (x *StructWithFieldAdapter) readField3(p thrift.Protocol) error {  // OptSharedField
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetOptSharedFieldNonCompat(result)
    return nil
}

func (x *StructWithFieldAdapter) readField4(p thrift.Protocol) error {  // OptBoxedField
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetOptBoxedFieldNonCompat(result)
    return nil
}

func (x *StructWithFieldAdapter) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use StructWithFieldAdapter.Set* methods instead or set the fields directly.
type StructWithFieldAdapterBuilder struct {
    obj *StructWithFieldAdapter
}

func NewStructWithFieldAdapterBuilder() *StructWithFieldAdapterBuilder {
    return &StructWithFieldAdapterBuilder{
        obj: NewStructWithFieldAdapter(),
    }
}

func (x *StructWithFieldAdapterBuilder) Field(value int32) *StructWithFieldAdapterBuilder {
    x.obj.Field = value
    return x
}

func (x *StructWithFieldAdapterBuilder) SharedField(value int32) *StructWithFieldAdapterBuilder {
    x.obj.SharedField = value
    return x
}

func (x *StructWithFieldAdapterBuilder) OptSharedField(value *int32) *StructWithFieldAdapterBuilder {
    x.obj.OptSharedField = value
    return x
}

func (x *StructWithFieldAdapterBuilder) OptBoxedField(value *int32) *StructWithFieldAdapterBuilder {
    x.obj.OptBoxedField = value
    return x
}

func (x *StructWithFieldAdapterBuilder) Emit() *StructWithFieldAdapter {
    var objCopy StructWithFieldAdapter = *x.obj
    return &objCopy
}

func (x *StructWithFieldAdapter) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("StructWithFieldAdapter"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := x.writeField4(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *StructWithFieldAdapter) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // field
            if err := x.readField1(p); err != nil {
                return err
            }
        case 2:  // shared_field
            if err := x.readField2(p); err != nil {
                return err
            }
        case 3:  // opt_shared_field
            if err := x.readField3(p); err != nil {
                return err
            }
        case 4:  // opt_boxed_field
            if err := x.readField4(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type TerseAdaptedFields struct {
    IntField int32 `thrift:"int_field,1" json:"int_field" db:"int_field"`
    StringField string `thrift:"string_field,2" json:"string_field" db:"string_field"`
    SetField []int32 `thrift:"set_field,3" json:"set_field" db:"set_field"`
}
// Compile time interface enforcer
var _ thrift.Struct = &TerseAdaptedFields{}

func NewTerseAdaptedFields() *TerseAdaptedFields {
    return (&TerseAdaptedFields{}).
        SetIntFieldNonCompat(0).
        SetStringFieldNonCompat("").
        SetSetFieldNonCompat(make([]int32, 0))
}

func (x *TerseAdaptedFields) GetIntFieldNonCompat() int32 {
    return x.IntField
}

func (x *TerseAdaptedFields) GetIntField() int32 {
    return x.IntField
}

func (x *TerseAdaptedFields) GetStringFieldNonCompat() string {
    return x.StringField
}

func (x *TerseAdaptedFields) GetStringField() string {
    return x.StringField
}

func (x *TerseAdaptedFields) GetSetFieldNonCompat() []int32 {
    return x.SetField
}

func (x *TerseAdaptedFields) GetSetField() []int32 {
    if !x.IsSetSetField() {
        return make([]int32, 0)
    }

    return x.SetField
}

func (x *TerseAdaptedFields) SetIntFieldNonCompat(value int32) *TerseAdaptedFields {
    x.IntField = value
    return x
}

func (x *TerseAdaptedFields) SetIntField(value int32) *TerseAdaptedFields {
    x.IntField = value
    return x
}

func (x *TerseAdaptedFields) SetStringFieldNonCompat(value string) *TerseAdaptedFields {
    x.StringField = value
    return x
}

func (x *TerseAdaptedFields) SetStringField(value string) *TerseAdaptedFields {
    x.StringField = value
    return x
}

func (x *TerseAdaptedFields) SetSetFieldNonCompat(value []int32) *TerseAdaptedFields {
    x.SetField = value
    return x
}

func (x *TerseAdaptedFields) SetSetField(value []int32) *TerseAdaptedFields {
    x.SetField = value
    return x
}

func (x *TerseAdaptedFields) IsSetSetField() bool {
    return x.SetField != nil
}

func (x *TerseAdaptedFields) writeField1(p thrift.Protocol) error {  // IntField
    if err := p.WriteFieldBegin("int_field", thrift.I32, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetIntFieldNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TerseAdaptedFields) writeField2(p thrift.Protocol) error {  // StringField
    if err := p.WriteFieldBegin("string_field", thrift.STRING, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetStringFieldNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TerseAdaptedFields) writeField3(p thrift.Protocol) error {  // SetField
    if !x.IsSetSetField() {
        return nil
    }

    if err := p.WriteFieldBegin("set_field", thrift.SET, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetSetFieldNonCompat()
    if err := p.WriteSetBegin(thrift.I32, len(item)); err != nil {
    return thrift.PrependError("error writing set begin: ", err)
}
for _, v := range item {
    {
        item := v
        if err := p.WriteI32(item); err != nil {
    return err
}
    }
}
if err := p.WriteSetEnd(); err != nil {
    return thrift.PrependError("error writing set end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *TerseAdaptedFields) readField1(p thrift.Protocol) error {  // IntField
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetIntFieldNonCompat(result)
    return nil
}

func (x *TerseAdaptedFields) readField2(p thrift.Protocol) error {  // StringField
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetStringFieldNonCompat(result)
    return nil
}

func (x *TerseAdaptedFields) readField3(p thrift.Protocol) error {  // SetField
    _ /* elemType */, size, err := p.ReadSetBegin()
if err != nil {
    return thrift.PrependError("error reading set begin: ", err)
}

setResult := make([]int32, 0, size)
for i := 0; i < size; i++ {
    var elem int32
    {
        result, err := p.ReadI32()
if err != nil {
    return err
}
        elem = result
    }
    setResult = append(setResult, elem)
}

if err := p.ReadSetEnd(); err != nil {
    return thrift.PrependError("error reading set end: ", err)
}
result := setResult

    x.SetSetFieldNonCompat(result)
    return nil
}

func (x *TerseAdaptedFields) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use TerseAdaptedFields.Set* methods instead or set the fields directly.
type TerseAdaptedFieldsBuilder struct {
    obj *TerseAdaptedFields
}

func NewTerseAdaptedFieldsBuilder() *TerseAdaptedFieldsBuilder {
    return &TerseAdaptedFieldsBuilder{
        obj: NewTerseAdaptedFields(),
    }
}

func (x *TerseAdaptedFieldsBuilder) IntField(value int32) *TerseAdaptedFieldsBuilder {
    x.obj.IntField = value
    return x
}

func (x *TerseAdaptedFieldsBuilder) StringField(value string) *TerseAdaptedFieldsBuilder {
    x.obj.StringField = value
    return x
}

func (x *TerseAdaptedFieldsBuilder) SetField(value []int32) *TerseAdaptedFieldsBuilder {
    x.obj.SetField = value
    return x
}

func (x *TerseAdaptedFieldsBuilder) Emit() *TerseAdaptedFields {
    var objCopy TerseAdaptedFields = *x.obj
    return &objCopy
}

func (x *TerseAdaptedFields) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("TerseAdaptedFields"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *TerseAdaptedFields) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // int_field
            if err := x.readField1(p); err != nil {
                return err
            }
        case 2:  // string_field
            if err := x.readField2(p); err != nil {
                return err
            }
        case 3:  // set_field
            if err := x.readField3(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type B struct {
    A *AdaptedA `thrift:"a,1" json:"a" db:"a"`
}
// Compile time interface enforcer
var _ thrift.Struct = &B{}

func NewB() *B {
    return (&B{}).
        SetANonCompat(*NewAdaptedA())
}

// Deprecated: Use NewB().GetA() instead.
var B_A_DEFAULT = NewB().GetA()

func (x *B) GetANonCompat() *AdaptedA {
    return x.A
}

func (x *B) GetA() *AdaptedA {
    if !x.IsSetA() {
        return NewAdaptedA()
    }

    return x.A
}

func (x *B) SetANonCompat(value AdaptedA) *B {
    x.A = &value
    return x
}

func (x *B) SetA(value *AdaptedA) *B {
    x.A = value
    return x
}

func (x *B) IsSetA() bool {
    return x.A != nil
}

func (x *B) writeField1(p thrift.Protocol) error {  // A
    if !x.IsSetA() {
        return nil
    }

    if err := p.WriteFieldBegin("a", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetANonCompat()
    err := WriteAdaptedA(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *B) readField1(p thrift.Protocol) error {  // A
    result, err := ReadAdaptedA(p)
if err != nil {
    return err
}

    x.SetANonCompat(result)
    return nil
}

func (x *B) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use B.Set* methods instead or set the fields directly.
type BBuilder struct {
    obj *B
}

func NewBBuilder() *BBuilder {
    return &BBuilder{
        obj: NewB(),
    }
}

func (x *BBuilder) A(value *AdaptedA) *BBuilder {
    x.obj.A = value
    return x
}

func (x *BBuilder) Emit() *B {
    var objCopy B = *x.obj
    return &objCopy
}

func (x *B) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("B"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *B) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // a
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type A struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &A{}

func NewA() *A {
    return (&A{})
}

func (x *A) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use A.Set* methods instead or set the fields directly.
type ABuilder struct {
    obj *A
}

func NewABuilder() *ABuilder {
    return &ABuilder{
        obj: NewA(),
    }
}

func (x *ABuilder) Emit() *A {
    var objCopy A = *x.obj
    return &objCopy
}

func (x *A) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("A"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *A) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type Config struct {
    Path string `thrift:"path,1" json:"path" db:"path"`
}
// Compile time interface enforcer
var _ thrift.Struct = &Config{}

func NewConfig() *Config {
    return (&Config{}).
        SetPathNonCompat("")
}

func (x *Config) GetPathNonCompat() string {
    return x.Path
}

func (x *Config) GetPath() string {
    return x.Path
}

func (x *Config) SetPathNonCompat(value string) *Config {
    x.Path = value
    return x
}

func (x *Config) SetPath(value string) *Config {
    x.Path = value
    return x
}

func (x *Config) writeField1(p thrift.Protocol) error {  // Path
    if err := p.WriteFieldBegin("path", thrift.STRING, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetPathNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Config) readField1(p thrift.Protocol) error {  // Path
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetPathNonCompat(result)
    return nil
}

func (x *Config) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use Config.Set* methods instead or set the fields directly.
type ConfigBuilder struct {
    obj *Config
}

func NewConfigBuilder() *ConfigBuilder {
    return &ConfigBuilder{
        obj: NewConfig(),
    }
}

func (x *ConfigBuilder) Path(value string) *ConfigBuilder {
    x.obj.Path = value
    return x
}

func (x *ConfigBuilder) Emit() *Config {
    var objCopy Config = *x.obj
    return &objCopy
}

func (x *Config) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("Config"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *Config) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // path
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type MyStruct struct {
    Field int32 `thrift:"field,1" json:"field" db:"field"`
    SetString SetWithAdapter `thrift:"set_string,2" json:"set_string" db:"set_string"`
}
// Compile time interface enforcer
var _ thrift.Struct = &MyStruct{}

func NewMyStruct() *MyStruct {
    return (&MyStruct{}).
        SetFieldNonCompat(0).
        SetSetStringNonCompat(NewSetWithAdapter())
}

func (x *MyStruct) GetFieldNonCompat() int32 {
    return x.Field
}

func (x *MyStruct) GetField() int32 {
    return x.Field
}

func (x *MyStruct) GetSetStringNonCompat() SetWithAdapter {
    return x.SetString
}

func (x *MyStruct) GetSetString() SetWithAdapter {
    if !x.IsSetSetString() {
        return NewSetWithAdapter()
    }

    return x.SetString
}

func (x *MyStruct) SetFieldNonCompat(value int32) *MyStruct {
    x.Field = value
    return x
}

func (x *MyStruct) SetField(value int32) *MyStruct {
    x.Field = value
    return x
}

func (x *MyStruct) SetSetStringNonCompat(value SetWithAdapter) *MyStruct {
    x.SetString = value
    return x
}

func (x *MyStruct) SetSetString(value SetWithAdapter) *MyStruct {
    x.SetString = value
    return x
}

func (x *MyStruct) IsSetSetString() bool {
    return x.SetString != nil
}

func (x *MyStruct) writeField1(p thrift.Protocol) error {  // Field
    if err := p.WriteFieldBegin("field", thrift.I32, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetFieldNonCompat()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *MyStruct) writeField2(p thrift.Protocol) error {  // SetString
    if !x.IsSetSetString() {
        return nil
    }

    if err := p.WriteFieldBegin("set_string", thrift.SET, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetSetStringNonCompat()
    err := WriteSetWithAdapter(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *MyStruct) readField1(p thrift.Protocol) error {  // Field
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetFieldNonCompat(result)
    return nil
}

func (x *MyStruct) readField2(p thrift.Protocol) error {  // SetString
    result, err := ReadSetWithAdapter(p)
if err != nil {
    return err
}

    x.SetSetStringNonCompat(result)
    return nil
}

func (x *MyStruct) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use MyStruct.Set* methods instead or set the fields directly.
type MyStructBuilder struct {
    obj *MyStruct
}

func NewMyStructBuilder() *MyStructBuilder {
    return &MyStructBuilder{
        obj: NewMyStruct(),
    }
}

func (x *MyStructBuilder) Field(value int32) *MyStructBuilder {
    x.obj.Field = value
    return x
}

func (x *MyStructBuilder) SetString(value SetWithAdapter) *MyStructBuilder {
    x.obj.SetString = value
    return x
}

func (x *MyStructBuilder) Emit() *MyStruct {
    var objCopy MyStruct = *x.obj
    return &objCopy
}

func (x *MyStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("MyStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *MyStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // field
            if err := x.readField1(p); err != nil {
                return err
            }
        case 2:  // set_string
            if err := x.readField2(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type AdaptTestStruct struct {
    Delay DurationMs `thrift:"delay,1" json:"delay" db:"delay"`
    Custom CustomProtocolType `thrift:"custom,2" json:"custom" db:"custom"`
    Timeout int64 `thrift:"timeout,3" json:"timeout" db:"timeout"`
    Data int64 `thrift:"data,4" json:"data" db:"data"`
    Meta string `thrift:"meta,5" json:"meta" db:"meta"`
    IndirectionString IndirectionString `thrift:"indirectionString,6" json:"indirectionString" db:"indirectionString"`
    StringData string `thrift:"string_data,7" json:"string_data" db:"string_data"`
    DoubleWrappedBool AdaptedBool `thrift:"double_wrapped_bool,8" json:"double_wrapped_bool" db:"double_wrapped_bool"`
    DoubleWrappedInteger AdaptedInteger `thrift:"double_wrapped_integer,9" json:"double_wrapped_integer" db:"double_wrapped_integer"`
    BinaryData []byte `thrift:"binary_data,10" json:"binary_data" db:"binary_data"`
}
// Compile time interface enforcer
var _ thrift.Struct = &AdaptTestStruct{}

func NewAdaptTestStruct() *AdaptTestStruct {
    return (&AdaptTestStruct{}).
        SetDelayNonCompat(NewDurationMs()).
        SetCustomNonCompat(NewCustomProtocolType()).
        SetTimeoutNonCompat(0).
        SetDataNonCompat(0).
        SetMetaNonCompat("").
        SetIndirectionStringNonCompat(NewIndirectionString()).
        SetStringDataNonCompat("").
        SetDoubleWrappedBoolNonCompat(NewAdaptedBool()).
        SetDoubleWrappedIntegerNonCompat(NewAdaptedInteger()).
        SetBinaryDataNonCompat([]byte(""))
}

func (x *AdaptTestStruct) GetDelayNonCompat() DurationMs {
    return x.Delay
}

func (x *AdaptTestStruct) GetDelay() DurationMs {
    return x.Delay
}

func (x *AdaptTestStruct) GetCustomNonCompat() CustomProtocolType {
    return x.Custom
}

func (x *AdaptTestStruct) GetCustom() CustomProtocolType {
    if !x.IsSetCustom() {
        return NewCustomProtocolType()
    }

    return x.Custom
}

func (x *AdaptTestStruct) GetTimeoutNonCompat() int64 {
    return x.Timeout
}

func (x *AdaptTestStruct) GetTimeout() int64 {
    return x.Timeout
}

func (x *AdaptTestStruct) GetDataNonCompat() int64 {
    return x.Data
}

func (x *AdaptTestStruct) GetData() int64 {
    return x.Data
}

func (x *AdaptTestStruct) GetMetaNonCompat() string {
    return x.Meta
}

func (x *AdaptTestStruct) GetMeta() string {
    return x.Meta
}

func (x *AdaptTestStruct) GetIndirectionStringNonCompat() IndirectionString {
    return x.IndirectionString
}

func (x *AdaptTestStruct) GetIndirectionString() IndirectionString {
    return x.IndirectionString
}

func (x *AdaptTestStruct) GetStringDataNonCompat() string {
    return x.StringData
}

func (x *AdaptTestStruct) GetStringData() string {
    return x.StringData
}

func (x *AdaptTestStruct) GetDoubleWrappedBoolNonCompat() AdaptedBool {
    return x.DoubleWrappedBool
}

func (x *AdaptTestStruct) GetDoubleWrappedBool() AdaptedBool {
    return x.DoubleWrappedBool
}

func (x *AdaptTestStruct) GetDoubleWrappedIntegerNonCompat() AdaptedInteger {
    return x.DoubleWrappedInteger
}

func (x *AdaptTestStruct) GetDoubleWrappedInteger() AdaptedInteger {
    return x.DoubleWrappedInteger
}

func (x *AdaptTestStruct) GetBinaryDataNonCompat() []byte {
    return x.BinaryData
}

func (x *AdaptTestStruct) GetBinaryData() []byte {
    if !x.IsSetBinaryData() {
        return []byte("")
    }

    return x.BinaryData
}

func (x *AdaptTestStruct) SetDelayNonCompat(value DurationMs) *AdaptTestStruct {
    x.Delay = value
    return x
}

func (x *AdaptTestStruct) SetDelay(value DurationMs) *AdaptTestStruct {
    x.Delay = value
    return x
}

func (x *AdaptTestStruct) SetCustomNonCompat(value CustomProtocolType) *AdaptTestStruct {
    x.Custom = value
    return x
}

func (x *AdaptTestStruct) SetCustom(value CustomProtocolType) *AdaptTestStruct {
    x.Custom = value
    return x
}

func (x *AdaptTestStruct) SetTimeoutNonCompat(value int64) *AdaptTestStruct {
    x.Timeout = value
    return x
}

func (x *AdaptTestStruct) SetTimeout(value int64) *AdaptTestStruct {
    x.Timeout = value
    return x
}

func (x *AdaptTestStruct) SetDataNonCompat(value int64) *AdaptTestStruct {
    x.Data = value
    return x
}

func (x *AdaptTestStruct) SetData(value int64) *AdaptTestStruct {
    x.Data = value
    return x
}

func (x *AdaptTestStruct) SetMetaNonCompat(value string) *AdaptTestStruct {
    x.Meta = value
    return x
}

func (x *AdaptTestStruct) SetMeta(value string) *AdaptTestStruct {
    x.Meta = value
    return x
}

func (x *AdaptTestStruct) SetIndirectionStringNonCompat(value IndirectionString) *AdaptTestStruct {
    x.IndirectionString = value
    return x
}

func (x *AdaptTestStruct) SetIndirectionString(value IndirectionString) *AdaptTestStruct {
    x.IndirectionString = value
    return x
}

func (x *AdaptTestStruct) SetStringDataNonCompat(value string) *AdaptTestStruct {
    x.StringData = value
    return x
}

func (x *AdaptTestStruct) SetStringData(value string) *AdaptTestStruct {
    x.StringData = value
    return x
}

func (x *AdaptTestStruct) SetDoubleWrappedBoolNonCompat(value AdaptedBool) *AdaptTestStruct {
    x.DoubleWrappedBool = value
    return x
}

func (x *AdaptTestStruct) SetDoubleWrappedBool(value AdaptedBool) *AdaptTestStruct {
    x.DoubleWrappedBool = value
    return x
}

func (x *AdaptTestStruct) SetDoubleWrappedIntegerNonCompat(value AdaptedInteger) *AdaptTestStruct {
    x.DoubleWrappedInteger = value
    return x
}

func (x *AdaptTestStruct) SetDoubleWrappedInteger(value AdaptedInteger) *AdaptTestStruct {
    x.DoubleWrappedInteger = value
    return x
}

func (x *AdaptTestStruct) SetBinaryDataNonCompat(value []byte) *AdaptTestStruct {
    x.BinaryData = value
    return x
}

func (x *AdaptTestStruct) SetBinaryData(value []byte) *AdaptTestStruct {
    x.BinaryData = value
    return x
}

func (x *AdaptTestStruct) IsSetCustom() bool {
    return x.Custom != nil
}

func (x *AdaptTestStruct) IsSetBinaryData() bool {
    return x.BinaryData != nil
}

func (x *AdaptTestStruct) writeField1(p thrift.Protocol) error {  // Delay
    if err := p.WriteFieldBegin("delay", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDelayNonCompat()
    err := WriteDurationMs(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) writeField2(p thrift.Protocol) error {  // Custom
    if !x.IsSetCustom() {
        return nil
    }

    if err := p.WriteFieldBegin("custom", thrift.BINARY, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetCustomNonCompat()
    err := WriteCustomProtocolType(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) writeField3(p thrift.Protocol) error {  // Timeout
    if err := p.WriteFieldBegin("timeout", thrift.I64, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetTimeoutNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) writeField4(p thrift.Protocol) error {  // Data
    if err := p.WriteFieldBegin("data", thrift.I64, 4); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDataNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) writeField5(p thrift.Protocol) error {  // Meta
    if err := p.WriteFieldBegin("meta", thrift.STRING, 5); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetMetaNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) writeField6(p thrift.Protocol) error {  // IndirectionString
    if err := p.WriteFieldBegin("indirectionString", thrift.STRING, 6); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetIndirectionStringNonCompat()
    err := WriteIndirectionString(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) writeField7(p thrift.Protocol) error {  // StringData
    if err := p.WriteFieldBegin("string_data", thrift.STRING, 7); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetStringDataNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) writeField8(p thrift.Protocol) error {  // DoubleWrappedBool
    if err := p.WriteFieldBegin("double_wrapped_bool", thrift.BOOL, 8); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDoubleWrappedBoolNonCompat()
    err := WriteAdaptedBool(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) writeField9(p thrift.Protocol) error {  // DoubleWrappedInteger
    if err := p.WriteFieldBegin("double_wrapped_integer", thrift.I32, 9); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDoubleWrappedIntegerNonCompat()
    err := WriteAdaptedInteger(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) writeField10(p thrift.Protocol) error {  // BinaryData
    if !x.IsSetBinaryData() {
        return nil
    }

    if err := p.WriteFieldBegin("binary_data", thrift.BINARY, 10); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetBinaryDataNonCompat()
    if err := p.WriteBinary(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) readField1(p thrift.Protocol) error {  // Delay
    result, err := ReadDurationMs(p)
if err != nil {
    return err
}

    x.SetDelayNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) readField2(p thrift.Protocol) error {  // Custom
    result, err := ReadCustomProtocolType(p)
if err != nil {
    return err
}

    x.SetCustomNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) readField3(p thrift.Protocol) error {  // Timeout
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetTimeoutNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) readField4(p thrift.Protocol) error {  // Data
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetDataNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) readField5(p thrift.Protocol) error {  // Meta
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetMetaNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) readField6(p thrift.Protocol) error {  // IndirectionString
    result, err := ReadIndirectionString(p)
if err != nil {
    return err
}

    x.SetIndirectionStringNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) readField7(p thrift.Protocol) error {  // StringData
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetStringDataNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) readField8(p thrift.Protocol) error {  // DoubleWrappedBool
    result, err := ReadAdaptedBool(p)
if err != nil {
    return err
}

    x.SetDoubleWrappedBoolNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) readField9(p thrift.Protocol) error {  // DoubleWrappedInteger
    result, err := ReadAdaptedInteger(p)
if err != nil {
    return err
}

    x.SetDoubleWrappedIntegerNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) readField10(p thrift.Protocol) error {  // BinaryData
    result, err := p.ReadBinary()
if err != nil {
    return err
}

    x.SetBinaryDataNonCompat(result)
    return nil
}

func (x *AdaptTestStruct) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use AdaptTestStruct.Set* methods instead or set the fields directly.
type AdaptTestStructBuilder struct {
    obj *AdaptTestStruct
}

func NewAdaptTestStructBuilder() *AdaptTestStructBuilder {
    return &AdaptTestStructBuilder{
        obj: NewAdaptTestStruct(),
    }
}

func (x *AdaptTestStructBuilder) Delay(value DurationMs) *AdaptTestStructBuilder {
    x.obj.Delay = value
    return x
}

func (x *AdaptTestStructBuilder) Custom(value CustomProtocolType) *AdaptTestStructBuilder {
    x.obj.Custom = value
    return x
}

func (x *AdaptTestStructBuilder) Timeout(value int64) *AdaptTestStructBuilder {
    x.obj.Timeout = value
    return x
}

func (x *AdaptTestStructBuilder) Data(value int64) *AdaptTestStructBuilder {
    x.obj.Data = value
    return x
}

func (x *AdaptTestStructBuilder) Meta(value string) *AdaptTestStructBuilder {
    x.obj.Meta = value
    return x
}

func (x *AdaptTestStructBuilder) IndirectionString(value IndirectionString) *AdaptTestStructBuilder {
    x.obj.IndirectionString = value
    return x
}

func (x *AdaptTestStructBuilder) StringData(value string) *AdaptTestStructBuilder {
    x.obj.StringData = value
    return x
}

func (x *AdaptTestStructBuilder) DoubleWrappedBool(value AdaptedBool) *AdaptTestStructBuilder {
    x.obj.DoubleWrappedBool = value
    return x
}

func (x *AdaptTestStructBuilder) DoubleWrappedInteger(value AdaptedInteger) *AdaptTestStructBuilder {
    x.obj.DoubleWrappedInteger = value
    return x
}

func (x *AdaptTestStructBuilder) BinaryData(value []byte) *AdaptTestStructBuilder {
    x.obj.BinaryData = value
    return x
}

func (x *AdaptTestStructBuilder) Emit() *AdaptTestStruct {
    var objCopy AdaptTestStruct = *x.obj
    return &objCopy
}

func (x *AdaptTestStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("AdaptTestStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := x.writeField4(p); err != nil {
        return err
    }

    if err := x.writeField5(p); err != nil {
        return err
    }

    if err := x.writeField6(p); err != nil {
        return err
    }

    if err := x.writeField7(p); err != nil {
        return err
    }

    if err := x.writeField8(p); err != nil {
        return err
    }

    if err := x.writeField9(p); err != nil {
        return err
    }

    if err := x.writeField10(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // delay
            if err := x.readField1(p); err != nil {
                return err
            }
        case 2:  // custom
            if err := x.readField2(p); err != nil {
                return err
            }
        case 3:  // timeout
            if err := x.readField3(p); err != nil {
                return err
            }
        case 4:  // data
            if err := x.readField4(p); err != nil {
                return err
            }
        case 5:  // meta
            if err := x.readField5(p); err != nil {
                return err
            }
        case 6:  // indirectionString
            if err := x.readField6(p); err != nil {
                return err
            }
        case 7:  // string_data
            if err := x.readField7(p); err != nil {
                return err
            }
        case 8:  // double_wrapped_bool
            if err := x.readField8(p); err != nil {
                return err
            }
        case 9:  // double_wrapped_integer
            if err := x.readField9(p); err != nil {
                return err
            }
        case 10:  // binary_data
            if err := x.readField10(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type AdaptTemplatedTestStruct struct {
    AdaptedBool AdaptedBool `thrift:"adaptedBool,1" json:"adaptedBool" db:"adaptedBool"`
    AdaptedByte AdaptedByte `thrift:"adaptedByte,2" json:"adaptedByte" db:"adaptedByte"`
    AdaptedShort AdaptedShort `thrift:"adaptedShort,3" json:"adaptedShort" db:"adaptedShort"`
    AdaptedInteger AdaptedInteger `thrift:"adaptedInteger,4" json:"adaptedInteger" db:"adaptedInteger"`
    AdaptedLong AdaptedLong `thrift:"adaptedLong,5" json:"adaptedLong" db:"adaptedLong"`
    AdaptedDouble AdaptedDouble `thrift:"adaptedDouble,6" json:"adaptedDouble" db:"adaptedDouble"`
    AdaptedString AdaptedString `thrift:"adaptedString,7" json:"adaptedString" db:"adaptedString"`
    AdaptedList []int64 `thrift:"adaptedList,8" json:"adaptedList" db:"adaptedList"`
    AdaptedSet []int64 `thrift:"adaptedSet,9" json:"adaptedSet" db:"adaptedSet"`
    AdaptedMap map[int64]int64 `thrift:"adaptedMap,10" json:"adaptedMap" db:"adaptedMap"`
    AdaptedBoolDefault AdaptedBool `thrift:"adaptedBoolDefault,11" json:"adaptedBoolDefault" db:"adaptedBoolDefault"`
    AdaptedByteDefault AdaptedByte `thrift:"adaptedByteDefault,12" json:"adaptedByteDefault" db:"adaptedByteDefault"`
    AdaptedShortDefault AdaptedShort `thrift:"adaptedShortDefault,13" json:"adaptedShortDefault" db:"adaptedShortDefault"`
    AdaptedIntegerDefault AdaptedInteger `thrift:"adaptedIntegerDefault,14" json:"adaptedIntegerDefault" db:"adaptedIntegerDefault"`
    AdaptedLongDefault AdaptedLong `thrift:"adaptedLongDefault,15" json:"adaptedLongDefault" db:"adaptedLongDefault"`
    AdaptedDoubleDefault AdaptedDouble `thrift:"adaptedDoubleDefault,16" json:"adaptedDoubleDefault" db:"adaptedDoubleDefault"`
    AdaptedStringDefault AdaptedString `thrift:"adaptedStringDefault,17" json:"adaptedStringDefault" db:"adaptedStringDefault"`
    AdaptedEnum AdaptedEnum `thrift:"adaptedEnum,18" json:"adaptedEnum" db:"adaptedEnum"`
    AdaptedListDefault []int64 `thrift:"adaptedListDefault,19" json:"adaptedListDefault" db:"adaptedListDefault"`
    AdaptedSetDefault []int64 `thrift:"adaptedSetDefault,20" json:"adaptedSetDefault" db:"adaptedSetDefault"`
    AdaptedMapDefault map[int64]int64 `thrift:"adaptedMapDefault,21" json:"adaptedMapDefault" db:"adaptedMapDefault"`
    DoubleTypedefBool DoubleTypedefBool `thrift:"doubleTypedefBool,22" json:"doubleTypedefBool" db:"doubleTypedefBool"`
}
// Compile time interface enforcer
var _ thrift.Struct = &AdaptTemplatedTestStruct{}

func NewAdaptTemplatedTestStruct() *AdaptTemplatedTestStruct {
    return (&AdaptTemplatedTestStruct{}).
        SetAdaptedBoolNonCompat(NewAdaptedBool()).
        SetAdaptedByteNonCompat(NewAdaptedByte()).
        SetAdaptedShortNonCompat(NewAdaptedShort()).
        SetAdaptedIntegerNonCompat(NewAdaptedInteger()).
        SetAdaptedLongNonCompat(NewAdaptedLong()).
        SetAdaptedDoubleNonCompat(NewAdaptedDouble()).
        SetAdaptedStringNonCompat(NewAdaptedString()).
        SetAdaptedListNonCompat(make([]int64, 0)).
        SetAdaptedSetNonCompat(make([]int64, 0)).
        SetAdaptedMapNonCompat(make(map[int64]int64)).
        SetAdaptedBoolDefaultNonCompat(true).
        SetAdaptedByteDefaultNonCompat(1).
        SetAdaptedShortDefaultNonCompat(2).
        SetAdaptedIntegerDefaultNonCompat(3).
        SetAdaptedLongDefaultNonCompat(4).
        SetAdaptedDoubleDefaultNonCompat(5.0).
        SetAdaptedStringDefaultNonCompat("6").
        SetAdaptedEnumNonCompat(
              ThriftAdaptedEnum_One,
          ).
        SetAdaptedListDefaultNonCompat(
              []int64{
    1,
},
          ).
        SetAdaptedSetDefaultNonCompat(
              []int64{
    1,
},
          ).
        SetAdaptedMapDefaultNonCompat(
              map[int64]int64{
    1: 1,
},
          ).
        SetDoubleTypedefBoolNonCompat(NewDoubleTypedefBool())
}

func (x *AdaptTemplatedTestStruct) GetAdaptedBoolNonCompat() AdaptedBool {
    return x.AdaptedBool
}

func (x *AdaptTemplatedTestStruct) GetAdaptedBool() AdaptedBool {
    return x.AdaptedBool
}

func (x *AdaptTemplatedTestStruct) GetAdaptedByteNonCompat() AdaptedByte {
    return x.AdaptedByte
}

func (x *AdaptTemplatedTestStruct) GetAdaptedByte() AdaptedByte {
    return x.AdaptedByte
}

func (x *AdaptTemplatedTestStruct) GetAdaptedShortNonCompat() AdaptedShort {
    return x.AdaptedShort
}

func (x *AdaptTemplatedTestStruct) GetAdaptedShort() AdaptedShort {
    return x.AdaptedShort
}

func (x *AdaptTemplatedTestStruct) GetAdaptedIntegerNonCompat() AdaptedInteger {
    return x.AdaptedInteger
}

func (x *AdaptTemplatedTestStruct) GetAdaptedInteger() AdaptedInteger {
    return x.AdaptedInteger
}

func (x *AdaptTemplatedTestStruct) GetAdaptedLongNonCompat() AdaptedLong {
    return x.AdaptedLong
}

func (x *AdaptTemplatedTestStruct) GetAdaptedLong() AdaptedLong {
    return x.AdaptedLong
}

func (x *AdaptTemplatedTestStruct) GetAdaptedDoubleNonCompat() AdaptedDouble {
    return x.AdaptedDouble
}

func (x *AdaptTemplatedTestStruct) GetAdaptedDouble() AdaptedDouble {
    return x.AdaptedDouble
}

func (x *AdaptTemplatedTestStruct) GetAdaptedStringNonCompat() AdaptedString {
    return x.AdaptedString
}

func (x *AdaptTemplatedTestStruct) GetAdaptedString() AdaptedString {
    return x.AdaptedString
}

func (x *AdaptTemplatedTestStruct) GetAdaptedListNonCompat() []int64 {
    return x.AdaptedList
}

func (x *AdaptTemplatedTestStruct) GetAdaptedList() []int64 {
    if !x.IsSetAdaptedList() {
        return make([]int64, 0)
    }

    return x.AdaptedList
}

func (x *AdaptTemplatedTestStruct) GetAdaptedSetNonCompat() []int64 {
    return x.AdaptedSet
}

func (x *AdaptTemplatedTestStruct) GetAdaptedSet() []int64 {
    if !x.IsSetAdaptedSet() {
        return make([]int64, 0)
    }

    return x.AdaptedSet
}

func (x *AdaptTemplatedTestStruct) GetAdaptedMapNonCompat() map[int64]int64 {
    return x.AdaptedMap
}

func (x *AdaptTemplatedTestStruct) GetAdaptedMap() map[int64]int64 {
    if !x.IsSetAdaptedMap() {
        return make(map[int64]int64)
    }

    return x.AdaptedMap
}

func (x *AdaptTemplatedTestStruct) GetAdaptedBoolDefaultNonCompat() AdaptedBool {
    return x.AdaptedBoolDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedBoolDefault() AdaptedBool {
    return x.AdaptedBoolDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedByteDefaultNonCompat() AdaptedByte {
    return x.AdaptedByteDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedByteDefault() AdaptedByte {
    return x.AdaptedByteDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedShortDefaultNonCompat() AdaptedShort {
    return x.AdaptedShortDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedShortDefault() AdaptedShort {
    return x.AdaptedShortDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedIntegerDefaultNonCompat() AdaptedInteger {
    return x.AdaptedIntegerDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedIntegerDefault() AdaptedInteger {
    return x.AdaptedIntegerDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedLongDefaultNonCompat() AdaptedLong {
    return x.AdaptedLongDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedLongDefault() AdaptedLong {
    return x.AdaptedLongDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedDoubleDefaultNonCompat() AdaptedDouble {
    return x.AdaptedDoubleDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedDoubleDefault() AdaptedDouble {
    return x.AdaptedDoubleDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedStringDefaultNonCompat() AdaptedString {
    return x.AdaptedStringDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedStringDefault() AdaptedString {
    return x.AdaptedStringDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedEnumNonCompat() AdaptedEnum {
    return x.AdaptedEnum
}

func (x *AdaptTemplatedTestStruct) GetAdaptedEnum() AdaptedEnum {
    return x.AdaptedEnum
}

func (x *AdaptTemplatedTestStruct) GetAdaptedListDefaultNonCompat() []int64 {
    return x.AdaptedListDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedListDefault() []int64 {
    if !x.IsSetAdaptedListDefault() {
        return make([]int64, 0)
    }

    return x.AdaptedListDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedSetDefaultNonCompat() []int64 {
    return x.AdaptedSetDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedSetDefault() []int64 {
    if !x.IsSetAdaptedSetDefault() {
        return make([]int64, 0)
    }

    return x.AdaptedSetDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedMapDefaultNonCompat() map[int64]int64 {
    return x.AdaptedMapDefault
}

func (x *AdaptTemplatedTestStruct) GetAdaptedMapDefault() map[int64]int64 {
    if !x.IsSetAdaptedMapDefault() {
        return make(map[int64]int64)
    }

    return x.AdaptedMapDefault
}

func (x *AdaptTemplatedTestStruct) GetDoubleTypedefBoolNonCompat() DoubleTypedefBool {
    return x.DoubleTypedefBool
}

func (x *AdaptTemplatedTestStruct) GetDoubleTypedefBool() DoubleTypedefBool {
    return x.DoubleTypedefBool
}

func (x *AdaptTemplatedTestStruct) SetAdaptedBoolNonCompat(value AdaptedBool) *AdaptTemplatedTestStruct {
    x.AdaptedBool = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedBool(value AdaptedBool) *AdaptTemplatedTestStruct {
    x.AdaptedBool = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedByteNonCompat(value AdaptedByte) *AdaptTemplatedTestStruct {
    x.AdaptedByte = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedByte(value AdaptedByte) *AdaptTemplatedTestStruct {
    x.AdaptedByte = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedShortNonCompat(value AdaptedShort) *AdaptTemplatedTestStruct {
    x.AdaptedShort = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedShort(value AdaptedShort) *AdaptTemplatedTestStruct {
    x.AdaptedShort = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedIntegerNonCompat(value AdaptedInteger) *AdaptTemplatedTestStruct {
    x.AdaptedInteger = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedInteger(value AdaptedInteger) *AdaptTemplatedTestStruct {
    x.AdaptedInteger = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedLongNonCompat(value AdaptedLong) *AdaptTemplatedTestStruct {
    x.AdaptedLong = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedLong(value AdaptedLong) *AdaptTemplatedTestStruct {
    x.AdaptedLong = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedDoubleNonCompat(value AdaptedDouble) *AdaptTemplatedTestStruct {
    x.AdaptedDouble = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedDouble(value AdaptedDouble) *AdaptTemplatedTestStruct {
    x.AdaptedDouble = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedStringNonCompat(value AdaptedString) *AdaptTemplatedTestStruct {
    x.AdaptedString = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedString(value AdaptedString) *AdaptTemplatedTestStruct {
    x.AdaptedString = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedListNonCompat(value []int64) *AdaptTemplatedTestStruct {
    x.AdaptedList = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedList(value []int64) *AdaptTemplatedTestStruct {
    x.AdaptedList = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedSetNonCompat(value []int64) *AdaptTemplatedTestStruct {
    x.AdaptedSet = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedSet(value []int64) *AdaptTemplatedTestStruct {
    x.AdaptedSet = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedMapNonCompat(value map[int64]int64) *AdaptTemplatedTestStruct {
    x.AdaptedMap = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedMap(value map[int64]int64) *AdaptTemplatedTestStruct {
    x.AdaptedMap = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedBoolDefaultNonCompat(value AdaptedBool) *AdaptTemplatedTestStruct {
    x.AdaptedBoolDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedBoolDefault(value AdaptedBool) *AdaptTemplatedTestStruct {
    x.AdaptedBoolDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedByteDefaultNonCompat(value AdaptedByte) *AdaptTemplatedTestStruct {
    x.AdaptedByteDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedByteDefault(value AdaptedByte) *AdaptTemplatedTestStruct {
    x.AdaptedByteDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedShortDefaultNonCompat(value AdaptedShort) *AdaptTemplatedTestStruct {
    x.AdaptedShortDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedShortDefault(value AdaptedShort) *AdaptTemplatedTestStruct {
    x.AdaptedShortDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedIntegerDefaultNonCompat(value AdaptedInteger) *AdaptTemplatedTestStruct {
    x.AdaptedIntegerDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedIntegerDefault(value AdaptedInteger) *AdaptTemplatedTestStruct {
    x.AdaptedIntegerDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedLongDefaultNonCompat(value AdaptedLong) *AdaptTemplatedTestStruct {
    x.AdaptedLongDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedLongDefault(value AdaptedLong) *AdaptTemplatedTestStruct {
    x.AdaptedLongDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedDoubleDefaultNonCompat(value AdaptedDouble) *AdaptTemplatedTestStruct {
    x.AdaptedDoubleDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedDoubleDefault(value AdaptedDouble) *AdaptTemplatedTestStruct {
    x.AdaptedDoubleDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedStringDefaultNonCompat(value AdaptedString) *AdaptTemplatedTestStruct {
    x.AdaptedStringDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedStringDefault(value AdaptedString) *AdaptTemplatedTestStruct {
    x.AdaptedStringDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedEnumNonCompat(value AdaptedEnum) *AdaptTemplatedTestStruct {
    x.AdaptedEnum = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedEnum(value AdaptedEnum) *AdaptTemplatedTestStruct {
    x.AdaptedEnum = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedListDefaultNonCompat(value []int64) *AdaptTemplatedTestStruct {
    x.AdaptedListDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedListDefault(value []int64) *AdaptTemplatedTestStruct {
    x.AdaptedListDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedSetDefaultNonCompat(value []int64) *AdaptTemplatedTestStruct {
    x.AdaptedSetDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedSetDefault(value []int64) *AdaptTemplatedTestStruct {
    x.AdaptedSetDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedMapDefaultNonCompat(value map[int64]int64) *AdaptTemplatedTestStruct {
    x.AdaptedMapDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetAdaptedMapDefault(value map[int64]int64) *AdaptTemplatedTestStruct {
    x.AdaptedMapDefault = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetDoubleTypedefBoolNonCompat(value DoubleTypedefBool) *AdaptTemplatedTestStruct {
    x.DoubleTypedefBool = value
    return x
}

func (x *AdaptTemplatedTestStruct) SetDoubleTypedefBool(value DoubleTypedefBool) *AdaptTemplatedTestStruct {
    x.DoubleTypedefBool = value
    return x
}

func (x *AdaptTemplatedTestStruct) IsSetAdaptedList() bool {
    return x.AdaptedList != nil
}

func (x *AdaptTemplatedTestStruct) IsSetAdaptedSet() bool {
    return x.AdaptedSet != nil
}

func (x *AdaptTemplatedTestStruct) IsSetAdaptedMap() bool {
    return x.AdaptedMap != nil
}

func (x *AdaptTemplatedTestStruct) IsSetAdaptedListDefault() bool {
    return x.AdaptedListDefault != nil
}

func (x *AdaptTemplatedTestStruct) IsSetAdaptedSetDefault() bool {
    return x.AdaptedSetDefault != nil
}

func (x *AdaptTemplatedTestStruct) IsSetAdaptedMapDefault() bool {
    return x.AdaptedMapDefault != nil
}

func (x *AdaptTemplatedTestStruct) writeField1(p thrift.Protocol) error {  // AdaptedBool
    if err := p.WriteFieldBegin("adaptedBool", thrift.BOOL, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedBoolNonCompat()
    err := WriteAdaptedBool(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField2(p thrift.Protocol) error {  // AdaptedByte
    if err := p.WriteFieldBegin("adaptedByte", thrift.BYTE, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedByteNonCompat()
    err := WriteAdaptedByte(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField3(p thrift.Protocol) error {  // AdaptedShort
    if err := p.WriteFieldBegin("adaptedShort", thrift.I16, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedShortNonCompat()
    err := WriteAdaptedShort(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField4(p thrift.Protocol) error {  // AdaptedInteger
    if err := p.WriteFieldBegin("adaptedInteger", thrift.I32, 4); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedIntegerNonCompat()
    err := WriteAdaptedInteger(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField5(p thrift.Protocol) error {  // AdaptedLong
    if err := p.WriteFieldBegin("adaptedLong", thrift.I64, 5); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedLongNonCompat()
    err := WriteAdaptedLong(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField6(p thrift.Protocol) error {  // AdaptedDouble
    if err := p.WriteFieldBegin("adaptedDouble", thrift.DOUBLE, 6); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedDoubleNonCompat()
    err := WriteAdaptedDouble(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField7(p thrift.Protocol) error {  // AdaptedString
    if err := p.WriteFieldBegin("adaptedString", thrift.STRING, 7); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedStringNonCompat()
    err := WriteAdaptedString(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField8(p thrift.Protocol) error {  // AdaptedList
    if !x.IsSetAdaptedList() {
        return nil
    }

    if err := p.WriteFieldBegin("adaptedList", thrift.LIST, 8); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedListNonCompat()
    if err := p.WriteListBegin(thrift.I64, len(item)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
}
for _, v := range item {
    {
        item := v
        if err := p.WriteI64(item); err != nil {
    return err
}
    }
}
if err := p.WriteListEnd(); err != nil {
    return thrift.PrependError("error writing list end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField9(p thrift.Protocol) error {  // AdaptedSet
    if !x.IsSetAdaptedSet() {
        return nil
    }

    if err := p.WriteFieldBegin("adaptedSet", thrift.SET, 9); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedSetNonCompat()
    if err := p.WriteSetBegin(thrift.I64, len(item)); err != nil {
    return thrift.PrependError("error writing set begin: ", err)
}
for _, v := range item {
    {
        item := v
        if err := p.WriteI64(item); err != nil {
    return err
}
    }
}
if err := p.WriteSetEnd(); err != nil {
    return thrift.PrependError("error writing set end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField10(p thrift.Protocol) error {  // AdaptedMap
    if !x.IsSetAdaptedMap() {
        return nil
    }

    if err := p.WriteFieldBegin("adaptedMap", thrift.MAP, 10); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedMapNonCompat()
    if err := p.WriteMapBegin(thrift.I64, thrift.I64, len(item)); err != nil {
    return thrift.PrependError("error writing map begin: ", err)
}
for k, v := range item {
    {
        item := k
        if err := p.WriteI64(item); err != nil {
    return err
}
    }

    {
        item := v
        if err := p.WriteI64(item); err != nil {
    return err
}
    }
}
if err := p.WriteMapEnd(); err != nil {
    return thrift.PrependError("error writing map end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField11(p thrift.Protocol) error {  // AdaptedBoolDefault
    if err := p.WriteFieldBegin("adaptedBoolDefault", thrift.BOOL, 11); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedBoolDefaultNonCompat()
    err := WriteAdaptedBool(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField12(p thrift.Protocol) error {  // AdaptedByteDefault
    if err := p.WriteFieldBegin("adaptedByteDefault", thrift.BYTE, 12); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedByteDefaultNonCompat()
    err := WriteAdaptedByte(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField13(p thrift.Protocol) error {  // AdaptedShortDefault
    if err := p.WriteFieldBegin("adaptedShortDefault", thrift.I16, 13); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedShortDefaultNonCompat()
    err := WriteAdaptedShort(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField14(p thrift.Protocol) error {  // AdaptedIntegerDefault
    if err := p.WriteFieldBegin("adaptedIntegerDefault", thrift.I32, 14); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedIntegerDefaultNonCompat()
    err := WriteAdaptedInteger(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField15(p thrift.Protocol) error {  // AdaptedLongDefault
    if err := p.WriteFieldBegin("adaptedLongDefault", thrift.I64, 15); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedLongDefaultNonCompat()
    err := WriteAdaptedLong(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField16(p thrift.Protocol) error {  // AdaptedDoubleDefault
    if err := p.WriteFieldBegin("adaptedDoubleDefault", thrift.DOUBLE, 16); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedDoubleDefaultNonCompat()
    err := WriteAdaptedDouble(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField17(p thrift.Protocol) error {  // AdaptedStringDefault
    if err := p.WriteFieldBegin("adaptedStringDefault", thrift.STRING, 17); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedStringDefaultNonCompat()
    err := WriteAdaptedString(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField18(p thrift.Protocol) error {  // AdaptedEnum
    if err := p.WriteFieldBegin("adaptedEnum", thrift.I32, 18); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedEnumNonCompat()
    err := WriteAdaptedEnum(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField19(p thrift.Protocol) error {  // AdaptedListDefault
    if !x.IsSetAdaptedListDefault() {
        return nil
    }

    if err := p.WriteFieldBegin("adaptedListDefault", thrift.LIST, 19); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedListDefaultNonCompat()
    if err := p.WriteListBegin(thrift.I64, len(item)); err != nil {
    return thrift.PrependError("error writing list begin: ", err)
}
for _, v := range item {
    {
        item := v
        if err := p.WriteI64(item); err != nil {
    return err
}
    }
}
if err := p.WriteListEnd(); err != nil {
    return thrift.PrependError("error writing list end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField20(p thrift.Protocol) error {  // AdaptedSetDefault
    if !x.IsSetAdaptedSetDefault() {
        return nil
    }

    if err := p.WriteFieldBegin("adaptedSetDefault", thrift.SET, 20); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedSetDefaultNonCompat()
    if err := p.WriteSetBegin(thrift.I64, len(item)); err != nil {
    return thrift.PrependError("error writing set begin: ", err)
}
for _, v := range item {
    {
        item := v
        if err := p.WriteI64(item); err != nil {
    return err
}
    }
}
if err := p.WriteSetEnd(); err != nil {
    return thrift.PrependError("error writing set end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField21(p thrift.Protocol) error {  // AdaptedMapDefault
    if !x.IsSetAdaptedMapDefault() {
        return nil
    }

    if err := p.WriteFieldBegin("adaptedMapDefault", thrift.MAP, 21); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedMapDefaultNonCompat()
    if err := p.WriteMapBegin(thrift.I64, thrift.I64, len(item)); err != nil {
    return thrift.PrependError("error writing map begin: ", err)
}
for k, v := range item {
    {
        item := k
        if err := p.WriteI64(item); err != nil {
    return err
}
    }

    {
        item := v
        if err := p.WriteI64(item); err != nil {
    return err
}
    }
}
if err := p.WriteMapEnd(); err != nil {
    return thrift.PrependError("error writing map end: ", err)
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) writeField22(p thrift.Protocol) error {  // DoubleTypedefBool
    if err := p.WriteFieldBegin("doubleTypedefBool", thrift.BOOL, 22); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDoubleTypedefBoolNonCompat()
    err := WriteDoubleTypedefBool(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) readField1(p thrift.Protocol) error {  // AdaptedBool
    result, err := ReadAdaptedBool(p)
if err != nil {
    return err
}

    x.SetAdaptedBoolNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField2(p thrift.Protocol) error {  // AdaptedByte
    result, err := ReadAdaptedByte(p)
if err != nil {
    return err
}

    x.SetAdaptedByteNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField3(p thrift.Protocol) error {  // AdaptedShort
    result, err := ReadAdaptedShort(p)
if err != nil {
    return err
}

    x.SetAdaptedShortNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField4(p thrift.Protocol) error {  // AdaptedInteger
    result, err := ReadAdaptedInteger(p)
if err != nil {
    return err
}

    x.SetAdaptedIntegerNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField5(p thrift.Protocol) error {  // AdaptedLong
    result, err := ReadAdaptedLong(p)
if err != nil {
    return err
}

    x.SetAdaptedLongNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField6(p thrift.Protocol) error {  // AdaptedDouble
    result, err := ReadAdaptedDouble(p)
if err != nil {
    return err
}

    x.SetAdaptedDoubleNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField7(p thrift.Protocol) error {  // AdaptedString
    result, err := ReadAdaptedString(p)
if err != nil {
    return err
}

    x.SetAdaptedStringNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField8(p thrift.Protocol) error {  // AdaptedList
    _ /* elemType */, size, err := p.ReadListBegin()
if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
}

listResult := make([]int64, 0, size)
for i := 0; i < size; i++ {
    var elem int64
    {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        elem = result
    }
    listResult = append(listResult, elem)
}

if err := p.ReadListEnd(); err != nil {
    return thrift.PrependError("error reading list end: ", err)
}
result := listResult

    x.SetAdaptedListNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField9(p thrift.Protocol) error {  // AdaptedSet
    _ /* elemType */, size, err := p.ReadSetBegin()
if err != nil {
    return thrift.PrependError("error reading set begin: ", err)
}

setResult := make([]int64, 0, size)
for i := 0; i < size; i++ {
    var elem int64
    {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        elem = result
    }
    setResult = append(setResult, elem)
}

if err := p.ReadSetEnd(); err != nil {
    return thrift.PrependError("error reading set end: ", err)
}
result := setResult

    x.SetAdaptedSetNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField10(p thrift.Protocol) error {  // AdaptedMap
    _ /* keyType */, _ /* valueType */, size, err := p.ReadMapBegin()
if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
}

mapResult := make(map[int64]int64, size)
for i := 0; i < size; i++ {
    var key int64
    {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        key = result
    }

    var value int64
    {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        value = result
    }

    mapResult[key] = value
}

if err := p.ReadMapEnd(); err != nil {
    return thrift.PrependError("error reading map end: ", err)
}
result := mapResult

    x.SetAdaptedMapNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField11(p thrift.Protocol) error {  // AdaptedBoolDefault
    result, err := ReadAdaptedBool(p)
if err != nil {
    return err
}

    x.SetAdaptedBoolDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField12(p thrift.Protocol) error {  // AdaptedByteDefault
    result, err := ReadAdaptedByte(p)
if err != nil {
    return err
}

    x.SetAdaptedByteDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField13(p thrift.Protocol) error {  // AdaptedShortDefault
    result, err := ReadAdaptedShort(p)
if err != nil {
    return err
}

    x.SetAdaptedShortDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField14(p thrift.Protocol) error {  // AdaptedIntegerDefault
    result, err := ReadAdaptedInteger(p)
if err != nil {
    return err
}

    x.SetAdaptedIntegerDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField15(p thrift.Protocol) error {  // AdaptedLongDefault
    result, err := ReadAdaptedLong(p)
if err != nil {
    return err
}

    x.SetAdaptedLongDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField16(p thrift.Protocol) error {  // AdaptedDoubleDefault
    result, err := ReadAdaptedDouble(p)
if err != nil {
    return err
}

    x.SetAdaptedDoubleDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField17(p thrift.Protocol) error {  // AdaptedStringDefault
    result, err := ReadAdaptedString(p)
if err != nil {
    return err
}

    x.SetAdaptedStringDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField18(p thrift.Protocol) error {  // AdaptedEnum
    result, err := ReadAdaptedEnum(p)
if err != nil {
    return err
}

    x.SetAdaptedEnumNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField19(p thrift.Protocol) error {  // AdaptedListDefault
    _ /* elemType */, size, err := p.ReadListBegin()
if err != nil {
    return thrift.PrependError("error reading list begin: ", err)
}

listResult := make([]int64, 0, size)
for i := 0; i < size; i++ {
    var elem int64
    {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        elem = result
    }
    listResult = append(listResult, elem)
}

if err := p.ReadListEnd(); err != nil {
    return thrift.PrependError("error reading list end: ", err)
}
result := listResult

    x.SetAdaptedListDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField20(p thrift.Protocol) error {  // AdaptedSetDefault
    _ /* elemType */, size, err := p.ReadSetBegin()
if err != nil {
    return thrift.PrependError("error reading set begin: ", err)
}

setResult := make([]int64, 0, size)
for i := 0; i < size; i++ {
    var elem int64
    {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        elem = result
    }
    setResult = append(setResult, elem)
}

if err := p.ReadSetEnd(); err != nil {
    return thrift.PrependError("error reading set end: ", err)
}
result := setResult

    x.SetAdaptedSetDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField21(p thrift.Protocol) error {  // AdaptedMapDefault
    _ /* keyType */, _ /* valueType */, size, err := p.ReadMapBegin()
if err != nil {
    return thrift.PrependError("error reading map begin: ", err)
}

mapResult := make(map[int64]int64, size)
for i := 0; i < size; i++ {
    var key int64
    {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        key = result
    }

    var value int64
    {
        result, err := p.ReadI64()
if err != nil {
    return err
}
        value = result
    }

    mapResult[key] = value
}

if err := p.ReadMapEnd(); err != nil {
    return thrift.PrependError("error reading map end: ", err)
}
result := mapResult

    x.SetAdaptedMapDefaultNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) readField22(p thrift.Protocol) error {  // DoubleTypedefBool
    result, err := ReadDoubleTypedefBool(p)
if err != nil {
    return err
}

    x.SetDoubleTypedefBoolNonCompat(result)
    return nil
}

func (x *AdaptTemplatedTestStruct) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use AdaptTemplatedTestStruct.Set* methods instead or set the fields directly.
type AdaptTemplatedTestStructBuilder struct {
    obj *AdaptTemplatedTestStruct
}

func NewAdaptTemplatedTestStructBuilder() *AdaptTemplatedTestStructBuilder {
    return &AdaptTemplatedTestStructBuilder{
        obj: NewAdaptTemplatedTestStruct(),
    }
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedBool(value AdaptedBool) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedBool = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedByte(value AdaptedByte) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedByte = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedShort(value AdaptedShort) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedShort = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedInteger(value AdaptedInteger) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedInteger = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedLong(value AdaptedLong) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedLong = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedDouble(value AdaptedDouble) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedDouble = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedString(value AdaptedString) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedString = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedList(value []int64) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedList = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedSet(value []int64) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedSet = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedMap(value map[int64]int64) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedMap = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedBoolDefault(value AdaptedBool) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedBoolDefault = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedByteDefault(value AdaptedByte) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedByteDefault = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedShortDefault(value AdaptedShort) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedShortDefault = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedIntegerDefault(value AdaptedInteger) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedIntegerDefault = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedLongDefault(value AdaptedLong) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedLongDefault = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedDoubleDefault(value AdaptedDouble) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedDoubleDefault = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedStringDefault(value AdaptedString) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedStringDefault = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedEnum(value AdaptedEnum) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedEnum = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedListDefault(value []int64) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedListDefault = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedSetDefault(value []int64) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedSetDefault = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) AdaptedMapDefault(value map[int64]int64) *AdaptTemplatedTestStructBuilder {
    x.obj.AdaptedMapDefault = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) DoubleTypedefBool(value DoubleTypedefBool) *AdaptTemplatedTestStructBuilder {
    x.obj.DoubleTypedefBool = value
    return x
}

func (x *AdaptTemplatedTestStructBuilder) Emit() *AdaptTemplatedTestStruct {
    var objCopy AdaptTemplatedTestStruct = *x.obj
    return &objCopy
}

func (x *AdaptTemplatedTestStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("AdaptTemplatedTestStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := x.writeField4(p); err != nil {
        return err
    }

    if err := x.writeField5(p); err != nil {
        return err
    }

    if err := x.writeField6(p); err != nil {
        return err
    }

    if err := x.writeField7(p); err != nil {
        return err
    }

    if err := x.writeField8(p); err != nil {
        return err
    }

    if err := x.writeField9(p); err != nil {
        return err
    }

    if err := x.writeField10(p); err != nil {
        return err
    }

    if err := x.writeField11(p); err != nil {
        return err
    }

    if err := x.writeField12(p); err != nil {
        return err
    }

    if err := x.writeField13(p); err != nil {
        return err
    }

    if err := x.writeField14(p); err != nil {
        return err
    }

    if err := x.writeField15(p); err != nil {
        return err
    }

    if err := x.writeField16(p); err != nil {
        return err
    }

    if err := x.writeField17(p); err != nil {
        return err
    }

    if err := x.writeField18(p); err != nil {
        return err
    }

    if err := x.writeField19(p); err != nil {
        return err
    }

    if err := x.writeField20(p); err != nil {
        return err
    }

    if err := x.writeField21(p); err != nil {
        return err
    }

    if err := x.writeField22(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedTestStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // adaptedBool
            if err := x.readField1(p); err != nil {
                return err
            }
        case 2:  // adaptedByte
            if err := x.readField2(p); err != nil {
                return err
            }
        case 3:  // adaptedShort
            if err := x.readField3(p); err != nil {
                return err
            }
        case 4:  // adaptedInteger
            if err := x.readField4(p); err != nil {
                return err
            }
        case 5:  // adaptedLong
            if err := x.readField5(p); err != nil {
                return err
            }
        case 6:  // adaptedDouble
            if err := x.readField6(p); err != nil {
                return err
            }
        case 7:  // adaptedString
            if err := x.readField7(p); err != nil {
                return err
            }
        case 8:  // adaptedList
            if err := x.readField8(p); err != nil {
                return err
            }
        case 9:  // adaptedSet
            if err := x.readField9(p); err != nil {
                return err
            }
        case 10:  // adaptedMap
            if err := x.readField10(p); err != nil {
                return err
            }
        case 11:  // adaptedBoolDefault
            if err := x.readField11(p); err != nil {
                return err
            }
        case 12:  // adaptedByteDefault
            if err := x.readField12(p); err != nil {
                return err
            }
        case 13:  // adaptedShortDefault
            if err := x.readField13(p); err != nil {
                return err
            }
        case 14:  // adaptedIntegerDefault
            if err := x.readField14(p); err != nil {
                return err
            }
        case 15:  // adaptedLongDefault
            if err := x.readField15(p); err != nil {
                return err
            }
        case 16:  // adaptedDoubleDefault
            if err := x.readField16(p); err != nil {
                return err
            }
        case 17:  // adaptedStringDefault
            if err := x.readField17(p); err != nil {
                return err
            }
        case 18:  // adaptedEnum
            if err := x.readField18(p); err != nil {
                return err
            }
        case 19:  // adaptedListDefault
            if err := x.readField19(p); err != nil {
                return err
            }
        case 20:  // adaptedSetDefault
            if err := x.readField20(p); err != nil {
                return err
            }
        case 21:  // adaptedMapDefault
            if err := x.readField21(p); err != nil {
                return err
            }
        case 22:  // doubleTypedefBool
            if err := x.readField22(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type AdaptTemplatedNestedTestStruct struct {
    AdaptedStruct *AdaptTemplatedTestStruct `thrift:"adaptedStruct,1" json:"adaptedStruct" db:"adaptedStruct"`
}
// Compile time interface enforcer
var _ thrift.Struct = &AdaptTemplatedNestedTestStruct{}

func NewAdaptTemplatedNestedTestStruct() *AdaptTemplatedNestedTestStruct {
    return (&AdaptTemplatedNestedTestStruct{}).
        SetAdaptedStructNonCompat(*NewAdaptTemplatedTestStruct())
}

// Deprecated: Use NewAdaptTemplatedNestedTestStruct().GetAdaptedStruct() instead.
var AdaptTemplatedNestedTestStruct_AdaptedStruct_DEFAULT = NewAdaptTemplatedNestedTestStruct().GetAdaptedStruct()

func (x *AdaptTemplatedNestedTestStruct) GetAdaptedStructNonCompat() *AdaptTemplatedTestStruct {
    return x.AdaptedStruct
}

func (x *AdaptTemplatedNestedTestStruct) GetAdaptedStruct() *AdaptTemplatedTestStruct {
    if !x.IsSetAdaptedStruct() {
        return NewAdaptTemplatedTestStruct()
    }

    return x.AdaptedStruct
}

func (x *AdaptTemplatedNestedTestStruct) SetAdaptedStructNonCompat(value AdaptTemplatedTestStruct) *AdaptTemplatedNestedTestStruct {
    x.AdaptedStruct = &value
    return x
}

func (x *AdaptTemplatedNestedTestStruct) SetAdaptedStruct(value *AdaptTemplatedTestStruct) *AdaptTemplatedNestedTestStruct {
    x.AdaptedStruct = value
    return x
}

func (x *AdaptTemplatedNestedTestStruct) IsSetAdaptedStruct() bool {
    return x.AdaptedStruct != nil
}

func (x *AdaptTemplatedNestedTestStruct) writeField1(p thrift.Protocol) error {  // AdaptedStruct
    if !x.IsSetAdaptedStruct() {
        return nil
    }

    if err := p.WriteFieldBegin("adaptedStruct", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedStructNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedNestedTestStruct) readField1(p thrift.Protocol) error {  // AdaptedStruct
    result := *NewAdaptTemplatedTestStruct()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetAdaptedStructNonCompat(result)
    return nil
}

func (x *AdaptTemplatedNestedTestStruct) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use AdaptTemplatedNestedTestStruct.Set* methods instead or set the fields directly.
type AdaptTemplatedNestedTestStructBuilder struct {
    obj *AdaptTemplatedNestedTestStruct
}

func NewAdaptTemplatedNestedTestStructBuilder() *AdaptTemplatedNestedTestStructBuilder {
    return &AdaptTemplatedNestedTestStructBuilder{
        obj: NewAdaptTemplatedNestedTestStruct(),
    }
}

func (x *AdaptTemplatedNestedTestStructBuilder) AdaptedStruct(value *AdaptTemplatedTestStruct) *AdaptTemplatedNestedTestStructBuilder {
    x.obj.AdaptedStruct = value
    return x
}

func (x *AdaptTemplatedNestedTestStructBuilder) Emit() *AdaptTemplatedNestedTestStruct {
    var objCopy AdaptTemplatedNestedTestStruct = *x.obj
    return &objCopy
}

func (x *AdaptTemplatedNestedTestStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("AdaptTemplatedNestedTestStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *AdaptTemplatedNestedTestStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // adaptedStruct
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type AdaptTestUnion struct {
    Delay *DurationMs `thrift:"delay,1" json:"delay" db:"delay"`
    Custom CustomProtocolType `thrift:"custom,2" json:"custom" db:"custom"`
}
// Compile time interface enforcer
var _ thrift.Struct = &AdaptTestUnion{}

func NewAdaptTestUnion() *AdaptTestUnion {
    return (&AdaptTestUnion{}).
        SetDelayNonCompat(NewDurationMs()).
        SetCustomNonCompat(NewCustomProtocolType())
}

// Deprecated: Use NewAdaptTestUnion().GetDelay() instead.
var AdaptTestUnion_Delay_DEFAULT = NewAdaptTestUnion().GetDelay()

func (x *AdaptTestUnion) GetDelayNonCompat() *DurationMs {
    return x.Delay
}

func (x *AdaptTestUnion) GetDelay() DurationMs {
    if !x.IsSetDelay() {
        return NewDurationMs()
    }

    return *x.Delay
}

func (x *AdaptTestUnion) GetCustomNonCompat() CustomProtocolType {
    return x.Custom
}

func (x *AdaptTestUnion) GetCustom() CustomProtocolType {
    if !x.IsSetCustom() {
        return NewCustomProtocolType()
    }

    return x.Custom
}

func (x *AdaptTestUnion) SetDelayNonCompat(value DurationMs) *AdaptTestUnion {
    x.Delay = &value
    return x
}

func (x *AdaptTestUnion) SetDelay(value *DurationMs) *AdaptTestUnion {
    x.Delay = value
    return x
}

func (x *AdaptTestUnion) SetCustomNonCompat(value CustomProtocolType) *AdaptTestUnion {
    x.Custom = value
    return x
}

func (x *AdaptTestUnion) SetCustom(value CustomProtocolType) *AdaptTestUnion {
    x.Custom = value
    return x
}

func (x *AdaptTestUnion) IsSetDelay() bool {
    return x.Delay != nil
}

func (x *AdaptTestUnion) IsSetCustom() bool {
    return x.Custom != nil
}

func (x *AdaptTestUnion) writeField1(p thrift.Protocol) error {  // Delay
    if !x.IsSetDelay() {
        return nil
    }

    if err := p.WriteFieldBegin("delay", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetDelayNonCompat()
    err := WriteDurationMs(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestUnion) writeField2(p thrift.Protocol) error {  // Custom
    if !x.IsSetCustom() {
        return nil
    }

    if err := p.WriteFieldBegin("custom", thrift.BINARY, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetCustomNonCompat()
    err := WriteCustomProtocolType(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestUnion) readField1(p thrift.Protocol) error {  // Delay
    result, err := ReadDurationMs(p)
if err != nil {
    return err
}

    x.SetDelayNonCompat(result)
    return nil
}

func (x *AdaptTestUnion) readField2(p thrift.Protocol) error {  // Custom
    result, err := ReadCustomProtocolType(p)
if err != nil {
    return err
}

    x.SetCustomNonCompat(result)
    return nil
}

func (x *AdaptTestUnion) String() string {
    return fmt.Sprintf("%+v", x)
}

func (x *AdaptTestUnion) countSetFields() int {
    count := int(0)
    if (x.IsSetDelay()) {
        count++
    }
    if (x.IsSetCustom()) {
        count++
    }
    return count
}


// Deprecated: Use AdaptTestUnion.Set* methods instead or set the fields directly.
type AdaptTestUnionBuilder struct {
    obj *AdaptTestUnion
}

func NewAdaptTestUnionBuilder() *AdaptTestUnionBuilder {
    return &AdaptTestUnionBuilder{
        obj: NewAdaptTestUnion(),
    }
}

func (x *AdaptTestUnionBuilder) Delay(value *DurationMs) *AdaptTestUnionBuilder {
    x.obj.Delay = value
    return x
}

func (x *AdaptTestUnionBuilder) Custom(value CustomProtocolType) *AdaptTestUnionBuilder {
    x.obj.Custom = value
    return x
}

func (x *AdaptTestUnionBuilder) Emit() *AdaptTestUnion {
    var objCopy AdaptTestUnion = *x.obj
    return &objCopy
}

func (x *AdaptTestUnion) Write(p thrift.Protocol) error {
    if countSet := x.countSetFields(); countSet > 1 {
        return fmt.Errorf("%T write union: no more than one field must be set (%d set).", x, countSet)
    }
    if err := p.WriteStructBegin("AdaptTestUnion"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *AdaptTestUnion) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // delay
            if err := x.readField1(p); err != nil {
                return err
            }
        case 2:  // custom
            if err := x.readField2(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type AdaptedStruct struct {
    Data int64 `thrift:"data,1" json:"data" db:"data"`
}
// Compile time interface enforcer
var _ thrift.Struct = &AdaptedStruct{}

func NewAdaptedStruct() *AdaptedStruct {
    return (&AdaptedStruct{}).
        SetDataNonCompat(0)
}

func (x *AdaptedStruct) GetDataNonCompat() int64 {
    return x.Data
}

func (x *AdaptedStruct) GetData() int64 {
    return x.Data
}

func (x *AdaptedStruct) SetDataNonCompat(value int64) *AdaptedStruct {
    x.Data = value
    return x
}

func (x *AdaptedStruct) SetData(value int64) *AdaptedStruct {
    x.Data = value
    return x
}

func (x *AdaptedStruct) writeField1(p thrift.Protocol) error {  // Data
    if err := p.WriteFieldBegin("data", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDataNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AdaptedStruct) readField1(p thrift.Protocol) error {  // Data
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetDataNonCompat(result)
    return nil
}

func (x *AdaptedStruct) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use AdaptedStruct.Set* methods instead or set the fields directly.
type AdaptedStructBuilder struct {
    obj *AdaptedStruct
}

func NewAdaptedStructBuilder() *AdaptedStructBuilder {
    return &AdaptedStructBuilder{
        obj: NewAdaptedStruct(),
    }
}

func (x *AdaptedStructBuilder) Data(value int64) *AdaptedStructBuilder {
    x.obj.Data = value
    return x
}

func (x *AdaptedStructBuilder) Emit() *AdaptedStruct {
    var objCopy AdaptedStruct = *x.obj
    return &objCopy
}

func (x *AdaptedStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("AdaptedStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *AdaptedStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // data
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type DirectlyAdaptedStruct struct {
    Data int64 `thrift:"data,1" json:"data" db:"data"`
}
// Compile time interface enforcer
var _ thrift.Struct = &DirectlyAdaptedStruct{}

func NewDirectlyAdaptedStruct() *DirectlyAdaptedStruct {
    return (&DirectlyAdaptedStruct{}).
        SetDataNonCompat(0)
}

func (x *DirectlyAdaptedStruct) GetDataNonCompat() int64 {
    return x.Data
}

func (x *DirectlyAdaptedStruct) GetData() int64 {
    return x.Data
}

func (x *DirectlyAdaptedStruct) SetDataNonCompat(value int64) *DirectlyAdaptedStruct {
    x.Data = value
    return x
}

func (x *DirectlyAdaptedStruct) SetData(value int64) *DirectlyAdaptedStruct {
    x.Data = value
    return x
}

func (x *DirectlyAdaptedStruct) writeField1(p thrift.Protocol) error {  // Data
    if err := p.WriteFieldBegin("data", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDataNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *DirectlyAdaptedStruct) readField1(p thrift.Protocol) error {  // Data
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetDataNonCompat(result)
    return nil
}

func (x *DirectlyAdaptedStruct) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use DirectlyAdaptedStruct.Set* methods instead or set the fields directly.
type DirectlyAdaptedStructBuilder struct {
    obj *DirectlyAdaptedStruct
}

func NewDirectlyAdaptedStructBuilder() *DirectlyAdaptedStructBuilder {
    return &DirectlyAdaptedStructBuilder{
        obj: NewDirectlyAdaptedStruct(),
    }
}

func (x *DirectlyAdaptedStructBuilder) Data(value int64) *DirectlyAdaptedStructBuilder {
    x.obj.Data = value
    return x
}

func (x *DirectlyAdaptedStructBuilder) Emit() *DirectlyAdaptedStruct {
    var objCopy DirectlyAdaptedStruct = *x.obj
    return &objCopy
}

func (x *DirectlyAdaptedStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("DirectlyAdaptedStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *DirectlyAdaptedStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // data
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type StructFieldAdaptedStruct struct {
    AdaptedStruct *AdaptedStruct `thrift:"adaptedStruct,1" json:"adaptedStruct" db:"adaptedStruct"`
    AdaptedTypedef *AdaptedTypedef `thrift:"adaptedTypedef,2" json:"adaptedTypedef" db:"adaptedTypedef"`
    DirectlyAdapted *DirectlyAdaptedStruct `thrift:"directlyAdapted,3" json:"directlyAdapted" db:"directlyAdapted"`
    TypedefOfAdapted *TypedefOfDirect `thrift:"typedefOfAdapted,4" json:"typedefOfAdapted" db:"typedefOfAdapted"`
}
// Compile time interface enforcer
var _ thrift.Struct = &StructFieldAdaptedStruct{}

func NewStructFieldAdaptedStruct() *StructFieldAdaptedStruct {
    return (&StructFieldAdaptedStruct{}).
        SetAdaptedStructNonCompat(*NewAdaptedStruct()).
        SetAdaptedTypedefNonCompat(*NewAdaptedTypedef()).
        SetDirectlyAdaptedNonCompat(*NewDirectlyAdaptedStruct()).
        SetTypedefOfAdaptedNonCompat(*NewTypedefOfDirect())
}

// Deprecated: Use NewStructFieldAdaptedStruct().GetAdaptedStruct() instead.
var StructFieldAdaptedStruct_AdaptedStruct_DEFAULT = NewStructFieldAdaptedStruct().GetAdaptedStruct()

// Deprecated: Use NewStructFieldAdaptedStruct().GetAdaptedTypedef() instead.
var StructFieldAdaptedStruct_AdaptedTypedef_DEFAULT = NewStructFieldAdaptedStruct().GetAdaptedTypedef()

// Deprecated: Use NewStructFieldAdaptedStruct().GetDirectlyAdapted() instead.
var StructFieldAdaptedStruct_DirectlyAdapted_DEFAULT = NewStructFieldAdaptedStruct().GetDirectlyAdapted()

// Deprecated: Use NewStructFieldAdaptedStruct().GetTypedefOfAdapted() instead.
var StructFieldAdaptedStruct_TypedefOfAdapted_DEFAULT = NewStructFieldAdaptedStruct().GetTypedefOfAdapted()

func (x *StructFieldAdaptedStruct) GetAdaptedStructNonCompat() *AdaptedStruct {
    return x.AdaptedStruct
}

func (x *StructFieldAdaptedStruct) GetAdaptedStruct() *AdaptedStruct {
    if !x.IsSetAdaptedStruct() {
        return NewAdaptedStruct()
    }

    return x.AdaptedStruct
}

func (x *StructFieldAdaptedStruct) GetAdaptedTypedefNonCompat() *AdaptedTypedef {
    return x.AdaptedTypedef
}

func (x *StructFieldAdaptedStruct) GetAdaptedTypedef() *AdaptedTypedef {
    if !x.IsSetAdaptedTypedef() {
        return NewAdaptedTypedef()
    }

    return x.AdaptedTypedef
}

func (x *StructFieldAdaptedStruct) GetDirectlyAdaptedNonCompat() *DirectlyAdaptedStruct {
    return x.DirectlyAdapted
}

func (x *StructFieldAdaptedStruct) GetDirectlyAdapted() *DirectlyAdaptedStruct {
    if !x.IsSetDirectlyAdapted() {
        return NewDirectlyAdaptedStruct()
    }

    return x.DirectlyAdapted
}

func (x *StructFieldAdaptedStruct) GetTypedefOfAdaptedNonCompat() *TypedefOfDirect {
    return x.TypedefOfAdapted
}

func (x *StructFieldAdaptedStruct) GetTypedefOfAdapted() *TypedefOfDirect {
    if !x.IsSetTypedefOfAdapted() {
        return NewTypedefOfDirect()
    }

    return x.TypedefOfAdapted
}

func (x *StructFieldAdaptedStruct) SetAdaptedStructNonCompat(value AdaptedStruct) *StructFieldAdaptedStruct {
    x.AdaptedStruct = &value
    return x
}

func (x *StructFieldAdaptedStruct) SetAdaptedStruct(value *AdaptedStruct) *StructFieldAdaptedStruct {
    x.AdaptedStruct = value
    return x
}

func (x *StructFieldAdaptedStruct) SetAdaptedTypedefNonCompat(value AdaptedTypedef) *StructFieldAdaptedStruct {
    x.AdaptedTypedef = &value
    return x
}

func (x *StructFieldAdaptedStruct) SetAdaptedTypedef(value *AdaptedTypedef) *StructFieldAdaptedStruct {
    x.AdaptedTypedef = value
    return x
}

func (x *StructFieldAdaptedStruct) SetDirectlyAdaptedNonCompat(value DirectlyAdaptedStruct) *StructFieldAdaptedStruct {
    x.DirectlyAdapted = &value
    return x
}

func (x *StructFieldAdaptedStruct) SetDirectlyAdapted(value *DirectlyAdaptedStruct) *StructFieldAdaptedStruct {
    x.DirectlyAdapted = value
    return x
}

func (x *StructFieldAdaptedStruct) SetTypedefOfAdaptedNonCompat(value TypedefOfDirect) *StructFieldAdaptedStruct {
    x.TypedefOfAdapted = &value
    return x
}

func (x *StructFieldAdaptedStruct) SetTypedefOfAdapted(value *TypedefOfDirect) *StructFieldAdaptedStruct {
    x.TypedefOfAdapted = value
    return x
}

func (x *StructFieldAdaptedStruct) IsSetAdaptedStruct() bool {
    return x.AdaptedStruct != nil
}

func (x *StructFieldAdaptedStruct) IsSetAdaptedTypedef() bool {
    return x.AdaptedTypedef != nil
}

func (x *StructFieldAdaptedStruct) IsSetDirectlyAdapted() bool {
    return x.DirectlyAdapted != nil
}

func (x *StructFieldAdaptedStruct) IsSetTypedefOfAdapted() bool {
    return x.TypedefOfAdapted != nil
}

func (x *StructFieldAdaptedStruct) writeField1(p thrift.Protocol) error {  // AdaptedStruct
    if !x.IsSetAdaptedStruct() {
        return nil
    }

    if err := p.WriteFieldBegin("adaptedStruct", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedStructNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *StructFieldAdaptedStruct) writeField2(p thrift.Protocol) error {  // AdaptedTypedef
    if !x.IsSetAdaptedTypedef() {
        return nil
    }

    if err := p.WriteFieldBegin("adaptedTypedef", thrift.STRUCT, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetAdaptedTypedefNonCompat()
    err := WriteAdaptedTypedef(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *StructFieldAdaptedStruct) writeField3(p thrift.Protocol) error {  // DirectlyAdapted
    if !x.IsSetDirectlyAdapted() {
        return nil
    }

    if err := p.WriteFieldBegin("directlyAdapted", thrift.STRUCT, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDirectlyAdaptedNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *StructFieldAdaptedStruct) writeField4(p thrift.Protocol) error {  // TypedefOfAdapted
    if !x.IsSetTypedefOfAdapted() {
        return nil
    }

    if err := p.WriteFieldBegin("typedefOfAdapted", thrift.STRUCT, 4); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetTypedefOfAdaptedNonCompat()
    err := WriteTypedefOfDirect(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *StructFieldAdaptedStruct) readField1(p thrift.Protocol) error {  // AdaptedStruct
    result := *NewAdaptedStruct()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetAdaptedStructNonCompat(result)
    return nil
}

func (x *StructFieldAdaptedStruct) readField2(p thrift.Protocol) error {  // AdaptedTypedef
    result, err := ReadAdaptedTypedef(p)
if err != nil {
    return err
}

    x.SetAdaptedTypedefNonCompat(result)
    return nil
}

func (x *StructFieldAdaptedStruct) readField3(p thrift.Protocol) error {  // DirectlyAdapted
    result := *NewDirectlyAdaptedStruct()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetDirectlyAdaptedNonCompat(result)
    return nil
}

func (x *StructFieldAdaptedStruct) readField4(p thrift.Protocol) error {  // TypedefOfAdapted
    result, err := ReadTypedefOfDirect(p)
if err != nil {
    return err
}

    x.SetTypedefOfAdaptedNonCompat(result)
    return nil
}

func (x *StructFieldAdaptedStruct) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use StructFieldAdaptedStruct.Set* methods instead or set the fields directly.
type StructFieldAdaptedStructBuilder struct {
    obj *StructFieldAdaptedStruct
}

func NewStructFieldAdaptedStructBuilder() *StructFieldAdaptedStructBuilder {
    return &StructFieldAdaptedStructBuilder{
        obj: NewStructFieldAdaptedStruct(),
    }
}

func (x *StructFieldAdaptedStructBuilder) AdaptedStruct(value *AdaptedStruct) *StructFieldAdaptedStructBuilder {
    x.obj.AdaptedStruct = value
    return x
}

func (x *StructFieldAdaptedStructBuilder) AdaptedTypedef(value *AdaptedTypedef) *StructFieldAdaptedStructBuilder {
    x.obj.AdaptedTypedef = value
    return x
}

func (x *StructFieldAdaptedStructBuilder) DirectlyAdapted(value *DirectlyAdaptedStruct) *StructFieldAdaptedStructBuilder {
    x.obj.DirectlyAdapted = value
    return x
}

func (x *StructFieldAdaptedStructBuilder) TypedefOfAdapted(value *TypedefOfDirect) *StructFieldAdaptedStructBuilder {
    x.obj.TypedefOfAdapted = value
    return x
}

func (x *StructFieldAdaptedStructBuilder) Emit() *StructFieldAdaptedStruct {
    var objCopy StructFieldAdaptedStruct = *x.obj
    return &objCopy
}

func (x *StructFieldAdaptedStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("StructFieldAdaptedStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := x.writeField4(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *StructFieldAdaptedStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // adaptedStruct
            if err := x.readField1(p); err != nil {
                return err
            }
        case 2:  // adaptedTypedef
            if err := x.readField2(p); err != nil {
                return err
            }
        case 3:  // directlyAdapted
            if err := x.readField3(p); err != nil {
                return err
            }
        case 4:  // typedefOfAdapted
            if err := x.readField4(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type CircularAdaptee struct {
    Field *CircularStruct `thrift:"field,1" json:"field" db:"field"`
}
// Compile time interface enforcer
var _ thrift.Struct = &CircularAdaptee{}

func NewCircularAdaptee() *CircularAdaptee {
    return (&CircularAdaptee{}).
        SetFieldNonCompat(*NewCircularStruct())
}

// Deprecated: Use NewCircularAdaptee().GetField() instead.
var CircularAdaptee_Field_DEFAULT = NewCircularAdaptee().GetField()

func (x *CircularAdaptee) GetFieldNonCompat() *CircularStruct {
    return x.Field
}

func (x *CircularAdaptee) GetField() *CircularStruct {
    if !x.IsSetField() {
        return NewCircularStruct()
    }

    return x.Field
}

func (x *CircularAdaptee) SetFieldNonCompat(value CircularStruct) *CircularAdaptee {
    x.Field = &value
    return x
}

func (x *CircularAdaptee) SetField(value *CircularStruct) *CircularAdaptee {
    x.Field = value
    return x
}

func (x *CircularAdaptee) IsSetField() bool {
    return x.Field != nil
}

func (x *CircularAdaptee) writeField1(p thrift.Protocol) error {  // Field
    if !x.IsSetField() {
        return nil
    }

    if err := p.WriteFieldBegin("field", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetFieldNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *CircularAdaptee) readField1(p thrift.Protocol) error {  // Field
    result := *NewCircularStruct()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetFieldNonCompat(result)
    return nil
}

func (x *CircularAdaptee) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use CircularAdaptee.Set* methods instead or set the fields directly.
type CircularAdapteeBuilder struct {
    obj *CircularAdaptee
}

func NewCircularAdapteeBuilder() *CircularAdapteeBuilder {
    return &CircularAdapteeBuilder{
        obj: NewCircularAdaptee(),
    }
}

func (x *CircularAdapteeBuilder) Field(value *CircularStruct) *CircularAdapteeBuilder {
    x.obj.Field = value
    return x
}

func (x *CircularAdapteeBuilder) Emit() *CircularAdaptee {
    var objCopy CircularAdaptee = *x.obj
    return &objCopy
}

func (x *CircularAdaptee) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("CircularAdaptee"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *CircularAdaptee) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // field
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type CircularStruct struct {
    Field *AdaptedCircularAdaptee `thrift:"field,1,optional" json:"field,omitempty" db:"field"`
}
// Compile time interface enforcer
var _ thrift.Struct = &CircularStruct{}

func NewCircularStruct() *CircularStruct {
    return (&CircularStruct{})
}

// Deprecated: Use NewCircularStruct().GetField() instead.
var CircularStruct_Field_DEFAULT = NewCircularStruct().GetField()

func (x *CircularStruct) GetFieldNonCompat() *AdaptedCircularAdaptee {
    return x.Field
}

func (x *CircularStruct) GetField() *AdaptedCircularAdaptee {
    if !x.IsSetField() {
        return NewAdaptedCircularAdaptee()
    }

    return x.Field
}

func (x *CircularStruct) SetFieldNonCompat(value AdaptedCircularAdaptee) *CircularStruct {
    x.Field = &value
    return x
}

func (x *CircularStruct) SetField(value *AdaptedCircularAdaptee) *CircularStruct {
    x.Field = value
    return x
}

func (x *CircularStruct) IsSetField() bool {
    return x.Field != nil
}

func (x *CircularStruct) writeField1(p thrift.Protocol) error {  // Field
    if !x.IsSetField() {
        return nil
    }

    if err := p.WriteFieldBegin("field", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetFieldNonCompat()
    err := WriteAdaptedCircularAdaptee(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *CircularStruct) readField1(p thrift.Protocol) error {  // Field
    result, err := ReadAdaptedCircularAdaptee(p)
if err != nil {
    return err
}

    x.SetFieldNonCompat(result)
    return nil
}

func (x *CircularStruct) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use CircularStruct.Set* methods instead or set the fields directly.
type CircularStructBuilder struct {
    obj *CircularStruct
}

func NewCircularStructBuilder() *CircularStructBuilder {
    return &CircularStructBuilder{
        obj: NewCircularStruct(),
    }
}

func (x *CircularStructBuilder) Field(value *AdaptedCircularAdaptee) *CircularStructBuilder {
    x.obj.Field = value
    return x
}

func (x *CircularStructBuilder) Emit() *CircularStruct {
    var objCopy CircularStruct = *x.obj
    return &objCopy
}

func (x *CircularStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("CircularStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *CircularStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // field
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type ReorderedStruct struct {
    ReorderedDependentAdapted *DeclaredAfterStruct `thrift:"reordered_dependent_adapted,1" json:"reordered_dependent_adapted" db:"reordered_dependent_adapted"`
}
// Compile time interface enforcer
var _ thrift.Struct = &ReorderedStruct{}

func NewReorderedStruct() *ReorderedStruct {
    return (&ReorderedStruct{}).
        SetReorderedDependentAdaptedNonCompat(*NewDeclaredAfterStruct())
}

// Deprecated: Use NewReorderedStruct().GetReorderedDependentAdapted() instead.
var ReorderedStruct_ReorderedDependentAdapted_DEFAULT = NewReorderedStruct().GetReorderedDependentAdapted()

func (x *ReorderedStruct) GetReorderedDependentAdaptedNonCompat() *DeclaredAfterStruct {
    return x.ReorderedDependentAdapted
}

func (x *ReorderedStruct) GetReorderedDependentAdapted() *DeclaredAfterStruct {
    if !x.IsSetReorderedDependentAdapted() {
        return NewDeclaredAfterStruct()
    }

    return x.ReorderedDependentAdapted
}

func (x *ReorderedStruct) SetReorderedDependentAdaptedNonCompat(value DeclaredAfterStruct) *ReorderedStruct {
    x.ReorderedDependentAdapted = &value
    return x
}

func (x *ReorderedStruct) SetReorderedDependentAdapted(value *DeclaredAfterStruct) *ReorderedStruct {
    x.ReorderedDependentAdapted = value
    return x
}

func (x *ReorderedStruct) IsSetReorderedDependentAdapted() bool {
    return x.ReorderedDependentAdapted != nil
}

func (x *ReorderedStruct) writeField1(p thrift.Protocol) error {  // ReorderedDependentAdapted
    if !x.IsSetReorderedDependentAdapted() {
        return nil
    }

    if err := p.WriteFieldBegin("reordered_dependent_adapted", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetReorderedDependentAdaptedNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *ReorderedStruct) readField1(p thrift.Protocol) error {  // ReorderedDependentAdapted
    result := *NewDeclaredAfterStruct()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetReorderedDependentAdaptedNonCompat(result)
    return nil
}

func (x *ReorderedStruct) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use ReorderedStruct.Set* methods instead or set the fields directly.
type ReorderedStructBuilder struct {
    obj *ReorderedStruct
}

func NewReorderedStructBuilder() *ReorderedStructBuilder {
    return &ReorderedStructBuilder{
        obj: NewReorderedStruct(),
    }
}

func (x *ReorderedStructBuilder) ReorderedDependentAdapted(value *DeclaredAfterStruct) *ReorderedStructBuilder {
    x.obj.ReorderedDependentAdapted = value
    return x
}

func (x *ReorderedStructBuilder) Emit() *ReorderedStruct {
    var objCopy ReorderedStruct = *x.obj
    return &objCopy
}

func (x *ReorderedStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("ReorderedStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *ReorderedStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // reordered_dependent_adapted
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type DeclaredAfterStruct struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &DeclaredAfterStruct{}

func NewDeclaredAfterStruct() *DeclaredAfterStruct {
    return (&DeclaredAfterStruct{})
}

func (x *DeclaredAfterStruct) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use DeclaredAfterStruct.Set* methods instead or set the fields directly.
type DeclaredAfterStructBuilder struct {
    obj *DeclaredAfterStruct
}

func NewDeclaredAfterStructBuilder() *DeclaredAfterStructBuilder {
    return &DeclaredAfterStructBuilder{
        obj: NewDeclaredAfterStruct(),
    }
}

func (x *DeclaredAfterStructBuilder) Emit() *DeclaredAfterStruct {
    var objCopy DeclaredAfterStruct = *x.obj
    return &objCopy
}

func (x *DeclaredAfterStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("DeclaredAfterStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *DeclaredAfterStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type RenamedStruct struct {
    Data int64 `thrift:"data,1" json:"data" db:"data"`
}
// Compile time interface enforcer
var _ thrift.Struct = &RenamedStruct{}

func NewRenamedStruct() *RenamedStruct {
    return (&RenamedStruct{}).
        SetDataNonCompat(0)
}

func (x *RenamedStruct) GetDataNonCompat() int64 {
    return x.Data
}

func (x *RenamedStruct) GetData() int64 {
    return x.Data
}

func (x *RenamedStruct) SetDataNonCompat(value int64) *RenamedStruct {
    x.Data = value
    return x
}

func (x *RenamedStruct) SetData(value int64) *RenamedStruct {
    x.Data = value
    return x
}

func (x *RenamedStruct) writeField1(p thrift.Protocol) error {  // Data
    if err := p.WriteFieldBegin("data", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDataNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *RenamedStruct) readField1(p thrift.Protocol) error {  // Data
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetDataNonCompat(result)
    return nil
}

func (x *RenamedStruct) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use RenamedStruct.Set* methods instead or set the fields directly.
type RenamedStructBuilder struct {
    obj *RenamedStruct
}

func NewRenamedStructBuilder() *RenamedStructBuilder {
    return &RenamedStructBuilder{
        obj: NewRenamedStruct(),
    }
}

func (x *RenamedStructBuilder) Data(value int64) *RenamedStructBuilder {
    x.obj.Data = value
    return x
}

func (x *RenamedStructBuilder) Emit() *RenamedStruct {
    var objCopy RenamedStruct = *x.obj
    return &objCopy
}

func (x *RenamedStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("RenamedStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *RenamedStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // data
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type SameNamespaceStruct struct {
    Data int64 `thrift:"data,1" json:"data" db:"data"`
}
// Compile time interface enforcer
var _ thrift.Struct = &SameNamespaceStruct{}

func NewSameNamespaceStruct() *SameNamespaceStruct {
    return (&SameNamespaceStruct{}).
        SetDataNonCompat(0)
}

func (x *SameNamespaceStruct) GetDataNonCompat() int64 {
    return x.Data
}

func (x *SameNamespaceStruct) GetData() int64 {
    return x.Data
}

func (x *SameNamespaceStruct) SetDataNonCompat(value int64) *SameNamespaceStruct {
    x.Data = value
    return x
}

func (x *SameNamespaceStruct) SetData(value int64) *SameNamespaceStruct {
    x.Data = value
    return x
}

func (x *SameNamespaceStruct) writeField1(p thrift.Protocol) error {  // Data
    if err := p.WriteFieldBegin("data", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetDataNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *SameNamespaceStruct) readField1(p thrift.Protocol) error {  // Data
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetDataNonCompat(result)
    return nil
}

func (x *SameNamespaceStruct) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use SameNamespaceStruct.Set* methods instead or set the fields directly.
type SameNamespaceStructBuilder struct {
    obj *SameNamespaceStruct
}

func NewSameNamespaceStructBuilder() *SameNamespaceStructBuilder {
    return &SameNamespaceStructBuilder{
        obj: NewSameNamespaceStruct(),
    }
}

func (x *SameNamespaceStructBuilder) Data(value int64) *SameNamespaceStructBuilder {
    x.obj.Data = value
    return x
}

func (x *SameNamespaceStructBuilder) Emit() *SameNamespaceStruct {
    var objCopy SameNamespaceStruct = *x.obj
    return &objCopy
}

func (x *SameNamespaceStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("SameNamespaceStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *SameNamespaceStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // data
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type HeapAllocated struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &HeapAllocated{}

func NewHeapAllocated() *HeapAllocated {
    return (&HeapAllocated{})
}

func (x *HeapAllocated) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use HeapAllocated.Set* methods instead or set the fields directly.
type HeapAllocatedBuilder struct {
    obj *HeapAllocated
}

func NewHeapAllocatedBuilder() *HeapAllocatedBuilder {
    return &HeapAllocatedBuilder{
        obj: NewHeapAllocated(),
    }
}

func (x *HeapAllocatedBuilder) Emit() *HeapAllocated {
    var objCopy HeapAllocated = *x.obj
    return &objCopy
}

func (x *HeapAllocated) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("HeapAllocated"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *HeapAllocated) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type MoveOnly struct {
    Ptr *HeapAllocated `thrift:"ptr,1" json:"ptr" db:"ptr"`
}
// Compile time interface enforcer
var _ thrift.Struct = &MoveOnly{}

func NewMoveOnly() *MoveOnly {
    return (&MoveOnly{}).
        SetPtrNonCompat(*NewHeapAllocated())
}

// Deprecated: Use NewMoveOnly().GetPtr() instead.
var MoveOnly_Ptr_DEFAULT = NewMoveOnly().GetPtr()

func (x *MoveOnly) GetPtrNonCompat() *HeapAllocated {
    return x.Ptr
}

func (x *MoveOnly) GetPtr() *HeapAllocated {
    if !x.IsSetPtr() {
        return NewHeapAllocated()
    }

    return x.Ptr
}

func (x *MoveOnly) SetPtrNonCompat(value HeapAllocated) *MoveOnly {
    x.Ptr = &value
    return x
}

func (x *MoveOnly) SetPtr(value *HeapAllocated) *MoveOnly {
    x.Ptr = value
    return x
}

func (x *MoveOnly) IsSetPtr() bool {
    return x.Ptr != nil
}

func (x *MoveOnly) writeField1(p thrift.Protocol) error {  // Ptr
    if !x.IsSetPtr() {
        return nil
    }

    if err := p.WriteFieldBegin("ptr", thrift.STRUCT, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetPtrNonCompat()
    if err := item.Write(p); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *MoveOnly) readField1(p thrift.Protocol) error {  // Ptr
    result := *NewHeapAllocated()
err := result.Read(p)
if err != nil {
    return err
}

    x.SetPtrNonCompat(result)
    return nil
}

func (x *MoveOnly) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use MoveOnly.Set* methods instead or set the fields directly.
type MoveOnlyBuilder struct {
    obj *MoveOnly
}

func NewMoveOnlyBuilder() *MoveOnlyBuilder {
    return &MoveOnlyBuilder{
        obj: NewMoveOnly(),
    }
}

func (x *MoveOnlyBuilder) Ptr(value *HeapAllocated) *MoveOnlyBuilder {
    x.obj.Ptr = value
    return x
}

func (x *MoveOnlyBuilder) Emit() *MoveOnly {
    var objCopy MoveOnly = *x.obj
    return &objCopy
}

func (x *MoveOnly) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("MoveOnly"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *MoveOnly) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // ptr
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type AlsoMoveOnly struct {
    Ptr int64 `thrift:"ptr,1" json:"ptr" db:"ptr"`
}
// Compile time interface enforcer
var _ thrift.Struct = &AlsoMoveOnly{}

func NewAlsoMoveOnly() *AlsoMoveOnly {
    return (&AlsoMoveOnly{}).
        SetPtrNonCompat(0)
}

func (x *AlsoMoveOnly) GetPtrNonCompat() int64 {
    return x.Ptr
}

func (x *AlsoMoveOnly) GetPtr() int64 {
    return x.Ptr
}

func (x *AlsoMoveOnly) SetPtrNonCompat(value int64) *AlsoMoveOnly {
    x.Ptr = value
    return x
}

func (x *AlsoMoveOnly) SetPtr(value int64) *AlsoMoveOnly {
    x.Ptr = value
    return x
}

func (x *AlsoMoveOnly) writeField1(p thrift.Protocol) error {  // Ptr
    if err := p.WriteFieldBegin("ptr", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetPtrNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *AlsoMoveOnly) readField1(p thrift.Protocol) error {  // Ptr
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetPtrNonCompat(result)
    return nil
}

func (x *AlsoMoveOnly) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use AlsoMoveOnly.Set* methods instead or set the fields directly.
type AlsoMoveOnlyBuilder struct {
    obj *AlsoMoveOnly
}

func NewAlsoMoveOnlyBuilder() *AlsoMoveOnlyBuilder {
    return &AlsoMoveOnlyBuilder{
        obj: NewAlsoMoveOnly(),
    }
}

func (x *AlsoMoveOnlyBuilder) Ptr(value int64) *AlsoMoveOnlyBuilder {
    x.obj.Ptr = value
    return x
}

func (x *AlsoMoveOnlyBuilder) Emit() *AlsoMoveOnly {
    var objCopy AlsoMoveOnly = *x.obj
    return &objCopy
}

func (x *AlsoMoveOnly) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("AlsoMoveOnly"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *AlsoMoveOnly) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // ptr
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type ApplyAdapter struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &ApplyAdapter{}

func NewApplyAdapter() *ApplyAdapter {
    return (&ApplyAdapter{})
}

func (x *ApplyAdapter) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use ApplyAdapter.Set* methods instead or set the fields directly.
type ApplyAdapterBuilder struct {
    obj *ApplyAdapter
}

func NewApplyAdapterBuilder() *ApplyAdapterBuilder {
    return &ApplyAdapterBuilder{
        obj: NewApplyAdapter(),
    }
}

func (x *ApplyAdapterBuilder) Emit() *ApplyAdapter {
    var objCopy ApplyAdapter = *x.obj
    return &objCopy
}

func (x *ApplyAdapter) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("ApplyAdapter"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *ApplyAdapter) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type TransitiveAdapted struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &TransitiveAdapted{}

func NewTransitiveAdapted() *TransitiveAdapted {
    return (&TransitiveAdapted{})
}

func (x *TransitiveAdapted) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use TransitiveAdapted.Set* methods instead or set the fields directly.
type TransitiveAdaptedBuilder struct {
    obj *TransitiveAdapted
}

func NewTransitiveAdaptedBuilder() *TransitiveAdaptedBuilder {
    return &TransitiveAdaptedBuilder{
        obj: NewTransitiveAdapted(),
    }
}

func (x *TransitiveAdaptedBuilder) Emit() *TransitiveAdapted {
    var objCopy TransitiveAdapted = *x.obj
    return &objCopy
}

func (x *TransitiveAdapted) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("TransitiveAdapted"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *TransitiveAdapted) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type CountingStruct struct {
    RegularInt *int64 `thrift:"regularInt,1,optional" json:"regularInt,omitempty" db:"regularInt"`
    CountingInt *CountingInt `thrift:"countingInt,2,optional" json:"countingInt,omitempty" db:"countingInt"`
    RegularString *string `thrift:"regularString,3,optional" json:"regularString,omitempty" db:"regularString"`
}
// Compile time interface enforcer
var _ thrift.Struct = &CountingStruct{}

func NewCountingStruct() *CountingStruct {
    return (&CountingStruct{})
}

// Deprecated: Use NewCountingStruct().GetRegularInt() instead.
var CountingStruct_RegularInt_DEFAULT = NewCountingStruct().GetRegularInt()

// Deprecated: Use NewCountingStruct().GetCountingInt() instead.
var CountingStruct_CountingInt_DEFAULT = NewCountingStruct().GetCountingInt()

// Deprecated: Use NewCountingStruct().GetRegularString() instead.
var CountingStruct_RegularString_DEFAULT = NewCountingStruct().GetRegularString()

func (x *CountingStruct) GetRegularIntNonCompat() *int64 {
    return x.RegularInt
}

func (x *CountingStruct) GetRegularInt() int64 {
    if !x.IsSetRegularInt() {
        return 0
    }

    return *x.RegularInt
}

func (x *CountingStruct) GetCountingIntNonCompat() *CountingInt {
    return x.CountingInt
}

func (x *CountingStruct) GetCountingInt() CountingInt {
    if !x.IsSetCountingInt() {
        return NewCountingInt()
    }

    return *x.CountingInt
}

func (x *CountingStruct) GetRegularStringNonCompat() *string {
    return x.RegularString
}

func (x *CountingStruct) GetRegularString() string {
    if !x.IsSetRegularString() {
        return ""
    }

    return *x.RegularString
}

func (x *CountingStruct) SetRegularIntNonCompat(value int64) *CountingStruct {
    x.RegularInt = &value
    return x
}

func (x *CountingStruct) SetRegularInt(value *int64) *CountingStruct {
    x.RegularInt = value
    return x
}

func (x *CountingStruct) SetCountingIntNonCompat(value CountingInt) *CountingStruct {
    x.CountingInt = &value
    return x
}

func (x *CountingStruct) SetCountingInt(value *CountingInt) *CountingStruct {
    x.CountingInt = value
    return x
}

func (x *CountingStruct) SetRegularStringNonCompat(value string) *CountingStruct {
    x.RegularString = &value
    return x
}

func (x *CountingStruct) SetRegularString(value *string) *CountingStruct {
    x.RegularString = value
    return x
}

func (x *CountingStruct) IsSetRegularInt() bool {
    return x.RegularInt != nil
}

func (x *CountingStruct) IsSetCountingInt() bool {
    return x.CountingInt != nil
}

func (x *CountingStruct) IsSetRegularString() bool {
    return x.RegularString != nil
}

func (x *CountingStruct) writeField1(p thrift.Protocol) error {  // RegularInt
    if !x.IsSetRegularInt() {
        return nil
    }

    if err := p.WriteFieldBegin("regularInt", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetRegularIntNonCompat()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *CountingStruct) writeField2(p thrift.Protocol) error {  // CountingInt
    if !x.IsSetCountingInt() {
        return nil
    }

    if err := p.WriteFieldBegin("countingInt", thrift.I64, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetCountingIntNonCompat()
    err := WriteCountingInt(item, p)
if err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *CountingStruct) writeField3(p thrift.Protocol) error {  // RegularString
    if !x.IsSetRegularString() {
        return nil
    }

    if err := p.WriteFieldBegin("regularString", thrift.STRING, 3); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := *x.GetRegularStringNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *CountingStruct) readField1(p thrift.Protocol) error {  // RegularInt
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetRegularIntNonCompat(result)
    return nil
}

func (x *CountingStruct) readField2(p thrift.Protocol) error {  // CountingInt
    result, err := ReadCountingInt(p)
if err != nil {
    return err
}

    x.SetCountingIntNonCompat(result)
    return nil
}

func (x *CountingStruct) readField3(p thrift.Protocol) error {  // RegularString
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetRegularStringNonCompat(result)
    return nil
}

func (x *CountingStruct) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use CountingStruct.Set* methods instead or set the fields directly.
type CountingStructBuilder struct {
    obj *CountingStruct
}

func NewCountingStructBuilder() *CountingStructBuilder {
    return &CountingStructBuilder{
        obj: NewCountingStruct(),
    }
}

func (x *CountingStructBuilder) RegularInt(value *int64) *CountingStructBuilder {
    x.obj.RegularInt = value
    return x
}

func (x *CountingStructBuilder) CountingInt(value *CountingInt) *CountingStructBuilder {
    x.obj.CountingInt = value
    return x
}

func (x *CountingStructBuilder) RegularString(value *string) *CountingStructBuilder {
    x.obj.RegularString = value
    return x
}

func (x *CountingStructBuilder) Emit() *CountingStruct {
    var objCopy CountingStruct = *x.obj
    return &objCopy
}

func (x *CountingStruct) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("CountingStruct"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := x.writeField3(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *CountingStruct) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // regularInt
            if err := x.readField1(p); err != nil {
                return err
            }
        case 2:  // countingInt
            if err := x.readField2(p); err != nil {
                return err
            }
        case 3:  // regularString
            if err := x.readField3(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type Person struct {
    Name string `thrift:"name,1" json:"name" db:"name"`
}
// Compile time interface enforcer
var _ thrift.Struct = &Person{}

func NewPerson() *Person {
    return (&Person{}).
        SetNameNonCompat("")
}

func (x *Person) GetNameNonCompat() string {
    return x.Name
}

func (x *Person) GetName() string {
    return x.Name
}

func (x *Person) SetNameNonCompat(value string) *Person {
    x.Name = value
    return x
}

func (x *Person) SetName(value string) *Person {
    x.Name = value
    return x
}

func (x *Person) writeField1(p thrift.Protocol) error {  // Name
    if err := p.WriteFieldBegin("name", thrift.STRING, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetNameNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Person) readField1(p thrift.Protocol) error {  // Name
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetNameNonCompat(result)
    return nil
}

func (x *Person) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use Person.Set* methods instead or set the fields directly.
type PersonBuilder struct {
    obj *Person
}

func NewPersonBuilder() *PersonBuilder {
    return &PersonBuilder{
        obj: NewPerson(),
    }
}

func (x *PersonBuilder) Name(value string) *PersonBuilder {
    x.obj.Name = value
    return x
}

func (x *PersonBuilder) Emit() *Person {
    var objCopy Person = *x.obj
    return &objCopy
}

func (x *Person) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("Person"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *Person) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // name
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type Person2 struct {
    Name string `thrift:"name,1" json:"name" db:"name"`
}
// Compile time interface enforcer
var _ thrift.Struct = &Person2{}

func NewPerson2() *Person2 {
    return (&Person2{}).
        SetNameNonCompat("")
}

func (x *Person2) GetNameNonCompat() string {
    return x.Name
}

func (x *Person2) GetName() string {
    return x.Name
}

func (x *Person2) SetNameNonCompat(value string) *Person2 {
    x.Name = value
    return x
}

func (x *Person2) SetName(value string) *Person2 {
    x.Name = value
    return x
}

func (x *Person2) writeField1(p thrift.Protocol) error {  // Name
    if err := p.WriteFieldBegin("name", thrift.STRING, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetNameNonCompat()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *Person2) readField1(p thrift.Protocol) error {  // Name
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetNameNonCompat(result)
    return nil
}

func (x *Person2) String() string {
    return fmt.Sprintf("%+v", x)
}


// Deprecated: Use Person2.Set* methods instead or set the fields directly.
type Person2Builder struct {
    obj *Person2
}

func NewPerson2Builder() *Person2Builder {
    return &Person2Builder{
        obj: NewPerson2(),
    }
}

func (x *Person2Builder) Name(value string) *Person2Builder {
    x.obj.Name = value
    return x
}

func (x *Person2Builder) Emit() *Person2 {
    var objCopy Person2 = *x.obj
    return &objCopy
}

func (x *Person2) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("Person2"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *Person2) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // name
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}

