// @generated by Thrift for [[[ program path ]]]
// This file is probably not the place you want to edit!

package module // [[[ program thrift source path ]]]


import (
    "context"
    "fmt"

    cpp "thrift/annotation/cpp"

    "thrift/lib/go/thrift"
)

var _ = cpp.GoUnusedProtection__

// (needed to ensure safety because of naive import list construction)
var _ = context.Background
var _ = fmt.Printf
var _ = thrift.ZERO



type MyService interface {
    Ping(ctx context.Context) error
    GetRandomData(ctx context.Context) (string, error)
    HasDataById(ctx context.Context, id int64) (bool, error)
    GetDataById(ctx context.Context, id int64) (string, error)
    PutDataById(ctx context.Context, id int64, data string) error
    LobDataById(ctx context.Context, id int64, data string) error
    GoDoNothing(ctx context.Context) error
}

// Deprecated: Use MyService instead.
type MyServiceClientInterface interface {
  thrift.ClientInterface
  Ping() error
  GetRandomData() (string, error)
  HasDataById(id int64) (bool, error)
  GetDataById(id int64) (string, error)
  PutDataById(id int64, data string) error
  LobDataById(id int64, data string) error
  GoDoNothing() error
}

type MyServiceChannelClient struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ MyService = &MyServiceChannelClient{}

func NewMyServiceChannelClient(channel thrift.RequestChannel) *MyServiceChannelClient {
    return &MyServiceChannelClient{
        ch: channel,
    }
}

func (c *MyServiceChannelClient) Close() error {
    return c.ch.Close()
}

func (c *MyServiceChannelClient) IsOpen() bool {
    return c.ch.IsOpen()
}

func (c *MyServiceChannelClient) Open() error {
    return c.ch.Open()
}

// Deprecated: Use MyServiceChannelClient instead.
type MyServiceClient struct {
    chClient *MyServiceChannelClient
}
// Compile time interface enforcer
var _ MyServiceClientInterface = &MyServiceClient{}

// Deprecated: Use NewMyServiceChannelClient() instead.
func NewMyServiceClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *MyServiceClient {
    return &MyServiceClient{
        chClient: NewMyServiceChannelClient(
            thrift.NewSerialChannel(iprot),
        ),
    }
}

func (c *MyServiceClient) Close() error {
    return c.chClient.Close()
}

func (c *MyServiceClient) IsOpen() bool {
    return c.chClient.IsOpen()
}

func (c *MyServiceClient) Open() error {
    return c.chClient.Open()
}

// Deprecated: Use MyServiceChannelClient instead.
type MyServiceThreadsafeClient = MyServiceClient

// Deprecated: Use NewMyServiceChannelClient() instead.
func NewMyServiceThreadsafeClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *MyServiceThreadsafeClient {
    return NewMyServiceClient(t, iprot, oprot)
}

// Deprecated: Use NewMyServiceChannelClient() instead.
func NewMyServiceClientProtocol(prot thrift.Protocol) *MyServiceClient {
  return NewMyServiceClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewMyServiceChannelClient() instead.
func NewMyServiceThreadsafeClientProtocol(prot thrift.Protocol) *MyServiceClient {
  return NewMyServiceClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewMyServiceChannelClient() instead.
func NewMyServiceClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *MyServiceClient {
  iprot := pf.GetProtocol(t)
  oprot := pf.GetProtocol(t)
  return NewMyServiceClient(t, iprot, oprot)
}

// Deprecated: Use NewMyServiceChannelClient() instead.
func NewMyServiceThreadsafeClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *MyServiceThreadsafeClient {
  return NewMyServiceClientFactory(t, pf)
}


func (c *MyServiceChannelClient) Ping(ctx context.Context) error {
    in := &reqMyServicePing{
    }
    out := newRespMyServicePing()
    err := c.ch.Call(ctx, "ping", in, out)
    return err
}

func (c *MyServiceClient) Ping() error {
    return c.chClient.Ping(nil)
}


func (c *MyServiceChannelClient) GetRandomData(ctx context.Context) (string, error) {
    in := &reqMyServiceGetRandomData{
    }
    out := newRespMyServiceGetRandomData()
    err := c.ch.Call(ctx, "getRandomData", in, out)
    return out.Value, err
}

func (c *MyServiceClient) GetRandomData() (string, error) {
    return c.chClient.GetRandomData(nil)
}


func (c *MyServiceChannelClient) HasDataById(ctx context.Context, id int64) (bool, error) {
    in := &reqMyServiceHasDataById{
        Id: id,
    }
    out := newRespMyServiceHasDataById()
    err := c.ch.Call(ctx, "hasDataById", in, out)
    return out.Value, err
}

func (c *MyServiceClient) HasDataById(id int64) (bool, error) {
    return c.chClient.HasDataById(nil, id)
}


func (c *MyServiceChannelClient) GetDataById(ctx context.Context, id int64) (string, error) {
    in := &reqMyServiceGetDataById{
        Id: id,
    }
    out := newRespMyServiceGetDataById()
    err := c.ch.Call(ctx, "getDataById", in, out)
    return out.Value, err
}

func (c *MyServiceClient) GetDataById(id int64) (string, error) {
    return c.chClient.GetDataById(nil, id)
}


func (c *MyServiceChannelClient) PutDataById(ctx context.Context, id int64, data string) error {
    in := &reqMyServicePutDataById{
        Id: id,
        Data: data,
    }
    out := newRespMyServicePutDataById()
    err := c.ch.Call(ctx, "putDataById", in, out)
    return err
}

func (c *MyServiceClient) PutDataById(id int64, data string) error {
    return c.chClient.PutDataById(nil, id, data)
}


func (c *MyServiceChannelClient) LobDataById(ctx context.Context, id int64, data string) error {
    in := &reqMyServiceLobDataById{
        Id: id,
        Data: data,
    }
    out := newRespMyServiceLobDataById()
    err := c.ch.Call(ctx, "lobDataById", in, out)
    return err
}

func (c *MyServiceClient) LobDataById(id int64, data string) error {
    return c.chClient.LobDataById(nil, id, data)
}


func (c *MyServiceChannelClient) GoDoNothing(ctx context.Context) error {
    in := &reqMyServiceGoDoNothing{
    }
    out := newRespMyServiceGoDoNothing()
    err := c.ch.Call(ctx, "doNothing", in, out)
    return err
}

func (c *MyServiceClient) GoDoNothing() error {
    return c.chClient.GoDoNothing(nil)
}


type reqMyServicePing struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServicePing{}

func newReqMyServicePing() *reqMyServicePing {
    return (&reqMyServicePing{})
}

// Deprecated: Use reqMyServicePing.Set* methods instead or set the fields directly.
type reqMyServicePingBuilder struct {
    obj *reqMyServicePing
}

func newReqMyServicePingBuilder() *reqMyServicePingBuilder {
    return &reqMyServicePingBuilder{
        obj: newReqMyServicePing(),
    }
}

func (x *reqMyServicePingBuilder) Emit() *reqMyServicePing {
    var objCopy reqMyServicePing = *x.obj
    return &objCopy
}

func (x *reqMyServicePing) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("req_MyService_ping"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServicePing) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type respMyServicePing struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServicePing{}

func newRespMyServicePing() *respMyServicePing {
    return (&respMyServicePing{})
}

// Deprecated: Use respMyServicePing.Set* methods instead or set the fields directly.
type respMyServicePingBuilder struct {
    obj *respMyServicePing
}

func newRespMyServicePingBuilder() *respMyServicePingBuilder {
    return &respMyServicePingBuilder{
        obj: newRespMyServicePing(),
    }
}

func (x *respMyServicePingBuilder) Emit() *respMyServicePing {
    var objCopy respMyServicePing = *x.obj
    return &objCopy
}

func (x *respMyServicePing) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("resp_MyService_ping"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServicePing) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type reqMyServiceGetRandomData struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServiceGetRandomData{}

func newReqMyServiceGetRandomData() *reqMyServiceGetRandomData {
    return (&reqMyServiceGetRandomData{})
}

// Deprecated: Use reqMyServiceGetRandomData.Set* methods instead or set the fields directly.
type reqMyServiceGetRandomDataBuilder struct {
    obj *reqMyServiceGetRandomData
}

func newReqMyServiceGetRandomDataBuilder() *reqMyServiceGetRandomDataBuilder {
    return &reqMyServiceGetRandomDataBuilder{
        obj: newReqMyServiceGetRandomData(),
    }
}

func (x *reqMyServiceGetRandomDataBuilder) Emit() *reqMyServiceGetRandomData {
    var objCopy reqMyServiceGetRandomData = *x.obj
    return &objCopy
}

func (x *reqMyServiceGetRandomData) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("req_MyService_getRandomData"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServiceGetRandomData) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type respMyServiceGetRandomData struct {
    Value string `thrift:"value,0,required" json:"value" db:"value"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServiceGetRandomData{}

func newRespMyServiceGetRandomData() *respMyServiceGetRandomData {
    return (&respMyServiceGetRandomData{})
}
func (x *respMyServiceGetRandomData) GetValue() string {
    return x.Value
}

func (x *respMyServiceGetRandomData) SetValue(value string) *respMyServiceGetRandomData {
    x.Value = value
    return x
}


func (x *respMyServiceGetRandomData) writeField0(p thrift.Protocol) error {  // Value
    if err := p.WriteFieldBegin("value", thrift.STRING, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetValue()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respMyServiceGetRandomData) readField0(p thrift.Protocol) error {  // Value
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetValue(result)
    return nil
}


// Deprecated: Use respMyServiceGetRandomData.Set* methods instead or set the fields directly.
type respMyServiceGetRandomDataBuilder struct {
    obj *respMyServiceGetRandomData
}

func newRespMyServiceGetRandomDataBuilder() *respMyServiceGetRandomDataBuilder {
    return &respMyServiceGetRandomDataBuilder{
        obj: newRespMyServiceGetRandomData(),
    }
}

func (x *respMyServiceGetRandomDataBuilder) Value(value string) *respMyServiceGetRandomDataBuilder {
    x.obj.Value = value
    return x
}

func (x *respMyServiceGetRandomDataBuilder) Emit() *respMyServiceGetRandomData {
    var objCopy respMyServiceGetRandomData = *x.obj
    return &objCopy
}

func (x *respMyServiceGetRandomData) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("resp_MyService_getRandomData"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServiceGetRandomData) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 0:  // value
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type reqMyServiceHasDataById struct {
    Id int64 `thrift:"id,1" json:"id" db:"id"`
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServiceHasDataById{}

func newReqMyServiceHasDataById() *reqMyServiceHasDataById {
    return (&reqMyServiceHasDataById{})
}
func (x *reqMyServiceHasDataById) GetId() int64 {
    return x.Id
}

func (x *reqMyServiceHasDataById) SetId(value int64) *reqMyServiceHasDataById {
    x.Id = value
    return x
}


func (x *reqMyServiceHasDataById) writeField1(p thrift.Protocol) error {  // Id
    if err := p.WriteFieldBegin("id", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetId()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *reqMyServiceHasDataById) readField1(p thrift.Protocol) error {  // Id
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetId(result)
    return nil
}


// Deprecated: Use reqMyServiceHasDataById.Set* methods instead or set the fields directly.
type reqMyServiceHasDataByIdBuilder struct {
    obj *reqMyServiceHasDataById
}

func newReqMyServiceHasDataByIdBuilder() *reqMyServiceHasDataByIdBuilder {
    return &reqMyServiceHasDataByIdBuilder{
        obj: newReqMyServiceHasDataById(),
    }
}

func (x *reqMyServiceHasDataByIdBuilder) Id(value int64) *reqMyServiceHasDataByIdBuilder {
    x.obj.Id = value
    return x
}

func (x *reqMyServiceHasDataByIdBuilder) Emit() *reqMyServiceHasDataById {
    var objCopy reqMyServiceHasDataById = *x.obj
    return &objCopy
}

func (x *reqMyServiceHasDataById) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("req_MyService_hasDataById"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServiceHasDataById) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // id
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type respMyServiceHasDataById struct {
    Value bool `thrift:"value,0,required" json:"value" db:"value"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServiceHasDataById{}

func newRespMyServiceHasDataById() *respMyServiceHasDataById {
    return (&respMyServiceHasDataById{})
}
func (x *respMyServiceHasDataById) GetValue() bool {
    return x.Value
}

func (x *respMyServiceHasDataById) SetValue(value bool) *respMyServiceHasDataById {
    x.Value = value
    return x
}


func (x *respMyServiceHasDataById) writeField0(p thrift.Protocol) error {  // Value
    if err := p.WriteFieldBegin("value", thrift.BOOL, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetValue()
    if err := p.WriteBool(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respMyServiceHasDataById) readField0(p thrift.Protocol) error {  // Value
    result, err := p.ReadBool()
if err != nil {
    return err
}

    x.SetValue(result)
    return nil
}


// Deprecated: Use respMyServiceHasDataById.Set* methods instead or set the fields directly.
type respMyServiceHasDataByIdBuilder struct {
    obj *respMyServiceHasDataById
}

func newRespMyServiceHasDataByIdBuilder() *respMyServiceHasDataByIdBuilder {
    return &respMyServiceHasDataByIdBuilder{
        obj: newRespMyServiceHasDataById(),
    }
}

func (x *respMyServiceHasDataByIdBuilder) Value(value bool) *respMyServiceHasDataByIdBuilder {
    x.obj.Value = value
    return x
}

func (x *respMyServiceHasDataByIdBuilder) Emit() *respMyServiceHasDataById {
    var objCopy respMyServiceHasDataById = *x.obj
    return &objCopy
}

func (x *respMyServiceHasDataById) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("resp_MyService_hasDataById"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServiceHasDataById) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 0:  // value
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type reqMyServiceGetDataById struct {
    Id int64 `thrift:"id,1" json:"id" db:"id"`
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServiceGetDataById{}

func newReqMyServiceGetDataById() *reqMyServiceGetDataById {
    return (&reqMyServiceGetDataById{})
}
func (x *reqMyServiceGetDataById) GetId() int64 {
    return x.Id
}

func (x *reqMyServiceGetDataById) SetId(value int64) *reqMyServiceGetDataById {
    x.Id = value
    return x
}


func (x *reqMyServiceGetDataById) writeField1(p thrift.Protocol) error {  // Id
    if err := p.WriteFieldBegin("id", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetId()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *reqMyServiceGetDataById) readField1(p thrift.Protocol) error {  // Id
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetId(result)
    return nil
}


// Deprecated: Use reqMyServiceGetDataById.Set* methods instead or set the fields directly.
type reqMyServiceGetDataByIdBuilder struct {
    obj *reqMyServiceGetDataById
}

func newReqMyServiceGetDataByIdBuilder() *reqMyServiceGetDataByIdBuilder {
    return &reqMyServiceGetDataByIdBuilder{
        obj: newReqMyServiceGetDataById(),
    }
}

func (x *reqMyServiceGetDataByIdBuilder) Id(value int64) *reqMyServiceGetDataByIdBuilder {
    x.obj.Id = value
    return x
}

func (x *reqMyServiceGetDataByIdBuilder) Emit() *reqMyServiceGetDataById {
    var objCopy reqMyServiceGetDataById = *x.obj
    return &objCopy
}

func (x *reqMyServiceGetDataById) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("req_MyService_getDataById"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServiceGetDataById) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // id
            if err := x.readField1(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type respMyServiceGetDataById struct {
    Value string `thrift:"value,0,required" json:"value" db:"value"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServiceGetDataById{}

func newRespMyServiceGetDataById() *respMyServiceGetDataById {
    return (&respMyServiceGetDataById{})
}
func (x *respMyServiceGetDataById) GetValue() string {
    return x.Value
}

func (x *respMyServiceGetDataById) SetValue(value string) *respMyServiceGetDataById {
    x.Value = value
    return x
}


func (x *respMyServiceGetDataById) writeField0(p thrift.Protocol) error {  // Value
    if err := p.WriteFieldBegin("value", thrift.STRING, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetValue()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respMyServiceGetDataById) readField0(p thrift.Protocol) error {  // Value
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetValue(result)
    return nil
}


// Deprecated: Use respMyServiceGetDataById.Set* methods instead or set the fields directly.
type respMyServiceGetDataByIdBuilder struct {
    obj *respMyServiceGetDataById
}

func newRespMyServiceGetDataByIdBuilder() *respMyServiceGetDataByIdBuilder {
    return &respMyServiceGetDataByIdBuilder{
        obj: newRespMyServiceGetDataById(),
    }
}

func (x *respMyServiceGetDataByIdBuilder) Value(value string) *respMyServiceGetDataByIdBuilder {
    x.obj.Value = value
    return x
}

func (x *respMyServiceGetDataByIdBuilder) Emit() *respMyServiceGetDataById {
    var objCopy respMyServiceGetDataById = *x.obj
    return &objCopy
}

func (x *respMyServiceGetDataById) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("resp_MyService_getDataById"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServiceGetDataById) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 0:  // value
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type reqMyServicePutDataById struct {
    Id int64 `thrift:"id,1" json:"id" db:"id"`
    Data string `thrift:"data,2" json:"data" db:"data"`
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServicePutDataById{}

func newReqMyServicePutDataById() *reqMyServicePutDataById {
    return (&reqMyServicePutDataById{})
}
func (x *reqMyServicePutDataById) GetId() int64 {
    return x.Id
}

func (x *reqMyServicePutDataById) GetData() string {
    return x.Data
}

func (x *reqMyServicePutDataById) SetId(value int64) *reqMyServicePutDataById {
    x.Id = value
    return x
}

func (x *reqMyServicePutDataById) SetData(value string) *reqMyServicePutDataById {
    x.Data = value
    return x
}



func (x *reqMyServicePutDataById) writeField1(p thrift.Protocol) error {  // Id
    if err := p.WriteFieldBegin("id", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetId()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *reqMyServicePutDataById) writeField2(p thrift.Protocol) error {  // Data
    if err := p.WriteFieldBegin("data", thrift.STRING, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetData()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *reqMyServicePutDataById) readField1(p thrift.Protocol) error {  // Id
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetId(result)
    return nil
}

func (x *reqMyServicePutDataById) readField2(p thrift.Protocol) error {  // Data
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetData(result)
    return nil
}


// Deprecated: Use reqMyServicePutDataById.Set* methods instead or set the fields directly.
type reqMyServicePutDataByIdBuilder struct {
    obj *reqMyServicePutDataById
}

func newReqMyServicePutDataByIdBuilder() *reqMyServicePutDataByIdBuilder {
    return &reqMyServicePutDataByIdBuilder{
        obj: newReqMyServicePutDataById(),
    }
}

func (x *reqMyServicePutDataByIdBuilder) Id(value int64) *reqMyServicePutDataByIdBuilder {
    x.obj.Id = value
    return x
}

func (x *reqMyServicePutDataByIdBuilder) Data(value string) *reqMyServicePutDataByIdBuilder {
    x.obj.Data = value
    return x
}

func (x *reqMyServicePutDataByIdBuilder) Emit() *reqMyServicePutDataById {
    var objCopy reqMyServicePutDataById = *x.obj
    return &objCopy
}

func (x *reqMyServicePutDataById) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("req_MyService_putDataById"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServicePutDataById) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // id
            if err := x.readField1(p); err != nil {
                return err
            }
        case 2:  // data
            if err := x.readField2(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type respMyServicePutDataById struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServicePutDataById{}

func newRespMyServicePutDataById() *respMyServicePutDataById {
    return (&respMyServicePutDataById{})
}

// Deprecated: Use respMyServicePutDataById.Set* methods instead or set the fields directly.
type respMyServicePutDataByIdBuilder struct {
    obj *respMyServicePutDataById
}

func newRespMyServicePutDataByIdBuilder() *respMyServicePutDataByIdBuilder {
    return &respMyServicePutDataByIdBuilder{
        obj: newRespMyServicePutDataById(),
    }
}

func (x *respMyServicePutDataByIdBuilder) Emit() *respMyServicePutDataById {
    var objCopy respMyServicePutDataById = *x.obj
    return &objCopy
}

func (x *respMyServicePutDataById) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("resp_MyService_putDataById"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServicePutDataById) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type reqMyServiceLobDataById struct {
    Id int64 `thrift:"id,1" json:"id" db:"id"`
    Data string `thrift:"data,2" json:"data" db:"data"`
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServiceLobDataById{}

func newReqMyServiceLobDataById() *reqMyServiceLobDataById {
    return (&reqMyServiceLobDataById{})
}
func (x *reqMyServiceLobDataById) GetId() int64 {
    return x.Id
}

func (x *reqMyServiceLobDataById) GetData() string {
    return x.Data
}

func (x *reqMyServiceLobDataById) SetId(value int64) *reqMyServiceLobDataById {
    x.Id = value
    return x
}

func (x *reqMyServiceLobDataById) SetData(value string) *reqMyServiceLobDataById {
    x.Data = value
    return x
}



func (x *reqMyServiceLobDataById) writeField1(p thrift.Protocol) error {  // Id
    if err := p.WriteFieldBegin("id", thrift.I64, 1); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetId()
    if err := p.WriteI64(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *reqMyServiceLobDataById) writeField2(p thrift.Protocol) error {  // Data
    if err := p.WriteFieldBegin("data", thrift.STRING, 2); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetData()
    if err := p.WriteString(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *reqMyServiceLobDataById) readField1(p thrift.Protocol) error {  // Id
    result, err := p.ReadI64()
if err != nil {
    return err
}

    x.SetId(result)
    return nil
}

func (x *reqMyServiceLobDataById) readField2(p thrift.Protocol) error {  // Data
    result, err := p.ReadString()
if err != nil {
    return err
}

    x.SetData(result)
    return nil
}


// Deprecated: Use reqMyServiceLobDataById.Set* methods instead or set the fields directly.
type reqMyServiceLobDataByIdBuilder struct {
    obj *reqMyServiceLobDataById
}

func newReqMyServiceLobDataByIdBuilder() *reqMyServiceLobDataByIdBuilder {
    return &reqMyServiceLobDataByIdBuilder{
        obj: newReqMyServiceLobDataById(),
    }
}

func (x *reqMyServiceLobDataByIdBuilder) Id(value int64) *reqMyServiceLobDataByIdBuilder {
    x.obj.Id = value
    return x
}

func (x *reqMyServiceLobDataByIdBuilder) Data(value string) *reqMyServiceLobDataByIdBuilder {
    x.obj.Data = value
    return x
}

func (x *reqMyServiceLobDataByIdBuilder) Emit() *reqMyServiceLobDataById {
    var objCopy reqMyServiceLobDataById = *x.obj
    return &objCopy
}

func (x *reqMyServiceLobDataById) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("req_MyService_lobDataById"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField1(p); err != nil {
        return err
    }

    if err := x.writeField2(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServiceLobDataById) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 1:  // id
            if err := x.readField1(p); err != nil {
                return err
            }
        case 2:  // data
            if err := x.readField2(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type respMyServiceLobDataById struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServiceLobDataById{}

func newRespMyServiceLobDataById() *respMyServiceLobDataById {
    return (&respMyServiceLobDataById{})
}

// Deprecated: Use respMyServiceLobDataById.Set* methods instead or set the fields directly.
type respMyServiceLobDataByIdBuilder struct {
    obj *respMyServiceLobDataById
}

func newRespMyServiceLobDataByIdBuilder() *respMyServiceLobDataByIdBuilder {
    return &respMyServiceLobDataByIdBuilder{
        obj: newRespMyServiceLobDataById(),
    }
}

func (x *respMyServiceLobDataByIdBuilder) Emit() *respMyServiceLobDataById {
    var objCopy respMyServiceLobDataById = *x.obj
    return &objCopy
}

func (x *respMyServiceLobDataById) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("resp_MyService_lobDataById"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServiceLobDataById) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type reqMyServiceDoNothing struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServiceDoNothing{}

func newReqMyServiceDoNothing() *reqMyServiceDoNothing {
    return (&reqMyServiceDoNothing{})
}

// Deprecated: Use reqMyServiceDoNothing.Set* methods instead or set the fields directly.
type reqMyServiceDoNothingBuilder struct {
    obj *reqMyServiceDoNothing
}

func newReqMyServiceDoNothingBuilder() *reqMyServiceDoNothingBuilder {
    return &reqMyServiceDoNothingBuilder{
        obj: newReqMyServiceDoNothing(),
    }
}

func (x *reqMyServiceDoNothingBuilder) Emit() *reqMyServiceDoNothing {
    var objCopy reqMyServiceDoNothing = *x.obj
    return &objCopy
}

func (x *reqMyServiceDoNothing) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("req_MyService_doNothing"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServiceDoNothing) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type respMyServiceDoNothing struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServiceDoNothing{}

func newRespMyServiceDoNothing() *respMyServiceDoNothing {
    return (&respMyServiceDoNothing{})
}

// Deprecated: Use respMyServiceDoNothing.Set* methods instead or set the fields directly.
type respMyServiceDoNothingBuilder struct {
    obj *respMyServiceDoNothing
}

func newRespMyServiceDoNothingBuilder() *respMyServiceDoNothingBuilder {
    return &respMyServiceDoNothingBuilder{
        obj: newRespMyServiceDoNothing(),
    }
}

func (x *respMyServiceDoNothingBuilder) Emit() *respMyServiceDoNothing {
    var objCopy respMyServiceDoNothing = *x.obj
    return &objCopy
}

func (x *respMyServiceDoNothing) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("resp_MyService_doNothing"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServiceDoNothing) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type MyServiceProcessor struct {
    processorMap       map[string]thrift.ProcessorFunction
    functionServiceMap map[string]string
    handler            MyService
}
// Compile time interface enforcer
var _ thrift.Processor = &MyServiceProcessor{}

func (p *MyServiceProcessor) AddToProcessorMap(key string, processor thrift.ProcessorFunction) {
    p.processorMap[key] = processor
}

func (p *MyServiceProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *MyServiceProcessor) GetProcessorFunction(key string) (processor thrift.ProcessorFunction, err error) {
    if processor, ok := p.processorMap[key]; ok {
        return processor, nil
    }
    return nil, nil
}

func (p *MyServiceProcessor) ProcessorMap() map[string]thrift.ProcessorFunction {
    return p.processorMap
}

func (p *MyServiceProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func NewMyServiceProcessor(handler MyService) *MyServiceProcessor {
    p := &MyServiceProcessor{
        handler:            handler,
        processorMap:       make(map[string]thrift.ProcessorFunction),
        functionServiceMap: make(map[string]string),
    }
    p.AddToProcessorMap("ping", &procFuncMyServicePing{handler: handler})
    p.AddToProcessorMap("getRandomData", &procFuncMyServiceGetRandomData{handler: handler})
    p.AddToProcessorMap("hasDataById", &procFuncMyServiceHasDataById{handler: handler})
    p.AddToProcessorMap("getDataById", &procFuncMyServiceGetDataById{handler: handler})
    p.AddToProcessorMap("putDataById", &procFuncMyServicePutDataById{handler: handler})
    p.AddToProcessorMap("lobDataById", &procFuncMyServiceLobDataById{handler: handler})
    p.AddToProcessorMap("doNothing", &procFuncMyServiceGoDoNothing{handler: handler})
    p.AddToFunctionServiceMap("ping", "MyService")
    p.AddToFunctionServiceMap("getRandomData", "MyService")
    p.AddToFunctionServiceMap("hasDataById", "MyService")
    p.AddToFunctionServiceMap("getDataById", "MyService")
    p.AddToFunctionServiceMap("putDataById", "MyService")
    p.AddToFunctionServiceMap("lobDataById", "MyService")
    p.AddToFunctionServiceMap("doNothing", "MyService")

    return p
}


type procFuncMyServicePing struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = &procFuncMyServicePing{}

func (p *procFuncMyServicePing) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServicePing()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServicePing) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    if _, ok := result.(thrift.ApplicationException); ok {
        messageType = thrift.EXCEPTION
    }
    if err2 = oprot.WriteMessageBegin("Ping", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServicePing) Run(reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespMyServicePing()
    if err := p.handler.Ping(); err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing Ping: " + err.Error(), err)
        return x, x
    }
    return result, nil
}


type procFuncMyServiceGetRandomData struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = &procFuncMyServiceGetRandomData{}

func (p *procFuncMyServiceGetRandomData) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServiceGetRandomData()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServiceGetRandomData) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    if _, ok := result.(thrift.ApplicationException); ok {
        messageType = thrift.EXCEPTION
    }
    if err2 = oprot.WriteMessageBegin("GetRandomData", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServiceGetRandomData) Run(reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespMyServiceGetRandomData()
    if retval, err := p.handler.GetRandomData(); err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GetRandomData: " + err.Error(), err)
        return x, x
    } else {
        result.Value = retval
    }

    return result, nil
}


type procFuncMyServiceHasDataById struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = &procFuncMyServiceHasDataById{}

func (p *procFuncMyServiceHasDataById) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServiceHasDataById()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServiceHasDataById) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    if _, ok := result.(thrift.ApplicationException); ok {
        messageType = thrift.EXCEPTION
    }
    if err2 = oprot.WriteMessageBegin("HasDataById", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServiceHasDataById) Run(reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    args := reqStruct.(*reqMyServiceHasDataById)
    result := newRespMyServiceHasDataById()
    if retval, err := p.handler.HasDataById(args.Id); err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing HasDataById: " + err.Error(), err)
        return x, x
    } else {
        result.Value = retval
    }

    return result, nil
}


type procFuncMyServiceGetDataById struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = &procFuncMyServiceGetDataById{}

func (p *procFuncMyServiceGetDataById) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServiceGetDataById()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServiceGetDataById) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    if _, ok := result.(thrift.ApplicationException); ok {
        messageType = thrift.EXCEPTION
    }
    if err2 = oprot.WriteMessageBegin("GetDataById", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServiceGetDataById) Run(reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    args := reqStruct.(*reqMyServiceGetDataById)
    result := newRespMyServiceGetDataById()
    if retval, err := p.handler.GetDataById(args.Id); err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GetDataById: " + err.Error(), err)
        return x, x
    } else {
        result.Value = retval
    }

    return result, nil
}


type procFuncMyServicePutDataById struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = &procFuncMyServicePutDataById{}

func (p *procFuncMyServicePutDataById) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServicePutDataById()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServicePutDataById) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    if _, ok := result.(thrift.ApplicationException); ok {
        messageType = thrift.EXCEPTION
    }
    if err2 = oprot.WriteMessageBegin("PutDataById", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServicePutDataById) Run(reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    args := reqStruct.(*reqMyServicePutDataById)
    result := newRespMyServicePutDataById()
    if err := p.handler.PutDataById(args.Id, args.Data); err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing PutDataById: " + err.Error(), err)
        return x, x
    }
    return result, nil
}


type procFuncMyServiceLobDataById struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = &procFuncMyServiceLobDataById{}

func (p *procFuncMyServiceLobDataById) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServiceLobDataById()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServiceLobDataById) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    if _, ok := result.(thrift.ApplicationException); ok {
        messageType = thrift.EXCEPTION
    }
    if err2 = oprot.WriteMessageBegin("LobDataById", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServiceLobDataById) Run(reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    args := reqStruct.(*reqMyServiceLobDataById)
    result := newRespMyServiceLobDataById()
    if err := p.handler.LobDataById(args.Id, args.Data); err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing LobDataById: " + err.Error(), err)
        return x, x
    }
    return result, nil
}


type procFuncMyServiceGoDoNothing struct {
    handler MyService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = &procFuncMyServiceGoDoNothing{}

func (p *procFuncMyServiceGoDoNothing) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServiceGoDoNothing()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServiceGoDoNothing) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    if _, ok := result.(thrift.ApplicationException); ok {
        messageType = thrift.EXCEPTION
    }
    if err2 = oprot.WriteMessageBegin("GoDoNothing", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServiceGoDoNothing) Run(reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespMyServiceGoDoNothing()
    if err := p.handler.GoDoNothing(); err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing GoDoNothing: " + err.Error(), err)
        return x, x
    }
    return result, nil
}




type MyServicePrioParent interface {
    Ping(ctx context.Context) error
    Pong(ctx context.Context) error
}

// Deprecated: Use MyServicePrioParent instead.
type MyServicePrioParentClientInterface interface {
  thrift.ClientInterface
  Ping() error
  Pong() error
}

type MyServicePrioParentChannelClient struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ MyServicePrioParent = &MyServicePrioParentChannelClient{}

func NewMyServicePrioParentChannelClient(channel thrift.RequestChannel) *MyServicePrioParentChannelClient {
    return &MyServicePrioParentChannelClient{
        ch: channel,
    }
}

func (c *MyServicePrioParentChannelClient) Close() error {
    return c.ch.Close()
}

func (c *MyServicePrioParentChannelClient) IsOpen() bool {
    return c.ch.IsOpen()
}

func (c *MyServicePrioParentChannelClient) Open() error {
    return c.ch.Open()
}

// Deprecated: Use MyServicePrioParentChannelClient instead.
type MyServicePrioParentClient struct {
    chClient *MyServicePrioParentChannelClient
}
// Compile time interface enforcer
var _ MyServicePrioParentClientInterface = &MyServicePrioParentClient{}

// Deprecated: Use NewMyServicePrioParentChannelClient() instead.
func NewMyServicePrioParentClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *MyServicePrioParentClient {
    return &MyServicePrioParentClient{
        chClient: NewMyServicePrioParentChannelClient(
            thrift.NewSerialChannel(iprot),
        ),
    }
}

func (c *MyServicePrioParentClient) Close() error {
    return c.chClient.Close()
}

func (c *MyServicePrioParentClient) IsOpen() bool {
    return c.chClient.IsOpen()
}

func (c *MyServicePrioParentClient) Open() error {
    return c.chClient.Open()
}

// Deprecated: Use MyServicePrioParentChannelClient instead.
type MyServicePrioParentThreadsafeClient = MyServicePrioParentClient

// Deprecated: Use NewMyServicePrioParentChannelClient() instead.
func NewMyServicePrioParentThreadsafeClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *MyServicePrioParentThreadsafeClient {
    return NewMyServicePrioParentClient(t, iprot, oprot)
}

// Deprecated: Use NewMyServicePrioParentChannelClient() instead.
func NewMyServicePrioParentClientProtocol(prot thrift.Protocol) *MyServicePrioParentClient {
  return NewMyServicePrioParentClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewMyServicePrioParentChannelClient() instead.
func NewMyServicePrioParentThreadsafeClientProtocol(prot thrift.Protocol) *MyServicePrioParentClient {
  return NewMyServicePrioParentClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewMyServicePrioParentChannelClient() instead.
func NewMyServicePrioParentClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *MyServicePrioParentClient {
  iprot := pf.GetProtocol(t)
  oprot := pf.GetProtocol(t)
  return NewMyServicePrioParentClient(t, iprot, oprot)
}

// Deprecated: Use NewMyServicePrioParentChannelClient() instead.
func NewMyServicePrioParentThreadsafeClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *MyServicePrioParentThreadsafeClient {
  return NewMyServicePrioParentClientFactory(t, pf)
}


func (c *MyServicePrioParentChannelClient) Ping(ctx context.Context) error {
    in := &reqMyServicePrioParentPing{
    }
    out := newRespMyServicePrioParentPing()
    err := c.ch.Call(ctx, "ping", in, out)
    return err
}

func (c *MyServicePrioParentClient) Ping() error {
    return c.chClient.Ping(nil)
}


func (c *MyServicePrioParentChannelClient) Pong(ctx context.Context) error {
    in := &reqMyServicePrioParentPong{
    }
    out := newRespMyServicePrioParentPong()
    err := c.ch.Call(ctx, "pong", in, out)
    return err
}

func (c *MyServicePrioParentClient) Pong() error {
    return c.chClient.Pong(nil)
}


type reqMyServicePrioParentPing struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServicePrioParentPing{}

func newReqMyServicePrioParentPing() *reqMyServicePrioParentPing {
    return (&reqMyServicePrioParentPing{})
}

// Deprecated: Use reqMyServicePrioParentPing.Set* methods instead or set the fields directly.
type reqMyServicePrioParentPingBuilder struct {
    obj *reqMyServicePrioParentPing
}

func newReqMyServicePrioParentPingBuilder() *reqMyServicePrioParentPingBuilder {
    return &reqMyServicePrioParentPingBuilder{
        obj: newReqMyServicePrioParentPing(),
    }
}

func (x *reqMyServicePrioParentPingBuilder) Emit() *reqMyServicePrioParentPing {
    var objCopy reqMyServicePrioParentPing = *x.obj
    return &objCopy
}

func (x *reqMyServicePrioParentPing) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("req_MyServicePrioParent_ping"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServicePrioParentPing) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type respMyServicePrioParentPing struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServicePrioParentPing{}

func newRespMyServicePrioParentPing() *respMyServicePrioParentPing {
    return (&respMyServicePrioParentPing{})
}

// Deprecated: Use respMyServicePrioParentPing.Set* methods instead or set the fields directly.
type respMyServicePrioParentPingBuilder struct {
    obj *respMyServicePrioParentPing
}

func newRespMyServicePrioParentPingBuilder() *respMyServicePrioParentPingBuilder {
    return &respMyServicePrioParentPingBuilder{
        obj: newRespMyServicePrioParentPing(),
    }
}

func (x *respMyServicePrioParentPingBuilder) Emit() *respMyServicePrioParentPing {
    var objCopy respMyServicePrioParentPing = *x.obj
    return &objCopy
}

func (x *respMyServicePrioParentPing) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("resp_MyServicePrioParent_ping"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServicePrioParentPing) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type reqMyServicePrioParentPong struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServicePrioParentPong{}

func newReqMyServicePrioParentPong() *reqMyServicePrioParentPong {
    return (&reqMyServicePrioParentPong{})
}

// Deprecated: Use reqMyServicePrioParentPong.Set* methods instead or set the fields directly.
type reqMyServicePrioParentPongBuilder struct {
    obj *reqMyServicePrioParentPong
}

func newReqMyServicePrioParentPongBuilder() *reqMyServicePrioParentPongBuilder {
    return &reqMyServicePrioParentPongBuilder{
        obj: newReqMyServicePrioParentPong(),
    }
}

func (x *reqMyServicePrioParentPongBuilder) Emit() *reqMyServicePrioParentPong {
    var objCopy reqMyServicePrioParentPong = *x.obj
    return &objCopy
}

func (x *reqMyServicePrioParentPong) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("req_MyServicePrioParent_pong"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServicePrioParentPong) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type respMyServicePrioParentPong struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServicePrioParentPong{}

func newRespMyServicePrioParentPong() *respMyServicePrioParentPong {
    return (&respMyServicePrioParentPong{})
}

// Deprecated: Use respMyServicePrioParentPong.Set* methods instead or set the fields directly.
type respMyServicePrioParentPongBuilder struct {
    obj *respMyServicePrioParentPong
}

func newRespMyServicePrioParentPongBuilder() *respMyServicePrioParentPongBuilder {
    return &respMyServicePrioParentPongBuilder{
        obj: newRespMyServicePrioParentPong(),
    }
}

func (x *respMyServicePrioParentPongBuilder) Emit() *respMyServicePrioParentPong {
    var objCopy respMyServicePrioParentPong = *x.obj
    return &objCopy
}

func (x *respMyServicePrioParentPong) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("resp_MyServicePrioParent_pong"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServicePrioParentPong) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type MyServicePrioParentProcessor struct {
    processorMap       map[string]thrift.ProcessorFunction
    functionServiceMap map[string]string
    handler            MyServicePrioParent
}
// Compile time interface enforcer
var _ thrift.Processor = &MyServicePrioParentProcessor{}

func (p *MyServicePrioParentProcessor) AddToProcessorMap(key string, processor thrift.ProcessorFunction) {
    p.processorMap[key] = processor
}

func (p *MyServicePrioParentProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *MyServicePrioParentProcessor) GetProcessorFunction(key string) (processor thrift.ProcessorFunction, err error) {
    if processor, ok := p.processorMap[key]; ok {
        return processor, nil
    }
    return nil, nil
}

func (p *MyServicePrioParentProcessor) ProcessorMap() map[string]thrift.ProcessorFunction {
    return p.processorMap
}

func (p *MyServicePrioParentProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func NewMyServicePrioParentProcessor(handler MyServicePrioParent) *MyServicePrioParentProcessor {
    p := &MyServicePrioParentProcessor{
        handler:            handler,
        processorMap:       make(map[string]thrift.ProcessorFunction),
        functionServiceMap: make(map[string]string),
    }
    p.AddToProcessorMap("ping", &procFuncMyServicePrioParentPing{handler: handler})
    p.AddToProcessorMap("pong", &procFuncMyServicePrioParentPong{handler: handler})
    p.AddToFunctionServiceMap("ping", "MyServicePrioParent")
    p.AddToFunctionServiceMap("pong", "MyServicePrioParent")

    return p
}


type procFuncMyServicePrioParentPing struct {
    handler MyServicePrioParent
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = &procFuncMyServicePrioParentPing{}

func (p *procFuncMyServicePrioParentPing) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServicePrioParentPing()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServicePrioParentPing) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    if _, ok := result.(thrift.ApplicationException); ok {
        messageType = thrift.EXCEPTION
    }
    if err2 = oprot.WriteMessageBegin("Ping", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServicePrioParentPing) Run(reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespMyServicePrioParentPing()
    if err := p.handler.Ping(); err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing Ping: " + err.Error(), err)
        return x, x
    }
    return result, nil
}


type procFuncMyServicePrioParentPong struct {
    handler MyServicePrioParent
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = &procFuncMyServicePrioParentPong{}

func (p *procFuncMyServicePrioParentPong) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServicePrioParentPong()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServicePrioParentPong) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    if _, ok := result.(thrift.ApplicationException); ok {
        messageType = thrift.EXCEPTION
    }
    if err2 = oprot.WriteMessageBegin("Pong", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServicePrioParentPong) Run(reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespMyServicePrioParentPong()
    if err := p.handler.Pong(); err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing Pong: " + err.Error(), err)
        return x, x
    }
    return result, nil
}




type MyServicePrioChild interface {
    // Inherited/extended service
    MyServicePrioParent

    Pang(ctx context.Context) error
}

// Deprecated: Use MyServicePrioChild instead.
type MyServicePrioChildClientInterface interface {
  thrift.ClientInterface
  // Inherited/extended service
  MyServicePrioParentClientInterface

  Pang() error
}

type MyServicePrioChildChannelClient struct {
    // Inherited/extended service
    *MyServicePrioParentChannelClient
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ MyServicePrioChild = &MyServicePrioChildChannelClient{}

func NewMyServicePrioChildChannelClient(channel thrift.RequestChannel) *MyServicePrioChildChannelClient {
    return &MyServicePrioChildChannelClient{
        MyServicePrioParentChannelClient: NewMyServicePrioParentChannelClient(channel),
        ch: channel,
    }
}

func (c *MyServicePrioChildChannelClient) Close() error {
    return c.ch.Close()
}

func (c *MyServicePrioChildChannelClient) IsOpen() bool {
    return c.ch.IsOpen()
}

func (c *MyServicePrioChildChannelClient) Open() error {
    return c.ch.Open()
}

// Deprecated: Use MyServicePrioChildChannelClient instead.
type MyServicePrioChildClient struct {
    // Inherited/extended service
    *MyServicePrioParentClient
    chClient *MyServicePrioChildChannelClient
}
// Compile time interface enforcer
var _ MyServicePrioChildClientInterface = &MyServicePrioChildClient{}

// Deprecated: Use NewMyServicePrioChildChannelClient() instead.
func NewMyServicePrioChildClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *MyServicePrioChildClient {
    return &MyServicePrioChildClient{
        MyServicePrioParentClient: NewMyServicePrioParentClient(t, iprot, oprot),
        chClient: NewMyServicePrioChildChannelClient(
            thrift.NewSerialChannel(iprot),
        ),
    }
}

func (c *MyServicePrioChildClient) Close() error {
    return c.chClient.Close()
}

func (c *MyServicePrioChildClient) IsOpen() bool {
    return c.chClient.IsOpen()
}

func (c *MyServicePrioChildClient) Open() error {
    return c.chClient.Open()
}

// Deprecated: Use MyServicePrioChildChannelClient instead.
type MyServicePrioChildThreadsafeClient = MyServicePrioChildClient

// Deprecated: Use NewMyServicePrioChildChannelClient() instead.
func NewMyServicePrioChildThreadsafeClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *MyServicePrioChildThreadsafeClient {
    return NewMyServicePrioChildClient(t, iprot, oprot)
}

// Deprecated: Use NewMyServicePrioChildChannelClient() instead.
func NewMyServicePrioChildClientProtocol(prot thrift.Protocol) *MyServicePrioChildClient {
  return NewMyServicePrioChildClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewMyServicePrioChildChannelClient() instead.
func NewMyServicePrioChildThreadsafeClientProtocol(prot thrift.Protocol) *MyServicePrioChildClient {
  return NewMyServicePrioChildClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewMyServicePrioChildChannelClient() instead.
func NewMyServicePrioChildClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *MyServicePrioChildClient {
  iprot := pf.GetProtocol(t)
  oprot := pf.GetProtocol(t)
  return NewMyServicePrioChildClient(t, iprot, oprot)
}

// Deprecated: Use NewMyServicePrioChildChannelClient() instead.
func NewMyServicePrioChildThreadsafeClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *MyServicePrioChildThreadsafeClient {
  return NewMyServicePrioChildClientFactory(t, pf)
}


func (c *MyServicePrioChildChannelClient) Pang(ctx context.Context) error {
    in := &reqMyServicePrioChildPang{
    }
    out := newRespMyServicePrioChildPang()
    err := c.ch.Call(ctx, "pang", in, out)
    return err
}

func (c *MyServicePrioChildClient) Pang() error {
    return c.chClient.Pang(nil)
}


type reqMyServicePrioChildPang struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqMyServicePrioChildPang{}

func newReqMyServicePrioChildPang() *reqMyServicePrioChildPang {
    return (&reqMyServicePrioChildPang{})
}

// Deprecated: Use reqMyServicePrioChildPang.Set* methods instead or set the fields directly.
type reqMyServicePrioChildPangBuilder struct {
    obj *reqMyServicePrioChildPang
}

func newReqMyServicePrioChildPangBuilder() *reqMyServicePrioChildPangBuilder {
    return &reqMyServicePrioChildPangBuilder{
        obj: newReqMyServicePrioChildPang(),
    }
}

func (x *reqMyServicePrioChildPangBuilder) Emit() *reqMyServicePrioChildPang {
    var objCopy reqMyServicePrioChildPang = *x.obj
    return &objCopy
}

func (x *reqMyServicePrioChildPang) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("req_MyServicePrioChild_pang"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqMyServicePrioChildPang) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type respMyServicePrioChildPang struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &respMyServicePrioChildPang{}

func newRespMyServicePrioChildPang() *respMyServicePrioChildPang {
    return (&respMyServicePrioChildPang{})
}

// Deprecated: Use respMyServicePrioChildPang.Set* methods instead or set the fields directly.
type respMyServicePrioChildPangBuilder struct {
    obj *respMyServicePrioChildPang
}

func newRespMyServicePrioChildPangBuilder() *respMyServicePrioChildPangBuilder {
    return &respMyServicePrioChildPangBuilder{
        obj: newRespMyServicePrioChildPang(),
    }
}

func (x *respMyServicePrioChildPangBuilder) Emit() *respMyServicePrioChildPang {
    var objCopy respMyServicePrioChildPang = *x.obj
    return &objCopy
}

func (x *respMyServicePrioChildPang) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("resp_MyServicePrioChild_pang"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respMyServicePrioChildPang) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type MyServicePrioChildProcessor struct {
    // Inherited/extended processor
    *MyServicePrioParentProcessor
}
// Compile time interface enforcer
var _ thrift.Processor = &MyServicePrioChildProcessor{}


func NewMyServicePrioChildProcessor(handler MyServicePrioChild) *MyServicePrioChildProcessor {
    p := &MyServicePrioChildProcessor{
        NewMyServicePrioParentProcessor(handler),
    }
    p.AddToProcessorMap("pang", &procFuncMyServicePrioChildPang{handler: handler})
    p.AddToFunctionServiceMap("pang", "MyServicePrioChild")

    return p
}


type procFuncMyServicePrioChildPang struct {
    handler MyServicePrioChild
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = &procFuncMyServicePrioChildPang{}

func (p *procFuncMyServicePrioChildPang) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqMyServicePrioChildPang()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncMyServicePrioChildPang) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    if _, ok := result.(thrift.ApplicationException); ok {
        messageType = thrift.EXCEPTION
    }
    if err2 = oprot.WriteMessageBegin("Pang", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncMyServicePrioChildPang) Run(reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespMyServicePrioChildPang()
    if err := p.handler.Pang(); err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing Pang: " + err.Error(), err)
        return x, x
    }
    return result, nil
}




type BadService interface {
    CreateBadInteraction(ctx context.Context) (, error)
    Bar(ctx context.Context) (int32, error)
}

// Deprecated: Use BadService instead.
type BadServiceClientInterface interface {
  thrift.ClientInterface
  CreateBadInteraction() (, error)
  Bar() (int32, error)
}

type BadServiceChannelClient struct {
    ch thrift.RequestChannel
}
// Compile time interface enforcer
var _ BadService = &BadServiceChannelClient{}

func NewBadServiceChannelClient(channel thrift.RequestChannel) *BadServiceChannelClient {
    return &BadServiceChannelClient{
        ch: channel,
    }
}

func (c *BadServiceChannelClient) Close() error {
    return c.ch.Close()
}

func (c *BadServiceChannelClient) IsOpen() bool {
    return c.ch.IsOpen()
}

func (c *BadServiceChannelClient) Open() error {
    return c.ch.Open()
}

// Deprecated: Use BadServiceChannelClient instead.
type BadServiceClient struct {
    chClient *BadServiceChannelClient
}
// Compile time interface enforcer
var _ BadServiceClientInterface = &BadServiceClient{}

// Deprecated: Use NewBadServiceChannelClient() instead.
func NewBadServiceClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *BadServiceClient {
    return &BadServiceClient{
        chClient: NewBadServiceChannelClient(
            thrift.NewSerialChannel(iprot),
        ),
    }
}

func (c *BadServiceClient) Close() error {
    return c.chClient.Close()
}

func (c *BadServiceClient) IsOpen() bool {
    return c.chClient.IsOpen()
}

func (c *BadServiceClient) Open() error {
    return c.chClient.Open()
}

// Deprecated: Use BadServiceChannelClient instead.
type BadServiceThreadsafeClient = BadServiceClient

// Deprecated: Use NewBadServiceChannelClient() instead.
func NewBadServiceThreadsafeClient(t thrift.Transport, iprot thrift.Protocol, oprot thrift.Protocol) *BadServiceThreadsafeClient {
    return NewBadServiceClient(t, iprot, oprot)
}

// Deprecated: Use NewBadServiceChannelClient() instead.
func NewBadServiceClientProtocol(prot thrift.Protocol) *BadServiceClient {
  return NewBadServiceClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewBadServiceChannelClient() instead.
func NewBadServiceThreadsafeClientProtocol(prot thrift.Protocol) *BadServiceClient {
  return NewBadServiceClient(prot.Transport(), prot, prot)
}

// Deprecated: Use NewBadServiceChannelClient() instead.
func NewBadServiceClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *BadServiceClient {
  iprot := pf.GetProtocol(t)
  oprot := pf.GetProtocol(t)
  return NewBadServiceClient(t, iprot, oprot)
}

// Deprecated: Use NewBadServiceChannelClient() instead.
func NewBadServiceThreadsafeClientFactory(t thrift.Transport, pf thrift.ProtocolFactory) *BadServiceThreadsafeClient {
  return NewBadServiceClientFactory(t, pf)
}


func (c *BadServiceChannelClient) CreateBadInteraction(ctx context.Context) (, error) {
    in := &reqBadServiceCreateBadInteraction{
    }
    out := newRespBadServiceCreateBadInteraction()
    err := c.ch.Call(ctx, "createBadInteraction", in, out)
    return out.Value, err
}

func (c *BadServiceClient) CreateBadInteraction() (, error) {
    return c.chClient.CreateBadInteraction(nil)
}


func (c *BadServiceChannelClient) Bar(ctx context.Context) (int32, error) {
    in := &reqBadServiceBar{
    }
    out := newRespBadServiceBar()
    err := c.ch.Call(ctx, "bar", in, out)
    return out.Value, err
}

func (c *BadServiceClient) Bar() (int32, error) {
    return c.chClient.Bar(nil)
}


type reqBadServiceCreateBadInteraction struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqBadServiceCreateBadInteraction{}

func newReqBadServiceCreateBadInteraction() *reqBadServiceCreateBadInteraction {
    return (&reqBadServiceCreateBadInteraction{})
}

// Deprecated: Use reqBadServiceCreateBadInteraction.Set* methods instead or set the fields directly.
type reqBadServiceCreateBadInteractionBuilder struct {
    obj *reqBadServiceCreateBadInteraction
}

func newReqBadServiceCreateBadInteractionBuilder() *reqBadServiceCreateBadInteractionBuilder {
    return &reqBadServiceCreateBadInteractionBuilder{
        obj: newReqBadServiceCreateBadInteraction(),
    }
}

func (x *reqBadServiceCreateBadInteractionBuilder) Emit() *reqBadServiceCreateBadInteraction {
    var objCopy reqBadServiceCreateBadInteraction = *x.obj
    return &objCopy
}

func (x *reqBadServiceCreateBadInteraction) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("req_BadService_createBadInteraction"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqBadServiceCreateBadInteraction) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type respBadServiceCreateBadInteraction struct {
    Value  `thrift:"value,0,required" json:"value" db:"value"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respBadServiceCreateBadInteraction{}

func newRespBadServiceCreateBadInteraction() *respBadServiceCreateBadInteraction {
    return (&respBadServiceCreateBadInteraction{})
}
func (x *respBadServiceCreateBadInteraction) GetValue()  {
    return x.Value
}

func (x *respBadServiceCreateBadInteraction) SetValue(value ) *respBadServiceCreateBadInteraction {
    x.Value = value
    return x
}


func (x *respBadServiceCreateBadInteraction) writeField0(p thrift.Protocol) error {  // Value
    if err := p.WriteFieldBegin("value", , 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetValue()
    
    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respBadServiceCreateBadInteraction) readField0(p thrift.Protocol) error {  // Value
    
    x.SetValue(result)
    return nil
}


// Deprecated: Use respBadServiceCreateBadInteraction.Set* methods instead or set the fields directly.
type respBadServiceCreateBadInteractionBuilder struct {
    obj *respBadServiceCreateBadInteraction
}

func newRespBadServiceCreateBadInteractionBuilder() *respBadServiceCreateBadInteractionBuilder {
    return &respBadServiceCreateBadInteractionBuilder{
        obj: newRespBadServiceCreateBadInteraction(),
    }
}

func (x *respBadServiceCreateBadInteractionBuilder) Value(value ) *respBadServiceCreateBadInteractionBuilder {
    x.obj.Value = value
    return x
}

func (x *respBadServiceCreateBadInteractionBuilder) Emit() *respBadServiceCreateBadInteraction {
    var objCopy respBadServiceCreateBadInteraction = *x.obj
    return &objCopy
}

func (x *respBadServiceCreateBadInteraction) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("resp_BadService_createBadInteraction"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respBadServiceCreateBadInteraction) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 0:  // value
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type reqBadServiceBar struct {
}
// Compile time interface enforcer
var _ thrift.Struct = &reqBadServiceBar{}

func newReqBadServiceBar() *reqBadServiceBar {
    return (&reqBadServiceBar{})
}

// Deprecated: Use reqBadServiceBar.Set* methods instead or set the fields directly.
type reqBadServiceBarBuilder struct {
    obj *reqBadServiceBar
}

func newReqBadServiceBarBuilder() *reqBadServiceBarBuilder {
    return &reqBadServiceBarBuilder{
        obj: newReqBadServiceBar(),
    }
}

func (x *reqBadServiceBarBuilder) Emit() *reqBadServiceBar {
    var objCopy reqBadServiceBar = *x.obj
    return &objCopy
}

func (x *reqBadServiceBar) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("req_BadService_bar"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *reqBadServiceBar) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}
type respBadServiceBar struct {
    Value int32 `thrift:"value,0,required" json:"value" db:"value"`
}
// Compile time interface enforcer
var _ thrift.Struct = &respBadServiceBar{}

func newRespBadServiceBar() *respBadServiceBar {
    return (&respBadServiceBar{})
}
func (x *respBadServiceBar) GetValue() int32 {
    return x.Value
}

func (x *respBadServiceBar) SetValue(value int32) *respBadServiceBar {
    x.Value = value
    return x
}


func (x *respBadServiceBar) writeField0(p thrift.Protocol) error {  // Value
    if err := p.WriteFieldBegin("value", thrift.I32, 0); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field begin error: ", x), err)
    }

    item := x.GetValue()
    if err := p.WriteI32(item); err != nil {
    return err
}

    if err := p.WriteFieldEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field end error: ", x), err)
    }
    return nil
}

func (x *respBadServiceBar) readField0(p thrift.Protocol) error {  // Value
    result, err := p.ReadI32()
if err != nil {
    return err
}

    x.SetValue(result)
    return nil
}


// Deprecated: Use respBadServiceBar.Set* methods instead or set the fields directly.
type respBadServiceBarBuilder struct {
    obj *respBadServiceBar
}

func newRespBadServiceBarBuilder() *respBadServiceBarBuilder {
    return &respBadServiceBarBuilder{
        obj: newRespBadServiceBar(),
    }
}

func (x *respBadServiceBarBuilder) Value(value int32) *respBadServiceBarBuilder {
    x.obj.Value = value
    return x
}

func (x *respBadServiceBarBuilder) Emit() *respBadServiceBar {
    var objCopy respBadServiceBar = *x.obj
    return &objCopy
}

func (x *respBadServiceBar) Write(p thrift.Protocol) error {
    if err := p.WriteStructBegin("resp_BadService_bar"); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", x), err)
    }

    if err := x.writeField0(p); err != nil {
        return err
    }

    if err := p.WriteFieldStop(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write field stop error: ", x), err)
    }

    if err := p.WriteStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T write struct end error: ", x), err)
    }
    return nil
}

func (x *respBadServiceBar) Read(p thrift.Protocol) error {
    if _, err := p.ReadStructBegin(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read error: ", x), err)
    }

    for {
        _, typ, id, err := p.ReadFieldBegin()
        if err != nil {
            return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", x, id), err)
        }

        if typ == thrift.STOP {
            break;
        }

        switch id {
        case 0:  // value
            if err := x.readField0(p); err != nil {
                return err
            }
        default:
            if err := p.Skip(typ); err != nil {
                return err
            }
        }

        if err := p.ReadFieldEnd(); err != nil {
            return err
        }
    }

    if err := p.ReadStructEnd(); err != nil {
        return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", x), err)
    }

    return nil
}


type BadServiceProcessor struct {
    processorMap       map[string]thrift.ProcessorFunction
    functionServiceMap map[string]string
    handler            BadService
}
// Compile time interface enforcer
var _ thrift.Processor = &BadServiceProcessor{}

func (p *BadServiceProcessor) AddToProcessorMap(key string, processor thrift.ProcessorFunction) {
    p.processorMap[key] = processor
}

func (p *BadServiceProcessor) AddToFunctionServiceMap(key, service string) {
    p.functionServiceMap[key] = service
}

func (p *BadServiceProcessor) GetProcessorFunction(key string) (processor thrift.ProcessorFunction, err error) {
    if processor, ok := p.processorMap[key]; ok {
        return processor, nil
    }
    return nil, nil
}

func (p *BadServiceProcessor) ProcessorMap() map[string]thrift.ProcessorFunction {
    return p.processorMap
}

func (p *BadServiceProcessor) FunctionServiceMap() map[string]string {
    return p.functionServiceMap
}

func NewBadServiceProcessor(handler BadService) *BadServiceProcessor {
    p := &BadServiceProcessor{
        handler:            handler,
        processorMap:       make(map[string]thrift.ProcessorFunction),
        functionServiceMap: make(map[string]string),
    }
    p.AddToProcessorMap("createBadInteraction", &procFuncBadServiceCreateBadInteraction{handler: handler})
    p.AddToProcessorMap("bar", &procFuncBadServiceBar{handler: handler})
    p.AddToFunctionServiceMap("createBadInteraction", "BadService")
    p.AddToFunctionServiceMap("bar", "BadService")

    return p
}


type procFuncBadServiceCreateBadInteraction struct {
    handler BadService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = &procFuncBadServiceCreateBadInteraction{}

func (p *procFuncBadServiceCreateBadInteraction) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqBadServiceCreateBadInteraction()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncBadServiceCreateBadInteraction) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    if _, ok := result.(thrift.ApplicationException); ok {
        messageType = thrift.EXCEPTION
    }
    if err2 = oprot.WriteMessageBegin("CreateBadInteraction", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncBadServiceCreateBadInteraction) Run(reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespBadServiceCreateBadInteraction()
    if retval, err := p.handler.CreateBadInteraction(); err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing CreateBadInteraction: " + err.Error(), err)
        return x, x
    } else {
        result.Value = retval
    }

    return result, nil
}


type procFuncBadServiceBar struct {
    handler BadService
}
// Compile time interface enforcer
var _ thrift.ProcessorFunction = &procFuncBadServiceBar{}

func (p *procFuncBadServiceBar) Read(iprot thrift.Protocol) (thrift.Struct, thrift.Exception) {
    args := newReqBadServiceBar()
    if err := args.Read(iprot); err != nil {
        return nil, err
    }
    iprot.ReadMessageEnd()
    return args, nil
}

func (p *procFuncBadServiceBar) Write(seqId int32, result thrift.WritableStruct, oprot thrift.Protocol) (err thrift.Exception) {
    var err2 error
    messageType := thrift.REPLY
    if _, ok := result.(thrift.ApplicationException); ok {
        messageType = thrift.EXCEPTION
    }
    if err2 = oprot.WriteMessageBegin("Bar", messageType, seqId); err2 != nil {
        err = err2
    }
    if err2 = result.Write(oprot); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.WriteMessageEnd(); err == nil && err2 != nil {
        err = err2
    }
    if err2 = oprot.Flush(); err == nil && err2 != nil {
        err = err2
    }
    return err
}

func (p *procFuncBadServiceBar) Run(reqStruct thrift.Struct) (thrift.WritableStruct, thrift.ApplicationException) {
    result := newRespBadServiceBar()
    if retval, err := p.handler.Bar(); err != nil {
        x := thrift.NewApplicationExceptionCause(thrift.INTERNAL_ERROR, "Internal error processing Bar: " + err.Error(), err)
        return x, x
    } else {
        result.Value = retval
    }

    return result, nil
}


