// Autogenerated by Thrift Compiler (facebook)
// DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
// @generated

package main

import (
        "flag"
        "fmt"
        "math"
        "net"
        "net/url"
        "os"
        "strconv"
        "strings"
        thrift "github.com/facebook/fbthrift/thrift/lib/go/thrift"
        "../../module"
)

func Usage() {
  fmt.Fprintln(os.Stderr, "Usage of ", os.Args[0], " [-h host:port] [-u url] [-f[ramed]] function [arg1 [arg2...]]:")
  flag.PrintDefaults()
  fmt.Fprintln(os.Stderr, "\nFunctions:")
  fmt.Fprintln(os.Stderr, "  GetEntityResponse getEntity(GetEntityRequest r)")
  fmt.Fprintln(os.Stderr, "  bool getBool()")
  fmt.Fprintln(os.Stderr, "  byte getByte()")
  fmt.Fprintln(os.Stderr, "  i16 getI16()")
  fmt.Fprintln(os.Stderr, "  i32 getI32()")
  fmt.Fprintln(os.Stderr, "  i64 getI64()")
  fmt.Fprintln(os.Stderr, "  double getDouble()")
  fmt.Fprintln(os.Stderr, "  string getString()")
  fmt.Fprintln(os.Stderr, "  string getBinary()")
  fmt.Fprintln(os.Stderr, "   getMap()")
  fmt.Fprintln(os.Stderr, "   getSet()")
  fmt.Fprintln(os.Stderr, "   getList()")
  fmt.Fprintln(os.Stderr, "  i32 getLegacyStuff(i64 numPos, i64 numNeg1, i64 numNeg2)")
  fmt.Fprintln(os.Stderr)
  os.Exit(0)
}

func main() {
  flag.Usage = Usage
  var host string
  var port int
  var protocol string
  var urlString string
  var framed bool
  var useHttp bool
  var parsedUrl url.URL
  var trans thrift.Transport
  _ = strconv.Atoi
  _ = math.Abs
  flag.Usage = Usage
  flag.StringVar(&host, "h", "localhost", "Specify host")
  flag.IntVar(&port, "p", 9090, "Specify port")
  flag.StringVar(&protocol, "P", "binary", "Specify the protocol (binary, compact, simplejson, json)")
  flag.StringVar(&urlString, "u", "", "Specify the url")
  flag.BoolVar(&framed, "framed", false, "Use framed transport")
  flag.BoolVar(&useHttp, "http", false, "Use http")
  flag.Parse()
  
  if len(urlString) > 0 {
    parsedUrl, err := url.Parse(urlString)
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
    host = parsedUrl.Host
    useHttp = len(parsedUrl.Scheme) <= 0 || parsedUrl.Scheme == "http"
  } else if useHttp {
    _, err := url.Parse(fmt.Sprint("http://", host, ":", port))
    if err != nil {
      fmt.Fprintln(os.Stderr, "Error parsing URL: ", err)
      flag.Usage()
    }
  }
  
  cmd := flag.Arg(0)
  var err error
  if useHttp {
    trans, err = thrift.NewHTTPPostClient(parsedUrl.String())
  } else {
    portStr := fmt.Sprint(port)
    if strings.Contains(host, ":") {
           host, portStr, err = net.SplitHostPort(host)
           if err != nil {
                   fmt.Fprintln(os.Stderr, "error with host:", err)
                   os.Exit(1)
           }
    }
    trans, err = thrift.NewSocket(thrift.SocketAddr(net.JoinHostPort(host, portStr)))
    if err != nil {
      fmt.Fprintln(os.Stderr, "error resolving address:", err)
      os.Exit(1)
    }
    if framed {
      trans = thrift.NewFramedTransport(trans)
    }
  }
  if err != nil {
    fmt.Fprintln(os.Stderr, "Error creating transport", err)
    os.Exit(1)
  }
  defer trans.Close()
  var protocolFactory thrift.ProtocolFactory
  switch protocol {
  case "compact":
    protocolFactory = thrift.NewCompactProtocolFactory()
    break
  case "simplejson":
    protocolFactory = thrift.NewSimpleJSONProtocolFactory()
    break
  case "json":
    protocolFactory = thrift.NewJSONProtocolFactory()
    break
  case "binary", "":
    protocolFactory = thrift.NewBinaryProtocolFactoryDefault()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid protocol specified: ", protocol)
    Usage()
    os.Exit(1)
  }
  client := module.NewGetEntityClientFactory(trans, protocolFactory)
  if err := trans.Open(); err != nil {
    fmt.Fprintln(os.Stderr, "Error opening socket to ", host, ":", port, " ", err)
    os.Exit(1)
  }
  
  switch cmd {
  case "getEntity":
    if flag.NArg() - 1 != 1 {
      fmt.Fprintln(os.Stderr, "GetEntity requires 1 args")
      flag.Usage()
    }
    arg6 := flag.Arg(1)
    mbTrans7 := thrift.NewMemoryBufferLen(len(arg6))
    defer mbTrans7.Close()
    _, err8 := mbTrans7.WriteString(arg6)
    if err8 != nil {
      Usage()
      return
    }
    factory9 := thrift.NewSimpleJSONProtocolFactory()
    jsProt10 := factory9.GetProtocol(mbTrans7)
    argvalue0 := module.NewGetEntityRequest()
    err11 := argvalue0.Read(jsProt10)
    if err11 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    fmt.Print(client.GetEntity(value0))
    fmt.Print("\n")
    break
  case "getBool":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetBool requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetBool())
    fmt.Print("\n")
    break
  case "getByte":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetByte requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetByte())
    fmt.Print("\n")
    break
  case "getI16":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetI16 requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetI16())
    fmt.Print("\n")
    break
  case "getI32":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetI32 requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetI32())
    fmt.Print("\n")
    break
  case "getI64":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetI64 requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetI64())
    fmt.Print("\n")
    break
  case "getDouble":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetDouble requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetDouble())
    fmt.Print("\n")
    break
  case "getString":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetString requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetString())
    fmt.Print("\n")
    break
  case "getBinary":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetBinary requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetBinary())
    fmt.Print("\n")
    break
  case "getMap":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetMap requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetMap())
    fmt.Print("\n")
    break
  case "getSet":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetSet requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetSet())
    fmt.Print("\n")
    break
  case "getList":
    if flag.NArg() - 1 != 0 {
      fmt.Fprintln(os.Stderr, "GetList requires 0 args")
      flag.Usage()
    }
    fmt.Print(client.GetList())
    fmt.Print("\n")
    break
  case "getLegacyStuff":
    if flag.NArg() - 1 != 3 {
      fmt.Fprintln(os.Stderr, "GetLegacyStuff requires 3 args")
      flag.Usage()
    }
    argvalue0, err12 := (strconv.ParseInt(flag.Arg(1), 10, 64))
    if err12 != nil {
      Usage()
      return
    }
    value0 := argvalue0
    argvalue1, err13 := (strconv.ParseInt(flag.Arg(2), 10, 64))
    if err13 != nil {
      Usage()
      return
    }
    value1 := argvalue1
    argvalue2, err14 := (strconv.ParseInt(flag.Arg(3), 10, 64))
    if err14 != nil {
      Usage()
      return
    }
    value2 := argvalue2
    fmt.Print(client.GetLegacyStuff(value0, value1, value2))
    fmt.Print("\n")
    break
  case "":
    Usage()
    break
  default:
    fmt.Fprintln(os.Stderr, "Invalid function ", cmd)
  }
}
