/*
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <folly/portability/GTest.h>

#include <thrift/lib/cpp2/transport/rocket/test/fuzz/FuzzUtil.h>

namespace apache {
namespace thrift {
namespace rocket {
namespace test {

TEST(BadInputTests, ParitialRequest) {
  // clang-format off
  unsigned char input[] = {
      0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x01, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x52, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xd4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd4, 0x00, 0x00,
      0x00, 0x00, 0x00, 0xf9, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x7e, 0x7e,
      0x7e, 0x7e, 0x7e, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00,
      0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74,
      0x52, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0xd4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0xd4, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf9, 0x02, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17,
      0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x00,
      0x00, 0x00, 0x00, 0x74, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd4, 0x00, 0x00, 0xd4, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xf9, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x17, 0x17,
      0x17, 0x17, 0x1f, 0xdb, 0x17, 0x17, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17,
      0x17, 0x17, 0x17, 0x17};
  // clang-format on
  unsigned int length = 388;
  testServerOneInput(input, length);
}

TEST(BadInputTests, MetaDataCorruption) {
  // clang-format off
  unsigned char input[] = {
      // setup frame
      0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0x0a,
      0x74, 0x65, 0x78, 0x74, 0x2f, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x0a,
      0x74, 0x65, 0x78, 0x74, 0x2f, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x00,
      0x00, 0x1d, 0x00, 0x00, 0x00, 0x01, 0x1b, 0x01, 0x88, 0x09, 0x72,
      0x61, 0x6e, 0x64, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x0a, 0x73, 0x65,
      0x74, 0x75, 0x70, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x00,
      // request response frame
      0x00, 0x00, 0x2f, 0x00, 0x00, 0x00, 0x01, 0x11, 0x00, 0x00, 0x00,
      0xf7, // unbounded metadata size
      0x15, 0x00, 0x18, 0x0d, 0x73, 0x75, 0x6d, 0x54, 0x77, 0x6f,
      0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x15, 0x00, 0x25, 0xe8,
      0x07, 0x00, 0x08, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00,
      0x02, 0x00, 0x00, 0x00, 0x02, 0x00};
  // clang-format on
  // 75 + 50
  unsigned int length = 125;
  testServerOneInput(input, length);
}

TEST(BadInputTests, BigMetaData) {
  // clang-format off
  unsigned char input[] = {
      0x00, 0x00, 0x13,
      0x00, 0x00, 0x00, 0x01, // stream ID = 1
      0x2b, 0x6a, // frame type = 0xa (PAYLOAD) | flags = 0x36a
      0xff, 0xd1, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
      0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x2a,
      0xc4, 0xc1, 0xd1, 0x30, 0x7e, 0x00, 0x00, 0x00, 0x07, 0x05, 0x51, 0xc1,
      0x00, 0x30, 0xd7, 0x07, 0x00, 0x00, 0x07, 0x2a, 0xc4, 0xc1, 0xd1, 0x30,
      0x7e, 0x00, 0x00, 0x00, 0x07, 0x05, 0x51, 0xc1, 0x00, 0x30, 0xd7, 0x07,
      0x00, 0x00, 0x00, 0xdb, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0x25, 0x41,
      0xc1, 0x7e, 0xff, 0xff, 0xff, 0x00, 0x30, 0x00, 0xd0, 0xff, 0x30, 0x7e,
      0xfa, 0x50, 0x00, 0x07, 0x00, 0xff, 0xff, 0x88, 0x00, 0x0b, 0x00, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x07, 0xc1,
      0xfe, 0xff, 0xff, 0x27, 0x2e, 0x00, 0x00, 0x0e, 0x00, 0xff, 0x0a, 0x00,
      0xff, 0xff, 0x33, 0x00, 0xff, 0xc7, 0x28, 0x00, 0x00, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff};
  // clang-format on
  testClientOneInput(input, sizeof(input));
}

TEST(BadInputTests, BadPayloadNoComplete) {
  // clang-format off
  unsigned char input[] = {
      0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x01, 0x2b,
      0x20, // flags (no complete)
      0xff, 0xd1, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
  // clang-format on
  testClientOneInput(input, sizeof(input));
}

TEST(BadInputTests, BadPayloadNoNext) {
  // clang-format off
  unsigned char input[] = {
      0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x01, 0x2b,
      0x40, // flags (no next)
      0xff, 0xd1, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
  // clang-format on
  testClientOneInput(input, sizeof(input));
}

TEST(BadInputTests, ErrorFollowingPartialPayload) {
  // clang-format off
  unsigned char input[] = {
      // partial frame
      0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x01, 0x2b,
      0xe0, // flags, (has follow)
      0xff, 0xd1, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      //error frame
      0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x01, 0x2c,
      0x00, 0x00, 0x00, 0x01,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    };
  // clang-format on
  testClientOneInput(input, sizeof(input));
}

} // namespace test
} // namespace rocket
} // namespace thrift
} // namespace apache
