/*
 * Copyright 2016-present Facebook, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <thrift/test/gen-cpp2/reflection_fatal_types.h>

#include <thrift/lib/cpp2/fatal/internal/test_helpers.h>

#include <gtest/gtest.h>

namespace test_cpp2 {
namespace cpp_reflection {

TEST(reflection_deps, recursive_dependencies) {
  using namespace apache::thrift;
  EXPECT_SAME<type_class::structure, reflect_type_class<dep_A_struct>>();

  using b_type = typename std::decay<
    decltype(std::declval<dep_A_struct>().b)
  >::type;
  EXPECT_SAME<type_class::structure, reflect_type_class<b_type>>();

  using c_type = typename std::decay<
    decltype(std::declval<dep_A_struct>().c)
  >::type;
  EXPECT_SAME<type_class::structure, reflect_type_class<c_type>>();

  using d_type = typename std::decay<decltype(std::declval<c_type>().d)>::type;
  EXPECT_SAME<type_class::structure, reflect_type_class<d_type>>();
}

} // namespace cpp_reflection {
} // namespace test_cpp2 {
