/*
 * Copyright 2009-present Facebook, Inc.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#include <stdio.h>

#include <folly/init/Init.h>

#include <thrift/lib/cpp/protocol/TBinaryProtocol.h>
#include <thrift/lib/cpp/protocol/TCompactProtocol.h>
#include <thrift/lib/cpp/protocol/THeaderProtocol.h>
#include <thrift/lib/cpp/protocol/TJSONProtocol.h>
#include <thrift/lib/cpp/transport/TBufferTransports.h>
#include <thrift/test/AllProtocolTests.tcc>

using namespace apache::thrift;
using namespace apache::thrift::test;
using namespace apache::thrift::protocol;

char errorMessage[ERR_LEN];

int main(int argc, char** argv) {
  folly::init(&argc, &argv);

  try {
    testProtocol<TBinaryProtocol>("TBinaryProtocol");
    testProtocol<TCompactProtocol>("TCompactProtocol");
    testProtocol<THeaderProtocol>("THeaderProtocol");
    testProtocol<TJSONProtocol>("TJSONProtocol");
  } catch (const TException& e) {
    printf("%s\n", e.what());
    return 1;
  }
  return 0;
}
