/* -----------------------------------------------------------------------------
 * filehelp.c defines file helper APIs.
 *
 * Author: Frank Balluffi
 *
 * Copyright (C) 2002-2005 Frank Balluffi. All rights reserved.
 * -----------------------------------------------------------------------------
 */

#include "../../include/filehelp.h"

#include <stdio.h>
#include <stdlib.h>

void * fileToMemory (const char * file,
                     size_t *     length)
{
    long   fileSize  = 0;
    void * memory    = NULL;
    size_t readCount = 0;
    FILE * stream    = NULL;

   /*
    Microsoft says, "If t or b is not given in mode, the default translation
    mode is defined by the global variable _fmode. Solaris says, "The character
    b has no effect, but is allowed for ISO C standard conformance."
    */

    stream = fopen (file, "rb");

    if (!stream)
        return NULL;

    if (fseek (stream, 0, SEEK_END))
        goto error;

    fileSize = ftell (stream);

    if (fileSize == -1L)
        goto error;

    if (fseek (stream, 0, SEEK_SET))
        goto error;

    memory = malloc (fileSize);

    if (!memory)
        goto error;

    readCount = fread (memory,
                       sizeof (unsigned char),
                       fileSize,
                       stream);
    fclose (stream);
    stream = NULL;

    if ((long) readCount != fileSize)
        goto error;

    if (length)
        *length = readCount;

    return memory;

error:

    if (memory)
        free (memory);

    if (stream)
        fclose (stream);

    return NULL;
}

int memoryToFile (const char * file,
                  const void * memory,
                  size_t       length)
{
    FILE * stream     = NULL;
    size_t writeCount = 0;

    stream = fopen (file, "wb");

    if (!stream)
        return 0;

    writeCount = fwrite (memory,
                         sizeof (unsigned char),
                         length,
                         stream);
    fclose (stream);

    if (writeCount != length)
        {
        remove (file);
        return 0;
        }

    return 1;
}
