/* -----------------------------------------------------------------------------
 * spnego.h declares RFC 2478 SPNEGO GSS-API mechanism APIs.
 *
 * Author: Frank Balluffi
 *
 * Copyright (C) 2002-2005 Frank Balluffi. All rights reserved.
 * -----------------------------------------------------------------------------
 */

#ifndef SPNEGO_H
#define SPNEGO_H

#ifdef __cplusplus
extern "C" {
#endif

#include <openssl/asn1.h>

/* Structure declarations and constant definitions. */

typedef struct SPNEGO_NEG_TOKEN_INIT_st {
    STACK_OF (ASN1_OBJECT) * mechTypes;
    ASN1_BIT_STRING *        reqFlags;
    ASN1_OCTET_STRING *      mechToken;
    ASN1_OCTET_STRING *      mechListMIC;
} SPNEGO_NEG_TOKEN_INIT;

#define SPNEGO_NEG_RESULT_ACCEPT_COMPLETED  0
#define SPNEGO_NEG_RESULT_ACCEPT_INCOMPLETE 1
#define SPNEGO_NEG_RESULT_ACCEPT_REJECT     2

typedef struct SPNEGO_NEG_TOKEN_TARG_st {
    ASN1_ENUMERATED *   negResult;
    ASN1_OBJECT *       supportedMech;
    ASN1_OCTET_STRING * responseToken;
    ASN1_OCTET_STRING * mechListMIC;
} SPNEGO_NEG_TOKEN_TARG;

#define SPNEGO_NEG_TOKEN_INIT_CHOICE 0
#define SPNEGO_NEG_TOKEN_TARG_CHOICE 1

typedef struct SPNEGO_NEGOTIATION_TOKEN_st {
    int type;
    union {
        SPNEGO_NEG_TOKEN_INIT * negTokenInit;
        SPNEGO_NEG_TOKEN_TARG * negTokenTarg;
    } value;
} SPNEGO_NEGOTIATION_TOKEN;

/* _new, _free, d2i_ and _i2d function declarations. */

DECLARE_ASN1_FUNCTIONS (SPNEGO_NEG_TOKEN_INIT)
DECLARE_ASN1_FUNCTIONS (SPNEGO_NEG_TOKEN_TARG)
DECLARE_ASN1_FUNCTIONS (SPNEGO_NEGOTIATION_TOKEN)

#ifdef __cplusplus
}
#endif

#endif /* SPNEGO_H */
