/* -----------------------------------------------------------------------------
 * filehelp.c declares file helper APIs.
 *
 * Author: Frank Balluffi
 *
 * Copyright (C) 2002-2005 Frank Balluffi. All rights reserved.
 * -----------------------------------------------------------------------------
 */

#ifndef FILEHELP_H
#define FILEHELP_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stddef.h>

/* -----------------------------------------------------------------------------
 * fileToMemory reads the contents of a file into memory, allocating the
 * necessary memory.
 *
 * If fileToMemory is successful, call free to free the memory allocated by
 * fileToMemory.
 *
 * Returns a pointer to the contents of the file if successful, NULL otherwise.
 * -----------------------------------------------------------------------------
 */

void * fileToMemory (const char * file,
                     size_t *     length);

/* -----------------------------------------------------------------------------
 * memoryToFile writes memory to a file.
 *
 * Returns 1 if successful, 0 otherwise.
 * -----------------------------------------------------------------------------
 */

int memoryToFile (const char * file,
                  const void * memory,
                  size_t       length);

#ifdef __cplusplus
}
#endif

#endif /* FILEHELP_H */
