//-----------------------------------------------------
// author: "Grame"
// copyright: "(c)GRAME 2006"
// license: "BSD"
// name: "tapiir"
// version: "1.0"
//
// Code generated with Faust 2.0.a30 (http://faust.grame.fr)
//-----------------------------------------------------

#ifndef  __mydsp_H__
#define  __mydsp_H__
/************************************************************************
 ************************************************************************
    FAUST Architecture File
	Copyright (C) 2006-2011 Albert Graef <Dr.Graef@t-online.de>
    ---------------------------------------------------------------------
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as 
	published by the Free Software Foundation; either version 2.1 of the 
	License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
 	License along with the GNU C Library; if not, write to the Free
  	Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  	02111-1307 USA. 
 ************************************************************************
 ************************************************************************/

/* Pd architecture file, written by Albert Graef <Dr.Graef@t-online.de>.
   This was derived from minimal.cpp included in the Faust distribution.
   Please note that this is to be compiled as a shared library, which is
   then loaded dynamically by Pd as an external. */

#include <stdlib.h>
#include <math.h>
#include <string>

#include "faust/misc.h"
#include "faust/gui/UI.h"
#include "faust/gui/meta.h"
#include "faust/audio/dsp.h"

//using namespace std;

/******************************************************************************
*******************************************************************************

							       VECTOR INTRINSICS

*******************************************************************************
*******************************************************************************/


/***************************************************************************
   Pd UI interface
 ***************************************************************************/

enum ui_elem_type_t {
  UI_BUTTON, UI_CHECK_BUTTON,
  UI_V_SLIDER, UI_H_SLIDER, UI_NUM_ENTRY,
  UI_V_BARGRAPH, UI_H_BARGRAPH,
  UI_END_GROUP, UI_V_GROUP, UI_H_GROUP, UI_T_GROUP
};

struct ui_elem_t {
  ui_elem_type_t type;
  char *label;
  float *zone;
  float init, min, max, step;
};

class PdUI : public UI
{
public:
  const char *name;
  int nelems, level;
  ui_elem_t *elems;
		
  PdUI();
  PdUI(const char *nm, const char *s);
  virtual ~PdUI();

protected:
  std::string path;
  void add_elem(ui_elem_type_t type, const char *label = NULL);
  void add_elem(ui_elem_type_t type, const char *label, float *zone);
  void add_elem(ui_elem_type_t type, const char *label, float *zone,
		float init, float min, float max, float step);
  void add_elem(ui_elem_type_t type, const char *label, float *zone,
		float min, float max);

public:
  virtual void addButton(const char* label, float* zone);
  virtual void addCheckButton(const char* label, float* zone);
  virtual void addVerticalSlider(const char* label, float* zone, float init, float min, float max, float step);
  virtual void addHorizontalSlider(const char* label, float* zone, float init, float min, float max, float step);
  virtual void addNumEntry(const char* label, float* zone, float init, float min, float max, float step);

  virtual void addHorizontalBargraph(const char* label, float* zone, float min, float max);
  virtual void addVerticalBargraph(const char* label, float* zone, float min, float max);
  
  virtual void openTabBox(const char* label);
  virtual void openHorizontalBox(const char* label);
  virtual void openVerticalBox(const char* label);
  virtual void closeBox();
	
  virtual void run();
};

static std::string mangle(const char *name, int level, const char *s)
{
  const char *s0 = s;
  std::string t = "";
  if (!s) return t;
  // Get rid of bogus "0x00" labels in recent Faust revisions. Also, for
  // backward compatibility with old Faust versions, make sure that default
  // toplevel groups and explicit toplevel groups with an empty label are
  // treated alike (these both return "0x00" labels in the latest Faust, but
  // would be treated inconsistently in earlier versions).
  if (!*s || strcmp(s, "0x00") == 0) {
    if (level == 0)
      // toplevel group with empty label, map to dsp name
      s = name;
    else
      // empty label
      s = "";
  }
  while (*s)
    if (isalnum(*s))
      t += *(s++);
    else {
      const char *s1 = s;
      while (*s && !isalnum(*s)) ++s;
      if (s1 != s0 && *s) t += "-";
    }
  return t;
}

static std::string normpath(std::string path)
{
  path = std::string("/")+path;
  int pos = path.find("//");
  while (pos >= 0) {
    path.erase(pos, 1);
    pos = path.find("//");
  }
  size_t len = path.length();
  if (len > 1 && path[len-1] == '/')
    path.erase(len-1, 1);
  return path;
}

static std::string pathcat(std::string path, std::string label)
{
  if (path.empty())
    return normpath(label);
  else if (label.empty())
    return normpath(path);
  else
    return normpath(path+"/"+label);
}

PdUI::PdUI()
{
  nelems = level = 0;
  elems = NULL;
  name = "";
  path = "";
}

PdUI::PdUI(const char *nm, const char *s)
{
  nelems = level = 0;
  elems = NULL;
  name = nm?nm:"";
  path = s?s:"";
}

PdUI::~PdUI()
{
  if (elems) {
    for (int i = 0; i < nelems; i++)
      if (elems[i].label)
	free(elems[i].label);
    free(elems);
  }
}

inline void PdUI::add_elem(ui_elem_type_t type, const char *label)
{
  ui_elem_t *elems1 = (ui_elem_t*)realloc(elems, (nelems+1)*sizeof(ui_elem_t));
  if (elems1)
    elems = elems1;
  else
    return;
  std::string s = pathcat(path, mangle(name, level, label));
  elems[nelems].type = type;
  elems[nelems].label = strdup(s.c_str());
  elems[nelems].zone = NULL;
  elems[nelems].init = 0.0;
  elems[nelems].min = 0.0;
  elems[nelems].max = 0.0;
  elems[nelems].step = 0.0;
  nelems++;
}

inline void PdUI::add_elem(ui_elem_type_t type, const char *label, float *zone)
{
  ui_elem_t *elems1 = (ui_elem_t*)realloc(elems, (nelems+1)*sizeof(ui_elem_t));
  if (elems1)
    elems = elems1;
  else
    return;
  std::string s = pathcat(path, mangle(name, level, label));
  elems[nelems].type = type;
  elems[nelems].label = strdup(s.c_str());
  elems[nelems].zone = zone;
  elems[nelems].init = 0.0;
  elems[nelems].min = 0.0;
  elems[nelems].max = 1.0;
  elems[nelems].step = 1.0;
  nelems++;
}

inline void PdUI::add_elem(ui_elem_type_t type, const char *label, float *zone,
			  float init, float min, float max, float step)
{
  ui_elem_t *elems1 = (ui_elem_t*)realloc(elems, (nelems+1)*sizeof(ui_elem_t));
  if (elems1)
    elems = elems1;
  else
    return;
  std::string s = pathcat(path, mangle(name, level, label));
  elems[nelems].type = type;
  elems[nelems].label = strdup(s.c_str());
  elems[nelems].zone = zone;
  elems[nelems].init = init;
  elems[nelems].min = min;
  elems[nelems].max = max;
  elems[nelems].step = step;
  nelems++;
}

inline void PdUI::add_elem(ui_elem_type_t type, const char *label, float *zone,
			  float min, float max)
{
  ui_elem_t *elems1 = (ui_elem_t*)realloc(elems, (nelems+1)*sizeof(ui_elem_t));
  if (elems1)
    elems = elems1;
  else
    return;
  std::string s = pathcat(path, mangle(name, level, label));
  elems[nelems].type = type;
  elems[nelems].label = strdup(s.c_str());
  elems[nelems].zone = zone;
  elems[nelems].init = 0.0;
  elems[nelems].min = min;
  elems[nelems].max = max;
  elems[nelems].step = 0.0;
  nelems++;
}

void PdUI::addButton(const char* label, float* zone)
{ add_elem(UI_BUTTON, label, zone); }
void PdUI::addCheckButton(const char* label, float* zone)
{ add_elem(UI_CHECK_BUTTON, label, zone); }
void PdUI::addVerticalSlider(const char* label, float* zone, float init, float min, float max, float step)
{ add_elem(UI_V_SLIDER, label, zone, init, min, max, step); }
void PdUI::addHorizontalSlider(const char* label, float* zone, float init, float min, float max, float step)
{ add_elem(UI_H_SLIDER, label, zone, init, min, max, step); }
void PdUI::addNumEntry(const char* label, float* zone, float init, float min, float max, float step)
{ add_elem(UI_NUM_ENTRY, label, zone, init, min, max, step); }

void PdUI::addHorizontalBargraph(const char* label, float* zone, float min, float max)
{ add_elem(UI_H_BARGRAPH, label, zone, min, max); }
void PdUI::addVerticalBargraph(const char* label, float* zone, float min, float max)
{ add_elem(UI_V_BARGRAPH, label, zone, min, max); }

void PdUI::openTabBox(const char* label)
{
  if (!path.empty()) path += "/";
  path += mangle(name, level, label);
  level++;
}
void PdUI::openHorizontalBox(const char* label)
{
  if (!path.empty()) path += "/";
  path += mangle(name, level, label);
  level++;
}
void PdUI::openVerticalBox(const char* label)
{
  if (!path.empty()) path += "/";
  path += mangle(name, level, label);
  level++;
}
void PdUI::closeBox()
{
  int pos = path.rfind("/");
  if (pos < 0) pos = 0;
  path.erase(pos);
  level--;
}

void PdUI::run() {}

/******************************************************************************
*******************************************************************************

			    FAUST DSP

*******************************************************************************
*******************************************************************************/

//----------------------------------------------------------------------------
//  FAUST generated signal processor
//----------------------------------------------------------------------------
		
#ifndef FAUSTFLOAT
#define FAUSTFLOAT float
#endif  

#include <math.h>


#ifndef FAUSTCLASS 
#define FAUSTCLASS mydsp
#endif

class mydsp : public dsp {
	
  private:
	
	float fVec0[524288];
	float fVec1[524288];
	float fVec2[524288];
	float fVec3[524288];
	float fVec4[524288];
	float fVec5[524288];
	float fRec0[2];
	float fRec1[2];
	float fRec2[2];
	float fRec3[2];
	float fRec4[2];
	float fRec5[2];
	FAUSTFLOAT fVslider0;
	FAUSTFLOAT fVslider1;
	FAUSTFLOAT fVslider2;
	FAUSTFLOAT fVslider3;
	FAUSTFLOAT fVslider4;
	FAUSTFLOAT fVslider5;
	FAUSTFLOAT fVslider6;
	FAUSTFLOAT fVslider7;
	FAUSTFLOAT fVslider8;
	FAUSTFLOAT fVslider9;
	FAUSTFLOAT fVslider10;
	int IOTA;
	int fSamplingFreq;
	int iConst0;
	FAUSTFLOAT fVslider11;
	FAUSTFLOAT fVslider12;
	FAUSTFLOAT fVslider13;
	FAUSTFLOAT fVslider14;
	FAUSTFLOAT fVslider15;
	FAUSTFLOAT fVslider16;
	FAUSTFLOAT fVslider17;
	FAUSTFLOAT fVslider18;
	FAUSTFLOAT fVslider19;
	FAUSTFLOAT fVslider20;
	FAUSTFLOAT fVslider21;
	FAUSTFLOAT fVslider22;
	FAUSTFLOAT fVslider23;
	FAUSTFLOAT fVslider24;
	FAUSTFLOAT fVslider25;
	FAUSTFLOAT fVslider26;
	FAUSTFLOAT fVslider27;
	FAUSTFLOAT fVslider28;
	FAUSTFLOAT fVslider29;
	FAUSTFLOAT fVslider30;
	FAUSTFLOAT fVslider31;
	FAUSTFLOAT fVslider32;
	FAUSTFLOAT fVslider33;
	FAUSTFLOAT fVslider34;
	FAUSTFLOAT fVslider35;
	FAUSTFLOAT fVslider36;
	FAUSTFLOAT fVslider37;
	FAUSTFLOAT fVslider38;
	FAUSTFLOAT fVslider39;
	FAUSTFLOAT fVslider40;
	FAUSTFLOAT fVslider41;
	FAUSTFLOAT fVslider42;
	FAUSTFLOAT fVslider43;
	FAUSTFLOAT fVslider44;
	FAUSTFLOAT fVslider45;
	FAUSTFLOAT fVslider46;
	FAUSTFLOAT fVslider47;
	FAUSTFLOAT fVslider48;
	FAUSTFLOAT fVslider49;
	FAUSTFLOAT fVslider50;
	FAUSTFLOAT fVslider51;
	FAUSTFLOAT fVslider52;
	FAUSTFLOAT fVslider53;
	FAUSTFLOAT fVslider54;
	FAUSTFLOAT fVslider55;
	FAUSTFLOAT fVslider56;
	FAUSTFLOAT fVslider57;
	FAUSTFLOAT fVslider58;
	FAUSTFLOAT fVslider59;
	FAUSTFLOAT fVslider60;
	FAUSTFLOAT fVslider61;
	FAUSTFLOAT fVslider62;
	FAUSTFLOAT fVslider63;
	FAUSTFLOAT fVslider64;
	FAUSTFLOAT fVslider65;
	FAUSTFLOAT fVslider66;
	FAUSTFLOAT fVslider67;
	FAUSTFLOAT fVslider68;
	FAUSTFLOAT fVslider69;
	FAUSTFLOAT fVslider70;
	FAUSTFLOAT fVslider71;
	FAUSTFLOAT fVslider72;
	FAUSTFLOAT fVslider73;
	FAUSTFLOAT fVslider74;
	FAUSTFLOAT fVslider75;
	FAUSTFLOAT fVslider76;
	FAUSTFLOAT fVslider77;
	
  public:
	
	void static metadata(Meta* m) { 
		m->declare("author", "Grame");
		m->declare("copyright", "(c)GRAME 2006");
		m->declare("license", "BSD");
		m->declare("math.lib/author", "GRAME");
		m->declare("math.lib/copyright", "GRAME");
		m->declare("math.lib/license", "LGPL with exception");
		m->declare("math.lib/name", "Math Library");
		m->declare("math.lib/version", "1.0");
		m->declare("music.lib/author", "GRAME");
		m->declare("music.lib/copyright", "GRAME");
		m->declare("music.lib/license", "LGPL with exception");
		m->declare("music.lib/name", "Music Library");
		m->declare("music.lib/version", "1.0");
		m->declare("name", "tapiir");
		m->declare("version", "1.0");
	}

	virtual int getNumInputs() {
		return 2;
		
	}
	virtual int getNumOutputs() {
		return 2;
		
	}
	virtual int getInputRate(int channel) {
		int rate;
		switch (channel) {
			case 0: {
				rate = 1;
				break;
			}
			case 1: {
				rate = 1;
				break;
			}
			default: {
				rate = -1;
				break;
			}
			
		}
		return rate;
		
	}
	virtual int getOutputRate(int channel) {
		int rate;
		switch (channel) {
			case 0: {
				rate = 1;
				break;
			}
			case 1: {
				rate = 1;
				break;
			}
			default: {
				rate = -1;
				break;
			}
			
		}
		return rate;
		
	}
	
	static void classInit(int samplingFreq) {
		
	}
	
	virtual void instanceInit(int samplingFreq) {
		fSamplingFreq = samplingFreq;
		fVslider0 = FAUSTFLOAT(1.);
		fVslider1 = FAUSTFLOAT(0.);
		fVslider2 = FAUSTFLOAT(1.);
		fVslider3 = FAUSTFLOAT(0.);
		fVslider4 = FAUSTFLOAT(0.);
		fVslider5 = FAUSTFLOAT(0.);
		fVslider6 = FAUSTFLOAT(0.);
		fVslider7 = FAUSTFLOAT(0.);
		fVslider8 = FAUSTFLOAT(0.);
		fVslider9 = FAUSTFLOAT(1.);
		fVslider10 = FAUSTFLOAT(1.);
		IOTA = 0;
		for (int i0 = 0; (i0 < 524288); i0 = (i0 + 1)) {
			fVec0[i0] = 0.f;
			
		}
		iConst0 = min(192000, max(1, fSamplingFreq));
		fVslider11 = FAUSTFLOAT(0.);
		for (int i1 = 0; (i1 < 2); i1 = (i1 + 1)) {
			fRec0[i1] = 0.f;
			
		}
		fVslider12 = FAUSTFLOAT(1.);
		fVslider13 = FAUSTFLOAT(0.);
		fVslider14 = FAUSTFLOAT(0.);
		fVslider15 = FAUSTFLOAT(0.);
		fVslider16 = FAUSTFLOAT(0.);
		fVslider17 = FAUSTFLOAT(0.);
		fVslider18 = FAUSTFLOAT(0.);
		fVslider19 = FAUSTFLOAT(1.);
		fVslider20 = FAUSTFLOAT(1.);
		for (int i2 = 0; (i2 < 524288); i2 = (i2 + 1)) {
			fVec1[i2] = 0.f;
			
		}
		fVslider21 = FAUSTFLOAT(0.);
		for (int i3 = 0; (i3 < 2); i3 = (i3 + 1)) {
			fRec1[i3] = 0.f;
			
		}
		fVslider22 = FAUSTFLOAT(1.);
		fVslider23 = FAUSTFLOAT(0.);
		fVslider24 = FAUSTFLOAT(0.);
		fVslider25 = FAUSTFLOAT(0.);
		fVslider26 = FAUSTFLOAT(0.);
		fVslider27 = FAUSTFLOAT(0.);
		fVslider28 = FAUSTFLOAT(0.);
		fVslider29 = FAUSTFLOAT(1.);
		fVslider30 = FAUSTFLOAT(1.);
		for (int i4 = 0; (i4 < 524288); i4 = (i4 + 1)) {
			fVec2[i4] = 0.f;
			
		}
		fVslider31 = FAUSTFLOAT(0.);
		for (int i5 = 0; (i5 < 2); i5 = (i5 + 1)) {
			fRec2[i5] = 0.f;
			
		}
		fVslider32 = FAUSTFLOAT(1.);
		fVslider33 = FAUSTFLOAT(0.);
		fVslider34 = FAUSTFLOAT(0.);
		fVslider35 = FAUSTFLOAT(0.);
		fVslider36 = FAUSTFLOAT(0.);
		fVslider37 = FAUSTFLOAT(0.);
		fVslider38 = FAUSTFLOAT(0.);
		fVslider39 = FAUSTFLOAT(1.);
		fVslider40 = FAUSTFLOAT(1.);
		for (int i6 = 0; (i6 < 524288); i6 = (i6 + 1)) {
			fVec3[i6] = 0.f;
			
		}
		fVslider41 = FAUSTFLOAT(0.);
		for (int i7 = 0; (i7 < 2); i7 = (i7 + 1)) {
			fRec3[i7] = 0.f;
			
		}
		fVslider42 = FAUSTFLOAT(1.);
		fVslider43 = FAUSTFLOAT(0.);
		fVslider44 = FAUSTFLOAT(0.);
		fVslider45 = FAUSTFLOAT(0.);
		fVslider46 = FAUSTFLOAT(0.);
		fVslider47 = FAUSTFLOAT(0.);
		fVslider48 = FAUSTFLOAT(0.);
		fVslider49 = FAUSTFLOAT(1.);
		fVslider50 = FAUSTFLOAT(1.);
		for (int i8 = 0; (i8 < 524288); i8 = (i8 + 1)) {
			fVec4[i8] = 0.f;
			
		}
		fVslider51 = FAUSTFLOAT(0.);
		for (int i9 = 0; (i9 < 2); i9 = (i9 + 1)) {
			fRec4[i9] = 0.f;
			
		}
		fVslider52 = FAUSTFLOAT(1.);
		fVslider53 = FAUSTFLOAT(0.);
		fVslider54 = FAUSTFLOAT(0.);
		fVslider55 = FAUSTFLOAT(0.);
		fVslider56 = FAUSTFLOAT(0.);
		fVslider57 = FAUSTFLOAT(0.);
		fVslider58 = FAUSTFLOAT(0.);
		fVslider59 = FAUSTFLOAT(1.);
		fVslider60 = FAUSTFLOAT(1.);
		for (int i10 = 0; (i10 < 524288); i10 = (i10 + 1)) {
			fVec5[i10] = 0.f;
			
		}
		fVslider61 = FAUSTFLOAT(0.);
		for (int i11 = 0; (i11 < 2); i11 = (i11 + 1)) {
			fRec5[i11] = 0.f;
			
		}
		fVslider62 = FAUSTFLOAT(0.);
		fVslider63 = FAUSTFLOAT(0.);
		fVslider64 = FAUSTFLOAT(0.);
		fVslider65 = FAUSTFLOAT(0.);
		fVslider66 = FAUSTFLOAT(0.);
		fVslider67 = FAUSTFLOAT(1.);
		fVslider68 = FAUSTFLOAT(1.);
		fVslider69 = FAUSTFLOAT(1.);
		fVslider70 = FAUSTFLOAT(0.);
		fVslider71 = FAUSTFLOAT(0.);
		fVslider72 = FAUSTFLOAT(0.);
		fVslider73 = FAUSTFLOAT(0.);
		fVslider74 = FAUSTFLOAT(0.);
		fVslider75 = FAUSTFLOAT(0.);
		fVslider76 = FAUSTFLOAT(1.);
		fVslider77 = FAUSTFLOAT(1.);
		
	}
	
	virtual void init(int samplingFreq) {
		classInit(samplingFreq);
		instanceInit(samplingFreq);
	}
	
	virtual void buildUserInterface(UI* interface) {
		interface->openVerticalBox("Tapiir");
		interface->openTabBox("0x00");
		interface->openHorizontalBox("Tap 0");
		interface->addVerticalSlider("delay (sec)", &fVslider11, 0.f, 0.f, 5.f, 0.01f);
		interface->addVerticalSlider("gain", &fVslider2, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("input 0", &fVslider9, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("input 1", &fVslider10, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 0", &fVslider3, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 1", &fVslider4, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 2", &fVslider5, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 3", &fVslider6, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 4", &fVslider7, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 5", &fVslider8, 0.f, 0.f, 1.f, 0.1f);
		interface->closeBox();
		interface->openHorizontalBox("Tap 1");
		interface->addVerticalSlider("delay (sec)", &fVslider21, 0.f, 0.f, 5.f, 0.01f);
		interface->addVerticalSlider("gain", &fVslider12, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("input 0", &fVslider19, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("input 1", &fVslider20, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 0", &fVslider13, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 1", &fVslider14, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 2", &fVslider15, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 3", &fVslider16, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 4", &fVslider17, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 5", &fVslider18, 0.f, 0.f, 1.f, 0.1f);
		interface->closeBox();
		interface->openHorizontalBox("Tap 2");
		interface->addVerticalSlider("delay (sec)", &fVslider31, 0.f, 0.f, 5.f, 0.01f);
		interface->addVerticalSlider("gain", &fVslider22, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("input 0", &fVslider29, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("input 1", &fVslider30, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 0", &fVslider23, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 1", &fVslider24, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 2", &fVslider25, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 3", &fVslider26, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 4", &fVslider27, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 5", &fVslider28, 0.f, 0.f, 1.f, 0.1f);
		interface->closeBox();
		interface->openHorizontalBox("Tap 3");
		interface->addVerticalSlider("delay (sec)", &fVslider41, 0.f, 0.f, 5.f, 0.01f);
		interface->addVerticalSlider("gain", &fVslider32, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("input 0", &fVslider39, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("input 1", &fVslider40, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 0", &fVslider33, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 1", &fVslider34, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 2", &fVslider35, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 3", &fVslider36, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 4", &fVslider37, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 5", &fVslider38, 0.f, 0.f, 1.f, 0.1f);
		interface->closeBox();
		interface->openHorizontalBox("Tap 4");
		interface->addVerticalSlider("delay (sec)", &fVslider51, 0.f, 0.f, 5.f, 0.01f);
		interface->addVerticalSlider("gain", &fVslider42, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("input 0", &fVslider49, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("input 1", &fVslider50, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 0", &fVslider43, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 1", &fVslider44, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 2", &fVslider45, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 3", &fVslider46, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 4", &fVslider47, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 5", &fVslider48, 0.f, 0.f, 1.f, 0.1f);
		interface->closeBox();
		interface->openHorizontalBox("Tap 5");
		interface->addVerticalSlider("delay (sec)", &fVslider61, 0.f, 0.f, 5.f, 0.01f);
		interface->addVerticalSlider("gain", &fVslider52, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("input 0", &fVslider59, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("input 1", &fVslider60, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 0", &fVslider53, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 1", &fVslider54, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 2", &fVslider55, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 3", &fVslider56, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 4", &fVslider57, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 5", &fVslider58, 0.f, 0.f, 1.f, 0.1f);
		interface->closeBox();
		interface->closeBox();
		interface->openVerticalBox("outputs");
		interface->openHorizontalBox("output 0");
		interface->addVerticalSlider("gain", &fVslider0, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("input 0", &fVslider67, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("input 1", &fVslider68, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 0", &fVslider1, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 1", &fVslider62, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 2", &fVslider63, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 3", &fVslider64, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 4", &fVslider65, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 5", &fVslider66, 0.f, 0.f, 1.f, 0.1f);
		interface->closeBox();
		interface->openHorizontalBox("output 1");
		interface->addVerticalSlider("gain", &fVslider69, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("input 0", &fVslider76, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("input 1", &fVslider77, 1.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 0", &fVslider70, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 1", &fVslider71, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 2", &fVslider72, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 3", &fVslider73, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 4", &fVslider74, 0.f, 0.f, 1.f, 0.1f);
		interface->addVerticalSlider("tap 5", &fVslider75, 0.f, 0.f, 1.f, 0.1f);
		interface->closeBox();
		interface->closeBox();
		interface->closeBox();
		
	}
	
	virtual void compute(int count, FAUSTFLOAT** inputs, FAUSTFLOAT** outputs) {
		FAUSTFLOAT* input0 = inputs[0];
		FAUSTFLOAT* input1 = inputs[1];
		FAUSTFLOAT* output0 = outputs[0];
		FAUSTFLOAT* output1 = outputs[1];
		float fSlow0 = float(fVslider0);
		float fSlow1 = float(fVslider1);
		float fSlow2 = float(fVslider2);
		float fSlow3 = float(fVslider3);
		float fSlow4 = float(fVslider4);
		float fSlow5 = float(fVslider5);
		float fSlow6 = float(fVslider6);
		float fSlow7 = float(fVslider7);
		float fSlow8 = float(fVslider8);
		float fSlow9 = float(fVslider9);
		float fSlow10 = float(fVslider10);
		int iSlow11 = int(int((int(float((float(iConst0) * float(fVslider11)))) & 524287)));
		float fSlow12 = float(fVslider12);
		float fSlow13 = float(fVslider13);
		float fSlow14 = float(fVslider14);
		float fSlow15 = float(fVslider15);
		float fSlow16 = float(fVslider16);
		float fSlow17 = float(fVslider17);
		float fSlow18 = float(fVslider18);
		float fSlow19 = float(fVslider19);
		float fSlow20 = float(fVslider20);
		int iSlow21 = int(int((int(float((float(iConst0) * float(fVslider21)))) & 524287)));
		float fSlow22 = float(fVslider22);
		float fSlow23 = float(fVslider23);
		float fSlow24 = float(fVslider24);
		float fSlow25 = float(fVslider25);
		float fSlow26 = float(fVslider26);
		float fSlow27 = float(fVslider27);
		float fSlow28 = float(fVslider28);
		float fSlow29 = float(fVslider29);
		float fSlow30 = float(fVslider30);
		int iSlow31 = int(int((int(float((float(iConst0) * float(fVslider31)))) & 524287)));
		float fSlow32 = float(fVslider32);
		float fSlow33 = float(fVslider33);
		float fSlow34 = float(fVslider34);
		float fSlow35 = float(fVslider35);
		float fSlow36 = float(fVslider36);
		float fSlow37 = float(fVslider37);
		float fSlow38 = float(fVslider38);
		float fSlow39 = float(fVslider39);
		float fSlow40 = float(fVslider40);
		int iSlow41 = int(int((int(float((float(iConst0) * float(fVslider41)))) & 524287)));
		float fSlow42 = float(fVslider42);
		float fSlow43 = float(fVslider43);
		float fSlow44 = float(fVslider44);
		float fSlow45 = float(fVslider45);
		float fSlow46 = float(fVslider46);
		float fSlow47 = float(fVslider47);
		float fSlow48 = float(fVslider48);
		float fSlow49 = float(fVslider49);
		float fSlow50 = float(fVslider50);
		int iSlow51 = int(int((int(float((float(iConst0) * float(fVslider51)))) & 524287)));
		float fSlow52 = float(fVslider52);
		float fSlow53 = float(fVslider53);
		float fSlow54 = float(fVslider54);
		float fSlow55 = float(fVslider55);
		float fSlow56 = float(fVslider56);
		float fSlow57 = float(fVslider57);
		float fSlow58 = float(fVslider58);
		float fSlow59 = float(fVslider59);
		float fSlow60 = float(fVslider60);
		int iSlow61 = int(int((int(float((float(iConst0) * float(fVslider61)))) & 524287)));
		float fSlow62 = float(fVslider62);
		float fSlow63 = float(fVslider63);
		float fSlow64 = float(fVslider64);
		float fSlow65 = float(fVslider65);
		float fSlow66 = float(fVslider66);
		float fSlow67 = float(fVslider67);
		float fSlow68 = float(fVslider68);
		float fSlow69 = float(fVslider69);
		float fSlow70 = float(fVslider70);
		float fSlow71 = float(fVslider71);
		float fSlow72 = float(fVslider72);
		float fSlow73 = float(fVslider73);
		float fSlow74 = float(fVslider74);
		float fSlow75 = float(fVslider75);
		float fSlow76 = float(fVslider76);
		float fSlow77 = float(fVslider77);
		for (int i = 0; (i < count); i = (i + 1)) {
			float fTemp0 = float(input0[i]);
			float fTemp1 = float(input1[i]);
			fVec0[(IOTA & 524287)] = float((fSlow2 * float((float((float((float((float((float((float((float((fSlow3 * fRec0[1])) + float((fSlow4 * fRec1[1])))) + float((fSlow5 * fRec2[1])))) + float((fSlow6 * fRec3[1])))) + float((fSlow7 * fRec4[1])))) + float((fSlow8 * fRec5[1])))) + float((fSlow9 * fTemp0)))) + float((fSlow10 * fTemp1))))));
			fRec0[0] = fVec0[((IOTA - iSlow11) & 524287)];
			fVec1[(IOTA & 524287)] = float((fSlow12 * float((float((float((float((float((float((float((float((fSlow13 * fRec0[1])) + float((fSlow14 * fRec1[1])))) + float((fSlow15 * fRec2[1])))) + float((fSlow16 * fRec3[1])))) + float((fSlow17 * fRec4[1])))) + float((fSlow18 * fRec5[1])))) + float((fSlow19 * fTemp0)))) + float((fSlow20 * fTemp1))))));
			fRec1[0] = fVec1[((IOTA - iSlow21) & 524287)];
			fVec2[(IOTA & 524287)] = float((fSlow22 * float((float((float((float((float((float((float((float((fSlow23 * fRec0[1])) + float((fSlow24 * fRec1[1])))) + float((fSlow25 * fRec2[1])))) + float((fSlow26 * fRec3[1])))) + float((fSlow27 * fRec4[1])))) + float((fSlow28 * fRec5[1])))) + float((fSlow29 * fTemp0)))) + float((fSlow30 * fTemp1))))));
			fRec2[0] = fVec2[((IOTA - iSlow31) & 524287)];
			fVec3[(IOTA & 524287)] = float((fSlow32 * float((float((float((float((float((float((float((float((fSlow33 * fRec0[1])) + float((fSlow34 * fRec1[1])))) + float((fSlow35 * fRec2[1])))) + float((fSlow36 * fRec3[1])))) + float((fSlow37 * fRec4[1])))) + float((fSlow38 * fRec5[1])))) + float((fSlow39 * fTemp0)))) + float((fSlow40 * fTemp1))))));
			fRec3[0] = fVec3[((IOTA - iSlow41) & 524287)];
			fVec4[(IOTA & 524287)] = float((fSlow42 * float((float((float((float((float((float((float((float((fSlow43 * fRec0[1])) + float((fSlow44 * fRec1[1])))) + float((fSlow45 * fRec2[1])))) + float((fSlow46 * fRec3[1])))) + float((fSlow47 * fRec4[1])))) + float((fSlow48 * fRec5[1])))) + float((fSlow49 * fTemp0)))) + float((fSlow50 * fTemp1))))));
			fRec4[0] = fVec4[((IOTA - iSlow51) & 524287)];
			fVec5[(IOTA & 524287)] = float((fSlow52 * float((float((float((float((float((float((float((float((fSlow53 * fRec0[1])) + float((fSlow54 * fRec1[1])))) + float((fSlow55 * fRec2[1])))) + float((fSlow56 * fRec3[1])))) + float((fSlow57 * fRec4[1])))) + float((fSlow58 * fRec5[1])))) + float((fSlow59 * fTemp0)))) + float((fSlow60 * fTemp1))))));
			fRec5[0] = fVec5[((IOTA - iSlow61) & 524287)];
			output0[i] = FAUSTFLOAT(float((fSlow0 * float((float((float((float((float((float((float((float((fSlow1 * fRec0[0])) + float((fSlow62 * fRec1[0])))) + float((fSlow63 * fRec2[0])))) + float((fSlow64 * fRec3[0])))) + float((fSlow65 * fRec4[0])))) + float((fSlow66 * fRec5[0])))) + float((fSlow67 * fTemp0)))) + float((fSlow68 * fTemp1)))))));
			output1[i] = FAUSTFLOAT(float((fSlow69 * float((float((float((float((float((float((float((float((fSlow70 * fRec0[0])) + float((fSlow71 * fRec1[0])))) + float((fSlow72 * fRec2[0])))) + float((fSlow73 * fRec3[0])))) + float((fSlow74 * fRec4[0])))) + float((fSlow75 * fRec5[0])))) + float((fSlow76 * fTemp0)))) + float((fSlow77 * fTemp1)))))));
			IOTA = (IOTA + 1);
			fRec0[1] = fRec0[0];
			fRec1[1] = fRec1[0];
			fRec2[1] = fRec2[0];
			fRec3[1] = fRec3[0];
			fRec4[1] = fRec4[0];
			fRec5[1] = fRec5[0];
			
		}
		
	}

	
};


#include <stdio.h>
#include <string>
#include "m_pd.h"

#define sym(name) xsym(name)
#define xsym(name) #name
#define faust_setup(name) xfaust_setup(name)
#define xfaust_setup(name) name ## _tilde_setup(void)

// time for "active" toggle xfades in secs
#define XFADE_TIME 0.1f

static t_class *faust_class;

struct t_faust {
  t_object x_obj;
#ifdef __MINGW32__
  /* This seems to be necessary as some as yet undetermined Pd routine seems
     to write past the end of x_obj on Windows. */
  int fence; /* dummy field (not used) */
#endif
  mydsp *dsp;
  PdUI *ui;
  std::string *label;
  int active, xfade, n_xfade, rate, n_in, n_out;
  t_sample **inputs, **outputs, **buf;
  t_outlet *out;
  t_sample f;
};

static t_symbol *s_button, *s_checkbox, *s_vslider, *s_hslider, *s_nentry,
  *s_vbargraph, *s_hbargraph;

static inline void zero_samples(int k, int n, t_sample **out)
{
  for (int i = 0; i < k; i++)
#ifdef __STDC_IEC_559__
    /* IEC 559 a.k.a. IEEE 754 floats can be initialized faster like this */
    memset(out[i], 0, n*sizeof(t_sample));
#else
    for (int j = 0; j < n; j++)
      out[i][j] = 0.0f;
#endif
}

static inline void copy_samples(int k, int n, t_sample **out, t_sample **in)
{
  for (int i = 0; i < k; i++)
    memcpy(out[i], in[i], n*sizeof(t_sample));
}

static t_int *faust_perform(t_int *w)
{
  t_faust *x = (t_faust *)(w[1]);
  int n = (int)(w[2]);
  if (!x->dsp || !x->buf) return (w+3);
  AVOIDDENORMALS;
  if (x->xfade > 0) {
    float d = 1.0f/x->n_xfade, f = (x->xfade--)*d;
    d = d/n;
    x->dsp->compute(n, x->inputs, x->buf);
    if (x->active)
      if (x->n_in == x->n_out)
	/* xfade inputs -> buf */
	for (int j = 0; j < n; j++, f -= d)
	  for (int i = 0; i < x->n_out; i++)
	    x->outputs[i][j] = f*x->inputs[i][j]+(1.0f-f)*x->buf[i][j];
      else
	/* xfade 0 -> buf */
	for (int j = 0; j < n; j++, f -= d)
	  for (int i = 0; i < x->n_out; i++)
	    x->outputs[i][j] = (1.0f-f)*x->buf[i][j];
    else
      if (x->n_in == x->n_out)
	/* xfade buf -> inputs */
	for (int j = 0; j < n; j++, f -= d)
	  for (int i = 0; i < x->n_out; i++)
	    x->outputs[i][j] = f*x->buf[i][j]+(1.0f-f)*x->inputs[i][j];
      else
	/* xfade buf -> 0 */
	for (int j = 0; j < n; j++, f -= d)
	  for (int i = 0; i < x->n_out; i++)
	    x->outputs[i][j] = f*x->buf[i][j];
  } else if (x->active) {
    x->dsp->compute(n, x->inputs, x->buf);
    copy_samples(x->n_out, n, x->outputs, x->buf);
  } else if (x->n_in == x->n_out) {
    copy_samples(x->n_out, n, x->buf, x->inputs);
    copy_samples(x->n_out, n, x->outputs, x->buf);
  } else
    zero_samples(x->n_out, n, x->outputs);
  return (w+3);
}

static void faust_dsp(t_faust *x, t_signal **sp)
{
  int n = sp[0]->s_n, sr = (int)sp[0]->s_sr;
  if (x->rate <= 0) {
    /* default sample rate is whatever Pd tells us */
    PdUI *ui = x->ui;
    float *z = NULL;
    if (ui->nelems > 0 &&
	(z = (float*)malloc(ui->nelems*sizeof(float)))) {
      /* save the current control values */
      for (int i = 0; i < ui->nelems; i++)
	if (ui->elems[i].zone)
	  z[i] = *ui->elems[i].zone;
    }
    /* set the proper sample rate; this requires reinitializing the dsp */
    x->rate = sr;
    x->dsp->init(sr);
    if (z) {
      /* restore previous control values */
      for (int i = 0; i < ui->nelems; i++)
	if (ui->elems[i].zone)
	  *ui->elems[i].zone = z[i];
      free(z);
    }
  }
  if (n > 0)
    x->n_xfade = (int)(x->rate*XFADE_TIME/n);
  dsp_add(faust_perform, 2, x, n);
  for (int i = 0; i < x->n_in; i++)
    x->inputs[i] = sp[i+1]->s_vec;
  for (int i = 0; i < x->n_out; i++)
    x->outputs[i] = sp[x->n_in+i+1]->s_vec;
  if (x->buf != NULL)
    for (int i = 0; i < x->n_out; i++) {
      x->buf[i] = (t_sample*)malloc(n*sizeof(t_sample));
      if (x->buf[i] == NULL) {
	for (int j = 0; j < i; j++)
	  free(x->buf[j]);
	free(x->buf);
	x->buf = NULL;
	break;
      }
    }
}

static int pathcmp(const char *s, const char *t)
{
  int n = strlen(s), m = strlen(t);
  if (n == 0 || m == 0)
    return 0;
  else if (t[0] == '/')
    return strcmp(s, t);
  else if (n <= m || s[n-m-1] != '/')
    return strcmp(s+1, t);
  else
    return strcmp(s+n-m, t);
}

static void faust_any(t_faust *x, t_symbol *s, int argc, t_atom *argv)
{
  if (!x->dsp) return;
  PdUI *ui = x->ui;
  if (s == &s_bang) {
    for (int i = 0; i < ui->nelems; i++)
      if (ui->elems[i].label && ui->elems[i].zone) {
	t_atom args[6];
	t_symbol *_s;
	switch (ui->elems[i].type) {
	case UI_BUTTON:
	  _s = s_button;
	  break;
	case UI_CHECK_BUTTON:
	  _s = s_checkbox;
	  break;
	case UI_V_SLIDER:
	  _s = s_vslider;
	  break;
	case UI_H_SLIDER:
	  _s = s_hslider;
	  break;
	case UI_NUM_ENTRY:
	  _s = s_nentry;
	  break;
	case UI_V_BARGRAPH:
	  _s = s_vbargraph;
	  break;
	case UI_H_BARGRAPH:
	  _s = s_hbargraph;
	  break;
	default:
	  continue;
	}
	SETSYMBOL(&args[0], gensym(ui->elems[i].label));
	SETFLOAT(&args[1], *ui->elems[i].zone);
	SETFLOAT(&args[2], ui->elems[i].init);
	SETFLOAT(&args[3], ui->elems[i].min);
	SETFLOAT(&args[4], ui->elems[i].max);
	SETFLOAT(&args[5], ui->elems[i].step);
	outlet_anything(x->out, _s, 6, args);
      }
  } else {
    const char *label = s->s_name;
    int count = 0;
    for (int i = 0; i < ui->nelems; i++)
      if (ui->elems[i].label &&
	  pathcmp(ui->elems[i].label, label) == 0) {
	if (argc == 0) {
	  if (ui->elems[i].zone) {
	    t_atom arg;
	    SETFLOAT(&arg, *ui->elems[i].zone);
	    outlet_anything(x->out, gensym(ui->elems[i].label), 1, &arg);
	  }
	  ++count;
	} else if (argc == 1 &&
		   (argv[0].a_type == A_FLOAT ||
		    argv[0].a_type == A_DEFFLOAT) &&
		   ui->elems[i].zone) {
	  float f = atom_getfloat(argv);
	  *ui->elems[i].zone = f;
	  ++count;
	} else
	  pd_error(x, "[faust] %s: bad control argument: %s",
		   x->label->c_str(), label);
      }
    if (count == 0 && strcmp(label, "active") == 0) {
      if (argc == 0) {
	t_atom arg;
	SETFLOAT(&arg, (float)x->active);
	outlet_anything(x->out, gensym((char*)"active"), 1, &arg);
      } else if (argc == 1 &&
		 (argv[0].a_type == A_FLOAT ||
		  argv[0].a_type == A_DEFFLOAT)) {
	float f = atom_getfloat(argv);
	x->active = (int)f;
	x->xfade = x->n_xfade;
      }
    }
  }
}

static void faust_free(t_faust *x)
{
  if (x->label) delete x->label;
  if (x->dsp) delete x->dsp;
  if (x->ui) delete x->ui;
  if (x->inputs) free(x->inputs);
  if (x->outputs) free(x->outputs);
  if (x->buf) {
    for (int i = 0; i < x->n_out; i++)
      if (x->buf[i]) free(x->buf[i]);
    free(x->buf);
  }
}

static void *faust_new(t_symbol *s, int argc, t_atom *argv)
{
  t_faust *x = (t_faust*)pd_new(faust_class);
  int sr = -1;
  t_symbol *id = NULL;
  x->active = 1;
  for (int i = 0; i < argc; i++)
    if (argv[i].a_type == A_FLOAT || argv[i].a_type == A_DEFFLOAT)
      sr = (int)argv[i].a_w.w_float;
    else if (argv[i].a_type == A_SYMBOL || argv[i].a_type == A_DEFSYMBOL)
      id = argv[i].a_w.w_symbol;
  x->rate = sr;
  if (sr <= 0) sr = 44100;
  x->xfade = 0; x->n_xfade = (int)(sr*XFADE_TIME/64);
  x->inputs = x->outputs = x->buf = NULL;
    x->label = new std::string(sym(mydsp) "~");
  x->dsp = new mydsp();
  x->ui = new PdUI(sym(mydsp), id?id->s_name:NULL);
  if (!x->dsp || !x->ui || !x->label) goto error;
  if (id) {
    *x->label += " ";
    *x->label += id->s_name;
  }
  x->n_in = x->dsp->getNumInputs();
  x->n_out = x->dsp->getNumOutputs();
  if (x->n_in > 0)
    x->inputs = (t_sample**)malloc(x->n_in*sizeof(t_sample*));
  if (x->n_out > 0) {
    x->outputs = (t_sample**)malloc(x->n_out*sizeof(t_sample*));
    x->buf = (t_sample**)malloc(x->n_out*sizeof(t_sample*));
  }
  if ((x->n_in > 0 && x->inputs == NULL) ||
      (x->n_out > 0 && (x->outputs == NULL || x->buf == NULL)))
    goto error;
  for (int i = 0; i < x->n_out; i++)
    x->buf[i] = NULL;
  x->dsp->init(sr);
  x->dsp->buildUserInterface(x->ui);
  for (int i = 0; i < x->n_in; i++)
    inlet_new(&x->x_obj, &x->x_obj.ob_pd, &s_signal, &s_signal);
  x->out = outlet_new(&x->x_obj, 0);
  for (int i = 0; i < x->n_out; i++)
    outlet_new(&x->x_obj, &s_signal);
  return (void *)x;
 error:
  faust_free(x);
  x->dsp = NULL; x->ui = NULL;
  x->inputs = x->outputs = x->buf = NULL;
  return (void *)x;
}

extern "C" void faust_setup(mydsp)
{
  t_symbol *s = gensym(sym(mydsp) "~");
  faust_class =
    class_new(s, (t_newmethod)faust_new, (t_method)faust_free,
	      sizeof(t_faust), CLASS_DEFAULT,
	      A_GIMME, A_NULL);
  class_addmethod(faust_class, (t_method)faust_dsp, gensym((char*)"dsp"), A_NULL);
  class_addanything(faust_class, faust_any);
  class_addmethod(faust_class, nullfn, &s_signal, A_NULL);
  s_button = gensym((char*)"button");
  s_checkbox = gensym((char*)"checkbox");
  s_vslider = gensym((char*)"vslider");
  s_hslider = gensym((char*)"hslider");
  s_nentry = gensym((char*)"nentry");
  s_vbargraph = gensym((char*)"vbargraph");
  s_hbargraph = gensym((char*)"hbargraph");
  /* give some indication that we're loaded and ready to go */
  mydsp dsp = mydsp();
  post("[faust] %s: %d inputs, %d outputs", sym(mydsp) "~",
       dsp.getNumInputs(), dsp.getNumOutputs());
}

#endif
