//-----------------------------------------------------
// author: "Grame"
// copyright: "(c)GRAME 2006"
// license: "BSD"
// name: "multibandfilter"
// version: "1.0"
//
// Code generated with Faust 2.0.a30 (http://faust.grame.fr)
//-----------------------------------------------------

#ifndef  __mydsp_H__
#define  __mydsp_H__
/************************************************************************
 ************************************************************************
    FAUST Architecture File
	Copyright (C) 2006-2011 Albert Graef <Dr.Graef@t-online.de>
    ---------------------------------------------------------------------
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as 
	published by the Free Software Foundation; either version 2.1 of the 
	License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
 	License along with the GNU C Library; if not, write to the Free
  	Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  	02111-1307 USA. 
 ************************************************************************
 ************************************************************************/

/* Pd architecture file, written by Albert Graef <Dr.Graef@t-online.de>.
   This was derived from minimal.cpp included in the Faust distribution.
   Please note that this is to be compiled as a shared library, which is
   then loaded dynamically by Pd as an external. */

#include <stdlib.h>
#include <math.h>
#include <string>

#include "faust/misc.h"
#include "faust/gui/UI.h"
#include "faust/gui/meta.h"
#include "faust/audio/dsp.h"

//using namespace std;

/******************************************************************************
*******************************************************************************

							       VECTOR INTRINSICS

*******************************************************************************
*******************************************************************************/


/***************************************************************************
   Pd UI interface
 ***************************************************************************/

enum ui_elem_type_t {
  UI_BUTTON, UI_CHECK_BUTTON,
  UI_V_SLIDER, UI_H_SLIDER, UI_NUM_ENTRY,
  UI_V_BARGRAPH, UI_H_BARGRAPH,
  UI_END_GROUP, UI_V_GROUP, UI_H_GROUP, UI_T_GROUP
};

struct ui_elem_t {
  ui_elem_type_t type;
  char *label;
  float *zone;
  float init, min, max, step;
};

class PdUI : public UI
{
public:
  const char *name;
  int nelems, level;
  ui_elem_t *elems;
		
  PdUI();
  PdUI(const char *nm, const char *s);
  virtual ~PdUI();

protected:
  std::string path;
  void add_elem(ui_elem_type_t type, const char *label = NULL);
  void add_elem(ui_elem_type_t type, const char *label, float *zone);
  void add_elem(ui_elem_type_t type, const char *label, float *zone,
		float init, float min, float max, float step);
  void add_elem(ui_elem_type_t type, const char *label, float *zone,
		float min, float max);

public:
  virtual void addButton(const char* label, float* zone);
  virtual void addCheckButton(const char* label, float* zone);
  virtual void addVerticalSlider(const char* label, float* zone, float init, float min, float max, float step);
  virtual void addHorizontalSlider(const char* label, float* zone, float init, float min, float max, float step);
  virtual void addNumEntry(const char* label, float* zone, float init, float min, float max, float step);

  virtual void addHorizontalBargraph(const char* label, float* zone, float min, float max);
  virtual void addVerticalBargraph(const char* label, float* zone, float min, float max);
  
  virtual void openTabBox(const char* label);
  virtual void openHorizontalBox(const char* label);
  virtual void openVerticalBox(const char* label);
  virtual void closeBox();
	
  virtual void run();
};

static std::string mangle(const char *name, int level, const char *s)
{
  const char *s0 = s;
  std::string t = "";
  if (!s) return t;
  // Get rid of bogus "0x00" labels in recent Faust revisions. Also, for
  // backward compatibility with old Faust versions, make sure that default
  // toplevel groups and explicit toplevel groups with an empty label are
  // treated alike (these both return "0x00" labels in the latest Faust, but
  // would be treated inconsistently in earlier versions).
  if (!*s || strcmp(s, "0x00") == 0) {
    if (level == 0)
      // toplevel group with empty label, map to dsp name
      s = name;
    else
      // empty label
      s = "";
  }
  while (*s)
    if (isalnum(*s))
      t += *(s++);
    else {
      const char *s1 = s;
      while (*s && !isalnum(*s)) ++s;
      if (s1 != s0 && *s) t += "-";
    }
  return t;
}

static std::string normpath(std::string path)
{
  path = std::string("/")+path;
  int pos = path.find("//");
  while (pos >= 0) {
    path.erase(pos, 1);
    pos = path.find("//");
  }
  size_t len = path.length();
  if (len > 1 && path[len-1] == '/')
    path.erase(len-1, 1);
  return path;
}

static std::string pathcat(std::string path, std::string label)
{
  if (path.empty())
    return normpath(label);
  else if (label.empty())
    return normpath(path);
  else
    return normpath(path+"/"+label);
}

PdUI::PdUI()
{
  nelems = level = 0;
  elems = NULL;
  name = "";
  path = "";
}

PdUI::PdUI(const char *nm, const char *s)
{
  nelems = level = 0;
  elems = NULL;
  name = nm?nm:"";
  path = s?s:"";
}

PdUI::~PdUI()
{
  if (elems) {
    for (int i = 0; i < nelems; i++)
      if (elems[i].label)
	free(elems[i].label);
    free(elems);
  }
}

inline void PdUI::add_elem(ui_elem_type_t type, const char *label)
{
  ui_elem_t *elems1 = (ui_elem_t*)realloc(elems, (nelems+1)*sizeof(ui_elem_t));
  if (elems1)
    elems = elems1;
  else
    return;
  std::string s = pathcat(path, mangle(name, level, label));
  elems[nelems].type = type;
  elems[nelems].label = strdup(s.c_str());
  elems[nelems].zone = NULL;
  elems[nelems].init = 0.0;
  elems[nelems].min = 0.0;
  elems[nelems].max = 0.0;
  elems[nelems].step = 0.0;
  nelems++;
}

inline void PdUI::add_elem(ui_elem_type_t type, const char *label, float *zone)
{
  ui_elem_t *elems1 = (ui_elem_t*)realloc(elems, (nelems+1)*sizeof(ui_elem_t));
  if (elems1)
    elems = elems1;
  else
    return;
  std::string s = pathcat(path, mangle(name, level, label));
  elems[nelems].type = type;
  elems[nelems].label = strdup(s.c_str());
  elems[nelems].zone = zone;
  elems[nelems].init = 0.0;
  elems[nelems].min = 0.0;
  elems[nelems].max = 1.0;
  elems[nelems].step = 1.0;
  nelems++;
}

inline void PdUI::add_elem(ui_elem_type_t type, const char *label, float *zone,
			  float init, float min, float max, float step)
{
  ui_elem_t *elems1 = (ui_elem_t*)realloc(elems, (nelems+1)*sizeof(ui_elem_t));
  if (elems1)
    elems = elems1;
  else
    return;
  std::string s = pathcat(path, mangle(name, level, label));
  elems[nelems].type = type;
  elems[nelems].label = strdup(s.c_str());
  elems[nelems].zone = zone;
  elems[nelems].init = init;
  elems[nelems].min = min;
  elems[nelems].max = max;
  elems[nelems].step = step;
  nelems++;
}

inline void PdUI::add_elem(ui_elem_type_t type, const char *label, float *zone,
			  float min, float max)
{
  ui_elem_t *elems1 = (ui_elem_t*)realloc(elems, (nelems+1)*sizeof(ui_elem_t));
  if (elems1)
    elems = elems1;
  else
    return;
  std::string s = pathcat(path, mangle(name, level, label));
  elems[nelems].type = type;
  elems[nelems].label = strdup(s.c_str());
  elems[nelems].zone = zone;
  elems[nelems].init = 0.0;
  elems[nelems].min = min;
  elems[nelems].max = max;
  elems[nelems].step = 0.0;
  nelems++;
}

void PdUI::addButton(const char* label, float* zone)
{ add_elem(UI_BUTTON, label, zone); }
void PdUI::addCheckButton(const char* label, float* zone)
{ add_elem(UI_CHECK_BUTTON, label, zone); }
void PdUI::addVerticalSlider(const char* label, float* zone, float init, float min, float max, float step)
{ add_elem(UI_V_SLIDER, label, zone, init, min, max, step); }
void PdUI::addHorizontalSlider(const char* label, float* zone, float init, float min, float max, float step)
{ add_elem(UI_H_SLIDER, label, zone, init, min, max, step); }
void PdUI::addNumEntry(const char* label, float* zone, float init, float min, float max, float step)
{ add_elem(UI_NUM_ENTRY, label, zone, init, min, max, step); }

void PdUI::addHorizontalBargraph(const char* label, float* zone, float min, float max)
{ add_elem(UI_H_BARGRAPH, label, zone, min, max); }
void PdUI::addVerticalBargraph(const char* label, float* zone, float min, float max)
{ add_elem(UI_V_BARGRAPH, label, zone, min, max); }

void PdUI::openTabBox(const char* label)
{
  if (!path.empty()) path += "/";
  path += mangle(name, level, label);
  level++;
}
void PdUI::openHorizontalBox(const char* label)
{
  if (!path.empty()) path += "/";
  path += mangle(name, level, label);
  level++;
}
void PdUI::openVerticalBox(const char* label)
{
  if (!path.empty()) path += "/";
  path += mangle(name, level, label);
  level++;
}
void PdUI::closeBox()
{
  int pos = path.rfind("/");
  if (pos < 0) pos = 0;
  path.erase(pos);
  level--;
}

void PdUI::run() {}

/******************************************************************************
*******************************************************************************

			    FAUST DSP

*******************************************************************************
*******************************************************************************/

//----------------------------------------------------------------------------
//  FAUST generated signal processor
//----------------------------------------------------------------------------
		
#ifndef FAUSTFLOAT
#define FAUSTFLOAT float
#endif  

#include <math.h>

inline float faustpower2_f(float value) {
	return (value * value);
	
}

#ifndef FAUSTCLASS 
#define FAUSTCLASS mydsp
#endif

class mydsp : public dsp {
	
  private:
	
	float fRec9[3];
	float fRec8[3];
	float fRec7[3];
	float fRec6[3];
	float fRec5[3];
	float fRec4[3];
	float fRec3[3];
	float fRec2[3];
	float fRec1[3];
	float fRec0[3];
	int fSamplingFreq;
	float fConst0;
	FAUSTFLOAT fEntry0;
	FAUSTFLOAT fVslider0;
	FAUSTFLOAT fEntry1;
	FAUSTFLOAT fEntry2;
	FAUSTFLOAT fVslider1;
	FAUSTFLOAT fEntry3;
	FAUSTFLOAT fEntry4;
	FAUSTFLOAT fVslider2;
	FAUSTFLOAT fEntry5;
	FAUSTFLOAT fEntry6;
	FAUSTFLOAT fVslider3;
	FAUSTFLOAT fEntry7;
	FAUSTFLOAT fEntry8;
	FAUSTFLOAT fVslider4;
	FAUSTFLOAT fEntry9;
	FAUSTFLOAT fEntry10;
	FAUSTFLOAT fVslider5;
	FAUSTFLOAT fEntry11;
	FAUSTFLOAT fEntry12;
	FAUSTFLOAT fVslider6;
	FAUSTFLOAT fEntry13;
	FAUSTFLOAT fEntry14;
	FAUSTFLOAT fVslider7;
	FAUSTFLOAT fEntry15;
	FAUSTFLOAT fEntry16;
	FAUSTFLOAT fVslider8;
	FAUSTFLOAT fEntry17;
	FAUSTFLOAT fEntry18;
	FAUSTFLOAT fVslider9;
	FAUSTFLOAT fEntry19;
	
  public:
	
	void static metadata(Meta* m) { 
		m->declare("author", "Grame");
		m->declare("bandfilter.dsp/author", "Grame");
		m->declare("bandfilter.dsp/copyright", "(c)GRAME 2006");
		m->declare("bandfilter.dsp/license", "BSD");
		m->declare("bandfilter.dsp/name", "bandfilter");
		m->declare("bandfilter.dsp/version", "1.0");
		m->declare("copyright", "(c)GRAME 2006");
		m->declare("license", "BSD");
		m->declare("math.lib/author", "GRAME");
		m->declare("math.lib/copyright", "GRAME");
		m->declare("math.lib/license", "LGPL with exception");
		m->declare("math.lib/name", "Math Library");
		m->declare("math.lib/version", "1.0");
		m->declare("music.lib/author", "GRAME");
		m->declare("music.lib/copyright", "GRAME");
		m->declare("music.lib/license", "LGPL with exception");
		m->declare("music.lib/name", "Music Library");
		m->declare("music.lib/version", "1.0");
		m->declare("name", "multibandfilter");
		m->declare("version", "1.0");
	}

	virtual int getNumInputs() {
		return 1;
		
	}
	virtual int getNumOutputs() {
		return 1;
		
	}
	virtual int getInputRate(int channel) {
		int rate;
		switch (channel) {
			case 0: {
				rate = 1;
				break;
			}
			default: {
				rate = -1;
				break;
			}
			
		}
		return rate;
		
	}
	virtual int getOutputRate(int channel) {
		int rate;
		switch (channel) {
			case 0: {
				rate = 1;
				break;
			}
			default: {
				rate = -1;
				break;
			}
			
		}
		return rate;
		
	}
	
	static void classInit(int samplingFreq) {
		
	}
	
	virtual void instanceInit(int samplingFreq) {
		fSamplingFreq = samplingFreq;
		fConst0 = float((3.14159f / float(min(192000, max(1, fSamplingFreq)))));
		fEntry0 = FAUSTFLOAT(10000.);
		fVslider0 = FAUSTFLOAT(0.);
		fEntry1 = FAUSTFLOAT(50.);
		fEntry2 = FAUSTFLOAT(9000.);
		fVslider1 = FAUSTFLOAT(0.);
		fEntry3 = FAUSTFLOAT(50.);
		fEntry4 = FAUSTFLOAT(8000.);
		fVslider2 = FAUSTFLOAT(0.);
		fEntry5 = FAUSTFLOAT(50.);
		fEntry6 = FAUSTFLOAT(7000.);
		fVslider3 = FAUSTFLOAT(0.);
		fEntry7 = FAUSTFLOAT(50.);
		fEntry8 = FAUSTFLOAT(6000.);
		fVslider4 = FAUSTFLOAT(0.);
		fEntry9 = FAUSTFLOAT(50.);
		fEntry10 = FAUSTFLOAT(5000.);
		fVslider5 = FAUSTFLOAT(0.);
		fEntry11 = FAUSTFLOAT(50.);
		fEntry12 = FAUSTFLOAT(4000.);
		fVslider6 = FAUSTFLOAT(0.);
		fEntry13 = FAUSTFLOAT(50.);
		fEntry14 = FAUSTFLOAT(3000.);
		fVslider7 = FAUSTFLOAT(0.);
		fEntry15 = FAUSTFLOAT(50.);
		fEntry16 = FAUSTFLOAT(2000.);
		fVslider8 = FAUSTFLOAT(0.);
		fEntry17 = FAUSTFLOAT(50.);
		fEntry18 = FAUSTFLOAT(1000.);
		fVslider9 = FAUSTFLOAT(0.);
		fEntry19 = FAUSTFLOAT(50.);
		for (int i0 = 0; (i0 < 3); i0 = (i0 + 1)) {
			fRec9[i0] = 0.f;
			
		}
		for (int i1 = 0; (i1 < 3); i1 = (i1 + 1)) {
			fRec8[i1] = 0.f;
			
		}
		for (int i2 = 0; (i2 < 3); i2 = (i2 + 1)) {
			fRec7[i2] = 0.f;
			
		}
		for (int i3 = 0; (i3 < 3); i3 = (i3 + 1)) {
			fRec6[i3] = 0.f;
			
		}
		for (int i4 = 0; (i4 < 3); i4 = (i4 + 1)) {
			fRec5[i4] = 0.f;
			
		}
		for (int i5 = 0; (i5 < 3); i5 = (i5 + 1)) {
			fRec4[i5] = 0.f;
			
		}
		for (int i6 = 0; (i6 < 3); i6 = (i6 + 1)) {
			fRec3[i6] = 0.f;
			
		}
		for (int i7 = 0; (i7 < 3); i7 = (i7 + 1)) {
			fRec2[i7] = 0.f;
			
		}
		for (int i8 = 0; (i8 < 3); i8 = (i8 + 1)) {
			fRec1[i8] = 0.f;
			
		}
		for (int i9 = 0; (i9 < 3); i9 = (i9 + 1)) {
			fRec0[i9] = 0.f;
			
		}
		
	}
	
	virtual void init(int samplingFreq) {
		classInit(samplingFreq);
		instanceInit(samplingFreq);
	}
	
	virtual void buildUserInterface(UI* interface) {
		interface->openHorizontalBox("Multi Band Filter");
		interface->openVerticalBox("peak 0");
		interface->addNumEntry("Q factor", &fEntry19, 50.f, 0.1f, 100.f, 0.1f);
		interface->addNumEntry("freq (Hz)", &fEntry18, 1000.f, 20.f, 20000.f, 1.f);
		interface->addVerticalSlider("gain (dB)", &fVslider9, 0.f, -50.f, 50.f, 0.1f);
		interface->closeBox();
		interface->openVerticalBox("peak 1");
		interface->addNumEntry("Q factor", &fEntry17, 50.f, 0.1f, 100.f, 0.1f);
		interface->addNumEntry("freq (Hz)", &fEntry16, 2000.f, 20.f, 20000.f, 1.f);
		interface->addVerticalSlider("gain (dB)", &fVslider8, 0.f, -50.f, 50.f, 0.1f);
		interface->closeBox();
		interface->openVerticalBox("peak 2");
		interface->addNumEntry("Q factor", &fEntry15, 50.f, 0.1f, 100.f, 0.1f);
		interface->addNumEntry("freq (Hz)", &fEntry14, 3000.f, 20.f, 20000.f, 1.f);
		interface->addVerticalSlider("gain (dB)", &fVslider7, 0.f, -50.f, 50.f, 0.1f);
		interface->closeBox();
		interface->openVerticalBox("peak 3");
		interface->addNumEntry("Q factor", &fEntry13, 50.f, 0.1f, 100.f, 0.1f);
		interface->addNumEntry("freq (Hz)", &fEntry12, 4000.f, 20.f, 20000.f, 1.f);
		interface->addVerticalSlider("gain (dB)", &fVslider6, 0.f, -50.f, 50.f, 0.1f);
		interface->closeBox();
		interface->openVerticalBox("peak 4");
		interface->addNumEntry("Q factor", &fEntry11, 50.f, 0.1f, 100.f, 0.1f);
		interface->addNumEntry("freq (Hz)", &fEntry10, 5000.f, 20.f, 20000.f, 1.f);
		interface->addVerticalSlider("gain (dB)", &fVslider5, 0.f, -50.f, 50.f, 0.1f);
		interface->closeBox();
		interface->openVerticalBox("peak 5");
		interface->addNumEntry("Q factor", &fEntry9, 50.f, 0.1f, 100.f, 0.1f);
		interface->addNumEntry("freq (Hz)", &fEntry8, 6000.f, 20.f, 20000.f, 1.f);
		interface->addVerticalSlider("gain (dB)", &fVslider4, 0.f, -50.f, 50.f, 0.1f);
		interface->closeBox();
		interface->openVerticalBox("peak 6");
		interface->addNumEntry("Q factor", &fEntry7, 50.f, 0.1f, 100.f, 0.1f);
		interface->addNumEntry("freq (Hz)", &fEntry6, 7000.f, 20.f, 20000.f, 1.f);
		interface->addVerticalSlider("gain (dB)", &fVslider3, 0.f, -50.f, 50.f, 0.1f);
		interface->closeBox();
		interface->openVerticalBox("peak 7");
		interface->addNumEntry("Q factor", &fEntry5, 50.f, 0.1f, 100.f, 0.1f);
		interface->addNumEntry("freq (Hz)", &fEntry4, 8000.f, 20.f, 20000.f, 1.f);
		interface->addVerticalSlider("gain (dB)", &fVslider2, 0.f, -50.f, 50.f, 0.1f);
		interface->closeBox();
		interface->openVerticalBox("peak 8");
		interface->addNumEntry("Q factor", &fEntry3, 50.f, 0.1f, 100.f, 0.1f);
		interface->addNumEntry("freq (Hz)", &fEntry2, 9000.f, 20.f, 20000.f, 1.f);
		interface->addVerticalSlider("gain (dB)", &fVslider1, 0.f, -50.f, 50.f, 0.1f);
		interface->closeBox();
		interface->openVerticalBox("peak 9");
		interface->addNumEntry("Q factor", &fEntry1, 50.f, 0.1f, 100.f, 0.1f);
		interface->addNumEntry("freq (Hz)", &fEntry0, 10000.f, 20.f, 20000.f, 1.f);
		interface->addVerticalSlider("gain (dB)", &fVslider0, 0.f, -50.f, 50.f, 0.1f);
		interface->closeBox();
		interface->closeBox();
		
	}
	
	virtual void compute(int count, FAUSTFLOAT** inputs, FAUSTFLOAT** outputs) {
		FAUSTFLOAT* input0 = inputs[0];
		FAUSTFLOAT* output0 = outputs[0];
		float fSlow0 = tanf(float((fConst0 * float(fEntry0))));
		float fSlow1 = float(fEntry1);
		float fSlow2 = float((powf(10.f, float((0.05f * float((0.f - float(fVslider0)))))) / fSlow1));
		float fSlow3 = float((1.f / float((1.f + float((fSlow0 * float((fSlow0 + fSlow2))))))));
		float fSlow4 = float((2.f * float((faustpower2_f(fSlow0) - 1.f))));
		float fSlow5 = tanf(float((fConst0 * float(fEntry2))));
		float fSlow6 = float(fEntry3);
		float fSlow7 = float((powf(10.f, float((0.05f * float((0.f - float(fVslider1)))))) / fSlow6));
		float fSlow8 = float((1.f / float((1.f + float((fSlow5 * float((fSlow5 + fSlow7))))))));
		float fSlow9 = float((2.f * float((faustpower2_f(fSlow5) - 1.f))));
		float fSlow10 = tanf(float((fConst0 * float(fEntry4))));
		float fSlow11 = float(fEntry5);
		float fSlow12 = float((powf(10.f, float((0.05f * float((0.f - float(fVslider2)))))) / fSlow11));
		float fSlow13 = float((1.f / float((1.f + float((fSlow10 * float((fSlow10 + fSlow12))))))));
		float fSlow14 = float((2.f * float((faustpower2_f(fSlow10) - 1.f))));
		float fSlow15 = tanf(float((fConst0 * float(fEntry6))));
		float fSlow16 = float(fEntry7);
		float fSlow17 = float((powf(10.f, float((0.05f * float((0.f - float(fVslider3)))))) / fSlow16));
		float fSlow18 = float((1.f / float((1.f + float((fSlow15 * float((fSlow15 + fSlow17))))))));
		float fSlow19 = float((2.f * float((faustpower2_f(fSlow15) - 1.f))));
		float fSlow20 = tanf(float((fConst0 * float(fEntry8))));
		float fSlow21 = float(fEntry9);
		float fSlow22 = float((powf(10.f, float((0.05f * float((0.f - float(fVslider4)))))) / fSlow21));
		float fSlow23 = float((1.f / float((1.f + float((fSlow20 * float((fSlow20 + fSlow22))))))));
		float fSlow24 = float((2.f * float((faustpower2_f(fSlow20) - 1.f))));
		float fSlow25 = tanf(float((fConst0 * float(fEntry10))));
		float fSlow26 = float(fEntry11);
		float fSlow27 = float((powf(10.f, float((0.05f * float((0.f - float(fVslider5)))))) / fSlow26));
		float fSlow28 = float((1.f / float((1.f + float((fSlow25 * float((fSlow25 + fSlow27))))))));
		float fSlow29 = float((2.f * float((faustpower2_f(fSlow25) - 1.f))));
		float fSlow30 = tanf(float((fConst0 * float(fEntry12))));
		float fSlow31 = float(fEntry13);
		float fSlow32 = float((powf(10.f, float((0.05f * float((0.f - float(fVslider6)))))) / fSlow31));
		float fSlow33 = float((1.f / float((1.f + float((fSlow30 * float((fSlow30 + fSlow32))))))));
		float fSlow34 = float((2.f * float((faustpower2_f(fSlow30) - 1.f))));
		float fSlow35 = tanf(float((fConst0 * float(fEntry14))));
		float fSlow36 = float(fEntry15);
		float fSlow37 = float((powf(10.f, float((0.05f * float((0.f - float(fVslider7)))))) / fSlow36));
		float fSlow38 = float((1.f / float((1.f + float((fSlow35 * float((fSlow35 + fSlow37))))))));
		float fSlow39 = float((2.f * float((faustpower2_f(fSlow35) - 1.f))));
		float fSlow40 = tanf(float((fConst0 * float(fEntry16))));
		float fSlow41 = float(fEntry17);
		float fSlow42 = float((powf(10.f, float((0.05f * float((0.f - float(fVslider8)))))) / fSlow41));
		float fSlow43 = float((1.f / float((1.f + float((fSlow40 * float((fSlow40 + fSlow42))))))));
		float fSlow44 = float((2.f * float((faustpower2_f(fSlow40) - 1.f))));
		float fSlow45 = tanf(float((fConst0 * float(fEntry18))));
		float fSlow46 = float(fEntry19);
		float fSlow47 = float((powf(10.f, float((0.05f * float((0.f - float(fVslider9)))))) / fSlow46));
		float fSlow48 = float((1.f / float((1.f + float((fSlow45 * float((fSlow45 + fSlow47))))))));
		float fSlow49 = float((2.f * float((faustpower2_f(fSlow45) - 1.f))));
		float fSlow50 = float((1.f + float((fSlow45 * float((fSlow45 - fSlow47))))));
		float fSlow51 = float((1.f / fSlow46));
		float fSlow52 = float((1.f + float((fSlow45 * float((fSlow45 + fSlow51))))));
		float fSlow53 = float((1.f + float((fSlow45 * float((fSlow45 - fSlow51))))));
		float fSlow54 = float((1.f + float((fSlow40 * float((fSlow40 - fSlow42))))));
		float fSlow55 = float((1.f / fSlow41));
		float fSlow56 = float((1.f + float((fSlow40 * float((fSlow40 + fSlow55))))));
		float fSlow57 = float((1.f + float((fSlow40 * float((fSlow40 - fSlow55))))));
		float fSlow58 = float((1.f + float((fSlow35 * float((fSlow35 - fSlow37))))));
		float fSlow59 = float((1.f / fSlow36));
		float fSlow60 = float((1.f + float((fSlow35 * float((fSlow35 + fSlow59))))));
		float fSlow61 = float((1.f + float((fSlow35 * float((fSlow35 - fSlow59))))));
		float fSlow62 = float((1.f + float((fSlow30 * float((fSlow30 - fSlow32))))));
		float fSlow63 = float((1.f / fSlow31));
		float fSlow64 = float((1.f + float((fSlow30 * float((fSlow30 + fSlow63))))));
		float fSlow65 = float((1.f + float((fSlow30 * float((fSlow30 - fSlow63))))));
		float fSlow66 = float((1.f + float((fSlow25 * float((fSlow25 - fSlow27))))));
		float fSlow67 = float((1.f / fSlow26));
		float fSlow68 = float((1.f + float((fSlow25 * float((fSlow25 + fSlow67))))));
		float fSlow69 = float((1.f + float((fSlow25 * float((fSlow25 - fSlow67))))));
		float fSlow70 = float((1.f + float((fSlow20 * float((fSlow20 - fSlow22))))));
		float fSlow71 = float((1.f / fSlow21));
		float fSlow72 = float((1.f + float((fSlow20 * float((fSlow20 + fSlow71))))));
		float fSlow73 = float((1.f + float((fSlow20 * float((fSlow20 - fSlow71))))));
		float fSlow74 = float((1.f + float((fSlow15 * float((fSlow15 - fSlow17))))));
		float fSlow75 = float((1.f / fSlow16));
		float fSlow76 = float((1.f + float((fSlow15 * float((fSlow15 + fSlow75))))));
		float fSlow77 = float((1.f + float((fSlow15 * float((fSlow15 - fSlow75))))));
		float fSlow78 = float((1.f + float((fSlow10 * float((fSlow10 - fSlow12))))));
		float fSlow79 = float((1.f / fSlow11));
		float fSlow80 = float((1.f + float((fSlow10 * float((fSlow10 + fSlow79))))));
		float fSlow81 = float((1.f + float((fSlow10 * float((fSlow10 - fSlow79))))));
		float fSlow82 = float((1.f + float((fSlow5 * float((fSlow5 - fSlow7))))));
		float fSlow83 = float((1.f / fSlow6));
		float fSlow84 = float((1.f + float((fSlow5 * float((fSlow5 + fSlow83))))));
		float fSlow85 = float((1.f + float((fSlow5 * float((fSlow5 - fSlow83))))));
		float fSlow86 = float((1.f + float((fSlow0 * float((fSlow0 - fSlow2))))));
		float fSlow87 = float((1.f / fSlow1));
		float fSlow88 = float((1.f + float((fSlow0 * float((fSlow0 + fSlow87))))));
		float fSlow89 = float((1.f + float((fSlow0 * float((fSlow0 - fSlow87))))));
		for (int i = 0; (i < count); i = (i + 1)) {
			float fTemp0 = float((fSlow49 * fRec9[1]));
			fRec9[0] = float((float(input0[i]) - float((fSlow48 * float((float((fSlow50 * fRec9[2])) + fTemp0))))));
			float fTemp1 = float((fSlow44 * fRec8[1]));
			fRec8[0] = float((float((fSlow48 * float((float((fTemp0 + float((fSlow52 * fRec9[0])))) + float((fSlow53 * fRec9[2])))))) - float((fSlow43 * float((float((fSlow54 * fRec8[2])) + fTemp1))))));
			float fTemp2 = float((fSlow39 * fRec7[1]));
			fRec7[0] = float((float((fSlow43 * float((float((fTemp1 + float((fSlow56 * fRec8[0])))) + float((fSlow57 * fRec8[2])))))) - float((fSlow38 * float((float((fSlow58 * fRec7[2])) + fTemp2))))));
			float fTemp3 = float((fSlow34 * fRec6[1]));
			fRec6[0] = float((float((fSlow38 * float((float((fTemp2 + float((fSlow60 * fRec7[0])))) + float((fSlow61 * fRec7[2])))))) - float((fSlow33 * float((float((fSlow62 * fRec6[2])) + fTemp3))))));
			float fTemp4 = float((fSlow29 * fRec5[1]));
			fRec5[0] = float((float((fSlow33 * float((float((fTemp3 + float((fSlow64 * fRec6[0])))) + float((fSlow65 * fRec6[2])))))) - float((fSlow28 * float((float((fSlow66 * fRec5[2])) + fTemp4))))));
			float fTemp5 = float((fSlow24 * fRec4[1]));
			fRec4[0] = float((float((fSlow28 * float((float((fTemp4 + float((fSlow68 * fRec5[0])))) + float((fSlow69 * fRec5[2])))))) - float((fSlow23 * float((float((fSlow70 * fRec4[2])) + fTemp5))))));
			float fTemp6 = float((fSlow19 * fRec3[1]));
			fRec3[0] = float((float((fSlow23 * float((float((fTemp5 + float((fSlow72 * fRec4[0])))) + float((fSlow73 * fRec4[2])))))) - float((fSlow18 * float((float((fSlow74 * fRec3[2])) + fTemp6))))));
			float fTemp7 = float((fSlow14 * fRec2[1]));
			fRec2[0] = float((float((fSlow18 * float((float((fTemp6 + float((fSlow76 * fRec3[0])))) + float((fSlow77 * fRec3[2])))))) - float((fSlow13 * float((float((fSlow78 * fRec2[2])) + fTemp7))))));
			float fTemp8 = float((fSlow9 * fRec1[1]));
			fRec1[0] = float((float((fSlow13 * float((float((fTemp7 + float((fSlow80 * fRec2[0])))) + float((fSlow81 * fRec2[2])))))) - float((fSlow8 * float((float((fSlow82 * fRec1[2])) + fTemp8))))));
			float fTemp9 = float((fSlow4 * fRec0[1]));
			fRec0[0] = float((float((fSlow8 * float((float((fTemp8 + float((fSlow84 * fRec1[0])))) + float((fSlow85 * fRec1[2])))))) - float((fSlow3 * float((float((fSlow86 * fRec0[2])) + fTemp9))))));
			output0[i] = FAUSTFLOAT(float((fSlow3 * float((float((fTemp9 + float((fSlow88 * fRec0[0])))) + float((fSlow89 * fRec0[2])))))));
			fRec9[2] = fRec9[1];
			fRec9[1] = fRec9[0];
			fRec8[2] = fRec8[1];
			fRec8[1] = fRec8[0];
			fRec7[2] = fRec7[1];
			fRec7[1] = fRec7[0];
			fRec6[2] = fRec6[1];
			fRec6[1] = fRec6[0];
			fRec5[2] = fRec5[1];
			fRec5[1] = fRec5[0];
			fRec4[2] = fRec4[1];
			fRec4[1] = fRec4[0];
			fRec3[2] = fRec3[1];
			fRec3[1] = fRec3[0];
			fRec2[2] = fRec2[1];
			fRec2[1] = fRec2[0];
			fRec1[2] = fRec1[1];
			fRec1[1] = fRec1[0];
			fRec0[2] = fRec0[1];
			fRec0[1] = fRec0[0];
			
		}
		
	}

	
};


#include <stdio.h>
#include <string>
#include "m_pd.h"

#define sym(name) xsym(name)
#define xsym(name) #name
#define faust_setup(name) xfaust_setup(name)
#define xfaust_setup(name) name ## _tilde_setup(void)

// time for "active" toggle xfades in secs
#define XFADE_TIME 0.1f

static t_class *faust_class;

struct t_faust {
  t_object x_obj;
#ifdef __MINGW32__
  /* This seems to be necessary as some as yet undetermined Pd routine seems
     to write past the end of x_obj on Windows. */
  int fence; /* dummy field (not used) */
#endif
  mydsp *dsp;
  PdUI *ui;
  std::string *label;
  int active, xfade, n_xfade, rate, n_in, n_out;
  t_sample **inputs, **outputs, **buf;
  t_outlet *out;
  t_sample f;
};

static t_symbol *s_button, *s_checkbox, *s_vslider, *s_hslider, *s_nentry,
  *s_vbargraph, *s_hbargraph;

static inline void zero_samples(int k, int n, t_sample **out)
{
  for (int i = 0; i < k; i++)
#ifdef __STDC_IEC_559__
    /* IEC 559 a.k.a. IEEE 754 floats can be initialized faster like this */
    memset(out[i], 0, n*sizeof(t_sample));
#else
    for (int j = 0; j < n; j++)
      out[i][j] = 0.0f;
#endif
}

static inline void copy_samples(int k, int n, t_sample **out, t_sample **in)
{
  for (int i = 0; i < k; i++)
    memcpy(out[i], in[i], n*sizeof(t_sample));
}

static t_int *faust_perform(t_int *w)
{
  t_faust *x = (t_faust *)(w[1]);
  int n = (int)(w[2]);
  if (!x->dsp || !x->buf) return (w+3);
  AVOIDDENORMALS;
  if (x->xfade > 0) {
    float d = 1.0f/x->n_xfade, f = (x->xfade--)*d;
    d = d/n;
    x->dsp->compute(n, x->inputs, x->buf);
    if (x->active)
      if (x->n_in == x->n_out)
	/* xfade inputs -> buf */
	for (int j = 0; j < n; j++, f -= d)
	  for (int i = 0; i < x->n_out; i++)
	    x->outputs[i][j] = f*x->inputs[i][j]+(1.0f-f)*x->buf[i][j];
      else
	/* xfade 0 -> buf */
	for (int j = 0; j < n; j++, f -= d)
	  for (int i = 0; i < x->n_out; i++)
	    x->outputs[i][j] = (1.0f-f)*x->buf[i][j];
    else
      if (x->n_in == x->n_out)
	/* xfade buf -> inputs */
	for (int j = 0; j < n; j++, f -= d)
	  for (int i = 0; i < x->n_out; i++)
	    x->outputs[i][j] = f*x->buf[i][j]+(1.0f-f)*x->inputs[i][j];
      else
	/* xfade buf -> 0 */
	for (int j = 0; j < n; j++, f -= d)
	  for (int i = 0; i < x->n_out; i++)
	    x->outputs[i][j] = f*x->buf[i][j];
  } else if (x->active) {
    x->dsp->compute(n, x->inputs, x->buf);
    copy_samples(x->n_out, n, x->outputs, x->buf);
  } else if (x->n_in == x->n_out) {
    copy_samples(x->n_out, n, x->buf, x->inputs);
    copy_samples(x->n_out, n, x->outputs, x->buf);
  } else
    zero_samples(x->n_out, n, x->outputs);
  return (w+3);
}

static void faust_dsp(t_faust *x, t_signal **sp)
{
  int n = sp[0]->s_n, sr = (int)sp[0]->s_sr;
  if (x->rate <= 0) {
    /* default sample rate is whatever Pd tells us */
    PdUI *ui = x->ui;
    float *z = NULL;
    if (ui->nelems > 0 &&
	(z = (float*)malloc(ui->nelems*sizeof(float)))) {
      /* save the current control values */
      for (int i = 0; i < ui->nelems; i++)
	if (ui->elems[i].zone)
	  z[i] = *ui->elems[i].zone;
    }
    /* set the proper sample rate; this requires reinitializing the dsp */
    x->rate = sr;
    x->dsp->init(sr);
    if (z) {
      /* restore previous control values */
      for (int i = 0; i < ui->nelems; i++)
	if (ui->elems[i].zone)
	  *ui->elems[i].zone = z[i];
      free(z);
    }
  }
  if (n > 0)
    x->n_xfade = (int)(x->rate*XFADE_TIME/n);
  dsp_add(faust_perform, 2, x, n);
  for (int i = 0; i < x->n_in; i++)
    x->inputs[i] = sp[i+1]->s_vec;
  for (int i = 0; i < x->n_out; i++)
    x->outputs[i] = sp[x->n_in+i+1]->s_vec;
  if (x->buf != NULL)
    for (int i = 0; i < x->n_out; i++) {
      x->buf[i] = (t_sample*)malloc(n*sizeof(t_sample));
      if (x->buf[i] == NULL) {
	for (int j = 0; j < i; j++)
	  free(x->buf[j]);
	free(x->buf);
	x->buf = NULL;
	break;
      }
    }
}

static int pathcmp(const char *s, const char *t)
{
  int n = strlen(s), m = strlen(t);
  if (n == 0 || m == 0)
    return 0;
  else if (t[0] == '/')
    return strcmp(s, t);
  else if (n <= m || s[n-m-1] != '/')
    return strcmp(s+1, t);
  else
    return strcmp(s+n-m, t);
}

static void faust_any(t_faust *x, t_symbol *s, int argc, t_atom *argv)
{
  if (!x->dsp) return;
  PdUI *ui = x->ui;
  if (s == &s_bang) {
    for (int i = 0; i < ui->nelems; i++)
      if (ui->elems[i].label && ui->elems[i].zone) {
	t_atom args[6];
	t_symbol *_s;
	switch (ui->elems[i].type) {
	case UI_BUTTON:
	  _s = s_button;
	  break;
	case UI_CHECK_BUTTON:
	  _s = s_checkbox;
	  break;
	case UI_V_SLIDER:
	  _s = s_vslider;
	  break;
	case UI_H_SLIDER:
	  _s = s_hslider;
	  break;
	case UI_NUM_ENTRY:
	  _s = s_nentry;
	  break;
	case UI_V_BARGRAPH:
	  _s = s_vbargraph;
	  break;
	case UI_H_BARGRAPH:
	  _s = s_hbargraph;
	  break;
	default:
	  continue;
	}
	SETSYMBOL(&args[0], gensym(ui->elems[i].label));
	SETFLOAT(&args[1], *ui->elems[i].zone);
	SETFLOAT(&args[2], ui->elems[i].init);
	SETFLOAT(&args[3], ui->elems[i].min);
	SETFLOAT(&args[4], ui->elems[i].max);
	SETFLOAT(&args[5], ui->elems[i].step);
	outlet_anything(x->out, _s, 6, args);
      }
  } else {
    const char *label = s->s_name;
    int count = 0;
    for (int i = 0; i < ui->nelems; i++)
      if (ui->elems[i].label &&
	  pathcmp(ui->elems[i].label, label) == 0) {
	if (argc == 0) {
	  if (ui->elems[i].zone) {
	    t_atom arg;
	    SETFLOAT(&arg, *ui->elems[i].zone);
	    outlet_anything(x->out, gensym(ui->elems[i].label), 1, &arg);
	  }
	  ++count;
	} else if (argc == 1 &&
		   (argv[0].a_type == A_FLOAT ||
		    argv[0].a_type == A_DEFFLOAT) &&
		   ui->elems[i].zone) {
	  float f = atom_getfloat(argv);
	  *ui->elems[i].zone = f;
	  ++count;
	} else
	  pd_error(x, "[faust] %s: bad control argument: %s",
		   x->label->c_str(), label);
      }
    if (count == 0 && strcmp(label, "active") == 0) {
      if (argc == 0) {
	t_atom arg;
	SETFLOAT(&arg, (float)x->active);
	outlet_anything(x->out, gensym((char*)"active"), 1, &arg);
      } else if (argc == 1 &&
		 (argv[0].a_type == A_FLOAT ||
		  argv[0].a_type == A_DEFFLOAT)) {
	float f = atom_getfloat(argv);
	x->active = (int)f;
	x->xfade = x->n_xfade;
      }
    }
  }
}

static void faust_free(t_faust *x)
{
  if (x->label) delete x->label;
  if (x->dsp) delete x->dsp;
  if (x->ui) delete x->ui;
  if (x->inputs) free(x->inputs);
  if (x->outputs) free(x->outputs);
  if (x->buf) {
    for (int i = 0; i < x->n_out; i++)
      if (x->buf[i]) free(x->buf[i]);
    free(x->buf);
  }
}

static void *faust_new(t_symbol *s, int argc, t_atom *argv)
{
  t_faust *x = (t_faust*)pd_new(faust_class);
  int sr = -1;
  t_symbol *id = NULL;
  x->active = 1;
  for (int i = 0; i < argc; i++)
    if (argv[i].a_type == A_FLOAT || argv[i].a_type == A_DEFFLOAT)
      sr = (int)argv[i].a_w.w_float;
    else if (argv[i].a_type == A_SYMBOL || argv[i].a_type == A_DEFSYMBOL)
      id = argv[i].a_w.w_symbol;
  x->rate = sr;
  if (sr <= 0) sr = 44100;
  x->xfade = 0; x->n_xfade = (int)(sr*XFADE_TIME/64);
  x->inputs = x->outputs = x->buf = NULL;
    x->label = new std::string(sym(mydsp) "~");
  x->dsp = new mydsp();
  x->ui = new PdUI(sym(mydsp), id?id->s_name:NULL);
  if (!x->dsp || !x->ui || !x->label) goto error;
  if (id) {
    *x->label += " ";
    *x->label += id->s_name;
  }
  x->n_in = x->dsp->getNumInputs();
  x->n_out = x->dsp->getNumOutputs();
  if (x->n_in > 0)
    x->inputs = (t_sample**)malloc(x->n_in*sizeof(t_sample*));
  if (x->n_out > 0) {
    x->outputs = (t_sample**)malloc(x->n_out*sizeof(t_sample*));
    x->buf = (t_sample**)malloc(x->n_out*sizeof(t_sample*));
  }
  if ((x->n_in > 0 && x->inputs == NULL) ||
      (x->n_out > 0 && (x->outputs == NULL || x->buf == NULL)))
    goto error;
  for (int i = 0; i < x->n_out; i++)
    x->buf[i] = NULL;
  x->dsp->init(sr);
  x->dsp->buildUserInterface(x->ui);
  for (int i = 0; i < x->n_in; i++)
    inlet_new(&x->x_obj, &x->x_obj.ob_pd, &s_signal, &s_signal);
  x->out = outlet_new(&x->x_obj, 0);
  for (int i = 0; i < x->n_out; i++)
    outlet_new(&x->x_obj, &s_signal);
  return (void *)x;
 error:
  faust_free(x);
  x->dsp = NULL; x->ui = NULL;
  x->inputs = x->outputs = x->buf = NULL;
  return (void *)x;
}

extern "C" void faust_setup(mydsp)
{
  t_symbol *s = gensym(sym(mydsp) "~");
  faust_class =
    class_new(s, (t_newmethod)faust_new, (t_method)faust_free,
	      sizeof(t_faust), CLASS_DEFAULT,
	      A_GIMME, A_NULL);
  class_addmethod(faust_class, (t_method)faust_dsp, gensym((char*)"dsp"), A_NULL);
  class_addanything(faust_class, faust_any);
  class_addmethod(faust_class, nullfn, &s_signal, A_NULL);
  s_button = gensym((char*)"button");
  s_checkbox = gensym((char*)"checkbox");
  s_vslider = gensym((char*)"vslider");
  s_hslider = gensym((char*)"hslider");
  s_nentry = gensym((char*)"nentry");
  s_vbargraph = gensym((char*)"vbargraph");
  s_hbargraph = gensym((char*)"hbargraph");
  /* give some indication that we're loaded and ready to go */
  mydsp dsp = mydsp();
  post("[faust] %s: %d inputs, %d outputs", sym(mydsp) "~",
       dsp.getNumInputs(), dsp.getNumOutputs());
}

#endif
