//-----------------------------------------------------
// author: "Grame"
// copyright: "(c)GRAME 2006"
// license: "BSD"
// name: "matrix"
// version: "1.0"
//
// Code generated with Faust 2.0.a30 (http://faust.grame.fr)
//-----------------------------------------------------

#ifndef  __mydsp_H__
#define  __mydsp_H__
/************************************************************************
 ************************************************************************
    FAUST Architecture File
	Copyright (C) 2006-2011 Albert Graef <Dr.Graef@t-online.de>
    ---------------------------------------------------------------------
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as 
	published by the Free Software Foundation; either version 2.1 of the 
	License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
 	License along with the GNU C Library; if not, write to the Free
  	Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  	02111-1307 USA. 
 ************************************************************************
 ************************************************************************/

/* Pd architecture file, written by Albert Graef <Dr.Graef@t-online.de>.
   This was derived from minimal.cpp included in the Faust distribution.
   Please note that this is to be compiled as a shared library, which is
   then loaded dynamically by Pd as an external. */

#include <stdlib.h>
#include <math.h>
#include <string>

#include "faust/misc.h"
#include "faust/gui/UI.h"
#include "faust/gui/meta.h"
#include "faust/audio/dsp.h"

//using namespace std;

/******************************************************************************
*******************************************************************************

							       VECTOR INTRINSICS

*******************************************************************************
*******************************************************************************/


/***************************************************************************
   Pd UI interface
 ***************************************************************************/

enum ui_elem_type_t {
  UI_BUTTON, UI_CHECK_BUTTON,
  UI_V_SLIDER, UI_H_SLIDER, UI_NUM_ENTRY,
  UI_V_BARGRAPH, UI_H_BARGRAPH,
  UI_END_GROUP, UI_V_GROUP, UI_H_GROUP, UI_T_GROUP
};

struct ui_elem_t {
  ui_elem_type_t type;
  char *label;
  float *zone;
  float init, min, max, step;
};

class PdUI : public UI
{
public:
  const char *name;
  int nelems, level;
  ui_elem_t *elems;
		
  PdUI();
  PdUI(const char *nm, const char *s);
  virtual ~PdUI();

protected:
  std::string path;
  void add_elem(ui_elem_type_t type, const char *label = NULL);
  void add_elem(ui_elem_type_t type, const char *label, float *zone);
  void add_elem(ui_elem_type_t type, const char *label, float *zone,
		float init, float min, float max, float step);
  void add_elem(ui_elem_type_t type, const char *label, float *zone,
		float min, float max);

public:
  virtual void addButton(const char* label, float* zone);
  virtual void addCheckButton(const char* label, float* zone);
  virtual void addVerticalSlider(const char* label, float* zone, float init, float min, float max, float step);
  virtual void addHorizontalSlider(const char* label, float* zone, float init, float min, float max, float step);
  virtual void addNumEntry(const char* label, float* zone, float init, float min, float max, float step);

  virtual void addHorizontalBargraph(const char* label, float* zone, float min, float max);
  virtual void addVerticalBargraph(const char* label, float* zone, float min, float max);
  
  virtual void openTabBox(const char* label);
  virtual void openHorizontalBox(const char* label);
  virtual void openVerticalBox(const char* label);
  virtual void closeBox();
	
  virtual void run();
};

static std::string mangle(const char *name, int level, const char *s)
{
  const char *s0 = s;
  std::string t = "";
  if (!s) return t;
  // Get rid of bogus "0x00" labels in recent Faust revisions. Also, for
  // backward compatibility with old Faust versions, make sure that default
  // toplevel groups and explicit toplevel groups with an empty label are
  // treated alike (these both return "0x00" labels in the latest Faust, but
  // would be treated inconsistently in earlier versions).
  if (!*s || strcmp(s, "0x00") == 0) {
    if (level == 0)
      // toplevel group with empty label, map to dsp name
      s = name;
    else
      // empty label
      s = "";
  }
  while (*s)
    if (isalnum(*s))
      t += *(s++);
    else {
      const char *s1 = s;
      while (*s && !isalnum(*s)) ++s;
      if (s1 != s0 && *s) t += "-";
    }
  return t;
}

static std::string normpath(std::string path)
{
  path = std::string("/")+path;
  int pos = path.find("//");
  while (pos >= 0) {
    path.erase(pos, 1);
    pos = path.find("//");
  }
  size_t len = path.length();
  if (len > 1 && path[len-1] == '/')
    path.erase(len-1, 1);
  return path;
}

static std::string pathcat(std::string path, std::string label)
{
  if (path.empty())
    return normpath(label);
  else if (label.empty())
    return normpath(path);
  else
    return normpath(path+"/"+label);
}

PdUI::PdUI()
{
  nelems = level = 0;
  elems = NULL;
  name = "";
  path = "";
}

PdUI::PdUI(const char *nm, const char *s)
{
  nelems = level = 0;
  elems = NULL;
  name = nm?nm:"";
  path = s?s:"";
}

PdUI::~PdUI()
{
  if (elems) {
    for (int i = 0; i < nelems; i++)
      if (elems[i].label)
	free(elems[i].label);
    free(elems);
  }
}

inline void PdUI::add_elem(ui_elem_type_t type, const char *label)
{
  ui_elem_t *elems1 = (ui_elem_t*)realloc(elems, (nelems+1)*sizeof(ui_elem_t));
  if (elems1)
    elems = elems1;
  else
    return;
  std::string s = pathcat(path, mangle(name, level, label));
  elems[nelems].type = type;
  elems[nelems].label = strdup(s.c_str());
  elems[nelems].zone = NULL;
  elems[nelems].init = 0.0;
  elems[nelems].min = 0.0;
  elems[nelems].max = 0.0;
  elems[nelems].step = 0.0;
  nelems++;
}

inline void PdUI::add_elem(ui_elem_type_t type, const char *label, float *zone)
{
  ui_elem_t *elems1 = (ui_elem_t*)realloc(elems, (nelems+1)*sizeof(ui_elem_t));
  if (elems1)
    elems = elems1;
  else
    return;
  std::string s = pathcat(path, mangle(name, level, label));
  elems[nelems].type = type;
  elems[nelems].label = strdup(s.c_str());
  elems[nelems].zone = zone;
  elems[nelems].init = 0.0;
  elems[nelems].min = 0.0;
  elems[nelems].max = 1.0;
  elems[nelems].step = 1.0;
  nelems++;
}

inline void PdUI::add_elem(ui_elem_type_t type, const char *label, float *zone,
			  float init, float min, float max, float step)
{
  ui_elem_t *elems1 = (ui_elem_t*)realloc(elems, (nelems+1)*sizeof(ui_elem_t));
  if (elems1)
    elems = elems1;
  else
    return;
  std::string s = pathcat(path, mangle(name, level, label));
  elems[nelems].type = type;
  elems[nelems].label = strdup(s.c_str());
  elems[nelems].zone = zone;
  elems[nelems].init = init;
  elems[nelems].min = min;
  elems[nelems].max = max;
  elems[nelems].step = step;
  nelems++;
}

inline void PdUI::add_elem(ui_elem_type_t type, const char *label, float *zone,
			  float min, float max)
{
  ui_elem_t *elems1 = (ui_elem_t*)realloc(elems, (nelems+1)*sizeof(ui_elem_t));
  if (elems1)
    elems = elems1;
  else
    return;
  std::string s = pathcat(path, mangle(name, level, label));
  elems[nelems].type = type;
  elems[nelems].label = strdup(s.c_str());
  elems[nelems].zone = zone;
  elems[nelems].init = 0.0;
  elems[nelems].min = min;
  elems[nelems].max = max;
  elems[nelems].step = 0.0;
  nelems++;
}

void PdUI::addButton(const char* label, float* zone)
{ add_elem(UI_BUTTON, label, zone); }
void PdUI::addCheckButton(const char* label, float* zone)
{ add_elem(UI_CHECK_BUTTON, label, zone); }
void PdUI::addVerticalSlider(const char* label, float* zone, float init, float min, float max, float step)
{ add_elem(UI_V_SLIDER, label, zone, init, min, max, step); }
void PdUI::addHorizontalSlider(const char* label, float* zone, float init, float min, float max, float step)
{ add_elem(UI_H_SLIDER, label, zone, init, min, max, step); }
void PdUI::addNumEntry(const char* label, float* zone, float init, float min, float max, float step)
{ add_elem(UI_NUM_ENTRY, label, zone, init, min, max, step); }

void PdUI::addHorizontalBargraph(const char* label, float* zone, float min, float max)
{ add_elem(UI_H_BARGRAPH, label, zone, min, max); }
void PdUI::addVerticalBargraph(const char* label, float* zone, float min, float max)
{ add_elem(UI_V_BARGRAPH, label, zone, min, max); }

void PdUI::openTabBox(const char* label)
{
  if (!path.empty()) path += "/";
  path += mangle(name, level, label);
  level++;
}
void PdUI::openHorizontalBox(const char* label)
{
  if (!path.empty()) path += "/";
  path += mangle(name, level, label);
  level++;
}
void PdUI::openVerticalBox(const char* label)
{
  if (!path.empty()) path += "/";
  path += mangle(name, level, label);
  level++;
}
void PdUI::closeBox()
{
  int pos = path.rfind("/");
  if (pos < 0) pos = 0;
  path.erase(pos);
  level--;
}

void PdUI::run() {}

/******************************************************************************
*******************************************************************************

			    FAUST DSP

*******************************************************************************
*******************************************************************************/

//----------------------------------------------------------------------------
//  FAUST generated signal processor
//----------------------------------------------------------------------------
		
#ifndef FAUSTFLOAT
#define FAUSTFLOAT float
#endif  



#ifndef FAUSTCLASS 
#define FAUSTCLASS mydsp
#endif

class mydsp : public dsp {
	
  private:
	
	FAUSTFLOAT fVslider0;
	FAUSTFLOAT fVslider1;
	FAUSTFLOAT fVslider2;
	FAUSTFLOAT fVslider3;
	FAUSTFLOAT fVslider4;
	FAUSTFLOAT fVslider5;
	FAUSTFLOAT fVslider6;
	FAUSTFLOAT fVslider7;
	FAUSTFLOAT fVslider8;
	FAUSTFLOAT fVslider9;
	FAUSTFLOAT fVslider10;
	FAUSTFLOAT fVslider11;
	FAUSTFLOAT fVslider12;
	FAUSTFLOAT fVslider13;
	FAUSTFLOAT fVslider14;
	FAUSTFLOAT fVslider15;
	FAUSTFLOAT fVslider16;
	FAUSTFLOAT fVslider17;
	FAUSTFLOAT fVslider18;
	FAUSTFLOAT fVslider19;
	FAUSTFLOAT fVslider20;
	FAUSTFLOAT fVslider21;
	FAUSTFLOAT fVslider22;
	FAUSTFLOAT fVslider23;
	FAUSTFLOAT fVslider24;
	FAUSTFLOAT fVslider25;
	FAUSTFLOAT fVslider26;
	FAUSTFLOAT fVslider27;
	FAUSTFLOAT fVslider28;
	FAUSTFLOAT fVslider29;
	FAUSTFLOAT fVslider30;
	FAUSTFLOAT fVslider31;
	FAUSTFLOAT fVslider32;
	FAUSTFLOAT fVslider33;
	FAUSTFLOAT fVslider34;
	FAUSTFLOAT fVslider35;
	FAUSTFLOAT fVslider36;
	FAUSTFLOAT fVslider37;
	FAUSTFLOAT fVslider38;
	FAUSTFLOAT fVslider39;
	FAUSTFLOAT fVslider40;
	FAUSTFLOAT fVslider41;
	FAUSTFLOAT fVslider42;
	FAUSTFLOAT fVslider43;
	FAUSTFLOAT fVslider44;
	FAUSTFLOAT fVslider45;
	FAUSTFLOAT fVslider46;
	FAUSTFLOAT fVslider47;
	FAUSTFLOAT fVslider48;
	FAUSTFLOAT fVslider49;
	FAUSTFLOAT fVslider50;
	FAUSTFLOAT fVslider51;
	FAUSTFLOAT fVslider52;
	FAUSTFLOAT fVslider53;
	FAUSTFLOAT fVslider54;
	FAUSTFLOAT fVslider55;
	FAUSTFLOAT fVslider56;
	FAUSTFLOAT fVslider57;
	FAUSTFLOAT fVslider58;
	FAUSTFLOAT fVslider59;
	FAUSTFLOAT fVslider60;
	FAUSTFLOAT fVslider61;
	FAUSTFLOAT fVslider62;
	FAUSTFLOAT fVslider63;
	int fSamplingFreq;
	
  public:
	
	void static metadata(Meta* m) { 
		m->declare("author", "Grame");
		m->declare("copyright", "(c)GRAME 2006");
		m->declare("license", "BSD");
		m->declare("math.lib/author", "GRAME");
		m->declare("math.lib/copyright", "GRAME");
		m->declare("math.lib/license", "LGPL with exception");
		m->declare("math.lib/name", "Math Library");
		m->declare("math.lib/version", "1.0");
		m->declare("music.lib/author", "GRAME");
		m->declare("music.lib/copyright", "GRAME");
		m->declare("music.lib/license", "LGPL with exception");
		m->declare("music.lib/name", "Music Library");
		m->declare("music.lib/version", "1.0");
		m->declare("name", "matrix");
		m->declare("version", "1.0");
	}

	virtual int getNumInputs() {
		return 8;
		
	}
	virtual int getNumOutputs() {
		return 8;
		
	}
	virtual int getInputRate(int channel) {
		int rate;
		switch (channel) {
			case 0: {
				rate = 1;
				break;
			}
			case 1: {
				rate = 1;
				break;
			}
			case 2: {
				rate = 1;
				break;
			}
			case 3: {
				rate = 1;
				break;
			}
			case 4: {
				rate = 1;
				break;
			}
			case 5: {
				rate = 1;
				break;
			}
			case 6: {
				rate = 1;
				break;
			}
			case 7: {
				rate = 1;
				break;
			}
			default: {
				rate = -1;
				break;
			}
			
		}
		return rate;
		
	}
	virtual int getOutputRate(int channel) {
		int rate;
		switch (channel) {
			case 0: {
				rate = 1;
				break;
			}
			case 1: {
				rate = 1;
				break;
			}
			case 2: {
				rate = 1;
				break;
			}
			case 3: {
				rate = 1;
				break;
			}
			case 4: {
				rate = 1;
				break;
			}
			case 5: {
				rate = 1;
				break;
			}
			case 6: {
				rate = 1;
				break;
			}
			case 7: {
				rate = 1;
				break;
			}
			default: {
				rate = -1;
				break;
			}
			
		}
		return rate;
		
	}
	
	static void classInit(int samplingFreq) {
		
	}
	
	virtual void instanceInit(int samplingFreq) {
		fSamplingFreq = samplingFreq;
		fVslider0 = FAUSTFLOAT(-10.);
		fVslider1 = FAUSTFLOAT(-10.);
		fVslider2 = FAUSTFLOAT(-10.);
		fVslider3 = FAUSTFLOAT(-10.);
		fVslider4 = FAUSTFLOAT(-10.);
		fVslider5 = FAUSTFLOAT(-10.);
		fVslider6 = FAUSTFLOAT(-10.);
		fVslider7 = FAUSTFLOAT(-10.);
		fVslider8 = FAUSTFLOAT(-10.);
		fVslider9 = FAUSTFLOAT(-10.);
		fVslider10 = FAUSTFLOAT(-10.);
		fVslider11 = FAUSTFLOAT(-10.);
		fVslider12 = FAUSTFLOAT(-10.);
		fVslider13 = FAUSTFLOAT(-10.);
		fVslider14 = FAUSTFLOAT(-10.);
		fVslider15 = FAUSTFLOAT(-10.);
		fVslider16 = FAUSTFLOAT(-10.);
		fVslider17 = FAUSTFLOAT(-10.);
		fVslider18 = FAUSTFLOAT(-10.);
		fVslider19 = FAUSTFLOAT(-10.);
		fVslider20 = FAUSTFLOAT(-10.);
		fVslider21 = FAUSTFLOAT(-10.);
		fVslider22 = FAUSTFLOAT(-10.);
		fVslider23 = FAUSTFLOAT(-10.);
		fVslider24 = FAUSTFLOAT(-10.);
		fVslider25 = FAUSTFLOAT(-10.);
		fVslider26 = FAUSTFLOAT(-10.);
		fVslider27 = FAUSTFLOAT(-10.);
		fVslider28 = FAUSTFLOAT(-10.);
		fVslider29 = FAUSTFLOAT(-10.);
		fVslider30 = FAUSTFLOAT(-10.);
		fVslider31 = FAUSTFLOAT(-10.);
		fVslider32 = FAUSTFLOAT(-10.);
		fVslider33 = FAUSTFLOAT(-10.);
		fVslider34 = FAUSTFLOAT(-10.);
		fVslider35 = FAUSTFLOAT(-10.);
		fVslider36 = FAUSTFLOAT(-10.);
		fVslider37 = FAUSTFLOAT(-10.);
		fVslider38 = FAUSTFLOAT(-10.);
		fVslider39 = FAUSTFLOAT(-10.);
		fVslider40 = FAUSTFLOAT(-10.);
		fVslider41 = FAUSTFLOAT(-10.);
		fVslider42 = FAUSTFLOAT(-10.);
		fVslider43 = FAUSTFLOAT(-10.);
		fVslider44 = FAUSTFLOAT(-10.);
		fVslider45 = FAUSTFLOAT(-10.);
		fVslider46 = FAUSTFLOAT(-10.);
		fVslider47 = FAUSTFLOAT(-10.);
		fVslider48 = FAUSTFLOAT(-10.);
		fVslider49 = FAUSTFLOAT(-10.);
		fVslider50 = FAUSTFLOAT(-10.);
		fVslider51 = FAUSTFLOAT(-10.);
		fVslider52 = FAUSTFLOAT(-10.);
		fVslider53 = FAUSTFLOAT(-10.);
		fVslider54 = FAUSTFLOAT(-10.);
		fVslider55 = FAUSTFLOAT(-10.);
		fVslider56 = FAUSTFLOAT(-10.);
		fVslider57 = FAUSTFLOAT(-10.);
		fVslider58 = FAUSTFLOAT(-10.);
		fVslider59 = FAUSTFLOAT(-10.);
		fVslider60 = FAUSTFLOAT(-10.);
		fVslider61 = FAUSTFLOAT(-10.);
		fVslider62 = FAUSTFLOAT(-10.);
		fVslider63 = FAUSTFLOAT(-10.);
		
	}
	
	virtual void init(int samplingFreq) {
		classInit(samplingFreq);
		instanceInit(samplingFreq);
	}
	
	virtual void buildUserInterface(UI* interface) {
		interface->openTabBox("Matrix 8 x 8");
		interface->openHorizontalBox("Output 0");
		interface->addVerticalSlider("Input 0", &fVslider0, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 1", &fVslider1, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 2", &fVslider2, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 3", &fVslider3, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 4", &fVslider4, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 5", &fVslider5, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 6", &fVslider6, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 7", &fVslider7, -10.f, -96.f, 4.f, 0.1f);
		interface->closeBox();
		interface->openHorizontalBox("Output 1");
		interface->addVerticalSlider("Input 0", &fVslider8, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 1", &fVslider9, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 2", &fVslider10, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 3", &fVslider11, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 4", &fVslider12, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 5", &fVslider13, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 6", &fVslider14, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 7", &fVslider15, -10.f, -96.f, 4.f, 0.1f);
		interface->closeBox();
		interface->openHorizontalBox("Output 2");
		interface->addVerticalSlider("Input 0", &fVslider16, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 1", &fVslider17, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 2", &fVslider18, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 3", &fVslider19, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 4", &fVslider20, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 5", &fVslider21, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 6", &fVslider22, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 7", &fVslider23, -10.f, -96.f, 4.f, 0.1f);
		interface->closeBox();
		interface->openHorizontalBox("Output 3");
		interface->addVerticalSlider("Input 0", &fVslider24, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 1", &fVslider25, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 2", &fVslider26, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 3", &fVslider27, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 4", &fVslider28, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 5", &fVslider29, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 6", &fVslider30, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 7", &fVslider31, -10.f, -96.f, 4.f, 0.1f);
		interface->closeBox();
		interface->openHorizontalBox("Output 4");
		interface->addVerticalSlider("Input 0", &fVslider32, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 1", &fVslider33, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 2", &fVslider34, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 3", &fVslider35, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 4", &fVslider36, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 5", &fVslider37, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 6", &fVslider38, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 7", &fVslider39, -10.f, -96.f, 4.f, 0.1f);
		interface->closeBox();
		interface->openHorizontalBox("Output 5");
		interface->addVerticalSlider("Input 0", &fVslider40, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 1", &fVslider41, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 2", &fVslider42, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 3", &fVslider43, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 4", &fVslider44, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 5", &fVslider45, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 6", &fVslider46, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 7", &fVslider47, -10.f, -96.f, 4.f, 0.1f);
		interface->closeBox();
		interface->openHorizontalBox("Output 6");
		interface->addVerticalSlider("Input 0", &fVslider48, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 1", &fVslider49, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 2", &fVslider50, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 3", &fVslider51, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 4", &fVslider52, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 5", &fVslider53, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 6", &fVslider54, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 7", &fVslider55, -10.f, -96.f, 4.f, 0.1f);
		interface->closeBox();
		interface->openHorizontalBox("Output 7");
		interface->addVerticalSlider("Input 0", &fVslider56, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 1", &fVslider57, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 2", &fVslider58, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 3", &fVslider59, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 4", &fVslider60, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 5", &fVslider61, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 6", &fVslider62, -10.f, -96.f, 4.f, 0.1f);
		interface->addVerticalSlider("Input 7", &fVslider63, -10.f, -96.f, 4.f, 0.1f);
		interface->closeBox();
		interface->closeBox();
		
	}
	
	virtual void compute(int count, FAUSTFLOAT** inputs, FAUSTFLOAT** outputs) {
		FAUSTFLOAT* input0 = inputs[0];
		FAUSTFLOAT* input1 = inputs[1];
		FAUSTFLOAT* input2 = inputs[2];
		FAUSTFLOAT* input3 = inputs[3];
		FAUSTFLOAT* input4 = inputs[4];
		FAUSTFLOAT* input5 = inputs[5];
		FAUSTFLOAT* input6 = inputs[6];
		FAUSTFLOAT* input7 = inputs[7];
		FAUSTFLOAT* output0 = outputs[0];
		FAUSTFLOAT* output1 = outputs[1];
		FAUSTFLOAT* output2 = outputs[2];
		FAUSTFLOAT* output3 = outputs[3];
		FAUSTFLOAT* output4 = outputs[4];
		FAUSTFLOAT* output5 = outputs[5];
		FAUSTFLOAT* output6 = outputs[6];
		FAUSTFLOAT* output7 = outputs[7];
		float fSlow0 = powf(10.f, float((0.05f * float(fVslider0))));
		float fSlow1 = powf(10.f, float((0.05f * float(fVslider1))));
		float fSlow2 = powf(10.f, float((0.05f * float(fVslider2))));
		float fSlow3 = powf(10.f, float((0.05f * float(fVslider3))));
		float fSlow4 = powf(10.f, float((0.05f * float(fVslider4))));
		float fSlow5 = powf(10.f, float((0.05f * float(fVslider5))));
		float fSlow6 = powf(10.f, float((0.05f * float(fVslider6))));
		float fSlow7 = powf(10.f, float((0.05f * float(fVslider7))));
		float fSlow8 = powf(10.f, float((0.05f * float(fVslider8))));
		float fSlow9 = powf(10.f, float((0.05f * float(fVslider9))));
		float fSlow10 = powf(10.f, float((0.05f * float(fVslider10))));
		float fSlow11 = powf(10.f, float((0.05f * float(fVslider11))));
		float fSlow12 = powf(10.f, float((0.05f * float(fVslider12))));
		float fSlow13 = powf(10.f, float((0.05f * float(fVslider13))));
		float fSlow14 = powf(10.f, float((0.05f * float(fVslider14))));
		float fSlow15 = powf(10.f, float((0.05f * float(fVslider15))));
		float fSlow16 = powf(10.f, float((0.05f * float(fVslider16))));
		float fSlow17 = powf(10.f, float((0.05f * float(fVslider17))));
		float fSlow18 = powf(10.f, float((0.05f * float(fVslider18))));
		float fSlow19 = powf(10.f, float((0.05f * float(fVslider19))));
		float fSlow20 = powf(10.f, float((0.05f * float(fVslider20))));
		float fSlow21 = powf(10.f, float((0.05f * float(fVslider21))));
		float fSlow22 = powf(10.f, float((0.05f * float(fVslider22))));
		float fSlow23 = powf(10.f, float((0.05f * float(fVslider23))));
		float fSlow24 = powf(10.f, float((0.05f * float(fVslider24))));
		float fSlow25 = powf(10.f, float((0.05f * float(fVslider25))));
		float fSlow26 = powf(10.f, float((0.05f * float(fVslider26))));
		float fSlow27 = powf(10.f, float((0.05f * float(fVslider27))));
		float fSlow28 = powf(10.f, float((0.05f * float(fVslider28))));
		float fSlow29 = powf(10.f, float((0.05f * float(fVslider29))));
		float fSlow30 = powf(10.f, float((0.05f * float(fVslider30))));
		float fSlow31 = powf(10.f, float((0.05f * float(fVslider31))));
		float fSlow32 = powf(10.f, float((0.05f * float(fVslider32))));
		float fSlow33 = powf(10.f, float((0.05f * float(fVslider33))));
		float fSlow34 = powf(10.f, float((0.05f * float(fVslider34))));
		float fSlow35 = powf(10.f, float((0.05f * float(fVslider35))));
		float fSlow36 = powf(10.f, float((0.05f * float(fVslider36))));
		float fSlow37 = powf(10.f, float((0.05f * float(fVslider37))));
		float fSlow38 = powf(10.f, float((0.05f * float(fVslider38))));
		float fSlow39 = powf(10.f, float((0.05f * float(fVslider39))));
		float fSlow40 = powf(10.f, float((0.05f * float(fVslider40))));
		float fSlow41 = powf(10.f, float((0.05f * float(fVslider41))));
		float fSlow42 = powf(10.f, float((0.05f * float(fVslider42))));
		float fSlow43 = powf(10.f, float((0.05f * float(fVslider43))));
		float fSlow44 = powf(10.f, float((0.05f * float(fVslider44))));
		float fSlow45 = powf(10.f, float((0.05f * float(fVslider45))));
		float fSlow46 = powf(10.f, float((0.05f * float(fVslider46))));
		float fSlow47 = powf(10.f, float((0.05f * float(fVslider47))));
		float fSlow48 = powf(10.f, float((0.05f * float(fVslider48))));
		float fSlow49 = powf(10.f, float((0.05f * float(fVslider49))));
		float fSlow50 = powf(10.f, float((0.05f * float(fVslider50))));
		float fSlow51 = powf(10.f, float((0.05f * float(fVslider51))));
		float fSlow52 = powf(10.f, float((0.05f * float(fVslider52))));
		float fSlow53 = powf(10.f, float((0.05f * float(fVslider53))));
		float fSlow54 = powf(10.f, float((0.05f * float(fVslider54))));
		float fSlow55 = powf(10.f, float((0.05f * float(fVslider55))));
		float fSlow56 = powf(10.f, float((0.05f * float(fVslider56))));
		float fSlow57 = powf(10.f, float((0.05f * float(fVslider57))));
		float fSlow58 = powf(10.f, float((0.05f * float(fVslider58))));
		float fSlow59 = powf(10.f, float((0.05f * float(fVslider59))));
		float fSlow60 = powf(10.f, float((0.05f * float(fVslider60))));
		float fSlow61 = powf(10.f, float((0.05f * float(fVslider61))));
		float fSlow62 = powf(10.f, float((0.05f * float(fVslider62))));
		float fSlow63 = powf(10.f, float((0.05f * float(fVslider63))));
		for (int i = 0; (i < count); i = (i + 1)) {
			float fTemp0 = float(input0[i]);
			float fTemp1 = float(input1[i]);
			float fTemp2 = float(input2[i]);
			float fTemp3 = float(input3[i]);
			float fTemp4 = float(input4[i]);
			float fTemp5 = float(input5[i]);
			float fTemp6 = float(input6[i]);
			float fTemp7 = float(input7[i]);
			output0[i] = FAUSTFLOAT(float((float((float((float((float((float((float((float((fSlow0 * fTemp0)) + float((fSlow1 * fTemp1)))) + float((fSlow2 * fTemp2)))) + float((fSlow3 * fTemp3)))) + float((fSlow4 * fTemp4)))) + float((fSlow5 * fTemp5)))) + float((fSlow6 * fTemp6)))) + float((fSlow7 * fTemp7)))));
			output1[i] = FAUSTFLOAT(float((float((float((float((float((float((float((float((fSlow8 * fTemp0)) + float((fSlow9 * fTemp1)))) + float((fSlow10 * fTemp2)))) + float((fSlow11 * fTemp3)))) + float((fSlow12 * fTemp4)))) + float((fSlow13 * fTemp5)))) + float((fSlow14 * fTemp6)))) + float((fSlow15 * fTemp7)))));
			output2[i] = FAUSTFLOAT(float((float((float((float((float((float((float((float((fSlow16 * fTemp0)) + float((fSlow17 * fTemp1)))) + float((fSlow18 * fTemp2)))) + float((fSlow19 * fTemp3)))) + float((fSlow20 * fTemp4)))) + float((fSlow21 * fTemp5)))) + float((fSlow22 * fTemp6)))) + float((fSlow23 * fTemp7)))));
			output3[i] = FAUSTFLOAT(float((float((float((float((float((float((float((float((fSlow24 * fTemp0)) + float((fSlow25 * fTemp1)))) + float((fSlow26 * fTemp2)))) + float((fSlow27 * fTemp3)))) + float((fSlow28 * fTemp4)))) + float((fSlow29 * fTemp5)))) + float((fSlow30 * fTemp6)))) + float((fSlow31 * fTemp7)))));
			output4[i] = FAUSTFLOAT(float((float((float((float((float((float((float((float((fSlow32 * fTemp0)) + float((fSlow33 * fTemp1)))) + float((fSlow34 * fTemp2)))) + float((fSlow35 * fTemp3)))) + float((fSlow36 * fTemp4)))) + float((fSlow37 * fTemp5)))) + float((fSlow38 * fTemp6)))) + float((fSlow39 * fTemp7)))));
			output5[i] = FAUSTFLOAT(float((float((float((float((float((float((float((float((fSlow40 * fTemp0)) + float((fSlow41 * fTemp1)))) + float((fSlow42 * fTemp2)))) + float((fSlow43 * fTemp3)))) + float((fSlow44 * fTemp4)))) + float((fSlow45 * fTemp5)))) + float((fSlow46 * fTemp6)))) + float((fSlow47 * fTemp7)))));
			output6[i] = FAUSTFLOAT(float((float((float((float((float((float((float((float((fSlow48 * fTemp0)) + float((fSlow49 * fTemp1)))) + float((fSlow50 * fTemp2)))) + float((fSlow51 * fTemp3)))) + float((fSlow52 * fTemp4)))) + float((fSlow53 * fTemp5)))) + float((fSlow54 * fTemp6)))) + float((fSlow55 * fTemp7)))));
			output7[i] = FAUSTFLOAT(float((float((float((float((float((float((float((float((fSlow56 * fTemp0)) + float((fSlow57 * fTemp1)))) + float((fSlow58 * fTemp2)))) + float((fSlow59 * fTemp3)))) + float((fSlow60 * fTemp4)))) + float((fSlow61 * fTemp5)))) + float((fSlow62 * fTemp6)))) + float((fSlow63 * fTemp7)))));
			
		}
		
	}

	
};


#include <stdio.h>
#include <string>
#include "m_pd.h"

#define sym(name) xsym(name)
#define xsym(name) #name
#define faust_setup(name) xfaust_setup(name)
#define xfaust_setup(name) name ## _tilde_setup(void)

// time for "active" toggle xfades in secs
#define XFADE_TIME 0.1f

static t_class *faust_class;

struct t_faust {
  t_object x_obj;
#ifdef __MINGW32__
  /* This seems to be necessary as some as yet undetermined Pd routine seems
     to write past the end of x_obj on Windows. */
  int fence; /* dummy field (not used) */
#endif
  mydsp *dsp;
  PdUI *ui;
  std::string *label;
  int active, xfade, n_xfade, rate, n_in, n_out;
  t_sample **inputs, **outputs, **buf;
  t_outlet *out;
  t_sample f;
};

static t_symbol *s_button, *s_checkbox, *s_vslider, *s_hslider, *s_nentry,
  *s_vbargraph, *s_hbargraph;

static inline void zero_samples(int k, int n, t_sample **out)
{
  for (int i = 0; i < k; i++)
#ifdef __STDC_IEC_559__
    /* IEC 559 a.k.a. IEEE 754 floats can be initialized faster like this */
    memset(out[i], 0, n*sizeof(t_sample));
#else
    for (int j = 0; j < n; j++)
      out[i][j] = 0.0f;
#endif
}

static inline void copy_samples(int k, int n, t_sample **out, t_sample **in)
{
  for (int i = 0; i < k; i++)
    memcpy(out[i], in[i], n*sizeof(t_sample));
}

static t_int *faust_perform(t_int *w)
{
  t_faust *x = (t_faust *)(w[1]);
  int n = (int)(w[2]);
  if (!x->dsp || !x->buf) return (w+3);
  AVOIDDENORMALS;
  if (x->xfade > 0) {
    float d = 1.0f/x->n_xfade, f = (x->xfade--)*d;
    d = d/n;
    x->dsp->compute(n, x->inputs, x->buf);
    if (x->active)
      if (x->n_in == x->n_out)
	/* xfade inputs -> buf */
	for (int j = 0; j < n; j++, f -= d)
	  for (int i = 0; i < x->n_out; i++)
	    x->outputs[i][j] = f*x->inputs[i][j]+(1.0f-f)*x->buf[i][j];
      else
	/* xfade 0 -> buf */
	for (int j = 0; j < n; j++, f -= d)
	  for (int i = 0; i < x->n_out; i++)
	    x->outputs[i][j] = (1.0f-f)*x->buf[i][j];
    else
      if (x->n_in == x->n_out)
	/* xfade buf -> inputs */
	for (int j = 0; j < n; j++, f -= d)
	  for (int i = 0; i < x->n_out; i++)
	    x->outputs[i][j] = f*x->buf[i][j]+(1.0f-f)*x->inputs[i][j];
      else
	/* xfade buf -> 0 */
	for (int j = 0; j < n; j++, f -= d)
	  for (int i = 0; i < x->n_out; i++)
	    x->outputs[i][j] = f*x->buf[i][j];
  } else if (x->active) {
    x->dsp->compute(n, x->inputs, x->buf);
    copy_samples(x->n_out, n, x->outputs, x->buf);
  } else if (x->n_in == x->n_out) {
    copy_samples(x->n_out, n, x->buf, x->inputs);
    copy_samples(x->n_out, n, x->outputs, x->buf);
  } else
    zero_samples(x->n_out, n, x->outputs);
  return (w+3);
}

static void faust_dsp(t_faust *x, t_signal **sp)
{
  int n = sp[0]->s_n, sr = (int)sp[0]->s_sr;
  if (x->rate <= 0) {
    /* default sample rate is whatever Pd tells us */
    PdUI *ui = x->ui;
    float *z = NULL;
    if (ui->nelems > 0 &&
	(z = (float*)malloc(ui->nelems*sizeof(float)))) {
      /* save the current control values */
      for (int i = 0; i < ui->nelems; i++)
	if (ui->elems[i].zone)
	  z[i] = *ui->elems[i].zone;
    }
    /* set the proper sample rate; this requires reinitializing the dsp */
    x->rate = sr;
    x->dsp->init(sr);
    if (z) {
      /* restore previous control values */
      for (int i = 0; i < ui->nelems; i++)
	if (ui->elems[i].zone)
	  *ui->elems[i].zone = z[i];
      free(z);
    }
  }
  if (n > 0)
    x->n_xfade = (int)(x->rate*XFADE_TIME/n);
  dsp_add(faust_perform, 2, x, n);
  for (int i = 0; i < x->n_in; i++)
    x->inputs[i] = sp[i+1]->s_vec;
  for (int i = 0; i < x->n_out; i++)
    x->outputs[i] = sp[x->n_in+i+1]->s_vec;
  if (x->buf != NULL)
    for (int i = 0; i < x->n_out; i++) {
      x->buf[i] = (t_sample*)malloc(n*sizeof(t_sample));
      if (x->buf[i] == NULL) {
	for (int j = 0; j < i; j++)
	  free(x->buf[j]);
	free(x->buf);
	x->buf = NULL;
	break;
      }
    }
}

static int pathcmp(const char *s, const char *t)
{
  int n = strlen(s), m = strlen(t);
  if (n == 0 || m == 0)
    return 0;
  else if (t[0] == '/')
    return strcmp(s, t);
  else if (n <= m || s[n-m-1] != '/')
    return strcmp(s+1, t);
  else
    return strcmp(s+n-m, t);
}

static void faust_any(t_faust *x, t_symbol *s, int argc, t_atom *argv)
{
  if (!x->dsp) return;
  PdUI *ui = x->ui;
  if (s == &s_bang) {
    for (int i = 0; i < ui->nelems; i++)
      if (ui->elems[i].label && ui->elems[i].zone) {
	t_atom args[6];
	t_symbol *_s;
	switch (ui->elems[i].type) {
	case UI_BUTTON:
	  _s = s_button;
	  break;
	case UI_CHECK_BUTTON:
	  _s = s_checkbox;
	  break;
	case UI_V_SLIDER:
	  _s = s_vslider;
	  break;
	case UI_H_SLIDER:
	  _s = s_hslider;
	  break;
	case UI_NUM_ENTRY:
	  _s = s_nentry;
	  break;
	case UI_V_BARGRAPH:
	  _s = s_vbargraph;
	  break;
	case UI_H_BARGRAPH:
	  _s = s_hbargraph;
	  break;
	default:
	  continue;
	}
	SETSYMBOL(&args[0], gensym(ui->elems[i].label));
	SETFLOAT(&args[1], *ui->elems[i].zone);
	SETFLOAT(&args[2], ui->elems[i].init);
	SETFLOAT(&args[3], ui->elems[i].min);
	SETFLOAT(&args[4], ui->elems[i].max);
	SETFLOAT(&args[5], ui->elems[i].step);
	outlet_anything(x->out, _s, 6, args);
      }
  } else {
    const char *label = s->s_name;
    int count = 0;
    for (int i = 0; i < ui->nelems; i++)
      if (ui->elems[i].label &&
	  pathcmp(ui->elems[i].label, label) == 0) {
	if (argc == 0) {
	  if (ui->elems[i].zone) {
	    t_atom arg;
	    SETFLOAT(&arg, *ui->elems[i].zone);
	    outlet_anything(x->out, gensym(ui->elems[i].label), 1, &arg);
	  }
	  ++count;
	} else if (argc == 1 &&
		   (argv[0].a_type == A_FLOAT ||
		    argv[0].a_type == A_DEFFLOAT) &&
		   ui->elems[i].zone) {
	  float f = atom_getfloat(argv);
	  *ui->elems[i].zone = f;
	  ++count;
	} else
	  pd_error(x, "[faust] %s: bad control argument: %s",
		   x->label->c_str(), label);
      }
    if (count == 0 && strcmp(label, "active") == 0) {
      if (argc == 0) {
	t_atom arg;
	SETFLOAT(&arg, (float)x->active);
	outlet_anything(x->out, gensym((char*)"active"), 1, &arg);
      } else if (argc == 1 &&
		 (argv[0].a_type == A_FLOAT ||
		  argv[0].a_type == A_DEFFLOAT)) {
	float f = atom_getfloat(argv);
	x->active = (int)f;
	x->xfade = x->n_xfade;
      }
    }
  }
}

static void faust_free(t_faust *x)
{
  if (x->label) delete x->label;
  if (x->dsp) delete x->dsp;
  if (x->ui) delete x->ui;
  if (x->inputs) free(x->inputs);
  if (x->outputs) free(x->outputs);
  if (x->buf) {
    for (int i = 0; i < x->n_out; i++)
      if (x->buf[i]) free(x->buf[i]);
    free(x->buf);
  }
}

static void *faust_new(t_symbol *s, int argc, t_atom *argv)
{
  t_faust *x = (t_faust*)pd_new(faust_class);
  int sr = -1;
  t_symbol *id = NULL;
  x->active = 1;
  for (int i = 0; i < argc; i++)
    if (argv[i].a_type == A_FLOAT || argv[i].a_type == A_DEFFLOAT)
      sr = (int)argv[i].a_w.w_float;
    else if (argv[i].a_type == A_SYMBOL || argv[i].a_type == A_DEFSYMBOL)
      id = argv[i].a_w.w_symbol;
  x->rate = sr;
  if (sr <= 0) sr = 44100;
  x->xfade = 0; x->n_xfade = (int)(sr*XFADE_TIME/64);
  x->inputs = x->outputs = x->buf = NULL;
    x->label = new std::string(sym(mydsp) "~");
  x->dsp = new mydsp();
  x->ui = new PdUI(sym(mydsp), id?id->s_name:NULL);
  if (!x->dsp || !x->ui || !x->label) goto error;
  if (id) {
    *x->label += " ";
    *x->label += id->s_name;
  }
  x->n_in = x->dsp->getNumInputs();
  x->n_out = x->dsp->getNumOutputs();
  if (x->n_in > 0)
    x->inputs = (t_sample**)malloc(x->n_in*sizeof(t_sample*));
  if (x->n_out > 0) {
    x->outputs = (t_sample**)malloc(x->n_out*sizeof(t_sample*));
    x->buf = (t_sample**)malloc(x->n_out*sizeof(t_sample*));
  }
  if ((x->n_in > 0 && x->inputs == NULL) ||
      (x->n_out > 0 && (x->outputs == NULL || x->buf == NULL)))
    goto error;
  for (int i = 0; i < x->n_out; i++)
    x->buf[i] = NULL;
  x->dsp->init(sr);
  x->dsp->buildUserInterface(x->ui);
  for (int i = 0; i < x->n_in; i++)
    inlet_new(&x->x_obj, &x->x_obj.ob_pd, &s_signal, &s_signal);
  x->out = outlet_new(&x->x_obj, 0);
  for (int i = 0; i < x->n_out; i++)
    outlet_new(&x->x_obj, &s_signal);
  return (void *)x;
 error:
  faust_free(x);
  x->dsp = NULL; x->ui = NULL;
  x->inputs = x->outputs = x->buf = NULL;
  return (void *)x;
}

extern "C" void faust_setup(mydsp)
{
  t_symbol *s = gensym(sym(mydsp) "~");
  faust_class =
    class_new(s, (t_newmethod)faust_new, (t_method)faust_free,
	      sizeof(t_faust), CLASS_DEFAULT,
	      A_GIMME, A_NULL);
  class_addmethod(faust_class, (t_method)faust_dsp, gensym((char*)"dsp"), A_NULL);
  class_addanything(faust_class, faust_any);
  class_addmethod(faust_class, nullfn, &s_signal, A_NULL);
  s_button = gensym((char*)"button");
  s_checkbox = gensym((char*)"checkbox");
  s_vslider = gensym((char*)"vslider");
  s_hslider = gensym((char*)"hslider");
  s_nentry = gensym((char*)"nentry");
  s_vbargraph = gensym((char*)"vbargraph");
  s_hbargraph = gensym((char*)"hbargraph");
  /* give some indication that we're loaded and ready to go */
  mydsp dsp = mydsp();
  post("[faust] %s: %d inputs, %d outputs", sym(mydsp) "~",
       dsp.getNumInputs(), dsp.getNumOutputs());
}

#endif
