//-----------------------------------------------------
// author: "Grame"
// copyright: "(c)GRAME 2006"
// license: "BSD"
// name: "karplus32"
// version: "1.0"
//
// Code generated with Faust 2.0.a30 (http://faust.grame.fr)
//-----------------------------------------------------

#ifndef  __mydsp_H__
#define  __mydsp_H__
/************************************************************************
 ************************************************************************
    FAUST Architecture File
	Copyright (C) 2006-2011 Albert Graef <Dr.Graef@t-online.de>
    ---------------------------------------------------------------------
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as 
	published by the Free Software Foundation; either version 2.1 of the 
	License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
 	License along with the GNU C Library; if not, write to the Free
  	Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  	02111-1307 USA. 
 ************************************************************************
 ************************************************************************/

/* Pd architecture file, written by Albert Graef <Dr.Graef@t-online.de>.
   This was derived from minimal.cpp included in the Faust distribution.
   Please note that this is to be compiled as a shared library, which is
   then loaded dynamically by Pd as an external. */

#include <stdlib.h>
#include <math.h>
#include <string>

#include "faust/misc.h"
#include "faust/gui/UI.h"
#include "faust/gui/meta.h"
#include "faust/audio/dsp.h"

//using namespace std;

/******************************************************************************
*******************************************************************************

							       VECTOR INTRINSICS

*******************************************************************************
*******************************************************************************/


/***************************************************************************
   Pd UI interface
 ***************************************************************************/

enum ui_elem_type_t {
  UI_BUTTON, UI_CHECK_BUTTON,
  UI_V_SLIDER, UI_H_SLIDER, UI_NUM_ENTRY,
  UI_V_BARGRAPH, UI_H_BARGRAPH,
  UI_END_GROUP, UI_V_GROUP, UI_H_GROUP, UI_T_GROUP
};

struct ui_elem_t {
  ui_elem_type_t type;
  char *label;
  float *zone;
  float init, min, max, step;
};

class PdUI : public UI
{
public:
  const char *name;
  int nelems, level;
  ui_elem_t *elems;
		
  PdUI();
  PdUI(const char *nm, const char *s);
  virtual ~PdUI();

protected:
  std::string path;
  void add_elem(ui_elem_type_t type, const char *label = NULL);
  void add_elem(ui_elem_type_t type, const char *label, float *zone);
  void add_elem(ui_elem_type_t type, const char *label, float *zone,
		float init, float min, float max, float step);
  void add_elem(ui_elem_type_t type, const char *label, float *zone,
		float min, float max);

public:
  virtual void addButton(const char* label, float* zone);
  virtual void addCheckButton(const char* label, float* zone);
  virtual void addVerticalSlider(const char* label, float* zone, float init, float min, float max, float step);
  virtual void addHorizontalSlider(const char* label, float* zone, float init, float min, float max, float step);
  virtual void addNumEntry(const char* label, float* zone, float init, float min, float max, float step);

  virtual void addHorizontalBargraph(const char* label, float* zone, float min, float max);
  virtual void addVerticalBargraph(const char* label, float* zone, float min, float max);
  
  virtual void openTabBox(const char* label);
  virtual void openHorizontalBox(const char* label);
  virtual void openVerticalBox(const char* label);
  virtual void closeBox();
	
  virtual void run();
};

static std::string mangle(const char *name, int level, const char *s)
{
  const char *s0 = s;
  std::string t = "";
  if (!s) return t;
  // Get rid of bogus "0x00" labels in recent Faust revisions. Also, for
  // backward compatibility with old Faust versions, make sure that default
  // toplevel groups and explicit toplevel groups with an empty label are
  // treated alike (these both return "0x00" labels in the latest Faust, but
  // would be treated inconsistently in earlier versions).
  if (!*s || strcmp(s, "0x00") == 0) {
    if (level == 0)
      // toplevel group with empty label, map to dsp name
      s = name;
    else
      // empty label
      s = "";
  }
  while (*s)
    if (isalnum(*s))
      t += *(s++);
    else {
      const char *s1 = s;
      while (*s && !isalnum(*s)) ++s;
      if (s1 != s0 && *s) t += "-";
    }
  return t;
}

static std::string normpath(std::string path)
{
  path = std::string("/")+path;
  int pos = path.find("//");
  while (pos >= 0) {
    path.erase(pos, 1);
    pos = path.find("//");
  }
  size_t len = path.length();
  if (len > 1 && path[len-1] == '/')
    path.erase(len-1, 1);
  return path;
}

static std::string pathcat(std::string path, std::string label)
{
  if (path.empty())
    return normpath(label);
  else if (label.empty())
    return normpath(path);
  else
    return normpath(path+"/"+label);
}

PdUI::PdUI()
{
  nelems = level = 0;
  elems = NULL;
  name = "";
  path = "";
}

PdUI::PdUI(const char *nm, const char *s)
{
  nelems = level = 0;
  elems = NULL;
  name = nm?nm:"";
  path = s?s:"";
}

PdUI::~PdUI()
{
  if (elems) {
    for (int i = 0; i < nelems; i++)
      if (elems[i].label)
	free(elems[i].label);
    free(elems);
  }
}

inline void PdUI::add_elem(ui_elem_type_t type, const char *label)
{
  ui_elem_t *elems1 = (ui_elem_t*)realloc(elems, (nelems+1)*sizeof(ui_elem_t));
  if (elems1)
    elems = elems1;
  else
    return;
  std::string s = pathcat(path, mangle(name, level, label));
  elems[nelems].type = type;
  elems[nelems].label = strdup(s.c_str());
  elems[nelems].zone = NULL;
  elems[nelems].init = 0.0;
  elems[nelems].min = 0.0;
  elems[nelems].max = 0.0;
  elems[nelems].step = 0.0;
  nelems++;
}

inline void PdUI::add_elem(ui_elem_type_t type, const char *label, float *zone)
{
  ui_elem_t *elems1 = (ui_elem_t*)realloc(elems, (nelems+1)*sizeof(ui_elem_t));
  if (elems1)
    elems = elems1;
  else
    return;
  std::string s = pathcat(path, mangle(name, level, label));
  elems[nelems].type = type;
  elems[nelems].label = strdup(s.c_str());
  elems[nelems].zone = zone;
  elems[nelems].init = 0.0;
  elems[nelems].min = 0.0;
  elems[nelems].max = 1.0;
  elems[nelems].step = 1.0;
  nelems++;
}

inline void PdUI::add_elem(ui_elem_type_t type, const char *label, float *zone,
			  float init, float min, float max, float step)
{
  ui_elem_t *elems1 = (ui_elem_t*)realloc(elems, (nelems+1)*sizeof(ui_elem_t));
  if (elems1)
    elems = elems1;
  else
    return;
  std::string s = pathcat(path, mangle(name, level, label));
  elems[nelems].type = type;
  elems[nelems].label = strdup(s.c_str());
  elems[nelems].zone = zone;
  elems[nelems].init = init;
  elems[nelems].min = min;
  elems[nelems].max = max;
  elems[nelems].step = step;
  nelems++;
}

inline void PdUI::add_elem(ui_elem_type_t type, const char *label, float *zone,
			  float min, float max)
{
  ui_elem_t *elems1 = (ui_elem_t*)realloc(elems, (nelems+1)*sizeof(ui_elem_t));
  if (elems1)
    elems = elems1;
  else
    return;
  std::string s = pathcat(path, mangle(name, level, label));
  elems[nelems].type = type;
  elems[nelems].label = strdup(s.c_str());
  elems[nelems].zone = zone;
  elems[nelems].init = 0.0;
  elems[nelems].min = min;
  elems[nelems].max = max;
  elems[nelems].step = 0.0;
  nelems++;
}

void PdUI::addButton(const char* label, float* zone)
{ add_elem(UI_BUTTON, label, zone); }
void PdUI::addCheckButton(const char* label, float* zone)
{ add_elem(UI_CHECK_BUTTON, label, zone); }
void PdUI::addVerticalSlider(const char* label, float* zone, float init, float min, float max, float step)
{ add_elem(UI_V_SLIDER, label, zone, init, min, max, step); }
void PdUI::addHorizontalSlider(const char* label, float* zone, float init, float min, float max, float step)
{ add_elem(UI_H_SLIDER, label, zone, init, min, max, step); }
void PdUI::addNumEntry(const char* label, float* zone, float init, float min, float max, float step)
{ add_elem(UI_NUM_ENTRY, label, zone, init, min, max, step); }

void PdUI::addHorizontalBargraph(const char* label, float* zone, float min, float max)
{ add_elem(UI_H_BARGRAPH, label, zone, min, max); }
void PdUI::addVerticalBargraph(const char* label, float* zone, float min, float max)
{ add_elem(UI_V_BARGRAPH, label, zone, min, max); }

void PdUI::openTabBox(const char* label)
{
  if (!path.empty()) path += "/";
  path += mangle(name, level, label);
  level++;
}
void PdUI::openHorizontalBox(const char* label)
{
  if (!path.empty()) path += "/";
  path += mangle(name, level, label);
  level++;
}
void PdUI::openVerticalBox(const char* label)
{
  if (!path.empty()) path += "/";
  path += mangle(name, level, label);
  level++;
}
void PdUI::closeBox()
{
  int pos = path.rfind("/");
  if (pos < 0) pos = 0;
  path.erase(pos);
  level--;
}

void PdUI::run() {}

/******************************************************************************
*******************************************************************************

			    FAUST DSP

*******************************************************************************
*******************************************************************************/

//----------------------------------------------------------------------------
//  FAUST generated signal processor
//----------------------------------------------------------------------------
		
#ifndef FAUSTFLOAT
#define FAUSTFLOAT float
#endif  



#ifndef FAUSTCLASS 
#define FAUSTCLASS mydsp
#endif

class mydsp : public dsp {
	
  private:
	
	float fVec3[4096];
	float fVec4[4096];
	float fVec5[4096];
	float fVec6[4096];
	float fVec7[4096];
	float fVec8[4096];
	float fVec9[4096];
	float fVec10[4096];
	float fVec11[4096];
	float fVec12[4096];
	float fVec13[4096];
	float fVec14[4096];
	float fVec15[4096];
	float fVec16[4096];
	float fVec19[4096];
	float fVec20[4096];
	float fVec21[4096];
	float fVec22[4096];
	float fVec23[4096];
	float fVec24[4096];
	float fVec25[4096];
	float fVec26[4096];
	float fVec27[4096];
	float fVec28[4096];
	float fVec29[4096];
	float fVec30[4096];
	float fVec31[4096];
	float fVec32[4096];
	float fVec2[2048];
	float fVec18[2048];
	float fVec17[1024];
	float fVec1[512];
	float fRec0[3];
	float fRec3[3];
	float fRec4[3];
	float fRec5[3];
	float fRec6[3];
	float fRec7[3];
	float fRec8[3];
	float fRec9[3];
	float fRec10[3];
	float fRec11[3];
	float fRec12[3];
	float fRec13[3];
	float fRec14[3];
	float fRec15[3];
	float fRec16[3];
	float fRec17[3];
	float fRec18[3];
	float fRec19[3];
	float fRec20[3];
	float fRec21[3];
	float fRec22[3];
	float fRec23[3];
	float fRec24[3];
	float fRec25[3];
	float fRec26[3];
	float fRec27[3];
	float fRec28[3];
	float fRec29[3];
	float fRec30[3];
	float fRec31[3];
	float fRec32[3];
	float fRec33[3];
	int iRec1[2];
	float fVec0[2];
	float fRec2[2];
	FAUSTFLOAT fHslider0;
	FAUSTFLOAT fHslider1;
	FAUSTFLOAT fHslider2;
	FAUSTFLOAT fHslider3;
	FAUSTFLOAT fButton0;
	FAUSTFLOAT fHslider4;
	int IOTA;
	FAUSTFLOAT fHslider5;
	FAUSTFLOAT fHslider6;
	int fSamplingFreq;
	
  public:
	
	void static metadata(Meta* m) { 
		m->declare("author", "Grame");
		m->declare("copyright", "(c)GRAME 2006");
		m->declare("license", "BSD");
		m->declare("math.lib/author", "GRAME");
		m->declare("math.lib/copyright", "GRAME");
		m->declare("math.lib/license", "LGPL with exception");
		m->declare("math.lib/name", "Math Library");
		m->declare("math.lib/version", "1.0");
		m->declare("music.lib/author", "GRAME");
		m->declare("music.lib/copyright", "GRAME");
		m->declare("music.lib/license", "LGPL with exception");
		m->declare("music.lib/name", "Music Library");
		m->declare("music.lib/version", "1.0");
		m->declare("name", "karplus32");
		m->declare("version", "1.0");
	}

	virtual int getNumInputs() {
		return 0;
		
	}
	virtual int getNumOutputs() {
		return 2;
		
	}
	virtual int getInputRate(int channel) {
		int rate;
		switch (channel) {
			default: {
				rate = -1;
				break;
			}
			
		}
		return rate;
		
	}
	virtual int getOutputRate(int channel) {
		int rate;
		switch (channel) {
			case 0: {
				rate = 1;
				break;
			}
			case 1: {
				rate = 1;
				break;
			}
			default: {
				rate = -1;
				break;
			}
			
		}
		return rate;
		
	}
	
	static void classInit(int samplingFreq) {
		
	}
	
	virtual void instanceInit(int samplingFreq) {
		fSamplingFreq = samplingFreq;
		fHslider0 = FAUSTFLOAT(0.5);
		fHslider1 = FAUSTFLOAT(1.);
		fHslider2 = FAUSTFLOAT(0.1);
		fHslider3 = FAUSTFLOAT(0.5);
		for (int i0 = 0; (i0 < 2); i0 = (i0 + 1)) {
			iRec1[i0] = 0;
			
		}
		fButton0 = FAUSTFLOAT(0.);
		for (int i1 = 0; (i1 < 2); i1 = (i1 + 1)) {
			fVec0[i1] = 0.f;
			
		}
		fHslider4 = FAUSTFLOAT(128.);
		for (int i2 = 0; (i2 < 2); i2 = (i2 + 1)) {
			fRec2[i2] = 0.f;
			
		}
		IOTA = 0;
		for (int i3 = 0; (i3 < 512); i3 = (i3 + 1)) {
			fVec1[i3] = 0.f;
			
		}
		fHslider5 = FAUSTFLOAT(128.);
		for (int i4 = 0; (i4 < 3); i4 = (i4 + 1)) {
			fRec0[i4] = 0.f;
			
		}
		for (int i5 = 0; (i5 < 2048); i5 = (i5 + 1)) {
			fVec2[i5] = 0.f;
			
		}
		fHslider6 = FAUSTFLOAT(32.);
		for (int i6 = 0; (i6 < 3); i6 = (i6 + 1)) {
			fRec3[i6] = 0.f;
			
		}
		for (int i7 = 0; (i7 < 4096); i7 = (i7 + 1)) {
			fVec3[i7] = 0.f;
			
		}
		for (int i8 = 0; (i8 < 3); i8 = (i8 + 1)) {
			fRec4[i8] = 0.f;
			
		}
		for (int i9 = 0; (i9 < 4096); i9 = (i9 + 1)) {
			fVec4[i9] = 0.f;
			
		}
		for (int i10 = 0; (i10 < 3); i10 = (i10 + 1)) {
			fRec5[i10] = 0.f;
			
		}
		for (int i11 = 0; (i11 < 4096); i11 = (i11 + 1)) {
			fVec5[i11] = 0.f;
			
		}
		for (int i12 = 0; (i12 < 3); i12 = (i12 + 1)) {
			fRec6[i12] = 0.f;
			
		}
		for (int i13 = 0; (i13 < 4096); i13 = (i13 + 1)) {
			fVec6[i13] = 0.f;
			
		}
		for (int i14 = 0; (i14 < 3); i14 = (i14 + 1)) {
			fRec7[i14] = 0.f;
			
		}
		for (int i15 = 0; (i15 < 4096); i15 = (i15 + 1)) {
			fVec7[i15] = 0.f;
			
		}
		for (int i16 = 0; (i16 < 3); i16 = (i16 + 1)) {
			fRec8[i16] = 0.f;
			
		}
		for (int i17 = 0; (i17 < 4096); i17 = (i17 + 1)) {
			fVec8[i17] = 0.f;
			
		}
		for (int i18 = 0; (i18 < 3); i18 = (i18 + 1)) {
			fRec9[i18] = 0.f;
			
		}
		for (int i19 = 0; (i19 < 4096); i19 = (i19 + 1)) {
			fVec9[i19] = 0.f;
			
		}
		for (int i20 = 0; (i20 < 3); i20 = (i20 + 1)) {
			fRec10[i20] = 0.f;
			
		}
		for (int i21 = 0; (i21 < 4096); i21 = (i21 + 1)) {
			fVec10[i21] = 0.f;
			
		}
		for (int i22 = 0; (i22 < 3); i22 = (i22 + 1)) {
			fRec11[i22] = 0.f;
			
		}
		for (int i23 = 0; (i23 < 4096); i23 = (i23 + 1)) {
			fVec11[i23] = 0.f;
			
		}
		for (int i24 = 0; (i24 < 3); i24 = (i24 + 1)) {
			fRec12[i24] = 0.f;
			
		}
		for (int i25 = 0; (i25 < 4096); i25 = (i25 + 1)) {
			fVec12[i25] = 0.f;
			
		}
		for (int i26 = 0; (i26 < 3); i26 = (i26 + 1)) {
			fRec13[i26] = 0.f;
			
		}
		for (int i27 = 0; (i27 < 4096); i27 = (i27 + 1)) {
			fVec13[i27] = 0.f;
			
		}
		for (int i28 = 0; (i28 < 3); i28 = (i28 + 1)) {
			fRec14[i28] = 0.f;
			
		}
		for (int i29 = 0; (i29 < 4096); i29 = (i29 + 1)) {
			fVec14[i29] = 0.f;
			
		}
		for (int i30 = 0; (i30 < 3); i30 = (i30 + 1)) {
			fRec15[i30] = 0.f;
			
		}
		for (int i31 = 0; (i31 < 4096); i31 = (i31 + 1)) {
			fVec15[i31] = 0.f;
			
		}
		for (int i32 = 0; (i32 < 3); i32 = (i32 + 1)) {
			fRec16[i32] = 0.f;
			
		}
		for (int i33 = 0; (i33 < 4096); i33 = (i33 + 1)) {
			fVec16[i33] = 0.f;
			
		}
		for (int i34 = 0; (i34 < 3); i34 = (i34 + 1)) {
			fRec17[i34] = 0.f;
			
		}
		for (int i35 = 0; (i35 < 1024); i35 = (i35 + 1)) {
			fVec17[i35] = 0.f;
			
		}
		for (int i36 = 0; (i36 < 3); i36 = (i36 + 1)) {
			fRec18[i36] = 0.f;
			
		}
		for (int i37 = 0; (i37 < 2048); i37 = (i37 + 1)) {
			fVec18[i37] = 0.f;
			
		}
		for (int i38 = 0; (i38 < 3); i38 = (i38 + 1)) {
			fRec19[i38] = 0.f;
			
		}
		for (int i39 = 0; (i39 < 4096); i39 = (i39 + 1)) {
			fVec19[i39] = 0.f;
			
		}
		for (int i40 = 0; (i40 < 3); i40 = (i40 + 1)) {
			fRec20[i40] = 0.f;
			
		}
		for (int i41 = 0; (i41 < 4096); i41 = (i41 + 1)) {
			fVec20[i41] = 0.f;
			
		}
		for (int i42 = 0; (i42 < 3); i42 = (i42 + 1)) {
			fRec21[i42] = 0.f;
			
		}
		for (int i43 = 0; (i43 < 4096); i43 = (i43 + 1)) {
			fVec21[i43] = 0.f;
			
		}
		for (int i44 = 0; (i44 < 3); i44 = (i44 + 1)) {
			fRec22[i44] = 0.f;
			
		}
		for (int i45 = 0; (i45 < 4096); i45 = (i45 + 1)) {
			fVec22[i45] = 0.f;
			
		}
		for (int i46 = 0; (i46 < 3); i46 = (i46 + 1)) {
			fRec23[i46] = 0.f;
			
		}
		for (int i47 = 0; (i47 < 4096); i47 = (i47 + 1)) {
			fVec23[i47] = 0.f;
			
		}
		for (int i48 = 0; (i48 < 3); i48 = (i48 + 1)) {
			fRec24[i48] = 0.f;
			
		}
		for (int i49 = 0; (i49 < 4096); i49 = (i49 + 1)) {
			fVec24[i49] = 0.f;
			
		}
		for (int i50 = 0; (i50 < 3); i50 = (i50 + 1)) {
			fRec25[i50] = 0.f;
			
		}
		for (int i51 = 0; (i51 < 4096); i51 = (i51 + 1)) {
			fVec25[i51] = 0.f;
			
		}
		for (int i52 = 0; (i52 < 3); i52 = (i52 + 1)) {
			fRec26[i52] = 0.f;
			
		}
		for (int i53 = 0; (i53 < 4096); i53 = (i53 + 1)) {
			fVec26[i53] = 0.f;
			
		}
		for (int i54 = 0; (i54 < 3); i54 = (i54 + 1)) {
			fRec27[i54] = 0.f;
			
		}
		for (int i55 = 0; (i55 < 4096); i55 = (i55 + 1)) {
			fVec27[i55] = 0.f;
			
		}
		for (int i56 = 0; (i56 < 3); i56 = (i56 + 1)) {
			fRec28[i56] = 0.f;
			
		}
		for (int i57 = 0; (i57 < 4096); i57 = (i57 + 1)) {
			fVec28[i57] = 0.f;
			
		}
		for (int i58 = 0; (i58 < 3); i58 = (i58 + 1)) {
			fRec29[i58] = 0.f;
			
		}
		for (int i59 = 0; (i59 < 4096); i59 = (i59 + 1)) {
			fVec29[i59] = 0.f;
			
		}
		for (int i60 = 0; (i60 < 3); i60 = (i60 + 1)) {
			fRec30[i60] = 0.f;
			
		}
		for (int i61 = 0; (i61 < 4096); i61 = (i61 + 1)) {
			fVec30[i61] = 0.f;
			
		}
		for (int i62 = 0; (i62 < 3); i62 = (i62 + 1)) {
			fRec31[i62] = 0.f;
			
		}
		for (int i63 = 0; (i63 < 4096); i63 = (i63 + 1)) {
			fVec31[i63] = 0.f;
			
		}
		for (int i64 = 0; (i64 < 3); i64 = (i64 + 1)) {
			fRec32[i64] = 0.f;
			
		}
		for (int i65 = 0; (i65 < 4096); i65 = (i65 + 1)) {
			fVec32[i65] = 0.f;
			
		}
		for (int i66 = 0; (i66 < 3); i66 = (i66 + 1)) {
			fRec33[i66] = 0.f;
			
		}
		
	}
	
	virtual void init(int samplingFreq) {
		classInit(samplingFreq);
		instanceInit(samplingFreq);
	}
	
	virtual void buildUserInterface(UI* interface) {
		interface->openVerticalBox("karplus32");
		interface->openVerticalBox("excitator");
		interface->addHorizontalSlider("excitation (samples)", &fHslider4, 128.f, 2.f, 512.f, 1.f);
		interface->addButton("play",&fButton0);
		interface->closeBox();
		interface->openVerticalBox("noise generator");
		interface->addHorizontalSlider("level", &fHslider3, 0.5f, 0.f, 1.f, 0.1f);
		interface->closeBox();
		interface->addHorizontalSlider("output volume", &fHslider0, 0.5f, 0.f, 1.f, 0.1f);
		interface->openVerticalBox("resonator x32");
		interface->addHorizontalSlider("attenuation", &fHslider2, 0.1f, 0.f, 1.f, 0.01f);
		interface->addHorizontalSlider("detune", &fHslider6, 32.f, 0.f, 512.f, 1.f);
		interface->addHorizontalSlider("duration (samples)", &fHslider5, 128.f, 2.f, 512.f, 1.f);
		interface->addHorizontalSlider("polyphony", &fHslider1, 1.f, 0.f, 32.f, 1.f);
		interface->closeBox();
		interface->closeBox();
		
	}
	
	virtual void compute(int count, FAUSTFLOAT** inputs, FAUSTFLOAT** outputs) {
		FAUSTFLOAT* output0 = outputs[0];
		FAUSTFLOAT* output1 = outputs[1];
		float fSlow0 = float(fHslider0);
		float fSlow1 = float(fHslider1);
		int iSlow2 = int((fSlow1 > 0.f));
		float fSlow3 = float((0.5f * float((1.f - float(fHslider2)))));
		float fSlow4 = float((4.65661e-10f * float(fHslider3)));
		float fSlow5 = float(fButton0);
		float fSlow6 = float((1.f / float(fHslider4)));
		float fSlow7 = float(fHslider5);
		int iSlow8 = int(int((int(float((fSlow7 - 1.5f))) & 4095)));
		int iSlow9 = int((fSlow1 > 2.f));
		float fSlow10 = float(fHslider6);
		int iSlow11 = int(int((int(float((float((fSlow7 + float((2.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow12 = int((fSlow1 > 4.f));
		int iSlow13 = int(int((int(float((float((fSlow7 + float((4.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow14 = int((fSlow1 > 6.f));
		int iSlow15 = int(int((int(float((float((fSlow7 + float((6.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow16 = int((fSlow1 > 8.f));
		int iSlow17 = int(int((int(float((float((fSlow7 + float((8.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow18 = int((fSlow1 > 10.f));
		int iSlow19 = int(int((int(float((float((fSlow7 + float((10.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow20 = int((fSlow1 > 12.f));
		int iSlow21 = int(int((int(float((float((fSlow7 + float((12.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow22 = int((fSlow1 > 14.f));
		int iSlow23 = int(int((int(float((float((fSlow7 + float((14.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow24 = int((fSlow1 > 16.f));
		int iSlow25 = int(int((int(float((float((fSlow7 + float((16.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow26 = int((fSlow1 > 18.f));
		int iSlow27 = int(int((int(float((float((fSlow7 + float((18.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow28 = int((fSlow1 > 20.f));
		int iSlow29 = int(int((int(float((float((fSlow7 + float((20.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow30 = int((fSlow1 > 22.f));
		int iSlow31 = int(int((int(float((float((fSlow7 + float((22.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow32 = int((fSlow1 > 24.f));
		int iSlow33 = int(int((int(float((float((fSlow7 + float((24.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow34 = int((fSlow1 > 26.f));
		int iSlow35 = int(int((int(float((float((fSlow7 + float((26.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow36 = int((fSlow1 > 28.f));
		int iSlow37 = int(int((int(float((float((fSlow7 + float((28.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow38 = int((fSlow1 > 30.f));
		int iSlow39 = int(int((int(float((float((fSlow7 + float((30.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow40 = int((fSlow1 > 1.f));
		int iSlow41 = int(int((int(float((float((fSlow10 + fSlow7)) - 1.5f))) & 4095)));
		int iSlow42 = int((fSlow1 > 3.f));
		int iSlow43 = int(int((int(float((float((fSlow7 + float((3.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow44 = int((fSlow1 > 5.f));
		int iSlow45 = int(int((int(float((float((fSlow7 + float((5.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow46 = int((fSlow1 > 7.f));
		int iSlow47 = int(int((int(float((float((fSlow7 + float((7.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow48 = int((fSlow1 > 9.f));
		int iSlow49 = int(int((int(float((float((fSlow7 + float((9.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow50 = int((fSlow1 > 11.f));
		int iSlow51 = int(int((int(float((float((fSlow7 + float((11.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow52 = int((fSlow1 > 13.f));
		int iSlow53 = int(int((int(float((float((fSlow7 + float((13.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow54 = int((fSlow1 > 15.f));
		int iSlow55 = int(int((int(float((float((fSlow7 + float((15.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow56 = int((fSlow1 > 17.f));
		int iSlow57 = int(int((int(float((float((fSlow7 + float((17.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow58 = int((fSlow1 > 19.f));
		int iSlow59 = int(int((int(float((float((fSlow7 + float((19.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow60 = int((fSlow1 > 21.f));
		int iSlow61 = int(int((int(float((float((fSlow7 + float((21.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow62 = int((fSlow1 > 23.f));
		int iSlow63 = int(int((int(float((float((fSlow7 + float((23.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow64 = int((fSlow1 > 25.f));
		int iSlow65 = int(int((int(float((float((fSlow7 + float((25.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow66 = int((fSlow1 > 27.f));
		int iSlow67 = int(int((int(float((float((fSlow7 + float((27.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow68 = int((fSlow1 > 29.f));
		int iSlow69 = int(int((int(float((float((fSlow7 + float((29.f * fSlow10)))) - 1.5f))) & 4095)));
		int iSlow70 = int((fSlow1 > 31.f));
		int iSlow71 = int(int((int(float((float((float((31.f * fSlow10)) + fSlow7)) - 1.5f))) & 4095)));
		for (int i = 0; (i < count); i = (i + 1)) {
			iRec1[0] = int((12345 + int((1103515245 * iRec1[1]))));
			fVec0[0] = fSlow5;
			fRec2[0] = float((float((fRec2[1] + float(int((float((fSlow5 - fVec0[1])) > 0.f))))) - float((fSlow6 * float(int((fRec2[1] > 0.f)))))));
			float fTemp0 = float((fSlow4 * float((float(iRec1[0]) * float((float(int((fRec2[0] > 0.f))) + 1.52588e-05f))))));
			fVec1[(IOTA & 511)] = float((float((fSlow3 * float((fRec0[1] + fRec0[2])))) + fTemp0));
			fRec0[0] = fVec1[((IOTA - iSlow8) & 511)];
			fVec2[(IOTA & 2047)] = float((fTemp0 + float((fSlow3 * float((fRec3[1] + fRec3[2]))))));
			fRec3[0] = fVec2[((IOTA - iSlow11) & 2047)];
			fVec3[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec4[1] + fRec4[2]))))));
			fRec4[0] = fVec3[((IOTA - iSlow13) & 4095)];
			fVec4[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec5[1] + fRec5[2]))))));
			fRec5[0] = fVec4[((IOTA - iSlow15) & 4095)];
			fVec5[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec6[1] + fRec6[2]))))));
			fRec6[0] = fVec5[((IOTA - iSlow17) & 4095)];
			fVec6[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec7[1] + fRec7[2]))))));
			fRec7[0] = fVec6[((IOTA - iSlow19) & 4095)];
			fVec7[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec8[1] + fRec8[2]))))));
			fRec8[0] = fVec7[((IOTA - iSlow21) & 4095)];
			fVec8[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec9[1] + fRec9[2]))))));
			fRec9[0] = fVec8[((IOTA - iSlow23) & 4095)];
			fVec9[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec10[1] + fRec10[2]))))));
			fRec10[0] = fVec9[((IOTA - iSlow25) & 4095)];
			fVec10[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec11[1] + fRec11[2]))))));
			fRec11[0] = fVec10[((IOTA - iSlow27) & 4095)];
			fVec11[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec12[1] + fRec12[2]))))));
			fRec12[0] = fVec11[((IOTA - iSlow29) & 4095)];
			fVec12[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec13[1] + fRec13[2]))))));
			fRec13[0] = fVec12[((IOTA - iSlow31) & 4095)];
			fVec13[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec14[1] + fRec14[2]))))));
			fRec14[0] = fVec13[((IOTA - iSlow33) & 4095)];
			fVec14[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec15[1] + fRec15[2]))))));
			fRec15[0] = fVec14[((IOTA - iSlow35) & 4095)];
			fVec15[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec16[1] + fRec16[2]))))));
			fRec16[0] = fVec15[((IOTA - iSlow37) & 4095)];
			fVec16[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec17[1] + fRec17[2]))))));
			fRec17[0] = fVec16[((IOTA - iSlow39) & 4095)];
			output0[i] = FAUSTFLOAT(float((fSlow0 * float((float((float((float((float((float((float((float((float((float((float((float((float((float((float((float((float(iSlow2) * fRec0[0])) + float((float(iSlow9) * fRec3[0])))) + float((float(iSlow12) * fRec4[0])))) + float((float(iSlow14) * fRec5[0])))) + float((float(iSlow16) * fRec6[0])))) + float((float(iSlow18) * fRec7[0])))) + float((float(iSlow20) * fRec8[0])))) + float((float(iSlow22) * fRec9[0])))) + float((float(iSlow24) * fRec10[0])))) + float((float(iSlow26) * fRec11[0])))) + float((float(iSlow28) * fRec12[0])))) + float((float(iSlow30) * fRec13[0])))) + float((float(iSlow32) * fRec14[0])))) + float((float(iSlow34) * fRec15[0])))) + float((float(iSlow36) * fRec16[0])))) + float((float(iSlow38) * fRec17[0])))))));
			fVec17[(IOTA & 1023)] = float((fTemp0 + float((fSlow3 * float((fRec18[1] + fRec18[2]))))));
			fRec18[0] = fVec17[((IOTA - iSlow41) & 1023)];
			fVec18[(IOTA & 2047)] = float((fTemp0 + float((fSlow3 * float((fRec19[1] + fRec19[2]))))));
			fRec19[0] = fVec18[((IOTA - iSlow43) & 2047)];
			fVec19[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec20[1] + fRec20[2]))))));
			fRec20[0] = fVec19[((IOTA - iSlow45) & 4095)];
			fVec20[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec21[1] + fRec21[2]))))));
			fRec21[0] = fVec20[((IOTA - iSlow47) & 4095)];
			fVec21[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec22[1] + fRec22[2]))))));
			fRec22[0] = fVec21[((IOTA - iSlow49) & 4095)];
			fVec22[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec23[1] + fRec23[2]))))));
			fRec23[0] = fVec22[((IOTA - iSlow51) & 4095)];
			fVec23[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec24[1] + fRec24[2]))))));
			fRec24[0] = fVec23[((IOTA - iSlow53) & 4095)];
			fVec24[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec25[1] + fRec25[2]))))));
			fRec25[0] = fVec24[((IOTA - iSlow55) & 4095)];
			fVec25[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec26[1] + fRec26[2]))))));
			fRec26[0] = fVec25[((IOTA - iSlow57) & 4095)];
			fVec26[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec27[1] + fRec27[2]))))));
			fRec27[0] = fVec26[((IOTA - iSlow59) & 4095)];
			fVec27[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec28[1] + fRec28[2]))))));
			fRec28[0] = fVec27[((IOTA - iSlow61) & 4095)];
			fVec28[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec29[1] + fRec29[2]))))));
			fRec29[0] = fVec28[((IOTA - iSlow63) & 4095)];
			fVec29[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec30[1] + fRec30[2]))))));
			fRec30[0] = fVec29[((IOTA - iSlow65) & 4095)];
			fVec30[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec31[1] + fRec31[2]))))));
			fRec31[0] = fVec30[((IOTA - iSlow67) & 4095)];
			fVec31[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec32[1] + fRec32[2]))))));
			fRec32[0] = fVec31[((IOTA - iSlow69) & 4095)];
			fVec32[(IOTA & 4095)] = float((fTemp0 + float((fSlow3 * float((fRec33[1] + fRec33[2]))))));
			fRec33[0] = fVec32[((IOTA - iSlow71) & 4095)];
			output1[i] = FAUSTFLOAT(float((fSlow0 * float((float((float((float((float((float((float((float((float((float((float((float((float((float((float((float((float(iSlow40) * fRec18[0])) + float((float(iSlow42) * fRec19[0])))) + float((float(iSlow44) * fRec20[0])))) + float((float(iSlow46) * fRec21[0])))) + float((float(iSlow48) * fRec22[0])))) + float((float(iSlow50) * fRec23[0])))) + float((float(iSlow52) * fRec24[0])))) + float((float(iSlow54) * fRec25[0])))) + float((float(iSlow56) * fRec26[0])))) + float((float(iSlow58) * fRec27[0])))) + float((float(iSlow60) * fRec28[0])))) + float((float(iSlow62) * fRec29[0])))) + float((float(iSlow64) * fRec30[0])))) + float((float(iSlow66) * fRec31[0])))) + float((float(iSlow68) * fRec32[0])))) + float((float(iSlow70) * fRec33[0])))))));
			iRec1[1] = iRec1[0];
			fVec0[1] = fVec0[0];
			fRec2[1] = fRec2[0];
			IOTA = (IOTA + 1);
			fRec0[2] = fRec0[1];
			fRec0[1] = fRec0[0];
			fRec3[2] = fRec3[1];
			fRec3[1] = fRec3[0];
			fRec4[2] = fRec4[1];
			fRec4[1] = fRec4[0];
			fRec5[2] = fRec5[1];
			fRec5[1] = fRec5[0];
			fRec6[2] = fRec6[1];
			fRec6[1] = fRec6[0];
			fRec7[2] = fRec7[1];
			fRec7[1] = fRec7[0];
			fRec8[2] = fRec8[1];
			fRec8[1] = fRec8[0];
			fRec9[2] = fRec9[1];
			fRec9[1] = fRec9[0];
			fRec10[2] = fRec10[1];
			fRec10[1] = fRec10[0];
			fRec11[2] = fRec11[1];
			fRec11[1] = fRec11[0];
			fRec12[2] = fRec12[1];
			fRec12[1] = fRec12[0];
			fRec13[2] = fRec13[1];
			fRec13[1] = fRec13[0];
			fRec14[2] = fRec14[1];
			fRec14[1] = fRec14[0];
			fRec15[2] = fRec15[1];
			fRec15[1] = fRec15[0];
			fRec16[2] = fRec16[1];
			fRec16[1] = fRec16[0];
			fRec17[2] = fRec17[1];
			fRec17[1] = fRec17[0];
			fRec18[2] = fRec18[1];
			fRec18[1] = fRec18[0];
			fRec19[2] = fRec19[1];
			fRec19[1] = fRec19[0];
			fRec20[2] = fRec20[1];
			fRec20[1] = fRec20[0];
			fRec21[2] = fRec21[1];
			fRec21[1] = fRec21[0];
			fRec22[2] = fRec22[1];
			fRec22[1] = fRec22[0];
			fRec23[2] = fRec23[1];
			fRec23[1] = fRec23[0];
			fRec24[2] = fRec24[1];
			fRec24[1] = fRec24[0];
			fRec25[2] = fRec25[1];
			fRec25[1] = fRec25[0];
			fRec26[2] = fRec26[1];
			fRec26[1] = fRec26[0];
			fRec27[2] = fRec27[1];
			fRec27[1] = fRec27[0];
			fRec28[2] = fRec28[1];
			fRec28[1] = fRec28[0];
			fRec29[2] = fRec29[1];
			fRec29[1] = fRec29[0];
			fRec30[2] = fRec30[1];
			fRec30[1] = fRec30[0];
			fRec31[2] = fRec31[1];
			fRec31[1] = fRec31[0];
			fRec32[2] = fRec32[1];
			fRec32[1] = fRec32[0];
			fRec33[2] = fRec33[1];
			fRec33[1] = fRec33[0];
			
		}
		
	}

	
};


#include <stdio.h>
#include <string>
#include "m_pd.h"

#define sym(name) xsym(name)
#define xsym(name) #name
#define faust_setup(name) xfaust_setup(name)
#define xfaust_setup(name) name ## _tilde_setup(void)

// time for "active" toggle xfades in secs
#define XFADE_TIME 0.1f

static t_class *faust_class;

struct t_faust {
  t_object x_obj;
#ifdef __MINGW32__
  /* This seems to be necessary as some as yet undetermined Pd routine seems
     to write past the end of x_obj on Windows. */
  int fence; /* dummy field (not used) */
#endif
  mydsp *dsp;
  PdUI *ui;
  std::string *label;
  int active, xfade, n_xfade, rate, n_in, n_out;
  t_sample **inputs, **outputs, **buf;
  t_outlet *out;
  t_sample f;
};

static t_symbol *s_button, *s_checkbox, *s_vslider, *s_hslider, *s_nentry,
  *s_vbargraph, *s_hbargraph;

static inline void zero_samples(int k, int n, t_sample **out)
{
  for (int i = 0; i < k; i++)
#ifdef __STDC_IEC_559__
    /* IEC 559 a.k.a. IEEE 754 floats can be initialized faster like this */
    memset(out[i], 0, n*sizeof(t_sample));
#else
    for (int j = 0; j < n; j++)
      out[i][j] = 0.0f;
#endif
}

static inline void copy_samples(int k, int n, t_sample **out, t_sample **in)
{
  for (int i = 0; i < k; i++)
    memcpy(out[i], in[i], n*sizeof(t_sample));
}

static t_int *faust_perform(t_int *w)
{
  t_faust *x = (t_faust *)(w[1]);
  int n = (int)(w[2]);
  if (!x->dsp || !x->buf) return (w+3);
  AVOIDDENORMALS;
  if (x->xfade > 0) {
    float d = 1.0f/x->n_xfade, f = (x->xfade--)*d;
    d = d/n;
    x->dsp->compute(n, x->inputs, x->buf);
    if (x->active)
      if (x->n_in == x->n_out)
	/* xfade inputs -> buf */
	for (int j = 0; j < n; j++, f -= d)
	  for (int i = 0; i < x->n_out; i++)
	    x->outputs[i][j] = f*x->inputs[i][j]+(1.0f-f)*x->buf[i][j];
      else
	/* xfade 0 -> buf */
	for (int j = 0; j < n; j++, f -= d)
	  for (int i = 0; i < x->n_out; i++)
	    x->outputs[i][j] = (1.0f-f)*x->buf[i][j];
    else
      if (x->n_in == x->n_out)
	/* xfade buf -> inputs */
	for (int j = 0; j < n; j++, f -= d)
	  for (int i = 0; i < x->n_out; i++)
	    x->outputs[i][j] = f*x->buf[i][j]+(1.0f-f)*x->inputs[i][j];
      else
	/* xfade buf -> 0 */
	for (int j = 0; j < n; j++, f -= d)
	  for (int i = 0; i < x->n_out; i++)
	    x->outputs[i][j] = f*x->buf[i][j];
  } else if (x->active) {
    x->dsp->compute(n, x->inputs, x->buf);
    copy_samples(x->n_out, n, x->outputs, x->buf);
  } else if (x->n_in == x->n_out) {
    copy_samples(x->n_out, n, x->buf, x->inputs);
    copy_samples(x->n_out, n, x->outputs, x->buf);
  } else
    zero_samples(x->n_out, n, x->outputs);
  return (w+3);
}

static void faust_dsp(t_faust *x, t_signal **sp)
{
  int n = sp[0]->s_n, sr = (int)sp[0]->s_sr;
  if (x->rate <= 0) {
    /* default sample rate is whatever Pd tells us */
    PdUI *ui = x->ui;
    float *z = NULL;
    if (ui->nelems > 0 &&
	(z = (float*)malloc(ui->nelems*sizeof(float)))) {
      /* save the current control values */
      for (int i = 0; i < ui->nelems; i++)
	if (ui->elems[i].zone)
	  z[i] = *ui->elems[i].zone;
    }
    /* set the proper sample rate; this requires reinitializing the dsp */
    x->rate = sr;
    x->dsp->init(sr);
    if (z) {
      /* restore previous control values */
      for (int i = 0; i < ui->nelems; i++)
	if (ui->elems[i].zone)
	  *ui->elems[i].zone = z[i];
      free(z);
    }
  }
  if (n > 0)
    x->n_xfade = (int)(x->rate*XFADE_TIME/n);
  dsp_add(faust_perform, 2, x, n);
  for (int i = 0; i < x->n_in; i++)
    x->inputs[i] = sp[i+1]->s_vec;
  for (int i = 0; i < x->n_out; i++)
    x->outputs[i] = sp[x->n_in+i+1]->s_vec;
  if (x->buf != NULL)
    for (int i = 0; i < x->n_out; i++) {
      x->buf[i] = (t_sample*)malloc(n*sizeof(t_sample));
      if (x->buf[i] == NULL) {
	for (int j = 0; j < i; j++)
	  free(x->buf[j]);
	free(x->buf);
	x->buf = NULL;
	break;
      }
    }
}

static int pathcmp(const char *s, const char *t)
{
  int n = strlen(s), m = strlen(t);
  if (n == 0 || m == 0)
    return 0;
  else if (t[0] == '/')
    return strcmp(s, t);
  else if (n <= m || s[n-m-1] != '/')
    return strcmp(s+1, t);
  else
    return strcmp(s+n-m, t);
}

static void faust_any(t_faust *x, t_symbol *s, int argc, t_atom *argv)
{
  if (!x->dsp) return;
  PdUI *ui = x->ui;
  if (s == &s_bang) {
    for (int i = 0; i < ui->nelems; i++)
      if (ui->elems[i].label && ui->elems[i].zone) {
	t_atom args[6];
	t_symbol *_s;
	switch (ui->elems[i].type) {
	case UI_BUTTON:
	  _s = s_button;
	  break;
	case UI_CHECK_BUTTON:
	  _s = s_checkbox;
	  break;
	case UI_V_SLIDER:
	  _s = s_vslider;
	  break;
	case UI_H_SLIDER:
	  _s = s_hslider;
	  break;
	case UI_NUM_ENTRY:
	  _s = s_nentry;
	  break;
	case UI_V_BARGRAPH:
	  _s = s_vbargraph;
	  break;
	case UI_H_BARGRAPH:
	  _s = s_hbargraph;
	  break;
	default:
	  continue;
	}
	SETSYMBOL(&args[0], gensym(ui->elems[i].label));
	SETFLOAT(&args[1], *ui->elems[i].zone);
	SETFLOAT(&args[2], ui->elems[i].init);
	SETFLOAT(&args[3], ui->elems[i].min);
	SETFLOAT(&args[4], ui->elems[i].max);
	SETFLOAT(&args[5], ui->elems[i].step);
	outlet_anything(x->out, _s, 6, args);
      }
  } else {
    const char *label = s->s_name;
    int count = 0;
    for (int i = 0; i < ui->nelems; i++)
      if (ui->elems[i].label &&
	  pathcmp(ui->elems[i].label, label) == 0) {
	if (argc == 0) {
	  if (ui->elems[i].zone) {
	    t_atom arg;
	    SETFLOAT(&arg, *ui->elems[i].zone);
	    outlet_anything(x->out, gensym(ui->elems[i].label), 1, &arg);
	  }
	  ++count;
	} else if (argc == 1 &&
		   (argv[0].a_type == A_FLOAT ||
		    argv[0].a_type == A_DEFFLOAT) &&
		   ui->elems[i].zone) {
	  float f = atom_getfloat(argv);
	  *ui->elems[i].zone = f;
	  ++count;
	} else
	  pd_error(x, "[faust] %s: bad control argument: %s",
		   x->label->c_str(), label);
      }
    if (count == 0 && strcmp(label, "active") == 0) {
      if (argc == 0) {
	t_atom arg;
	SETFLOAT(&arg, (float)x->active);
	outlet_anything(x->out, gensym((char*)"active"), 1, &arg);
      } else if (argc == 1 &&
		 (argv[0].a_type == A_FLOAT ||
		  argv[0].a_type == A_DEFFLOAT)) {
	float f = atom_getfloat(argv);
	x->active = (int)f;
	x->xfade = x->n_xfade;
      }
    }
  }
}

static void faust_free(t_faust *x)
{
  if (x->label) delete x->label;
  if (x->dsp) delete x->dsp;
  if (x->ui) delete x->ui;
  if (x->inputs) free(x->inputs);
  if (x->outputs) free(x->outputs);
  if (x->buf) {
    for (int i = 0; i < x->n_out; i++)
      if (x->buf[i]) free(x->buf[i]);
    free(x->buf);
  }
}

static void *faust_new(t_symbol *s, int argc, t_atom *argv)
{
  t_faust *x = (t_faust*)pd_new(faust_class);
  int sr = -1;
  t_symbol *id = NULL;
  x->active = 1;
  for (int i = 0; i < argc; i++)
    if (argv[i].a_type == A_FLOAT || argv[i].a_type == A_DEFFLOAT)
      sr = (int)argv[i].a_w.w_float;
    else if (argv[i].a_type == A_SYMBOL || argv[i].a_type == A_DEFSYMBOL)
      id = argv[i].a_w.w_symbol;
  x->rate = sr;
  if (sr <= 0) sr = 44100;
  x->xfade = 0; x->n_xfade = (int)(sr*XFADE_TIME/64);
  x->inputs = x->outputs = x->buf = NULL;
    x->label = new std::string(sym(mydsp) "~");
  x->dsp = new mydsp();
  x->ui = new PdUI(sym(mydsp), id?id->s_name:NULL);
  if (!x->dsp || !x->ui || !x->label) goto error;
  if (id) {
    *x->label += " ";
    *x->label += id->s_name;
  }
  x->n_in = x->dsp->getNumInputs();
  x->n_out = x->dsp->getNumOutputs();
  if (x->n_in > 0)
    x->inputs = (t_sample**)malloc(x->n_in*sizeof(t_sample*));
  if (x->n_out > 0) {
    x->outputs = (t_sample**)malloc(x->n_out*sizeof(t_sample*));
    x->buf = (t_sample**)malloc(x->n_out*sizeof(t_sample*));
  }
  if ((x->n_in > 0 && x->inputs == NULL) ||
      (x->n_out > 0 && (x->outputs == NULL || x->buf == NULL)))
    goto error;
  for (int i = 0; i < x->n_out; i++)
    x->buf[i] = NULL;
  x->dsp->init(sr);
  x->dsp->buildUserInterface(x->ui);
  for (int i = 0; i < x->n_in; i++)
    inlet_new(&x->x_obj, &x->x_obj.ob_pd, &s_signal, &s_signal);
  x->out = outlet_new(&x->x_obj, 0);
  for (int i = 0; i < x->n_out; i++)
    outlet_new(&x->x_obj, &s_signal);
  return (void *)x;
 error:
  faust_free(x);
  x->dsp = NULL; x->ui = NULL;
  x->inputs = x->outputs = x->buf = NULL;
  return (void *)x;
}

extern "C" void faust_setup(mydsp)
{
  t_symbol *s = gensym(sym(mydsp) "~");
  faust_class =
    class_new(s, (t_newmethod)faust_new, (t_method)faust_free,
	      sizeof(t_faust), CLASS_DEFAULT,
	      A_GIMME, A_NULL);
  class_addmethod(faust_class, (t_method)faust_dsp, gensym((char*)"dsp"), A_NULL);
  class_addanything(faust_class, faust_any);
  class_addmethod(faust_class, nullfn, &s_signal, A_NULL);
  s_button = gensym((char*)"button");
  s_checkbox = gensym((char*)"checkbox");
  s_vslider = gensym((char*)"vslider");
  s_hslider = gensym((char*)"hslider");
  s_nentry = gensym((char*)"nentry");
  s_vbargraph = gensym((char*)"vbargraph");
  s_hbargraph = gensym((char*)"hbargraph");
  /* give some indication that we're loaded and ready to go */
  mydsp dsp = mydsp();
  post("[faust] %s: %d inputs, %d outputs", sym(mydsp) "~",
       dsp.getNumInputs(), dsp.getNumOutputs());
}

#endif
