/*
 * Decompiled with CFR 0.152.
 */
package javacli;

import java.lang.reflect.Field;
import java.util.Hashtable;
import javacli.CliError;
import javacli.ComBuffer;
import javacli.Connection;
import javacli.ObjectSet;
import javacli.Rectangle;
import javacli.Reference;
import javacli.TableDescriptor;

public class Statement {
    byte[] stmt;
    int stmtId;
    int stmtLen;
    Connection con;
    Parameter params;
    Parameter lastParam;
    int nParams;
    Field columns;
    int nColumns;
    boolean prepared;
    boolean forUpdate;
    TableDescriptor tableDesc;

    public void finalize() {
        if (this.con != null) {
            this.close();
        }
    }

    public void close() {
        if (this.con == null) {
            throw new CliError("Statement already closed");
        }
        ComBuffer buf = new ComBuffer(7, this.stmtId);
        this.con.send(buf);
        this.con = null;
    }

    public void setBool(String name, boolean value) {
        Parameter p = this.getParam(name);
        p.ivalue = value ? 1 : 0;
        p.type = 1;
    }

    public void setByte(String name, byte value) {
        Parameter p = this.getParam(name);
        p.ivalue = value;
        p.type = 4;
    }

    public void setShort(String name, short value) {
        Parameter p = this.getParam(name);
        p.ivalue = value;
        p.type = 4;
    }

    public void setInt(String name, int value) {
        Parameter p = this.getParam(name);
        p.ivalue = value;
        p.type = 4;
    }

    public void setLong(String name, long value) {
        Parameter p = this.getParam(name);
        p.lvalue = value;
        p.type = 5;
    }

    public void setDouble(String name, double value) {
        Parameter p = this.getParam(name);
        p.dvalue = value;
        p.type = 7;
    }

    public void setFloat(String name, float value) {
        Parameter p = this.getParam(name);
        p.fvalue = value;
        p.type = 6;
    }

    public void setString(String name, String value) {
        Parameter p = this.getParam(name);
        p.svalue = value;
        p.type = 9;
    }

    public void setRef(String name, Reference value) {
        Parameter p = this.getParam(name);
        p.ivalue = value != null ? value.oid : 0;
        p.type = 0;
    }

    public void setRectangle(String name, Rectangle rect) {
        Parameter p = this.getParam(name);
        p.rvalue = rect;
        p.type = 25;
    }

    public ObjectSet fetch() {
        return this.fetch(false);
    }

    public ObjectSet fetch(boolean forUpdate) {
        ComBuffer buf;
        if (!this.prepared) {
            buf = new ComBuffer(1, this.stmtId);
            int n = this.tableDesc.nColumns;
            buf.putByte(this.nParams);
            buf.putByte(n);
            int len = this.stmtLen;
            boolean addNull = false;
            if (len == 0 || this.stmt[len - 1] != 0) {
                addNull = true;
                buf.putShort((len += this.nParams) + 1);
            } else {
                buf.putShort(len += this.nParams);
            }
            int i = 0;
            Parameter p = this.params;
            do {
                byte ch = this.stmt[i++];
                buf.putByte(ch);
                if (ch != 0 || --len == 0) continue;
                if (p.type == 26) {
                    throw new CliError("Unbound parameter " + p.name);
                }
                buf.putByte(p.type);
                p = p.next;
                --len;
            } while (len != 0);
            if (addNull) {
                buf.putByte(0);
            }
            this.tableDesc.writeColumnDefs(buf);
        } else {
            buf = new ComBuffer(2, this.stmtId);
        }
        this.forUpdate = forUpdate;
        buf.putByte(forUpdate ? 1 : 0);
        Parameter p = this.params;
        while (p != null) {
            switch (p.type) {
                case 0: 
                case 4: {
                    buf.putInt(p.ivalue);
                    break;
                }
                case 1: 
                case 2: {
                    buf.putByte((byte)p.ivalue);
                    break;
                }
                case 3: {
                    buf.putShort((short)p.ivalue);
                    break;
                }
                case 5: {
                    buf.putLong(p.lvalue);
                    break;
                }
                case 6: {
                    buf.putFloat(p.fvalue);
                    break;
                }
                case 7: {
                    buf.putDouble(p.dvalue);
                    break;
                }
                case 9: {
                    buf.putAsciiz(p.svalue);
                }
            }
            p = p.next;
        }
        this.prepared = true;
        return new ObjectSet(this, this.con.sendReceive(buf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Statement(Connection con, String sql, int stmtId) {
        this.stmtId = stmtId;
        int src = 0;
        int dst = 0;
        int len = sql.length();
        int p = sql.indexOf("from");
        if (p < 0 && (p = sql.indexOf("FROM")) < 0) {
            throw new CliError("Bad statment: SELECT FROM expected");
        }
        p += 5;
        while (p < len && sql.charAt(p) == ' ') {
            ++p;
        }
        int q = p;
        while (++q < len && sql.charAt(q) != ' ') {
        }
        if (p + 1 == q) {
            throw new CliError("Bad statment: table name expected after FROM");
        }
        String tableName = sql.substring(p, q);
        Hashtable hashtable = Connection.tableHash;
        synchronized (hashtable) {
            this.tableDesc = (TableDescriptor)Connection.tableHash.get(tableName);
            if (this.tableDesc == null) {
                Class<?> tableClass;
                block27: {
                    tableClass = null;
                    try {
                        tableClass = Class.forName(tableName);
                    }
                    catch (ClassNotFoundException x) {
                        int i;
                        if (con.pkgs != null) {
                            String[] pkgs = con.pkgs;
                            i = pkgs.length;
                            while (--i >= 0) {
                                try {
                                    tableClass = Class.forName(pkgs[i] + '.' + tableName);
                                    break;
                                }
                                catch (ClassNotFoundException x1) {
                                }
                            }
                        }
                        if (tableClass == null) {
                            Package[] pks = Package.getPackages();
                            i = pks.length;
                            while (--i >= 0) {
                                try {
                                    tableClass = Class.forName(pks[i].getName() + '.' + tableName);
                                    break;
                                }
                                catch (ClassNotFoundException x1) {
                                }
                            }
                        }
                        if (tableClass != null) break block27;
                        throw new CliError("Class " + tableName + " not found");
                    }
                }
                this.tableDesc = new TableDescriptor(tableClass);
                Connection.tableHash.put(tableName, this.tableDesc);
            }
        }
        byte[] buf = new byte[len];
        while (src < len) {
            char ch = sql.charAt(src);
            if (ch == '\'') {
                while (true) {
                    buf[dst++] = (byte)sql.charAt(src++);
                    if (src == len) {
                        throw new CliError("Unterminated string constant in query");
                    }
                    if (sql.charAt(src) != '\'') continue;
                    buf[dst++] = 39;
                    if (++src >= len || sql.charAt(src) != '\'') break;
                }
                continue;
            }
            if (ch == '%') {
                int begin = src;
                while (++src != len && ((ch = sql.charAt(src)) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_')) {
                }
                if (ch == '%') {
                    throw new CliError("Invalid parameter name");
                }
                Parameter param = new Parameter(sql.substring(begin, src));
                if (this.lastParam == null) {
                    this.params = param;
                } else {
                    this.lastParam.next = param;
                }
                this.lastParam = param;
                ++this.nParams;
                buf[dst++] = 0;
                continue;
            }
            buf[dst++] = (byte)sql.charAt(src++);
        }
        this.stmt = buf;
        this.stmtLen = dst;
        this.con = con;
    }

    protected Parameter getParam(String name) {
        Parameter p = this.params;
        while (p != null) {
            if (p.name.equals(name)) {
                return p;
            }
            p = p.next;
        }
        throw new CliError("No such parameter");
    }

    static class Parameter {
        Parameter next;
        String name;
        int type;
        int ivalue;
        long lvalue;
        float fvalue;
        double dvalue;
        String svalue;
        Rectangle rvalue;

        Parameter(String name) {
            this.name = name;
            this.type = 26;
        }
    }
}

