/*
 * Decompiled with CFR 0.152.
 */
package javacli;

import javacli.Rectangle;

class ComBuffer {
    byte[] buf;
    int pos;

    static final int packShort(byte[] buf, int offs, int val) {
        buf[offs++] = (byte)(val >> 8);
        buf[offs++] = (byte)val;
        return offs;
    }

    static final int packInt(byte[] buf, int offs, int val) {
        buf[offs++] = (byte)(val >> 24);
        buf[offs++] = (byte)(val >> 16);
        buf[offs++] = (byte)(val >> 8);
        buf[offs++] = (byte)val;
        return offs;
    }

    static final int packLong(byte[] buf, int offs, long val) {
        return ComBuffer.packInt(buf, ComBuffer.packInt(buf, offs, (int)(val >> 32)), (int)val);
    }

    static final int packFloat(byte[] buf, int offs, float value) {
        return ComBuffer.packInt(buf, offs, Float.floatToIntBits(value));
    }

    static final int packDouble(byte[] buf, int offs, double value) {
        return ComBuffer.packLong(buf, offs, Double.doubleToLongBits(value));
    }

    static final short unpackShort(byte[] buf, int offs) {
        return (short)((buf[offs] << 8) + (buf[offs + 1] & 0xFF));
    }

    static final int unpackInt(byte[] buf, int offs) {
        return (buf[offs] << 24) + ((buf[offs + 1] & 0xFF) << 16) + ((buf[offs + 2] & 0xFF) << 8) + (buf[offs + 3] & 0xFF);
    }

    static final long unpackLong(byte[] buf, int offs) {
        return ((long)ComBuffer.unpackInt(buf, offs) << 32) + ((long)ComBuffer.unpackInt(buf, offs + 4) & 0xFFFFFFFFL);
    }

    static final float unpackFloat(byte[] buf, int offs) {
        return Float.intBitsToFloat(ComBuffer.unpackInt(buf, offs));
    }

    static final double unpackDouble(byte[] buf, int offs) {
        return Double.longBitsToDouble(ComBuffer.unpackLong(buf, offs));
    }

    ComBuffer(int cmd, int id) {
        int size = 12;
        this.buf = new byte[size];
        this.pos = 0;
        this.putInt(size);
        this.putInt(cmd);
        this.putInt(id);
    }

    ComBuffer(int cmd) {
        this(cmd, 0);
    }

    void reset(int size) {
        if (this.buf.length < size) {
            this.buf = new byte[size];
        }
        this.pos = 0;
    }

    void end() {
        ComBuffer.packInt(this.buf, 0, this.pos);
    }

    void extend(int len) {
        if (this.pos + len > this.buf.length) {
            int newLen = this.pos + len > len * 2 ? this.pos + len : len * 2;
            byte[] newBuf = new byte[newLen];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
        }
    }

    void putByte(int val) {
        this.extend(1);
        this.buf[this.pos++] = (byte)val;
    }

    void putShort(int val) {
        this.extend(2);
        this.pos = ComBuffer.packShort(this.buf, this.pos, val);
    }

    void putInt(int val) {
        this.extend(4);
        this.pos = ComBuffer.packInt(this.buf, this.pos, val);
    }

    void putLong(long val) {
        this.extend(8);
        this.pos = ComBuffer.packLong(this.buf, this.pos, val);
    }

    void putDouble(double val) {
        this.extend(8);
        this.pos = ComBuffer.packDouble(this.buf, this.pos, val);
    }

    void putFloat(float val) {
        this.extend(4);
        this.pos = ComBuffer.packFloat(this.buf, this.pos, val);
    }

    void putRectangle(Rectangle r) {
        this.extend(16);
        this.pos = ComBuffer.packInt(this.buf, this.pos, r.x0);
        this.pos = ComBuffer.packInt(this.buf, this.pos, r.y0);
        this.pos = ComBuffer.packInt(this.buf, this.pos, r.x1);
        this.pos = ComBuffer.packInt(this.buf, this.pos, r.y1);
    }

    void putAsciiz(String str) {
        if (str != null) {
            byte[] bytes = str.getBytes();
            int len = bytes.length;
            this.extend(len + 1);
            byte[] dst = this.buf;
            int i = this.pos;
            int j = 0;
            while (j < len) {
                dst[i++] = bytes[j++];
            }
            dst[i++] = 0;
            this.pos = i;
        } else {
            this.extend(1);
            this.buf[this.pos++] = 0;
        }
    }

    void putByteArray(byte[] arr) {
        int len = arr == null ? 0 : arr.length;
        this.extend(len + 4);
        this.pos = ComBuffer.packInt(this.buf, this.pos, len);
        System.arraycopy(arr, 0, this.buf, this.pos, len);
        this.pos += len;
    }

    void putString(String str) {
        if (str == null) {
            this.extend(5);
            this.pos = ComBuffer.packInt(this.buf, this.pos, 1);
        } else {
            byte[] bytes = str.getBytes();
            int len = bytes.length;
            this.extend(len + 5);
            this.pos = ComBuffer.packInt(this.buf, this.pos, len + 1);
            System.arraycopy(bytes, 0, this.buf, this.pos, len);
            this.pos += len;
        }
        this.buf[this.pos++] = 0;
    }

    byte getByte() {
        return this.buf[this.pos++];
    }

    short getShort() {
        short value = ComBuffer.unpackShort(this.buf, this.pos);
        this.pos += 2;
        return value;
    }

    int getInt() {
        int value = ComBuffer.unpackInt(this.buf, this.pos);
        this.pos += 4;
        return value;
    }

    long getLong() {
        long value = ComBuffer.unpackLong(this.buf, this.pos);
        this.pos += 8;
        return value;
    }

    float getFloat() {
        float value = ComBuffer.unpackFloat(this.buf, this.pos);
        this.pos += 4;
        return value;
    }

    double getDouble() {
        double value = ComBuffer.unpackDouble(this.buf, this.pos);
        this.pos += 8;
        return value;
    }

    String getAsciiz() {
        int i;
        byte[] p = this.buf;
        int j = i = this.pos;
        while (p[j++] != 0) {
        }
        this.pos = j;
        return new String(p, i, j - i - 1);
    }

    String getString() {
        int len = this.getInt();
        String value = new String(this.buf, this.pos, len - 1);
        this.pos += len;
        return value;
    }

    Rectangle getRectangle() {
        Rectangle r = new Rectangle(ComBuffer.unpackInt(this.buf, this.pos), ComBuffer.unpackInt(this.buf, this.pos + 4), ComBuffer.unpackInt(this.buf, this.pos + 8), ComBuffer.unpackInt(this.buf, this.pos + 12));
        this.pos += 16;
        return r;
    }
}

