/*
 * Decompiled with CFR 0.152.
 */
package jnicli;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.Hashtable;
import jnicli.ClassDescriptor;
import jnicli.CliException;
import jnicli.ConstraintParser;
import jnicli.Cursor;
import jnicli.Database;
import jnicli.IncrementalCursor;
import jnicli.IncrementalCursorForUpdate;
import jnicli.PrefetchedCursor;

public class DatabaseJNI
implements Database {
    static final int TP_BOOL = 1;
    static final int TP_CHAR = 2;
    static final int TP_INT1 = 3;
    static final int TP_INT2 = 4;
    static final int TP_INT4 = 5;
    static final int TP_INT8 = 6;
    static final int TP_REAL4 = 7;
    static final int TP_REAL8 = 8;
    static final int TP_STRING = 9;
    static final int TP_DATE = 10;
    static final int TP_BOOL_ARRAY = 11;
    static final int TP_CHAR_ARRAY = 12;
    static final int TP_INT1_ARRAY = 13;
    static final int TP_INT2_ARRAY = 14;
    static final int TP_INT4_ARRAY = 15;
    static final int TP_INT8_ARRAY = 16;
    static final int TP_REAL4_ARRAY = 17;
    static final int TP_REAL8_ARRAY = 18;
    static final int TP_STRING_ARRAY = 19;
    long db;
    Hashtable classes;
    boolean remote;

    @Override
    public void open(int accessType, String databaseName, String databasePath, long initSize, int transactionCommitDelay) {
        String table;
        this.db = this.jniOpen(accessType, databaseName, databasePath, initSize, transactionCommitDelay);
        this.classes = new Hashtable();
        while ((table = this.jniNextTable(this.db)) != null) {
            try {
                Class<?> c = Class.forName(table);
                ClassDescriptor desc = new ClassDescriptor(c);
                this.classes.put(c, desc);
                desc.td = this.jniUpdateTable(this.db, table, this.getTableDescriptor(desc));
            }
            catch (ClassNotFoundException x) {
                new CliException("Class '" + table + "' not found");
            }
            catch (Exception x) {
                new CliException(x.getMessage());
            }
        }
    }

    @Override
    public void close() {
        this.jniClose(this.db);
        this.classes = null;
    }

    @Override
    public Cursor select(Class table, String condition, int flags) {
        Cursor cursor;
        ClassDescriptor desc = (ClassDescriptor)this.classes.get(table);
        if (desc == null) {
            throw new CliException("Table not found: " + table);
        }
        long result = this.jniSelect(this.db, desc.td, condition);
        if (this.remote || (flags & 2) != 0) {
            cursor = new PrefetchedCursor(this, result, desc);
            if ((flags & 2) != 0) {
                this.jniCommit(this.db);
            }
        } else {
            cursor = (flags & 1) != 0 ? new IncrementalCursorForUpdate(this, result, desc) : new IncrementalCursor(this, result, desc);
        }
        return cursor;
    }

    Object unswizzleObject(long cursor, ClassDescriptor desc) {
        int[] types = desc.types;
        Field[] fields = desc.fields;
        try {
            Object obj = desc.newInstance();
            block23: for (int i = 0; i < types.length; ++i) {
                Field f = fields[i];
                switch (types[i]) {
                    case 1: {
                        f.setBoolean(obj, this.jniGetByte(cursor) != 0);
                        continue block23;
                    }
                    case 2: {
                        f.setChar(obj, (char)this.jniGetShort(cursor));
                        continue block23;
                    }
                    case 3: {
                        f.setByte(obj, this.jniGetByte(cursor));
                        continue block23;
                    }
                    case 4: {
                        f.setShort(obj, this.jniGetShort(cursor));
                        continue block23;
                    }
                    case 5: {
                        f.setInt(obj, this.jniGetInt(cursor));
                        continue block23;
                    }
                    case 6: {
                        f.setLong(obj, this.jniGetLong(cursor));
                        continue block23;
                    }
                    case 7: {
                        f.setFloat(obj, Float.intBitsToFloat(this.jniGetInt(cursor)));
                        continue block23;
                    }
                    case 8: {
                        f.setDouble(obj, Double.longBitsToDouble(this.jniGetLong(cursor)));
                        continue block23;
                    }
                    case 9: {
                        f.set(obj, this.jniGetString(cursor));
                        continue block23;
                    }
                    case 10: {
                        long timestamp = this.jniGetLong(cursor);
                        f.set(obj, timestamp < 0L ? null : new Date(timestamp));
                        continue block23;
                    }
                    case 11: {
                        f.set(obj, this.jniGetBoolArray(cursor));
                        continue block23;
                    }
                    case 12: {
                        f.set(obj, this.jniGetCharArray(cursor));
                        continue block23;
                    }
                    case 13: {
                        f.set(obj, this.jniGetByteArray(cursor));
                        continue block23;
                    }
                    case 14: {
                        f.set(obj, this.jniGetShortArray(cursor));
                        continue block23;
                    }
                    case 15: {
                        f.set(obj, this.jniGetIntArray(cursor));
                        continue block23;
                    }
                    case 16: {
                        f.set(obj, this.jniGetLongArray(cursor));
                        continue block23;
                    }
                    case 17: {
                        f.set(obj, this.jniGetFloatArray(cursor));
                        continue block23;
                    }
                    case 18: {
                        f.set(obj, this.jniGetDoubleArray(cursor));
                        continue block23;
                    }
                    case 19: {
                        f.set(obj, this.jniGetStringArray(cursor));
                        continue block23;
                    }
                    default: {
                        throw new CliException("Invalid field type: " + types[i]);
                    }
                }
            }
            return obj;
        }
        catch (Exception x) {
            throw new CliException(x.getMessage());
        }
    }

    private long swizzleObject(ClassDescriptor desc, Object obj) {
        long buf = this.jniCreateBuffer();
        int[] types = desc.types;
        Field[] fields = desc.fields;
        try {
            block23: for (int i = 0; i < types.length; ++i) {
                Field f = fields[i];
                switch (types[i]) {
                    case 1: {
                        this.jniSetByte(buf, (byte)(f.getBoolean(obj) ? 1 : 0));
                        continue block23;
                    }
                    case 2: {
                        this.jniSetShort(buf, (short)f.getChar(obj));
                        continue block23;
                    }
                    case 3: {
                        this.jniSetByte(buf, f.getByte(obj));
                        continue block23;
                    }
                    case 4: {
                        this.jniSetShort(buf, f.getShort(obj));
                        continue block23;
                    }
                    case 5: {
                        this.jniSetInt(buf, f.getInt(obj));
                        continue block23;
                    }
                    case 6: {
                        this.jniSetLong(buf, f.getLong(obj));
                        continue block23;
                    }
                    case 7: {
                        this.jniSetInt(buf, Float.floatToIntBits(f.getFloat(obj)));
                        continue block23;
                    }
                    case 8: {
                        this.jniSetLong(buf, Double.doubleToLongBits(f.getDouble(obj)));
                        continue block23;
                    }
                    case 9: {
                        this.jniSetString(buf, (String)f.get(obj));
                        continue block23;
                    }
                    case 10: {
                        Date d = (Date)f.get(obj);
                        this.jniSetLong(buf, d != null ? d.getTime() : -1L);
                        continue block23;
                    }
                    case 11: {
                        this.jniSetBoolArray(buf, (boolean[])f.get(obj));
                        continue block23;
                    }
                    case 12: {
                        this.jniSetCharArray(buf, (char[])f.get(obj));
                        continue block23;
                    }
                    case 13: {
                        this.jniSetByteArray(buf, (byte[])f.get(obj));
                        continue block23;
                    }
                    case 14: {
                        this.jniSetShortArray(buf, (short[])f.get(obj));
                        continue block23;
                    }
                    case 15: {
                        this.jniSetIntArray(buf, (int[])f.get(obj));
                        continue block23;
                    }
                    case 16: {
                        this.jniSetLongArray(buf, (long[])f.get(obj));
                        continue block23;
                    }
                    case 17: {
                        this.jniSetFloatArray(buf, (float[])f.get(obj));
                        continue block23;
                    }
                    case 18: {
                        this.jniSetDoubleArray(buf, (double[])f.get(obj));
                        continue block23;
                    }
                    case 19: {
                        this.jniSetStringArray(buf, (String[])f.get(obj));
                        continue block23;
                    }
                    default: {
                        throw new CliException("Invalid field type: " + types[i]);
                    }
                }
            }
        }
        catch (Exception x) {
            throw new CliException(x.getMessage());
        }
        return buf;
    }

    @Override
    public void update(long oid, Object obj) {
        Class<?> c = obj.getClass();
        ClassDescriptor desc = (ClassDescriptor)this.classes.get(c);
        if (desc == null) {
            throw new CliException("Table not found: " + c);
        }
        this.jniUpdate(this.db, oid, desc.td, this.swizzleObject(desc, obj));
    }

    @Override
    public long insert(Object obj) {
        Class<?> c = obj.getClass();
        String table = c.getName();
        ClassDescriptor desc = (ClassDescriptor)this.classes.get(c);
        if (desc == null) {
            desc = new ClassDescriptor(c);
            this.classes.put(c, desc);
            desc.td = this.jniCreateTable(this.db, table, this.getTableDescriptor(desc));
        }
        return this.jniInsert(this.db, desc.td, this.swizzleObject(desc, obj));
    }

    @Override
    public int delete(Class table, String condition) {
        ClassDescriptor desc = (ClassDescriptor)this.classes.get(table);
        if (desc == null) {
            throw new CliException("Table not found: " + table);
        }
        return this.jniDelete(this.db, desc.td, condition);
    }

    @Override
    public void commit() {
        this.jniCommit(this.db);
    }

    @Override
    public void rollback() {
        this.jniRollback(this.db);
    }

    @Override
    public void lock() {
        this.jniLock(this.db);
    }

    @Override
    public void attach() {
        this.jniAttach(this.db);
    }

    @Override
    public void detach(int flags) {
        this.jniDetach(this.db, flags);
    }

    private long getTableDescriptor(ClassDescriptor desc) {
        String[] fieldNames = desc.getFieldNames();
        try {
            ConstraintParser constraintParser = new ConstraintParser(fieldNames, desc.getConstraints());
            return this.jniCreateTableDescriptor(this.db, desc.cls.getName(), fieldNames, desc.types, constraintParser.getReferencedTables(), constraintParser.getInverseFields(), constraintParser.getConstraintMasks());
        }
        catch (Exception x) {
            throw new CliException(x.getMessage());
        }
    }

    public void setThreadContext(long ctx) {
        this.jniSetThreadContext(this.db, ctx);
    }

    public long getThreadContext() {
        return this.jniGetThreadContext(this.db);
    }

    public DatabaseJNI() {
        this(false);
    }

    public DatabaseJNI(boolean remote) {
        this.remote = remote;
    }

    native long jniOpen(int var1, String var2, String var3, long var4, int var6);

    native void jniClose(long var1);

    native String jniNextTable(long var1);

    native void jniSetByte(long var1, byte var3);

    native void jniSetShort(long var1, short var3);

    native void jniSetInt(long var1, int var3);

    native void jniSetLong(long var1, long var3);

    native void jniSetString(long var1, String var3);

    native void jniSetBoolArray(long var1, boolean[] var3);

    native void jniSetCharArray(long var1, char[] var3);

    native void jniSetByteArray(long var1, byte[] var3);

    native void jniSetShortArray(long var1, short[] var3);

    native void jniSetIntArray(long var1, int[] var3);

    native void jniSetLongArray(long var1, long[] var3);

    native void jniSetFloatArray(long var1, float[] var3);

    native void jniSetDoubleArray(long var1, double[] var3);

    native void jniSetStringArray(long var1, String[] var3);

    native long jniCreateBuffer();

    native long jniCreateTable(long var1, String var3, long var4);

    native long jniUpdateTable(long var1, String var3, long var4);

    native long jniNext(long var1);

    native byte jniGetByte(long var1);

    native short jniGetShort(long var1);

    native int jniGetInt(long var1);

    native long jniGetLong(long var1);

    native String jniGetString(long var1);

    native boolean[] jniGetBoolArray(long var1);

    native char[] jniGetCharArray(long var1);

    native byte[] jniGetByteArray(long var1);

    native short[] jniGetShortArray(long var1);

    native int[] jniGetIntArray(long var1);

    native long[] jniGetLongArray(long var1);

    native float[] jniGetFloatArray(long var1);

    native double[] jniGetDoubleArray(long var1);

    native String[] jniGetStringArray(long var1);

    native void jniCloseCursor(long var1);

    native void jniUpdate(long var1, long var3, long var5, long var7);

    native long jniInsert(long var1, long var3, long var5);

    native long jniSelect(long var1, long var3, String var5);

    native int jniDelete(long var1, long var3, String var5);

    native int jniGetNumberOfSelectedRecords(long var1);

    native void jniCommit(long var1);

    native void jniRollback(long var1);

    native void jniLock(long var1);

    native long jniGetThreadContext(long var1);

    native void jniSetThreadContext(long var1, long var3);

    native void jniAttach(long var1);

    native void jniDetach(long var1, int var3);

    native long jniCreateTableDescriptor(long var1, String var3, String[] var4, int[] var5, String[] var6, String[] var7, int[] var8);

    static {
        Runtime.getRuntime().loadLibrary("jnicli");
    }
}

