/*
 * Decompiled with CFR 0.152.
 */
package jnicli;

import jnicli.CliException;

class ConstraintParser {
    int pos;
    String constraints;
    String[] fields;
    String[] inverseFields;
    String[] referencedTables;
    int[] constraintMasks;
    static final int INDEXED = 2;
    static final int CASE_INSENSITIVE = 8;
    static final int UNIQUE = 16;
    static final int AUTOINCREMENT = 32;
    static final int THICK = 64;

    String getToken() {
        int p;
        int len = this.constraints.length();
        for (p = this.pos; p < len && Character.isWhitespace(this.constraints.charAt(p)); ++p) {
        }
        if (p == len) {
            return null;
        }
        if (Character.isJavaIdentifierStart(this.constraints.charAt(p))) {
            int start = p;
            while (++p < len && (Character.isJavaIdentifierPart(this.constraints.charAt(p)) || this.constraints.charAt(p) == '.')) {
            }
            String tkn = this.constraints.substring(start, p);
            this.pos = p;
            return tkn;
        }
        ++this.pos;
        return this.constraints.substring(p, p + 1);
    }

    ConstraintParser(String[] fields, String constraints) {
        this.fields = fields;
        this.constraints = constraints;
        this.referencedTables = new String[fields.length];
        this.constraintMasks = new int[fields.length];
        this.parse();
    }

    void parse() {
        String tkn;
        block0: while ((tkn = this.getToken()) != null) {
            for (int i = 0; i < this.fields.length; ++i) {
                if (!tkn.equals(this.fields[i])) continue;
                tkn = this.getToken();
                while (tkn != null) {
                    if (tkn.equals(",")) continue block0;
                    if (tkn.equals("using")) {
                        while (!"index".equals(tkn = this.getToken())) {
                            if ("thick".equals(tkn)) {
                                int n = i;
                                this.constraintMasks[n] = this.constraintMasks[n] | 0x40;
                                continue;
                            }
                            if ("case_insensitive".equals(tkn)) {
                                int n = i;
                                this.constraintMasks[n] = this.constraintMasks[n] | 8;
                                continue;
                            }
                            throw new CliException("Unknown index constraint '" + tkn + "'");
                        }
                        int n = i;
                        this.constraintMasks[n] = this.constraintMasks[n] | 2;
                    } else if (tkn.equals("unique")) {
                        int n = i;
                        this.constraintMasks[n] = this.constraintMasks[n] | 0x10;
                    } else if (tkn.equals("autoincrement")) {
                        int n = i;
                        this.constraintMasks[n] = this.constraintMasks[n] | 0x20;
                    } else {
                        if (tkn.equals("references")) {
                            tkn = this.getToken();
                            if (tkn == null) {
                                throw new CliException("Referenced table name expected");
                            }
                            this.referencedTables[i] = tkn;
                            tkn = this.getToken();
                            if (!"(".equals(tkn)) continue;
                            tkn = this.getToken();
                            if (tkn == null) {
                                throw new CliException("Inverse field name expected");
                            }
                            this.inverseFields[i] = tkn;
                            tkn = this.getToken();
                            if (!")".equals(tkn)) {
                                throw new CliException("')' expected");
                            }
                            tkn = this.getToken();
                            continue;
                        }
                        throw new CliException("Unknown constraint '" + tkn + "'");
                    }
                    tkn = this.getToken();
                }
                return;
            }
            throw new CliException("Constrained field '" + tkn + "' not found in class");
        }
    }

    String[] getReferencedTables() {
        return this.referencedTables;
    }

    String[] getInverseFields() {
        return this.inverseFields;
    }

    int[] getConstraintMasks() {
        return this.constraintMasks;
    }
}

