/*
 * Decompiled with CFR 0.152.
 */
package jnicli;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Vector;
import jnicli.CliException;

class ClassDescriptor {
    Class cls;
    int[] types;
    Field[] fields;
    long td;
    Constructor constructor;
    static final Object[] bypassFlag = new Object[]{new Boolean(true)};
    static Method setBypass;
    static final Class[] constructorProfile;
    static final Object[] constructorParameters;

    Object newInstance() throws Exception {
        return this.constructor.newInstance(constructorParameters);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ClassDescriptor(Class c) {
        this.cls = c;
        Vector fieldList = new Vector();
        try {
            this.buildFieldList(c, fieldList);
        }
        catch (Exception x) {
            throw new CliException(x.getMessage());
        }
        this.fields = new Field[fieldList.size()];
        fieldList.copyInto(this.fields);
        this.types = new int[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            int cliType;
            Class<?> type;
            Field f = this.fields[i];
            if (setBypass != null) {
                try {
                    setBypass.invoke((Object)f, bypassFlag);
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            if ((type = f.getType()) == Byte.TYPE) {
                cliType = 3;
            } else if (type == Short.TYPE) {
                cliType = 4;
            } else if (type == Integer.TYPE) {
                cliType = 5;
            } else if (type == Boolean.TYPE) {
                cliType = 1;
            } else if (type == Character.TYPE) {
                cliType = 2;
            } else if (type == Long.TYPE) {
                cliType = 6;
            } else if (type == Float.TYPE) {
                cliType = 7;
            } else if (type == Double.TYPE) {
                cliType = 8;
            } else if (type == String.class) {
                cliType = 9;
            } else if (type == Date.class) {
                cliType = 10;
            } else {
                if (!type.isArray()) throw new CliException("Unsupported field type " + type.getName());
                if ((type = type.getComponentType()) == Boolean.TYPE) {
                    cliType = 11;
                } else if (type == Character.TYPE) {
                    cliType = 12;
                } else if (type == Byte.TYPE) {
                    cliType = 13;
                } else if (type == Short.TYPE) {
                    cliType = 14;
                } else if (type == Integer.TYPE) {
                    cliType = 15;
                } else if (type == Long.TYPE) {
                    cliType = 16;
                } else if (type == Float.TYPE) {
                    cliType = 17;
                } else if (type == Double.TYPE) {
                    cliType = 18;
                } else {
                    if (type != String.class) throw new CliException("Unsupported array type " + type.getName());
                    cliType = 19;
                }
            }
            this.types[i] = cliType;
        }
        try {
            this.constructor = c.getDeclaredConstructor(constructorProfile);
        }
        catch (Exception x) {
            throw new CliException("Default constructor is not accessible in class " + c.getName());
        }
        if (setBypass == null) return;
        try {
            setBypass.invoke((Object)this.constructor, bypassFlag);
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void buildFieldList(Class c, Vector list) throws Exception {
        Class superclass = c.getSuperclass();
        if (superclass != null) {
            this.buildFieldList(superclass, list);
        }
        Field[] flds = c.getDeclaredFields();
        for (int i = 0; i < flds.length; ++i) {
            Field f = flds[i];
            if ((f.getModifiers() & 0x88) != 0) continue;
            list.addElement(f);
        }
    }

    String getConstraints() throws Exception {
        StringBuffer buf = new StringBuffer();
        this.getConstraints(this.cls, buf);
        return buf.toString();
    }

    void getConstraints(Class c, StringBuffer buf) throws Exception {
        block7: {
            Class superclass = c.getSuperclass();
            if (superclass != null) {
                this.getConstraints(superclass, buf);
            }
            try {
                String constraints;
                Field f = c.getDeclaredField("CONSTRAINTS");
                if ((f.getModifiers() & 8) == 0) break block7;
                if (setBypass != null) {
                    try {
                        setBypass.invoke((Object)f, bypassFlag);
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                }
                if ((constraints = (String)f.get(null)) != null) {
                    buf.append(constraints);
                    buf.append(',');
                }
            }
            catch (NoSuchFieldException x) {
                // empty catch block
            }
        }
    }

    String[] getFieldNames() {
        String[] names = new String[this.fields.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.fields[i].getName();
        }
        return names;
    }

    static {
        constructorProfile = new Class[0];
        constructorParameters = new Object[0];
        try {
            Class<?> c = Class.forName("java.lang.reflect.AccessibleObject");
            Class[] param = new Class[]{Boolean.TYPE};
            setBypass = c.getMethod("setAccessible", param);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

