/*
 * Decompiled with CFR 0.152.
 */
package jnicli;

import java.util.NoSuchElementException;
import jnicli.ClassDescriptor;
import jnicli.CliException;
import jnicli.Cursor;
import jnicli.DatabaseJNI;

class IncrementalCursor
implements Cursor {
    DatabaseJNI db;
    long nextOid;
    long currOid;
    long cursor;
    ClassDescriptor desc;

    IncrementalCursor(DatabaseJNI db, long cursor, ClassDescriptor desc) {
        this.db = db;
        this.desc = desc;
        this.cursor = cursor;
        this.nextOid = db.jniNext(cursor);
    }

    @Override
    public int size() {
        return this.db.jniGetNumberOfSelectedRecords(this.cursor);
    }

    @Override
    public boolean hasMoreElements() {
        return this.nextOid != 0L;
    }

    @Override
    public Object nextElement() {
        if (this.nextOid == 0L) {
            throw new NoSuchElementException();
        }
        Object obj = this.db.unswizzleObject(this.cursor, this.desc);
        this.currOid = this.nextOid;
        this.nextOid = this.db.jniNext(this.cursor);
        return obj;
    }

    @Override
    public long getOid() {
        return this.currOid;
    }

    @Override
    public void update() {
        throw new CliException("Cursor not in update mode");
    }

    protected void finalize() {
        if (this.nextOid != 0L) {
            this.db.jniCloseCursor(this.cursor);
        }
    }
}

