/*
 * Copyright 2012 Sean Farley
 *
 * This guy called Sean wrote this sweet code. You are hereby granted
 * permission to do whatever you feel like doing with it on the understanding
 * that he's not responsible for anything that results from your use of this
 * sweet code.
 */

#include "fast-hg-common.h"

void go_up_one_dir(char* dir_path) {
  size_t k = 0;

  /* if we get here then the file doesn't exist, so try the next directory up */
  for (k = strlen(dir_path)-1; k+1; k--) {
    if (dir_path[k] == '/') { /* obviously won't work on windows ... but what does? */
      dir_path[k] = 0;        /* cheap hack in c: set an element of the
                                 character array to the null-terminator '\0'
                                 to mark the end of a new string */
      break;
    }
  }
}

int map(int (*apply)(const char*)) {
  char pwd[PATH_MAX+1], hg_path[PATH_MAX+1];
  size_t l=0;
  int denied=0;

  getcwd(pwd, PATH_MAX+1);

  while ((l = strlen(pwd)) > 0) {
    sprintf(hg_path, "%s/.hg", pwd);
    denied = access(hg_path, R_OK);

    if (!denied) return apply(pwd);

    go_up_one_dir(pwd);
  }

  return 0;
}

/* return 0 if successfully printed out from file */
int cat_file(const char *pwd, const char *file_name) {
  FILE *f;
  char full_path[PATH_MAX+1];
  char c = EOF;

  sprintf(full_path, "%s/%s", pwd, file_name);
  f = fopen(full_path, "r");

  if (f && (c=fgetc(f)) && c != EOF && c != '\n') { /* this checks for an empty file; probably a
                                                        little fragile, we should check for any
                                                        white space */
    putchar(c);

    while ((c = fgetc(f)) != EOF && c != '\n') putchar(c);

    fclose(f);

    return 0;
  }

  return -1;
}
