#include <stdio.h>
#include <stdlib.h> /* calloc() */
#include <string.h> /* strdup() */

#include "debug.h"
#include "links.h"

void dump_links(struct link_root_type *link_info, FILE *fout) {
   
    struct link_type *temp_link;
    int i;
    
    temp_link=link_info->head;
   
    for(i=0;i<link_info->count;i++) {
       fprintf(fout,"\t%i",temp_link->source);
       if (temp_link->sub_source) fprintf(fout,":%i",temp_link->sub_source);
       fprintf(fout," -> %i",temp_link->destination);
       if (temp_link->sub_destination) fprintf(fout,":%i",temp_link->sub_destination);
       if (temp_link->label!=NULL) fprintf(fout,"[label=\"%s\"]",temp_link->label);
       fprintf(fout,";");
       if (temp_link->comment!=NULL) fprintf(fout,"\t// %s",temp_link->comment);
       fprintf(fout,"\n");
       temp_link=temp_link->next;
    }
}

void free_links(struct link_root_type *link_info) {
    
    int i;
    struct link_type *temp_link,*next_link;
   
    temp_link=link_info->head;
    for(i=0;i<link_info->count;i++) {
       next_link=temp_link->next;
       if (temp_link->comment) free(temp_link->comment);
       if (temp_link->label) free(temp_link->label);
       free(temp_link);
       temp_link=next_link;
       
    }
   
}

void add_link(struct link_root_type *link_info,
	      int source, int sub_source,
	      int destination, int sub_destination,
	      char *label, char *comment) {
   
    struct link_type *temp_link;
    int i;

    if (link_info->count==0) {
       link_info->head=calloc(1,sizeof(struct link_type));
       temp_link=link_info->head;
    }
    else {
       temp_link=link_info->head;
       for(i=0;i<link_info->count-1;i++) {
	  temp_link=temp_link->next;
       }
       temp_link->next=calloc(1,sizeof(struct link_type));
       temp_link=temp_link->next;
    }
    
    temp_link->source=source;
    temp_link->sub_source=sub_source;
    
    temp_link->destination=destination;
    temp_link->sub_destination=sub_destination;
    
    if (label!=NULL) temp_link->label=strdup(label);
    else temp_link->label=NULL; 
   
    if (comment!=NULL) temp_link->comment=strdup(comment);
    else temp_link->comment=NULL;
   
    temp_link->next=NULL;
   
    link_info->count++;
    
}
