#include <stdio.h>
#include <stdlib.h> /* calloc() */

#include "debug.h"
#include "label.h"

struct label_lookup *label_table=NULL;

    /* If I were clever enough this would be done using a hash */
void add_label(int label, int line_number) {
   
    struct label_lookup *temp_label;
   
    if (label_table==NULL) {
       label_table=calloc(1,sizeof(struct label_lookup));
       temp_label=label_table;
    }
    else {
       temp_label=label_table;
       while (temp_label->next!=NULL) {
          if (label==temp_label->label) {
	     fprintf(stderr,"WARNING! Duplicate Label %i\n",label);
	  }
	  temp_label=temp_label->next;
       }
       temp_label->next=calloc(1,sizeof(struct label_lookup));
       temp_label=temp_label->next;
    }
    temp_label->label=label;
    temp_label->line_number=line_number;
    temp_label->next=NULL;
}
    /* Again, for perfomance should use hash */
int line_from_label(int label) {
   
   struct label_lookup *temp_label;
   
   temp_label=label_table;
   if (temp_label==NULL) {
      fprintf(stderr,"WARNING!  Looking into empty label tabel!\n");
      return -1;
   }
   
   while (temp_label->label!=label) {
      if (temp_label->next==NULL) break;
      else temp_label=temp_label->next;
   }
   
   if (temp_label->label==label) return temp_label->line_number;
   else return -1;
}

    /* Again, for perfomance should use hash */
int label_from_line(int line) {
   
   struct label_lookup *temp_label;
   
   temp_label=label_table;
   if (temp_label==NULL) {
      fprintf(stderr,"WARNING!  Looking into empty label tabel!\n");
      return -1;
   }
   
   while (temp_label->line_number < line) {
      if (temp_label->next==NULL) break;
      else temp_label=temp_label->next;
   }
   
   return temp_label->label;
   
}
   
