/*****************************************************************************/
/* EyeClock - A clock application for X. The eyes follow the mouse pointer.  */
/*                                                                           */
/* EyeClock Copyright (C) 1998-1999 Sakai Hiroaki.                           */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* EyeClock is a simple clock application for X11. You can put your favorite */
/* picture on the face of the clock. And you can move the eyes of the        */
/* picture following the mouse pointer.                                      */
/*                                                                           */
/* This file is a part of EyeClock.                                          */
/* EyeClock is FREE SOFTWARE. You can use, copy, modify, and/or redistribute */
/* it freely under the terms in the COPYRIGHT.                               */
/* See the COPYRIGHT for more details.                                       */
/*****************************************************************************/

/*****************************************************************************/
/* Hand å                                                         */
/* ()                                                                    */
/*===========================================================================*/
/* Υե                                                        */
/*---------------------------------------------------------------------------*/
/* ΥեϡåȤΤǤ                                  */
/*****************************************************************************/

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

#include "HandP.h"

/*****************************************************************************/
/* إåեΥ󥯥롼                                              */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/*                                                                 */
/*****************************************************************************/

#ifndef M_PI
#define M_PI 3.1415926535
#endif

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/* ѿ                                                            */
/*****************************************************************************/

/*===========================================================================*/
/* åȤΥ饹Τγ                                          */
/*===========================================================================*/

WidgetClass handWidgetClass = (WidgetClass)(&handClassRec);

/*===========================================================================*/
/* ꥽                                                            */
/*===========================================================================*/

static XtResource resources[] = {
  {XtNgeometry, XtCGeometry, XtRWidgetCorePart, sizeof(CorePart),
   XtOffsetOf(HandRec, core), XtRString, "0x0+0+0"},
  {XtNactive, XtCActive, XtRBoolean, sizeof(Boolean),
   XtOffsetOf(HandRec, hand.active), XtRString, "True"},

  {XtNtype, XtCType, XtRInt, sizeof(int),
   XtOffsetOf(HandRec, hand.type), XtRInt, (int)OTHER_TYPE},

  {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
   XtOffsetOf(HandRec, hand.foreground_pixel), XtRString, "Brown"},
  {XtNborderColor, XtCBorderColor, XtRPixel, sizeof(Pixel),
   XtOffsetOf(HandRec, core.border_pixel), XtRString, "Black"},
  {XtNborderWidth, XtCBorderWidth, XtRDimension, sizeof(Dimension),
   XtOffsetOf(HandRec, core.border_width), XtRString, "1"},
  {XtNwidth, XtCWidth, XtRDimension, sizeof(Dimension),
   XtOffsetOf(HandRec, core.width), XtRString, "0"},
  {XtNlength, XtCLength, XtRDimension, sizeof(Dimension),
   XtOffsetOf(HandRec, core.height), XtRString, "0"},

  {XtNfaceSize, XtCFaceSize, XtRInt, sizeof(int),
   XtOffsetOf(HandRec, hand.face_size), XtRString, "64"},
  {XtNfaceWidth, XtCFaceWidth, XtRInt, sizeof(int),
   XtOffsetOf(HandRec, hand.face_width), XtRString, "64"},
  {XtNfaceHeight, XtCFaceHeight, XtRInt, sizeof(int),
   XtOffsetOf(HandRec, hand.face_height), XtRString, "64"},
  {XtNratio, XtCRatio, XtRInt, sizeof(int),
   XtOffsetOf(HandRec, hand.ratio), XtRString, "100"},
  {XtNratioX, XtCRatioX, XtRInt, sizeof(int),
   XtOffsetOf(HandRec, hand.ratio_x), XtRString, "100"},
  {XtNratioY, XtCRatioY, XtRInt, sizeof(int),
   XtOffsetOf(HandRec, hand.ratio_y), XtRString, "100"}};

/*===========================================================================*/
/* åȤΥ饹                                                */
/*===========================================================================*/

static void ClassInitialize();
static void ClassPartInitialize(WidgetClass widgetClass);

static void Initialize();
static void Realize(Widget w, XtValueMask * value_mask,
		    XSetWindowAttributes * attrs);
static void Destroy(Widget w);
static void Resize(Widget w);
static void Redisplay(Widget w, XEvent * event, Region region);

HandClassRec handClassRec = {
  { /* core ե */
    &widgetClassRec,        /* ѡ饹 */
    "Hand",                 /* 饹̾ */
    sizeof(HandRec),        /*  */
    ClassInitialize,        /* 饹ν */
    NULL,                   /* class part ν */
    FALSE,                  /* class_inited */
    Initialize,             /* 󥹥󥹤ν */
    NULL,                   /* initialize_hook */
    Realize,                /* realize */
    NULL,                   /* actions */
    0,                      /* actions ο */
    resources,              /* ꥽ */
    XtNumber(resources),    /* ꥽ο */
    NULLQUARK,              /* xrm_class */
    TRUE,                   /* motion  */
    TRUE,                   /* exposure  */
    TRUE,                   /* enterleave  */
    FALSE,                  /* visible_interest */
    Destroy,                /* 󥹥󥹤κ */
    Resize,                 /* ꥵ */
    Redisplay,              /* ݡ */
    NULL,                   /* set_values */
    NULL,                   /* set_values_hook */
    NULL,                   /* set_values_almost */
    NULL,                   /* get_values_hook */
    NULL,                   /* accept_focus */
    XtVersion,              /* С */
    NULL,                   /* callback_offsets */
    NULL,                   /* tm_table */
    XtInheritQueryGeometry, /* query_geometry */
    NULL,                   /* display_accelerator */
    NULL                    /* extension */
  },
  { /* hand fields */
    0                       /* dummy */
  }
};

/*****************************************************************************/
/* ؿ                                                                */
/*****************************************************************************/

static void ClassInitialize()
{
  /* ꥽СϿ */
  XtSetTypeConverter(XtRString, XtRXPoint, ConvertStringToPoint, NULL, 0,
		     XtCacheNone, NULL);
  XtSetTypeConverter(XtRString, XtRWidgetCorePart, 
		     ConvertGeometryStringToPoint, NULL, 0,
		     XtCacheNone, NULL);
}

static void ClassPartInitialize(WidgetClass widgetClass) { /* None */ }

static void Initialize(Widget req, Widget new, ArgList args, Cardinal num)
{
  HandWidget hw = (HandWidget)new;
  Display * d;
  Window r;

  if (!hw->hand.active) return;

  d = XtDisplay(new);
  r = DefaultRootWindow(d);

  /* GC κ */
  hw->hand.hand_gc = XCreateGC(d, r, 0, 0);
  hw->hand.edge_gc = XCreateGC(d, r, 0, 0);
  XSetForeground(d, hw->hand.hand_gc, hw->hand.foreground_pixel);
  XSetForeground(d, hw->hand.edge_gc, new->core.border_pixel);
}

static void Realize(Widget w, XtValueMask * value_mask,
		    XSetWindowAttributes * attrs)
{
  HandWidget hw = (HandWidget)w;

  if (!hw->hand.active) return;

  /* Resize(w); */
}

static void Destroy(Widget w)
{
  HandWidget hw = (HandWidget)w;
  Display * d;

  if (!hw->hand.active) return;

  d = XtDisplay(w);

  if (hw->hand.hand_gc) {
    XFreeGC(d, hw->hand.hand_gc);
    hw->hand.hand_gc = 0;
  }
  if (hw->hand.edge_gc) {
    XFreeGC(d, hw->hand.edge_gc);
    hw->hand.edge_gc = 0;
  }
}

static void Resize(Widget w)
{
  HandWidget hw = (HandWidget)w;
  Display * d;

  if (!hw->hand.active) return;

  d = XtDisplay(w);

  XSetLineAttributes(d, hw->hand.hand_gc,
		     hw->hand.face_size * (int)hw->core.width
		     * hw->hand.ratio / 100 / 100,
		     LineSolid, CapRound, JoinMiter);
  XSetLineAttributes(d, hw->hand.edge_gc,
		     hw->hand.face_size * (int)hw->core.width
		     * hw->hand.ratio / 100 / 100 +
		     hw->hand.face_size * (int)hw->core.border_width
		     * hw->hand.ratio / 100 / 100,
		     LineSolid, CapRound, JoinMiter);
}

static void Redisplay(Widget w, XEvent * event, Region region)
{
  HandWidget hw = (HandWidget)w;

  if (!hw->hand.active) return;

  /* None */
}

/*===========================================================================*/
/* 饹Υ᥽åɤ                                                    */
/*===========================================================================*/

/*---------------------------------------------------------------------------*/
/*                                                                       */
/*---------------------------------------------------------------------------*/

void HandDraw(Widget w, Pixmap pixmap, XPoint center, time_t t)
{
  HandWidget hw = (HandWidget)w;
  struct tm * tblock;
  int hour, minute, second;
  double angle;
  int x0, y0, x1, y1;

  if (!hw->hand.active) return;

  if (!pixmap) return; /* 褬ʤ */

  tblock = localtime(&t);
  hour   = (int)(tblock->tm_hour);
  minute = (int)(tblock->tm_min);
  second = (int)(tblock->tm_sec);

  /* Ӥγ٤η׻ */
  switch (hw->hand.type) {
  case SECOND_HAND :
    angle = ( 6.0 * second                - 90.0) * (M_PI / 180.0);
    break;
  case MINUTE_HAND :
    angle = ( 6.0 * minute + 0.1 * second - 90.0) * (M_PI / 180.0);
    break;
  case HOUR_HAND :
    angle = (30.0 * hour   + 0.5 * minute + (0.5/60.0) * second - 90.0)
      * (M_PI / 180.0);
    break;
  default :
    angle = -90.0 * (M_PI / 180.0);
  }

  /* פ濴κɸη׻ */
  x0 = center.x +
    (hw->hand.face_width /2 * (int)w->core.x / 100 * hw->hand.ratio_x / 100);
  y0 = center.y +
    (hw->hand.face_height/2 * (int)w->core.y / 100 * hw->hand.ratio_y / 100);

  /* Ӥüκɸη׻ */
  x1 = x0
    + (int)(hw->hand.face_size/2 * (int)w->core.height / 100 * cos(angle))
    * hw->hand.ratio / 100;
  y1 = y0
    + (int)(hw->hand.face_size/2 * (int)w->core.height / 100 * sin(angle))
    * hw->hand.ratio / 100;

  XDrawLine(XtDisplay(w), pixmap, hw->hand.edge_gc, x0, y0, x1, y1);
  XDrawLine(XtDisplay(w), pixmap, hw->hand.hand_gc, x0, y0, x1, y1);
}

/*****************************************************************************/
/* ޤ                                                                  */
/*****************************************************************************/

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
