/*****************************************************************************/
/* EyeClock - A clock application for X. The eyes follow the mouse pointer.  */
/*                                                                           */
/* EyeClock Copyright (C) 1998-1999 Sakai Hiroaki.                           */
/* All Rights Reserved.                                                      */
/*                                                                           */
/* EyeClock is a simple clock application for X11. You can put your favorite */
/* picture on the face of the clock. And you can move the eyes of the        */
/* picture following the mouse pointer.                                      */
/*                                                                           */
/* This file is a part of EyeClock.                                          */
/* EyeClock is FREE SOFTWARE. You can use, copy, modify, and/or redistribute */
/* it freely under the terms in the COPYRIGHT.                               */
/* See the COPYRIGHT for more details.                                       */
/*****************************************************************************/

/*****************************************************************************/
/* Eye å                                                          */
/* ()                                                                    */
/*===========================================================================*/
/* Υե                                                        */
/*---------------------------------------------------------------------------*/
/* ΥեϡåȤΤǤ                                  */
/*****************************************************************************/

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

#include "EyeP.h"

/*****************************************************************************/
/* إåեΥ󥯥롼                                              */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/*                                                                 */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

/* None */

/*****************************************************************************/
/* ѿ                                                            */
/*****************************************************************************/

/*===========================================================================*/
/* åȤΥ饹Τγ                                          */
/*===========================================================================*/

WidgetClass eyeWidgetClass = (WidgetClass)(&eyeClassRec);

/*===========================================================================*/
/* ꥽                                                            */
/*===========================================================================*/

static XtResource resources[] = {
  {XtNgeometry, XtCGeometry, XtRWidgetCorePart, sizeof(CorePart),
   XtOffsetOf(EyeRec, core), XtRString, "0x0+0+0"},
  {XtNactive, XtCActive, XtRBoolean, sizeof(Boolean),
   XtOffsetOf(EyeRec, eye.active), XtRString, "True"},

  {XtNfillColor, XtCFillColor, XtRBoolean, sizeof(Boolean),
   XtOffsetOf(EyeRec, eye.fill_color), XtRString, "False"},
  {XtNfillPixmap, XtCFillPixmap, XtRBoolean, sizeof(Boolean),
   XtOffsetOf(EyeRec, eye.fill_pixmap), XtRString, "False"},
  {XtNbackground, XtCBackground, XtRPixel, sizeof(Pixel),
   XtOffsetOf(EyeRec, core.background_pixel), XtRString, "White"},
  {XtNmove, XtCMove, XtRXPoint, sizeof(XPoint),
   XtOffsetOf(EyeRec, eye.move), XtRString, "100x100"},
  {XtNlimit, XtCLimit, XtRXPoint, sizeof(XPoint),
   XtOffsetOf(EyeRec, eye.limit), XtRString, "75x75"},
  {XtNoffset, XtCOffset, XtRXPoint, sizeof(XPoint),
   XtOffsetOf(EyeRec, eye.offset), XtRString, "0x0"},

  {XtNcoreFigure, XtCCoreFigure, XtRPixmap, sizeof(Pixmap),
   XtOffsetOf(EyeRec, eye.core_figure), XtRString, "None"},
  {XtNcoreMask, XtCCoreMask, XtRPixmap, sizeof(Pixmap),
   XtOffsetOf(EyeRec, eye.core_mask), XtRString, "None"},
  {XtNeyeFigure, XtCEyeFigure, XtRPixmap, sizeof(Pixmap),
   XtOffsetOf(EyeRec, eye.eye_figure), XtRString, "None"},
  {XtNeyeMask, XtCEyeMask, XtRPixmap, sizeof(Pixmap),
   XtOffsetOf(EyeRec, eye.eye_mask), XtRString, "None"},

  {XtNcoreSize, XtCCoreSize, XtRXPoint, sizeof(XPoint),
   XtOffsetOf(EyeRec, eye.core_size), XtRString, "0x0"},
  {XtNeyeSize, XtCEyeSize, XtRXPoint, sizeof(XPoint),
   XtOffsetOf(EyeRec, eye.eye_size), XtRString, "0x0"},

  {XtNfaceSize, XtCFaceSize, XtRInt, sizeof(int),
   XtOffsetOf(EyeRec, eye.face_size), XtRString, "64"},
  {XtNfaceWidth, XtCFaceWidth, XtRInt, sizeof(int),
   XtOffsetOf(EyeRec, eye.face_width), XtRString, "64"},
  {XtNfaceHeight, XtCFaceHeight, XtRInt, sizeof(int),
   XtOffsetOf(EyeRec, eye.face_height), XtRString, "64"},
  {XtNratio, XtCRatio, XtRInt, sizeof(int),
   XtOffsetOf(EyeRec, eye.ratio), XtRString, "100"},
  {XtNratioX, XtCRatioX, XtRInt, sizeof(int),
   XtOffsetOf(EyeRec, eye.ratio_x), XtRString, "100"},
  {XtNratioY, XtCRatioY, XtRInt, sizeof(int),
   XtOffsetOf(EyeRec, eye.ratio_y), XtRString, "100"}};

/*===========================================================================*/
/* åȤΥ饹                                                */
/*===========================================================================*/

static void ClassInitialize();
static void ClassPartInitialize(WidgetClass widgetClass);

static void Initialize();
static void Realize(Widget w, XtValueMask * value_mask,
		    XSetWindowAttributes * attrs);
static void Destroy(Widget w);
static void Resize(Widget w);
static void Redisplay(Widget w, XEvent * event, Region region);

EyeClassRec eyeClassRec = {
  { /* core ե */
    &widgetClassRec,        /* ѡ饹 */
    "Eye",                  /* 饹̾ */
    sizeof(EyeRec),         /*  */
    ClassInitialize,        /* 饹ν */
    NULL,                   /* class part ν */
    FALSE,                  /* class_inited */
    Initialize,             /* 󥹥󥹤ν */
    NULL,                   /* initialize_hook */
    Realize,                /* realize */
    NULL,                   /* actions */
    0,                      /* actions ο */
    resources,              /* ꥽ */
    XtNumber(resources),    /* ꥽ο */
    NULLQUARK,              /* xrm_class */
    TRUE,                   /* motion  */
    TRUE,                   /* exposure  */
    TRUE,                   /* enterleave  */
    FALSE,                  /* visible_interest */
    Destroy,                /* 󥹥󥹤κ */
    Resize,                 /* ꥵ */
    Redisplay,              /* ݡ */
    NULL,                   /* set_values */
    NULL,                   /* set_values_hook */
    NULL,                   /* set_values_almost */
    NULL,                   /* get_values_hook */
    NULL,                   /* accept_focus */
    XtVersion,              /* С */
    NULL,                   /* callback_offsets */
    NULL,                   /* tm_table */
    XtInheritQueryGeometry, /* query_geometry */
    NULL,                   /* display_accelerator */
    NULL                    /* extension */
  },
  { /* eye ե */
    0                       /* dummy */
  }
};

/*****************************************************************************/
/* ؿ                                                                */
/*****************************************************************************/

static void ClassInitialize()
{
  /* ꥽СϿ */
  XtSetTypeConverter(XtRString, XtRXPoint, ConvertStringToPoint,
		     NULL, 0, XtCacheNone, NULL);
  XtSetTypeConverter(XtRString, XtRBitmap, ConvertStringToPixmap,
                     NULL, 0, XtCacheNone, NULL);
  XtSetTypeConverter(XtRString, XtRPixmap, ConvertStringToPixmap,
		     NULL, 0, XtCacheNone, NULL);
  XtSetTypeConverter(XtRPixmapData, XtRPixmap, ConvertPixmapDataToPixmap,
		     NULL, 0, XtCacheNone, NULL);
  XtSetTypeConverter(XtRString, XtRWidgetCorePart, 
		     ConvertGeometryStringToPoint, NULL, 0,
		     XtCacheNone, NULL);
}

static void ClassPartInitialize(WidgetClass widgetClass) { /* None */ }

static void Initialize(Widget req, Widget new, ArgList args, Cardinal num)
{
  EyeWidget ew = (EyeWidget)new;
  Display * d;
  Window r;

  if (!ew->eye.active) return;

  d = XtDisplay(new);
  r = DefaultRootWindow(d);

  if (!ew->eye.core_figure && !ew->eye.eye_figure) {
    ew->eye.active = False;
    return;
  }

  if (ew->eye.core_figure) {
    if (ew->eye.core_size.x <=0 )
      ew->eye.core_size.x = GetWidth( d, ew->eye.core_figure);

    if (ew->eye.core_size.y <= 0)
      ew->eye.core_size.y = GetHeight(d, ew->eye.core_figure);

    if ((ew->eye.core_size.x != GetWidth( d, ew->eye.core_figure)) ||
	(ew->eye.core_size.y != GetHeight(d, ew->eye.core_figure))) {
      ew->eye.core_figure = ResizePixmap(d, r, ew->eye.core_figure,
					 ew->eye.core_size.x,
					 ew->eye.core_size.y);
    }
  }

  if (ew->eye.eye_figure) {
    if (ew->eye.eye_size.x <= 0)
      ew->eye.eye_size.x =
	new->core.width  ? new->core.width  : GetWidth( d, ew->eye.eye_figure);

    if (ew->eye.eye_size.y <= 0)
      ew->eye.eye_size.y =
	new->core.height ? new->core.height : GetHeight(d, ew->eye.eye_figure);

    new->core.width  = ew->eye.eye_size.x;
    new->core.height = ew->eye.eye_size.y;

    if ((ew->eye.eye_size.x != GetWidth( d, ew->eye.eye_figure)) ||
	(ew->eye.eye_size.y != GetHeight(d, ew->eye.eye_figure))) {
      ew->eye.eye_figure = ResizePixmap(d, r, ew->eye.eye_figure,
					ew->eye.eye_size.x,
					ew->eye.eye_size.y);
    }
  }

  /* GC κ */
  ew->eye.gc_fill        = XCreateGC(d, DefaultRootWindow(d), 0, 0);
  ew->eye.gc_black       = XCreateGC(d, DefaultRootWindow(d), 0, 0);
  ew->eye.gc_white       = XCreateGC(d, DefaultRootWindow(d), 0, 0);
  ew->eye.gc_copy_copy   = XCreateGC(d, DefaultRootWindow(d), 0, 0);
  ew->eye.gc_copy_and    = XCreateGC(d, DefaultRootWindow(d), 0, 0);
  ew->eye.gc_copy_andinv = XCreateGC(d, DefaultRootWindow(d), 0, 0);
  ew->eye.gc_copy_or     = XCreateGC(d, DefaultRootWindow(d), 0, 0);

  XSetForeground(d, ew->eye.gc_fill, new->core.background_pixel);
  XSetForeground(d, ew->eye.gc_black, BlackPixel(d, DefaultScreen(d)));
  XSetForeground(d, ew->eye.gc_white, WhitePixel(d, DefaultScreen(d)));
  XSetFunction(d, ew->eye.gc_copy_copy,   GXcopy);
  XSetFunction(d, ew->eye.gc_copy_and,    GXand);
  XSetFunction(d, ew->eye.gc_copy_andinv, GXandInverted);
  XSetFunction(d, ew->eye.gc_copy_or,     GXor);

  /* ޥ̵ˤϡưŪ˺ */
  if (ew->eye.core_figure) {
    if (!ew->eye.core_mask)
      ew->eye.core_mask = CreateMaskPixmap(d, r, ew->eye.core_figure,
					   ew->eye.gc_black, ew->eye.gc_white);
    if (ew->eye.core_mask) {
      if ((GetWidth( d, ew->eye.core_mask) != ew->eye.core_size.x) ||
	  (GetHeight(d, ew->eye.core_mask) != ew->eye.core_size.y))
	ew->eye.core_mask = ResizePixmap(d, r, ew->eye.core_mask,
					 ew->eye.core_size.x,
					 ew->eye.core_size.y);
      XCopyArea(d, ew->eye.core_mask, ew->eye.core_figure,
		ew->eye.gc_copy_andinv,
		0, 0, ew->eye.core_size.x, ew->eye.core_size.y, 0, 0);
    }
  }

  if (ew->eye.eye_figure) {
    if (!ew->eye.eye_mask)
      ew->eye.eye_mask = CreateMaskPixmap(d, r, ew->eye.eye_figure,
					  ew->eye.gc_black, ew->eye.gc_white);
    if (ew->eye.eye_mask) {
      if ((GetWidth( d, ew->eye.eye_mask) != ew->eye.eye_size.x) ||
	  (GetHeight(d, ew->eye.eye_mask) != ew->eye.eye_size.y))
	ew->eye.eye_mask = ResizePixmap(d, r, ew->eye.eye_mask,
					ew->eye.eye_size.x,
					ew->eye.eye_size.y);
      XCopyArea(d, ew->eye.eye_mask, ew->eye.eye_figure,
		ew->eye.gc_copy_andinv,
		0, 0, ew->eye.eye_size.x, ew->eye.eye_size.y, 0, 0);
    }
  }

  ew->eye.resized_core_figure = 0;
  ew->eye.resized_core_mask   = 0;
  ew->eye.resized_eye_figure  = 0;
  ew->eye.resized_eye_mask    = 0;
  ew->eye.work_figure         = 0;
  ew->eye.work_mask           = 0;
}

static void Realize(Widget w, XtValueMask * value_mask,
		    XSetWindowAttributes * attrs)
{
  EyeWidget ew = (EyeWidget)w;

  if (!ew->eye.active) return;

  /* if (!ew->eye.resized_core_figure) Resize(w); */
}

static void Destroy(Widget w)
{
  EyeWidget ew = (EyeWidget)w;
  Display * d;

  if (!ew->eye.active) return;

  d = XtDisplay(w);

  if (ew->eye.gc_fill) {
    XFreeGC(d, ew->eye.gc_fill);
    ew->eye.gc_fill = 0;
  }
  if (ew->eye.gc_black) {
    XFreeGC(d, ew->eye.gc_black);
    ew->eye.gc_black = 0;
  }
  if (ew->eye.gc_white) {
    XFreeGC(d, ew->eye.gc_white);
    ew->eye.gc_white = 0;
  }
  if (ew->eye.gc_copy_copy) {
    XFreeGC(d, ew->eye.gc_copy_copy);
    ew->eye.gc_copy_copy = 0;
  }
  if (ew->eye.gc_copy_and) {
    XFreeGC(d, ew->eye.gc_copy_and);
    ew->eye.gc_copy_and = 0;
  }
  if (ew->eye.gc_copy_andinv) {
    XFreeGC(d, ew->eye.gc_copy_andinv);
    ew->eye.gc_copy_andinv = 0;
  }
  if (ew->eye.gc_copy_or) {
    XFreeGC(d, ew->eye.gc_copy_or);
    ew->eye.gc_copy_or = 0;
  }

  if (ew->eye.core_figure) {
    XFreePixmap(d, ew->eye.core_figure);
    ew->eye.core_figure = 0;
  }
  if (ew->eye.core_mask) {
    XFreePixmap(d, ew->eye.core_mask);
    ew->eye.core_mask = 0;
  }
  if (ew->eye.eye_figure) {
    XFreePixmap(d, ew->eye.eye_figure);
    ew->eye.eye_figure = 0;
  }
  if (ew->eye.eye_mask) {
    XFreePixmap(d, ew->eye.eye_mask);
    ew->eye.eye_mask = 0;
  }

  if (ew->eye.resized_core_figure) {
    XFreePixmap(d, ew->eye.resized_core_figure);
    ew->eye.resized_core_figure = 0;
  }
  if (ew->eye.resized_core_mask) {
    XFreePixmap(d, ew->eye.resized_core_mask);
    ew->eye.resized_core_mask = 0;
  }
  if (ew->eye.resized_eye_figure) {
    XFreePixmap(d, ew->eye.resized_eye_figure);
    ew->eye.resized_eye_figure = 0;
  }
  if (ew->eye.resized_eye_mask) {
    XFreePixmap(d, ew->eye.resized_eye_mask);
    ew->eye.resized_eye_mask = 0;
  }
  if (ew->eye.work_figure) {
    XFreePixmap(d, ew->eye.work_figure);
    ew->eye.work_figure = 0;
  }
  if (ew->eye.work_mask) {
    XFreePixmap(d, ew->eye.work_mask);
    ew->eye.work_mask = 0;
  }
}

static void Resize(Widget w)
{
  EyeWidget ew = (EyeWidget)w;
  Display * d;
  Window r;
  int width, height;

  if (!ew->eye.active) return;

  d = XtDisplay(w);
  r = DefaultRootWindow(d);

  if (ew->eye.resized_core_figure) {
    XFreePixmap(d, ew->eye.resized_core_figure);
    ew->eye.resized_core_figure = 0;
  }
  if (ew->eye.resized_core_mask) {
    XFreePixmap(d, ew->eye.resized_core_mask);
    ew->eye.resized_core_mask = 0;
  }
  if (ew->eye.resized_eye_figure) {
    XFreePixmap(d, ew->eye.resized_eye_figure);
    ew->eye.resized_eye_figure = 0;
  }
  if (ew->eye.resized_eye_mask) {
    XFreePixmap(d, ew->eye.resized_eye_mask);
    ew->eye.resized_eye_mask = 0;
  }
  if (ew->eye.work_figure) {
    XFreePixmap(d, ew->eye.work_figure);
    ew->eye.work_figure = 0;
  }
  if (ew->eye.work_mask) {
    XFreePixmap(d, ew->eye.work_mask);
    ew->eye.work_mask = 0;
  }

  width  = ew->eye.core_size.x * ew->eye.ratio_x / 100;
  height = ew->eye.core_size.y * ew->eye.ratio_y / 100;

  ew->eye.resized_core_figure = (width>0 && height>0 && ew->eye.core_figure)
    ? CreateResizedPixmap(d, r, ew->eye.core_figure, width, height) : 0;
  ew->eye.resized_core_mask   = (width>0 && height>0 && ew->eye.core_mask)
    ? CreateResizedPixmap(d, r, ew->eye.core_mask  , width, height) : 0;

  ew->eye.resized_core_width  = width;
  ew->eye.resized_core_height = height;

  width  = ew->eye.eye_size.x * ew->eye.ratio_x / 100;
  height = ew->eye.eye_size.y * ew->eye.ratio_y / 100;

  ew->eye.resized_eye_figure = (width>0 && height>0 && ew->eye.eye_figure)
    ? CreateResizedPixmap(d, r, ew->eye.eye_figure, width, height) : 0;
  ew->eye.resized_eye_mask   = (width>0 && height>0 && ew->eye.eye_mask)
    ? CreateResizedPixmap(d, r, ew->eye.eye_mask  , width, height) : 0;

  ew->eye.work_figure = (width>0 && height>0)
    ? XCreatePixmap(d, r, width,height, DefaultDepth(d,DefaultScreen(d))) : 0;
  ew->eye.work_mask   = (width>0 && height>0)
    ? XCreatePixmap(d, r, width,height, DefaultDepth(d,DefaultScreen(d))) : 0;

  ew->eye.resized_eye_width  = width;
  ew->eye.resized_eye_height = height;
}

static void Redisplay(Widget w, XEvent * event, Region region)
{
  EyeWidget ew = (EyeWidget)w;

  if (!ew->eye.active) return;

  /* None */
}

/*===========================================================================*/
/* 饹Υ᥽åɤ                                                    */
/*===========================================================================*/

/*---------------------------------------------------------------------------*/
/*                                                                       */
/*---------------------------------------------------------------------------*/

void EyeDraw(Widget w, Pixmap pixmap, XPoint pointer)
{
  EyeWidget ew = (EyeWidget)w;
  Display * d;
  int x, y; /* ԥåޥå׾Ǥ(eye)ΰ */
  int px, py; /* ݥ󥿤ˤܤΰưΥη׻ */
  int eye_w, eye_h; /* (eye)ΥԥåޥåפΥ */
  int eye_cx, eye_cy; /* (eye)濴κɸ */
  int core_w, core_h; /* ܶ(core)ΥԥåޥåפΥ */
  int disp_w, disp_h; /* ǥץ쥤ȹ⤵ */
  int limit_x, limit_y; /* ܤΰư */
  Pixmap * figure;
  Pixmap * mask;

  if (!ew->eye.active) return;

  if (!pixmap) return; /* 褬ʤ */

  d = XtDisplay(w);

  /* ǥץ쥤ȹ⤵ */
  disp_w = DisplayWidth( d, DefaultScreen(d));
  disp_h = DisplayHeight(d, DefaultScreen(d));

  /* ܶ(core)ΥԥåޥåפΥ */
  if (ew->eye.resized_core_figure) {
    core_w = ew->eye.resized_core_width;
    core_h = ew->eye.resized_core_height;
  } else {
    core_w = 0;
    core_h = 0;
  }

  /* (eye)ΥԥåޥåפΥ */
  if (ew->eye.resized_eye_figure) {
    eye_w = ew->eye.resized_eye_width;
    eye_h = ew->eye.resized_eye_height;
  } else { /* eye_figure ̵ˤ⡤̤ܶư褦ˤ뤿 */
    eye_w = core_w;
    eye_h = core_h;
  }

  eye_cx = eye_w / 2;
  eye_cy = eye_h / 2;

  /* ܤΰ֤η׻ */
  x = (int)w->core.x * ew->eye.ratio_x / 100;
  y = (int)w->core.y * ew->eye.ratio_y / 100;

  /* ݥ󥿤ˤܤΰưΥη׻ */
  if (ew->eye.move.x >= 0)
    px = (pointer.x - (x + eye_cx))
      * ew->eye.move.x / 100 * ew->eye.limit.x / 100 * (eye_w/2) / disp_w
      + ew->eye.offset.x;
  else
    px = (pointer.x - (x + eye_cx)) + ew->eye.offset.x;

  if (ew->eye.move.y >= 0)
    py = (pointer.y - (y + eye_cy))
      * ew->eye.move.y / 100 * ew->eye.limit.y / 100 * (eye_h/2) / disp_h
      + ew->eye.offset.y;
  else
    py = (pointer.y - (y + eye_cy)) + ew->eye.offset.y;

  /* ܤΰư¤ */
  if (ew->eye.limit.x >= 0) {
    limit_x = eye_w/2 * ew->eye.limit.x / 100;
    if      (px < -limit_x) px = -limit_x;
    else if (px >  limit_x) px =  limit_x;
  }
  if (ew->eye.limit.y >= 0) {
    limit_y = eye_h/2 * ew->eye.limit.y / 100;
    if      (py < -limit_y) py = -limit_y;
    else if (py >  limit_y) py =  limit_y;
  }

  if (ew->eye.eye_figure == 0) {

    /* eye_figure ̵ˤϡΤޤĥդ */

    if (ew->eye.resized_core_mask)
      XCopyArea(d, ew->eye.resized_core_mask, pixmap,
		ew->eye.gc_copy_and, 0, 0, core_w, core_h, x + px, y + py);
    if (ew->eye.resized_core_figure)
      XCopyArea(d, ew->eye.resized_core_figure, pixmap,
		ew->eye.gc_copy_or , 0, 0, core_w, core_h, x + px, y + py);

  } else {

    figure = NULL;
    mask   = NULL;

    /* ԥåޥåפκ */
    if (ew->eye.work_figure) {

      if (!ew->eye.fill_color && !ew->eye.fill_pixmap)
	XFillRectangle(d, ew->eye.work_figure, ew->eye.gc_black,
		       0, 0, eye_w, eye_h);
      else {
	if (ew->eye.fill_color)
	  XFillRectangle(d, ew->eye.work_figure, ew->eye.gc_fill,
			 0, 0, eye_w, eye_h);
	if (ew->eye.fill_pixmap) {
	  if (ew->eye.fill_color)
	    XCopyArea(d, ew->eye.resized_eye_figure, ew->eye.work_figure,
		      ew->eye.gc_copy_or, 0, 0, eye_w, eye_h, 0, 0);
	  else
	    XCopyArea(d, ew->eye.resized_eye_figure, ew->eye.work_figure,
		      ew->eye.gc_copy_copy, 0, 0, eye_w, eye_h, 0, 0);
	}
	if (ew->eye.resized_core_mask)
	  XCopyArea(d, ew->eye.resized_core_mask, ew->eye.work_figure,
		    ew->eye.gc_copy_and, 0, 0, core_w, core_h,
		    eye_cx - core_w/2 + px, eye_cy - core_h/2 + py);
      }

      if (ew->eye.resized_core_figure)
	XCopyArea(d, ew->eye.resized_core_figure, ew->eye.work_figure,
		  ew->eye.gc_copy_or, 0, 0, core_w, core_h,
		  eye_cx - core_w/2 + px, eye_cy - core_h/2 + py);

      if (ew->eye.resized_eye_mask)
	XCopyArea(d, ew->eye.resized_eye_mask, ew->eye.work_figure,
		  ew->eye.gc_copy_andinv, 0, 0, eye_w, eye_h, 0, 0);

      figure = &(ew->eye.work_figure);
    }

    /* ޥκ */
    if (ew->eye.work_mask) {

      if (ew->eye.fill_color || ew->eye.fill_pixmap) {
	if (ew->eye.resized_eye_mask)
	  mask = &(ew->eye.resized_eye_mask);
	/*
	  XCopyArea(d, ew->eye.resized_eye_mask, ew->eye.work_mask,
	  ew->eye.gc_copy_copy, 0, 0, eye_w, eye_h, 0, 0);
	  */
      } else {
	XFillRectangle(d, ew->eye.work_mask, ew->eye.gc_white,
		       0, 0, eye_w, eye_h);
	if (ew->eye.resized_core_mask)
	  XCopyArea(d, ew->eye.resized_core_mask, ew->eye.work_mask,
		    ew->eye.gc_copy_and, 0, 0, core_w, core_h,
		    eye_cx - core_w/2 + px, eye_cy - core_h/2 + py);
	if (ew->eye.resized_eye_mask)
	  XCopyArea(d, ew->eye.resized_eye_mask, ew->eye.work_mask,
		    ew->eye.gc_copy_or, 0, 0, eye_w, eye_h, 0, 0);
	mask = &(ew->eye.work_mask);
      }
    }

    /*  */
    if (mask)
      XCopyArea(d, *mask, pixmap, ew->eye.gc_copy_and,
		0, 0, eye_w, eye_h, x, y);
    if (figure)
      XCopyArea(d, *figure, pixmap, ew->eye.gc_copy_or,
		0, 0, eye_w, eye_h, x, y);
  }
}

/*****************************************************************************/
/* ޤ                                                                  */
/*****************************************************************************/

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
