#!/usr/bin/gawk -f

#
# Copyright(C) 2007-2012 National Institute of Information and Communications Technology
#

# ʸ(EUC-JP)Ȳ

BEGIN {
  FS = "\t";

  if (ARGC < 1) {
    printf "usage: %s [<*.tsv>]\n", SCRIPT > "/dev/stderr";
    EXIT = 1;
    exit EXIT;
  }


  type["+"] = 0;
  type["-"] = 0;
  type["٣"] = 0;
  type[""] = 0;
  type["˾+"] = 1;
  type["˾-"] = 1;
  type["˾"] = 1;
  type["˾"] = 1;
  type["+"] = 2;
  type["-"] = 2;
  type["ɾ+"] = 3;
  type["ɾ-"] = 3;
  type["+"] = 4;
  type["-"] = 4;
  type["å+"] = 5;
  type["å-"] = 5;
  type["+"] = 6;
  type["-"] = 6;
}

{
#Կ򥫥
  nlines++;

  cls = type[$1];
  xpr = $2;
  sen = $3;
  mrp = $4;

  n = ma(mrp, surf, base, cpos, fpos);

  # ɾɽνиս
  p = position(sen, n, surf, xpr, 0);
  if (p == -1) {
    showError("xpr !in sen");
    printf " = Line:%d\n", nlines > "/dev/stderr";
  }

  # Ϳ(trieõ)
  for (i = PSTART; i <= PEND; i++) pole[i] = "";
  nlist = lookup(n, surf, PSTART, PEND, trie_flg, trie_val, listv, listb, listl);
  for (i = 0; i < nlist; i++) {
    for (j = 0; j <= listl[i]; j++) {
      pole[listb[i] + j] = dicp[listv[i]];
    }
  }

  # 
  printf "%d", cls;

  # unigram
  for (i = 1; i <= n; i++) {
    printf " s=%s:1 b=%s:1 c=%s:1 f=%s:1", surf[i], base[i], cpos[i], fpos[i];
  }

  # unigram
  for (i = PSTART; i <= PEND; i++) {
    printf " S=%s:1 B=%s:1 C=%s:1 F=%s:1", surf[i], base[i], cpos[i], fpos[i];
  }
  # bigram
  for (i = PSTART; i <= PEND - 1; i++) {
    printf " SS=%s_%s:1 BB=%s_%s:1 CC=%s_%s:1 FF=%s_%s:1", surf[i], surf[i + 1], base[i], base[i + 1], cpos[i], cpos[i + 1], fpos[i], fpos[i + 1];
  }

  # unigram
  for (i = PEND + 1; i <= n; i++) {
    printf " Ss=%s:1 Bs=%s:1 Cs=%s:1 Fs=%s:1", surf[i], base[i], cpos[i], fpos[i];
  }

  # +и
  for (i = PSTART; i <= PEND - 1; i++) {
    if (pole[i] != "") printf " ps=%s_%s:1", pole[i], surf[i + 1];
    if (pole[i + 1] != "") printf " sp=%s_%s:1", surf[i], pole[i + 1];
  }

  # ñ
  for (i = 0; i < nlist; i++) {
    printf " dw=%s:1", dicw[listv[i]];
  }

  # ɾɽη
  printf " sz=%s:1 bz=%s:1 cz=%s:1 fz=%s:1", surf[PEND], base[PEND], cpos[PEND], fpos[PEND];

  printf "\n";
}
