/*
  Copyright(C) 2007-2012 National Institute of Information and Communications Technology
*/

/*
  svmtools
  Kernel module
*/


#ifndef _SVM_KERNEL_H_
#define _SVM_KERNEL_H_


#include "svm_common.h"


#define SVM_KFUNC_POLYNOMIAL_1O 4
#define SVM_KFUNC_POLYNOMIAL_2O 5
#define SVM_KFUNC_POLYNOMIAL_3O 6
#define SVM_KFUNC_POLYNOMIAL_4O 7
#define SVM_KFUNC_POLYNOMIAL_5O 8


/* ͥ׻Ѥκѥǡ */
typedef struct Svm_kwrk {
  int kfunc;	/* Ѥ륫ͥؿ */
  int num;	/* ׻оݤΥ٥ȥθĿ */
  SVM_SV **sv;	/* ؽ */
  float *sqnorm;	/* RBFͥ */
  float sqnorm2;	/* RBFͥ */
  int max;	/* ο */
  int *tbl;	/* ѷ׻Ѥκɽ */
  int *inv_eid;	/* ž֥ǥåλid */
  float *inv_val;	/* ž֥ǥåΥ٥ȥ */
} SVM_KWRK;

/* Kernel cache */
typedef struct Svm_kc {
  SVM_KPRM kprm;
  int col;	/* åο */
  int row;	/* åο(åιԿ) */
  int size;	/* åΥ */
  float *cache;	/* åǡ */
  int *e2r;	/* (idåι) */
  unsigned int *r2e;	/* պ(åιԢid)(Ǿ̥ӥåȤϻѥե饰) */
  int nxt;	/* clock algorithmǼĴ٤ */
  int *gen;	/* ƹԤ(ȤˤʤäƤĴԤ) */
  int hst_num;	/* ߤ */
  int *hst;	/* ޤǤ˺Ƥǥå */
  int *label;	/* ؽΥ٥ */
  SVM_KWRK *kwrk;	/* ѥǡ */
} SVM_KC;


SVM_KC *svm_knl_kcinit(SVM_KPRM *kprm, int num, int *label, SVM_SV **sv, int size);
void svm_knl_kcdelete(SVM_KC *kc);
float *svm_knl_kckernel(SVM_KC *kc, int p, float *rsv);
void svm_knl_kchide(SVM_KC *kc, int p);
void svm_knl_kcexpand(SVM_KC *kc);
SVM_KWRK *svm_knl_kwrkinit(SVM_KPRM *kprm, int num, SVM_SV **sv);
SVM_KWRK *svm_knl_kwrkinit_inv(SVM_KPRM *kprm, int num, SVM_SV **sv);
void svm_knl_kwrkdelete(SVM_KWRK *kwrk);
void svm_knl_kwrkkernel(SVM_KPRM *kprm, SVM_KWRK *kwrk, SVM_SV *v, float *q);


#endif
