/*
  Copyright(C) 2007-2012 National Institute of Information and Communications Technology
*/

/*
  svmtools
  Common module
*/


#ifndef _SVM_COMMON_H_
#define _SVM_COMMON_H_


#include <stdio.h>


#define SVM_KERNEL_LINEAR 0
#define SVM_KERNEL_POLYNOMIAL 1
#define SVM_KERNEL_RBF 2
#define SVM_KERNEL_SIGMOID 3


/* Kernel parameter */
typedef struct Svm_kprm {
  int ktype;	/* $B%+!<%M%k$N<oN`(B */
  float degree;	/* $B%+!<%M%k4X?t$N%Q%i%a!<%?(B */
  float gamma;	/* $B%+!<%M%k4X?t$N%Q%i%a!<%?(B */
  float coef;	/* $B%+!<%M%k4X?t$N%Q%i%a!<%?(B */
} SVM_KPRM;

/* Sparse vector */
typedef struct Svm_sv {
  int num;	/* $B%Y%/%H%k$NMWAG?t(B */
  int *idx;	/* $B%$%s%G%C%/%9(B */
  float *val;	/* $BCM(B(binary$B%b!<%I$G$OL$;HMQ(B) */
} SVM_SV;

/* Model data */
struct Svm_kwrk;
typedef struct Svm_mdl {
  SVM_KPRM kprm;	/* $B%+!<%M%k%Q%i%a!<%?(B */
  double *beta;	/* (alpha_i * y_i) */
  int num;	/* $B%5%]!<%H%Y%/%?!<?t(B */
  SVM_SV **sv;  /* $B%5%]!<%H%Y%/%?!<(B */
  double b;	/* b */
  float *reg;	/* $B7W;;7k2L$r3JG<$9$kG[Ns(B */
  struct Svm_kwrk *kwrk;	/* $B%+!<%M%k7W;;$N:n6HMQ(B */
} SVM_MDL;

/* Example */
typedef struct Svm_exm {
  int num;	/* $B;vNc?t(B */
  int *label;	/* $B%i%Y%k(B($BFsCMJ,N`$N>l9g$O(B-1$B$+(B+1) */
  SVM_SV **sv;	/* $BAG@-%Y%/%H%k(B */
} SVM_EXM;


SVM_EXM *svm_readexm(FILE *fp);
int svm_createmdl(SVM_KPRM *kprm, SVM_EXM *exm, double *alpha, double b, FILE *fp);
SVM_MDL *svm_readmdl(FILE *fp);
double svm_decision(SVM_MDL *mdl, SVM_SV *x);
int svm_readvec(FILE *fp, int *label, SVM_SV *svbuf, int *svbuf_size, SVM_SV *sv);


extern int svm_verbose;
extern int svm_invidx;


#endif
