/*
  Copyright(C) 2007-2012 National Institute of Information and Communications Technology
*/

/*
  Hashtable library
*/


#ifndef _HASHTABLE_H_
#define _HASHTABLE_H_


#include <stddef.h>


struct Ht;
typedef struct Ht HT;


HT *ht_new(int (*equal)(const void *, const void *), size_t (*hash)(const void *));
void ht_delete(HT *ht);
void ht_clear(HT *ht);
void *ht_get(HT *ht, const void *key);
int ht_put(HT *ht, void *key, void *val);
void *ht_remove(HT *ht, const void *key);
size_t strhash(const char *s);


typedef struct Sdb {
  size_t size;
  size_t num;
  char **tbl;
  HT *ht;
} SDB;


SDB *sdb_new(void);
void sdb_delete(SDB *sdb);
void sdb_clear(SDB *sdb);
char *sdb_str(SDB *sdb, int id);
#define sdb_str(sdb, id) ((sdb)->tbl[(id)])
int sdb_id(SDB *sdb, char *str, int add);
int sdb_put(SDB *sdb, char *str);
int sdb_size(SDB *sdb);
#define sdb_size(sdb) ((sdb)->num)


#endif
