#!/bin/sh

#
# Copyright(C) 2007-2012 National Institute of Information and Communications Technology
#

if [ $# -ne 3 ]
then
  echo "usage: svmtest.sh <*.ft> <*.svmmdl> <*.tsv> > <*.tsv>" 1>&2
  exit 1
fi

dir=`dirname $0`
tmp=${TMPDIR:-.}
exlib=${EXOPLIB:-.}
ftfile=$1
mdlfile=$2
tsvfile=$3
fvfile=$tmp/svmtest.$$.fv
svfile=$tmp/svmtest.$$.sv
outfile=$tmp/svmtest.$$.out

$dir/tsvconv.awk -f $exlib/utility.awk -v SCRIPT=$dir/tsvconv.awk $tsvfile | $dir/makefv.awk -f $exlib/utility.awk -v SCRIPT=$dir/makefv.awk > $fvfile
$dir/../svmtools/svm_fv2sv $ftfile < $fvfile > $svfile
$dir/../svmtools/svm_classify $svfile $mdlfile $outfile > /dev/null 2>&1
$dir/out2tsv.awk -f $exlib/utility.awk -v SCRIPT=$dir/out2tsv.awk $tsvfile $outfile

rm -f $fvfile $svfile $outfile
