#!/usr/bin/gawk -f

#
# Copyright(C) 2007-2012 National Institute of Information and Communications Technology
#

# EUC-JP¸뤳

BEGIN {
  FS = "\t";
  OFS = "\t";

  if (ARGC != 3) {
    printf "usage: %s <*.tsv> <*.out>\n", SCRIPT > "/dev/stderr";
    EXIT = 1;
    exit EXIT;
  }
  outfile = ARGV[2];
  ARGV[2] = "";
}

{
  if ($8 == "") {
    print;
    next;
  }

  n8 = split($8, a8, /\\n/);

  src = "";
  for (i = 1; i <= n8; i++) {
    if (getline y < outfile <= 0) error("unexpected EOF");
    s = (y > 0.0) ? "[]" : "[]";
    src = src "\\n" s;
  }
  src = substr(src, 3);
  $7 = src;
  print;
}

END {
  if (EXIT != "") exit EXIT;

  if (getline < outfile != 0) error("wrong *.out file");
}
