#!/bin/sh

#
# Copyright(C) 2007-2012 National Institute of Information and Communications Technology
#

crf_test=crf_test

if [ $# -ne 2 ]
then
  echo "usage: crftest.sh <*.crfmdl> <*.tsv>" 1>&2
  exit 1
fi

dir=`dirname $0`
tmp=${TMPDIR:-.}
exlib=${EXOPLIB:-.}
mdlfile=$1
tsvfile=$2
tagfile=$tmp/crftrain.$$.tag
otagfile=$tmp/crftrain.$$.otag

$dir/tsv2tag.awk -f $exlib/utility.awk -v SCRIPT=$dir/tsv2tag.awk $tsvfile > $tagfile
$crf_test -m $mdlfile $tagfile > $otagfile
$dir/otag2tsv.awk -f $exlib/utility.awk -v SCRIPT=$dir/otag2tsv.awk $tsvfile $otagfile

rm -f $tagfile $otagfile
