#!/usr/bin/gawk -f

#
# Copyright(C) 2007-2012 National Institute of Information and Communications Technology
#

BEGIN {
  FS = "\t";
  OFS = "\t";
}

{
  sen = $5;
  typ = $9;
  mrp = $10;
  dep = $11;
  nxpr = split($8, expr, /\\n/);
  ntyp = split($9, etyp, /\\n/);
  if (nxpr != ntyp) error("nxpr != ntyp");
  if ($8 == "") next;

  for (l = 1; l <= nxpr; l++) {
    xpr = expr[l];
    typ = etyp[l];

    pol = "";
    if (typ ~ /^/ || typ ~ /^˾/) {
      continue;
    } else if (typ ~ /+$/) {
      pol = "+1";
    } else if (typ ~ /-$/) {
      pol = "-1";
    } else {
      continue;
    }

    n = ma(mrp, surf, base, cpos, fpos);
    m = da(dep, bnst, head, type);

    # ɾɽʬβϷ̤Ф
    cbgn = eucindex(sen, xpr);
    if (cbgn == 0) continue;
    cend = cbgn + length(xpr) - 1;
    bbgn = 0;
    bend = 0;
    k = 0;
    for (i = 1; i <= m; i++) {
      for (j = bnst[i - 1]; j < bnst[i]; j++) {
	k += length(surf[j]);
	if (bbgn == 0) {
	  if (cbgn <= k) bbgn = i;
	}
	if (bbgn != 0 && bend == 0) {
	  if (cend <= k) bend = i;
	}
	if (bbgn != 0 && bend != 0) {
	  break;
	}
      }
    }

    if (bbgn == 0 || bend == 0) showError("fatal error 1");
    mbgn = bnst[bbgn - 1];
    mend = bnst[bend] - 1;
    #printf "# c:%d-%d, m:%d-%d, b:%d-%d\n", cbgn, cend, mbgn, mend, bbgn, bend > "/dev/stderr";

    surfall = "";
    baseall = "";
    cposall = "";
    fposall = "";
    for (i = mbgn; i <= mend; i++) {
      surfall = surfall " " surf[i];
      baseall = baseall " " base[i];
      cposall = cposall " " cpos[i];
      fposall = fposall " " fpos[i];
    }
    surfall = substr(surfall, 2);
    baseall = substr(baseall, 2);
    cposall = substr(cposall, 2);
    fposall = substr(fposall, 2);

    chnkall = "";
    headall = "";
    typeall = "";
    for (i = bbgn; i <= bend; i++) {
      typetmp = type[i];
      if (head[i] == 0 || i == bend) {
	headtmp = 0;
      } else {
	headtmp = head[i] - bbgn + 1;
	if (bend - bbgn + 1 < headtmp) {
	  headtmp = bend - bbgn + 1;
	  typetmp = "D";
	}
      }
      chnkall = chnkall " " (bnst[i - 1] - mbgn + 1);
      headall = headall " " headtmp;
      typeall = typeall " " typetmp;
    }
    chnkall = substr(chnkall, 2);
    headall = substr(headall, 2);
    typeall = substr(typeall, 2);

    printf "%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\n", pol, xpr, surfall, baseall, cposall, fposall, chnkall, headall, typeall;
  }
}
