/*
  Copyright(C) 2007-2012 National Institute of Information and Communications Technology
*/

/*
  Exception library
*/


#ifndef _EXCEPTION_H_
#define _EXCEPTION_H_


#include <stddef.h>


#define exception(bool, format, ...) exception_(__FILE__, __LINE__, bool, format ,##__VA_ARGS__)
#define smalloc(size) smalloc_(__FILE__, __LINE__, (size))
#define scalloc(nmemb, size) scalloc_(__FILE__, __LINE__, (nmemb), (size))
#define srealloc(ptr, size) srealloc_(__FILE__, __LINE__, (ptr), (size))
#define sstrdup(s) sstrdup_(__FILE__, __LINE__, (s))


void exception_(char *file, int line, int bool, char *format, ...);
void *scalloc_(char *file, int line, size_t nmemb, size_t size);
void *smalloc_(char *file, int line, size_t size);
void *srealloc_(char *file, int line, void *ptr, size_t size);
char *sstrdup_(char *file, int line, const char *s);


#endif
