#!/bin/env perl

#
# Copyright(C) 2007-2012 National Institute of Information and Communications Technology
#

use strict;
use warnings;

use tsv;
use utf8;
binmode STDIN,  ":encoding(euc-jp)";
binmode STDOUT, ":encoding(utf8)";
binmode STDERR, ":encoding(utf8)";
my $lineCount = 0;

while ( my $s = <STDIN> ) {

    # $B=hM}9T?t$r%$%s%/%j%a%s%H(B
    $lineCount++;

    chomp $s;
    my (
        $topic,     $sampleID, $documentID, $sentenceID, $sentence,
        $relevancy, $holder,   $expression, $type,       $morph,
        $depend,    $context,  $repr
    ) = split( "\t", $s );

    my $tsv = tsv->new(
        {
            topic      => $topic,
            documentID => $documentID,
            sentenceID => $sentenceID,
            sentence   => $sentence
        }
    );

    $tsv->setVal( { holder     => $holder } );
    $tsv->setVal( { relevancy  => $relevancy } );
    $tsv->setVal( { expression => $expression } );
    $tsv->setVal( { type       => $type } );
    if ( $tsv->checkTSV() == -1 ) {

        # $B%(%i!<9T?tI=<((B
        printf STDERR " = Line:%d\n", $lineCount;
    }
    else {
        $tsv->printOUT();
    }
}

