#!/bin/sh
#!/usr/bin/env perl
#!/usr/bin/env iconv

#
# Copyright(C) 2007-2012 National Institute of Information and Communications Technology
#

if [ $# -lt 1 -o  $# -gt 3  ]
then
    echo "Usage $0 file_name [topic_str]"
    exit -1;
fi

dir=`cd $(dirname $0) && pwd`
. $dir/conf.sh

export LANG=C
export LC_ALL=C
export EXOPLIB=$dir/lib
export EXOPDIC=$dir/dic

tmp=${TMPDIR:-.}
tsvfile=$tmp/extract.$$.tsv

#nkf -e -W --fb-skip < $1 > $1.euc
# $B;XDjJ8;z%3!<%I$O4D6-$K$h$C$FI=5-$,0c$&$?$a(Biconv -l$B$G3NG'(B
iconv -c -f UTF-8 -t EUC-JP < $1 > $1.euc
perl -I $EXOPLIB $EXOPLIB/in2tsv.pl $1.euc $2 > $tsvfile
$dir/_extract.sh $model $tsvfile | perl -I $EXOPLIB $EXOPLIB/tsv2out.pl

rm -f $tsvfile
