#!/bin/sh

#
# Copyright(C) 2007-2012 National Institute of Information and Communications Technology
#

if [ $# -ne 2 ]
then
  echo "usage: _extract.sh <model name> <*.tsv>" 1>&2
  exit 1
fi

dir=`cd $(dirname $0) && pwd`
tmp=${TMPDIR:-.}
xprmdlfile=$1".xpr_mdl"
srcftfile=$1".src_ft"
srcsvmmdlfile=$1".src_svmmdl"
srccrfmdlfile=$1".src_crfmdl"
typftfile=$1".typ_ft"
typmdlfile=$1".typ_mdl"
polmdlfile=$1".pol_mdl"
#scrftfile=$1".scr_ft"
#scrmdlfile=$1".scr_mdl"
tsvfile=$2
intsvfile=$tmp/test.$$.intsv
outtsvfile=$tmp/test.$$.outtsv

cp $tsvfile $intsvfile
$dir/xpr/extract.sh $xprmdlfile $intsvfile > $outtsvfile
cp $outtsvfile $intsvfile
$dir/src/extract.sh $srcftfile $srcsvmmdlfile $srccrfmdlfile $intsvfile > $outtsvfile
cp $outtsvfile $intsvfile
$dir/typ/extract.sh $typftfile $typmdlfile $intsvfile > $outtsvfile
cp $outtsvfile $intsvfile
$dir/pol/extract.sh $polmdlfile $intsvfile > $outtsvfile
#cp $outtsvfile $intsvfile
#$dir/scr/extract.sh $scrftfile $scrmdlfile $intsvfile > $outtsvfile
cat $outtsvfile

rm -f $intsvfile $outtsvfile
