module Data

(* This file has been automatically generated by EverParse. *)
open FStar.Bytes
module U8 = FStar.UInt8
module U16 = FStar.UInt16
module U32 = FStar.UInt32
module U64 = FStar.UInt64
module LP = LowParse.Spec.Base
module LS = LowParse.SLow.Base
module LPI = LowParse.Spec.AllIntegers
module LL = LowParse.Low.Base
module L = FStar.List.Tot
module B = LowStar.Buffer
module BY = FStar.Bytes
module HS = FStar.HyperStack
module HST = FStar.HyperStack.ST
module LWP = LowParse.Writers.Combinators

open Boolean

type data =
  | Payloads_TRUE of U32.t
  | Payloads_FALSE of U16.t

inline_for_extraction let tag_of_data (x:data) : boolean = match x with
  | Payloads_TRUE _ -> TRUE
  | Payloads_FALSE _ -> FALSE

inline_for_extraction noextract let data_parser_kind = LP.strong_parser_kind 3 5 None

noextract val data_parser: LP.parser data_parser_kind data

noextract val data_serializer: LP.serializer data_parser

noextract val data_bytesize (x:data) : GTot nat

noextract val data_bytesize_eq (x:data) : Lemma (data_bytesize x == Seq.length (LP.serialize data_serializer x))

val data_parser32: LS.parser32 data_parser

val data_serializer32: LS.serializer32 data_serializer

val data_size32: LS.size32 data_serializer

val data_validator: LL.validator data_parser

val data_jumper: LL.jumper data_parser

inline_for_extraction noextract let lwp_data = LWP.make_parser data_parser data_serializer data_jumper
val data_reader : LL.leaf_reader data_parser

val data_lserializer: LL.serializer32 data_serializer

val lemma_valid_data_valid_boolean: #rrel: _ -> #rel: _ -> s:LL.slice rrel rel -> pos:U32.t -> h:HyperStack.mem -> Lemma
  (requires LL.valid data_parser h s pos)
  (ensures (LL.valid boolean_parser h s pos /\ LL.contents boolean_parser h s pos == tag_of_data (LL.contents data_parser h s pos)))
  [SMTPat (LL.valid data_parser h s pos)]

noextract let data_clens_tag : LL.clens data boolean = {
  LL.clens_cond = (fun _ -> True);
  LL.clens_get = (fun (x: data) -> tag_of_data x);
}

val data_gaccessor_tag : LL.gaccessor data_parser boolean_parser data_clens_tag

val data_accessor_tag : LL.accessor data_gaccessor_tag

inline_for_extraction noextract let lwp_data_accessor_tag  : LWP.access_t lwp_data lwp_boolean (data_accessor_tag ) = LWP.access _ _ _

val data_bytesize_eqn_TRUE (x: U32.t) : Lemma (data_bytesize (Payloads_TRUE x) == 1 + 4) [SMTPat (data_bytesize (Payloads_TRUE x))]

val data_bytesize_eqn_FALSE (x: U16.t) : Lemma (data_bytesize (Payloads_FALSE x) == 1 + 2) [SMTPat (data_bytesize (Payloads_FALSE x))]

noextract let data_clens_TRUE : LL.clens data U32.t = {
  LL.clens_cond = (fun (x: data) -> tag_of_data x == TRUE);
  LL.clens_get = (fun (x: data) -> (match x with Payloads_TRUE y -> y) <: (Ghost U32.t (requires (tag_of_data x == TRUE)) (ensures (fun y -> True))));
}

val data_gaccessor_TRUE : LL.gaccessor data_parser LPI.parse_u32 data_clens_TRUE

val data_accessor_TRUE : LL.accessor data_gaccessor_TRUE

inline_for_extraction noextract let lwp_data_accessor_TRUE  : LWP.access_t lwp_data LWP.parse_u32 (data_accessor_TRUE ) = LWP.access _ _ _

noextract let data_clens_FALSE : LL.clens data U16.t = {
  LL.clens_cond = (fun (x: data) -> tag_of_data x == FALSE);
  LL.clens_get = (fun (x: data) -> (match x with Payloads_FALSE y -> y) <: (Ghost U16.t (requires (tag_of_data x == FALSE)) (ensures (fun y -> True))));
}

val data_gaccessor_FALSE : LL.gaccessor data_parser LPI.parse_u16 data_clens_FALSE

val data_accessor_FALSE : LL.accessor data_gaccessor_FALSE

inline_for_extraction noextract let lwp_data_accessor_FALSE  : LWP.access_t lwp_data LWP.parse_u16 (data_accessor_FALSE ) = LWP.access _ _ _

val finalize_data_TRUE (#rrel: _) (#rel: _) (input: LL.slice rrel rel) (pos: U32.t) : HST.Stack unit
  (requires (fun h ->
    assert_norm (pow2 32 == 4294967296);
U32.v pos + 1 < 4294967296 /\ LL.valid LPI.parse_u32 h input (pos `U32.add` 1ul) /\ LL.writable input.LL.base (U32.v pos) (U32.v pos + 1) h))
  (ensures (fun h _ h' ->
    assert_norm (pow2 32 == 4294967296);
    let pos_payload = pos `U32.add` 1ul in
    B.modifies (LL.loc_slice_from_to input pos pos_payload) h h' /\
    LL.valid_content_pos data_parser h' input pos (Payloads_TRUE (LL.contents LPI.parse_u32 h input pos_payload)) (LL.get_valid_pos LPI.parse_u32 h input pos_payload)
  ))

val finalize_data_FALSE (#rrel: _) (#rel: _) (input: LL.slice rrel rel) (pos: U32.t) : HST.Stack unit
  (requires (fun h ->
    assert_norm (pow2 32 == 4294967296);
U32.v pos + 1 < 4294967296 /\ LL.valid LPI.parse_u16 h input (pos `U32.add` 1ul) /\ LL.writable input.LL.base (U32.v pos) (U32.v pos + 1) h))
  (ensures (fun h _ h' ->
    assert_norm (pow2 32 == 4294967296);
    let pos_payload = pos `U32.add` 1ul in
    B.modifies (LL.loc_slice_from_to input pos pos_payload) h h' /\
    LL.valid_content_pos data_parser h' input pos (Payloads_FALSE (LL.contents LPI.parse_u16 h input pos_payload)) (LL.get_valid_pos LPI.parse_u16 h input pos_payload)
  ))

