module Boolean

(* This file has been automatically generated by EverParse. *)
open FStar.Bytes
module U8 = FStar.UInt8
module U16 = FStar.UInt16
module U32 = FStar.UInt32
module U64 = FStar.UInt64
module LP = LowParse.Spec
module LS = LowParse.SLow
module LPI = LowParse.Spec.AllIntegers
module LL = LowParse.Low
module LT = LowParse.TacLib
module L = FStar.List.Tot
module B = LowStar.Buffer
module BY = FStar.Bytes
module HS = FStar.HyperStack
module HST = FStar.HyperStack.ST
module LWP = LowParse.Writers.Instances

#reset-options "--using_facts_from '* -FStar.Tactics -FStar.Reflection' --z3rlimit 16 --z3cliopt smt.arith.nl=false --max_fuel 2 --max_ifuel 2"

[@LT.Norm] inline_for_extraction let boolean_enum : LP.enum boolean U8.t =
  [@inline_let] let e = [
    FALSE, 0z;
    TRUE, 1z;
  ] in
  [@inline_let] let _ =
    assert_norm (L.noRepeats (LP.list_map fst e))
  in
  [@inline_let] let _ = 
    assert_norm (L.noRepeats (LP.list_map snd e))
  in e

noextract let boolean_repr_parser = LPI.parse_u8

noextract let boolean_repr_serializer = LPI.serialize_u8

inline_for_extraction noextract let boolean_repr_parser32 = LS.parse32_u8

inline_for_extraction noextract let boolean_repr_serializer32 = LS.serialize32_u8

inline_for_extraction noextract let boolean_repr_size32 = LS.size32_u8

inline_for_extraction noextract let boolean_repr_validator = (LL.validate_u8 ())

inline_for_extraction noextract let boolean_repr_jumper = LL.jump_u8

inline_for_extraction noextract let boolean_repr_reader = LL.read_u8

inline_for_extraction noextract let boolean_repr_writer = LL.write_u8

inline_for_extraction let synth_boolean (x: LP.enum_key boolean_enum) : Tot boolean = x

inline_for_extraction let synth_boolean_inv (x: boolean) : Tot (LP.enum_key boolean_enum) =
  [@inline_let] let _ : squash (LP.list_mem x (LP.list_map fst boolean_enum)) =
    _ by (LP.synth_maybe_enum_key_inv_unknown_tac x)
  in
  x

let lemma_synth_boolean_inj () : Lemma
  (LP.synth_injective synth_boolean) = ()

let lemma_synth_boolean_inv () : Lemma
  (LP.synth_inverse synth_boolean synth_boolean_inv) = ()

noextract let parse_boolean_key : LP.parser _ (LP.enum_key boolean_enum) =
  LP.parse_enum_key boolean_repr_parser boolean_enum

noextract let serialize_boolean_key : LP.serializer parse_boolean_key =
  LP.serialize_enum_key boolean_repr_parser boolean_repr_serializer boolean_enum

noextract let boolean_parser : LP.parser _ boolean =
  lemma_synth_boolean_inj ();
  parse_boolean_key `LP.parse_synth` synth_boolean

noextract let boolean_serializer : LP.serializer boolean_parser =
  lemma_synth_boolean_inj ();
  lemma_synth_boolean_inv ();
  LP.serialize_synth _ synth_boolean serialize_boolean_key synth_boolean_inv ()

let boolean_bytesize (x:boolean) : GTot nat = Seq.length (boolean_serializer x)

let boolean_bytesize_eq x = ()

let parse32_boolean_key : LS.parser32 parse_boolean_key =
  FStar.Tactics.synth_by_tactic (LS.parse32_enum_key_tac boolean_repr_parser32 boolean_enum)

let boolean_parser32 : LS.parser32 boolean_parser =
  lemma_synth_boolean_inj ();
  LS.parse32_synth _ synth_boolean (fun x->synth_boolean x) parse32_boolean_key ()

let serialize32_boolean_key : LS.serializer32 serialize_boolean_key =
  FStar.Tactics.synth_by_tactic (LS.serialize32_enum_key_gen_tac
    boolean_repr_serializer32 boolean_enum)

let boolean_serializer32 : LS.serializer32 boolean_serializer =
  lemma_synth_boolean_inj ();
  lemma_synth_boolean_inv ();
  LS.serialize32_synth _ synth_boolean _ serialize32_boolean_key synth_boolean_inv (fun x->synth_boolean_inv x) ()

let boolean_size32 =
  [@inline_let] let _ = assert_norm (LS.size32_constant_precond boolean_serializer 1ul) in
  LS.size32_constant boolean_serializer 1ul ()

[@@ (LT.postprocess_with LT.pp_norm_tac) ]
inline_for_extraction let validate_boolean_key : LL.validator parse_boolean_key =
    LL.mk_validate_enum_key boolean_repr_validator boolean_repr_reader boolean_enum

  let boolean_validator =
  lemma_synth_boolean_inj ();
  LL.validate_synth validate_boolean_key synth_boolean ()

[@@ (LT.postprocess_with LT.pp_norm_tac) ]
inline_for_extraction let read_boolean_key : LL.leaf_reader parse_boolean_key =
  LL.mk_read_enum_key boolean_repr_reader boolean_enum
 
let boolean_reader =
 [@inline_let] let _ = lemma_synth_boolean_inj () in
 LL.read_synth' parse_boolean_key synth_boolean read_boolean_key ()

inline_for_extraction let write_boolean_key : LL.leaf_writer_strong serialize_boolean_key =
  LL.write_enum_key boolean_repr_writer boolean_enum (_ by (LP.enum_repr_of_key_tac boolean_enum))

inline_for_extraction let lserialize_boolean_key : LL.serializer32 serialize_boolean_key =
  LL.serializer32_of_leaf_writer_strong_constant_size write_boolean_key 1ul ()

let boolean_writer =
  [@inline_let] let _ = lemma_synth_boolean_inj (); lemma_synth_boolean_inv () in
  LL.write_synth write_boolean_key synth_boolean synth_boolean_inv (fun x -> synth_boolean_inv x) ()

let boolean_lserializer = LL.serializer32_of_leaf_writer_strong_constant_size boolean_writer 1ul ()

let boolean_bytesize_eqn x = boolean_bytesize_eq x; assert (FStar.Seq.length (LP.serialize boolean_serializer x) <= 1); assert (1 <= FStar.Seq.length (LP.serialize boolean_serializer x))

