(*
   Copyright 2019 Microsoft Research

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain as copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*)
module TypeSizes
open FStar.All
open Ast
open FStar.Mul
module H = Hashtable
module B = Binding

type size =
  | Fixed of int
  | WithVariableSuffix of int
  | Variable

val size_env : Type0

let env_t = B.env & size_env

val size_of_typename (env:env_t) (i:ident)
  : ML size

val size_of_typ (env:env_t) (t:typ)
  : ML size

val value_of_const_expr (env:env_t) (e:expr)
  : ML (option (either bool (integer_type & int)))

val size_of_decls (env:B.global_env) (d:list decl)
  : ML (env_t & list decl)
