/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/* This file sucks in a bunch of pixmaps as static arrays, then
   creates access lists for use by the gui code */

#include "pixmaps.hpp"

/* all the pixmaps */
#include "card_0_0.xpm"
#include "card_0_1.xpm"
#include "card_0_2.xpm"
#include "card_0_3.xpm"
#include "card_1_0.xpm"
#include "card_1_1.xpm"
#include "card_1_2.xpm"
#include "card_1_3.xpm"
#include "card_2_0.xpm"
#include "card_2_1.xpm"
#include "card_2_2.xpm"
#include "card_2_3.xpm"
#include "card_3_0.xpm"
#include "card_3_1.xpm"
#include "card_3_2.xpm"
#include "card_3_3.xpm"
#include "card_4_0.xpm"
#include "card_4_1.xpm"
#include "card_4_2.xpm"
#include "card_4_3.xpm"
#include "card_5_0.xpm"
#include "card_5_1.xpm"
#include "card_5_2.xpm"
#include "card_5_3.xpm"
#include "cardback1.xpm"
#include "cardback2.xpm"
#include "cardback3.xpm"
#include "suit_0.xpm"
#include "suit_1.xpm"
#include "suit_2.xpm"
#include "suit_3.xpm"
#include "bid_team.xpm"
#include "bid_loner.xpm"
#include "bid_empty.xpm"
#include "marker_pass.xpm"
#include "marker_empty.xpm"

char** card_pixmap_array[(Card::Ace+1)][(Card::Spades+1)] = {
  { card_0_0, card_0_1, card_0_2, card_0_3 },
  { card_1_0, card_1_1, card_1_2, card_1_3 },
  { card_2_0, card_2_1, card_2_2, card_2_3 },
  { card_3_0, card_3_1, card_3_2, card_3_3 },
  { card_4_0, card_4_1, card_4_2, card_4_3 },
  { card_5_0, card_5_1, card_5_2, card_5_3 }
};

char** suit_pixmap[(Card::Spades+1)] = {
  suit_0, suit_1, suit_2, suit_3
};

char** bid_pixmap[2] = {
  bid_team, bid_loner
};

char** bid_empty_pixmap = bid_empty;

char** card_back_pixmap[(NUM_CARD_BACKS)] = {
  cardback1_xpm, cardback2_xpm, cardback3_xpm
};

char** pass_marker_pixmap  = marker_pass_xpm;
char** empty_marker_pixmap = marker_empty_xpm;
