/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "Debug.hpp"
#include "HumanPlayer.hpp"

HumanPlayer::HumanPlayer(Common::PlayerPosition myPos) :
  Player(myPos) {}

HumanPlayer::~HumanPlayer() {}

int HumanPlayer::isInteractive() const {
  return 1;
}

Common::Bid HumanPlayer::auction1(const Card& upCard,
				  Common::PlayerPosition dealer) {

  Common::Bid ret = Common::NOBID;
  char choice;

  while (ret == Common::NOBID) {
    LOG("%c->\t %d has the deal up card is %s\n\t your hand %s\n\tDo you wish to (P)ass, p(I)ch it up, or go (L)oner? ", 
	Common::getPlayerPositionStr(itsPos), Common::getPlayerPositionStr(dealer), upCard.getName(), itsHand.getName());
    
    scanf("%c", &choice);

    switch (choice) {
    case 'p':
    case 'P':
      ret = Common::PASS;
      break;

    case 'i':
    case 'I':
      ret = Common::PICKITUP;
      break;

    case 'L':
    case 'l':
      ret = Common::LONER;
      break;

    default:
      LOG("HUH?!?\n");
    }
  }

  itsBid = ret;
  return ret;
}

Common::Bid HumanPlayer::auction2(Card& yourTrump,
				  const Card& upCard,
				  bool stuck) {
  Common::Bid ret = Common::NOBID;
  char choice;

  while (ret == Common::NOBID) {
    LOG("%c->name your own trump\n\t your hand %s \n\t (D)iamonds, (C)lubs, (H)earts, (S)pades, or (P)ass:  ",
	Common::getPlayerPositionStr(itsPos), itsHand.getName());

    scanf("%c", &choice);

    switch (choice) {
    case 'D':
    case 'd':
      ret = Common::PICKITUP;
      yourTrump.setSuit(Card::Diamonds);
      break;

    case 'C':
    case 'c':
      ret = Common::PICKITUP;
      yourTrump.setSuit(Card::Clubs);
      break;

    case 'H':
    case 'h':
      ret = Common::PICKITUP;
      yourTrump.setSuit(Card::Hearts);
      break;

    case 'S':
    case 's':
      ret = Common::PICKITUP;
      yourTrump.setSuit(Card::Spades);
      break;
    
    case 'P':
    case 'p':
      ret = Common::PASS;
      break;

    default:
      LOG("HUH?!?\n");
    }

    if (ret != Common::NOBID) {
      if (yourTrump.getSuit() == upCard.getSuit()) {
	LOG("You cannot choose %s\n", upCard.getSuitChar());
	ret = Common::NOBID;
      }
    }
  }

  if (ret == Common::PICKITUP) {
    LOG("Do you want to go loner (y or n)?  ");
    scanf("%c", &choice);

    if (choice == 'Y' || choice == 'y') {
      ret = Common::LONER;
    }
  }

  itsBid = ret;

  return ret;
}

Card HumanPlayer::discard(Card& newCard) {
  int  choice = -1;

  while (choice == -1) {
    LOG("%c->  Choose a card to discard: \n", Common::getPlayerPositionStr(itsPos));
    for (int i = 0; i < Common::CARDS_PER_HAND; i++) {
      LOG("%d) %s\n",  itsHand.getCard(i).getName());
    }

    scanf("%c", &choice);

    if (choice < 0 || choice >= Common::CARDS_PER_HAND) {
      LOG("HUH!?!\n");
      choice = -1;
    }
  }

  Card ret = itsHand.getCard(choice);
  itsHand.setCard(choice, newCard);

  return ret;
}

Card HumanPlayer::getCard(const Round& theRound, 
			  Common::PlayerPosition whoStarted) {

  Card::Suit ledSuit = theRound.getCard(whoStarted).getSuit();

  LOG("%c->\t Your hand is:\n", Common::getPlayerPositionStr(itsPos));

  for (int i = 0; i < Common::CARDS_PER_HAND; i++) {
    LOG("%d   ", i);
  }

  LOG("\n");

  for (int i = 0; i < Common::CARDS_PER_HAND; i++) {
    LOG("%s  ", itsHand.getCard(i).getName());
  }

  LOG("\n");

  int choice = -1;
  while (choice == -1) {
    LOG("Choose a card by number:  ");

    scanf("%d", &choice);

    if (choice < 0 || choice >= Common::CARDS_PER_HAND) {
      LOG("HUH?!?\n");
      choice = -1;
    } else if (itsHand.getCard(choice).getSuit() == Card::NoSuit) {
      LOG("HUH?!?\n");
      choice = -1;
    }

    /* validate user is following suit */

    if (itsHand.contains(ledSuit)) {
      if (! itsHand.getCard(choice).isSuit(ledSuit)) {
	LOG("You must follow suit\n");
	choice = -1;
      }
    }
  }

  return itsHand.removeCard(choice);
}
